/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import webetk.app.Markt;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EinstellungenBasis
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    protected boolean mbVerbaumenge;
    protected String msMarke;
    protected String msProdukart;
    protected String msKatalogUmfang;
    protected String msLenkung;
    protected String msLanguage;
    protected String msLangRegion;
    protected boolean mbBnKomprimiert;
    protected boolean mbSuchwegVerkuerzen;
    protected boolean mbNachruestungenRelevant;
    protected String msTabellenanzeige = "";
    protected String msSchriftgroesse = "";
    protected String msSuchraum = "";
    protected boolean mbIsLoaded;
    protected boolean mbEinstellungenGesetzt;
    protected Boolean mbAlwaysDisplayProduktDate;
    protected Boolean mbDisplayPreise;
    protected Vector<String> mcRegionen;
    protected boolean mbDisplayTippsTricks;
    protected Markt mIPACMarkt;
    protected Markt mEtkPrimaerMarkt;
    protected Collection<Markt> mEtkSonstigeMaerkte;
    protected Boolean vinBlockRequired;

    public EinstellungenBasis() {
        this.mbEinstellungenGesetzt = false;
        this.mbVerbaumenge = false;
        this.msMarke = "";
        this.msProdukart = "";
        this.msKatalogUmfang = "";
        this.msLenkung = "";
        this.msLanguage = null;
        this.msLangRegion = null;
        this.mbAlwaysDisplayProduktDate = null;
        this.mbDisplayPreise = null;
        this.mbDisplayTippsTricks = true;
        this.mbSuchwegVerkuerzen = true;
        this.mbNachruestungenRelevant = true;
        this.mbBnKomprimiert = false;
        this.mbIsLoaded = false;
        this.msTabellenanzeige = "";
        this.msSchriftgroesse = "";
        this.msSuchraum = "";
        this.mcRegionen = new Vector();
        this.mIPACMarkt = null;
        this.vinBlockRequired = null;
    }

    public EinstellungenBasis(EinstellungenBasis oEinstellungen) {
        Iterator<Object> iterator;
        this.msMarke = oEinstellungen.getMarke();
        this.msProdukart = oEinstellungen.getProduktart();
        this.msKatalogUmfang = oEinstellungen.getKatalogumfang();
        this.msLenkung = oEinstellungen.getLenkung();
        this.msLanguage = oEinstellungen.getSprache();
        this.msLangRegion = oEinstellungen.getSpracheRegion();
        this.mbAlwaysDisplayProduktDate = oEinstellungen.getAlwaysDisplayProduktDate();
        this.mbDisplayPreise = oEinstellungen.getDisplayPreise();
        this.mbDisplayTippsTricks = oEinstellungen.displayTippsTricks();
        this.mbSuchwegVerkuerzen = oEinstellungen.getSuchwegVerkuerzen();
        this.mbNachruestungenRelevant = oEinstellungen.getNachruestungenRelevant();
        this.mbBnKomprimiert = oEinstellungen.getDarstellungBN();
        this.mbIsLoaded = oEinstellungen.isLoaded();
        this.msTabellenanzeige = oEinstellungen.getTabellenanzeige();
        this.msSchriftgroesse = oEinstellungen.getSchriftgroesse();
        this.msSuchraum = oEinstellungen.getSuchraum();
        this.mbEinstellungenGesetzt = true;
        this.mIPACMarkt = oEinstellungen.getIPACMarkt();
        this.mEtkPrimaerMarkt = oEinstellungen.getEtkPrimaerMarkt();
        this.mbVerbaumenge = oEinstellungen.getVerbaumenge();
        if (oEinstellungen.getRegionen() != null) {
            this.mcRegionen = new Vector();
            iterator = oEinstellungen.getRegionen().iterator();
            while (iterator.hasNext()) {
                this.mcRegionen.add(iterator.next());
            }
        } else {
            this.mcRegionen = null;
        }
        if (oEinstellungen.getEtkSonstigeMaerkte() != null) {
            this.mEtkSonstigeMaerkte = new ArrayList<Markt>();
            iterator = oEinstellungen.getEtkSonstigeMaerkte().iterator();
            while (iterator.hasNext()) {
                this.mEtkSonstigeMaerkte.add((Markt)iterator.next());
            }
        } else {
            this.mEtkSonstigeMaerkte = null;
        }
    }

    public boolean getVerbaumenge() {
        return this.mbVerbaumenge;
    }

    public void setVerbaumenge(boolean mbVerbaumenge) {
        this.mbVerbaumenge = mbVerbaumenge;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("[Marke (").append(this.msMarke).append("), ");
        buf.append("PArt (").append(this.msProdukart).append("), ");
        buf.append("KatUmfang (").append(this.msKatalogUmfang).append("), ");
        buf.append("Lenkung (").append(this.msLenkung).append("), ");
        buf.append("Sprache (").append(this.msLanguage).append("), ");
        if (this.msLangRegion != null) {
            buf.append("Country (").append(this.msLangRegion).append("), ");
        }
        buf.append("Bed (").append(this.mbSuchwegVerkuerzen ? "yes" : "no").append("), ");
        buf.append("Bnb (").append(this.mbBnKomprimiert ? "comp" : "uncomp").append("), ");
        buf.append("Nachruestungen (").append(this.mbNachruestungenRelevant ? "yes" : "no").append("), ");
        buf.append("Tabellenanzeige (").append(this.msTabellenanzeige).append("), ");
        buf.append("Schriftgroesse (").append(this.msSchriftgroesse).append("), ");
        buf.append("Suchraum (").append(this.msSuchraum).append("), ");
        buf.append("TippsTricks (").append(this.mbDisplayTippsTricks ? "yes" : "no").append("), ");
        buf.append("Verbaumenge (").append(this.mbVerbaumenge ? "yes" : "no").append("), ");
        buf.append("Regionen (").append(this.mcRegionen.size()).append(")");
        buf.append("MarktId (").append(this.getMarktId()).append(" )]");
        buf.append("MarktKuerzel (").append(this.getMarktKuerzel()).append(" )]");
        return buf.toString();
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public void setProduktart(String sPArt) {
        this.msProdukart = sPArt;
    }

    public String getProduktart() {
        return this.msProdukart;
    }

    public void setKatalogumfang(String sKatUmfang) {
        this.msKatalogUmfang = sKatUmfang;
    }

    public String getKatalogumfang() {
        return this.msKatalogUmfang;
    }

    public void setLenkung(String sLenkung) {
        this.msLenkung = sLenkung;
    }

    public String getLenkung() {
        return this.msLenkung;
    }

    public void setSprache(String sSprache) {
        this.msLanguage = sSprache;
    }

    public String getSprache() {
        return this.msLanguage;
    }

    public void setSpracheRegion(String sLand) {
        this.msLangRegion = sLand;
    }

    public String getSpracheRegion() {
        return this.msLangRegion;
    }

    public void setDarstellungBN(boolean bDarstellungBN) {
        this.mbBnKomprimiert = bDarstellungBN;
    }

    public boolean getDarstellungBN() {
        return this.mbBnKomprimiert;
    }

    public void setSuchwegVerkuerzen(boolean bSuchwegVerk) {
        this.mbSuchwegVerkuerzen = bSuchwegVerk;
    }

    public boolean getSuchwegVerkuerzen() {
        return this.mbSuchwegVerkuerzen;
    }

    public Vector<String> getRegionen() {
        return this.mcRegionen;
    }

    public void addRegion(String sRegion) {
        if (this.mcRegionen.contains(sRegion)) {
            return;
        }
        this.mcRegionen.add(sRegion);
    }

    public boolean getEinstellungenGesetzt() {
        return this.mbEinstellungenGesetzt;
    }

    public Boolean getAlwaysDisplayProduktDate() {
        return this.mbAlwaysDisplayProduktDate;
    }

    public void setAlwaysDisplayProduktDate(Boolean bShowProdDate) {
        this.mbAlwaysDisplayProduktDate = bShowProdDate;
    }

    public void setTabellenanzeige(String sTabellenanzeige) {
        this.msTabellenanzeige = sTabellenanzeige;
    }

    public String getTabellenanzeige() {
        return this.msTabellenanzeige;
    }

    public void setSchriftgroesse(String sSchriftgroesse) {
        this.msSchriftgroesse = sSchriftgroesse;
    }

    public String getSchriftgroesse() {
        return this.msSchriftgroesse;
    }

    public void setSuchraum(String sSuchraum) {
        this.msSuchraum = sSuchraum;
    }

    public String getSuchraum() {
        return this.msSuchraum;
    }

    public boolean isLoaded() {
        return this.mbIsLoaded;
    }

    public void markUnloaded() {
        this.mbIsLoaded = false;
    }

    public void markLoaded() {
        this.mbIsLoaded = true;
        this.mbEinstellungenGesetzt = true;
    }

    public Boolean getDisplayPreise() {
        return this.mbDisplayPreise;
    }

    public void setDisplayPreise(Boolean bDisplayPreise) {
        this.mbDisplayPreise = bDisplayPreise;
    }

    public boolean displayTippsTricks() {
        return this.mbDisplayTippsTricks;
    }

    public void displayTrippsTricks(boolean bDisplayTippsTricks) {
        this.mbDisplayTippsTricks = bDisplayTippsTricks;
    }

    public void setIPACMarkt(Markt ipacMarkt) {
        this.mIPACMarkt = ipacMarkt;
    }

    public Markt getIPACMarkt() {
        return this.mIPACMarkt;
    }

    public int getMarktId() {
        if (this.mIPACMarkt == null) {
            return 0;
        }
        return this.mIPACMarkt.getMarktId();
    }

    public String getMarktKuerzel() {
        if (this.mIPACMarkt == null) {
            return "";
        }
        return this.mIPACMarkt.getKuerzel();
    }

    public boolean getNachruestungenRelevant() {
        return this.mbNachruestungenRelevant;
    }

    public void setNachruestungenRelevant(boolean mbNachruestRel) {
        this.mbNachruestungenRelevant = mbNachruestRel;
    }

    public Markt getEtkPrimaerMarkt() {
        return this.mEtkPrimaerMarkt;
    }

    public void setEtkPrimaerMarkt(Markt etkPrimaerMarkt) {
        this.mEtkPrimaerMarkt = etkPrimaerMarkt;
    }

    public Collection<Markt> getEtkSonstigeMaerkte() {
        return this.mEtkSonstigeMaerkte;
    }

    public Collection<String> getEtkSonstigeMaerkteIds() {
        if (this.mEtkSonstigeMaerkte == null) {
            return null;
        }
        ArrayList<String> maerkte = new ArrayList<String>();
        for (Markt markt : this.mEtkSonstigeMaerkte) {
            int id = markt.getMarktId();
            maerkte.add(Integer.toString(id));
        }
        return maerkte;
    }

    public void setEtkSonstigeMaerkte(Collection<Markt> etkSonstigeMaerkte) {
        this.mEtkSonstigeMaerkte = etkSonstigeMaerkte;
    }

    public Boolean getVinBlockRequired() {
        return this.vinBlockRequired;
    }

    public void setVinBlockRequired(Boolean vinBlockRequired) {
        this.vinBlockRequired = vinBlockRequired;
    }
}

