/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileinfo;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.TeileInfoDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="webetk.app.teileinfo.Notiz")
public class Notiz
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Notiz.class);
    private String msNotiz;
    private Collection<String> mcNotizenOthers = new Vector<String>();
    private Collection<String> mcNotizenOthersGueltigBis = new Vector<String>();
    private int mnBisJahr;
    private int mnBisMonat;
    private String msGueltigBis = "";
    private String msSachnummer;
    private String msHG;
    private String msUG;
    private boolean mbAllgemein;
    private String msSprache;

    public Notiz() {
        this.msSprache = null;
    }

    public Notiz(String sSprache) {
        this.msSprache = sSprache;
    }

    public void setSachnummer(String sSachnummer) {
        this.msSachnummer = sSachnummer;
    }

    public void setNotiz(String sNotiz) {
        this.msNotiz = sNotiz;
    }

    public void setBisJahr(int Jahr) {
        this.mnBisJahr = Jahr;
    }

    public void setBisMonat(int Monat) {
        this.mnBisMonat = Monat;
    }

    public String getSachnummer() {
        return this.msSachnummer;
    }

    public void setHG(String sHG) {
        this.msHG = sHG;
    }

    public void setUG(String sUG) {
        this.msUG = sUG;
    }

    public void setAllgemein(boolean bAllgemein) {
        this.mbAllgemein = bAllgemein;
    }

    public boolean getAllgemein() {
        return this.mbAllgemein;
    }

    public String getTeilenummer() {
        return this.msHG + " " + this.msUG + " " + WebetkUtils.formatiereSachnummer(this.msSachnummer);
    }

    public String getNotiz() {
        if (this.msNotiz != null) {
            return this.msNotiz;
        }
        return "";
    }

    public Collection<String> getNotizenOthers() {
        return this.mcNotizenOthers;
    }

    public Collection<String> getNotizenOthersGueltigBis() {
        return this.mcNotizenOthersGueltigBis;
    }

    public int getBisJahr() {
        return this.mnBisJahr;
    }

    public int getBisMonat() {
        return this.mnBisMonat;
    }

    public String getGueltigBis() {
        return this.msGueltigBis;
    }

    public void load(String sNutzer, String sSachnummer) throws SQLException, DatabaseBusyException {
        this.load(sNutzer, null, sSachnummer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String sNutzer, String sFirma, String sSachnummer) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block7: {
            this.msSachnummer = sSachnummer;
            gObj = ServerGlobalObjects.getInstance();
            log.info("Loading Notiz for part with No: " + sSachnummer + "User: " + sNutzer);
            con = null;
            res = null;
            try {
                con = gObj.getDBConnection("Notiz.load");
                res = TeileInfoDbAccess.loadNotiz(con, sNutzer, sFirma, this.msSprache, sSachnummer);
                if (res != null && res.next()) {
                    this.msNotiz = res.getString("Notiz");
                    this.mnBisJahr = (int)res.getLong("BisJahr");
                    this.mnBisMonat = (int)res.getLong("BisMonat");
                    if (sFirma != null) {
                        String sMonat = res.getString("MONATBEN");
                        this.msGueltigBis = sMonat + " " + Integer.toString(this.mnBisJahr);
                        String sAllgemein = res.getString("Allgemein");
                        this.mbAllgemein = sAllgemein.equals("J");
                    }
                }
                WebetkUtils.closeQuery(res);
                if (sFirma == null) break block7;
                try {
                    res = TeileInfoDbAccess.loadNotizenOthers(con, sNutzer, sFirma, sSachnummer, this.msSprache);
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                while (res != null && res.next()) {
                    String sNotiz = res.getString("Notiz");
                    this.mcNotizenOthers.add(sNotiz);
                    int nJahr = (int)res.getLong("BisJahr");
                    String sMonat = res.getString("Monat");
                    String sGueltigBis = sMonat + " " + Integer.toString(nJahr);
                    this.mcNotizenOthersGueltigBis.add(sGueltigBis);
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "Notiz.load");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Notiz.load");
    }

    public void save(String sNutzer) throws SQLException, DatabaseBusyException {
        this.save(sNutzer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String sNutzer, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Storing Notiz for user with ID: " + sNutzer + " Part No:" + this.msSachnummer);
        Connection con = null;
        try {
            con = gObj.getDBConnection("Notiz.save");
            TeileInfoDbAccess.saveNotiz(con, sNutzer, sFirma, this.msSachnummer, this.msNotiz, this.mbAllgemein, this.mnBisJahr, this.mnBisMonat);
        }
        finally {
            gObj.freeDBConnection(con, "Notiz.save");
        }
    }

    public void delete(String sNutzer) throws SQLException, DatabaseBusyException {
        this.delete(sNutzer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String sNutzer, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Deleting Notiz for user with ID: " + sNutzer + " Part No:" + this.msSachnummer);
        Connection con = null;
        try {
            con = gObj.getDBConnection("Notiz.delete");
            TeileInfoDbAccess.deleteNotiz(con, sNutzer, sFirma, this.msSachnummer);
        }
        finally {
            gObj.freeDBConnection(con, "Notiz.delete");
        }
    }
}

