/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileinfo;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.ValueAndNameSupport;
import webetk.app.teileinfo.Notiz;
import webetk.app.teileinfo.ReachInfo;
import webetk.app.teileinfo.ServiceInfoTable;
import webetk.app.teileinfo.Serviceinfo;
import webetk.app.teileinfo.Teileclearing;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teileliste;
import webetk.db.dbaccess.AllgemeinDbAccess;
import webetk.db.dbaccess.InterpretationDbAccess;
import webetk.db.dbaccess.SatzEinzelteileDbAccess;
import webetk.db.dbaccess.TeileInfoDbAccess;
import webetk.framework.ServerSessionInfo;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Teileinfo
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Teileinfo.class);
    protected String msSachnummer;
    private HashMap<String, String> reachRelaventInformation = new HashMap();
    List<ReachInfo> reachInfoList = new ArrayList<ReachInfo>();
    protected String msDiebstahlrelevant;
    protected Collection<SearchBTETeile.PartOrBTE> maSachnummern = new Vector<SearchBTETeile.PartOrBTE>();
    protected String msHg;
    protected String msUg;
    protected Vector<String> maMarken = new Vector();
    protected String msProduktart;
    protected String msBenennung;
    protected String msBenennungskommentar;
    protected String msZusatz;
    protected String msAustausch;
    protected String msNeuteil;
    protected String msTeilenrAlt;
    protected String msAustauschbar;
    protected String msAustauschbarBen;
    protected String msHinweis;
    protected String msProduktklasse;
    protected String msTeileart;
    protected String msTST;
    protected String msTSD;
    protected String msLokalTeilKZ;
    protected String msMengenEinheit;
    protected String msMengenEinheitBen;
    protected String msRundungsKZ;
    protected Float mfGewicht;
    protected Integer mnVVM;
    protected Integer mnLVM;
    protected Integer mnBVM;
    protected String msRecylingKz;
    protected String msZusatzinfo;
    protected String msReachinfo;
    protected String msNormNr;
    protected String msLanguage;
    protected Notiz moNotiz;
    private boolean mbIsReifen;
    protected Collection<ServiceInfoTable> mcServiceinfoLinks;
    protected Collection<ServiceInfoTable> mcServiceinfoRechts;
    protected Collection<Teileclearing> mcTeileclearing = new Vector<Teileclearing>();
    protected Collection<ValueAndNameSupport> mcMonate = new Vector<ValueAndNameSupport>();
    protected Collection<ComboTeilelisteItem> mcTeilelisten = new Vector<ComboTeilelisteItem>();
    protected boolean mbHatInterpretation;
    protected boolean mbHatEinzelteile;
    protected boolean mbVerbaubar;
    protected String sKraftstoffeffizienzKlasse;
    protected String sNasshaftungsKlasse;
    protected int rollgeraeuschKlasse;
    protected int geraeuschMesswert;

    public Teileinfo() {
    }

    public Teileinfo(String sHgUg, String sSachnummer, String sBenennung, String sMarke) {
        this.msHg = null;
        this.msUg = null;
        if (sHgUg != null) {
            if (sHgUg.length() > 2) {
                this.msHg = sHgUg.substring(0, 2);
                this.msUg = sHgUg.substring(2);
            } else {
                this.msHg = sHgUg;
            }
        }
        this.msSachnummer = sSachnummer.toUpperCase();
        this.msBenennung = sBenennung;
        this.appendMarke(sMarke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Teileinfo(String sCompoundLang) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("Lade Monate");
        Connection con = null;
        try {
            con = gObj.getDBConnection("Teileinfo.Teileinfo");
            String sArt = "M";
            this.msLanguage = sCompoundLang;
            String sLang = LanguageUtils.toLanguage(sCompoundLang);
            String sCountry = LanguageUtils.toRegion(sCompoundLang, true);
            this.mcMonate = new Vector<ValueAndNameSupport>();
            Collection<ValueAndNameSupport> cMonate = AllgemeinDbAccess.selectWertebereich(con, sArt, sLang, sCountry);
            for (ValueAndNameSupport van : cMonate) {
                this.mcMonate.add(van);
            }
        }
        finally {
            gObj.freeDBConnection(con, "Teileinfo.Teileinfo");
        }
    }

    public Vector<String> getMarken() {
        return this.maMarken;
    }

    public String getMarkenKommaSep() {
        if (this.maMarken == null || this.maMarken.size() == 0) {
            return "";
        }
        String sMarken = "";
        Iterator<String> iter = this.maMarken.iterator();
        boolean bFirst = true;
        while (iter.hasNext()) {
            if (!bFirst) {
                sMarken = sMarken + ",";
            }
            sMarken = sMarken + iter.next();
            bFirst = false;
        }
        return sMarken;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public String getTeilenummer() {
        StringBuffer sTeilenummer = new StringBuffer("");
        if (this.msHg != null) {
            sTeilenummer.append(this.msHg);
        }
        if (this.msUg != null) {
            sTeilenummer.append(this.msUg);
        }
        if (this.msSachnummer != null) {
            sTeilenummer.append(this.msSachnummer);
        }
        return sTeilenummer.toString();
    }

    public String getTeilenummerGespreizt() {
        StringBuffer sTeilenummer = new StringBuffer("");
        if (this.msHg != null) {
            sTeilenummer.append(this.msHg);
            sTeilenummer.append(" ");
        }
        if (this.msUg != null) {
            sTeilenummer.append(this.msUg);
            sTeilenummer.append(" ");
        }
        sTeilenummer.append(this.getSachnummerGespreizt());
        return sTeilenummer.toString();
    }

    public String getHg() {
        if (this.msHg != null) {
            return this.msHg;
        }
        return "";
    }

    public String getUg() {
        if (this.msUg != null) {
            return this.msUg;
        }
        return "";
    }

    public String getSachnummer() {
        if (this.msSachnummer != null) {
            return this.msSachnummer;
        }
        return "";
    }

    public boolean isDiebstahlrelevant() {
        if (this.msDiebstahlrelevant == null) {
            return false;
        }
        return this.msDiebstahlrelevant.equals("J");
    }

    public String getSachnummerGespreizt() {
        if (this.msSachnummer != null) {
            if (this.msSachnummer.length() == 7) {
                return WebetkUtils.formatiereSachnummer(this.msSachnummer);
            }
            return this.msSachnummer;
        }
        return "";
    }

    public String getBenennung() {
        if (this.msBenennung != null) {
            return this.msBenennung;
        }
        return "";
    }

    public String getBenennungskommentar() {
        if (this.msBenennungskommentar != null) {
            return this.msBenennungskommentar;
        }
        return "";
    }

    public String getZusatz() {
        if (this.msZusatz != null) {
            return this.msZusatz;
        }
        return "";
    }

    public String getAustausch() {
        if (this.msAustausch != null) {
            return this.msAustausch;
        }
        return "";
    }

    public String getNeuteil() {
        if (this.msNeuteil != null) {
            return this.msNeuteil;
        }
        return "";
    }

    public String getTeilenrAlt() {
        if (this.msTeilenrAlt != null) {
            return this.msTeilenrAlt;
        }
        return "";
    }

    public String getAustauschbar() {
        if (this.msAustauschbar != null) {
            return this.msAustauschbar;
        }
        return "";
    }

    public String getAustauschbarBen() {
        if (this.msAustauschbarBen != null) {
            return this.msAustauschbarBen;
        }
        return "";
    }

    public String getHinweis() {
        if (this.msHinweis != null) {
            return this.msHinweis;
        }
        return "";
    }

    public String getProduktklasse() {
        if (this.msProduktklasse != null) {
            return this.msProduktklasse;
        }
        return "";
    }

    public String getTeileart() {
        if (this.msTeileart != null) {
            return this.msTeileart;
        }
        return "";
    }

    public String getTST() {
        if (this.msTST != null) {
            return this.msTST;
        }
        return "";
    }

    public String getTSD() {
        if (this.msTSD != null) {
            return this.msTSD;
        }
        return "";
    }

    public String getLokalTeilKZ() {
        if (this.msLokalTeilKZ != null) {
            return this.msLokalTeilKZ;
        }
        return "";
    }

    public String getNormNr() {
        if (this.msNormNr != null) {
            return this.msNormNr;
        }
        return "";
    }

    public String getMengenEinheit() {
        if (this.msMengenEinheit != null) {
            return this.msMengenEinheit;
        }
        return "";
    }

    public String getMengenEinheitBen() {
        if (this.msMengenEinheitBen != null) {
            return this.msMengenEinheitBen;
        }
        return "";
    }

    public String getRundungsKZ() {
        if (this.msRundungsKZ != null) {
            return this.msRundungsKZ;
        }
        return "";
    }

    public String getGewicht() {
        if (this.mfGewicht != null) {
            return this.mfGewicht.toString();
        }
        return "";
    }

    public String getVVM() {
        if (this.mnVVM != null) {
            return this.mnVVM.toString();
        }
        return "";
    }

    public int getVVMInt() {
        if (this.mnVVM != null) {
            return this.mnVVM;
        }
        return 0;
    }

    public String getLVM() {
        if (this.mnLVM != null) {
            return this.mnLVM.toString();
        }
        return "";
    }

    public int getLVMInt() {
        if (this.mnLVM != null) {
            return this.mnLVM;
        }
        return 0;
    }

    public String getBVM() {
        if (this.mnBVM != null) {
            return this.mnBVM.toString();
        }
        return "";
    }

    public int getBVMInt() {
        if (this.mnBVM != null) {
            return this.mnBVM;
        }
        return 0;
    }

    public String getRecylingKz() {
        if (this.msRecylingKz != null) {
            return this.msRecylingKz;
        }
        return "";
    }

    public String getZusatzinfo() {
        if (this.msZusatzinfo != null) {
            return this.msZusatzinfo;
        }
        return "";
    }

    public Collection<ServiceInfoTable> getServiceInfoLinks() {
        return this.mcServiceinfoLinks;
    }

    public Collection<ServiceInfoTable> getServiceInfoRechts() {
        return this.mcServiceinfoRechts;
    }

    public Collection<Teileclearing> getTeileclearingInfo() {
        return this.mcTeileclearing;
    }

    public Collection<Hashtable<String, String>> getTeileclearingInfoWebETK() {
        Vector<Hashtable<String, String>> cTeileclearing = new Vector<Hashtable<String, String>>();
        for (Teileclearing oTC : this.mcTeileclearing) {
            String sBaureihenMotor2 = oTC.getBaureihenMotor();
            Vector<String> cBaureihenMotoren = new Vector<String>();
            while (sBaureihenMotor2.length() > 47) {
                cBaureihenMotoren.add(sBaureihenMotor2.substring(0, 48));
                sBaureihenMotor2 = sBaureihenMotor2.substring(48);
            }
            if (sBaureihenMotor2.length() > 0) {
                cBaureihenMotoren.add(sBaureihenMotor2);
            }
            boolean bFirst = true;
            for (String sBaureihenMotor2 : cBaureihenMotoren) {
                Hashtable<String, String> oTCHashtable = new Hashtable<String, String>();
                if (bFirst) {
                    oTCHashtable.put("Land", oTC.getLand());
                    oTCHashtable.put("BaureihenMotor", sBaureihenMotor2);
                    if (oTC.getDatumVon() == null) {
                        oTCHashtable.put("istFortlaufend", "J");
                    }
                    if (oTC.getDatumVon() != null) {
                        oTCHashtable.put("DatumVon", oTC.getDatumVon());
                        oTCHashtable.put("hatDatumVon", "J");
                    }
                    if (oTC.getDatumBis() != null) {
                        oTCHashtable.put("DatumBis", oTC.getDatumBis());
                        oTCHashtable.put("hatDatumBis", "J");
                    }
                } else {
                    oTCHashtable.put("Land", "");
                    oTCHashtable.put("BaureihenMotor", sBaureihenMotor2);
                }
                cTeileclearing.add(oTCHashtable);
                bFirst = false;
            }
        }
        return cTeileclearing;
    }

    public String getNotizText() {
        if (this.moNotiz == null) {
            return "";
        }
        return this.moNotiz.getNotiz();
    }

    public Collection<String> getNotizTexteOthers() {
        if (this.moNotiz == null) {
            return null;
        }
        return this.moNotiz.getNotizenOthers();
    }

    public Collection<String> getNotizTexteOthersGueltigBis() {
        if (this.moNotiz == null) {
            return null;
        }
        return this.moNotiz.getNotizenOthersGueltigBis();
    }

    public void setNotiz(Notiz oNotiz) {
        this.moNotiz = oNotiz;
    }

    public String getNotizBisMonatAlsString() {
        if (this.moNotiz == null) {
            return "0";
        }
        String sMonat = String.valueOf(this.moNotiz.getBisMonat());
        if (sMonat.length() < 2) {
            return "0" + sMonat;
        }
        return sMonat;
    }

    public String getNotizBisJahrAlsString() {
        if (this.moNotiz == null) {
            return "0";
        }
        String sJahr = String.valueOf(this.moNotiz.getBisJahr());
        return sJahr;
    }

    public boolean getNotizAllgemein() {
        if (this.moNotiz == null) {
            return false;
        }
        return this.moNotiz.getAllgemein();
    }

    public Collection<ValueAndNameSupport> getMonate() {
        return this.mcMonate;
    }

    public Collection<ComboTeilelisteItem> getTeilelisten() {
        return this.mcTeilelisten;
    }

    public void setTeilelisten(Collection<ComboTeilelisteItem> teilelisten) {
        this.mcTeilelisten = teilelisten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String sHgUg, String sSachnummer, String sFremdeTNr, String sNutzer, String sFirma, String sFiliale, String sSprache, Collection<String> aMarken, ServerSessionInfo objSessionInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        String isReach;
        long lKomId;
        ResultSet resMengenEinheitBen;
        ResultSet resAustausBen;
        ResultSet resReach;
        ResultSet resKom;
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block40: {
            block38: {
                block39: {
                    gObj = ServerGlobalObjects.getInstance();
                    log.info("Loading Teileinfo for part with No: " + sHgUg + sSachnummer + sFremdeTNr + " Language: " + sSprache);
                    con = null;
                    res = null;
                    resKom = null;
                    resReach = null;
                    resAustausBen = null;
                    resMengenEinheitBen = null;
                    con = gObj.getDBConnection("Teileinfo.load");
                    con.setReadOnly(true);
                    if (!StringUtils.isEmpty(sSachnummer, true) && sSachnummer.length() == 7) break block38;
                    if (StringUtils.isEmpty(sFremdeTNr, true)) break block39;
                    log.debug(" Suche \u00fcber fremde Teilenummer ");
                    Vector<String> aSachnummern = AllgemeinDbAccess.retrieveBMWSachnummern(con, sFremdeTNr);
                    if (aSachnummern == null || aSachnummern.size() < 1) {
                        sSachnummer = null;
                        break block39;
                    }
                    if (aSachnummern.size() == 1) {
                        sSachnummer = aSachnummern.get(0);
                        break block39;
                    }
                    this.maSachnummern = new Vector<SearchBTETeile.PartOrBTE>();
                    res = TeileInfoDbAccess.loadTeilenummernErgebnisliste(con, aSachnummern, sSprache);
                    String prevSachnummer = null;
                    while (res != null && res.next()) {
                        SearchBTETeile.PartOrBTE part = SearchBTETeile.readResultIntoPart(res);
                        String sMarke = res.getString("Marke");
                        part.addMarke(sMarke);
                        if (part.getIdNummer().equals(prevSachnummer)) continue;
                        prevSachnummer = part.getIdNummer();
                        this.maSachnummern.add(part);
                    }
                    boolean bl = true;
                    WebetkUtils.closeQuery(resAustausBen);
                    WebetkUtils.closeQuery(resMengenEinheitBen);
                    WebetkUtils.closeQuery(resKom);
                    WebetkUtils.closeQuery(res);
                    WebetkUtils.closeQuery(resReach);
                    if (con != null) {
                        con.setReadOnly(false);
                        gObj.freeDBConnection(con, "Teileinfo.load");
                    }
                    return bl;
                }
                if (!StringUtils.isEmpty(sSachnummer, true) && !StringUtils.isEmpty(sFremdeTNr, true)) break block38;
                log.warn("Keine Sachnummer oder fremde Teilenummer \u00fcbergeben!");
                boolean aSachnummern = false;
                WebetkUtils.closeQuery(resAustausBen);
                WebetkUtils.closeQuery(resMengenEinheitBen);
                WebetkUtils.closeQuery(resKom);
                WebetkUtils.closeQuery(res);
                WebetkUtils.closeQuery(resReach);
                if (con != null) {
                    con.setReadOnly(false);
                    gObj.freeDBConnection(con, "Teileinfo.load");
                }
                return aSachnummern;
            }
            res = TeileInfoDbAccess.loadTeileinfo(con, sHgUg, sSachnummer, sSprache, aMarken);
            boolean bFound = false;
            lKomId = -1L;
            isReach = null;
            while (res.next()) {
                bFound = true;
                this.msHg = res.getString("Hg");
                this.msUg = res.getString("Ug");
                this.msSachnummer = res.getString("SachNr");
                String sMarkeHelp = res.getString("Marke");
                this.appendMarke(sMarkeHelp);
                this.msProduktart = res.getString("Produktart");
                this.msBenennung = res.getString("Benennung");
                this.msBenennungskommentar = res.getString("BenKom");
                this.msZusatz = res.getString("BenZusatz");
                this.msTeileart = res.getString("Art");
                this.msDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null ? res.getString("Teil_Diebstahlrelevant") : "N";
                this.msAustausch = null;
                this.msNeuteil = null;
                String sTauschHg = res.getString("TauschHg");
                String sTauschUg = res.getString("TauschUg");
                String sAustauschTNr = res.getString("AustauschTNr");
                if (sAustauschTNr != null) {
                    sAustauschTNr = sTauschHg + " " + sTauschUg + " " + WebetkUtils.formatiereSachnummer(sAustauschTNr);
                }
                if (this.msTeileart.equals("1")) {
                    this.msAustausch = sAustauschTNr;
                } else if (this.msTeileart.equals("2")) {
                    this.msNeuteil = sAustauschTNr;
                }
                String sHgAlt = res.getString("AltHg");
                String sUgAlt = res.getString("AltUg");
                String sTeilenrAlt = res.getString("TNrAlt");
                this.msTeilenrAlt = sTeilenrAlt != null ? sHgAlt + " " + sUgAlt + " " + WebetkUtils.formatiereSachnummer(sTeilenrAlt) : null;
                this.msTST = res.getString("TST");
                this.msTSD = res.getString("TSD");
                this.msMengenEinheit = res.getString("Mengeneinheit");
                this.msMengenEinheitBen = res.getString("BenMengeneinheit");
                this.msProduktklasse = res.getString("Produktklasse");
                this.msRundungsKZ = res.getString("RundungsKz");
                this.msLokalTeilKZ = res.getString("LokalTeilKz");
                String sWert = res.getString("VVM");
                this.mnVVM = sWert != null ? new Integer(sWert) : null;
                sWert = res.getString("LVM");
                this.mnLVM = sWert != null ? new Integer(sWert) : null;
                sWert = res.getString("BVM");
                this.mnBVM = sWert != null ? new Integer(sWert) : null;
                sWert = res.getString("Gewicht");
                this.mfGewicht = sWert != null ? Float.valueOf(sWert) : null;
                this.msHinweis = res.getString("Fertigungshinweis");
                sWert = res.getString("Verbaubar");
                this.mbVerbaubar = sWert != null && sWert.equals("J");
                String sNormart = res.getString("Normart");
                String sNormnummer = res.getString("DIN");
                this.msNormNr = "";
                if (sNormart != null) {
                    this.msNormNr = sNormart;
                }
                if (sNormnummer != null) {
                    this.msNormNr = this.msNormNr + " " + sNormnummer;
                }
                this.msRecylingKz = res.getString("RecyclKz");
                this.msAustauschbar = res.getString("Austauschbar");
                this.msAustauschbarBen = res.getString("BenAustausch");
                this.msZusatzinfo = "";
                lKomId = res.getLong("ZusatzinfoKomId");
                isReach = res.getString("Reach");
                this.geraeuschMesswert = res.getInt("reifen_rollgeraeusch_wert");
                this.rollgeraeuschKlasse = res.getInt("reifen_rollgeraeusch_stufe");
                this.sKraftstoffeffizienzKlasse = res.getString("reifen_kraftstoff");
                this.sNasshaftungsKlasse = res.getString("reifen_nasshaftung");
            }
            WebetkUtils.closeQuery(res);
            if (bFound) break block40;
            boolean sMarkeHelp = false;
            WebetkUtils.closeQuery(resAustausBen);
            WebetkUtils.closeQuery(resMengenEinheitBen);
            WebetkUtils.closeQuery(resKom);
            WebetkUtils.closeQuery(res);
            WebetkUtils.closeQuery(resReach);
            if (con != null) {
                con.setReadOnly(false);
                gObj.freeDBConnection(con, "Teileinfo.load");
            }
            return sMarkeHelp;
        }
        try {
            if (this.msAustauschbar != null && this.msAustauschbarBen == null) {
                resAustausBen = TeileInfoDbAccess.loadBenZuKuerzel(con, "A", this.msAustauschbar, sSprache);
                if (resAustausBen != null && resAustausBen.next()) {
                    this.msAustauschbarBen = resAustausBen.getString("Ben");
                } else {
                    WebetkUtils.closeQuery(resAustausBen);
                    resAustausBen = TeileInfoDbAccess.loadBenZuKuerzel(con, "A", "??", sSprache);
                    if (resAustausBen != null && resAustausBen.next()) {
                        this.msAustauschbarBen = resAustausBen.getString("Ben");
                    }
                }
            }
            if (this.msMengenEinheit != null && this.msMengenEinheitBen == null) {
                resMengenEinheitBen = TeileInfoDbAccess.loadBenZuKuerzel(con, "MENGE", this.msMengenEinheit, sSprache);
                if (resMengenEinheitBen != null && resMengenEinheitBen.next()) {
                    this.msMengenEinheitBen = resMengenEinheitBen.getString("Ben");
                } else {
                    WebetkUtils.closeQuery(resMengenEinheitBen);
                    resMengenEinheitBen = TeileInfoDbAccess.loadBenZuKuerzel(con, "MENGE", "??", sSprache);
                    if (resMengenEinheitBen != null && resMengenEinheitBen.next()) {
                        this.msMengenEinheitBen = resMengenEinheitBen.getString("Ben");
                    }
                }
            }
            if (isReach != null && isReach.equals("J") && (resReach = TeileInfoDbAccess.loadReachinfo(con, this.msSachnummer)) != null) {
                ReachInfo reachInfo = null;
                while (resReach.next()) {
                    reachInfo = new ReachInfo();
                    reachInfo.setSubkomponent(resReach.getString("subKomponent"));
                    reachInfo.setCasNr(resReach.getString("casNr"));
                    reachInfo.setCasName(resReach.getString("casName"));
                    this.reachInfoList.add(reachInfo);
                }
            }
            if (lKomId > 0L && (resKom = TeileInfoDbAccess.loadProduktinfo(con, lKomId, sSprache)) != null) {
                while (resKom.next()) {
                    if (resKom.getString("Ben").equals("*****")) continue;
                    this.msZusatzinfo = this.msZusatzinfo + resKom.getString("Ben") + "\r\n";
                }
            }
            this.mcServiceinfoLinks = new Vector<ServiceInfoTable>();
            this.mcServiceinfoRechts = new Vector<ServiceInfoTable>();
            res = TeileInfoDbAccess.loadServiceinfo(con, sSachnummer);
            if (res != null) {
                int nRowCount = 0;
                int nLeft = 0;
                while (res.next()) {
                    ++nRowCount;
                }
                log.debug(new Integer(nRowCount).toString() + " Serviceinformationen geladen");
                nLeft = nRowCount <= 4 ? nRowCount : (nRowCount <= 8 ? 4 : nRowCount / 2 + nRowCount % 2);
                log.debug("  davon werden " + new Integer(nLeft).toString() + " in der linken Spalte angezeigt.");
                res.first();
                for (int nCount = 1; nCount <= nRowCount; ++nCount) {
                    Serviceinfo objServiceinfo = new Serviceinfo(res, this.getSachnummer());
                    ServiceInfoTable tabServiceinfo = new ServiceInfoTable(objServiceinfo.getHashtable());
                    if (nCount <= nLeft) {
                        this.mcServiceinfoLinks.add(tabServiceinfo);
                    } else {
                        this.mcServiceinfoRechts.add(tabServiceinfo);
                    }
                    res.next();
                }
            }
            Collection<String> aUserMarken = objSessionInfo.getUserMarken();
            Collection<String> aUserProdukte = objSessionInfo.getUserProdukte();
            String sUserKatalogumfang = objSessionInfo.getUserKatUmfang();
            this.loadTeileclearingInfo(con, aUserMarken, aUserProdukte, sUserKatalogumfang, sLandkuerzel);
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resAustausBen);
            WebetkUtils.closeQuery(resMengenEinheitBen);
            WebetkUtils.closeQuery(resKom);
            WebetkUtils.closeQuery(res);
            WebetkUtils.closeQuery(resReach);
            if (con != null) {
                con.setReadOnly(false);
                gObj.freeDBConnection(con, "Teileinfo.load");
            }
            throw throwable;
        }
        WebetkUtils.closeQuery(resAustausBen);
        WebetkUtils.closeQuery(resMengenEinheitBen);
        WebetkUtils.closeQuery(resKom);
        WebetkUtils.closeQuery(res);
        WebetkUtils.closeQuery(resReach);
        if (con != null) {
            con.setReadOnly(false);
            gObj.freeDBConnection(con, "Teileinfo.load");
        }
        this.moNotiz = new Notiz(sSprache);
        this.moNotiz.load(sNutzer, sFirma, sSachnummer);
        if (this.maMarken != null) {
            this.mcTeilelisten = Teileliste.getTeilelisten(sNutzer, this.maMarken, sFirma, sFiliale, false);
        }
        this.hatEinzelteile();
        this.hatInterpretation();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean load(String sSachnummer, String sFremdeTNr, String sSprache, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        block27: {
            block25: {
                block26: {
                    gObj = ServerGlobalObjects.getInstance();
                    Teileinfo.log.info("Loading Teileinfo for part with No: " + sSachnummer + sFremdeTNr + " Language: " + sSprache);
                    con = null;
                    res = null;
                    resKom = null;
                    resReach = null;
                    resAustausBen = null;
                    resMengenEinheitBen = null;
                    con = gObj.getDBConnection("Teileinfo.load");
                    if (sSachnummer != null && sSachnummer.length() == 7) break block25;
                    if (sFremdeTNr == null || sFremdeTNr.length() <= 0) ** GOTO lbl44
                    Teileinfo.log.debug(" Suche \u00fcber fremde Teilenummer ");
                    aSachnummern = AllgemeinDbAccess.retrieveBMWSachnummern(con, sFremdeTNr);
                    if (aSachnummern == null) {
                        sSachnummer = null;
                        break block26;
                    }
                    if (aSachnummern.size() == 1) {
                        sSachnummer = aSachnummern.get(0);
                        break block26;
                    }
                    this.maSachnummern = new Vector<SearchBTETeile.PartOrBTE>();
                    res = TeileInfoDbAccess.loadTeilenummernErgebnisliste(con, aSachnummern, sSprache);
                    prevSachnummer = null;
                    while (res != null && res.next()) {
                        part = SearchBTETeile.readResultIntoPart(res);
                        sMarkeTeil = res.getString("Marke");
                        part.addMarke(sMarkeTeil);
                        if (part.getIdNummer().equals(prevSachnummer)) continue;
                        prevSachnummer = part.getIdNummer();
                        this.maSachnummern.add(part);
                    }
                    part = true;
                    WebetkUtils.closeQuery(resAustausBen);
                    WebetkUtils.closeQuery(resMengenEinheitBen);
                    WebetkUtils.closeQuery(resKom);
                    WebetkUtils.closeQuery(res);
                    WebetkUtils.closeQuery(resReach);
                    gObj.freeDBConnection(con, "Teileinfo.load");
                    return part;
                }
                break block25;
lbl44:
                // 1 sources

                Teileinfo.log.warn("Keine Sachnummer oder fremde Teilenummer \u00fcbergeben!");
                aSachnummern = false;
                WebetkUtils.closeQuery(resAustausBen);
                WebetkUtils.closeQuery(resMengenEinheitBen);
                WebetkUtils.closeQuery(resKom);
                WebetkUtils.closeQuery(res);
                WebetkUtils.closeQuery(resReach);
                gObj.freeDBConnection(con, "Teileinfo.load");
                return aSachnummern;
            }
            res = TeileInfoDbAccess.loadTeileinfo(con, "", sSachnummer, sSprache, aUserMarken);
            if (res != null && res.next()) break block27;
            aSachnummern = false;
            WebetkUtils.closeQuery(resAustausBen);
            WebetkUtils.closeQuery(resMengenEinheitBen);
            WebetkUtils.closeQuery(resKom);
            WebetkUtils.closeQuery(res);
            WebetkUtils.closeQuery(resReach);
            gObj.freeDBConnection(con, "Teileinfo.load");
            return aSachnummern;
        }
        try {
            this.msHg = res.getString("Hg");
            this.msUg = res.getString("Ug");
            this.msSachnummer = res.getString("SachNr");
            sMarkeHelp = res.getString("Marke");
            this.appendMarke(sMarkeHelp);
            this.msProduktart = res.getString("Produktart");
            this.msBenennung = res.getString("Benennung");
            this.msBenennungskommentar = res.getString("BenKom");
            this.msZusatz = res.getString("BenZusatz");
            this.msTeileart = res.getString("Art");
            this.msDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null ? res.getString("Teil_Diebstahlrelevant") : "N";
            this.msAustausch = null;
            this.msNeuteil = null;
            sTauschHg = res.getString("TauschHg");
            sTauschUg = res.getString("TauschUg");
            sAustauschTNr = res.getString("AustauschTNr");
            if (sAustauschTNr != null) {
                sAustauschTNr = sTauschHg + " " + sTauschUg + " " + WebetkUtils.formatiereSachnummer(sAustauschTNr);
            }
            if (this.msTeileart.equals("1")) {
                this.msAustausch = sAustauschTNr;
            } else if (this.msTeileart.equals("2")) {
                this.msNeuteil = sAustauschTNr;
            }
            sHgAlt = res.getString("AltHg");
            sUgAlt = res.getString("AltUg");
            sTeilenrAlt = res.getString("TNrAlt");
            this.msTeilenrAlt = sTeilenrAlt != null ? sHgAlt + " " + sUgAlt + " " + WebetkUtils.formatiereSachnummer(sTeilenrAlt) : null;
            this.msAustauschbar = res.getString("Austauschbar");
            this.msAustauschbarBen = res.getString("BenAustausch");
            if (this.msAustauschbar != null && this.msAustauschbarBen == null && (resAustausBen = TeileInfoDbAccess.loadBenZuKuerzel(con, "A", "??", sSprache)) != null && resAustausBen.next()) {
                this.msAustauschbarBen = resAustausBen.getString("Ben");
            }
            this.msTST = res.getString("TST");
            this.msTSD = res.getString("TSD");
            this.msMengenEinheit = res.getString("Mengeneinheit");
            if (this.msMengenEinheit != null && this.msMengenEinheitBen == null && (resMengenEinheitBen = TeileInfoDbAccess.loadBenZuKuerzel(con, "MENGE", "??", sSprache)) != null && resMengenEinheitBen.next()) {
                this.msMengenEinheitBen = resMengenEinheitBen.getString("Ben");
            }
            this.msProduktklasse = res.getString("Produktklasse");
            this.msRundungsKZ = res.getString("RundungsKz");
            this.msLokalTeilKZ = res.getString("LokalTeilKz");
            sWert = res.getString("VVM");
            this.mnVVM = sWert != null ? new Integer(sWert) : null;
            sWert = res.getString("LVM");
            this.mnLVM = sWert != null ? new Integer(sWert) : null;
            sWert = res.getString("BVM");
            this.mnBVM = sWert != null ? new Integer(sWert) : null;
            sWert = res.getString("Gewicht");
            this.mfGewicht = sWert != null ? Float.valueOf(sWert) : null;
            this.msHinweis = res.getString("Fertigungshinweis");
            sWert = res.getString("Verbaubar");
            this.mbVerbaubar = sWert != null && sWert.equals("J") != false;
            this.msReachinfo = "";
            isReach = res.getString("Reach");
            if (isReach != null && isReach.equals("J") && (resReach = TeileInfoDbAccess.loadReachinfo(con, this.msSachnummer)) != null) {
                reachInfo = null;
                while (resReach.next()) {
                    reachInfo = new ReachInfo();
                    reachInfo.setSubkomponent("subKomponent");
                    reachInfo.setCasNr(resReach.getString("casNr"));
                    reachInfo.setCasName(resReach.getString("casName"));
                    this.reachInfoList.add(reachInfo);
                }
            }
            this.msZusatzinfo = "";
            lKomId = res.getLong("ZusatzinfoKomId");
            if (lKomId > 0L && (resKom = TeileInfoDbAccess.loadProduktinfo(con, lKomId, sSprache)) != null) {
                while (resKom.next()) {
                    if (resKom.getString("BEN").equals("*****")) continue;
                    this.msZusatzinfo = this.msZusatzinfo + resKom.getString("BEN") + "\r\n";
                }
            }
            sNormart = res.getString("Normart");
            sNormnummer = res.getString("DIN");
            this.msNormNr = "";
            if (sNormart != null) {
                this.msNormNr = sNormart;
            }
            if (sNormnummer != null) {
                this.msNormNr = this.msNormNr + " " + sNormnummer;
            }
            this.msRecylingKz = res.getString("RecyclKz");
            this.mcServiceinfoLinks = new Vector<ServiceInfoTable>();
            this.mcServiceinfoRechts = new Vector<ServiceInfoTable>();
            this.geraeuschMesswert = res.getInt("reifen_rollgeraeusch_wert");
            this.rollgeraeuschKlasse = res.getInt("reifen_rollgeraeusch_stufe");
            this.sKraftstoffeffizienzKlasse = res.getString("reifen_kraftstoff");
            this.sNasshaftungsKlasse = res.getString("reifen_nasshaftung");
            WebetkUtils.closeQuery(res);
            res = TeileInfoDbAccess.loadServiceinfo(con, sSachnummer);
            if (res != null) {
                nRowCount = 0;
                nLeft = 0;
                while (res.next()) {
                    ++nRowCount;
                }
                Teileinfo.log.debug(new Integer(nRowCount).toString() + " Serviceinformationen geladen");
                nLeft = nRowCount <= 4 ? nRowCount : (nRowCount <= 8 ? 4 : nRowCount / 2 + nRowCount % 2);
                Teileinfo.log.debug("  davon werden " + new Integer(nLeft).toString() + " in der linken Spalte angezeigt.");
                res.first();
                for (nCount = 1; nCount <= nRowCount; ++nCount) {
                    objServiceinfo = new Serviceinfo(res, this.getSachnummer());
                    tabServiceinfo = new ServiceInfoTable(objServiceinfo.getHashtable());
                    if (nCount <= nLeft) {
                        this.mcServiceinfoLinks.add(tabServiceinfo);
                    } else {
                        this.mcServiceinfoRechts.add(tabServiceinfo);
                    }
                    res.next();
                }
            }
            this.loadTeileclearingInfo(con, aUserMarken, aUserProdukte, sUserKatalogumfang, sLandkuerzel);
        }
        catch (Throwable var33_39) {
            WebetkUtils.closeQuery(resAustausBen);
            WebetkUtils.closeQuery(resMengenEinheitBen);
            WebetkUtils.closeQuery(resKom);
            WebetkUtils.closeQuery(res);
            WebetkUtils.closeQuery(resReach);
            gObj.freeDBConnection(con, "Teileinfo.load");
            throw var33_39;
        }
        WebetkUtils.closeQuery(resAustausBen);
        WebetkUtils.closeQuery(resMengenEinheitBen);
        WebetkUtils.closeQuery(resKom);
        WebetkUtils.closeQuery(res);
        WebetkUtils.closeQuery(resReach);
        gObj.freeDBConnection(con, "Teileinfo.load");
        this.hatEinzelteile();
        this.hatInterpretation();
        return true;
    }

    public void loadNutzerSpezifischeDaten(String sSachnummer, String sNutzer, String sFirma, String sFiliale, String sSprache, String sMarke) throws SQLException, DatabaseBusyException {
        log.info("Loading Teileinfo for part with No: " + sSachnummer);
        this.moNotiz = new Notiz(sSprache);
        this.moNotiz.load(sNutzer, sFirma, sSachnummer);
        if (this.maMarken != null) {
            this.mcTeilelisten = Teileliste.getTeilelisten(sNutzer, this.maMarken, sFirma, sFiliale, false);
        }
    }

    public boolean containsLAZServiceinfo() {
        String sDokuart;
        ServiceInfoTable tabServiceinfo;
        Iterator<ServiceInfoTable> iter;
        if (this.mcServiceinfoLinks != null) {
            iter = this.mcServiceinfoLinks.iterator();
            while (iter != null && iter.hasNext()) {
                tabServiceinfo = iter.next();
                sDokuart = tabServiceinfo.get("DokArt");
                if (!sDokuart.equals("LAZ")) continue;
                return true;
            }
        }
        if (this.mcServiceinfoRechts != null) {
            iter = this.mcServiceinfoRechts.iterator();
            while (iter != null && iter.hasNext()) {
                tabServiceinfo = iter.next();
                sDokuart = tabServiceinfo.get("DokArt");
                if (!sDokuart.equals("LAZ")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getHatInterpretation() {
        return this.mbHatInterpretation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hatInterpretation() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block4: {
            boolean bl;
            String sSachnummer = this.getSachnummer();
            if (sSachnummer.length() < 7) {
                this.mbHatInterpretation = false;
                return false;
            }
            gObj = ServerGlobalObjects.getInstance();
            log.info("checking Interpretation for part with No: " + sSachnummer);
            con = null;
            res = null;
            try {
                con = gObj.getDBConnection("Teileinfo.hatInterpretation");
                res = InterpretationDbAccess.loadInterpretationEinstieg(con, sSachnummer);
                if (res != null && res.next()) break block4;
                this.mbHatInterpretation = false;
                bl = false;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "Teileinfo.hatInterpretation");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Teileinfo.hatInterpretation");
            return bl;
        }
        this.mbHatInterpretation = true;
        boolean bl = true;
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teileinfo.hatInterpretation");
        return bl;
    }

    public boolean getHatEinzelteile() {
        return this.mbHatEinzelteile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hatEinzelteile() throws SQLException, DatabaseBusyException {
        String sSachnummer = this.getSachnummer();
        if (sSachnummer.length() < 7) {
            this.mbHatEinzelteile = false;
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("checking Einzelteile for part with No: " + sSachnummer);
        Connection con = null;
        try {
            con = gObj.getDBConnection("Teileinfo.hatEinzelteile");
            this.mbHatEinzelteile = SatzEinzelteileDbAccess.hatEinzelteile(con, sSachnummer);
        }
        finally {
            gObj.freeDBConnection(con, "Teileinfo.hatEinzelteile");
        }
        return this.mbHatEinzelteile;
    }

    public boolean getVerbaubar() {
        return this.mbVerbaubar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPreiseGeladen(String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info("checkPreiseGeladen");
        Connection con = null;
        try {
            con = gObj.getDBConnectionPreise("Teileinfo.checkPreiseGeladen");
            boolean bl = TeileInfoDbAccess.checkPreiseGeladen(con, sFirma);
            return bl;
        }
        finally {
            gObj.freeDBConnectionPreise(con, "Teileinfo.checkPreiseGeladen");
        }
    }

    public void appendMarke(String sMarke) {
        if (this.maMarken == null) {
            this.maMarken = new Vector();
            this.maMarken.add(sMarke);
            return;
        }
        for (String sHelp : this.maMarken) {
            if (!sMarke.equalsIgnoreCase(sHelp)) continue;
            return;
        }
        this.maMarken.add(sMarke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTeileclearingInfo(Connection con, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        log.info("loadTeileclearingInfo");
        ResultSet res = null;
        try {
            res = TeileInfoDbAccess.loadTeileclearing(con, this.msSachnummer, aUserMarken, aUserProdukte, sUserKatalogumfang, sLandkuerzel);
            String sIdGemerkt = null;
            boolean bNeueKampagne = false;
            while (res.next()) {
                String sDatumBis;
                String sId = res.getString("Id");
                bNeueKampagne = false;
                if (sIdGemerkt == null || !sIdGemerkt.equals(sId)) {
                    sIdGemerkt = sId;
                    bNeueKampagne = true;
                }
                String sLand = res.getString("Land");
                String sBaureihen = res.getString("Baureihen");
                String sMotoren = res.getString("Motoren");
                String sDatumVon = res.getString("DatumVon");
                if (sDatumVon != null) {
                    long lDatumVon = Long.parseLong(sDatumVon);
                    sDatumVon = WebetkUtils.getStringFromDate(WebetkUtils.getDateFromLong(lDatumVon), "de", 2);
                }
                if ((sDatumBis = res.getString("DatumBis")) != null) {
                    long lDatumBis = Long.parseLong(sDatumBis);
                    sDatumBis = WebetkUtils.getStringFromDate(WebetkUtils.getDateFromLong(lDatumBis), "de", 2);
                }
                if (!sBaureihen.equals("ALLE")) {
                    Teileclearing oTC = new Teileclearing(sLand, bNeueKampagne, sBaureihen, sDatumVon, sDatumBis);
                    this.mcTeileclearing.add(oTC);
                    bNeueKampagne = false;
                } else if (sMotoren.equals("ALLE")) {
                    Teileclearing oTC = new Teileclearing(sLand, bNeueKampagne, "ALLE", sDatumVon, sDatumBis);
                    this.mcTeileclearing.add(oTC);
                    bNeueKampagne = false;
                }
                if (sMotoren.equals("ALLE")) continue;
                Teileclearing oTC = new Teileclearing(sLand, bNeueKampagne, sMotoren, sDatumVon, sDatumBis);
                this.mcTeileclearing.add(oTC);
                bNeueKampagne = false;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
    }

    public Collection<SearchBTETeile.PartOrBTE> getSachnummern() {
        return this.maSachnummern;
    }

    public boolean isReifen() {
        if (this.sNasshaftungsKlasse != null && !this.sNasshaftungsKlasse.equals("")) {
            this.mbIsReifen = true;
        }
        return this.mbIsReifen;
    }

    public void setIsReifen(boolean mbIsReifen) {
        this.mbIsReifen = mbIsReifen;
    }

    public String getsKraftstoffeffizienzKlasse() {
        return this.sKraftstoffeffizienzKlasse;
    }

    public void setsKraftstoffeffizienzKlasse(String sKraftstoffeffizienzKlasse) {
        this.sKraftstoffeffizienzKlasse = sKraftstoffeffizienzKlasse;
    }

    public String getsNasshaftungsKlasse() {
        return this.sNasshaftungsKlasse;
    }

    public void setsNasshaftungsKlasse(String sNasshaftungsKlasse) {
        this.sNasshaftungsKlasse = sNasshaftungsKlasse;
    }

    public int getRollgeraeuschKlasse() {
        return this.rollgeraeuschKlasse;
    }

    public void setRollgeraeuschKlasse(int rollgeraeuschKlasse) {
        this.rollgeraeuschKlasse = rollgeraeuschKlasse;
    }

    public int getGeraeuschMesswert() {
        return this.geraeuschMesswert;
    }

    public void setGeraeuschMesswert(int geraeuschMesswert) {
        this.geraeuschMesswert = geraeuschMesswert;
    }

    public HashMap<String, String> getReachRelaventInformation() {
        return this.reachRelaventInformation;
    }

    public List<?> getReachInformationList() {
        return this.reachInfoList;
    }

    public HashMap<String, String> getReachInformationHashMap() {
        HashMap<String, String> hMap = new HashMap<String, String>();
        int i = 1;
        if (this.reachInfoList != null) {
            for (ReachInfo ri : this.reachInfoList) {
                hMap.put("subKomponent" + i, ri.getSubkomponent());
                hMap.put("casNr" + i, ri.getCasNr());
                hMap.put("casName" + i, ri.getCasName());
                ++i;
            }
        }
        return hMap;
    }
}

