/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.valueline;

import java.io.Serializable;
import java.util.Hashtable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import webetk.WebetkUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ValueLineSatz
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    private String msSachnummer = null;
    private String msHG = null;
    private String msUG = null;
    private String msBenennung = null;
    private String msZusatz = null;
    private String msZI = null;
    private boolean mbIsDiebstahlrelevant = false;

    public ValueLineSatz() {
    }

    public ValueLineSatz(String sSachnummer, String sHG, String sUG, String sBenennung, String sZusatz, String sZI, boolean bIsDiebstahlrelevant) {
        this.msSachnummer = sSachnummer;
        this.msHG = sHG;
        this.msUG = sUG;
        this.msBenennung = sBenennung;
        this.msZusatz = sZusatz;
        this.msZI = sZI;
        this.mbIsDiebstahlrelevant = bIsDiebstahlrelevant;
    }

    public boolean isTeilDiebstahlrelevant() {
        return this.mbIsDiebstahlrelevant;
    }

    public String getSachnummer() {
        return this.msSachnummer;
    }

    public String getTeilenummer() {
        String sTeilenummer = "";
        if (this.msHG != null && this.msUG != null) {
            sTeilenummer = this.msHG + " " + this.msUG;
        }
        if (this.msSachnummer != null) {
            sTeilenummer = sTeilenummer + " " + WebetkUtils.formatiereSachnummer(this.msSachnummer);
        }
        return sTeilenummer;
    }

    public String getBenennung() {
        return this.msBenennung;
    }

    public String getZusatz() {
        if (this.msZusatz == null) {
            return "";
        }
        return this.msZusatz;
    }

    public String getZI() {
        if (this.msZI == null) {
            return "";
        }
        return this.msZI;
    }

    public Hashtable getHashtable() {
        Hashtable<String, String> objHashtable = new Hashtable<String, String>();
        objHashtable.put("Sachummer", this.msSachnummer);
        objHashtable.put("Teilenummer", this.getTeilenummer());
        objHashtable.put("Benennung", this.msBenennung);
        objHashtable.put("Zusatz", this.getZusatz());
        objHashtable.put("ZI", this.msZI);
        objHashtable.put("Diebstahlrelevant", this.isTeilDiebstahlrelevant() ? "J" : "N");
        objHashtable.put("Teilenr_und_Benennung", this.getTeilenummer() + " - " + this.msBenennung);
        objHashtable.put("istSatz", "J");
        return objHashtable;
    }
}

