/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.WebetkUtils;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.zub.common.PreisZeile;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.Variante;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Preise
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Preise.class);
    private ArrayList<PreisZeile> mPreisZeilen = new ArrayList();
    private boolean mAbPreiseMitSteuer = true;
    private HashMap<String, EinbauInfo> mEinbauinfosBte = new HashMap();
    private HashMap<String, HashMap<String, EinbauInfo>> mEinbauinfosBnbs = new HashMap();
    private HashMap<String, HashMap<String, EinbauInfo>> mEinbauinfosVarianten = new HashMap();
    private String mBteNr = null;
    private FzgSucheInfo mFahrzeug = null;
    private AufwandsKonfiguration mAufwaende;
    private double mdMwStArbeit = 0.0;

    public Preise(AufwandsKonfiguration aufwaende, FzgSucheInfo fahrzeug) {
        this.mPreisZeilen = new ArrayList();
        this.mEinbauinfosBte = new HashMap();
        this.mEinbauinfosBnbs = new HashMap();
        this.mEinbauinfosVarianten = new HashMap();
        this.mAufwaende = aufwaende;
        this.mFahrzeug = fahrzeug;
    }

    public Preise() {
    }

    public void addPreisZeile(PreisZeile zeile) {
        this.mPreisZeilen.add(zeile);
    }

    public List<PreisZeile> getPreisZeilen() {
        return this.mPreisZeilen;
    }

    public void setzeMwStSaetzeZuCodes(Konfiguration konfig) {
        String sMwSt = konfig.getMWStSatzHoch();
        this.mdMwStArbeit = sMwSt != null && sMwSt.length() > 0 ? Double.parseDouble(sMwSt) : 0.0;
        if (this.mPreisZeilen == null || this.mPreisZeilen.isEmpty()) {
            return;
        }
        String sAtSt = konfig.getMWStSatzAltteile();
        double dAtSt = 0.0;
        if (sAtSt != null) {
            try {
                dAtSt = Double.parseDouble(sAtSt);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Iterator<PreisZeile> iter = this.mPreisZeilen.iterator();
        PreisZeile zeile = null;
        while (iter.hasNext()) {
            zeile = iter.next();
            if (zeile.getMwSt() != 0.0) continue;
            String sMwStCode = zeile.getMwStCode();
            sMwSt = sMwStCode != null ? (sMwStCode.equals("2") ? konfig.getMWStSatzHoch() : (sMwStCode.equals("3") ? konfig.getMWStSatzAltteile() : (sMwStCode.equals("4") ? konfig.getMWStSatz3() : (sMwStCode.equals("5") ? konfig.getMWStSatz4() : konfig.getMWStSatzNiedrig())))) : konfig.getMWStSatzHoch();
            double dMwSt = 0.0;
            if (sMwSt != null) {
                try {
                    dMwSt = Double.parseDouble(sMwSt);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            zeile.setMwSt(dMwSt);
            zeile.setAtSt(dAtSt);
        }
    }

    public Double getAbPreis(String bnbNr, ArrayList bnbsVarianten) {
        log.debug("Ermittele Preis zu BTE " + this.mBteNr + ", BNB " + bnbNr);
        double preis = 0.0;
        String baureihe = null;
        if (this.mFahrzeug != null) {
            baureihe = this.mFahrzeug.getBaureihe();
        }
        if (baureihe == null || baureihe.length() == 0) {
            baureihe = "OHNE";
        }
        if (bnbNr == null) {
            if (bnbsVarianten == null) {
                Double dPreis = this.getAbPreisKeineVariante(baureihe);
                if (dPreis == null) {
                    return null;
                }
                log.debug("Preis: " + dPreis.toString());
                preis = dPreis;
            } else {
                Double dPreis = this.getAbPreisVariante(bnbsVarianten, baureihe);
                if (dPreis == null) {
                    return null;
                }
                preis = dPreis;
                log.debug("Preis Baureihe " + baureihe + ": " + Double.toString(preis));
            }
            log.debug("Preis mit Arbeit " + Double.toString(preis += this.getPreisArbeit(null, 0L, baureihe)));
        } else {
            Double dPreis = this.getAbPreisBnb(bnbNr, bnbsVarianten, baureihe);
            if (dPreis == null) {
                return null;
            }
            preis = dPreis;
        }
        log.debug("Preis " + Double.toString(preis));
        return new Double(Math.floor(preis * 100.0 + 0.5) / 100.0);
    }

    private Double getAbPreisKeineVariante(String baureihe) {
        ArrayList bnbNummern = this.getBnbNummernHauptprodukt();
        if (bnbNummern == null) {
            return null;
        }
        Iterator iter = bnbNummern.iterator();
        double minpreisAlternative = 0.0;
        double preisVariante = 0.0;
        while (iter.hasNext()) {
            String aktBnbnr = (String)iter.next();
            Double preisAktBnb = this.getAbPreisBnb(aktBnbnr, null, baureihe);
            if (preisAktBnb == null) {
                return null;
            }
            if (this.getElemartBnb(aktBnbnr).equals("HP_ALTERNATIV") || this.getElemartBnb(aktBnbnr).equals("HP_EINZELTEIL")) {
                if (minpreisAlternative != 0.0 && !(preisAktBnb < minpreisAlternative) || !(preisAktBnb > 0.0)) continue;
                minpreisAlternative = preisAktBnb;
                continue;
            }
            preisVariante += preisAktBnb.doubleValue();
        }
        if (minpreisAlternative > 0.0) {
            preisVariante += minpreisAlternative;
        }
        if (preisVariante == 0.0) {
            boolean hatTeile = false;
            for (String aktBnbnr : bnbNummern) {
                ArrayList zeilen = this.getZeilenZuBnb(aktBnbnr);
                int variante = this.getVarianteBnb(aktBnbnr, null);
                if (!this.getVarianteHatTeile(variante, zeilen)) continue;
                hatTeile = true;
                break;
            }
            if (!hatTeile) {
                return null;
            }
        }
        return new Double(preisVariante);
    }

    private Double getAbPreisVariante(ArrayList bnbsVarianten, String baureihe) {
        if (bnbsVarianten == null) {
            log.error("getAbPreisKeineVariante(String baureihe) verwenden");
            return null;
        }
        ArrayList bnbNummern = this.getBnbNummernHauptprodukt(bnbsVarianten);
        if (bnbNummern == null) {
            return null;
        }
        Iterator iter = bnbNummern.iterator();
        double minpreisAlternative = 0.0;
        double preisVariante = 0.0;
        while (iter.hasNext()) {
            String aktBnbnr = (String)iter.next();
            Double preisAktBnb = this.getAbPreisBnb(aktBnbnr, bnbsVarianten, baureihe);
            if (preisAktBnb == null) {
                return null;
            }
            if (this.getElemartBnb(aktBnbnr).equals("HP_ALTERNATIV")) {
                if (minpreisAlternative != 0.0 && !(preisAktBnb < minpreisAlternative) || !(preisAktBnb > 0.0)) continue;
                minpreisAlternative = preisAktBnb;
                continue;
            }
            preisVariante += preisAktBnb.doubleValue();
        }
        if (minpreisAlternative > 0.0) {
            preisVariante += minpreisAlternative;
        }
        if (preisVariante == 0.0) {
            boolean hatTeile = false;
            for (String aktBnbnr : bnbNummern) {
                ArrayList zeilen = this.getZeilenZuBnb(aktBnbnr);
                int variante = this.getVarianteBnb(aktBnbnr, bnbsVarianten);
                if (!this.getVarianteHatTeile(variante, zeilen)) continue;
                hatTeile = true;
                break;
            }
            if (!hatTeile) {
                return null;
            }
        }
        if (bnbsVarianten != null) {
            for (String aktBnbnr : bnbNummern) {
                int variante = this.getVarianteBnb(aktBnbnr, bnbsVarianten);
                if (variante <= 0) continue;
                preisVariante += this.getPreisArbeit(null, variante, baureihe);
            }
        }
        return new Double(preisVariante);
    }

    private ArrayList getBnbNummernHauptprodukt() {
        ArrayList<String> bnbNummern = new ArrayList<String>();
        String lastBnb = "";
        for (PreisZeile zeile : this.mPreisZeilen) {
            if (zeile == null || zeile.getBnbNr() == null || zeile.getBnbNr().equals(lastBnb) || zeile.getElementArt() == null || !zeile.getElementArt().equals("HP_OBLIGAT") && !zeile.getElementArt().equals("HP_PAKET") && !zeile.getElementArt().equals("HP_ALTERNATIV") && !zeile.getElementArt().equals("HILFSSTOFFE") && !zeile.getElementArt().equals("HP_EINZELTEIL")) continue;
            bnbNummern.add(zeile.getBnbNr());
            lastBnb = zeile.getBnbNr();
        }
        return bnbNummern;
    }

    private ArrayList getBnbNummernHauptprodukt(ArrayList bnbsVarianten) {
        ArrayList<String> bnbNummern = new ArrayList<String>();
        if (bnbsVarianten == null) {
            log.error("getAbPreisKeineVariante(String baureihe) verwenden");
            return null;
        }
        for (Bnb bnb : bnbsVarianten) {
            if (bnb.getElementArt() == null || !bnb.getElementArt().equals("HP_OBLIGAT") && !bnb.getElementArt().equals("HP_PAKET") && !bnb.getElementArt().equals("HP_ALTERNATIV") && !bnb.getElementArt().equals("HILFSSTOFFE") && !bnb.getElementArt().equals("HP_EINZELTEIL")) continue;
            bnbNummern.add(bnb.getBildPos());
        }
        return bnbNummern;
    }

    private ArrayList getZeilenZuBnb(String bnbNr) {
        ArrayList<PreisZeile> zeilen = new ArrayList<PreisZeile>();
        for (PreisZeile zeile : this.mPreisZeilen) {
            if (zeile == null || zeile.getBnbNr() == null || !zeile.getBnbNr().equals(bnbNr)) continue;
            zeilen.add(zeile);
        }
        return zeilen;
    }

    private int getVarianteBnb(String bnbNr, ArrayList bnbsVarianten) {
        if (bnbsVarianten == null) {
            return 0;
        }
        for (Bnb bnb : bnbsVarianten) {
            Variante variante;
            if (bnb == null || !bnb.getBildPos().equals(bnbNr) || (variante = bnb.getSelectedVariante()) == null) continue;
            return variante.getVarianteId();
        }
        return 0;
    }

    private String getElemartBnb(String bnbNr) {
        for (PreisZeile zeile : this.mPreisZeilen) {
            if (zeile == null || zeile.getBnbNr() == null || !zeile.getBnbNr().equals(bnbNr)) continue;
            return zeile.getElementArt();
        }
        return "";
    }

    private ArrayList getVariantenDerBte() {
        ArrayList<Long> varianten = new ArrayList<Long>();
        for (PreisZeile zeile : this.mPreisZeilen) {
            if (zeile == null || varianten.contains(new Long(zeile.getVarianteId()))) continue;
            varianten.add(new Long(zeile.getVarianteId()));
        }
        return varianten;
    }

    private Double getAbPreisBnb(String bnbNr, ArrayList bnbsVarianten, String baureihe) {
        Long oVariante;
        long aktVariante;
        log.debug("Ermittle Preis BNB " + bnbNr + " baureihe " + baureihe);
        double abPreis = 0.0;
        ArrayList zeilen = this.getZeilenZuBnb(bnbNr);
        boolean varianteHatTeile = false;
        ArrayList varianten = this.getVariantenDerBte();
        Iterator iter = varianten.iterator();
        while (iter.hasNext() && ((aktVariante = (oVariante = (Long)iter.next()).longValue()) == 0L || !(varianteHatTeile = this.getVarianteHatTeile(aktVariante, zeilen)))) {
        }
        if (bnbsVarianten == null) {
            if (!varianteHatTeile) {
                log.debug("keine Variante enthaelt Teile");
                Double preis = this.getAbPreisVariante(0L, zeilen);
                if (preis == null) {
                    return null;
                }
                abPreis = preis;
                abPreis += this.getPreisArbeit(bnbNr, 0L, baureihe);
            } else {
                varianten = this.getVariantenDerBte();
                iter = varianten.iterator();
                int countVariante = 0;
                while (iter.hasNext()) {
                    Long oVariante2 = (Long)iter.next();
                    long aktVariante2 = oVariante2;
                    if (varianten.size() > 1 && aktVariante2 == 0L || varianten.size() > 1 && !this.getVarianteHatTeile(aktVariante2, zeilen)) continue;
                    ++countVariante;
                    Double preis = this.getAbPreisVariante(aktVariante2, zeilen);
                    if (preis == null) {
                        return null;
                    }
                    double preisVariante = preis;
                    if (!((preisVariante += this.getPreisArbeit(bnbNr, 0L, baureihe)) < abPreis) && countVariante != 1) continue;
                    abPreis = preisVariante;
                }
            }
            log.debug("Preis BNB " + bnbNr + "baureihe " + baureihe + ": " + Double.toString(abPreis));
        } else {
            Double preisOhneVariante;
            long variante = 0L;
            if (!varianteHatTeile) {
                log.debug("keine Variante enthaelt Teile");
                variante = 0L;
            } else {
                variante = this.getVarianteBnb(bnbNr, bnbsVarianten);
            }
            Double preis = this.getAbPreisVariante(variante, zeilen);
            if (preis == null) {
                return null;
            }
            abPreis = preis;
            if (variante != 0L && (preisOhneVariante = this.getAbPreisVariante(0L, zeilen)) != null && preisOhneVariante > 0.0 && preisOhneVariante < abPreis) {
                abPreis = preisOhneVariante;
            }
            log.debug("Preis BNB " + bnbNr + " variante " + Long.toString(variante) + "baureihe " + baureihe + ": " + Double.toString(abPreis += this.getPreisArbeit(bnbNr, 0L, baureihe)));
        }
        return new Double(abPreis);
    }

    private Double getAbPreisVariante(long variante, ArrayList zeilen) {
        String buendelung = null;
        Double preisBuendelOhne = this.getAbPreisBuendelungVariante(buendelung, variante, zeilen);
        buendelung = "RECHTS";
        Double preisBuendelRechts = this.getAbPreisBuendelungVariante(buendelung, variante, zeilen);
        buendelung = "LINKS";
        Double preisBuendelLinks = this.getAbPreisBuendelungVariante(buendelung, variante, zeilen);
        if (preisBuendelOhne == null) {
            return null;
        }
        if (preisBuendelRechts == null || preisBuendelLinks == null) {
            if (preisBuendelRechts != null) {
                preisBuendelLinks = preisBuendelRechts;
            } else if (preisBuendelLinks != null) {
                preisBuendelRechts = preisBuendelLinks;
            } else {
                return null;
            }
        }
        double preisVariante = preisBuendelOhne + preisBuendelRechts + preisBuendelLinks;
        log.debug("Preis Variante " + Double.toString(preisVariante));
        return new Double(preisVariante);
    }

    private Double getAbPreisBuendelungVariante(String buendelung, long variante, ArrayList zeilen) {
        log.debug("Ermittele Preis zu Buendelung " + buendelung + " und Varinate " + Long.toString(variante));
        Double abPreis = null;
        boolean hatTeile = false;
        for (PreisZeile zeile : zeilen) {
            if (zeile.getArt().equals("NIVM") || zeile.getArt().equals("NPZ") || (zeile.getBuendel() != null || buendelung != null) && (zeile.getBuendel() == null || buendelung == null || !zeile.getBuendel().equals(buendelung)) || zeile.getVarianteId() != variante || zeile.getVerweis() != 0) continue;
            hatTeile = true;
            Double preis = zeile.getMinGesamtPreis(this.mAbPreiseMitSteuer);
            if (preis == null) continue;
            double aktTeilPreis = preis;
            log.debug("Preis des Teils " + zeile.getTeileNr() + ": " + Double.toString(aktTeilPreis));
            Double preisNivm = this.getNivmPreiseZuPos(zeile.getPos(), zeilen);
            if (preisNivm == null) {
                log.debug("NIVMS undefiniert");
                preis = null;
                continue;
            }
            log.debug("+ NIVMS " + Double.toString(aktTeilPreis += preisNivm.doubleValue()));
            if (abPreis != null && !(abPreis > aktTeilPreis)) continue;
            abPreis = new Double(aktTeilPreis);
        }
        if (abPreis == null) {
            if (hatTeile) {
                log.debug("abPreis ist nicht definiert");
                return null;
            }
            log.debug("abPreis 0 (keine Teile)");
            return new Double(0.0);
        }
        log.debug("abPreis " + Double.toString(abPreis));
        Double preisVerweis = this.getVerweisPreise(zeilen);
        if (preisVerweis == null) {
            log.debug("Verweispreis ist nicht definiert");
            return null;
        }
        abPreis = new Double(abPreis + preisVerweis);
        log.debug("+ Verweise " + Double.toString(abPreis));
        return abPreis;
    }

    private boolean getVarianteHatTeile(long variante, ArrayList zeilen) {
        for (PreisZeile zeile : zeilen) {
            if (zeile.getArt().equals("NIVM") || zeile.getArt().equals("NPZ") || zeile.getVerweis() != 0 || zeile.getVarianteId() != variante) continue;
            return true;
        }
        return false;
    }

    private Double getNivmPreiseZuPos(int pos, ArrayList zeilen) {
        double preis = 0.0;
        for (PreisZeile zeile : zeilen) {
            if (!zeile.getArt().equals("NIVM") || zeile.getGehZuPos() != pos) continue;
            Double preisZeile = zeile.getMinGesamtPreis(this.mAbPreiseMitSteuer);
            if (preisZeile == null) {
                return null;
            }
            preis += preisZeile.doubleValue();
        }
        return new Double(preis);
    }

    private Double getVerweisPreise(ArrayList zeilen) {
        double preisAlleVerw = 0.0;
        Double dMinPreisAktVerw = null;
        int aktVerw = 0;
        for (PreisZeile zeile : zeilen) {
            if (zeile.getVerweis() == 0) continue;
            Double preisAktZeile = zeile.getMinGesamtPreis(this.mAbPreiseMitSteuer);
            if (zeile.getVerweis() != aktVerw) {
                if (dMinPreisAktVerw != null) {
                    preisAlleVerw += dMinPreisAktVerw.doubleValue();
                }
                dMinPreisAktVerw = preisAktZeile;
                aktVerw = zeile.getVerweis();
                continue;
            }
            if (preisAktZeile == null) {
                if (dMinPreisAktVerw == null || dMinPreisAktVerw != 0.0) continue;
                dMinPreisAktVerw = null;
                continue;
            }
            if (dMinPreisAktVerw != null && (preisAktZeile == null || !(dMinPreisAktVerw > preisAktZeile))) continue;
            dMinPreisAktVerw = preisAktZeile;
        }
        if (aktVerw == 0) {
            log.debug("Kein verweis");
            return new Double(0.0);
        }
        if (dMinPreisAktVerw == null) {
            log.debug("Preis der Verweise undefiniert");
            return null;
        }
        log.debug("Preis der Verweise: " + Double.toString(preisAlleVerw += dMinPreisAktVerw.doubleValue()));
        return new Double(preisAlleVerw);
    }

    public Double getPreisZuSachnummer(String sachnummer) {
        PreisZeile zeile = this.findPreisZeileZuSachnummer(sachnummer);
        if (zeile != null) {
            return zeile.getGesamtPreis(1, this.mAbPreiseMitSteuer);
        }
        return null;
    }

    public double getRabattZuSachnummer(String sachnummer) {
        PreisZeile zeile = this.findPreisZeileZuSachnummer(sachnummer);
        if (zeile != null) {
            return zeile.getRabatt();
        }
        return 0.0;
    }

    public double getLagerbestandZuSachnummer(String sachnummer) {
        PreisZeile zeile = this.findPreisZeileZuSachnummer(sachnummer);
        if (zeile != null) {
            return zeile.getLagerbestand();
        }
        return 0.0;
    }

    public PreisZeile findPreisZeileZuSachnummer(String sachnummer) {
        for (PreisZeile zeile : this.mPreisZeilen) {
            if (zeile == null || zeile.getSachNr() == null) continue;
            String sachNrVgl = zeile.getSachNr();
            String sachNrFormatiert = WebetkUtils.formatiereSachnummer(sachNrVgl);
            if (!sachNrVgl.equals(sachnummer) && !sachNrFormatiert.equals(sachnummer)) continue;
            return zeile;
        }
        return null;
    }

    public double getMwstSatzZuSachnummer(String sachnummer) {
        PreisZeile zeile = this.findPreisZeileZuSachnummer(sachnummer);
        if (zeile != null) {
            return zeile.getMwSt();
        }
        return 0.0;
    }

    private double getPreisArbeit(String bnbNr, long varianteId, String baureihe) {
        double preis = 0.0;
        preis += this.getPreisArbeit("mech", bnbNr, varianteId, baureihe);
        preis += this.getPreisArbeit("elektr", bnbNr, varianteId, baureihe);
        preis += this.getPreisArbeit("progr", bnbNr, varianteId, baureihe);
        preis += this.getPreisArbeit("lack", bnbNr, varianteId, baureihe);
        return preis += this.getPreisArbeit("sonst", bnbNr, varianteId, baureihe);
    }

    private double getPreisArbeit(String art, String bnbNr, long varianteId, String baureihe) {
        if (art == null) {
            return 0.0;
        }
        double preis = 0.0;
        if (bnbNr == null && varianteId == 0L) {
            preis = this.getPreisArbeitBte(art, baureihe);
        } else if (bnbNr != null) {
            preis = this.getPreisArbeitBnb(art, bnbNr, baureihe);
        }
        if (bnbNr == null && varianteId > 0L) {
            preis += this.getPreisArbeitVariante(art, varianteId, baureihe);
        }
        return Math.floor(preis * 100.0 + 0.5) / 100.0;
    }

    private double getPreisArbeitBte(String art, String baureihe) {
        if (art == null) {
            return 0.0;
        }
        double preis = 0.0;
        EinbauInfo info = this.mEinbauinfosBte.get("OHNE");
        preis = this.getPreisArbeit(art, info);
        if (!baureihe.equals("OHNE")) {
            info = this.mEinbauinfosBte.get(baureihe);
            preis += this.getPreisArbeit(art, info);
        }
        return Math.floor(preis * 100.0 + 0.5) / 100.0;
    }

    private double getPreisArbeitBnb(String art, String bnbNr, String baureihe) {
        EinbauInfo info;
        if (art == null) {
            return 0.0;
        }
        double preis = 0.0;
        HashMap<String, EinbauInfo> einbauinfosZuBr = this.mEinbauinfosBnbs.get("OHNE");
        if (einbauinfosZuBr != null) {
            info = einbauinfosZuBr.get(bnbNr);
            preis = this.getPreisArbeit(art, info);
        }
        if (!baureihe.equals("OHNE") && (einbauinfosZuBr = this.mEinbauinfosBnbs.get(baureihe)) != null) {
            info = einbauinfosZuBr.get(bnbNr);
            preis += this.getPreisArbeit(art, info);
        }
        return Math.floor(preis * 100.0 + 0.5) / 100.0;
    }

    private double getPreisArbeitVariante(String art, long varianteId, String baureihe) {
        EinbauInfo info;
        if (art == null) {
            return 0.0;
        }
        if (varianteId == 0L) {
            return 0.0;
        }
        double preis = 0.0;
        HashMap<String, EinbauInfo> einbauinfosZuBr = this.mEinbauinfosVarianten.get("OHNE");
        if (einbauinfosZuBr != null) {
            info = einbauinfosZuBr.get(Long.toString(varianteId));
            preis += this.getPreisArbeit(art, info);
        }
        if (!baureihe.equals("OHNE") && (einbauinfosZuBr = this.mEinbauinfosVarianten.get(baureihe)) != null) {
            info = einbauinfosZuBr.get(Long.toString(varianteId));
            preis += this.getPreisArbeit(art, info);
        }
        return Math.floor(preis * 100.0 + 0.5) / 100.0;
    }

    private double getPreisArbeit(String art, EinbauInfo info) {
        if (art == null || info == null) {
            return 0.0;
        }
        int minuten = 0;
        minuten = art.equals("mech") ? (int)info.getMechanischerAufwand() : (art.equals("elektr") ? (int)info.getElektrischerAufwand() : (art.equals("progr") ? (int)info.getProgrammierAufwand() : (art.equals("lack") ? (int)info.getLackierAufwand() : (art.equals("sonst") ? (int)info.getSonstigerAufwand() : (int)info.getArbeitsAufwand()))));
        double preis = this.getPreisZuMinuten(art, minuten);
        preis = Math.floor(preis * 100.0 + 0.5) / 100.0;
        return preis;
    }

    public double getAWZuMinuten(String art, float minuten) {
        if (art == null || minuten == 0.0f) {
            return 0.0;
        }
        double minutenProAw = 6.0;
        minutenProAw = art.equals("mech") ? this.mAufwaende.getMechanischeArbeit().getAwMin() : (art.equals("elektr") ? this.mAufwaende.getElektrischeArbeit().getAwMin() : (art.equals("progr") ? this.mAufwaende.getProgrammierArbeit().getAwMin() : (art.equals("lack") ? this.mAufwaende.getLackierArbeit().getAwMin() : (art.equals("sonst") ? this.mAufwaende.getSonstigeArbeit().getAwMin().doubleValue() : this.mAufwaende.getArbeitAufwand().getAwMin().doubleValue()))));
        double aW = (double)minuten / minutenProAw;
        return Math.floor(aW + 0.5);
    }

    public float getMinutenZuAW(String awNummer, float aw) {
        if (awNummer == null || aw == 0.0f) {
            return 0.0f;
        }
        float minutenProAw = 0.0f;
        minutenProAw = this.mAufwaende.getMechanischeArbeit() != null ? (awNummer.equals(this.mAufwaende.getMechanischeArbeit().getId()) ? this.mAufwaende.getMechanischeArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getElektrischeArbeit().getId()) ? this.mAufwaende.getElektrischeArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getProgrammierArbeit().getId()) ? this.mAufwaende.getProgrammierArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getLackierArbeit().getId()) ? this.mAufwaende.getLackierArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getSonstigeArbeit().getId()) ? this.mAufwaende.getSonstigeArbeit().getAwMin().floatValue() : this.mAufwaende.getArbeitAufwand().getAwMin().floatValue()))))) : this.mAufwaende.getArbeitAufwand().getAwMin().floatValue();
        return aw * minutenProAw;
    }

    public float getMinutenZuAW(String awNummer, int aw) {
        if (awNummer == null || aw == 0) {
            return 0.0f;
        }
        float minutenProAw = 0.0f;
        minutenProAw = this.mAufwaende.getMechanischeArbeit() != null ? (awNummer.equals(this.mAufwaende.getMechanischeArbeit().getId()) ? this.mAufwaende.getMechanischeArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getElektrischeArbeit().getId()) ? this.mAufwaende.getElektrischeArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getProgrammierArbeit().getId()) ? this.mAufwaende.getProgrammierArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getLackierArbeit().getId()) ? this.mAufwaende.getLackierArbeit().getAwMin().floatValue() : (awNummer.equals(this.mAufwaende.getSonstigeArbeit().getId()) ? this.mAufwaende.getSonstigeArbeit().getAwMin().floatValue() : this.mAufwaende.getArbeitAufwand().getAwMin().floatValue()))))) : this.mAufwaende.getArbeitAufwand().getAwMin().floatValue();
        return (float)aw * minutenProAw;
    }

    public double getPreisZuAw(String art, double aw, boolean bNetto) {
        if (art == null || aw == 0.0) {
            return 0.0;
        }
        if (art == null || aw == 0.0) {
            return 0.0;
        }
        double preisProAw = 0.0;
        preisProAw = art.equals("mech") ? this.mAufwaende.getMechanischeArbeit().getPreis() : (art.equals("elektr") ? this.mAufwaende.getElektrischeArbeit().getPreis() : (art.equals("progr") ? this.mAufwaende.getProgrammierArbeit().getPreis() : (art.equals("lack") ? this.mAufwaende.getLackierArbeit().getPreis() : (art.equals("sonst") ? this.mAufwaende.getSonstigeArbeit().getPreis().doubleValue() : this.mAufwaende.getArbeitAufwand().getPreis().doubleValue()))));
        double preis = aw * preisProAw;
        if (!bNetto && this.mAbPreiseMitSteuer) {
            double mwst = preis * this.mdMwStArbeit / 100.0;
            mwst = Math.floor(mwst * 100.0 + 0.5) / 100.0;
            preis += mwst;
            preis = Math.floor(preis * 100.0 + 0.5) / 100.0;
        }
        return preis;
    }

    public double getPreisZuMinuten(String art, int minuten) {
        if (art == null || minuten == 0) {
            return 0.0;
        }
        double aW = this.getAWZuMinuten(art, minuten);
        boolean bNetto = false;
        double preis = this.getPreisZuAw(art, aW, bNetto);
        return preis;
    }

    public void addEinbauinfo(String art, String key, String baureihe, EinbauInfo info) {
        if (art == null || info == null) {
            return;
        }
        if (baureihe == null || baureihe.length() == 0) {
            baureihe = "OHNE";
        }
        if (art.equals("BTE")) {
            this.mEinbauinfosBte.put(baureihe, info);
        } else if (art.equals("BNB")) {
            HashMap<String, EinbauInfo> einbauinfosZuBr = this.mEinbauinfosBnbs.get(baureihe);
            if (einbauinfosZuBr == null) {
                einbauinfosZuBr = new HashMap();
            }
            einbauinfosZuBr.put(key, info);
            this.mEinbauinfosBnbs.put(baureihe, einbauinfosZuBr);
        } else if (art.equals("VAR")) {
            HashMap<String, EinbauInfo> einbauinfosZuBr = this.mEinbauinfosVarianten.get(baureihe);
            if (einbauinfosZuBr == null) {
                einbauinfosZuBr = new HashMap();
            }
            einbauinfosZuBr.put(key, info);
            this.mEinbauinfosVarianten.put(baureihe, einbauinfosZuBr);
        }
    }

    public String getBtenr() {
        return this.mBteNr;
    }

    public void setBtenr(String btenr) {
        this.mBteNr = btenr;
    }

    public FzgSucheInfo getFahrzeug() {
        return this.mFahrzeug;
    }

    public void setAbPreiseMitSteuer(boolean abPreiseMitSteuer) {
        this.mAbPreiseMitSteuer = abPreiseMitSteuer;
    }
}

