/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.Logger;
import webetk.communication.Cachable;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Transferable;
import webetk.communication.utils.EasySSLProtocolSocketFactory;

public class CommController {
    private LinkedList<Transferable> m_collTransferables;
    private String m_ServerUrl = null;
    protected Logger log = Logger.getLogger(CommController.class);
    private static CommController m_theInstance = null;
    private CommThread m_objCommThread;
    private HostConfiguration m_hostConfiguration = null;
    private Credentials m_Credentials = null;
    private String m_CredentialRealm = null;
    private String m_CredentialHost = null;
    public static Map<String, String> mCookies = new HashMap<String, String>();
    private HttpClient client = new HttpClient();

    private CommController() {
        this.m_collTransferables = new LinkedList();
        Protocol myhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)myhttps);
        this.log.debug("https protocol registered!");
        this.createCommThread();
    }

    public static synchronized CommController getInstance() {
        if (m_theInstance == null) {
            m_theInstance = new CommController();
            CommController.m_theInstance.log.info("CommController: comm controller created");
        }
        if (CommController.m_theInstance.m_objCommThread == null) {
            CommController.m_theInstance.log.info("CommController: create comm thread on getInstance");
            m_theInstance.createCommThread();
        }
        return m_theInstance;
    }

    private HostConfiguration getHostConfig() {
        return this.m_hostConfiguration;
    }

    private void setHostConfig(HostConfiguration c) {
        this.log.debug("Setting host config to: " + c.toString());
        this.m_hostConfiguration = c;
    }

    public void init(String sServerUrl) throws Exception {
        if (sServerUrl == null || sServerUrl.length() < 1) {
            this.log.error("Can not initialize communication layer with empty URL.");
            throw new Exception("Can not initialize communication layer with empty URL.");
        }
        this.m_ServerUrl = sServerUrl;
        this.log.info("URL to server: " + this.m_ServerUrl);
        if (this.getHostConfig() != null) {
            this.getHostConfig().setProxy(null, 0);
        }
        this.m_Credentials = null;
    }

    public void init(String sServerUrl, String sProxyName, int nProxyPort, String sProxyRealm, String sProxyHost, String sProxyUser, String sProxyPassword, String sNtDomain, String sNtHost) throws Exception {
        if (sServerUrl == null || sServerUrl.length() < 1) {
            this.log.error("Can not initialize communication layer with empty URL.");
            throw new Exception("Can not initialize communication layer with empty URL.");
        }
        this.m_ServerUrl = sServerUrl;
        this.log.info("URL to server: " + this.m_ServerUrl);
        URL url = new URL(sServerUrl);
        this.log.debug("Configuring to server: " + sServerUrl);
        this.setHostConfig(new HostConfiguration());
        this.getHostConfig().setHost(url.getHost(), url.getPort());
        if (sProxyName != null) {
            this.getHostConfig().setProxy(sProxyName, nProxyPort);
            this.log.debug("Using Proxy " + sProxyName + " on port " + Integer.toString(nProxyPort) + " / " + this.getHostConfig().toString());
        }
        this.m_Credentials = null;
        if (sNtDomain != null) {
            this.m_Credentials = new NTCredentials(sProxyUser, sProxyPassword, sNtHost, sNtDomain);
            this.log.debug("Using NT Credentials: " + this.m_Credentials);
        } else {
            this.m_Credentials = new UsernamePasswordCredentials(sProxyUser, sProxyPassword);
            this.log.debug("Using Credentials: " + this.m_Credentials);
        }
    }

    public void setTimeouts(int nConnectionTimeout, int nSocketTimeout, int nHttpConnectionFactoryTimeout) {
        this.client.setConnectionTimeout(nConnectionTimeout * 1000);
        this.client.setTimeout(nSocketTimeout * 1000);
        this.client.setHttpConnectionFactoryTimeout((long)nHttpConnectionFactoryTimeout * 1000L);
        this.log.debug("Connection Timeout (seconds): " + Integer.toString(nConnectionTimeout) + ", SocketTimeout: " + Integer.toString(nSocketTimeout) + ", Timeout Factory: " + Integer.toString(nHttpConnectionFactoryTimeout));
    }

    public static synchronized void stop() {
        if (m_theInstance == null) {
            return;
        }
        CommController.m_theInstance.log.info("CommController: stop comm thread");
        if (CommController.m_theInstance.m_objCommThread != null) {
            CommController.m_theInstance.m_objCommThread.stopThread();
            CommController.m_theInstance.m_objCommThread = null;
            CommController.m_theInstance.m_collTransferables.clear();
        }
    }

    public static synchronized void destroyInstance() {
        if (m_theInstance == null) {
            return;
        }
        CommController.m_theInstance.log.debug("CommController: ########## destroy instance ##########");
        if (CommController.m_theInstance.m_objCommThread == Thread.currentThread()) {
            CommController.m_theInstance.log.debug("CommController: destroy comm controller within comm thread");
            CommController.m_theInstance.m_objCommThread.m_bStopThread = true;
            CommController.m_theInstance.m_collTransferables.clear();
            CommController.m_theInstance.m_collTransferables = null;
            CommController.m_theInstance.m_objCommThread.m_bDestroyOnEnd = true;
        } else {
            if (CommController.m_theInstance.m_objCommThread != null) {
                CommController.m_theInstance.m_objCommThread.endThread();
                try {
                    CommController.m_theInstance.m_objCommThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            CommController.m_theInstance.m_collTransferables.clear();
            CommController.m_theInstance.m_collTransferables = null;
            m_theInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncComm(Transferable trf) {
        if (this.m_objCommThread == null || !this.m_objCommThread.isAlive()) {
            CommController.m_theInstance.log.warn("CommController::doAsyncComm: communication thread is not alive");
            this.m_objCommThread = new CommThread();
            this.m_objCommThread.waitForStart();
        }
        if (trf != null) {
            CommController.m_theInstance.log.debug("CommController:doAsyncComm with " + trf.getClass().getName() + "; command ID " + trf.getCommand());
            LinkedList<Transferable> linkedList = this.m_collTransferables;
            synchronized (linkedList) {
                this.m_collTransferables.addLast(trf);
                this.m_collTransferables.notifyAll();
            }
        }
    }

    private synchronized boolean doSyncComm(Transferable trf) throws CommunicationException {
        if (this.m_objCommThread == null) {
            return false;
        }
        if (this.fillFromCache(trf)) {
            return true;
        }
        this.m_objCommThread.enable(false);
        CommController.m_theInstance.log.debug("CommController:doSyncComm with " + trf.getClass().getName() + "; command ID " + trf.getCommand());
        boolean bRet = this.doCommunication(trf);
        this.m_objCommThread.enable(true);
        return bRet;
    }

    private void createCommThread() {
        this.m_objCommThread = new CommThread();
    }

    private boolean fillFromCache(Transferable trf) {
        if (trf instanceof Cachable) {
            return ((Cachable)((Object)trf)).fillFromCache();
        }
        return false;
    }

    protected String getServerURL() {
        return this.m_ServerUrl;
    }

    private boolean doCommunication(Transferable trfToSend) throws CommunicationException {
        return this.doCommunicationApacheCommonsHTTPClient(trfToSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doCommunicationApacheCommonsHTTPClient(Transferable trfToSend) throws CommunicationException {
        trfToSend.setError(null);
        try {
            if (this.getServerURL() == null) {
                this.log.error("Not properly initialized! Server URL is missing.");
                throw new CommunicationException("Not properly initialized! Server URL is missing.");
            }
            PostMethod post = null;
            try {
                boolean bl;
                boolean useQM;
                if (this.getHostConfig() != null) {
                    this.log.debug("Setting host configuration to: " + this.getHostConfig().toString());
                    this.client.setHostConfiguration(this.getHostConfig());
                }
                if (this.m_Credentials != null) {
                    this.log.debug("Setting Credentials to: " + this.m_Credentials.toString());
                    this.client.getState().setProxyCredentials(this.m_CredentialRealm, this.m_CredentialHost, this.m_Credentials);
                }
                this.client.getState().setAuthenticationPreemptive(true);
                if (this.log.isDebugEnabled()) {
                    this.logHttpClient(this.client);
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream streamOut = new ObjectOutputStream(bos);
                Transferable.send(streamOut, trfToSend);
                streamOut.close();
                bos.close();
                byte[] arr = bos.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(arr);
                StringBuffer sServerUrl = new StringBuffer(this.getServerURL());
                boolean bl2 = useQM = this.getServerURL().indexOf(63) == -1;
                if (trfToSend.getServerParameter() != null) {
                    Set<String> theKeys = trfToSend.getServerParameter().keySet();
                    for (String key : theKeys) {
                        String value = trfToSend.getServerParameter().get(key);
                        this.log.debug("Rewriting Parameter <" + key.toString() + "> at server URL with value: " + value.toString());
                        sServerUrl.append(useQM ? "?" : "&").append((Object)key).append("=").append((Object)value);
                    }
                }
                this.log.debug("Connecting to server with URL: " + sServerUrl.toString());
                post = new PostMethod(sServerUrl.toString());
                HostConfiguration hostConfig = post.getHostConfiguration();
                if (hostConfig.getHost().indexOf("_") > -1) {
                    int port = hostConfig.getPort();
                    int nStart = sServerUrl.toString().lastIndexOf(":") + 1;
                    int nEnde = sServerUrl.toString().indexOf("/", nStart);
                    String sPort = sServerUrl.toString().substring(nStart, nEnde);
                    port = Integer.parseInt(sPort);
                    hostConfig.setHost(hostConfig.getHost(), port);
                }
                post.setRequestHeader("Content-type", "application/x-javaserializedobject webetk.communication.transferables.Transferable");
                post.setRequestBody((InputStream)bis);
                if (this.log.isDebugEnabled()) {
                    this.logHttpMethod((HttpMethod)post);
                }
                this.client.executeMethod((HttpMethod)post);
                Cookie[] cookies = this.client.getState().getCookies();
                mCookies = new HashMap<String, String>();
                for (int i = 0; i < cookies.length; ++i) {
                    this.log.debug("Cookies: " + cookies[i].toString());
                    mCookies.put(cookies[i].getName(), cookies[i].getValue());
                }
                if (this.log.isDebugEnabled()) {
                    this.logHttpMethod((HttpMethod)post);
                }
                bis.close();
                ObjectInputStream streamIn = null;
                try {
                    streamIn = new ObjectInputStream(post.getResponseBodyAsStream());
                }
                catch (Exception ex) {
                    String sResponse = post.getResponseBodyAsString();
                    this.log.error(sResponse);
                    trfToSend.setError(new Exception(ex.getMessage()));
                    CommController.m_theInstance.log.debug("Exception: " + ex.getClass().getName());
                    boolean bl3 = false;
                    this.log.debug("Releasing HTTPClient connection");
                    if (post == null) return bl3;
                    post.releaseConnection();
                    return bl3;
                }
                Transferable trfRead = Transferable.read(streamIn);
                streamIn.close();
                Cookie[] myCookies = this.client.getState().getCookies();
                for (int i = 0; i < myCookies.length; ++i) {
                    this.log.debug("Cookies: " + myCookies[i].toString());
                }
                if (!trfToSend.hasSameIdAs(trfRead)) {
                    this.log.error("CommController: ID's do not match");
                    trfToSend.setError(new Exception("CommController: ID's do not match"));
                    bl = false;
                    return bl;
                }
                trfToSend.copyData(trfRead);
                if (trfToSend.getError() != null) {
                    this.log.error("CommController: received exception", trfToSend.getError());
                    bl = false;
                    return bl;
                }
                if (trfToSend instanceof Cachable) {
                    ((Cachable)((Object)trfToSend)).storeInCache();
                }
                bl = true;
                return bl;
            }
            finally {
                this.log.debug("Releasing HTTPClient connection");
                if (post != null) {
                    post.releaseConnection();
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.log.error("Could not create object from stream!", e);
            trfToSend.setError(e);
            return false;
        }
        catch (ClassCastException e) {
            this.log.error("Could not cast the retrieved object to its assigned class!", e);
            trfToSend.setError(e);
            return false;
        }
        catch (IOException e) {
            this.log.error("Error during communication!", e);
            trfToSend.setError(e);
        }
        return false;
    }

    private void logHttpClient(HttpClient client) {
        HttpState state;
        this.log.debug("CLIENT------------------------------------------------------------------");
        this.log.debug("Client state: " + client.getState().toString());
        this.log.debug("Client state: " + client.getHostConfiguration().toString());
        this.log.debug("Host: " + client.getHostConfiguration().getHost());
        try {
            this.log.debug("HostURL: " + client.getHostConfiguration().getHostURL());
        }
        catch (IllegalStateException e) {
            this.log.debug("HostURL: " + e.getMessage());
        }
        this.log.debug("Host Port: " + client.getHostConfiguration().getPort());
        this.log.debug("Proxy: " + client.getHostConfiguration().getProxyHost());
        this.log.debug("Proxy Port: " + client.getHostConfiguration().getProxyPort());
        this.log.debug("Virtual Host: " + client.getHostConfiguration().getVirtualHost());
        this.log.debug("Local Adress: " + client.getHostConfiguration().getLocalAddress());
        if (client.getHostConfiguration().getLocalAddress() != null) {
            this.log.debug("** Host Adress: " + client.getHostConfiguration().getLocalAddress().getHostAddress());
            this.log.debug("** Host Name: " + client.getHostConfiguration().getLocalAddress().getHostName());
        }
        this.log.debug("Protocol: " + client.getHostConfiguration().getProtocol());
        if (client.getHostConfiguration().getProtocol() != null) {
            this.log.debug("** Default Port: " + client.getHostConfiguration().getProtocol().getDefaultPort());
            this.log.debug("** Scheme: " + client.getHostConfiguration().getProtocol().getScheme());
        }
        if ((state = client.getState()) != null) {
            this.log.debug("## Credentials: " + state.getCredentials(null, null));
            this.log.debug("## Proxy Credentials: " + state.getProxyCredentials(null, null));
        }
        this.log.debug("------------------------------------------------------------------------");
    }

    private void logHttpMethod(HttpMethod method) {
        this.log.debug("METHOD------------------------------------------------------------------");
        this.log.debug("Name: " + method.getName());
        this.log.debug("Path: " + method.getPath());
        this.log.debug("QueryString: " + method.getQueryString());
        this.log.debug("Status Line: " + method.getStatusLine());
        if (method.getStatusLine() != null) {
            this.log.debug("Status Code: " + method.getStatusCode());
            this.log.debug("Status: " + method.getStatusText());
        }
        this.log.debug("Do Authentification: " + method.getDoAuthentication());
        this.log.debug("Follow Redirects: " + method.getFollowRedirects());
        this.log.debug("Name: " + method.getStatusLine());
        this.log.debug("------------------------------------------------------------------------");
    }

    public String toString() {
        return "m_ServerUrl: " + this.m_ServerUrl + " client: " + this.client + " m_Credentials: " + this.m_Credentials;
    }

    private class CommThread
    extends Thread {
        private boolean m_bStopThread = false;
        private boolean m_bEnableSend = true;
        private boolean m_bDestroyOnEnd = false;
        private boolean m_bHasStarted = false;
        protected Logger log1 = Logger.getLogger(CommThread.class);

        public CommThread() {
            this.start();
            this.log1.debug("Communication thread started.");
        }

        public synchronized void enable(boolean p_bEnable) {
            this.m_bEnableSend = p_bEnable;
            if (p_bEnable) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endThread() {
            Object object = this;
            synchronized (object) {
                this.m_bStopThread = true;
                this.notifyAll();
                this.log1.debug("Communication thread ended.");
            }
            object = CommController.this.m_collTransferables;
            synchronized (object) {
                CommController.this.m_collTransferables.notifyAll();
            }
        }

        public void stopThread() {
            this.m_bStopThread = true;
            this.interrupt();
            this.log1.debug("Communication thread stopped.");
        }

        public synchronized void waitForStart() {
            if (!this.m_bHasStarted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bStopThread = false;
            this.log1.debug("Communication thread is about to run");
            Object object = this;
            synchronized (object) {
                bStopThread = this.m_bStopThread;
                this.m_bHasStarted = true;
                this.notifyAll();
            }
            this.log1.debug("Communication thread now running.");
            while (!bStopThread) {
                Transferable trfToSend;
                object = CommController.this.m_collTransferables;
                synchronized (object) {
                    if (CommController.this.m_collTransferables.size() == 0) {
                        try {
                            CommController.this.m_collTransferables.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    trfToSend = CommController.this.m_collTransferables.size() > 0 ? (Transferable)CommController.this.m_collTransferables.removeFirst() : null;
                }
                object = this;
                synchronized (object) {
                    while (!this.m_bEnableSend && !this.m_bStopThread) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (trfToSend != null && !this.m_bStopThread && !CommController.this.fillFromCache(trfToSend)) {
                        trfToSend.startAsyncComm();
                        try {
                            CommController.this.doCommunication(trfToSend);
                        }
                        catch (CommunicationException e) {
                            this.log1.error("Could not perform communication!", e);
                            this.m_bStopThread = true;
                        }
                        if (!this.m_bStopThread) {
                            CommThread.yield();
                        }
                    }
                    bStopThread = this.m_bStopThread;
                }
                if (trfToSend == null || bStopThread) continue;
                trfToSend.notifyObservers();
                trfToSend.endAsyncComm();
                trfToSend = null;
            }
            if (this.m_bDestroyOnEnd) {
                this.log1.info("Destroying CommController instance from within communication thread.");
                m_theInstance = null;
            }
            CommController.this.log.debug("###### comm thread is dead ######");
        }
    }
}

