/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.app.ServerGlobalObjects;
import webetk.app.admintool.DBConnection;
import webetk.app.admintool.DBSicherung;
import webetk.app.admintool.Sprache;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.command.TrfTeilesucheCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.JaxbObjectArray;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfAdminTool;
import webetk.db.dbaccess.AdminToolDbAccess;
import webetk.javaserver.app.GlobalObjects;

public class TrfAdminToolCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfTeilesucheCommand.class);
    private static boolean lockTable = false;

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfAdminTool transferableMap = (TrfAdminTool)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.NO_OPERATION.equals(command)) {
            return;
        }
        if (Command.DB_ERZEUGE_PREISE.equals(command)) {
            this.log.debug("command id " + Command.DB_ERZEUGE_PREISE);
            this.dbErzeugePreise(transferableMap);
            return;
        }
        if (Command.DB_LOESCHE_LOCK_PREISE.equals(command)) {
            this.dbLoescheLockPreise(transferableMap);
            return;
        }
        if (Command.DB_UNLOCK_PREISE.equals(command)) {
            this.dbUnlockPreise(transferableMap);
            return;
        }
        if (Command.DB_ERZEUGEN_SICHERUNG.equals(command)) {
            this.dbErzeugenSicherung(transferableMap);
            return;
        }
        if (Command.DB_EINLESEN_SICHERUNG.equals(command)) {
            this.dbEinlesenSicherung(transferableMap);
            return;
        }
        if (Command.DB_LADE_SPRACHEN.equals(command)) {
            this.dbLadeSprachen(transferableMap);
            return;
        }
        if (Command.DB_LADE_VERSIONINFO.equals(command)) {
            this.dbVersionInfo(transferableMap);
            return;
        }
        if (Command.IGDOMACCESS.equals(command)) {
            this.igdomAccess(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void dbLoescheLockPreise(TrfAdminTool transferableMap) {
        String msFirma = (String)transferableMap.getValue("firmaid");
        boolean bUpdate = ((String)transferableMap.getValue("UPDATE")).compareTo("true") == 0;
        this.log.debug("connecting");
        Connection connection = null;
        boolean closeOnException = false;
        try {
            boolean bOK;
            connection = ServerGlobalObjects.getInstance().getDBConnectionPreise("dbLoescheLockPreise");
            this.log.debug("firma: " + msFirma + " update: " + bUpdate + " working dir: " + System.getProperty("user.dir"));
            closeOnException = true;
            connection.setAutoCommit(true);
            boolean bFirmaIsTheOnlyOne = AdminToolDbAccess.isFirmaIdTheOnlyOneInPreise(connection, msFirma);
            int nCount = DBConnection.getCountPreise(connection, msFirma);
            bUpdate = nCount == 0 ? false : bUpdate;
            connection.setAutoCommit(false);
            if (lockTable && !(bOK = AdminToolDbAccess.lockTable(connection, "w_preise", "UPDATE"))) {
                transferableMap.setError(new Exception("NO_TABLE_LOCK"));
                return;
            }
            if (!bUpdate) {
                AdminToolDbAccess.loeschePreise(connection, msFirma, bFirmaIsTheOnlyOne);
            }
            connection.commit();
            ServerGlobalObjects.getInstance().freeDBConnectionPreise(connection, "dbLoescheLockPreise");
        }
        catch (Exception e) {
            this.log.error("error on lock or delete preise", e);
            try {
                if (closeOnException && connection != null) {
                    connection.close();
                }
            }
            catch (SQLException ex) {
                this.log.error("error on closing connection dbLoescheLockPreise", ex);
            }
            transferableMap.setError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbErzeugePreise(TrfAdminTool transferableMap) {
        String errMsg = null;
        Exception e = null;
        try {
            String msFirma = (String)transferableMap.getValue("firmaid");
            boolean bUpdate = ((String)transferableMap.getValue("UPDATE")).compareTo("true") == 0;
            ArrayList recordList = (ArrayList)transferableMap.getValue("RECORDLIST");
            ArrayList<String[]> stringArrayList = new ArrayList<String[]>();
            for (JaxbObjectArray stringJaxbObjectArray : recordList) {
                stringArrayList.add(stringJaxbObjectArray.toArray(new String[0]));
            }
            DBConnection.erzeugePreise(stringArrayList, bUpdate, msFirma);
            transferableMap.getHashMap().clear();
        }
        catch (SQLException ex) {
            errMsg = "internal Error";
            e = ex;
        }
        catch (DatabaseBusyException ex) {
            errMsg = "database busy";
            e = ex;
        }
        catch (Exception ex) {
            errMsg = "error on create preise";
            e = ex;
        }
        finally {
            if (errMsg != null) {
                this.log.error(errMsg, e);
                transferableMap.setError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbUnlockPreise(TrfAdminTool transferableMap) {
        this.log.debug("unlock w_preise");
        Connection connection = null;
        if (lockTable) {
            try {
                connection = ServerGlobalObjects.getInstance().getDBConnectionPreise("dbUnlockPreise");
                AdminToolDbAccess.unlockTable(connection, "w_preise");
                connection.commit();
            }
            catch (Exception e) {
                this.log.error("error on unlocking w_preise", e);
                transferableMap.setError(e);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.log.error("SQL error on closing connection", e);
                    e.printStackTrace();
                }
            }
        }
    }

    private void dbErzeugenSicherung(TrfAdminTool trfSicherung) {
        DBSicherung.setDbPass((String)trfSicherung.getValue("DBPASS"));
        DBSicherung.setSavDir(this.getSicherungsDir());
        List retList = DBSicherung.sichereEtkNutzer();
        this.prepareSicherungReturnList(retList, trfSicherung);
    }

    private void dbEinlesenSicherung(TrfAdminTool trfSicherung) {
        DBSicherung.setDbPass((String)trfSicherung.getValue("DBPASS"));
        DBSicherung.setSavDir(this.getSicherungsDir());
        int retCode = DBSicherung.ladeEtkNutzer();
        this.prepareSicherungReturn(retCode, trfSicherung);
    }

    private String getSicherungsDir() {
        String sicherungsDir = "D:\\ETK";
        return sicherungsDir;
    }

    private void prepareSicherungReturn(int retCode, TrfAdminTool trfSicherung) {
        trfSicherung.getHashMap().clear();
        trfSicherung.setValue("RETCODE", new Integer(retCode));
        if (retCode >= 1000) {
            trfSicherung.setError(DBSicherung.getExceptionOccured());
        }
    }

    private void prepareSicherungReturnList(List retList, TrfAdminTool trfSicherung) {
        trfSicherung.getHashMap().clear();
        int retCode = Integer.parseInt(retList.get(0).toString());
        trfSicherung.setValue("RETCODE", new Integer(retCode));
        if (retList.size() > 1 && retList.get(1) != null) {
            trfSicherung.setValue("FILESIZE", (Long)retList.get(1));
        }
        if (retCode >= 1000) {
            trfSicherung.setError(DBSicherung.getExceptionOccured());
        }
    }

    private void dbLadeSprachen(TrfAdminTool trfSprachen) {
        ArrayList<Sprache> sprachen;
        try {
            sprachen = DBConnection.ladeSprachen();
        }
        catch (Exception e) {
            sprachen = null;
            trfSprachen.setError(e);
        }
        trfSprachen.setValue("sprachen", sprachen);
    }

    private void dbVersionInfo(TrfAdminTool trfSprachen) {
        try {
            String[] versionInfo = DBConnection.ladeVersionInfo();
            trfSprachen.setValue("DB_VERSION", versionInfo[0]);
            trfSprachen.setValue("DB_DATEN_VOM", versionInfo[1]);
        }
        catch (Exception e) {
            trfSprachen.setError(e);
        }
    }

    private void igdomAccess(TrfAdminTool transferableMap) {
        this.log.debug("igdomAccess");
        int imode = (Integer)transferableMap.getValue("IGDOMACCESS");
        GlobalObjects globs = GlobalObjects.getInstance();
        switch (imode) {
            case 1: {
                globs.setIgdomAccess(true);
                break;
            }
            case 2: {
                globs.setIgdomAccess(false);
                break;
            }
            case 3: {
                imode = globs.isIgdomAccess() ? 1 : 2;
                break;
            }
        }
        transferableMap.setValue("RETCODE", new Integer(imode));
    }

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfAdminTool)) {
            this.log.error("Given transferable must be TrfAdminTool, but it isn't!");
            throw new ClassCastException("TrfAdminTool excepted!");
        }
        super.setTransferable(trf);
    }
}

