/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.app.clientadmintool.LokaleSicherung;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfDatei;

public class TrfDateiCommand
extends AbstractTransferableCommand {
    private static Logger log = Logger.getLogger(TrfDateiCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfDatei)) {
            log.error("Given transferable must be TrfDatei, but it isn't!");
            throw new ClassCastException("TrfDatei excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        Command command = this.transferable.getCommand();
        log.debug("Executing command: " + command);
        if (Command.SAVE_ETKNUTZER.equals(command)) {
            this.putDataToTrf();
            return;
        }
        if (Command.SAVE_AKTUELLEVERSION.equals(command)) {
            this.putVersionToTrf();
            return;
        }
        if (Command.LOAD_AKTUELLEVERSION.equals(command)) {
            this.setVersionToDir();
            return;
        }
        if (Command.LOAD_ETKNUTZER.equals(command)) {
            this.setDataToDir();
            return;
        }
        log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void putVersionToTrf() {
        TrfDatei trfDatei = (TrfDatei)this.transferable;
        trfDatei.setDateiName(LokaleSicherung.getVersionSicherungFile());
        try {
            trfDatei.storeByteArray(LokaleSicherung.getVersionToArray());
        }
        catch (Exception ex) {
            trfDatei.setError(ex);
        }
    }

    private void setVersionToDir() {
        TrfDatei trfDatei = (TrfDatei)this.transferable;
        String sPath = LokaleSicherung.getSicherungsDir() + "\\TEMP";
        File oDirectory = new File(sPath);
        if (!oDirectory.exists() && !oDirectory.mkdirs()) {
            trfDatei.setReturnCode(1002);
            return;
        }
        try {
            LokaleSicherung.setArrayInDatei(sPath, trfDatei.getDateiName(), trfDatei.toByteArray(), false);
            trfDatei.setReturnCode(0);
        }
        catch (Exception ex) {
            trfDatei.setError(ex);
            trfDatei.setReturnCode(1002);
        }
    }

    public void putDataToTrf() {
        TrfDatei trfDatei = (TrfDatei)this.transferable;
        try {
            trfDatei.setDateiName(LokaleSicherung.getDataFileName());
            log.info("putDataToTrf  Filename: " + trfDatei.getDateiName() + " mit Paketnummer : " + trfDatei.getPaketNummer());
            this.teileDaten(LokaleSicherung.getDataToArray(), trfDatei.getPaketNummer());
        }
        catch (Exception ex) {
            trfDatei.setError(ex);
        }
    }

    private void teileDaten(byte[] data, int paketNr) {
        TrfDatei trfDatei = (TrfDatei)this.transferable;
        byte[] divData = new byte[this.getMaxByteCount()];
        trfDatei.setPaketNummer(paketNr + 1);
        log.info("Teiledaten mit Packetnummer " + ++paketNr);
        if (data.length > this.getMaxByteCount()) {
            trfDatei.setGesamtanzahlPakete(data.length / this.getMaxByteCount() + 1);
            int startpos = this.getMaxByteCount() * (paketNr - 1);
            int anzahlByte = data.length - this.getMaxByteCount() * paketNr;
            anzahlByte = data.length - this.getMaxByteCount() * paketNr > 0 ? this.getMaxByteCount() : data.length - startpos;
            divData = new byte[anzahlByte];
            for (int i = 0; i < anzahlByte; ++i) {
                divData[i] = data[startpos + i];
            }
        } else {
            trfDatei.storeByteArray(data);
            trfDatei.setGesamtanzahlPakete(1);
            return;
        }
        trfDatei.storeByteArray(divData);
    }

    private int getMaxByteCount() {
        return 30000000;
    }

    private void setDataToDir() {
        TrfDatei trfDatei = (TrfDatei)this.transferable;
        String sPath = LokaleSicherung.getSicherungsDir() + "\\TEMP";
        try {
            if (trfDatei.getPaketNummer() == 1) {
                LokaleSicherung.setArrayInDatei(sPath, trfDatei.getDateiName(), trfDatei.toByteArray(), false);
            } else {
                LokaleSicherung.setArrayInDatei(sPath, trfDatei.getDateiName(), trfDatei.toByteArray(), true);
            }
            if (trfDatei.getPaketNummer() == trfDatei.getGesamtanzahlPakete()) {
                LokaleSicherung.deleteFile(new File(LokaleSicherung.getVersionSicherungFile()));
                LokaleSicherung.deleteFile(new File(LokaleSicherung.getDataFileName()));
                LokaleSicherung.copyDir(new File(sPath), new File(LokaleSicherung.getSicherungsDir()));
                LokaleSicherung.deleteDir(new File(sPath));
            }
            trfDatei.storeByteArray(null);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), e);
            trfDatei.setError(e);
        }
        catch (IOException e) {
            log.error("IOException in setDataDir() " + e.getMessage(), e);
            trfDatei.setError(e);
        }
    }
}

