/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.UserHandlingException;
import webetk.WebetkUtils;
import webetk.app.Bedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.FGs;
import webetk.app.FunktionsgruppeTO;
import webetk.app.GenericTeil;
import webetk.app.HGFGs;
import webetk.app.HauptgruppeTO;
import webetk.app.ImageCache;
import webetk.app.Markt;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SessionInfoDez;
import webetk.app.SucheInfo;
import webetk.app.ValueAndNameSupport;
import webetk.app.aspg.Teil;
import webetk.app.aspg.TeilHelper;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.auswertung.User;
import webetk.app.basesuche.BaseHgFgSuche;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.bteanzeige.Textteil;
import webetk.app.bteinfo.Info;
import webetk.app.erstbevorratung.Erstbevorratung;
import webetk.app.etktext.ETKTexte;
import webetk.app.federtabelle.FTZeilen;
import webetk.app.federtabelle.FedertabelleInfo;
import webetk.app.fuellmengen.FMZeilen;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.fzgsuche.HGFGSuche;
import webetk.app.fzgumfang.FzgUmfang;
import webetk.app.hilfe.Abkuerzungsliste;
import webetk.app.hilfe.Attributlisten;
import webetk.app.hilfe.Salapaliste;
import webetk.app.hilfe.VersionInfo;
import webetk.app.infotool.InfoObject;
import webetk.app.infotool.InfoObjectText;
import webetk.app.infotool.TickerText;
import webetk.app.infotool.XMLInfoObjectText;
import webetk.app.infotool.XMLTickerText;
import webetk.app.interpretation.IZeile;
import webetk.app.interpretation.Interpretation;
import webetk.app.konfiguration.Berechtigungen;
import webetk.app.konfiguration.Filiale;
import webetk.app.konfiguration.Filialen;
import webetk.app.konfiguration.Firma;
import webetk.app.konfiguration.Firmen;
import webetk.app.konfiguration.Funktionsrecht;
import webetk.app.konfiguration.Funktionsrechte;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.konfiguration.Sprachen;
import webetk.app.lagerzeit.Lagerzeit;
import webetk.app.normteile.Grafik;
import webetk.app.normteile.NormteilBenennung;
import webetk.app.normteile.NormteilBildTO;
import webetk.app.normteile.NormteilTO;
import webetk.app.normteile.Normteile;
import webetk.app.notizuebersicht.Notizuebersicht;
import webetk.app.polstercode.neu.PCZeilen;
import webetk.app.polstercode.neu.PolsterCodeAusstattungZeile;
import webetk.app.satzeinzelteile.Hg;
import webetk.app.satzeinzelteile.SEZeilen;
import webetk.app.satzeinzelteile.ZusatzInfo;
import webetk.app.settings.Einstellungen;
import webetk.app.settings.EinstellungenBasis;
import webetk.app.settings.Sprache;
import webetk.app.settings.WertebereichRegionen;
import webetk.app.settings.WertebereichSprachen;
import webetk.app.technischeliteratur.TLZeilen;
import webetk.app.teileersetzung.Teileersetzung;
import webetk.app.teileinfo.Notiz;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.app.teileliste.Teileliste;
import webetk.app.teileliste.TeilelisteTO;
import webetk.app.teilevwdgben.Teilevwdgben;
import webetk.app.teilevwdgfzg.Teilevwdgfzg;
import webetk.app.teilevwdgred.Teileverwendung;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.app.teilevwdgteil.Teilevwdgteil;
import webetk.app.valueline.ValueLine;
import webetk.app.valueline.ValueLineSatz;
import webetk.app.visualisierungteil.VisualisierungTeil;
import webetk.communication.CommunicationException;
import webetk.communication.JavaAssSucheInfo;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.Nutzer;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfHashMap;
import webetk.db.dbaccess.AspgDbAccess;
import webetk.db.dbaccess.InfoToolDbAccess;
import webetk.db.dbaccess.KonfigurationDbAccess;
import webetk.db.dbaccess.TeileListeDbAccess;
import webetk.db.dbaccess.TeileSucheFzgDbAccess;
import webetk.javaserver.app.GlobalObjects;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.XmlDmsBestandsabfrage;
import webetk.xmlapi.dms.commands.XmlDmsFilialabfrage;
import webetk.xmlapi.dms.commands.XmlDmsFzgIdAuftrag;
import webetk.xmlapi.dms.commands.XmlDmsFzgIdKfzKennzeichen;
import webetk.xmlapi.dms.commands.XmlDmsInit;
import webetk.xmlapi.dms.commands.XmlDmsTeileinfo;
import webetk.xmlapi.dms.commands.typen.XmlDmsMwst;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilelistenPosition;

public class TrfHashMapCommand
extends AbstractTransferableCommand {
    public static final int THIS_BT = 0;
    public static final int NEXT_BT = 1;
    public static final int PREV_BT = 2;
    protected Logger log = Logger.getLogger(TrfHashMapCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfHashMap)) {
            this.log.error("Given transferable must be TrfHashMap, but it isn't!");
            throw new ClassCastException("TrfHashMap excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfHashMap transferableMap = (TrfHashMap)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.NO_OPERATION.equals(command)) {
            return;
        }
        if (Command.LOGIN.equals(command)) {
            return;
        }
        if (Command.LOAD_FIRMEN.equals(command)) {
            this.ladeFirmen(transferableMap);
            return;
        }
        if (Command.LOAD_FILIALEN.equals(command)) {
            this.ladeFilialen(transferableMap);
            return;
        }
        if (Command.LOAD_FILIALE_INFO.equals(command)) {
            this.ladeFilialeInfo(transferableMap);
            return;
        }
        if (Command.LOAD_INTERPRETATION.equals(command)) {
            this.ladeInterpretation(transferableMap);
            return;
        }
        if (Command.LOAD_KONFIGURATION.equals(command)) {
            this.ladeKonfiguration(transferableMap);
            return;
        }
        if (Command.SAVE_KONFIGURATION.equals(command)) {
            this.speichereKonfiguration(transferableMap);
            return;
        }
        if (Command.LOAD_SATZEINZEL_HG.equals(command)) {
            this.ladeSatzEinzelteileHgs(transferableMap);
            return;
        }
        if (Command.LOAD_SATZEINZEL_SAETZE.equals(command)) {
            this.ladeSatzEinzelteileSaetze(transferableMap);
            return;
        }
        if (Command.LOAD_SATZEINZEL_EINZELTEILE.equals(command)) {
            this.ladeEinzelteile(transferableMap);
            return;
        }
        if (Command.LOAD_VALUE_LINE_HGS.equals(command)) {
            this.ladeValueLineHGs(transferableMap);
            return;
        }
        if (Command.LOAD_VALUE_LINE_SAETZE.equals(command)) {
            this.ladeValueLineSaetze(transferableMap);
            return;
        }
        if (Command.LOAD_VALUE_LINE_BTE_BAUREIHEN.equals(command)) {
            this.ladeValueLineBteBaureihen(transferableMap);
            return;
        }
        if (Command.LOAD_VALUE_LINE_BTES.equals(command)) {
            this.ladeValueLineBtes(transferableMap);
            return;
        }
        if (Command.LOAD_VALUE_LINE_TEILENUMMERN.equals(command)) {
            this.ladeValueLineTeilenummern(transferableMap);
            return;
        }
        if (Command.LOAD_TEILELISTEN_IDS.equals(command)) {
            this.ladeTeilelistenIDs(transferableMap);
            return;
        }
        if (Command.LOAD_TECHLIT_SPRACHEN.equals(command)) {
            this.ladeTechLitSprachen(transferableMap);
            return;
        }
        if (Command.LOAD_TECHLIT_FGS.equals(command)) {
            this.ladeTechLitFgs(transferableMap);
            return;
        }
        if (Command.LOAD_TECHLIT_ERGEBNIS.equals(command)) {
            this.ladeTechLitErgebnisse(transferableMap);
            return;
        }
        if (Command.LOAD_VERSIONSINFO.equals(command)) {
            this.ladeVersionsinfo(transferableMap);
            return;
        }
        if (Command.LOAD_ABKUERZUNGEN.equals(command)) {
            this.ladeAbkuerzungen(transferableMap);
            return;
        }
        if (Command.LOAD_TF_ATTRIBUTE.equals(command)) {
            this.ladeTFAttribute(transferableMap);
            return;
        }
        if (Command.LOAD_POLSTERCODE.equals(command)) {
            this.ladePolstercode(transferableMap);
            return;
        }
        if (Command.LOAD_SONDERAUSSTATTUNGEN.equals(command)) {
            this.ladeSonderausstattungen(transferableMap);
            return;
        }
        if (Command.LOAD_NORMTEILBENENNUNGEN.equals(command)) {
            this.ladeNormteilbenennungen(transferableMap);
            return;
        }
        if (Command.LOAD_NORMTEILGRAFIKEN.equals(command)) {
            this.ladeNormteilgrafiken(transferableMap);
            return;
        }
        if (Command.LOAD_NORMTEILE_BY_NORMNUMMER.equals(command)) {
            this.ladeNormteileByNormnummer(transferableMap);
            return;
        }
        if (Command.LOAD_NORMTEILE_BY_BENENNUNG.equals(command)) {
            this.ladeNormteileByBenennung(transferableMap);
            return;
        }
        if (Command.LOAD_LAGERZEIT_HGS.equals(command)) {
            this.ladeLagerzeitHgs(transferableMap);
            return;
        }
        if (Command.LOAD_LAGERZEIT_ZU_HG.equals(command)) {
            this.ladeLagerzeitTeile(transferableMap);
            return;
        }
        if (Command.LOAD_LAGERZEIT_ZU_HG_AT_INDEX.equals(command)) {
            this.holeLagerzeitTeileIndex(transferableMap);
            return;
        }
        if (Command.LOAD_FZGUMFANG_REGIONEN.equals(command)) {
            this.ladeFzgUmfangRegionen(transferableMap);
            return;
        }
        if (Command.LOAD_FZGUMFANG_LENKUNGEN.equals(command)) {
            this.ladeFzgUmfangLenkungen(transferableMap);
            return;
        }
        if (Command.LOAD_FZGUMFANG_BAUARTEN.equals(command)) {
            this.ladeFzgUmfangBauarten(transferableMap);
            return;
        }
        if (Command.LOAD_FZGUMFANG_BAUREIHEN.equals(command)) {
            this.ladeFzgUmfangBaureihen(transferableMap);
            return;
        }
        if (Command.LOAD_FZGUMFANG_KAROSSERIEN.equals(command)) {
            this.ladeFzgUmfangKarosserien(transferableMap);
            return;
        }
        if (Command.LOAD_FZGUMFANG_MODELLE.equals(command)) {
            this.ladeFzgUmfangModelle(transferableMap);
            return;
        }
        if (Command.LOAD_FZGUMFANG_MODELLSPALTEN.equals(command)) {
            this.ladeFzgUmfangModellspalten(transferableMap);
            return;
        }
        if (Command.LOAD_ERSTBEVORRATUNG_HGS.equals(command)) {
            this.ladeErstbevorratungHgs(transferableMap);
            return;
        }
        if (Command.LOAD_ERSTBEVORRATUNG_ZU_HG.equals(command)) {
            this.ladeErstbevorratungTeile(transferableMap);
            return;
        }
        if (Command.LOAD_ERSTBEVORRATUNG_ZU_HG_AT_INDEX.equals(command)) {
            this.holeErstbevorratungTeileIndex(transferableMap);
            return;
        }
        if (Command.LOAD_VISUALISIERUNG.equals(command)) {
            this.ladeVisualisierung(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEERSETZUNG_HGS.equals(command)) {
            this.ladeTeileersetzungHgs(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEERSETZUNG_ZU_HG.equals(command)) {
            this.ladeTeileersetzungTeile(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEERSETZUNG_ZU_HG_AT_INDEX.equals(command)) {
            this.holeTeileersetzungTeileIndex(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEVERWENDUNGFZG_HGS.equals(command)) {
            this.ladeTeileverwendungFzgHgs(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEVERWENDUNGFZG_ZU_HG.equals(command)) {
            this.ladeTeileverwendungFzgTeile(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEVERWENDUNGFZG_ZU_HG_AT_INDEX.equals(command)) {
            this.holeTeileverwendungFzgTeileIndex(transferableMap);
            return;
        }
        if (Command.CHECK_TEILEVERWENDUNGTEIL.equals(command)) {
            this.ladeTeileverwendungTeilInfo(transferableMap);
            return;
        }
        if (Command.CHECK_TEILEVERWENDUNGBEN.equals(command)) {
            this.ladeTeileverwendungTeilInfo(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEVERWENDUNGTEIL.equals(command)) {
            this.ladeTeileverwendungTeil(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEVERWENDUNGBEN.equals(command)) {
            this.ladeTeileverwendungBenennung(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEVERWENDUNG_REDUZIERT.equals(command)) {
            this.ladeTeileverwendungReduziert(transferableMap);
            return;
        }
        if (Command.LOAD_NOTIZEN.equals(command)) {
            this.ladeTeilenotizen(transferableMap);
            return;
        }
        if (Command.LOAD_TEILESUCHE_GRAF_HG.equals(command)) {
            this.ladeTeilesucheGrafHg(transferableMap);
            return;
        }
        if (Command.LOAD_TEILESUCHE_GRAF_FG.equals(command)) {
            this.ladeTeilesucheGrafFg(transferableMap);
            return;
        }
        if (Command.CHECK_TEILESUCHE_GRAF_BT.equals(command)) {
            this.checkTeilesucheBt(transferableMap);
            return;
        }
        if (Command.LOAD_TEILESUCHE_GRAF_BT.equals(command)) {
            this.ladeTeilesucheGrafBt(transferableMap);
            return;
        }
        if (Command.LOAD_TEILESUCHE_HGFG.equals(command)) {
            this.ladeTeilesucheHgFg(transferableMap);
            return;
        }
        if (Command.LOAD_SETTINGS_REGIONEN.equals(command)) {
            this.ladeEinstellungenRegionen(transferableMap);
            return;
        }
        if (Command.LOAD_SETTINGS_SPRACHEN.equals(command)) {
            this.ladeEinstellungenSprachen(transferableMap);
            return;
        }
        if (Command.CHECK_SETTINGS.equals(command)) {
            this.checkSettings(transferableMap);
            return;
        }
        if (Command.SAVE_SETTINGS.equals(command)) {
            this.saveSettings(transferableMap);
            return;
        }
        if (Command.SET_SETTINGS.equals(command)) {
            this.setSettings(transferableMap);
            return;
        }
        if (Command.LOAD_FUELLMENGEN.equals(command)) {
            this.ladeFuellmengen(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEINFO.equals(command)) {
            this.ladeTeileinfo(transferableMap);
            return;
        }
        if (Command.SAVE_NOTIZ.equals(command)) {
            this.saveTeilenotiz(transferableMap);
            return;
        }
        if (Command.DO_DMS_FILIALBESTAND.equals(command)) {
            this.doDMSFilialbestand(transferableMap);
            return;
        }
        if (Command.LOAD_KOMMERZIELLE_INFO.equals(command)) {
            this.ladeKommerzielleInfo(transferableMap);
            return;
        }
        if (Command.LOAD_FT_SONDERAUSSTATTUNGEN.equals(command)) {
            this.ladeFedertabelleSonderausstattungen(transferableMap);
            return;
        }
        if (Command.LOAD_FT_FEDERN.equals(command)) {
            this.ladeFedertabelleFedern(transferableMap);
            return;
        }
        if (Command.SET_BTE_MENGE.equals(command)) {
            this.setBTEMenge(transferableMap);
            return;
        }
        if (Command.BT_THIS_BTE.equals(command)) {
            this.selectThisBTE(transferableMap);
            return;
        }
        if (Command.BT_NEXT_BTE.equals(command)) {
            this.selectNextBTE(transferableMap);
            return;
        }
        if (Command.BT_PREV_BTE.equals(command)) {
            this.selectPrevBTE(transferableMap);
            return;
        }
        if (Command.BT_SET_CURRENT_BTE.equals(command)) {
            this.setCurrentBTE(transferableMap);
            return;
        }
        if (Command.BT_LOAD_BTE.equals(command)) {
            this.loadBTE(transferableMap);
            return;
        }
        if (Command.BT_EXPAND_BILDNUMMER.equals(command)) {
            this.expandBildnummer(transferableMap);
            return;
        }
        if (Command.BT_COLLAPSE_BILDNUMMER.equals(command)) {
            this.collapseBildnummer(transferableMap);
            return;
        }
        if (Command.BT_APPLY_BEDINGUNGEN.equals(command)) {
            this.anwendenBedAuswertung(transferableMap);
            return;
        }
        if (Command.BT_CHANGE_BED.equals(command)) {
            this.changeBedingung(transferableMap);
            return;
        }
        if (Command.BT_RESET_BEDINGUNGEN.equals(command)) {
            this.resetBedingungen(transferableMap);
            return;
        }
        if (Command.BT_LOAD_VERWEIS_BT.equals(command)) {
            this.loadVerweisBTE(transferableMap);
            return;
        }
        if (Command.BT_SHOW_TV_TEIL.equals(command)) {
            this.showBTFromTVTeil(transferableMap);
            return;
        }
        if (Command.DO_KONFIGURATION_DMS_ABGLEICH.equals(command)) {
            this.doKonfigurationDmsAbgleich(transferableMap);
            return;
        }
        if (Command.FI_LOAD_TL_ZU_AUFTRAG.equals(command)) {
            this.loadTeilelisteZuAuftrag(transferableMap);
            return;
        }
        if (Command.DO_DMS_AUFTRAG.equals(command)) {
            this.doDMSAuftrag(transferableMap);
            return;
        }
        if (Command.DO_DMS_AUFTRAG_KFZ_KENNZEICHEN.equals(command)) {
            this.doDMSAuftragKfzKennzeichen(transferableMap);
            return;
        }
        if (Command.BT_GET_DRUCKANSICHT.equals(command)) {
            this.holeDruckansicht(transferableMap);
            return;
        }
        if (Command.LOAD_BT_INFO.equals(command)) {
            this.holeBTInfo(transferableMap);
            return;
        }
        if (Command.LOAD_FIRMA.equals(command)) {
            this.ladeFirma(transferableMap);
            return;
        }
        if (Command.EXIST_FIRMA.equals(command)) {
            this.existiertFirmenBenennung(transferableMap);
            return;
        }
        if (Command.UPDATE_FIRMA.equals(command)) {
            this.updateFirmenBenennung(transferableMap);
            return;
        }
        if (Command.EXIST_FILIALID.equals(command)) {
            this.existiertFilialId(transferableMap);
            return;
        }
        if (Command.EXIST_FILIALBEZEICHNUNG.equals(command)) {
            this.existiertFiliale(transferableMap);
            return;
        }
        if (Command.DELETE_FILIALE.equals(command)) {
            this.deleteFiliale(transferableMap);
            return;
        }
        if (Command.UPDATE_FILIALE.equals(command)) {
            this.updateFiliale(transferableMap);
            return;
        }
        if (Command.LOAD_FILIALEN_SPRACHEN.equals(command)) {
            this.ladeFilialenUndSprachen(transferableMap);
            return;
        }
        if (Command.LOAD_BENUTZER.equals(command)) {
            this.ladeNutzer(transferableMap);
            return;
        }
        if (Command.LOAD_ANZAHL_NUTZER.equals(command)) {
            this.ladeAnzahlNutzer(transferableMap);
            return;
        }
        if (Command.LOAD_MATCHING_NUTZER.equals(command)) {
            this.loadMatchingNutzer(transferableMap);
            return;
        }
        if (Command.LOAD_NUTZER.equals(command)) {
            this.ladeNutzerAnhandId(transferableMap);
            return;
        }
        if (Command.LOAD_BERECHTIGUNGEN.equals(command)) {
            this.ladeBerechtigungen(transferableMap);
            return;
        }
        if (Command.LOAD_FILIAL_SPRACHEN.equals(command)) {
            this.ladeSprachen(transferableMap);
            return;
        }
        if (Command.LOAD_FUNKTIONSRECHTE.equals(command)) {
            this.ladeFunktionsrechte(transferableMap);
            return;
        }
        if (Command.LOAD_NUTZER_FUNKTIONSRECHTE.equals(command)) {
            this.ladeNutzerFunktionsrechte(transferableMap);
            return;
        }
        if (Command.LOAD_NUTZER_BERECHTIGUNGEN.equals(command)) {
            this.ladeNutzerBerechtigungen(transferableMap);
            return;
        }
        if (Command.DELETE_NUTZER.equals(command)) {
            this.deleteNutzer(transferableMap);
            return;
        }
        if (Command.EXIST_USERID.equals(command)) {
            this.existiertNutzerId(transferableMap);
            return;
        }
        if (Command.STORE_USER.equals(command)) {
            this.speichereNutzer(transferableMap);
            return;
        }
        if (Command.MOVE_TEILELISTEN.equals(command)) {
            this.moveTeilelisten(transferableMap);
            return;
        }
        if (Command.EXIST_FIRMAID.equals(command)) {
            this.existiertFirmaId(transferableMap);
            return;
        }
        if (Command.EXIST_EINE_FIRMA_FILIALE_NUTZER.equals(command)) {
            this.existiertEineFirmaFilialeNutzer(transferableMap);
            return;
        }
        if (Command.LOAD_DEFAULTFILIALE_PASSWORT.equals(command)) {
            this.ladeDefaultFilialePasswort(transferableMap);
            return;
        }
        if (Command.CREATE_FILIALE.equals(command)) {
            this.erzeugeNeueFiliale(transferableMap);
            return;
        }
        if (Command.LOAD_USER_BY_FILIALID.equals(command)) {
            this.ladeNutzerZuFilialId(transferableMap);
            return;
        }
        if (Command.EXIST_LISTS_BY_FILIALID.equals(command)) {
            this.existierenListeneintraege(transferableMap);
            return;
        }
        if (Command.LOAD_NOTIZ.equals(command)) {
            this.ladeNotiz(transferableMap);
            return;
        }
        if (Command.GET_TIPP_TRICK.equals(command)) {
            this.ladeTippTrick(transferableMap);
            return;
        }
        if (Command.LOAD_TIPPS_TRICKS_BASISINFO.equals(command)) {
            this.ladenTippTricksBasisinfo(transferableMap);
            return;
        }
        if (Command.LOAD_TIPPS_TRICKS_DETAILS.equals(command)) {
            this.ladenTippTricksDetails(transferableMap);
            return;
        }
        if (Command.SAVE_TIPPS_GELESEN.equals(command)) {
            this.saveTippTrickGelesen(transferableMap);
            return;
        }
        if (Command.EXIST_TIPPS_TRICKS.equals(command)) {
            this.existiertTipps(transferableMap);
            return;
        }
        if (Command.LOAD_TICKERTEXTE.equals(command)) {
            this.ladenTickertexte(transferableMap);
            return;
        }
        if (Command.PROTOKOLLIERE_LOGIN.equals(command)) {
            this.protokolliereLogin(transferableMap);
            return;
        }
        if (Command.PROTOKOLLIERE_LOGOUT.equals(command)) {
            this.protokolliereLogout(transferableMap);
            return;
        }
        if (Command.GET_LOGGEDIN_USERS.equals(command)) {
            this.getLoggedInUsers(transferableMap);
            return;
        }
        if (Command.GET_INACTIVE_USERS.equals(command)) {
            this.getInactiveUsers(transferableMap);
            return;
        }
        if (Command.LOAD_TABELLENKONFIGURATION.equals(command)) {
            this.loadTableConfiguration(transferableMap);
            return;
        }
        if (Command.SAVE_TABELLENKONFIGURATION.equals(command)) {
            this.saveTableConfiguration(transferableMap);
            return;
        }
        if (Command.LOAD_ABSENDER_UND_EMPFAENGER.equals(command)) {
            this.loadAbsenderUndEmpfaenger(transferableMap);
            return;
        }
        if (Command.SAVE_ABSENDER.equals(command)) {
            this.saveAbsender(transferableMap);
            return;
        }
        if (Command.SAVE_EMPFAENGER.equals(command)) {
            this.saveEmpfaenger(transferableMap);
            return;
        }
        if (Command.LOAD_ETKTEXTE.equals(command)) {
            this.getETKTexte(transferableMap);
            return;
        }
        if (Command.LADE_MAERKTE_ETK_LOKALE_PRODUKTE.equals(command)) {
            this.ladeMaerkteEtkLokaleProdukte(transferableMap);
            return;
        }
        if (Command.LOAD_ASPGTEILE.equals(command)) {
            this.ladeAspgTeile(transferableMap);
            return;
        }
        if (Command.LOAD_STECKER.equals(command)) {
            this.ladeSteckerTeile(transferableMap);
            return;
        }
        if (Command.INSERT_US_LISTEN.equals(command)) {
            this.createUSListen(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void ladeFirmen(TrfHashMap transferableMap) {
        Firmen oFirmen = null;
        try {
            oFirmen = new Firmen();
            oFirmen.loadFirmen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Firma> cFirmen = oFirmen.getFirmen();
        int i = 1;
        for (Firma firma : cFirmen) {
            transferableMap.setValue(i + "firmaid", firma.getId());
            transferableMap.setValue(i + "benennung", firma.getBezeichnung());
            ++i;
        }
        int nCount = cFirmen.size();
        String sCount = Integer.toString(nCount);
        transferableMap.setValue("count", sCount);
        if (cFirmen.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Firmen gefunden!"));
        }
    }

    private void ladeFilialen(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        Filialen oFilialen = null;
        try {
            oFilialen = new Filialen(sFirmaId);
            oFilialen.loadFilialen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Filiale> cFilialen = oFilialen.getFilialen();
        int i = 1;
        for (Filiale filiale : cFilialen) {
            transferableMap.setValue(i + "filialid", filiale.getId());
            transferableMap.setValue(i + "benennung", filiale.getBezeichnung());
            ++i;
        }
        int nCount = cFilialen.size();
        String sCount = Integer.toString(nCount);
        transferableMap.setValue("count", sCount);
        if (cFilialen.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Filialen gefunden!"));
        }
    }

    private void ladeFilialeInfo(TrfHashMap transferableMap) {
        String sIdFirma = (String)transferableMap.getValue("firmaid");
        String sIdFiliale = (String)transferableMap.getValue("filialid");
        Filiale oFiliale = new Filiale(sIdFiliale, sIdFirma);
        try {
            oFiliale.load();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("filiale", oFiliale);
    }

    private void ladeInterpretation(TrfHashMap transferableMap) {
        String sBestaende;
        Collection<String> cMarken = this.sessionInfo.getUserMarken();
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marken", cMarken);
                String sMarke = this.sessionInfo.getUserInfo().getMarke();
                transferableMap.setValue("marke", sMarke);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_INTERPRETATION);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
        }
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        Interpretation oInterpretation = null;
        try {
            oInterpretation = new Interpretation(cMarken, sLang, sSachnummer);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        if (!(!this.sessionInfo.getDMSVerwenden() || (sBestaende = (String)transferableMap.getValue("bestaende")) != null && sBestaende.equals("N") || oInterpretation.isEmpty())) {
            Vector<String> cTeilenummern = new Vector<String>();
            Vector<String> cMarkenDms = new Vector<String>();
            Collection<IZeile> cZeilen = null;
            XmlDmsBestandsabfrage xmlReq = new XmlDmsBestandsabfrage();
            try {
                String sNutzerId = this.sessionInfo.getUserInfo().getID();
                String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
                String sFilialeId = this.sessionInfo.getUserInfo().getFilialeID();
                cZeilen = oInterpretation.getAlleZeilen(cTeilenummern, cMarkenDms);
                xmlReq.setInputParameters(sNutzerId, sFirmaId, sFilialeId, cTeilenummern, cMarkenDms);
                xmlReq.requestService();
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
            if (this.checkXmlErgebnisCode(transferableMap, xmlReq) && cZeilen != null) {
                for (int ii = 0; ii < xmlReq.getTeileCount(); ++ii) {
                    IZeile oZeile = (IZeile)cZeilen.toArray()[ii];
                    Double dLagerbestand = xmlReq.getLagerbestand(ii);
                    oZeile.setLagerbestand(dLagerbestand);
                }
            }
        }
        if (oInterpretation.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Interpretation gefunden!"));
        }
        transferableMap.setValue("interpretation", oInterpretation);
    }

    private void ladeKonfiguration(TrfHashMap transferableMap) {
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        Konfiguration oKonfiguration = null;
        try {
            oKonfiguration = new Konfiguration(sFirma, sFiliale);
            oKonfiguration.loadKonfiguration();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("Haendler_Konfiguration", oKonfiguration);
    }

    private void speichereKonfiguration(TrfHashMap transferableMap) {
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        Konfiguration config = (Konfiguration)transferableMap.getValue("Haendler_Konfiguration");
        try {
            config.setFirma(sFirma);
            config.setFiliale(sFiliale);
            config.saveKonfiguration();
            boolean bDMSVerwenden = config.getDMSSchnittstelleVerwenden().equals("J");
            this.sessionInfo.setDMSVerwenden(bDMSVerwenden);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
    }

    private void ladeSatzEinzelteileHgs(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        String sUserKatalogumfang = this.sessionInfo.getUserKatUmfang();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("katalogumfang_berechtigung", sUserKatalogumfang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_SATZEINZEL_HG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        SEZeilen oHauptgruppen = null;
        try {
            oHauptgruppen = new SEZeilen(sMarke, sProduktart, sUserKatalogumfang, sLang, null, sLandkuerzel);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<Hg> hglist = new ArrayList<Hg>();
        int i = 1;
        oHauptgruppen.first();
        while (true) {
            hglist.add(new Hg(oHauptgruppen.getCurrentHG(), oHauptgruppen.getCurrentBenennung()));
            ++i;
            if (!oHauptgruppen.hasNext()) break;
            oHauptgruppen.next();
        }
        transferableMap.setValue("HG_EXT_LIST", hglist);
        if (oHauptgruppen.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Hauptgruppen gefunden!"));
        }
    }

    private void ladeSatzEinzelteileSaetze(TrfHashMap transferableMap) {
        SEZeilen oSaetze;
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sHg = (String)transferableMap.getValue("hg");
        String sUserKatalogumfang = this.sessionInfo.getUserKatUmfang();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("katalogumfang_berechtigung", sUserKatalogumfang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_SATZEINZEL_SAETZE);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            oSaetze = new SEZeilen(sMarke, sProduktart, sUserKatalogumfang, sLang, sHg, sLandkuerzel);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<Hg> retval = new ArrayList<Hg>();
        oSaetze.first();
        Hg currentHg = null;
        while (true) {
            if (oSaetze.getCurrentArt().equals("H")) {
                currentHg = new Hg(oSaetze.getCurrentHG(), oSaetze.getCurrentBenennung());
                retval.add(currentHg);
            } else if (currentHg != null) {
                currentHg.addZusatzInfo(new ZusatzInfo(oSaetze.getCurrentBenennung(), oSaetze.getCurrentTeilenummer(), oSaetze.getCurrentZusatz(), oSaetze.getCurrentZI()));
            }
            if (!oSaetze.hasNext()) break;
            oSaetze.next();
        }
        transferableMap.setValue("HG_EXT_LIST", retval);
        if (oSaetze.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine S\u00e4tze gefunden!"));
        }
    }

    private void ladeEinzelteile(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sUserKatalogumfang = this.sessionInfo.getUserKatUmfang();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                transferableMap.setValue("katalogumfang_berechtigung", sUserKatalogumfang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_SATZEINZEL_EINZELTEILE);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        SEZeilen oEinzelteile = null;
        try {
            oEinzelteile = new SEZeilen(sMarke, sProduktart, sUserKatalogumfang, sLang, sSachnummer, sLandkuerzel);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<ZusatzInfo> zusatzInfos = new ArrayList<ZusatzInfo>();
        oEinzelteile.first();
        while (true) {
            zusatzInfos.add(new ZusatzInfo(oEinzelteile.getCurrentBenennung(), oEinzelteile.getCurrentTeilenummer(), oEinzelteile.getCurrentZusatz(), oEinzelteile.getCurrentZI(), oEinzelteile.isCurrentEBA(), oEinzelteile.isCurrentBeziehbar(), oEinzelteile.getCurrentMenge()));
            if (!oEinzelteile.hasNext()) break;
            oEinzelteile.next();
        }
        transferableMap.setValue("zusatz_infos", zusatzInfos);
        if (oEinzelteile.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Einzelteile gefunden!"));
        }
    }

    private void ladeValueLineHGs(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_VALUE_LINE_HGS);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        Collection<webetk.app.valueline.Hg> hgs = null;
        try {
            hgs = ValueLine.loadHgs(sMarke, sProduktart, sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("HG_LIST", hgs);
    }

    private void ladeValueLineSaetze(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sHG = (String)transferableMap.getValue("hg");
        String sUserKatalogumfang = this.sessionInfo.getUserKatUmfang();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("katalogumfang_berechtigung", sUserKatalogumfang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_VALUE_LINE_SAETZE);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            Collection<ValueLineSatz> saetze = ValueLine.loadSaetze(sMarke, sProduktart, sUserKatalogumfang, sLang, sHG, sLandkuerzel);
            transferableMap.setValue("saetze", saetze);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeValueLineBteBaureihen(TrfHashMap transferable) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = (String)transferable.getValue("marke");
        String sProduktart = (String)transferable.getValue("produktart");
        Vector<String> cRegionen = this.sessionInfo.getUserInfo().getRegionen();
        AssSucheInfo oSucheInfo = new AssSucheInfo();
        oSucheInfo.setMarke(sMarke);
        oSucheInfo.setProduktart(sProduktart);
        String sKatalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        oSucheInfo.setKatalogumfang(sKatalogumfang);
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("sprache", sLang);
                transferable.setValue("regionendefault", cRegionen);
                transferable.setValue("katalogumfang_berechtigung", sKatalogumfang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.LOAD_VALUE_LINE_BTE_BAUREIHEN);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
            }
        } else {
            try {
                Collection<Baureihe> cBaureihen = ValueLine.loadBteBaureihen(oSucheInfo, sLang, cRegionen);
                transferable.setValue("baureihenListe", cBaureihen);
            }
            catch (Exception e) {
                transferable.setError(e);
            }
        }
    }

    private void ladeValueLineBtes(TrfHashMap transferable) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = (String)transferable.getValue("marke");
        String sProduktart = (String)transferable.getValue("produktart");
        String sBaureihe = (String)transferable.getValue("baureihe");
        Vector<String> cRegionen = this.sessionInfo.getUserInfo().getRegionen();
        AssSucheInfo oSucheInfo = new AssSucheInfo();
        oSucheInfo.setMarke(sMarke);
        oSucheInfo.setProduktart(sProduktart);
        String sKatalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        oSucheInfo.setKatalogumfang(sKatalogumfang);
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("sprache", sLang);
                transferable.setValue("regionendefault", cRegionen);
                transferable.setValue("katalogumfang_berechtigung", sKatalogumfang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.LOAD_VALUE_LINE_BTES);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
            }
        } else {
            try {
                Collection<Modellspalte> cBTEs = ValueLine.loadBildtafeln(oSucheInfo, sLang, sBaureihe, "", cRegionen);
                transferable.setValue("MODELLSPALTEN", cBTEs);
            }
            catch (Exception e) {
                transferable.setError(e);
            }
        }
    }

    private void ladeValueLineTeilenummern(TrfHashMap transferable) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = (String)transferable.getValue("marke");
        String sProduktart = (String)transferable.getValue("produktart");
        Collection<SearchBTETeile.PartOrBTE> cTeile = null;
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("sprache", sLang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.LOAD_VALUE_LINE_TEILENUMMERN);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
            }
        } else {
            try {
                cTeile = ValueLine.loadTeilenummern(sMarke, sProduktart, sLang);
                transferable.setValue("bildtafeln", cTeile);
            }
            catch (Exception e) {
                transferable.setError(e);
            }
        }
    }

    private void ladeTeilelistenIDs(TrfHashMap transferableMap) {
        String sNutzer = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        boolean bRrSap = false;
        String sRrSap = (String)transferableMap.getValue("rrsaplisten");
        if (sRrSap != null && sRrSap.equals("J")) {
            bRrSap = true;
        }
        Vector<ComboTeilelisteItem> cBestelllisten = null;
        Vector<ComboTeilelisteItem> cTeilelisten = null;
        if (bRrSap) {
            try {
                cTeilelisten = Teileliste.getRrListen(sNutzer, sFirma, sFiliale);
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
        }
        Collection aMarken = (Collection)transferableMap.getValue("marken");
        boolean bOhneBestelllisten = false;
        String sOhneBestelllisten = (String)transferableMap.getValue("ohnebestelllisten");
        if (sOhneBestelllisten != null && sOhneBestelllisten.equals("J")) {
            bOhneBestelllisten = true;
        }
        boolean bNurBestelllisten = false;
        String sNurBestelllisten = (String)transferableMap.getValue("nurbestelllisten");
        if (sNurBestelllisten != null && sNurBestelllisten.equals("J")) {
            bNurBestelllisten = true;
        }
        if (this.sessionInfo.getDMSVerwenden() && !bOhneBestelllisten) {
            try {
                cBestelllisten = Bestellliste.getBestelllisten(sFirma, sFiliale);
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
        }
        if (!bNurBestelllisten) {
            try {
                cTeilelisten = Teileliste.getTeilelisten(sNutzer, aMarken, sFirma, sFiliale, false);
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
        }
        Iterator<Object> iterator = null;
        Vector<ComboTeilelisteItem> comboTeilelisteItems = new Vector<ComboTeilelisteItem>();
        if (cBestelllisten != null) {
            for (ComboTeilelisteItem oTeileliste : cBestelllisten) {
                comboTeilelisteItems.add(oTeileliste);
            }
        }
        if (cTeilelisten != null) {
            boolean bUSDirect;
            String sUSDirect = (String)transferableMap.getValue("us_filename");
            boolean bl = bUSDirect = sUSDirect != null && sUSDirect.trim().length() > 0;
            if (bUSDirect) {
                for (ComboTeilelisteItem oTeileliste : cTeilelisten) {
                    if (!Marken.getInstance().getEigenschaften("marke.usListenIds").contains(oTeileliste.getName())) continue;
                    comboTeilelisteItems.add(oTeileliste);
                }
            }
            iterator = cTeilelisten.iterator();
            boolean bRechtRROrderList = this.sessionInfo.getUserInfo().hasRecht("R_WEBETK_RR_ORDER_LIST");
            while (iterator.hasNext()) {
                ComboTeilelisteItem oTeileliste = (ComboTeilelisteItem)iterator.next();
                if (Marken.getInstance().getEigenschaften("marke.usListenIds").contains(oTeileliste.getName()) || !bRechtRROrderList && oTeileliste.isRrSapListe()) continue;
                comboTeilelisteItems.add(oTeileliste);
            }
        }
        transferableMap.setValue("Combo_teilelisteid", comboTeilelisteItems);
    }

    private void ladeTechLitSprachen(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TECHLIT_SPRACHEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        WertebereichSprachen wbSprachen = new WertebereichSprachen();
        try {
            wbSprachen.loadFuerTL(sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        Iterator<Sprache> iterator = wbSprachen.iteratorSprachen();
        while (iterator.hasNext()) {
            Sprache oSprache = iterator.next();
            transferableMap.setValue(i + "iso", oSprache.getISO());
            transferableMap.setValue(i + "regiso", oSprache.getRegISO());
            transferableMap.setValue(i + "benennung", oSprache.getBenennung());
            ++i;
        }
    }

    private void ladeTechLitFgs(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        long lModellspalte = 0L;
        if (this.sessionInfo.getFzgIdInfo() != null) {
            FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
            sMarke = oFzgIdInfo.getMarke();
            sProduktart = oFzgIdInfo.getProduktart();
            sKatalogumfang = oFzgIdInfo.getKatalogumfang();
            lModellspalte = oFzgIdInfo.getModellspalte();
        } else if (this.sessionInfo.getAssSucheInfo() != null) {
            AssSucheInfo oAssSucheInfo = this.sessionInfo.getAssSucheInfo();
            sMarke = oAssSucheInfo.getMarke();
            sProduktart = oAssSucheInfo.getProduktart();
            sKatalogumfang = oAssSucheInfo.getKatalogumfang();
        } else {
            sMarke = this.sessionInfo.getUserInfo().getMarke();
            sProduktart = this.sessionInfo.getUserInfo().getProduktart();
            sKatalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                transferableMap.setValue("katalogumfang", sKatalogumfang);
                if (this.sessionInfo.getFzgIdInfo() != null) {
                    transferableMap.setValue("modellspaltenid", lModellspalte);
                }
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TECHLIT_FGS);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        HGFGs oHgFgs = new HGFGs(null);
        try {
            oHgFgs.loadFGsFuerTL(lModellspalte, sMarke, sProduktart, sKatalogumfang, sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Collection oFgs = oHgFgs.getFGs("01");
        if (oFgs == null) {
            transferableMap.setError(new NoDataFoundException("keine Funktionsgruppen gefunden!"));
            return;
        }
        Iterator iterator = oFgs.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            HGFGs.HGFGData oFg = (HGFGs.HGFGData)iterator.next();
            transferableMap.setValue(i + "hg", "01");
            transferableMap.setValue(i + "fg", oFg.getFG());
            transferableMap.setValue(i + "benennung", oFg.getName());
            ++i;
        }
    }

    private void ladeTechLitErgebnisse(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        long lModellspalte = 0L;
        if (this.sessionInfo.getFzgIdInfo() != null) {
            FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
            sMarke = oFzgIdInfo.getMarke();
            sProduktart = oFzgIdInfo.getProduktart();
            sKatalogumfang = oFzgIdInfo.getKatalogumfang();
            lModellspalte = oFzgIdInfo.getModellspalte();
        } else if (this.sessionInfo.getAssSucheInfo() != null) {
            AssSucheInfo oAssSucheInfo = this.sessionInfo.getAssSucheInfo();
            sMarke = oAssSucheInfo.getMarke();
            sProduktart = oAssSucheInfo.getProduktart();
            sKatalogumfang = oAssSucheInfo.getKatalogumfang();
        } else {
            sMarke = this.sessionInfo.getUserInfo().getMarke();
            sProduktart = this.sessionInfo.getUserInfo().getProduktart();
            sKatalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                transferableMap.setValue("katalogumfang", sKatalogumfang);
                if (this.sessionInfo.getFzgIdInfo() != null) {
                    transferableMap.setValue("modellspaltenid", lModellspalte);
                }
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TECHLIT_ERGEBNIS);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sFg = (String)transferableMap.getValue("fg");
        String sSpracheTL = (String)transferableMap.getValue("sprache_tl");
        TLZeilen oZeilen = null;
        try {
            oZeilen = new TLZeilen(sLang, lModellspalte, sMarke, sProduktart, sKatalogumfang, sFg, sSpracheTL);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        oZeilen.first();
        while (true) {
            transferableMap.setValue(i + "teilenummer", oZeilen.getCurrentTeilenummer());
            transferableMap.setValue(i + "benennung", oZeilen.getCurrentTeilebenennung());
            transferableMap.setValue(i + "kommentar", oZeilen.getCurrentKommentar());
            transferableMap.setValue(i + "zusatz", oZeilen.getCurrentZusatz());
            transferableMap.setValue(i + "einsatzdatum", oZeilen.getCurrentEinsatz());
            transferableMap.setValue(i + "auslaufdatum", oZeilen.getCurrentAuslauf());
            transferableMap.setValue(i + "mam", oZeilen.getCurrentMAM());
            String sIsEBA = oZeilen.isCurrentEBA() ? "true" : "false";
            transferableMap.setValue(i + "iseba", sIsEBA);
            ++i;
            if (!oZeilen.hasNext()) break;
            oZeilen.next();
        }
    }

    private void ladeVersionsinfo(TrfHashMap transferableMap) {
        if (this.sessionInfo.doZentraleRecherche() && !transferableMap.isForceLocalServerOnly()) {
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_VERSIONSINFO);
                transferableMap.setValue("cdversion", this.ladeCDVersionsinfo());
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
            String sApplVersion = ServerGlobalObjects.getInstance().getApplicationInfo();
            transferableMap.setValue("webetkversion", sApplVersion);
            return;
        }
        VersionInfo oVersionInfo = null;
        try {
            oVersionInfo = new VersionInfo();
            transferableMap.setValue("cdversion", this.ladeCDVersionsinfo());
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        transferableMap.setValue("webetkversion", oVersionInfo.getApplVersion());
        transferableMap.setValue("dbversion", oVersionInfo.getDBVersion());
        transferableMap.setValue("datenvom", oVersionInfo.getDBErzeugt());
    }

    private String ladeCDVersionsinfo() throws IOException {
        String szCDVersion = "";
        String sVersionsFile = GlobalObjects.getInstance().getRealPath("WEB-INF/version.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sVersionsFile)));
        String szLine = in.readLine();
        while (szLine != null) {
            if (szLine.indexOf("Version.CD=") == 0) {
                szCDVersion = szLine.substring(11);
                break;
            }
            szLine = in.readLine();
        }
        in.close();
        return szCDVersion;
    }

    private void ladeAbkuerzungen(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_ABKUERZUNGEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            Abkuerzungsliste oAbkuerzungen = new Abkuerzungsliste(sLang);
            transferableMap.setValue("abkuerzung", oAbkuerzungen.load());
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeTFAttribute(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TF_ATTRIBUTE);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            Attributlisten oTFAttribute = new Attributlisten(sLang);
            transferableMap.setValue("teilearten", oTFAttribute.load());
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladePolstercode(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_POLSTERCODE_ZR_NEU);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            PCZeilen oZeilen = new PCZeilen(sLang);
            List<PolsterCodeAusstattungZeile> retval = oZeilen.load();
            if (retval == null || retval.isEmpty()) {
                transferableMap.setError(new NoDataFoundException("keine Daten gefunden!"));
            } else {
                transferableMap.setValue("poster_ausstattungen", retval);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeSonderausstattungen(TrfHashMap transferableMap) {
        Salapaliste oSonderausstattungen;
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_SONDERAUSSTATTUNGEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            oSonderausstattungen = new Salapaliste(sLang);
            oSonderausstattungen.load();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("pkw_salapas", oSonderausstattungen.getSalapasPKW());
        transferableMap.setValue("motorrad_salapas", oSonderausstattungen.getSalapasMotorrad());
    }

    private void ladeNormteilbenennungen(TrfHashMap transferableMap) {
        Normteile oNormteile;
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = this.sessionInfo.getUserInfo().getMarke();
        String sProduktart = this.sessionInfo.getUserInfo().getProduktart();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_NORMTEILBENENNUNGEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            oNormteile = new Normteile(sMarke, sProduktart, sLang);
            oNormteile.loadNormteilebenennungen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Collection cNormteilbenennungen = oNormteile.getNormteileBenennungen();
        ArrayList<NormteilBenennung> normteilBenennungen = new ArrayList<NormteilBenennung>();
        for (Object aCNormteilbenennungen : cNormteilbenennungen) {
            Hashtable oNormteilbenennung = (Hashtable)aCNormteilbenennungen;
            normteilBenennungen.add(new NormteilBenennung((String)oNormteilbenennung.get("BenIDs"), (String)oNormteilbenennung.get("Benennung")));
        }
        transferableMap.setValue("normteile_benennungen", normteilBenennungen);
    }

    private void ladeNormteilgrafiken(TrfHashMap transferableMap) {
        Normteile oNormteile;
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = this.sessionInfo.getUserInfo().getMarke();
        String sProduktart = this.sessionInfo.getUserInfo().getProduktart();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_NORMTEILGRAFIKEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sNormnummergruppe = (String)transferableMap.getValue("nummer");
        String sArt = sNormnummergruppe == null ? "NNG" : "NN";
        try {
            oNormteile = new Normteile(sMarke, sProduktart, sLang);
            oNormteile.loadGrafiken(sNormnummergruppe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Collection cGrafiken = oNormteile.getGrafiken();
        ArrayList<NormteilBildTO> normteilBildTOs = new ArrayList<NormteilBildTO>();
        for (Grafik oGrafik : cGrafiken) {
            long lTimestamp = oGrafik.getTimestamp();
            String sTimestamp = Long.toString(lTimestamp);
            byte[] aBild = this.ladeGrafik(oGrafik.getID(), "T", sTimestamp);
            normteilBildTOs.add(new NormteilBildTO(oGrafik, aBild, sArt, "T"));
        }
        transferableMap.setValue("normteile_bilder", normteilBildTOs);
    }

    private void ladeNormteileByNormnummer(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = this.sessionInfo.getUserInfo().getMarke();
        String sProduktart = this.sessionInfo.getUserInfo().getProduktart();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_NORMTEILE_BY_NORMNUMMER);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sNormnummer = (String)transferableMap.getValue("nummer");
        Normteile oNormteile = null;
        try {
            oNormteile = new Normteile(sMarke, sProduktart, sLang);
            oNormteile.loadNormteile(sNormnummer, null);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<NormteilTO> normteilTOs = new ArrayList<NormteilTO>();
        Collection cTeile = oNormteile.getTeile();
        if (cTeile != null) {
            for (Hashtable oTeil : cTeile) {
                normteilTOs.add(new NormteilTO((String)oTeil.get("Marke"), (String)oTeil.get("Produktart"), (String)oTeil.get("Benennung"), (String)oTeil.get("Zusatz"), (String)oTeil.get("Teilenummer"), (String)oTeil.get("Normart"), (String)oTeil.get("Normnummer")));
            }
        }
        transferableMap.setValue("normteile", normteilTOs);
    }

    private void ladeNormteileByBenennung(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = this.sessionInfo.getUserInfo().getMarke();
        String sProduktart = this.sessionInfo.getUserInfo().getProduktart();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_NORMTEILE_BY_BENENNUNG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        Normteile oNormteile = null;
        try {
            oNormteile = new Normteile(sMarke, sProduktart, sLang);
            Vector<String> aBenIDs = new Vector<String>();
            String sBenIDs = (String)transferableMap.getValue("textcode");
            while (sBenIDs.indexOf("_") > -1) {
                String sBenID = sBenIDs.substring(0, sBenIDs.indexOf("_"));
                aBenIDs.add(sBenID);
                sBenIDs = sBenIDs.substring(sBenIDs.indexOf("_") + 1);
            }
            String sNormnummer = null;
            oNormteile.loadNormteile(sNormnummer, aBenIDs);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<NormteilTO> normteilTOs = new ArrayList<NormteilTO>();
        Collection cTeile = oNormteile.getTeile();
        if (cTeile != null) {
            for (Hashtable oTeil : cTeile) {
                normteilTOs.add(new NormteilTO((String)oTeil.get("Marke"), (String)oTeil.get("Produktart"), (String)oTeil.get("Benennung"), (String)oTeil.get("Zusatz"), (String)oTeil.get("Teilenummer"), (String)oTeil.get("Normart"), (String)oTeil.get("Normnummer")));
            }
        }
        transferableMap.setValue("normteile", normteilTOs);
    }

    private void ladeLagerzeitHgs(TrfHashMap transferableMap) {
        String sMarke = this.sessionInfo.getUserInfo().getMarke();
        String sProduktart = this.sessionInfo.getUserInfo().getProduktart();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_LAGERZEIT_HGS);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sHgVon = (String)transferableMap.getValue("hgvon");
        String sHgBis = (String)transferableMap.getValue("hgbis");
        try {
            Lagerzeit oLagerzeit = new Lagerzeit();
            transferableMap.setValue("hgs", oLagerzeit.loadHGs(sHgVon, sHgBis, sMarke, sProduktart));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeLagerzeitTeile(TrfHashMap transferableMap) {
        Lagerzeit oLagerzeit;
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sMarke = this.sessionInfo.getUserInfo().getMarke();
        String sProduktart = this.sessionInfo.getUserInfo().getProduktart();
        String sUserKatalogumfang = this.sessionInfo.getUserKatUmfang();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                transferableMap.setValue("katalogumfang_berechtigung", sUserKatalogumfang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_LAGERZEIT_ZU_HG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            Lagerzeit oLagerzeit2 = (Lagerzeit)transferableMap.getValue("lagerzeit");
            this.sessionInfo.setTempValue(oLagerzeit2);
            return;
        }
        String sHg = (String)transferableMap.getValue("hg");
        try {
            oLagerzeit = new Lagerzeit();
            oLagerzeit.loadTeile(sLang, sHg, sMarke, sProduktart, sUserKatalogumfang, sLandkuerzel);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        this.sessionInfo.setTempValue(oLagerzeit);
        transferableMap.setValue("hg", sHg);
        transferableMap.setValue("genericteile", oLagerzeit.getTeile(0));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oLagerzeit.getAnzahlTeile(), oLagerzeit.getAnzahlPakete(), 0);
        transferableMap.setValue("buttons", cButtons);
    }

    private void holeLagerzeitTeileIndex(TrfHashMap transferableMap) {
        String sIndex = (String)transferableMap.getValue("index");
        int nIndex = sIndex == null ? -1 : Integer.parseInt(sIndex);
        Lagerzeit oLagerzeit = null;
        try {
            oLagerzeit = (Lagerzeit)this.sessionInfo.getTempValue();
        }
        catch (Exception e) {
            this.log.error("holeLagerzeitTeileIndex: keine Lagerzeit-Objekt vorhanden");
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("genericteile", oLagerzeit.getTeile(nIndex));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oLagerzeit.getAnzahlTeile(), oLagerzeit.getAnzahlPakete(), nIndex);
        transferableMap.setValue("buttons", cButtons);
    }

    private void ladeFzgUmfangRegionen(TrfHashMap transferableMap) {
        Vector<String> cDefaultRegionen = this.sessionInfo.getUserInfo().getRegionen();
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("regionendefault", cDefaultRegionen);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FZGUMFANG_REGIONEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FzgUmfang oFzgUmfang = null;
        try {
            oFzgUmfang = new FzgUmfang(sMarke, sProduktart, sKatalogumfang, cDefaultRegionen);
            oFzgUmfang.updateRegionen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        Collection cRegionen = oFzgUmfang.getRegionen();
        Iterator iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            transferableMap.setValue(i + "region", iterator.next());
            ++i;
        }
        String sCount = Integer.toString(i - 1);
        transferableMap.setValue("count", sCount);
        transferableMap.setValue("fzgumfang", oFzgUmfang);
    }

    private void ladeFzgUmfangLenkungen(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        Vector<String> cDefaultRegionen = this.sessionInfo.getUserInfo().getRegionen();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            transferableMap.setValue("regionendefault", cDefaultRegionen);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FZGUMFANG_LENKUNGEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FzgUmfang oFzgUmfang = (FzgUmfang)transferableMap.getValue("fzgumfang");
        String[] aRegionen = (String[])transferableMap.getValue("regionen");
        try {
            oFzgUmfang.setSelRegionen(aRegionen);
            oFzgUmfang.updateLenkungen(sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        Collection cLenkungen = oFzgUmfang.getLenkungen();
        for (ValueAndNameSupport oObj : cLenkungen) {
            transferableMap.setValue(i + "lenkung", oObj.getValue());
            transferableMap.setValue(i + "benennung", oObj.getName());
            ++i;
        }
        String sCount = Integer.toString(i - 1);
        transferableMap.setValue("count", sCount);
        transferableMap.setValue("fzgumfang", oFzgUmfang);
    }

    private void ladeFzgUmfangBauarten(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        Vector<String> cDefaultRegionen = this.sessionInfo.getUserInfo().getRegionen();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            transferableMap.setValue("regionendefault", cDefaultRegionen);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FZGUMFANG_BAUARTEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FzgUmfang oFzgUmfang = (FzgUmfang)transferableMap.getValue("fzgumfang");
        String[] aRegionen = (String[])transferableMap.getValue("regionen");
        try {
            oFzgUmfang.setSelRegionen(aRegionen);
            oFzgUmfang.updateBauarten(sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        Collection cBauarten = oFzgUmfang.getBauarten();
        for (ValueAndNameSupport oObj : cBauarten) {
            transferableMap.setValue(i + "bauart", oObj.getValue());
            transferableMap.setValue(i + "benennung", oObj.getName());
            ++i;
        }
        String sCount = Integer.toString(i - 1);
        transferableMap.setValue("count", sCount);
        transferableMap.setValue("fzgumfang", oFzgUmfang);
    }

    private void ladeFzgUmfangBaureihen(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        Vector<String> cDefaultRegionen = this.sessionInfo.getUserInfo().getRegionen();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            transferableMap.setValue("regionendefault", cDefaultRegionen);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FZGUMFANG_BAUREIHEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FzgUmfang oFzgUmfang = (FzgUmfang)transferableMap.getValue("fzgumfang");
        String[] aRegionen = (String[])transferableMap.getValue("regionen");
        String[] aLenkungen = (String[])transferableMap.getValue("lenkungen");
        String[] aBauarten = (String[])transferableMap.getValue("bauarten");
        try {
            oFzgUmfang.setSelRegionen(aRegionen);
            oFzgUmfang.setSelLenkungen(aLenkungen);
            oFzgUmfang.setSelBauarten(aBauarten);
            oFzgUmfang.updateBaureihen(sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        Collection cBaureihen = oFzgUmfang.getBaureihen();
        for (ValueAndNameSupport oObj : cBaureihen) {
            transferableMap.setValue(i + "baureihe", oObj.getValue());
            transferableMap.setValue(i + "benennung", oObj.getName());
            ++i;
        }
        String sCount = Integer.toString(i - 1);
        transferableMap.setValue("count", sCount);
        transferableMap.setValue("fzgumfang", oFzgUmfang);
    }

    private void ladeFzgUmfangKarosserien(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        Vector<String> cDefaultRegionen = this.sessionInfo.getUserInfo().getRegionen();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("sprache", sLang);
            transferableMap.setValue("regionendefault", cDefaultRegionen);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FZGUMFANG_KAROSSERIEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FzgUmfang oFzgUmfang = (FzgUmfang)transferableMap.getValue("fzgumfang");
        String[] aRegionen = (String[])transferableMap.getValue("regionen");
        String[] aLenkungen = (String[])transferableMap.getValue("lenkungen");
        String[] aBaureihen = (String[])transferableMap.getValue("baureihen");
        try {
            oFzgUmfang.setSelRegionen(aRegionen);
            oFzgUmfang.setSelLenkungen(aLenkungen);
            oFzgUmfang.setSelBaureihen(aBaureihen);
            oFzgUmfang.updateKarosserien(sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        Collection cKarosserien = oFzgUmfang.getKarosserien();
        for (ValueAndNameSupport oObj : cKarosserien) {
            transferableMap.setValue(i + "karosserie", oObj.getValue());
            transferableMap.setValue(i + "benennung", oObj.getName());
            ++i;
        }
        String sCount = Integer.toString(i - 1);
        transferableMap.setValue("count", sCount);
        transferableMap.setValue("fzgumfang", oFzgUmfang);
    }

    private void ladeFzgUmfangModelle(TrfHashMap transferableMap) {
        Vector<String> cDefaultRegionen = this.sessionInfo.getUserInfo().getRegionen();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("regionendefault", cDefaultRegionen);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FZGUMFANG_MODELLE);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FzgUmfang oFzgUmfang = (FzgUmfang)transferableMap.getValue("fzgumfang");
        String[] aRegionen = (String[])transferableMap.getValue("regionen");
        String[] aLenkungen = (String[])transferableMap.getValue("lenkungen");
        String[] aBauarten = (String[])transferableMap.getValue("bauarten");
        String[] aBaureihen = (String[])transferableMap.getValue("baureihen");
        String[] aKarosserien = (String[])transferableMap.getValue("karosserien");
        try {
            oFzgUmfang.setSelRegionen(aRegionen);
            oFzgUmfang.setSelLenkungen(aLenkungen);
            oFzgUmfang.setSelBauarten(aBauarten);
            oFzgUmfang.setSelBaureihen(aBaureihen);
            oFzgUmfang.setSelKarosserien(aKarosserien);
            oFzgUmfang.updateModelle();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        int i = 1;
        Collection cModelle = oFzgUmfang.getModelle();
        Iterator iterator = cModelle.iterator();
        while (iterator.hasNext()) {
            transferableMap.setValue(i + "modell", iterator.next());
            ++i;
        }
        String sCount = Integer.toString(i - 1);
        transferableMap.setValue("count", sCount);
        transferableMap.setValue("fzgumfang", oFzgUmfang);
    }

    private void ladeFzgUmfangModellspalten(TrfHashMap transferableMap) {
        Vector<String> cDefaultRegionen = this.sessionInfo.getUserInfo().getRegionen();
        if (this.sessionInfo.doZentraleRecherche()) {
            transferableMap.setValue("regionendefault", cDefaultRegionen);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FZGUMFANG_MODELLSPALTEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FzgUmfang oFzgUmfang = (FzgUmfang)transferableMap.getValue("fzgumfang");
        String[] aRegionen = (String[])transferableMap.getValue("regionen");
        String[] aLenkungen = (String[])transferableMap.getValue("lenkungen");
        String[] aBauarten = (String[])transferableMap.getValue("bauarten");
        String[] aBaureihen = (String[])transferableMap.getValue("baureihen");
        String[] aKarosserien = (String[])transferableMap.getValue("karosserien");
        String[] aModelle = (String[])transferableMap.getValue("modelle");
        String sModellspaltenIDs = null;
        try {
            oFzgUmfang.setSelRegionen(aRegionen);
            oFzgUmfang.setSelLenkungen(aLenkungen);
            oFzgUmfang.setSelBauarten(aBauarten);
            oFzgUmfang.setSelBaureihen(aBaureihen);
            oFzgUmfang.setSelKarosserien(aKarosserien);
            oFzgUmfang.setSelModelle(aModelle);
            sModellspaltenIDs = oFzgUmfang.loadModellspalten();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("modellspaltenids", sModellspaltenIDs);
        transferableMap.setValue("fzgumfang", oFzgUmfang);
    }

    private void ladeErstbevorratungHgs(TrfHashMap transferableMap) {
        Erstbevorratung oErstbevorratung;
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_ERSTBEVORRATUNG_HGS);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sHgVon = (String)transferableMap.getValue("hgvon");
        String sHgBis = (String)transferableMap.getValue("hgbis");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        String sLenkung = (String)transferableMap.getValue("lenkung");
        try {
            oErstbevorratung = new Erstbevorratung();
            oErstbevorratung.loadHGs(sHgVon, sHgBis, sModellspaltenIDs, sLenkung);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("hgs", oErstbevorratung.getHGs());
    }

    private void ladeErstbevorratungTeile(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_ERSTBEVORRATUNG_ZU_HG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            Erstbevorratung oErstbevorratung = (Erstbevorratung)transferableMap.getValue("erstbevorratung");
            this.sessionInfo.setTempValue(oErstbevorratung);
            return;
        }
        String sHg = (String)transferableMap.getValue("hg");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        String sLenkung = (String)transferableMap.getValue("lenkung");
        Erstbevorratung oErstbevorratung = null;
        try {
            oErstbevorratung = new Erstbevorratung();
            oErstbevorratung.loadTeile(sLang, sHg, sModellspaltenIDs, sLenkung, sLandkuerzel);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        this.sessionInfo.setTempValue(oErstbevorratung);
        transferableMap.setValue("hg", sHg);
        transferableMap.setValue("genericteile", oErstbevorratung.getTeile(0));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oErstbevorratung.getAnzahlTeile(), oErstbevorratung.getAnzahlPakete(), 0);
        transferableMap.setValue("buttons", cButtons);
    }

    private void holeErstbevorratungTeileIndex(TrfHashMap transferableMap) {
        String sIndex = (String)transferableMap.getValue("index");
        int nIndex = sIndex == null ? -1 : Integer.parseInt(sIndex);
        Erstbevorratung oErstbevorratung = null;
        try {
            oErstbevorratung = (Erstbevorratung)this.sessionInfo.getTempValue();
        }
        catch (Exception e) {
            this.log.error("holeErstbevorratungTeileIndex: keine Erstbevorratungs-Objekt vorhanden");
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("genericteile", oErstbevorratung.getTeile(nIndex));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oErstbevorratung.getAnzahlTeile(), oErstbevorratung.getAnzahlPakete(), nIndex);
        transferableMap.setValue("buttons", cButtons);
    }

    private void ladeVisualisierung(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_VISUALISIERUNG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sMarke = (String)transferableMap.getValue("marke");
        Vector<String> aMarken = new Vector<String>();
        aMarken.add(sMarke);
        String sProdukt = (String)transferableMap.getValue("produktart");
        Vector<String> aProdukte = new Vector<String>();
        aProdukte.add(sProdukt);
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        VisualisierungTeil oVisualisierung = null;
        try {
            oVisualisierung = new VisualisierungTeil(sLang, aMarken, aProdukte, sSachnummer);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("btnummer", oVisualisierung.getBildtafelNummer());
        transferableMap.setValue("ueberschrift", oVisualisierung.getBildtafelUeberschrift());
        transferableMap.setValue("imgts", oVisualisierung.getGrafikTimestamp());
        transferableMap.setValue("imgid", oVisualisierung.getGrafikId());
        transferableMap.setValue("imgformat", oVisualisierung.getGrafikFormat());
        transferableMap.setValue("nummer", oVisualisierung.getBildnummer());
        transferableMap.setValue("teilenummer", oVisualisierung.getTeilenummer());
        transferableMap.setValue("benennung_string", oVisualisierung.getTeilebenennung());
        transferableMap.setValue("zusatz", oVisualisierung.getTeilebenennungZusatz());
    }

    private void ladeTeileersetzungHgs(TrfHashMap transferableMap) {
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEERSETZUNG_HGS);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sHgVon = (String)transferableMap.getValue("hgvon");
        String sHgBis = (String)transferableMap.getValue("hgbis");
        String sDatumAbTag = (String)transferableMap.getValue("tag");
        String sDatumAbMonat = (String)transferableMap.getValue("monat");
        String sDatumAbJahr = (String)transferableMap.getValue("jahr");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        String sLenkung = (String)transferableMap.getValue("lenkung");
        long lDatumAb = 0L;
        if (!(sDatumAbTag.equals("") || sDatumAbMonat.equals("") || sDatumAbJahr.equals(""))) {
            lDatumAb = Long.parseLong(sDatumAbJahr) * 10000L + Long.parseLong(sDatumAbMonat) * 100L + Long.parseLong(sDatumAbTag);
        }
        Teileersetzung oTeileersetzung = null;
        try {
            oTeileersetzung = new Teileersetzung();
            oTeileersetzung.loadHGs(sHgVon, sHgBis, lDatumAb, sModellspaltenIDs, sLenkung);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("hgs", oTeileersetzung.getHGs());
    }

    private void ladeTeileersetzungTeile(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEERSETZUNG_ZU_HG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            Teileersetzung oTeileersetzung = (Teileersetzung)transferableMap.getValue("teileersetzung");
            this.sessionInfo.setTempValue(oTeileersetzung);
            return;
        }
        String sHg = (String)transferableMap.getValue("hg");
        String sDatumAbTag = (String)transferableMap.getValue("tag");
        String sDatumAbMonat = (String)transferableMap.getValue("monat");
        String sDatumAbJahr = (String)transferableMap.getValue("jahr");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        String sLenkung = (String)transferableMap.getValue("lenkung");
        long lDatumAb = 0L;
        if (!(sDatumAbTag.equals("") || sDatumAbMonat.equals("") || sDatumAbJahr.equals(""))) {
            lDatumAb = Long.parseLong(sDatumAbJahr) * 10000L + Long.parseLong(sDatumAbMonat) * 100L + Long.parseLong(sDatumAbTag);
        }
        Teileersetzung oTeileersetzung = null;
        try {
            oTeileersetzung = new Teileersetzung();
            oTeileersetzung.loadTeile(sLang, sHg, lDatumAb, sModellspaltenIDs, sLenkung, sLandkuerzel);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        this.sessionInfo.setTempValue(oTeileersetzung);
        transferableMap.setValue("hg", sHg);
        transferableMap.setValue("teilersetzung_teile", oTeileersetzung.getTeile(0));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oTeileersetzung.getAnzahlTeile(), oTeileersetzung.getAnzahlPakete(), 0);
        transferableMap.setValue("buttons", cButtons);
    }

    private void holeTeileersetzungTeileIndex(TrfHashMap transferableMap) {
        String sIndex = (String)transferableMap.getValue("index");
        int nIndex = sIndex == null ? -1 : Integer.parseInt(sIndex);
        Teileersetzung oTeileersetzung = null;
        try {
            oTeileersetzung = (Teileersetzung)this.sessionInfo.getTempValue();
        }
        catch (Exception e) {
            this.log.error("holeTeileersetzungTeileIndex: kein Teileersetzung-Objekt vorhanden");
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("teilersetzung_teile", oTeileersetzung.getTeile(nIndex));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oTeileersetzung.getAnzahlTeile(), oTeileersetzung.getAnzahlPakete(), nIndex);
        transferableMap.setValue("buttons", cButtons);
    }

    private void ladeTeileverwendungFzgHgs(TrfHashMap transferableMap) {
        Teilevwdgfzg oTeileverwendungFzg;
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEVERWENDUNGFZG_HGS);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sHgVon = (String)transferableMap.getValue("hgvon");
        String sHgBis = (String)transferableMap.getValue("hgbis");
        String sDatumAbTag = (String)transferableMap.getValue("tag");
        String sDatumAbMonat = (String)transferableMap.getValue("monat");
        String sDatumAbJahr = (String)transferableMap.getValue("jahr");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        String sLenkung = (String)transferableMap.getValue("lenkung");
        long lDatumAb = 0L;
        if (!(sDatumAbTag.equals("") || sDatumAbMonat.equals("") || sDatumAbJahr.equals(""))) {
            lDatumAb = Long.parseLong(sDatumAbJahr) * 10000L + Long.parseLong(sDatumAbMonat) * 100L + Long.parseLong(sDatumAbTag);
        }
        try {
            oTeileverwendungFzg = new Teilevwdgfzg();
            oTeileverwendungFzg.loadHGs(sHgVon, sHgBis, lDatumAb, sModellspaltenIDs, sLenkung);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("hgs", oTeileverwendungFzg.getHGs());
    }

    private void ladeTeileverwendungFzgTeile(TrfHashMap transferableMap) {
        Teilevwdgfzg oTeileverwendungFzg;
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEVERWENDUNGFZG_ZU_HG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            Teilevwdgfzg oTeileverwendung = (Teilevwdgfzg)transferableMap.getValue("teileverwendung");
            this.sessionInfo.setTempValue(oTeileverwendung);
            return;
        }
        String sHg = (String)transferableMap.getValue("hg");
        String sDatumAbTag = (String)transferableMap.getValue("tag");
        String sDatumAbMonat = (String)transferableMap.getValue("monat");
        String sDatumAbJahr = (String)transferableMap.getValue("jahr");
        String sNurInSelFzg = (String)transferableMap.getValue("nurinselfzg");
        boolean bNurInFzg = "true".equals(sNurInSelFzg);
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        String sLenkung = (String)transferableMap.getValue("lenkung");
        long lDatumAb = 0L;
        if (!(sDatumAbTag.equals("") || sDatumAbMonat.equals("") || sDatumAbJahr.equals(""))) {
            lDatumAb = Long.parseLong(sDatumAbJahr) * 10000L + Long.parseLong(sDatumAbMonat) * 100L + Long.parseLong(sDatumAbTag);
        }
        try {
            oTeileverwendungFzg = new Teilevwdgfzg();
            oTeileverwendungFzg.loadTeile(sLang, sHg, lDatumAb, bNurInFzg, sModellspaltenIDs, sLenkung, sLandkuerzel);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        this.sessionInfo.setTempValue(oTeileverwendungFzg);
        transferableMap.setValue("hg", sHg);
        transferableMap.setValue("teileverwendung_teile", oTeileverwendungFzg.getTeile(0));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oTeileverwendungFzg.getAnzahlTeile(), oTeileverwendungFzg.getAnzahlPakete(), 0);
        transferableMap.setValue("buttons", cButtons);
    }

    private void holeTeileverwendungFzgTeileIndex(TrfHashMap transferableMap) {
        Teilevwdgfzg oTeileverwendungFzg;
        String sIndex = (String)transferableMap.getValue("index");
        int nIndex = sIndex == null ? -1 : Integer.parseInt(sIndex);
        try {
            oTeileverwendungFzg = (Teilevwdgfzg)this.sessionInfo.getTempValue();
        }
        catch (Exception e) {
            this.log.error("holeTeileverwendungFzgTeileIndex: keine Teileverwendung vorhanden");
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("teileverwendung_teile", oTeileverwendungFzg.getTeile(nIndex));
        Collection cButtons = WebetkUtils.evalHgBlaetterButtons(oTeileverwendungFzg.getAnzahlTeile(), oTeileverwendungFzg.getAnzahlPakete(), nIndex);
        transferableMap.setValue("buttons", cButtons);
    }

    private void ladeTeileverwendungTeil(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
        Vector<String> cRegionen = this.sessionInfo.getUserInfo().getRegionen();
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        String sBaureiheExp = (String)transferableMap.getValue("baureihe_string");
        if (sBaureiheExp == null || sBaureiheExp.equals("")) {
            this.sessionInfo.setSachnummerSuch(sSachnummer);
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("user_id", sNutzerId);
                transferableMap.setValue("firmaid", sFirmaId);
                transferableMap.setValue("regionendefault", cRegionen);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEVERWENDUNGTEIL);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        Teilevwdgteil oTeileverwendungTeil = null;
        try {
            oTeileverwendungTeil = new Teilevwdgteil(sFirmaId, sNutzerId, sMarke, sProduktart, sKatalogumfang, sModellspaltenIDs, sSachnummer, null, null);
            oTeileverwendungTeil.loadBaureihen(sBaureiheExp, sLang, cRegionen);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("baureihenListe", oTeileverwendungTeil.getBaureihen());
    }

    private void ladeTeileverwendungBenennung(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
        Vector<String> cRegionen = this.sessionInfo.getUserInfo().getRegionen();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("user_id", sNutzerId);
                transferableMap.setValue("firmaid", sFirmaId);
                transferableMap.setValue("regionendefault", cRegionen);
                SessionInfoDez oSessionInfoDez = new SessionInfoDez();
                oSessionInfoDez.setMbAusweisungenElementeAktiv(this.sessionInfo.isAusweisungenElementeAktiv());
                oSessionInfoDez.setMbNachruestungenRelevant(this.sessionInfo.getUserInfo().getNachruestungenRelevant());
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    oSessionInfoDez.setMoBedingungswerte_BTE(this.sessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE());
                } else {
                    oSessionInfoDez.setMoBedingungswerte_BTE(null);
                }
                transferableMap.setValue("sesseionInfoDez", oSessionInfoDez);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEVERWENDUNGBEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        String sBaureiheExp = (String)transferableMap.getValue("baureihe");
        String sModus = (String)transferableMap.getValue("modus");
        List cSachnummern = null;
        String sSuchbegriff = null;
        if (sModus.equals("suchesuchbegriff")) {
            sSuchbegriff = (String)transferableMap.getValue("suchbegriff");
        }
        if (sModus.equals("suchesachnummer")) {
            cSachnummern = (List)transferableMap.getValue("sachnummern");
        }
        Teilevwdgben oTeileverwendungBen = null;
        try {
            oTeileverwendungBen = new Teilevwdgben(sFirmaId, sNutzerId, sMarke, sProduktart, sKatalogumfang, sModellspaltenIDs, sSuchbegriff, cSachnummern);
            oTeileverwendungBen.loadBaureihen(sBaureiheExp, sLang, cRegionen);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("baureihenListe", oTeileverwendungBen.getBaureihen());
        transferableMap.setValue("Teilevwdgben", oTeileverwendungBen);
    }

    private void ladeTeileverwendungTeilInfo(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sSettingsMarke = this.sessionInfo.getUserInfo().getProduktart();
        String sSettingsProduktart = this.sessionInfo.getUserInfo().getProduktart();
        Collection<String> aMarkenBerechtigungen = this.sessionInfo.getUserMarken();
        Collection<String> aProdukteBerechtigung = this.sessionInfo.getUserProdukte();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("user_id", sNutzerId);
                transferableMap.setValue("firmaid", sFirmaId);
                transferableMap.setValue("marken_berechtigungen", aMarkenBerechtigungen);
                transferableMap.setValue("marke_settings", sSettingsMarke);
                transferableMap.setValue("produkte_berechtigungen", aProdukteBerechtigung);
                transferableMap.setValue("produktart_settings", sSettingsProduktart);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.CHECK_TEILEVERWENDUNGTEIL);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sMarke = (String)transferableMap.getValue("marke");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        Teilevwdgteil oTeileverwendungTeil = null;
        boolean bExist = true;
        try {
            oTeileverwendungTeil = new Teilevwdgteil(sFirmaId, sNutzerId, sMarke, sProduktart, sKatalogumfang, sModellspaltenIDs, sSachnummer, null, null);
            bExist = oTeileverwendungTeil.loadTeil(aMarkenBerechtigungen, sSettingsMarke, aProdukteBerechtigung, sSettingsProduktart, sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        if (!bExist) {
            transferableMap.setError(new NoDataFoundException("Teil nicht im Teilestamm enthalten"));
        } else {
            String sTeilenummer = oTeileverwendungTeil.getTeilenummer();
            String sBenennung = oTeileverwendungTeil.getBenennung();
            String sHG = oTeileverwendungTeil.getHgUg().substring(0, 2);
            String sUG = oTeileverwendungTeil.getHgUg().substring(2, 4);
            GenericTeil t = new GenericTeil();
            t.setBenennung(oTeileverwendungTeil.getBenennung());
            t.setSachnummer(sSachnummer);
            t.setHG(sHG);
            t.setUG(sUG);
            transferableMap.setValue("genericteil", t);
        }
    }

    private void ladeTeileverwendungReduziert(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEVERWENDUNG_REDUZIERT);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        String sModellspaltenIDs = (String)transferableMap.getValue("modellspaltenids");
        Teileverwendung oTeileverwendung = null;
        try {
            oTeileverwendung = new Teileverwendung(sSachnummer, sModellspaltenIDs, sLang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("ueberschrift", oTeileverwendung.getUeberschrift());
        int i = 1;
        Collection cZeilen = oTeileverwendung.getZeilen();
        for (Hashtable oHashtable : cZeilen) {
            transferableMap.setValue(i + "baureihe", oHashtable.get("Baureihe"));
            transferableMap.setValue(i + "modell", oHashtable.get("Modell"));
            transferableMap.setValue(i + "karosserie", oHashtable.get("Karosserie"));
            transferableMap.setValue(i + "region", oHashtable.get("Region"));
            ++i;
        }
    }

    private void ladeTeilenotizen(TrfHashMap transferableMap) {
        String sNutzer = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sHg = (String)transferableMap.getValue("hg");
        String sInit = (String)transferableMap.getValue("isinit");
        boolean bInit = sInit != null && sInit.equals("isinit");
        Notizuebersicht oNotizen = null;
        try {
            oNotizen = new Notizuebersicht(sNutzer, sFirma, sLang);
            if (bInit) {
                oNotizen.loadTeileFirstHG();
            } else if (sHg == null || sHg.equals("")) {
                oNotizen.loadTeileAllHGs();
            } else {
                oNotizen.loadTeileZuHG(sHg);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<webetk.app.notizuebersicht.Teil> teile = new Vector<webetk.app.notizuebersicht.Teil>();
        webetk.app.notizuebersicht.Teil oPrevTeil = null;
        Collection<webetk.app.notizuebersicht.Teil> cTeile = oNotizen.getTeile();
        if (cTeile != null) {
            for (webetk.app.notizuebersicht.Teil oTeil : cTeile) {
                if (oPrevTeil == null) {
                    oPrevTeil = oTeil;
                }
                if (!oPrevTeil.getTeilenummer().equals(oTeil.getTeilenummer())) {
                    teile.add(oPrevTeil);
                    oPrevTeil = oTeil;
                    continue;
                }
                if (oPrevTeil.getGueltigBis().equals(oTeil.getGueltigBis())) continue;
                oPrevTeil.setGueltigBis("*");
            }
            if (oPrevTeil != null) {
                teile.add(oPrevTeil);
            }
        }
        transferableMap.setValue("teilenotiz", teile);
        transferableMap.setValue("count", Integer.toString(oNotizen.getAnzTeile()));
        transferableMap.setValue("hgvon", oNotizen.getFirstHG());
    }

    private void ladeNotiz(TrfHashMap transferableMap) {
        Notiz oNotiz;
        String sNutzer = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        try {
            String sLang = this.sessionInfo.getAktuelleSprache();
            oNotiz = new Notiz(sLang);
            oNotiz.load(sNutzer, sFirma, sSachnummer);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("notiz_objekt", oNotiz);
    }

    private void ladeTeilesucheHgFg(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIstFzg = (String)transferableMap.getValue("isfzg");
        boolean bIstFzg = sIstFzg != null && !sIstFzg.equals("false");
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        long lModellspalte = 0L;
        String sGetriebe = "N";
        if (bIstFzg) {
            if (this.sessionInfo.getFzgIdInfo() != null) {
                FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
                sMarke = oFzgIdInfo.getMarke();
                sProduktart = oFzgIdInfo.getProduktart();
                sKatalogumfang = oFzgIdInfo.getKatalogumfang();
                lModellspalte = oFzgIdInfo.getModellspalte();
                sGetriebe = oFzgIdInfo.getGetriebe();
            }
        } else {
            sMarke = (String)transferableMap.getValue("marke");
            sProduktart = (String)transferableMap.getValue("produktart");
            sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                transferableMap.setValue("katalogumfang", sKatalogumfang);
                if (bIstFzg) {
                    transferableMap.setValue("modellspaltenid", lModellspalte);
                    transferableMap.setValue("getriebe", sGetriebe);
                }
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILESUCHE_HGFG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        HGFGs oHgFgs = new HGFGs(new Vector());
        try {
            if (bIstFzg) {
                oHgFgs.loadAllHGFGs(false, lModellspalte, sMarke, sLang, sGetriebe);
            } else {
                oHgFgs.loadAllHGFGs(false, sMarke, sLang, sProduktart, sKatalogumfang);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<HauptgruppeTO> hauptgruppen = new ArrayList<HauptgruppeTO>();
        try {
            oHgFgs.goFirst();
            while (true) {
                HauptgruppeTO hauptgruppeTO = new HauptgruppeTO(oHgFgs.getCurrentHG(), oHgFgs.getCurrentName(), null);
                hauptgruppen.add(hauptgruppeTO);
                Collection cFgs = oHgFgs.getFGs(oHgFgs.getCurrentHG());
                for (HGFGs.HGFGData hgfgData : cFgs) {
                    hauptgruppeTO.addFunktionsgruppe(new FunktionsgruppeTO(hgfgData.getHG(), hgfgData.getFG(), hgfgData.getName()));
                }
                if (oHgFgs.hasNext()) {
                    oHgFgs.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
        transferableMap.setValue("hgfgs", hauptgruppen);
    }

    private void ladeTeilesucheGrafHg(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIstFzg = (String)transferableMap.getValue("isfzg");
        boolean bIstFzg = sIstFzg != null && sIstFzg.equals("true");
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        long lModellspalte = 0L;
        String sGetriebe = "N";
        if (bIstFzg) {
            if (this.sessionInfo.getFzgIdInfo() != null) {
                FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
                sMarke = oFzgIdInfo.getMarke();
                sProduktart = oFzgIdInfo.getProduktart();
                sKatalogumfang = oFzgIdInfo.getKatalogumfang();
                lModellspalte = oFzgIdInfo.getModellspalte();
                sGetriebe = oFzgIdInfo.getGetriebe();
            }
        } else {
            sMarke = (String)transferableMap.getValue("marke");
            sProduktart = (String)transferableMap.getValue("produktart");
            sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
        }
        boolean bZentraleSuche = this.sessionInfo.doZentraleRecherche();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                transferableMap.setValue("katalogumfang", sKatalogumfang);
                if (bIstFzg) {
                    transferableMap.setValue("modellspaltenid", lModellspalte);
                    transferableMap.setValue("getriebe", sGetriebe);
                }
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILESUCHE_GRAF_HG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        HGFGs oHgs = new HGFGs(null);
        try {
            if (bIstFzg) {
                oHgs.loadHGFGs(true, bZentraleSuche, lModellspalte, sMarke, sLang, sGetriebe);
            } else {
                oHgs.loadHGFGs(true, bZentraleSuche, sMarke, sLang, sProduktart, sKatalogumfang);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<HauptgruppeTO> mHauptgruppen = new ArrayList<HauptgruppeTO>();
        try {
            oHgs.goFirst();
            int i = 1;
            while (true) {
                mHauptgruppen.add(new HauptgruppeTO(oHgs.getCurrentHG(), oHgs.getCurrentName(), oHgs.getCurrentGrafik()));
                ++i;
                if (oHgs.hasNext()) {
                    oHgs.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
        transferableMap.setValue("hgfgs", mHauptgruppen);
    }

    private void ladeTeilesucheGrafFg(TrfHashMap transferableMap) {
        boolean bZentraleSuche;
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIstFzg = (String)transferableMap.getValue("isfzg");
        boolean bIstFzg = sIstFzg != null && sIstFzg.equals("true");
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        String sHG = (String)transferableMap.getValue("hg");
        long lModellspalte = 0L;
        String sGetriebe = "N";
        if (bIstFzg) {
            if (this.sessionInfo.getFzgIdInfo() != null) {
                FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
                sMarke = oFzgIdInfo.getMarke();
                sProduktart = oFzgIdInfo.getProduktart();
                sKatalogumfang = oFzgIdInfo.getKatalogumfang();
                lModellspalte = oFzgIdInfo.getModellspalte();
                sGetriebe = oFzgIdInfo.getGetriebe();
            }
        } else {
            sMarke = (String)transferableMap.getValue("marke");
            sProduktart = (String)transferableMap.getValue("produktart");
            sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
        }
        if (bZentraleSuche = this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("produktart", sProduktart);
                transferableMap.setValue("katalogumfang", sKatalogumfang);
                transferableMap.setValue("hg", sHG);
                if (bIstFzg) {
                    transferableMap.setValue("modellspaltenid", lModellspalte);
                    transferableMap.setValue("getriebe", sGetriebe);
                }
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILESUCHE_GRAF_FG);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        boolean bMitGrafiken = true;
        try {
            FGs fgs = null;
            fgs = bIstFzg ? TeileSucheFzgDbAccess.getFGGrafMosp(sHG, lModellspalte, sMarke, sLang, bMitGrafiken) : TeileSucheFzgDbAccess.getFGGraf(sHG, sMarke, sProduktart, sLang, bMitGrafiken);
            transferableMap.setValue("FGOBJECT", fgs);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void checkTeilesucheBt(TrfHashMap transferableMap) {
        int nErgebnis;
        String sFGSuche;
        String sHg = (String)transferableMap.getValue("hg");
        Vector<String> aHg = new Vector<String>();
        aHg.add(sHg);
        Vector<String> aFg = (Vector<String>)transferableMap.getValue("fgs");
        if (aFg == null) {
            aFg = new Vector<String>();
        }
        boolean bFGSuche = (sFGSuche = (String)transferableMap.getValue("fgsuche")) == null || sFGSuche.equals("true");
        String sIstFzg = (String)transferableMap.getValue("isfzg");
        boolean bIstFzg = sIstFzg != null && sIstFzg.equals("true");
        SucheInfo oSucheInfo = null;
        if (bIstFzg) {
            oSucheInfo = this.sessionInfo.getFzgSucheInfo();
        } else {
            String sMarke = (String)transferableMap.getValue("marke");
            String sProduktart = (String)transferableMap.getValue("produktart");
            String sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
            oSucheInfo = new AssSucheInfo();
            oSucheInfo.setMarke(sMarke);
            oSucheInfo.setProduktart(sProduktart);
            oSucheInfo.setKatalogumfang(sKatalogumfang);
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sucheinfo", oSucheInfo);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.CHECK_TEILESUCHE_GRAF_BT);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            BaseHgFgSuche oSuche;
            if (bIstFzg) {
                oSuche = new HGFGSuche(aHg, null, aFg, true, true, false, false, bFGSuche);
                nErgebnis = ((HGFGSuche)oSuche).checkSearch_grafisch(oSucheInfo);
            } else {
                oSuche = new webetk.app.asssuche.HGFGSuche(aHg, null, aFg, true, true, false, false, bFGSuche);
                nErgebnis = ((webetk.app.asssuche.HGFGSuche)oSuche).checkSearch_grafisch(oSucheInfo);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        if (nErgebnis == 4) {
            transferableMap.setError(new NoDataFoundException("keine Daten gefunden"));
        }
    }

    private void ladeTeilesucheGrafBt(TrfHashMap transferableMap) {
        int nErgebnis;
        BaseHgFgSuche oSuche;
        String sIstFzg;
        Vector<String> aFg;
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sHg = (String)transferableMap.getValue("hg");
        String sFGSuche = (String)transferableMap.getValue("fgsuche");
        boolean bFGSuche = sFGSuche == null || sFGSuche.equals("true");
        Vector<String> aHg = (Vector<String>)transferableMap.getValue("hgfg");
        if (aHg == null) {
            aHg = new Vector<String>();
            aHg.add(sHg);
        }
        if ((aFg = (Vector<String>)transferableMap.getValue("fgs")) == null) {
            aFg = new Vector<String>();
        }
        boolean bIstFzg = (sIstFzg = (String)transferableMap.getValue("isfzg")) != null && sIstFzg.equals("true");
        SearchBTETeile.PartOrBTE.PartOrBTEHelper oPoBHelper = null;
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        SucheInfo oSucheInfo = null;
        if (bIstFzg) {
            if (this.sessionInfo.getFzgIdInfo() != null) {
                FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
                oSucheInfo = this.sessionInfo.getFzgSucheInfo();
                sMarke = oFzgIdInfo.getMarke();
                sProduktart = oFzgIdInfo.getProduktart();
                sKatalogumfang = oFzgIdInfo.getKatalogumfang();
                this.log.info("oSucheInfo: " + oSucheInfo.getSuchHG());
                FzgSucheInfo oFzgSucheInfo = this.sessionInfo.getFzgSucheInfo();
                oPoBHelper = new SearchBTETeile.PartOrBTE.PartOrBTEHelper(this.sessionInfo.isAusweisungenElementeAktiv(), oFzgSucheInfo.getModellspalte(), sLang, this.sessionInfo.getUserInfo().getNachruestungenRelevant(), oFzgSucheInfo.getRegion().equals("USA"), oFzgSucheInfo.getFahrgestellnummer() != null && !oFzgSucheInfo.getFahrgestellnummer().equals(""), oFzgSucheInfo.getBedingungsMenge_BTE());
            }
        } else {
            sMarke = (String)transferableMap.getValue("marke");
            sProduktart = (String)transferableMap.getValue("produktart");
            sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
            if (sMarke == null) {
                oSucheInfo = this.sessionInfo.getAssSucheInfo();
                this.log.info("oSucheInfo: " + oSucheInfo.getSuchHG());
            } else {
                oSucheInfo = this.sessionInfo.newAssSucheInfo();
                this.log.info("oSucheInfo: " + oSucheInfo.getSuchHG());
                oSucheInfo.setMarke(sMarke);
                oSucheInfo.setProduktart(sProduktart);
                oSucheInfo.setKatalogumfang(sKatalogumfang);
            }
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                String key = this.getSuchInfoKey(oSucheInfo);
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue(key, oSucheInfo);
                SessionInfoDez oSessionInfoDez = new SessionInfoDez();
                oSessionInfoDez.setMbAusweisungenElementeAktiv(this.sessionInfo.isAusweisungenElementeAktiv());
                oSessionInfoDez.setMbNachruestungenRelevant(this.sessionInfo.getUserInfo().getNachruestungenRelevant());
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    oSessionInfoDez.setMoBedingungswerte_BTE(this.sessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE());
                } else {
                    oSessionInfoDez.setMoBedingungswerte_BTE(null);
                }
                transferableMap.setValue("sesseionInfoDez", oSessionInfoDez);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILESUCHE_GRAF_BT_NEU);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        try {
            oSuche = bIstFzg ? new HGFGSuche(aHg, sHg, aFg, true, true, false, false, bFGSuche) : new webetk.app.asssuche.HGFGSuche(aHg, sHg, aFg, true, true, false, false, bFGSuche);
            nErgebnis = ((SearchBTETeile)oSuche).performSearch(oSucheInfo, sLang, this.sessionInfo);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        if (nErgebnis == 4) {
            transferableMap.setValue("count", "0");
        } else {
            Collection<SearchBTETeile.PartOrBTE> partOrBTEList = oSuche.getBTEs();
            transferableMap.setValue("btes", partOrBTEList);
            transferableMap.setValue("count", Integer.toString(partOrBTEList.size()));
        }
        this.sessionInfo.setSearchBTETeile(oSuche);
        int nIndexHGPrev = -1;
        int nIndexHGNext = -1;
        int nIndexFGPrev = -1;
        int nIndexFGNext = -1;
        if (oSuche instanceof webetk.app.asssuche.HGFGSuche) {
            AssSucheInfo oAssSucheInfoSrc = (AssSucheInfo)oSucheInfo;
            JavaAssSucheInfo oAssSucheInfo = new JavaAssSucheInfo(oAssSucheInfoSrc);
            transferableMap.setValue("asssucheinfo_java", oAssSucheInfo);
            nIndexHGPrev = ((webetk.app.asssuche.HGFGSuche)oSuche).getIndexPrevHG();
            nIndexHGNext = ((webetk.app.asssuche.HGFGSuche)oSuche).getIndexNextHG();
            nIndexFGPrev = ((webetk.app.asssuche.HGFGSuche)oSuche).getIndexPrevFG();
            nIndexFGNext = ((webetk.app.asssuche.HGFGSuche)oSuche).getIndexNextFG();
        }
        if (oSuche instanceof HGFGSuche) {
            nIndexHGPrev = ((HGFGSuche)oSuche).getIndexPrevHG();
            nIndexHGNext = ((HGFGSuche)oSuche).getIndexNextHG();
            nIndexFGPrev = ((HGFGSuche)oSuche).getIndexPrevFG();
            nIndexFGNext = ((HGFGSuche)oSuche).getIndexNextFG();
            FzgSucheInfo oFzgSucheInfoSrc = (FzgSucheInfo)oSucheInfo;
            JavaFzgSucheInfo oFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfoSrc);
            transferableMap.setValue("fzgsucheinfo_java", oFzgSucheInfo);
        }
        transferableMap.setValue("index_prev_hg", Integer.toString(nIndexHGPrev));
        transferableMap.setValue("index_next_hg", Integer.toString(nIndexHGNext));
        transferableMap.setValue("index_prev_fg", Integer.toString(nIndexFGPrev));
        transferableMap.setValue("index_next_fg", Integer.toString(nIndexFGNext));
    }

    private String getSuchInfoKey(SucheInfo oSucheInfo) {
        String key = oSucheInfo instanceof AssSucheInfo ? "asssuche_info_ass" : (oSucheInfo instanceof FzgSucheInfo ? "fzgsucheinfo_app" : "sucheinfo");
        return key;
    }

    private void ladeEinstellungenSprachen(TrfHashMap transferableMap) {
        WertebereichSprachen wbSprachen = new WertebereichSprachen();
        try {
            wbSprachen.load();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        ArrayList<String> isoList = new ArrayList<String>();
        ArrayList<String> regisoList = new ArrayList<String>();
        ArrayList<String> benennungList = new ArrayList<String>();
        Iterator<Sprache> iterator = wbSprachen.iteratorSprachen();
        while (iterator.hasNext()) {
            Sprache oSprache = iterator.next();
            isoList.add(oSprache.getISO());
            String regiso = oSprache.getRegISO();
            regiso = regiso == null ? "" : regiso;
            regisoList.add(regiso);
            benennungList.add(oSprache.getBenennung());
        }
        transferableMap.setValue("iso_list", isoList);
        transferableMap.setValue("regiso_list", regisoList);
        transferableMap.setValue("benennung_list", benennungList);
    }

    private void ladeEinstellungenRegionen(TrfHashMap transferableMap) {
        WertebereichRegionen wbRegionen = new WertebereichRegionen();
        try {
            wbRegionen.load();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("region", wbRegionen.getRegionen());
    }

    private void checkSettings(TrfHashMap transferableMap) {
        EinstellungenBasis oEinstellungenBasis = (EinstellungenBasis)transferableMap.getValue("einstellungen");
        Einstellungen oEinstellungen = new Einstellungen(oEinstellungenBasis);
        boolean bOK = false;
        try {
            bOK = oEinstellungen.checkModellspalte();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        if (!bOK) {
            transferableMap.setError(new NoDataFoundException());
        }
    }

    private void saveSettings(TrfHashMap transferableMap) {
        String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        EinstellungenBasis oEinstellungenBasis = (EinstellungenBasis)transferableMap.getValue("einstellungen");
        Einstellungen oEinstellungen = new Einstellungen(oEinstellungenBasis);
        try {
            oEinstellungen.writeToDB(sFirmaId, sNutzerId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        this.sessionInfo.getUserInfo().setSettings(oEinstellungen);
    }

    private void setSettings(TrfHashMap transferableMap) {
        EinstellungenBasis oEinstellungenBasis = (EinstellungenBasis)transferableMap.getValue("einstellungen");
        Einstellungen oEinstellungen = new Einstellungen(oEinstellungenBasis);
        this.sessionInfo.getUserInfo().setSettings(oEinstellungen);
    }

    private void ladeFuellmengen(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
        if (oFzgIdInfo == null) {
            transferableMap.setError(new InvalidDataException("keine FI gefunden"));
            return;
        }
        List<String> cTypen = oFzgIdInfo.getTypmenge();
        String sBaujahr = oFzgIdInfo.getBaujahr();
        String sZulassungsmonat = oFzgIdInfo.getZulMonat();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("typen", cTypen);
                transferableMap.setValue("baujahr", sBaujahr);
                transferableMap.setValue("zulmonat", sZulassungsmonat);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FUELLMENGEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FMZeilen oZeilen = null;
        try {
            oZeilen = new FMZeilen(sLang, cTypen, sZulassungsmonat, sBaujahr);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("fuellmengen", oZeilen);
        if (oZeilen.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine F\u00fcllmengen gefunden!"));
        }
    }

    private void ladeFedertabelleSonderausstattungen(TrfHashMap transferableMap) {
        String sIsTagesgenau;
        String sLang = this.sessionInfo.getAktuelleSprache();
        FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
        if (oFzgIdInfo == null) {
            transferableMap.setError(new InvalidDataException("keine FI gefunden"));
            return;
        }
        String sMarke = oFzgIdInfo.getMarke();
        List<String> cTypen = oFzgIdInfo.getTypmenge();
        String sProduktionsdatum = oFzgIdInfo.getProduktionsdatum(true);
        boolean bIsTagesgenau = oFzgIdInfo.isProduktionsdatumTagesgenau();
        String string = sIsTagesgenau = bIsTagesgenau ? "true" : "false";
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("typen", cTypen);
                transferableMap.setValue("ProdDatum", sProduktionsdatum);
                transferableMap.setValue("istagesgenau", sIsTagesgenau);
                String sBaujahr = oFzgIdInfo.getBaujahr();
                String sZulassungsmonat = oFzgIdInfo.getZulMonat();
                transferableMap.setValue("baujahr", sBaujahr);
                transferableMap.setValue("zulmonat", sZulassungsmonat);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FT_SONDERAUSSTATTUNGEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FedertabelleInfo oFTInfo = new FedertabelleInfo(sMarke);
        try {
            oFTInfo.performSalaLoad(sLang, cTypen, sProduktionsdatum, bIsTagesgenau);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("sala_zeilen_links", oFTInfo.getSalaZeilenLeft());
        transferableMap.setValue("sala_zeilen_rechts", oFTInfo.getSalaZeilenRight());
    }

    private void ladeFedertabelleFedern(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
        SucheInfo oSucheInfo = this.sessionInfo.getSucheInfo();
        if (oFzgIdInfo == null) {
            transferableMap.setError(new InvalidDataException("keine FI gefunden"));
            return;
        }
        String sMarke = oFzgIdInfo.getMarke();
        List<String> cTypen = oFzgIdInfo.getTypmenge();
        String sProduktionsdatum = oFzgIdInfo.getProduktionsdatum(true);
        boolean bIsTagesgenau = oFzgIdInfo.isProduktionsdatumTagesgenau();
        String sIsTagesgenau = bIsTagesgenau ? "true" : "false";
        Collection cSalaIds = (Collection)transferableMap.getValue("salaids");
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("fzgidinfo_app", oFzgIdInfo);
                transferableMap.setValue(this.getSuchInfoKey(oSucheInfo), oSucheInfo);
                transferableMap.setValue("marke", sMarke);
                transferableMap.setValue("typen", cTypen);
                transferableMap.setValue("ProdDatum", sProduktionsdatum);
                transferableMap.setValue("istagesgenau", sIsTagesgenau);
                String sBaujahr = oFzgIdInfo.getBaujahr();
                String sZulassungsmonat = oFzgIdInfo.getZulMonat();
                transferableMap.setValue("baujahr", sBaujahr);
                transferableMap.setValue("zulmonat", sZulassungsmonat);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_FT_FEDERN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        FedertabelleInfo oFTInfo = new FedertabelleInfo(sMarke);
        try {
            oFTInfo.performFedertabelleEval(cTypen, sProduktionsdatum, bIsTagesgenau, cSalaIds, this.sessionInfo.getFzgIdInfo(), this.sessionInfo.getSucheInfo());
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        boolean i = true;
        FTZeilen oZeilen = oFTInfo.getFTZeilen();
        if (oZeilen.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Federtabellen gefunden!"));
        } else {
            transferableMap.setValue("ft_zeilen", oFTInfo.getFTZeilen());
        }
    }

    private void setBTEMenge(TrfHashMap transferableMap) {
        Collection cSelBtNummern = (Collection)transferableMap.getValue("bildtafeln_list_of_string");
        Collection cSelBtTypen = (Collection)transferableMap.getValue("btearten");
        this.sessionInfo.setBTEMenge(cSelBtNummern, cSelBtTypen);
    }

    private void selectThisBTE(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.selectBTE(0, transferableMap);
        transferableMap.setValue("currentbte", oCurrentBTE);
        boolean bHasNextBT = this.sessionInfo.getBTEManager().hasNextBTE();
        String sHasNextBT = bHasNextBT ? "true" : "false";
        transferableMap.setValue("hasnextbt", sHasNextBT);
        boolean bHasPrevBT = this.sessionInfo.getBTEManager().hasPreviousBTE();
        String sHasPrevBT = bHasPrevBT ? "true" : "false";
        transferableMap.setValue("hasprevbt", sHasPrevBT);
    }

    private void selectNextBTE(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.selectBTE(1, transferableMap);
        transferableMap.setValue("currentbte", oCurrentBTE);
        boolean bHasNextBT = this.sessionInfo.getBTEManager().hasNextBTE();
        String sHasNextBT = bHasNextBT ? "true" : "false";
        transferableMap.setValue("hasnextbt", sHasNextBT);
        boolean bHasPrevBT = this.sessionInfo.getBTEManager().hasPreviousBTE();
        String sHasPrevBT = bHasPrevBT ? "true" : "false";
        transferableMap.setValue("hasprevbt", sHasPrevBT);
    }

    private void selectPrevBTE(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.selectBTE(2, transferableMap);
        transferableMap.setValue("currentbte", oCurrentBTE);
        boolean bHasNextBT = this.sessionInfo.getBTEManager().hasNextBTE();
        String sHasNextBT = bHasNextBT ? "true" : "false";
        transferableMap.setValue("hasnextbt", sHasNextBT);
        boolean bHasPrevBT = this.sessionInfo.getBTEManager().hasPreviousBTE();
        String sHasPrevBT = bHasPrevBT ? "true" : "false";
        transferableMap.setValue("hasprevbt", sHasPrevBT);
    }

    private void setCurrentBTE(TrfHashMap transferableMap) {
        String sBTNummer = (String)transferableMap.getValue("btnummer");
        if (sBTNummer == null) {
            transferableMap.setError(new InvalidDataException("keine BTE als Current \u00fcbergeben"));
            return;
        }
        String sLang = this.sessionInfo.getAktuelleSprache();
        boolean bExpandBNB = !this.sessionInfo.getUserInfo().getDarstellungBNB();
        boolean bNachruestRelevant = this.sessionInfo.getUserInfo().getNachruestungenRelevant();
        long lModellspalte = -1L;
        Boolean bVinIdentif = null;
        if (this.sessionInfo.getFzgSucheInfo() != null) {
            lModellspalte = this.sessionInfo.getFzgSucheInfo().getModellspalte();
            bVinIdentif = this.sessionInfo.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bUSATyp = null;
        if (this.sessionInfo.getFzgIdInfo() != null) {
            String region = this.sessionInfo.getFzgIdInfo().getRegion();
            bUSATyp = region != null && region.equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean bIGDOM = this.sessionInfo.getIGDOMVerwenden();
        if (this.sessionInfo.getSucheInfo() == null) {
            String sMarke = (String)transferableMap.getValue("marke");
            String sProduktart = (String)transferableMap.getValue("produktart");
            String sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
            AssSucheInfo oSucheInfo = this.sessionInfo.newAssSucheInfo();
            oSucheInfo.setMarke(sMarke);
            oSucheInfo.setProduktart(sProduktart);
            oSucheInfo.setKatalogumfang(sKatalogumfang);
            bIGDOM = oSucheInfo.isIGDOM();
        }
        try {
            this.sessionInfo.getBTEManager().setCurrentBTE(sBTNummer, sLang, lModellspalte, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, this.sessionInfo.getSucheInfo(), false, this.sessionInfo.getSucheInfo().isIGDOM());
        }
        catch (IndexOutOfBoundsException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("The internal data is corrupt: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("A Database error occured: " + e.getMessage(), e);
        }
        catch (DatabaseBusyException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("Database is busy!", e);
        }
        catch (InvalidInitializationException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("Illegal objects found in internal collection!", e);
        }
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        oCurrentBTE = this.loadBTEStammdaten(transferableMap);
        this.aktualisierenZeilen(transferableMap);
        transferableMap.setValue("currentbte", oCurrentBTE);
        boolean bHasNextBT = this.sessionInfo.getBTEManager().hasNextBTE();
        String sHasNextBT = bHasNextBT ? "true" : "false";
        transferableMap.setValue("hasnextbt", sHasNextBT);
        boolean bHasPrevBT = this.sessionInfo.getBTEManager().hasPreviousBTE();
        String sHasPrevBT = bHasPrevBT ? "true" : "false";
        transferableMap.setValue("hasprevbt", sHasPrevBT);
    }

    private void loadBTE(TrfHashMap transferableMap) {
        String sSachnummerSuch = this.sessionInfo.getSachnummerSuch();
        this.aktualisierenZeilen(transferableMap);
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        transferableMap.setValue("currentbte", oCurrentBTE);
        transferableMap.setValue("sachnummersuch", sSachnummerSuch);
    }

    private CurrentBTE selectBTE(int nWhat, TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        boolean bExpandBNB = !this.sessionInfo.getUserInfo().getDarstellungBNB();
        boolean bNachruestRelevant = this.sessionInfo.getUserInfo().getNachruestungenRelevant();
        long lModellspalte = -1L;
        Boolean bVinIdentif = null;
        if (this.sessionInfo.getFzgSucheInfo() != null) {
            lModellspalte = this.sessionInfo.getFzgSucheInfo().getModellspalte();
            bVinIdentif = this.sessionInfo.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bUSATyp = null;
        if (this.sessionInfo.getFzgIdInfo() != null) {
            bUSATyp = this.sessionInfo.getFzgIdInfo().getRegion() != null && this.sessionInfo.getFzgIdInfo().getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        try {
            switch (nWhat) {
                case 0: {
                    this.sessionInfo.getBTEManager().thisBTE(sLang, lModellspalte, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, this.sessionInfo.getSucheInfo(), false, this.sessionInfo.getSucheInfo().isIGDOM());
                    break;
                }
                case 1: {
                    this.sessionInfo.getBTEManager().nextBTE(sLang, lModellspalte, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, this.sessionInfo.getSucheInfo(), false, this.sessionInfo.getSucheInfo().isIGDOM());
                    break;
                }
                case 2: {
                    if (this.sessionInfo.getBTEManager().haveBteVerweise()) {
                        this.sessionInfo.getBTEManager().removeVerweisBte(sLang, lModellspalte, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, this.sessionInfo.getSucheInfo(), false, this.sessionInfo.getSucheInfo().isIGDOM());
                        break;
                    }
                    this.sessionInfo.getBTEManager().previousBTE(sLang, lModellspalte, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, this.sessionInfo.getSucheInfo(), false, this.sessionInfo.getSucheInfo().isIGDOM());
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("The internal data is corrupt: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("A Database error occured: " + e.getMessage(), e);
        }
        catch (DatabaseBusyException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("Database is busy!", e);
        }
        catch (InvalidInitializationException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("Illegal objects found in internal collection!", e);
        }
        this.sessionInfo.getBTEManager().getCurrentBTE();
        this.loadBTEStammdaten(transferableMap);
        String sSachnummerSuch = this.sessionInfo.getSachnummerSuch();
        transferableMap.setValue("sachnummersuch", sSachnummerSuch);
        this.aktualisierenZeilen(transferableMap);
        return this.sessionInfo.getBTEManager().getCurrentBTE();
    }

    private void expandBildnummer(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            transferableMap.setError(new IllegalArgumentException("Current Bildtafel is null!"));
            return;
        }
        String sBildnummer = (String)transferableMap.getValue("bildnummer");
        oCurrentBTE.expandZeile(sBildnummer);
        this.aktualisierenZeilen(transferableMap);
    }

    private void collapseBildnummer(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            transferableMap.setError(new IllegalArgumentException("Current Bildtafel is null!"));
            return;
        }
        String sBildnummer = (String)transferableMap.getValue("bildnummer");
        oCurrentBTE.collapseZeile(sBildnummer);
        this.aktualisierenZeilen(transferableMap);
    }

    private void anwendenBedAuswertung(TrfHashMap transferableMap) {
        String sBedAuswertung = (String)transferableMap.getValue("apply_bed_auswertung");
        boolean bBedAuswertung = sBedAuswertung.equals("true");
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            transferableMap.setError(new IllegalArgumentException("Current Bildtafel is null!"));
        } else {
            oCurrentBTE.setFilterZustand(bBedAuswertung);
        }
        this.aktualisierenZeilen(transferableMap);
    }

    private void changeBedingung(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            transferableMap.setError(new IllegalArgumentException("Current Bildtafel is null!"));
            return;
        }
        Long lBedId = (Long)transferableMap.getValue("id");
        Bedingungswert oBedWert = (Bedingungswert)transferableMap.getValue("wert");
        String sAktualisieren = (String)transferableMap.getValue("aktualisieren");
        boolean bAktualisieren = sAktualisieren != null && !sAktualisieren.equals("false");
        try {
            oCurrentBTE.getBedingungen().setBedWert(lBedId, oBedWert);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
        FzgSucheInfo oFzgSucheInfo = this.sessionInfo.getFzgSucheInfo();
        Bedingungsmenge oBedMenge = oFzgSucheInfo.getBedingungsMenge();
        oBedMenge.uebernehmenWerte(oCurrentBTE.getBedingungen(), true, false);
        if (bAktualisieren) {
            this.aktualisierenZeilen(transferableMap);
        } else {
            transferableMap.setValue("currentbte", oCurrentBTE);
        }
        SearchBTETeile oSearchBTETeile = this.sessionInfo.getSearchBTETeile();
        if (oSearchBTETeile != null) {
            Bedingungsmenge oBedMengeBTE = oFzgSucheInfo.getBedingungsMenge_BTE();
            if (oBedMengeBTE != null) {
                oBedMengeBTE.setBedWert(lBedId, oBedWert);
            }
            oSearchBTETeile.aktualisierenBedingungen(false, lBedId, oBedWert);
        }
        transferableMap.setValue("searchbteteile", oSearchBTETeile);
    }

    private void resetBedingungen(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            transferableMap.setError(new IllegalArgumentException("Current Bildtafel is null!"));
            return;
        }
        try {
            oCurrentBTE.getBedingungen().resetWerte();
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
        FzgSucheInfo oFzgSucheInfo = this.sessionInfo.getFzgSucheInfo();
        Bedingungsmenge oBedMenge = oFzgSucheInfo.getBedingungsMenge();
        oBedMenge.uebernehmenWerte(oCurrentBTE.getBedingungen(), true, false);
        transferableMap.setValue("currentbte", oCurrentBTE);
        SearchBTETeile oSearchBTETeile = this.sessionInfo.getSearchBTETeile();
        if (oSearchBTETeile != null) {
            Bedingungsmenge oBedMengeBTE = oFzgSucheInfo.getBedingungsMenge_BTE();
            if (oBedMengeBTE != null) {
                oBedMengeBTE.resetWerte();
            }
            oSearchBTETeile.aktualisierenBedingungen(true, null, null);
        }
        transferableMap.setValue("searchbteteile", oSearchBTETeile);
    }

    private void holeDruckansicht(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            transferableMap.setError(new IllegalArgumentException("Current Bildtafel is null!"));
            return;
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("currentbte", oCurrentBTE);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.BT_GET_DRUCKANSICHT);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        Vector cZeilenId = (Vector)transferableMap.getValue("ids");
        SucheInfo oSucheInfo = this.sessionInfo.getSucheInfo();
        Textteil oDruckansicht = oCurrentBTE.makeSnapshot("Druck", cZeilenId, oSucheInfo);
        transferableMap.setValue("druckansicht", oDruckansicht);
        transferableMap.setValue("bteBedingung", oCurrentBTE.getBedingungen());
    }

    private byte[] ladeGrafik(String sBildId, String sBildFactor, String sBildTimestamp) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String sFormat = ImageCache.requestImageAsByteArray(out, sBildId, sBildFactor);
            if (sFormat == null) {
                this.log.error("Image could not be loaded! Cause unknown.");
                return null;
            }
            byte[] theData = out.toByteArray();
            byte[] data = new byte[theData.length];
            System.arraycopy(theData, 0, data, 0, theData.length);
            return data;
        }
        catch (IOException ex) {
            this.log.error("I/O Error loading image from database!", ex);
            return null;
        }
        catch (DatabaseBusyException ex) {
            this.log.error("Database access failed during image loading!", ex);
            return null;
        }
        catch (SQLException ex) {
            this.log.error("SQL Error during image loading!", ex);
            return null;
        }
    }

    private void aktualisierenZeilen(TrfHashMap transferableMap) {
        String sSachnummerSuch = (String)transferableMap.getValue("sachnummersuch");
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            transferableMap.setError(new IllegalArgumentException("Current Bildtafel is null!"));
            return;
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("currentbte", oCurrentBTE);
                transferableMap.setValue("sucheinfo", this.sessionInfo.getSucheInfo());
                transferableMap.setValue("landkuerzel", sLandkuerzel);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.AKTUALISIEREN_BT_ZEILEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            oCurrentBTE = (CurrentBTE)transferableMap.getValue("currentbte");
            this.sessionInfo.getBTEManager().setCurrentBTE(oCurrentBTE);
            return;
        }
        try {
            Vector<String> cSachnummerSuch = new Vector<String>();
            if (sSachnummerSuch != null && !sSachnummerSuch.trim().equals("")) {
                cSachnummerSuch.add(sSachnummerSuch);
            }
            oCurrentBTE.aktualisierenZeilen(this.sessionInfo.getSucheInfo(), cSachnummerSuch, sLandkuerzel, false);
            oCurrentBTE.checkForSatzteile();
        }
        catch (IllegalArgumentException e) {
            this.log.error("The given SucheInfo-Object is null!", e);
            transferableMap.setError(e);
        }
        catch (InvalidDataException e) {
            this.log.error("Internal data concerning the row representation is corrupt!", e);
            transferableMap.setError(e);
        }
        catch (DatabaseBusyException e) {
            this.log.error("Database is busy!", e);
            transferableMap.setError(e);
        }
        catch (SQLException e) {
            this.log.error("Database error detected: " + e.getMessage(), e);
            transferableMap.setError(e);
        }
        transferableMap.setValue("currentbte", oCurrentBTE);
        transferableMap.setValue("sachnummersuch", sSachnummerSuch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ladeTeileinfo(TrfHashMap transferableMap) {
        block15: {
            String sSachnummer = (String)transferableMap.getValue("sachnummer");
            String sFremdeTNr = (String)transferableMap.getValue("fremdetnr");
            String sCurrentLang = this.sessionInfo.getAktuelleSprache();
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
            Teileinfo objTeileinfo = null;
            if (this.sessionInfo.doZentraleRecherche() && (sSachnummer != null || sFremdeTNr != null)) {
                try {
                    String sLang = this.sessionInfo.getAktuelleSprache();
                    String sMarke = this.sessionInfo.getUserInfo().getMarke();
                    Collection<String> aUserMarken = this.sessionInfo.getUserMarken();
                    Collection<String> aUserProdukte = this.sessionInfo.getUserProdukte();
                    String sUserKatalogumfang = this.sessionInfo.getUserKatUmfang();
                    transferableMap.setValue("sprache", sLang);
                    transferableMap.setValue("marke", sMarke);
                    transferableMap.setValue("marken_berechtigungen", aUserMarken);
                    transferableMap.setValue("produkte_berechtigungen", aUserProdukte);
                    transferableMap.setValue("katalogumfang_berechtigung", sUserKatalogumfang);
                    transferableMap.setValue("landkuerzel", sLandkuerzel);
                    GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEILEINFO);
                    objTeileinfo = (Teileinfo)transferableMap.getValue("teileinfo");
                    if (transferableMap.getError() != null) {
                        return;
                    }
                    if (sSachnummer == null && sFremdeTNr == null) break block15;
                    try {
                        objTeileinfo.loadNutzerSpezifischeDaten(sSachnummer, sNutzerId, sFirma, sFiliale, sCurrentLang, sMarke);
                    }
                    catch (Exception ex) {
                        transferableMap.setError(ex);
                    }
                }
                catch (CommunicationException ex) {
                    transferableMap.setError(ex);
                }
            } else {
                try {
                    objTeileinfo = new Teileinfo(sCurrentLang);
                    if (sSachnummer == null && sFremdeTNr == null) {
                        return;
                    }
                    Collection<String> aMarken = this.sessionInfo.getUserMarken();
                    if (!objTeileinfo.load("", sSachnummer, sFremdeTNr, sNutzerId, sFirma, sFiliale, sCurrentLang, aMarken, this.sessionInfo, sLandkuerzel)) {
                        Logger.getLogger(TrfHashMapCommand.class).debug("Teileinfo nicht gefunden");
                        throw new NoDataFoundException();
                    }
                }
                catch (Exception e) {
                    transferableMap.setError(e);
                }
                finally {
                    transferableMap.setValue("teileinfo", objTeileinfo);
                }
            }
        }
    }

    private void saveTeilenotiz(TrfHashMap transferableMap) {
        Notiz objNotiz = (Notiz)transferableMap.getValue("notiz_objekt");
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            objNotiz.save(sNutzerId, sFirma);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void doDMSAuftrag(TrfHashMap transferableMap) {
        int nLength;
        String sAuftragsnummer = (String)transferableMap.getValue("auftragsnr");
        XmlDmsFzgIdAuftrag xmlReq = new XmlDmsFzgIdAuftrag();
        try {
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
            String sFilialeId = this.sessionInfo.getUserInfo().getFilialeID();
            xmlReq.setInputParameters(sNutzerId, sFirmaId, sFilialeId, sAuftragsnummer);
            xmlReq.requestService();
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        if (!this.checkXmlErgebnisCode(transferableMap, xmlReq)) {
            return;
        }
        String sKundennummer = "";
        if (xmlReq.getKundennummer() >= 0) {
            sKundennummer = Integer.toString(xmlReq.getKundennummer());
        }
        transferableMap.setValue("kundennr", sKundennummer);
        String sKundenname = xmlReq.getKundenname();
        if (sKundenname == null) {
            sKundenname = "";
        }
        if ((nLength = sKundenname.length()) > 20) {
            sKundenname = sKundenname.substring(0, 20);
        }
        transferableMap.setValue("kundenname", sKundenname);
        String sFahrgestellnummer = xmlReq.getFahrgestellnummer();
        sFahrgestellnummer = sFahrgestellnummer == null ? "" : sFahrgestellnummer.trim();
        nLength = sFahrgestellnummer.length();
        if (nLength > 7) {
            sFahrgestellnummer = sFahrgestellnummer.substring(nLength - 7);
        }
        transferableMap.setValue("fgstnr", sFahrgestellnummer);
    }

    private void doDMSAuftragKfzKennzeichen(TrfHashMap transferableMap) {
        String sKfzKennzeichen = (String)transferableMap.getValue("kfz-kennezeichen");
        XmlDmsFzgIdKfzKennzeichen xmlReq = new XmlDmsFzgIdKfzKennzeichen();
        try {
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
            String sFilialeId = this.sessionInfo.getUserInfo().getFilialeID();
            String sMarke = null;
            xmlReq.setInputParameters(sNutzerId, sFirmaId, sFilialeId, sKfzKennzeichen, sMarke);
            xmlReq.requestService();
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        if (!this.checkXmlErgebnisCode(transferableMap, xmlReq)) {
            return;
        }
        String sAuftragsnummer = xmlReq.getAuftragsnummer();
        transferableMap.setValue("auftragsnr", sAuftragsnummer);
        String sKundennummer = "";
        if (xmlReq.getKundennummer() >= 0) {
            sKundennummer = Integer.toString(xmlReq.getKundennummer());
        }
        transferableMap.setValue("kundennr", sKundennummer);
        String sKundenname = xmlReq.getKundenname();
        int nLength = sKundenname.length();
        if (nLength > 20) {
            sKundenname = sKundenname.substring(0, 20);
        }
        transferableMap.setValue("kundenname", sKundenname);
        String sFahrgestellnummer = xmlReq.getFahrgestellnummer();
        sFahrgestellnummer = sFahrgestellnummer == null ? "" : sFahrgestellnummer.trim();
        nLength = sFahrgestellnummer.length();
        if (nLength > 7) {
            sFahrgestellnummer = sFahrgestellnummer.substring(nLength - 7);
        }
        transferableMap.setValue("fgstnr", sFahrgestellnummer);
    }

    private void ladeKommerzielleInfo(TrfHashMap transferableMap) {
        try {
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            webetk.app.teileliste.Teil oTeil = (webetk.app.teileliste.Teil)transferableMap.getValue("teil");
            oTeil.loadPreisInfo(sFirma);
            try {
                String sMwStCode;
                Konfiguration oKonfiguration = null;
                oKonfiguration = new Konfiguration(sFirma, sFiliale);
                oKonfiguration.loadKonfiguration();
                String sAtSt = oKonfiguration.getMWStSatzAltteile();
                double dAtSt = 0.0;
                if (sAtSt != null) {
                    try {
                        dAtSt = Double.parseDouble(sAtSt);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (oTeil.getMwStDouble() == null && (sMwStCode = oTeil.getMwstCode()) != null) {
                    String sMwSt = null;
                    sMwSt = sMwStCode.equals("2") ? oKonfiguration.getMWStSatzHoch() : (sMwStCode.equals("3") ? oKonfiguration.getMWStSatzAltteile() : (sMwStCode.equals("4") ? oKonfiguration.getMWStSatz3() : (sMwStCode.equals("5") ? oKonfiguration.getMWStSatz4() : oKonfiguration.getMWStSatzNiedrig())));
                    double dMwSt = 0.0;
                    if (sMwSt != null) {
                        try {
                            dMwSt = Double.parseDouble(sMwSt);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    oTeil.setMwSt(new Double(dMwSt));
                }
                if (oTeil.getAtStDouble() == null) {
                    oTeil.setAtSt(new Double(dAtSt));
                }
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
            oTeil.setMenge("1");
            if (this.sessionInfo.getDMSVerwenden()) {
                Double dAtst;
                Double dMwst;
                Vector<String> aMarkenTeil = oTeil.getMarken();
                Collection<String> aMarkenUser = this.sessionInfo.getUserMarken();
                String sMarkeEinstellungen = this.sessionInfo.getUserInfo().getMarke();
                String sMarke = GlobalObjects.getInstance().getMarkeTeilRepraesentant(aMarkenTeil, aMarkenUser, sMarkeEinstellungen);
                String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
                XmlDmsTeileinfo xmlReq = new XmlDmsTeileinfo();
                xmlReq.setInputParameters(sNutzerId, sFirma, sFiliale, oTeil.getTeilenummer(), sDMSMarke);
                xmlReq.requestService();
                if (!this.checkXmlErgebnisCode(transferableMap, xmlReq)) {
                    return;
                }
                oTeil.setBenennung(xmlReq.getTeilebezeichnung());
                double dPreis = xmlReq.getHaendlerpreis();
                oTeil.setHaendlerpreis(dPreis);
                if (dPreis != 0.0) {
                    oTeil.setPreis(dPreis);
                }
                oTeil.setLagerbestand(xmlReq.getLagerbestand());
                oTeil.setMinimalbestand(xmlReq.getMindestbestand());
                oTeil.setLagerort(xmlReq.getLagerort());
                String sKodierungsstufe = xmlReq.getKodierungsstufe();
                if (sKodierungsstufe != null && sKodierungsstufe.trim().length() > 0) {
                    oTeil.setRabattSchluessel(sKodierungsstufe);
                }
                if ((dMwst = xmlReq.getMehrwertsteuer()) != null) {
                    oTeil.setMwSt(dMwst);
                }
                if ((dAtst = xmlReq.getSondersteuer()) != null) {
                    oTeil.setAtSt(dAtst);
                }
            }
            transferableMap.setValue("teil", oTeil);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    private void loadVerweisBTE(TrfHashMap transferableMap) {
        String sVerweisBtNummer = (String)transferableMap.getValue("btnummer");
        String sBtNummer = this.sessionInfo.getBTEManager().getCurrentBTE().getBTENr();
        String sLang = this.sessionInfo.getAktuelleSprache();
        boolean bExpandBNB = !this.sessionInfo.getUserInfo().getDarstellungBNB();
        boolean bNachruestRelevant = this.sessionInfo.getUserInfo().getNachruestungenRelevant();
        long lModellspalte = -1L;
        Boolean bVinIdentif = null;
        if (this.sessionInfo.getFzgSucheInfo() != null) {
            lModellspalte = this.sessionInfo.getFzgSucheInfo().getModellspalte();
            bVinIdentif = this.sessionInfo.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bUSATyp = null;
        if (this.sessionInfo.getFzgIdInfo() != null) {
            bUSATyp = this.sessionInfo.getFzgIdInfo().getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        try {
            this.sessionInfo.getBTEManager().addVerweisBte(sBtNummer, sVerweisBtNummer, sLang, lModellspalte, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, this.sessionInfo.getSucheInfo(), false, this.sessionInfo.getIGDOMVerwenden());
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("The given SucheInfo-Object is null!", e);
        }
        catch (InvalidInitializationException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("Invalid Initialization", e);
        }
        catch (DatabaseBusyException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("Database is busy!", e);
        }
        catch (SQLException e) {
            Logger.getLogger(TrfHashMapCommand.class).error("Database error detected: " + e.getMessage(), e);
        }
        CurrentBTE oCurrentBTE = this.loadBTEStammdaten(transferableMap);
        this.aktualisierenZeilen(transferableMap);
        oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        transferableMap.setValue("currentbte", oCurrentBTE);
    }

    private void showBTFromTVTeil(TrfHashMap transferableMap) {
        boolean bDisplayDate;
        String sLang = this.sessionInfo.getAktuelleSprache();
        Boolean bDisplayDateAlways = this.sessionInfo.getUserInfo().getAlwaysDisplayProduktDate();
        boolean bHasRechtDisplayDate = this.sessionInfo.hasRechtAnzeigeProddatum();
        boolean bl = bDisplayDate = bHasRechtDisplayDate;
        if (bDisplayDate && (bDisplayDateAlways == null || !bDisplayDateAlways.booleanValue())) {
            bDisplayDate = false;
        }
        String sBtNummer = (String)transferableMap.getValue("btnummer");
        FzgSucheInfo oFzgSucheInfo = this.sessionInfo.newFzgSucheInfo();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("fzgsucheinfo_app", oFzgSucheInfo);
                transferableMap.setValue("sprache", sLang);
                String sDisplayDate = bDisplayDate ? "true" : "false";
                transferableMap.setValue("ProdDatum", sDisplayDate);
                transferableMap.setValue("regionendefault", this.sessionInfo.getUserInfo().getRegionen());
                transferableMap.setValue("lenkung", this.sessionInfo.getUserInfo().getLenkung());
                transferableMap.setValue("iso", this.sessionInfo.getUserInfo().getSprache());
                transferableMap.setValue("regiso", this.sessionInfo.getUserInfo().getSpracheRegion());
                transferableMap.setValue("marken_berechtigungen", this.sessionInfo.getUserMarken());
                transferableMap.setValue("produkte_berechtigungen", this.sessionInfo.getUserProdukte());
                transferableMap.setValue("katalogumfang_berechtigung", this.sessionInfo.getUserKatUmfang());
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.BT_SHOW_TV_TEIL);
            }
            catch (CommunicationException ex) {
                this.transferable.setError(ex);
                return;
            }
            JavaFzgIdInfo oJavaFzgIdInfo = (JavaFzgIdInfo)transferableMap.getValue("fzgidinfo_java");
            FzgIdInfo oFzgIdInfo = oJavaFzgIdInfo.constructFzgIdInfo();
            this.sessionInfo.setFzgIdInfo(oFzgIdInfo);
            oFzgSucheInfo = (FzgSucheInfo)transferableMap.getValue("fzgsucheinfo_app");
            this.sessionInfo.setSucheInfo(oFzgSucheInfo);
            JavaFzgSucheInfo oJavaFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfo);
            transferableMap.setValue("fzgsucheinfo_java", oJavaFzgSucheInfo);
        } else {
            String sMarke = (String)transferableMap.getValue("marke");
            String sProduktart = (String)transferableMap.getValue("produktart");
            String sBauart = (String)transferableMap.getValue("bauart");
            String sBaureihe = (String)transferableMap.getValue("baureihe");
            String sKarosserie = (String)transferableMap.getValue("karosserie");
            String sModell = (String)transferableMap.getValue("modell");
            String sRegion = (String)transferableMap.getValue("region");
            String sKatalogumfang = (String)transferableMap.getValue("katalogumfang");
            FzgIdInfo oFzgIdInfo = this.sessionInfo.newFzgIdInfo();
            try {
                oFzgIdInfo.setMajorAttributes(sMarke, sProduktart, sKatalogumfang);
                if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                    oFzgIdInfo.setBauart(sBauart, false);
                }
                oFzgIdInfo.setBaureihe(sBaureihe, false);
                if (sProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                    oFzgIdInfo.setKarosserie(sKarosserie, false);
                }
                oFzgIdInfo.setModell(sModell, false);
                oFzgIdInfo.setRegion(sRegion, false);
                oFzgIdInfo.finalize(oFzgSucheInfo, bDisplayDate, null, null);
            }
            catch (Exception e) {
                Logger.getLogger(TrfHashMapCommand.class).error("FzgIdInfo konnte nicht erzeugt werden: " + e.getMessage());
                oFzgIdInfo = null;
                oFzgSucheInfo = null;
                transferableMap.setError(e);
                return;
            }
            JavaFzgIdInfo oJavaFzgIdInfo = new JavaFzgIdInfo(oFzgIdInfo, false);
            transferableMap.setValue("fzgidinfo_java", oJavaFzgIdInfo);
            JavaFzgSucheInfo oJavaFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfo);
            transferableMap.setValue("fzgsucheinfo_java", oJavaFzgSucheInfo);
        }
        if (this.sessionInfo.getFzgIdInfo() == null || this.sessionInfo.getFzgSucheInfo() == null) {
            return;
        }
        Vector<String> cSelBtNummer = new Vector<String>();
        cSelBtNummer.add(sBtNummer);
        Vector<String> cSelBtType = new Vector<String>();
        cSelBtType.add("FZG");
        this.sessionInfo.setBTEMenge(cSelBtNummer, cSelBtType);
        this.selectBTE(1, transferableMap);
    }

    private void loadTeilelisteZuAuftrag(TrfHashMap transferableMap) {
        String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
        String sFilialeId = this.sessionInfo.getUserInfo().getFilialeID();
        String sAuftragsnummer = (String)transferableMap.getValue("auftragsnr");
        TeilelisteTO oErgebnis = null;
        try {
            Teileliste oTeilelisteObject = new Teileliste();
            oErgebnis = oTeilelisteObject.getTeilelisteZuAuftrag(sFirmaId, sFilialeId, sAuftragsnummer);
            if (oErgebnis == null) {
                transferableMap.setError(new NoDataFoundException("es besteht noch keine Teileliste f\u00fcr Auftrag " + sAuftragsnummer));
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            Logger.getLogger(TrfHashMapCommand.class).error("Teilliste konnte nicht  konnte nicht erzeugt werden: " + e.getMessage());
        }
        transferableMap.setValue("teileliste_TO", oErgebnis);
    }

    private void doDMSFilialbestand(TrfHashMap transferableMap) {
        XmlDmsFilialabfrage xmlReq = new XmlDmsFilialabfrage();
        try {
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            xmlReq.setInputParameters(sNutzerId, sFirma, sFiliale);
            String sTeilenummer = (String)transferableMap.getValue("teilenummer");
            String sMarke = (String)transferableMap.getValue("marke");
            String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
            xmlReq.addPosition(new XmlDmsTeilelistenPosition(sTeilenummer, sDMSMarke));
            xmlReq.requestService();
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        if (!this.checkXmlErgebnisCode(transferableMap, xmlReq)) {
            return;
        }
        if (xmlReq.getErgebnisCount() > 0) {
            Vector<String> aFilialen = new Vector<String>();
            Vector<String> aBestanede = new Vector<String>();
            for (int ii = 0; ii < xmlReq.getFilialbestandlCount(0); ++ii) {
                aFilialen.add(xmlReq.getFiliale(0, ii));
                aBestanede.add(Double.toString(xmlReq.getBestand(0, ii)));
            }
            transferableMap.setValue("filialenDMS", aFilialen);
            transferableMap.setValue("bestaendeDMS", aBestanede);
        }
    }

    private void doKonfigurationDmsAbgleich(TrfHashMap transferableMap) {
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        String sPasswort = (String)transferableMap.getValue("pwd");
        Konfiguration config = (Konfiguration)transferableMap.getValue("Haendler_Konfiguration");
        XmlDmsInit xmlReq = new XmlDmsInit();
        try {
            xmlReq.setInputParameters(sNutzerId, sFirma, sFiliale, sPasswort);
            xmlReq.requestService();
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        if (!this.checkXmlErgebnisCode(transferableMap, xmlReq)) {
            return;
        }
        config.setFirma(xmlReq.getFirma());
        config.setHaendleranschriftZeile1(xmlReq.getFirma());
        config.setHaendleranschriftZeile3(xmlReq.getStrasse());
        config.setHaendleranschriftPLZ(xmlReq.getPostleitzahl());
        config.setHaendleranschriftOrt(xmlReq.getOrt());
        config.setHaendleranschriftTelefon(xmlReq.getTelefon());
        config.setHaendlernummerPKW(xmlReq.getNummerPKW());
        config.setHaendlernummerMotorrad(xmlReq.getNummerKrad());
        block8: for (int nInd = 0; nInd < xmlReq.getMwstCount(); ++nInd) {
            XmlDmsMwst oMwSt = xmlReq.getMwst(nInd);
            int nId = oMwSt.getId();
            switch (nId) {
                case 1: {
                    config.setMWStSatzHoch(Double.toString(oMwSt.getProzentsatz()));
                    continue block8;
                }
                case 2: {
                    config.setMWStSatzNiedrig(Double.toString(oMwSt.getProzentsatz()));
                    continue block8;
                }
                case 3: {
                    config.setMWStSatz3(Double.toString(oMwSt.getProzentsatz()));
                    continue block8;
                }
                case 4: {
                    config.setMWStSatz4(Double.toString(oMwSt.getProzentsatz()));
                }
            }
        }
        if (xmlReq.getAtSteuer() != null) {
            config.setMWStSatzAltteile(Double.toString(xmlReq.getAtSteuer()));
        } else {
            config.setMWStSatzAltteile("");
        }
        config.setStandardBarVerkaufsNummer(Integer.toString(xmlReq.getBarverkaufsNummer()));
        if (xmlReq.getIndikatorSatzAusfuehrung()) {
            config.setAbwicklung("S");
        } else {
            config.setAbwicklung("A");
        }
        transferableMap.setValue("Haendler_Konfiguration", config);
    }

    private void holeBTInfo(TrfHashMap transferableMap) {
        String sBteNummer = (String)transferableMap.getValue("btnummer");
        String sProduktart = (String)transferableMap.getValue("produktart");
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sLang);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_BT_INFO);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        Info oBtInfo = null;
        try {
            oBtInfo = new Info(sBteNummer, sProduktart, sLang);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
        if (oBtInfo != null) {
            transferableMap.setValue("ueberschrift", oBtInfo.getTitel());
            transferableMap.setValue("bte_info", oBtInfo);
        }
    }

    private void ladeFirma(TrfHashMap transferableMap) {
        Firmen oFirmen;
        try {
            oFirmen = new Firmen();
            oFirmen.loadFirmen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Firma> cFirmen = oFirmen.getFirmen();
        for (Firma firma : cFirmen) {
            if (!this.sessionInfo.getUserInfo().getFirmaID().equals(firma.getId())) continue;
            transferableMap.setValue("benennung_string", firma.getBezeichnung());
        }
    }

    private void existiertFirmenBenennung(TrfHashMap transferableMap) {
        Firmen oFirmen;
        try {
            oFirmen = new Firmen();
            oFirmen.loadFirmen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        String sFirma = (String)transferableMap.getValue("benennung_string");
        Vector<Firma> cFirmen = oFirmen.getFirmen();
        for (Firma firma : cFirmen) {
            if (!sFirma.equals(firma.getBezeichnung())) continue;
            transferableMap.setValue("boolean", Boolean.TRUE);
            return;
        }
        transferableMap.setValue("boolean", Boolean.FALSE);
    }

    private void existiertFirmaId(TrfHashMap transferableMap) {
        Firmen oFirmen;
        try {
            oFirmen = new Firmen();
            oFirmen.loadFirmen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        String sFirma = (String)transferableMap.getValue("id");
        for (Firma firma : oFirmen.getFirmen()) {
            if (!sFirma.equals(firma.getId())) continue;
            transferableMap.setValue("boolean", Boolean.TRUE);
            return;
        }
        transferableMap.setValue("boolean", Boolean.FALSE);
    }

    private void updateFirmenBenennung(TrfHashMap transferableMap) {
        Logger.getLogger(Firma.class).info("Updating Firmenbezeichnung");
        String sBezeichnung = (String)transferableMap.getValue("benennung_string");
        String sId = (String)transferableMap.getValue("firmaid");
        try {
            Firma.updateBezeichnung(sId, sBezeichnung);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void existiertFilialId(TrfHashMap transferableMap) {
        Filialen oFilialen;
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sFilialId = (String)transferableMap.getValue("filialid");
        try {
            oFilialen = new Filialen(sFirmaId);
            oFilialen.loadFilialen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Filiale> cFilialen = oFilialen.getFilialen();
        for (Filiale filiale : cFilialen) {
            if (!sFilialId.equals(filiale.getId())) continue;
            transferableMap.setValue("boolean", Boolean.TRUE);
            return;
        }
        transferableMap.setValue("boolean", Boolean.FALSE);
    }

    private void existiertFiliale(TrfHashMap transferableMap) {
        Filialen oFilialen;
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sFiliale = (String)transferableMap.getValue("filiale");
        try {
            oFilialen = new Filialen(sFirmaId);
            oFilialen.loadFilialen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Filiale> cFilialen = oFilialen.getFilialen();
        for (Filiale oFiliale : cFilialen) {
            if (!sFiliale.equals(oFiliale.getBezeichnung())) continue;
            transferableMap.setValue("boolean", Boolean.TRUE);
            return;
        }
        transferableMap.setValue("boolean", Boolean.FALSE);
    }

    private void deleteFiliale(TrfHashMap transferableMap) {
        Filiale filiale = (Filiale)transferableMap.getValue("filiale");
        try {
            filiale.delete();
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void updateFiliale(TrfHashMap transferableMap) {
        Filiale oFiliale = (Filiale)transferableMap.getValue("filiale");
        try {
            oFiliale.update();
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeFilialenUndSprachen(TrfHashMap transferableMap) {
        Filialen oFilialen;
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        try {
            oFilialen = new Filialen(sFirmaId);
            oFilialen.loadFilialenSprachen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Filiale> cFilialen = oFilialen.getFilialen();
        transferableMap.setValue("filialen", cFilialen);
        int nCount = cFilialen.size();
        String sCount = Integer.toString(nCount);
        transferableMap.setValue("count", sCount);
        if (cFilialen.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Filialen gefunden!"));
        }
    }

    private void ladeNutzer(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        List aUserIdsToIgnore = (List)transferableMap.getValue("userids_to_ignore");
        webetk.app.konfiguration.Nutzer oNutzer = null;
        try {
            oNutzer = new webetk.app.konfiguration.Nutzer(sFirmaId);
            oNutzer.loadNutzer(aUserIdsToIgnore);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<webetk.app.konfiguration.Nutzer> cNutzer = oNutzer.getNutzer();
        transferableMap.setValue("nutzer_list", cNutzer);
        if (cNutzer.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Nutzer gefunden!"));
        }
    }

    private void ladeAnzahlNutzer(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sKriterium = (String)transferableMap.getValue("suchbegriff");
        List aUserIdsToIgnore = (List)transferableMap.getValue("userids_to_ignore");
        if (sKriterium == null) {
            sKriterium = "%";
        }
        int anzahl = 0;
        try {
            anzahl = KonfigurationDbAccess.loadAnzahlNutzer(sFirmaId, sKriterium, aUserIdsToIgnore);
        }
        catch (SQLException e) {
            transferableMap.setError(e);
            return;
        }
        catch (DatabaseBusyException e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("anzahlNutzer", new Integer(anzahl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void ladeNutzerAnhandId(TrfHashMap transferableMap) {
        block21: {
            globs = ServerGlobalObjects.getInstance();
            logger = Logger.getLogger(InfoToolDbAccess.class);
            logger.debug("Now Accessing Database");
            con = null;
            sFirmaId = (String)transferableMap.getValue("firmaid");
            sUserId = (String)transferableMap.getValue("user_id");
            sUserName = null;
            sPasswort = null;
            sDefaultFiliale = null;
            sBearbeiterNr = null;
            result = null;
            con = globs.getDBConnectionNutzer("konfiguration.AdminToolDbAccess.ladeNutzerAnhandId");
            result = KonfigurationDbAccess.loadNutzer(con, sFirmaId, sUserId);
            if (result.next()) break block21;
            try {
                WebetkUtils.closeQuery(result);
                if (con != null) {
                    globs.freeDBConnectionNutzer(con, "ladeNutzerAnhandId");
                }
            }
            catch (SQLException e) {
                transferableMap.setError(e);
                return;
            }
            return;
        }
        sUserName = result.getString("NutzerName");
        sPasswort = result.getString("Passwort");
        sDefaultFiliale = result.getString("DefaultFiliale");
        sBearbeiterNr = result.getString("BearbeiterNummer");
        try {
            WebetkUtils.closeQuery(result);
            if (con == null) ** GOTO lbl73
            globs.freeDBConnectionNutzer(con, "ladeNutzerAnhandId");
        }
        catch (SQLException e) {
            transferableMap.setError(e);
            return;
        }
        catch (SQLException e) {
            transferableMap.setError(e);
            try {
                WebetkUtils.closeQuery(result);
                if (con != null) {
                    globs.freeDBConnectionNutzer(con, "ladeNutzerAnhandId");
                }
            }
            catch (SQLException e) {
                transferableMap.setError(e);
                return;
            }
            return;
        }
        catch (DatabaseBusyException e) {
            transferableMap.setError(e);
            {
                catch (Throwable var14_18) {
                    try {
                        WebetkUtils.closeQuery(result);
                        if (con != null) {
                            globs.freeDBConnectionNutzer(con, "ladeNutzerAnhandId");
                        }
                    }
                    catch (SQLException e) {
                        transferableMap.setError(e);
                        return;
                    }
                    throw var14_18;
                }
            }
            try {
                WebetkUtils.closeQuery(result);
                if (con != null) {
                    globs.freeDBConnectionNutzer(con, "ladeNutzerAnhandId");
                }
            }
            catch (SQLException e) {
                transferableMap.setError(e);
                return;
            }
            return;
        }
lbl73:
        // 2 sources

        transferableMap.setValue("username", sUserName);
        transferableMap.setValue("pwd", sPasswort);
        transferableMap.setValue("filiale", sDefaultFiliale);
        transferableMap.setValue("bearbeiter_nummer", sBearbeiterNr);
    }

    private void loadMatchingNutzer(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sKriterium = (String)transferableMap.getValue("suchbegriff");
        List aUserIdsToIgnore = (List)transferableMap.getValue("userids_to_ignore");
        if (sKriterium == null) {
            sKriterium = "%";
        }
        List<String[]> treffer = null;
        ArrayList<Nutzer> nutzerListe = new ArrayList<Nutzer>();
        try {
            treffer = KonfigurationDbAccess.loadMatchingNutzer(sFirmaId, sKriterium, aUserIdsToIgnore);
            for (String[] result : treffer) {
                nutzerListe.add(new Nutzer(result[0], result[1]));
            }
        }
        catch (SQLException e) {
            transferableMap.setError(e);
            return;
        }
        catch (DatabaseBusyException e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("matchingNutzerLISTE", nutzerListe);
    }

    private void ladeNutzerZuFilialId(TrfHashMap transferableMap) {
        webetk.app.konfiguration.Nutzer oNutzer;
        String sFilialId = (String)transferableMap.getValue("filialid");
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        try {
            oNutzer = new webetk.app.konfiguration.Nutzer(null);
            oNutzer.loadNutzerByFilialId(sFilialId, sFirmaId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("nutzer_list", oNutzer.getNutzer());
    }

    private void ladeBerechtigungen(TrfHashMap transferableMap) {
        Berechtigungen oBerechtigungen;
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        try {
            oBerechtigungen = new Berechtigungen(sFirmaId);
            oBerechtigungen.loadBerechtigungen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("berechtigungen", oBerechtigungen);
    }

    private void ladeSprachen(TrfHashMap transferableMap) {
        String sIso = (String)transferableMap.getValue("iso");
        String sRegIso = (String)transferableMap.getValue("regiso");
        Sprachen oSprachen = null;
        try {
            oSprachen = new Sprachen(sIso, sRegIso);
            oSprachen.loadSprachen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<webetk.app.konfiguration.Sprache> cSprachen = oSprachen.getSprachen();
        transferableMap.setValue("sprachen_list", cSprachen);
        if (cSprachen.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Sprachen gefunden!"));
        }
    }

    private void ladeFunktionsrechte(TrfHashMap transferableMap) {
        String sIso = (String)transferableMap.getValue("iso");
        String sRegIso = (String)transferableMap.getValue("regiso");
        Funktionsrechte oFunktionsrechte = null;
        try {
            oFunktionsrechte = new Funktionsrechte(sIso, sRegIso);
            oFunktionsrechte.loadFunktionsrechte();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Funktionsrecht> cFunktionsrechte = oFunktionsrechte.getFunktionsrechte();
        transferableMap.setValue("funktionsrecht_list", cFunktionsrechte);
        if (cFunktionsrechte.isEmpty()) {
            transferableMap.setError(new NoDataFoundException("keine Funktionsrechte gefunden!"));
        }
        int nCount = cFunktionsrechte.size();
        String sCount = Integer.toString(nCount);
        transferableMap.setValue("count", sCount);
    }

    private void ladeNutzerFunktionsrechte(TrfHashMap transferableMap) {
        String sIso = (String)transferableMap.getValue("iso");
        String sRegIso = (String)transferableMap.getValue("regiso");
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        Funktionsrechte oFunktionsrechte = null;
        try {
            oFunktionsrechte = new Funktionsrechte(sFirmaId, sUserId, null, sIso, sRegIso);
            oFunktionsrechte.loadNutzerFunktionsrechte();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Vector<Funktionsrecht> cFunktionsrechte = oFunktionsrechte.getFunktionsrechte();
        transferableMap.setValue("funktionsrecht_list", cFunktionsrechte);
        int nCount = cFunktionsrechte.size();
        String sCount = Integer.toString(nCount);
        transferableMap.setValue("count", sCount);
    }

    private void ladeNutzerBerechtigungen(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        Berechtigungen oBerechtigungen = null;
        try {
            oBerechtigungen = new Berechtigungen(sFirmaId, sUserId);
            oBerechtigungen.loadNutzerBerechtigungen();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("berechtigungen", oBerechtigungen);
    }

    private void deleteNutzer(TrfHashMap transferableMap) {
        String sUserId = (String)transferableMap.getValue("user_id");
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        try {
            webetk.app.konfiguration.Nutzer.delete(sUserId, sFirmaId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void existiertNutzerId(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sNutzerId = (String)transferableMap.getValue("user_id");
        webetk.app.konfiguration.Nutzer oNutzer = null;
        Boolean b = Boolean.FALSE;
        try {
            oNutzer = new webetk.app.konfiguration.Nutzer(sFirmaId, sNutzerId, null);
            b = oNutzer.existNutzerId() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("boolean", b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void speichereNutzer(TrfHashMap transferableMap) {
        String sIso = (String)transferableMap.getValue("iso");
        String sRegIso = (String)transferableMap.getValue("regiso");
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sNutzerName = (String)transferableMap.getValue("username");
        String sNutzerId = (String)transferableMap.getValue("user_id");
        String sPasswort = (String)transferableMap.getValue("pwd");
        String sFilialId = (String)transferableMap.getValue("filialid");
        String sBearbeiterNummer = (String)transferableMap.getValue("bearbeiter_nummer");
        webetk.app.konfiguration.Nutzer oNutzer = new webetk.app.konfiguration.Nutzer(sFirmaId, sNutzerId, sNutzerName, sPasswort, sFilialId, sBearbeiterNummer);
        Berechtigungen oBerechtigungen = (Berechtigungen)transferableMap.getValue("berechtigungen");
        Vector mcFunktionsrechte = (Vector)transferableMap.getValue("funktionsrechte_list");
        Funktionsrechte oFunktionsrechte = new Funktionsrechte(sFirmaId, sNutzerId, mcFunktionsrechte, sIso, sRegIso);
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnectionNutzer("Nutzer.store");
            con.setAutoCommit(false);
            oNutzer.store(con);
            oFunktionsrechte.store(con);
            oBerechtigungen.store(con);
            con.commit();
        }
        catch (SQLException ex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (SQLException ex2) {
                transferableMap.setError(ex2);
            }
            transferableMap.setError(ex);
        }
        catch (DatabaseBusyException ex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (SQLException ex2) {
                transferableMap.setError(ex2);
            }
            transferableMap.setError(ex);
        }
        finally {
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
                ServerGlobalObjects.getInstance().freeDBConnectionNutzer(con, "Nutzer.store");
            }
            catch (SQLException e) {
                transferableMap.setError(e);
            }
        }
    }

    private void ladeDefaultFilialePasswort(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sNutzerId = (String)transferableMap.getValue("user_id");
        webetk.app.konfiguration.Nutzer oNutzer = null;
        try {
            oNutzer = new webetk.app.konfiguration.Nutzer(sFirmaId, sNutzerId, null);
            int iRet = oNutzer.loadDefaultFilialePasswort();
            if (iRet == 0) {
                transferableMap.setError(new DMSException("can not get DefaultFilialePasswort"));
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("pwd", oNutzer.getPassword());
        transferableMap.setValue("filialid", oNutzer.getDefaultFiliale());
        transferableMap.setValue("filiale", oNutzer.getDefaultFilialeBezeichnung());
        transferableMap.setValue("iso", oNutzer.getIso());
        transferableMap.setValue("regiso", oNutzer.getRegIso());
        transferableMap.setValue("user_id", oNutzer.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTeilelisten(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sNutzerId = (String)transferableMap.getValue("user_id");
        String sFilialIdNeu = (String)transferableMap.getValue("filialid");
        String sFilialIdAlt = (String)transferableMap.getValue("filialid_alt");
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Logger.getLogger(TrfHashMap.class).info("Move Teilelisten");
        Connection con = null;
        try {
            con = gObj.getDBConnection("TrfHashMap.moveTeilelisten");
            KonfigurationDbAccess.moveTeilelisten(con, sFirmaId, sNutzerId, sFilialIdNeu, sFilialIdAlt);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.moveTeilelisten");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    private void existiertEineFirmaFilialeNutzer(TrfHashMap transferableMap) {
        List aUserIdsToIgnore = (List)transferableMap.getValue("userids_to_ignore");
        try {
            Firmen oFirmen = new Firmen();
            transferableMap.setValue("boolean", oFirmen.existiertEineFirmaFilialeNutzer(aUserIdsToIgnore) ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void erzeugeNeueFiliale(TrfHashMap transferableMap) {
        Filiale oFiliale = (Filiale)transferableMap.getValue("filiale");
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("Filiale.create");
            con.setAutoCommit(false);
            oFiliale.writeToDB(con);
            TeileListeDbAccess.storeBestellliste(con, "EILAUFTRAGSLISTE", oFiliale.getId(), oFiliale.getIdFirma());
            TeileListeDbAccess.storeBestellliste(con, "NORMALAUFTRAGSLISTE", oFiliale.getId(), oFiliale.getIdFirma());
            con.commit();
        }
        catch (Exception ex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (SQLException e) {
                transferableMap.setError(e);
            }
            transferableMap.setError(ex);
        }
        finally {
            try {
                ServerGlobalObjects.getInstance().freeDBConnection(con, "Filiale.create");
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                transferableMap.setError(e);
            }
        }
        try {
            Konfiguration oKonfiguration = new Konfiguration(oFiliale.getIdFirma(), oFiliale.getId());
            oKonfiguration.setDMSSchnittstelleVerwenden("N");
            oKonfiguration.saveKonfiguration();
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void existierenListeneintraege(TrfHashMap transferableMap) {
        Boolean b = null;
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sFilialId = (String)transferableMap.getValue("filialid");
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("TrfHashMapCommand.existLists");
            b = KonfigurationDbAccess.existLists(con, sFilialId, sFirmaId) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
        finally {
            try {
                ServerGlobalObjects.getInstance().freeDBConnection(con, "TrfHashMapCommand.existLists");
            }
            catch (SQLException e) {
                transferableMap.setError(e);
            }
        }
        transferableMap.setValue("boolean", b);
    }

    private CurrentBTE loadBTEStammdaten(TrfHashMap transferableMap) {
        CurrentBTE oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        if (oCurrentBTE == null) {
            return null;
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("currentbte", oCurrentBTE);
                if (oCurrentBTE.getBTEType().equals("FZG")) {
                    transferableMap.setValue("fzgsucheinfo_app", this.sessionInfo.getFzgSucheInfo());
                }
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_BTE_STAMMDATEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return null;
            }
            oCurrentBTE = (CurrentBTE)transferableMap.getValue("currentbte");
            this.sessionInfo.getBTEManager().setCurrentBTE(oCurrentBTE);
            if (oCurrentBTE.getBTEType().equals("FZG")) {
                FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)transferableMap.getValue("fzgsucheinfo_app");
                this.sessionInfo.setSucheInfo(oFzgSucheInfo);
            }
        } else {
            try {
                Bedingungsmenge oBeds = null;
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    oBeds = this.sessionInfo.getFzgSucheInfo().getBedingungsMenge();
                }
                oCurrentBTE.load(oBeds);
            }
            catch (IndexOutOfBoundsException e) {
                Logger.getLogger(TrfHashMapCommand.class).error("The internal data is corrupt: " + e.getMessage(), e);
            }
            catch (SQLException e) {
                Logger.getLogger(TrfHashMapCommand.class).error("A Database error occured: " + e.getMessage(), e);
            }
            catch (DatabaseBusyException e) {
                Logger.getLogger(TrfHashMapCommand.class).error("Database is busy!", e);
            }
        }
        oCurrentBTE = this.sessionInfo.getBTEManager().getCurrentBTE();
        return oCurrentBTE;
    }

    private boolean checkXmlErgebnisCode(TrfHashMap transferableMap, XmlDmsCommand xmlCmd) {
        String sDmsMsgText = xmlCmd.getMeldungstext();
        transferableMap.setValue("msgtxt", sDmsMsgText);
        int nStatus = xmlCmd.getErgebnisCode();
        if (nStatus != 0) {
            transferableMap.setValue("returncode", nStatus);
            transferableMap.setError(new DMSException("Ergebniscode: " + nStatus));
            return false;
        }
        return true;
    }

    private void ladeTippTrick(TrfHashMap transferableMap) {
        InfoObject oInfoObject = (InfoObject)transferableMap.getValue("info");
        if (oInfoObject instanceof InfoObjectText) {
            this.ladeInfoObjectText(transferableMap);
        }
    }

    private void ladeInfoObjectText(TrfHashMap transferableMap) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        if (sLang == null) {
            sLang = "en";
        }
        InfoObjectText oInfoObjectText = (InfoObjectText)transferableMap.getValue("info");
        String sFilename = oInfoObjectText.getFilename();
        String sTickerDir = GlobalObjects.getInstance().getTickerVerzeichnis();
        StringBuilder sbPfad = new StringBuilder();
        sbPfad.append(sTickerDir).append(File.separator);
        sbPfad.append(sLang.trim()).append(File.separator);
        String sFilenameAbs = sbPfad.toString() + sFilename;
        sFilenameAbs = StringUtils.substituteStringStraight(sFilenameAbs, "\\", File.separator);
        try {
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.alias("tipptrick", XMLInfoObjectText.class);
            FileInputStream oInStream = new FileInputStream(sFilenameAbs);
            InputStreamReader oInStreamReader = new InputStreamReader((InputStream)oInStream, "UTF-8");
            XMLInfoObjectText oXML = (XMLInfoObjectText)xstream.fromXML((Reader)oInStreamReader);
            oInfoObjectText.setNummer(oXML.nummer);
            oInfoObjectText.setText(oXML.text);
            oInfoObjectText.setUeberschrift(oXML.ueberschrift);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            transferableMap.setError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTippTrickGelesen(TrfHashMap transferableMap) {
        String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        Collection cTippsTricks = (Collection)transferableMap.getValue("tipps");
        if (cTippsTricks == null) {
            return;
        }
        ArrayList<String> cGelesen = new ArrayList<String>();
        for (InfoObject oInfoObject : cTippsTricks) {
            if (!oInfoObject.isGelesen()) continue;
            cGelesen.add(oInfoObject.getId());
        }
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.saveTippTrickGelesen");
            InfoToolDbAccess.saveGelesen(con, sFirmaId, sNutzerId, cGelesen);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.saveTippTrickGelesen");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void ladenTippTricksBasisinfo(TrfHashMap transferableMap) {
        block13: {
            sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
            sNutzerId = this.sessionInfo.getUserInfo().getID();
            sIsWichtig = (String)transferableMap.getValue("is_wichtig");
            bIsWichtig = sIsWichtig != null && sIsWichtig.equals("N") == false;
            con = null;
            res = null;
            gObj = ServerGlobalObjects.getInstance();
            try {
                con = gObj.getDBConnection("TrfHashMap.ladenTippTricks");
                tippsTricks = new ArrayList<InfoObjectText>();
                res = InfoToolDbAccess.loadTippsTricks(con, sFirmaId, sNutzerId, bIsWichtig);
                while (res.next()) {
                    sId = res.getString("Id");
                    sArt = res.getString("Art");
                    sFilename = res.getString("Filename");
                    sGelesen = res.getString("Gelesen");
                    v0 = bGelesen = sGelesen != null && sGelesen.equals("N") == false;
                    if (sArt.equals("Text")) {
                        tippsTricks.add(new InfoObjectText(sId, sFilename, sArt, bIsWichtig, bGelesen));
                        continue;
                    }
                    this.log.error("**Tipp mit der Id " + sId + " (Filename = " + sFilename + ") hat die unbekannte Art " + sArt);
                    this.log.error("**Bitte \u00fcberpr\u00fcfen!!!");
                    e = new UserHandlingException("**Tipp mit der Id " + sId + " (Filename = " + sFilename + ") hat die unbekannte Art " + sArt);
                    transferableMap.setError(e);
                }
                transferableMap.setValue("tipps", tippsTricks);
                ** try [egrp 1[TRYBLOCK] [0 : 348->366)] { 
            }
            catch (Exception e) {
                transferableMap.setError(e);
                e.printStackTrace();
                break block13;
            }
            finally {
                try {
                    WebetkUtils.closeQuery(res);
                    gObj.freeDBConnection(con, "TrfHashMap.ladenTippTricks");
                }
                catch (SQLException ex) {
                    transferableMap.setError(ex);
                    ex.printStackTrace();
                }
            }
lbl-1000:
            // 1 sources

            {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "TrfHashMap.ladenTippTricks");
            }
lbl32:
            // 1 sources

            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
            {
            }
        }
    }

    private void ladenTippTricksDetails(TrfHashMap transferableMap) {
        this.ladenTippTricksBasisinfo(transferableMap);
        List cInfoObjects = (List)transferableMap.getValue("tipps");
        if (cInfoObjects == null) {
            return;
        }
        for (InfoObjectText infoObjectText : cInfoObjects) {
            TrfHashMap trfInfoObject = new TrfHashMap(null);
            trfInfoObject.setValue("info", infoObjectText);
            this.ladeTippTrick(trfInfoObject);
            if (trfInfoObject.getError() == null) continue;
            transferableMap.setError(trfInfoObject.getError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void existiertTipps(TrfHashMap transferableMap) {
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.existiertTipps");
            boolean bErgebnis = InfoToolDbAccess.existTippsTricks(con);
            transferableMap.setValue("boolean", bErgebnis);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.existiertTipps");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existiertTickertext() throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.existiertTickertext");
            boolean bl = InfoToolDbAccess.existTickertext(con);
            return bl;
        }
        finally {
            gObj.freeDBConnection(con, "TrfHashMap.existiertTickertext");
        }
    }

    private void ladenTickertexte(TrfHashMap transferableMap) {
        try {
            if (!this.existiertTickertext()) {
                transferableMap.setValue("arraylist_of_string", null);
                return;
            }
            String sLang = this.sessionInfo.getAktuelleSprache();
            String sFilename = "startticker.xml";
            String sTickerDir = GlobalObjects.getInstance().getTickerVerzeichnis();
            StringBuilder sbPfad = new StringBuilder();
            sbPfad.append(sTickerDir).append(File.separator);
            sbPfad.append(sLang.trim()).append(File.separator);
            String sFilenameAbs = sbPfad.toString() + sFilename;
            sFilenameAbs = StringUtils.substituteStringStraight(sFilenameAbs, "\\", File.separator);
            TickerText oTickertext = new TickerText();
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.alias("ticker", XMLTickerText.class);
            FileInputStream oInStream = new FileInputStream(sFilenameAbs);
            InputStreamReader oInStreamReader = new InputStreamReader((InputStream)oInStream, "UTF-8");
            XMLTickerText oXML = (XMLTickerText)xstream.fromXML((Reader)oInStreamReader);
            oTickertext.appendTickerText(oXML.tickertext1);
            oTickertext.appendTickerText(oXML.tickertext2);
            oTickertext.appendTickerText(oXML.tickertext3);
            oTickertext.appendTickerText(oXML.tickertext4);
            oTickertext.appendTickerText(oXML.tickertext5);
            oTickertext.appendTickerText(oXML.tickertext6);
            oTickertext.appendTickerText(oXML.tickertext7);
            oTickertext.appendTickerText(oXML.tickertext8);
            oTickertext.appendTickerText(oXML.tickertext9);
            oTickertext.appendTickerText(oXML.tickertext10);
            transferableMap.setValue("arraylist_of_string", oTickertext.getTickerTexte());
        }
        catch (FileNotFoundException e) {
            transferableMap.setValue("arraylist_of_string", null);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            transferableMap.setError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void protokolliereLogin(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.protokolliereLogin");
            if (KonfigurationDbAccess.getAnzahlLogins(con, sFirmaId, sUserId) == 0) {
                KonfigurationDbAccess.insertLoginInfo(con, sFirmaId, sUserId);
            } else {
                KonfigurationDbAccess.updateLoginInfo(con, sFirmaId, sUserId, true);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.protokolliereLogin");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void protokolliereLogout(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.protokolliereLogout");
            KonfigurationDbAccess.updateLoginInfo(con, sFirmaId, sUserId, false);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.protokolliereLogout");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLoggedInUsers(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        List aUserIdsToIgnore = (List)transferableMap.getValue("userids_to_ignore");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.getLoggedInUsers");
            List<User> users = KonfigurationDbAccess.getLoggedInUsers(con, sFirmaId, aUserIdsToIgnore);
            transferableMap.setValue("userList", users);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.getLoggedInUsers");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInactiveUsers(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        List aUserIdsToIgnore = (List)transferableMap.getValue("userids_to_ignore");
        long lDateSince = (Long)transferableMap.getValue("datum");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.getInactiveUsers");
            List<User> users = KonfigurationDbAccess.getInactiveUsers(con, sFirmaId, aUserIdsToIgnore, lDateSince);
            transferableMap.setValue("userList", users);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.getInactiveUsers");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableConfiguration(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        String sTabelle = (String)transferableMap.getValue("TabellenName");
        String sZusatz = (String)transferableMap.getValue("zusatz");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.loadTableConfiguration");
            List<String> config = KonfigurationDbAccess.loadTableConfiguration(con, sFirmaId, sUserId, sTabelle, sZusatz);
            transferableMap.setValue("TabellenKonfiguration", config);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.loadTableConfiguration");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTableConfiguration(TrfHashMap transferableMap) {
        ArrayList oTableConfig = (ArrayList)transferableMap.getValue("TabellenKonfiguration");
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        String sTabelle = (String)transferableMap.getValue("TabellenName");
        String sZusatz = (String)transferableMap.getValue("zusatz");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.saveTableConfiguration");
            con.setAutoCommit(false);
            KonfigurationDbAccess.deleteTableConfiguration(con, sFirmaId, sUserId, sTabelle, sZusatz);
            KonfigurationDbAccess.insertTableConfiguration(con, oTableConfig, sFirmaId, sUserId, sTabelle, sZusatz);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
            try {
                gObj.freeDBConnection(con, "TrfHashMap.saveTableConfiguration");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAbsenderUndEmpfaenger(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.loadAbsenderUndEmpfaenger");
            ArrayList config = new ArrayList(KonfigurationDbAccess.loadAbsenderUndEmpfaenger(con, sFirmaId, sUserId));
            for (String[] element : config) {
                if (element[0].equals("E-Mail-Adresse Empfaenger")) {
                    transferableMap.setValue("eMailEmpfaenger", element[1]);
                    continue;
                }
                if (element[0].equals("E-Mail-Adresse Absender")) {
                    transferableMap.setValue("eMailAbsender", element[1]);
                    continue;
                }
                if (!element[0].equals("Name Absender")) continue;
                transferableMap.setValue("nameAbsender", element[1]);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                gObj.freeDBConnection(con, "TrfHashMap.loadAbsenderUndEmpfaenger");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAbsender(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        String sEmailAbsender = (String)transferableMap.getValue("eMailAbsender");
        String sNameAbsender = (String)transferableMap.getValue("nameAbsender");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.saveAbsender");
            con.setAutoCommit(false);
            KonfigurationDbAccess.deleteAbsender(con, sFirmaId, sUserId);
            KonfigurationDbAccess.insertAbsender(con, sFirmaId, sUserId, sEmailAbsender, sNameAbsender);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
            try {
                gObj.freeDBConnection(con, "TrfHashMap.saveAbsender");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEmpfaenger(TrfHashMap transferableMap) {
        String sFirmaId = (String)transferableMap.getValue("firmaid");
        String sUserId = (String)transferableMap.getValue("user_id");
        String sEmailEmpfaenger = (String)transferableMap.getValue("eMailEmpfaenger");
        Connection con = null;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        try {
            con = gObj.getDBConnection("TrfHashMap.saveEmpfaenger");
            con.setAutoCommit(false);
            KonfigurationDbAccess.deleteEmpfaenger(con, sFirmaId, sUserId);
            KonfigurationDbAccess.insertEmpfaenger(con, sFirmaId, sUserId, sEmailEmpfaenger);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
            try {
                gObj.freeDBConnection(con, "TrfHashMap.saveEmpfaenger");
            }
            catch (SQLException ex) {
                transferableMap.setError(ex);
                ex.printStackTrace();
            }
        }
    }

    private void getETKTexte(TrfHashMap transferableMap) {
        try {
            String sSprISO = this.sessionInfo.getUserInfo().getSprache();
            String sSprRegISO = this.sessionInfo.getUserInfo().getSpracheRegion();
            ETKTexte oETKTexte = new ETKTexte();
            oETKTexte.load(sSprISO, sSprRegISO);
            transferableMap.setValue("etktexte", oETKTexte);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
    }

    private void ladeMaerkteEtkLokaleProdukte(TrfHashMap transferableMap) {
        try {
            if (this.sessionInfo.doZentraleRecherche()) {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LADE_MAERKTE_ETK_LOKALE_PRODUKTE);
                return;
            }
            String sprache = (String)transferableMap.getValue("sprache");
            ArrayList<Markt> maerkte = Einstellungen.loadMaerkteEtkLokaleProdukte(sprache);
            transferableMap.setValue("marktListe", maerkte);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            this.log.error("Fehler beim Laden der Maerkte: ", ex);
        }
    }

    private void ladeAspgTeile(TrfHashMap transferableMap) {
        try {
            String sLang = this.sessionInfo.getAktuelleSprache();
            if (this.sessionInfo.doZentraleRecherche()) {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_ASPGTEILE);
                return;
            }
            String sprache = (String)transferableMap.getValue("sprache");
            Vector cTeile = (Vector)transferableMap.getValue("teileaspg");
            ArrayList<Teil> cTeileErgebnis = AspgDbAccess.loadAspgTeile(TeilHelper.toArrayList(cTeile), sprache);
            transferableMap.setValue("teileaspg", TeilHelper.toVector(cTeileErgebnis));
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            this.log.error("Fehler beim Laden der Maerkte: ", ex);
        }
    }

    private void ladeSteckerTeile(TrfHashMap transferableMap) {
        try {
            if (this.sessionInfo.doZentraleRecherche()) {
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_STECKER);
                return;
            }
            String sSprache = this.sessionInfo.getAktuelleSprache();
            Vector cTeile = (Vector)transferableMap.getValue("teileaspg");
            ArrayList<Teil> cTeileErgebnis = AspgDbAccess.loadStecker(TeilHelper.toArrayList(cTeile), sSprache);
            transferableMap.setValue("teileaspg", TeilHelper.toVector(cTeileErgebnis));
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            this.log.error("Fehler beim Laden der Maerkte: ", ex);
        }
    }

    private void createUSListen(TrfHashMap transferableMap) {
        String szUSFilename = (String)transferableMap.getValue("us_filename");
        if (szUSFilename != null && szUSFilename.length() > 0) {
            String sSprache = this.sessionInfo.getAktuelleSprache();
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            Collection<String> aMarken = this.sessionInfo.getUserMarken();
            for (String sMarke : aMarken) {
                String sUSListenId = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.usListenIds", "unknown-" + sMarke);
                Teileliste objTeileliste = new Teileliste(sMarke, sNutzerId, sUSListenId, sSprache);
                objTeileliste.setMarke(sMarke);
                try {
                    objTeileliste.insert(sFirma, sFiliale);
                }
                catch (Exception ex) {
                    transferableMap.setError(ex);
                    this.log.error("Fehler beim Anlegen der US-Listen: ", ex);
                }
            }
        }
    }
}

