/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.app.ImageCache;
import webetk.communication.CommunicationException;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfImage;
import webetk.javaserver.app.GlobalObjects;

public class TrfImageCommand
extends AbstractTransferableCommand {
    private static Logger log = Logger.getLogger(TrfImageCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfImage)) {
            log.error("Given transferable must be TrfImage, but it isn't!");
            throw new ClassCastException("TrfImage excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        Command command = this.transferable.getCommand();
        log.debug("Executing command: " + command);
        if (!Command.GET_IMAGE_NO_SESSION.equals(command) && !Command.GET_IMAGE.equals(command)) {
            log.error("No valid command: " + command);
            throw new InvalidDataException("No valid command: " + command);
        }
        this.loadImage();
    }

    public void loadImage() {
        TrfImage trfImage = (TrfImage)this.transferable;
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfImage, Command.GET_IMAGE);
            }
            catch (CommunicationException ex) {
                trfImage.setError(ex);
                return;
            }
            return;
        }
        if (trfImage.getImageID() == null || trfImage.getFormFactor() == null) {
            log.error("Could not load image! No ID or form factor found!");
            trfImage.setError(new Exception("Missing ID or form factor. Image load failed!"));
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String sFormat = ImageCache.requestImageAsByteArray(out, trfImage.getImageID(), trfImage.getFormFactor());
            if (sFormat == null) {
                log.error("Image could not be loaded! Cause unknown.");
                trfImage.setError(new Exception("Image could not be loaded! Cause unknown."));
                return;
            }
            trfImage.fromStream(out);
            trfImage.setImageFormat(sFormat);
        }
        catch (IOException ex) {
            log.error("I/O Error loading image from database!", ex);
            trfImage.setError(ex);
        }
        catch (DatabaseBusyException ex) {
            log.error("Database access failed during image loading!", ex);
            trfImage.setError(ex);
        }
        catch (SQLException ex) {
            log.error("SQL Error during image loading!", ex);
            trfImage.setError(ex);
        }
    }
}

