/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.app.BmwNetz;
import webetk.app.teileinfo.Notiz;
import webetk.app.teileinfo.Teileinfo;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfString;
import webetk.javaserver.app.GlobalObjects;

public class TrfStringCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfStringCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfString)) {
            this.log.error("Given transferable must be TrfString, but it isn't!");
            throw new ClassCastException("TrfString excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfString transferableString = (TrfString)this.transferable;
        Command command = transferableString.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.NO_OPERATION.equals(command)) {
            return;
        }
        if (Command.DELETE_NOTIZ.equals(command)) {
            this.deleteNotiz(transferableString);
            return;
        }
        if (Command.DELETE_FAHRZEUGIDENTIFIKATION.equals(command)) {
            this.deleteFahrzeugidentifikation(transferableString);
            return;
        }
        if (Command.LOAD_ASAP_URL.equals(command)) {
            this.loadAsapUrl(transferableString);
            return;
        }
        if (Command.LOAD_ASAP_TUNNEL_FLAG.equals(command)) {
            this.loadAsapTunnelFlag(transferableString);
            return;
        }
        if (Command.LOAD_NETZ.equals(command)) {
            this.loadNetz(transferableString);
            return;
        }
        if (Command.LOAD_PROGRAMM_VERSION.equals(command)) {
            this.ladeProgrammVersion(transferableString);
            return;
        }
        if (Command.CHECK_PREISE_GELADEN.equals(command)) {
            this.checkPreiseGeladen(transferableString);
            return;
        }
        if (Command.CHECK_IS_ISIS.equals(command)) {
            this.checkIsIsis(transferableString);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void deleteNotiz(TrfString transferableString) {
        String sNutzer = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sSachnummer = transferableString.getString();
        Notiz oNotiz = null;
        try {
            oNotiz = new Notiz();
            oNotiz.setSachnummer(sSachnummer);
            oNotiz.delete(sNutzer, sFirma);
        }
        catch (Exception e) {
            transferableString.setError(e);
        }
    }

    private void deleteFahrzeugidentifikation(TrfString transferableString) {
        this.sessionInfo.resetFzgId();
        this.sessionInfo.resetFzgSuche();
    }

    private void loadAsapUrl(TrfString transferableString) {
        BmwNetz oBmwNetz = new BmwNetz();
        try {
            String sIbaseConnectionType = transferableString.getString();
            oBmwNetz.load(sIbaseConnectionType);
            String sAsapUrl = oBmwNetz.getAsapURL();
            transferableString.setString(sAsapUrl);
        }
        catch (Exception ex) {
            transferableString.setError(ex);
        }
    }

    private void loadAsapTunnelFlag(TrfString transferableString) {
        if (GlobalObjects.getInstance().isIsis()) {
            return;
        }
        BmwNetz oBmwNetz = new BmwNetz();
        try {
            oBmwNetz.load();
            String sAsapTunnel = oBmwNetz.getAsapTunnel();
            transferableString.setString(sAsapTunnel);
        }
        catch (Exception ex) {
            transferableString.setError(ex);
        }
    }

    private void loadNetz(TrfString transferableString) {
        if (GlobalObjects.getInstance().isIsis()) {
            if (GlobalObjects.getInstance().isIgdomAccess()) {
                transferableString.setString("isIsis");
            } else {
                transferableString.setString(null);
            }
            return;
        }
        BmwNetz oBmwNetz = new BmwNetz();
        try {
            oBmwNetz.load();
            String sNetz = oBmwNetz.getNetz();
            transferableString.setString(sNetz);
        }
        catch (Exception ex) {
            transferableString.setError(ex);
        }
    }

    private void checkIsIsis(TrfString transferableString) {
        if (GlobalObjects.getInstance().isIsis()) {
            transferableString.setString("true");
        } else {
            transferableString.setString("false");
        }
    }

    private void ladeProgrammVersion(TrfString transferableString) {
        String szProgrammVersion = "";
        try {
            String sVersionsFile = GlobalObjects.getInstance().getRealPath("WEB-INF/version.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sVersionsFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                if (szLine.indexOf("Version.Programme=") == 0) {
                    szProgrammVersion = szLine.substring(18);
                    break;
                }
                szLine = in.readLine();
            }
            in.close();
        }
        catch (IOException ex) {
            transferableString.setError(ex);
            return;
        }
        transferableString.setString(szProgrammVersion);
    }

    private void checkPreiseGeladen(TrfString transferableString) {
        boolean bOK = false;
        try {
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            bOK = Teileinfo.checkPreiseGeladen(sFirma);
        }
        catch (Exception e) {
            transferableString.setError(e);
            return;
        }
        if (bOK) {
            transferableString.setString("J");
        } else {
            transferableString.setString("N");
        }
    }
}

