/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.DatabaseBusyException;
import webetk.DuplicateValueException;
import webetk.EmptyListException;
import webetk.InvalidDataException;
import webetk.ListLockedException;
import webetk.NoDataFoundException;
import webetk.app.BmwNetz;
import webetk.app.GenericTeil;
import webetk.app.ImageCache;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.bteanzeige.DruckansichtObject;
import webetk.app.fzgid.Auftrag;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.konfiguration.Nutzer;
import webetk.app.teileliste.Bestellliste;
import webetk.app.teileliste.Scoreliste;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.communication.CommunicationException;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.command.TrfFahrzeugIdCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfTeileliste;
import webetk.javaserver.app.GlobalObjects;
import webetk.javaserver.framework.SessionInfo;
import webetk.mrkprd.Marken;
import webetk.xmlapi.XmlCommunicationException;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.XmlDmsBarverkauf;
import webetk.xmlapi.dms.commands.XmlDmsEilauftrag;
import webetk.xmlapi.dms.commands.XmlDmsKostenvoranschlag;
import webetk.xmlapi.dms.commands.XmlDmsNeuteileAuftrag;
import webetk.xmlapi.dms.commands.XmlDmsStammsatzanlage;
import webetk.xmlapi.dms.commands.XmlDmsTeilelistenInfo;
import webetk.xmlapi.dms.commands.XmlDmsWerkstattAuftrag;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPosition;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPositionErweitert;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPositionKomplett;

public class TrfTeilelisteCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfTeilelisteCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfTeileliste)) {
            this.log.error("Given transferable must be TrfTeileliste, but it isn't!");
            throw new ClassCastException("TrfTeileliste excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfTeileliste transferableMap = (TrfTeileliste)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.NO_OPERATION.equals(command)) {
            return;
        }
        if (Command.LOAD_TEILELISTE.equals(command)) {
            this.ladeTeileliste(transferableMap);
            return;
        }
        if (Command.LOAD_BESTELLLISTE.equals(command)) {
            this.ladeBestellliste(transferableMap);
            return;
        }
        if (Command.SAVE_TEILELISTE_KOPFDATEN.equals(command)) {
            this.saveKopfdaten(transferableMap);
            return;
        }
        if (Command.DELETE_TEILELISTE.equals(command)) {
            this.deleteTeileliste(transferableMap);
            return;
        }
        if (Command.LOAD_TEIL_BASISDATEN.equals(command)) {
            this.loadTeilBasisdaten(transferableMap);
            return;
        }
        if (Command.TEILELISTE_INSERT_TEILE.equals(command)) {
            this.insertTeile(transferableMap);
            return;
        }
        if (Command.TEILELISTE_SAVE_TEIL.equals(command)) {
            this.saveTeile(transferableMap);
            return;
        }
        if (Command.TEILELISTE_DELETE_TEIL.equals(command)) {
            this.deleteTeil(transferableMap);
            return;
        }
        if (Command.DO_DATENABGLEICH.equals(command)) {
            this.doDatenAbgleich(transferableMap);
            return;
        }
        if (Command.DO_DMS_STAMMSATZ.equals(command)) {
            this.doDMSStammsatz(transferableMap);
            return;
        }
        if (Command.DO_DMS_SEND_LIST.equals(command)) {
            this.doDMSSendList(transferableMap);
            return;
        }
        if (Command.LOAD_TEIL_PREISDATEN.equals(command)) {
            this.loadTeilPreisdaten(transferableMap);
            return;
        }
        if (Command.UNLOCK_BESTELLLISTE.equals(command)) {
            this.unlockListe(transferableMap);
            return;
        }
        if (Command.SENDE_MAIL.equals(command)) {
            this.doSendMailOperation(transferableMap);
            return;
        }
        if (Command.LOAD_TEILELISTEN_UEBERSICHT.equals(command)) {
            this.loadTeilelistenUebersicht(transferableMap);
            return;
        }
        if (Command.INCREMENT_RECHUNGSNUMMER.equals(command)) {
            this.incrementRechungsnummer(transferableMap);
            return;
        }
        if (Command.SAVE_AUFTRAG.equals(command)) {
            this.saveAuftrag(transferableMap);
            return;
        }
        if (Command.LOAD_SENDEINFO.equals(command)) {
            this.doLadeSendeinfo(transferableMap);
            return;
        }
        if (Command.CHECK_KANN_TEILE_UEBERNEHMEN.equals(command)) {
            this.checkKannTeileUebernehmen(transferableMap);
            return;
        }
        if (Command.EIGENTUEMER_AENDERN.equals(command)) {
            this.aendereEigentuemer(transferableMap);
            return;
        }
        if (Command.GET_NEXT_TEILELISTEN_ID.equals(command)) {
            this.getNextTeilelistenId(transferableMap);
            return;
        }
        if (Command.COPY_TEILELISTE.equals(command)) {
            this.copyTeileliste(transferableMap);
            return;
        }
        if (Command.LOAD_BEARBEITERNR.equals(command)) {
            this.loadBearbeiterNr(transferableMap);
            return;
        }
        if (Command.INSERT_SCORE_LISTE.equals(command)) {
            this.insertScoreListe(transferableMap);
            return;
        }
        if (Command.SAP_SENDE.equals(command)) {
            this.sendeSap(transferableMap);
            return;
        }
        if (Command.SAP_HOLE_ANTWORT.equals(command)) {
            this.holeAntwortSap(transferableMap);
            return;
        }
        if (Command.SAP_STORNO.equals(command)) {
            this.stornoSap(transferableMap);
            return;
        }
        if (Command.LADE_ARBEITEN.equals(command)) {
            this.ladeArbeiten(transferableMap);
            return;
        }
        if (Command.INSERT_RRSAP_LISTE.equals(command)) {
            this.insertRrSapListe(transferableMap);
            return;
        }
        if (Command.RENAME_RRSAP_LISTE.equals(command)) {
            this.renameDefaultRrSapListe(transferableMap);
            return;
        }
        if (Command.GET_RR_NUTZERDATEN_PSI.equals(command)) {
            this.getRRNutzerDatenPsi(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void getRRNutzerDatenPsi(TrfTeileliste transferable) {
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.GET_RR_NUTZERDATEN_PSI);
        }
        catch (CommunicationException ex) {
            transferable.setError(ex);
        }
    }

    private void ladeArbeiten(TrfTeileliste transferableMap) {
        Teileliste oTL = (Teileliste)transferableMap.getValue("teileliste");
        Teil oSingleTeil = (Teil)transferableMap.getValue("teil");
        Vector<Teil> cTeile = (Vector<Teil>)transferableMap.getValue("teile");
        if (oTL != null) {
            cTeile = oTL.getTeile();
        } else if (oSingleTeil != null) {
            cTeile = new Vector();
            cTeile.add(oSingleTeil);
        }
        if (cTeile == null) {
            return;
        }
        String sMarke = null;
        sMarke = oTL != null ? oTL.getMarke() : (String)transferableMap.getValue("marke");
        String sAuftragsNr = (String)transferableMap.getValue("auftragsnr");
        String sKundenNr = (String)transferableMap.getValue("kundennr");
        int nKundenNr = -1;
        if (sKundenNr != null) {
            nKundenNr = Integer.parseInt(sKundenNr);
        }
        StringBuffer sAuftragsNrBuf = null;
        sAuftragsNrBuf = sAuftragsNr != null ? new StringBuffer(sAuftragsNr) : new StringBuffer("");
        IntWrapper kundenNr = new IntWrapper(nKundenNr);
        try {
            this.doDMSAbgleichArbeit(cTeile, sMarke, sAuftragsNrBuf, kundenNr, transferableMap);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    protected void doDMSAbgleichArbeit(Collection<Teil> cTeile, String sMarke, StringBuffer sAuftragsNrBuf, IntWrapper kundenNr, TrfTeileliste transferableMap) throws XmlParseException, XmlCommunicationException {
        Vector<String> aFehlerhafteTeilenummern = new Vector<String>();
        Vector<Integer> aFehlerhaftePos = new Vector<Integer>();
        Vector<Integer> aTeilRetCodes = new Vector<Integer>();
        if (cTeile == null) {
            return;
        }
        Iterator<Teil> iter = cTeile.iterator();
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        Vector<String> cTeileNr = new Vector<String>();
        Vector<String> cTeileArt = new Vector<String>();
        for (Teil oTeil : cTeile) {
            cTeileNr.add(oTeil.getTeilenummer());
            cTeileArt.add(oTeil.getTeileart());
        }
        String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
        String sAuftragsNr = null;
        if (sAuftragsNrBuf != null && sAuftragsNrBuf.length() > 0) {
            sAuftragsNr = sAuftragsNrBuf.toString();
        }
        int nKundenNr = 0;
        if (kundenNr != null) {
            nKundenNr = kundenNr.getValue();
        }
        XmlDmsTeilelistenInfo xmlReq = new XmlDmsTeilelistenInfo();
        xmlReq.setInputParameters(sNutzerId, sFirma, sFiliale, sAuftragsNr, nKundenNr, sDMSMarke, cTeileNr, cTeileArt);
        xmlReq.requestService();
        String sMsgText = xmlReq.getMeldungstext();
        transferableMap.setValue("msgtxt", sMsgText);
        int nStatus = xmlReq.getErgebnisCode();
        if (nStatus != 0) {
            transferableMap.setError(new DMSException(Integer.toString(nStatus)));
            return;
        }
        sAuftragsNr = xmlReq.getAuftragsnummer();
        if (sAuftragsNrBuf != null && sAuftragsNr != null && sAuftragsNr.length() > 0) {
            sAuftragsNrBuf.delete(0, sAuftragsNrBuf.length());
            sAuftragsNrBuf.append(sAuftragsNr);
        }
        nKundenNr = xmlReq.getKundennummer();
        if (kundenNr != null && nKundenNr > 0) {
            kundenNr.setValue(nKundenNr);
        }
        iter = cTeile.iterator();
        for (int i = 0; i < xmlReq.getTeileCount() && iter.hasNext(); ++i) {
            Teil oTeil = iter.next();
            nStatus = xmlReq.getErgebnisCode(i);
            if (nStatus != 0) {
                aFehlerhaftePos.add(new Integer(i + 1));
                aFehlerhafteTeilenummern.add(oTeil.getTeilenummerGespreizt());
                aTeilRetCodes.add(new Integer(nStatus));
                continue;
            }
            Teil oTeilOld = new Teil(oTeil);
            if (!oTeil.isTeilVonScore()) {
                oTeil.setBenennung(xmlReq.getTeilebezeichnung(i));
                double dPreis = xmlReq.getHaendlerpreis(i);
                oTeil.setHaendlerpreis(dPreis);
                oTeil.setPreis(dPreis);
            }
            oTeil.setLagerbestand(xmlReq.getLagerbestand(i));
            oTeil.setMinimalbestand(xmlReq.getMindestbestand(i));
            if (xmlReq.getBedarfshinweis(i) >= 0) {
                oTeil.setBedarfshinweis(new Integer(xmlReq.getBedarfshinweis(i)));
            } else {
                oTeil.setBedarfshinweis(null);
            }
            oTeil.setAuMe(xmlReq.getAUME(i));
            oTeil.setLagerort(xmlReq.getLagerort(i));
            oTeil.setRabatt(xmlReq.getRabatt(i));
            oTeil.setDispo(Integer.toString(xmlReq.getDispoCode(i)));
            oTeil.setSuffix(Integer.toString(xmlReq.getSuffix(i)));
            Double dMwst = xmlReq.getMwst(i);
            oTeil.setMwSt(dMwst);
            oTeil.setAtSt(xmlReq.getSondersteuer(i));
            if (oTeil.equals(oTeilOld)) continue;
            oTeil.setMustSave(true);
        }
        if (!aFehlerhafteTeilenummern.isEmpty()) {
            transferableMap.setError(new DMSException(aFehlerhaftePos, aFehlerhafteTeilenummern, aTeilRetCodes));
        }
    }

    protected void ladeTeileliste(TrfTeileliste transferableMap) {
        boolean bRrSap;
        Boolean oScore;
        String sSprache = this.sessionInfo.getAktuelleSprache();
        String sLandkuerzel = GlobalObjects.getInstance().getIsoCountryCodeIsis();
        String sMarke = "";
        Teileliste objTeileliste = null;
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        String sID = (String)transferableMap.getValue("teilelisteid");
        String sEigentuemer = (String)transferableMap.getValue("eigentuemer");
        if (sEigentuemer == null) {
            sEigentuemer = sNutzerId;
        }
        if (transferableMap.getValue("filialid") != null) {
            sFiliale = (String)transferableMap.getValue("filialid");
        }
        boolean bScore = (oScore = (Boolean)transferableMap.getValue("score")) != null && oScore != false;
        Boolean oRrSap = (Boolean)transferableMap.getValue("rrsaplisten");
        boolean bl = bRrSap = oRrSap != null && oRrSap != false;
        if (bScore) {
            Boolean oLoadTc = (Boolean)transferableMap.getValue("tc");
            boolean bLoadTc = oLoadTc != null && oLoadTc != false;
            Scoreliste objScoreliste = new Scoreliste(sID, sSprache, sEigentuemer, sFiliale);
            try {
                objScoreliste.reload(sFirma, sFiliale);
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    objScoreliste.setFzgIdString(this.sessionInfo.getFzgSucheInfo().getFzgIdString());
                }
            }
            catch (Exception e) {
                transferableMap.setError(e);
                return;
            }
            try {
                if (bLoadTc) {
                    objScoreliste.loadTcKennzeichen(this.sessionInfo.getFzgSucheInfo(), sLandkuerzel);
                }
            }
            catch (Exception e) {
                transferableMap.setError(e);
            }
            transferableMap.setValue("scoreliste", objScoreliste);
        } else {
            if (sID != null) {
                try {
                    objTeileliste = new Teileliste(sID, sEigentuemer, sSprache, sFirma, sFiliale);
                    if (!bRrSap) {
                        Boolean bLock = (Boolean)transferableMap.getValue("lock");
                        if (bLock != null && bLock.booleanValue() && !objTeileliste.sperre(bLock, sNutzerId, sFirma)) {
                            if (objTeileliste.getGesperrtVon() != null) {
                                String sName = Nutzer.loadNutzerName(sFirma, objTeileliste.getGesperrtVon());
                                transferableMap.setValue("username", sName);
                            }
                            transferableMap.setValue("teileliste", objTeileliste);
                            transferableMap.setError(new ListLockedException());
                            return;
                        }
                        Auftrag oAuftrag = objTeileliste.getAuftrag();
                        if (oAuftrag != null) {
                            String sFzgIdString = this.ermittleFzgIdString(oAuftrag.getFgstNr());
                            oAuftrag.setFzgIdString(sFzgIdString);
                        }
                    }
                }
                catch (Exception e) {
                    if (bRrSap) {
                        sMarke = Marken.getInstance().getMarke("RR").getBerechtigung();
                        objTeileliste = new Teileliste(sMarke, sNutzerId, sID, sSprache);
                        objTeileliste.setFiliale(sFiliale);
                        objTeileliste.setPrivat(true);
                        Calendar rightNow = Calendar.getInstance();
                        Date datToday = rightNow.getTime();
                        objTeileliste.setDatErstellung(datToday);
                        objTeileliste.setDatAenderung(datToday);
                        objTeileliste.setSapStatus("N");
                        try {
                            objTeileliste.saveKopfdaten(true, sFirma);
                            objTeileliste.loadRrNutzerdaten(null, sNutzerId, sFirma);
                        }
                        catch (Exception ex2) {
                            transferableMap.setError(ex2);
                            return;
                        }
                    }
                    SucheInfo objSucheInfo = this.sessionInfo.getSucheInfo();
                    if (objSucheInfo != null) {
                        sMarke = objSucheInfo.getMarke();
                        objTeileliste = new Teileliste(sMarke, sNutzerId, sID, sSprache);
                    }
                    transferableMap.setError(e);
                    return;
                }
                objTeileliste.setSelektiertesTeil(null);
            } else {
                String sNewID = (String)transferableMap.getValue("teilelistenewid");
                sMarke = (String)transferableMap.getValue("marke");
                objTeileliste = new Teileliste(sMarke, sNutzerId, sNewID, sSprache);
            }
            transferableMap.setValue("teileliste", objTeileliste);
        }
    }

    protected String ermittleFzgIdString(String sFgstNr) {
        TrfFahrzeugId trfFahrzeugId = new TrfFahrzeugId(null);
        trfFahrzeugId.setValue("fgstnr", sFgstNr);
        TrfFahrzeugIdCommand trfFahrzeugIdCommand = new TrfFahrzeugIdCommand();
        trfFahrzeugIdCommand.setEnvironment(this.sessionInfo);
        trfFahrzeugIdCommand.doEvalFgzIdString(trfFahrzeugId);
        String sFzgIdString = (String)trfFahrzeugId.getValue("fzgidstring");
        return sFzgIdString;
    }

    protected void ladeBestellliste(TrfTeileliste transferableMap) {
        String sSprache = this.sessionInfo.getAktuelleSprache();
        Bestellliste objBestellliste = null;
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        try {
            String sID = (String)transferableMap.getValue("teilelisteid");
            boolean bLock = (Boolean)transferableMap.getValue("lock");
            boolean bForceLock = (Boolean)transferableMap.getValue("forcelock");
            objBestellliste = sID == null ? (Bestellliste)transferableMap.getValue("teileliste") : new Bestellliste(sID, sSprache, sFirma, sFiliale);
            if (bLock) {
                objBestellliste.sperre(bLock, bForceLock, sNutzerId, sFirma);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("bestellliste", objBestellliste);
    }

    protected void unlockListe(TrfTeileliste transferableMap) {
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            Teileliste objTeileliste = (Teileliste)transferableMap.getValue("teileliste");
            if (objTeileliste instanceof Bestellliste) {
                Bestellliste objBestellliste = (Bestellliste)objTeileliste;
                objBestellliste.sperre(false, false, sNutzerId, sFirma);
            } else {
                objTeileliste.sperre(false, sNutzerId, sFirma);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    protected void saveKopfdaten(TrfTeileliste transferableMap) {
        Calendar rightNow;
        Teileliste objTeileliste = (Teileliste)transferableMap.getValue("teileliste");
        if (objTeileliste != null && objTeileliste.isRrSapListe()) {
            this.saveKopfdatenRr(transferableMap);
            return;
        }
        String sID = (String)transferableMap.getValue("teilelisteid");
        String sNewID = (String)transferableMap.getValue("teilelistenewid");
        String sMarke = (String)transferableMap.getValue("marke");
        Auftrag oAuftrag = (Auftrag)transferableMap.getValue("auftrag");
        String sAuftragsnummer = (String)transferableMap.getValue("auftragsnr");
        String sKundennummer = (String)transferableMap.getValue("kundennr");
        Boolean bPrivat = (Boolean)transferableMap.getValue("privat");
        String sSprache = this.sessionInfo.getAktuelleSprache();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sNutzerId = null;
        String sFiliale = null;
        sNutzerId = transferableMap.getValue("eigentuemer") != null ? (String)transferableMap.getValue("eigentuemer") : this.sessionInfo.getUserInfo().getID();
        sFiliale = transferableMap.getValue("filialid") != null ? (String)transferableMap.getValue("filialid") : this.sessionInfo.getUserInfo().getFilialeID();
        Boolean bScore = (Boolean)transferableMap.getValue("score");
        boolean bNeuanlage = sNewID != null;
        Date datErstellung = null;
        Date datAenderung = null;
        if (bScore != null && bScore.booleanValue()) {
            objTeileliste = new Scoreliste(sID, sSprache, sNutzerId, sFiliale);
            rightNow = Calendar.getInstance();
            datErstellung = rightNow.getTime();
        } else if (!bNeuanlage) {
            objTeileliste = new Teileliste(sMarke, sNutzerId, sID, sSprache);
            datErstellung = (Date)transferableMap.getValue("teilelisteerstellt");
        } else {
            sID = sNewID;
            objTeileliste = new Teileliste(sMarke, sNutzerId, sID, sSprache);
            rightNow = Calendar.getInstance();
            datErstellung = rightNow.getTime();
        }
        objTeileliste.setDatErstellung(datErstellung);
        objTeileliste.setAuftrag(oAuftrag);
        objTeileliste.setAuftragsNrLokal(sAuftragsnummer);
        Long lKundennummer = null;
        if (sKundennummer != null && sKundennummer.length() > 0) {
            lKundennummer = new Long(sKundennummer);
        }
        objTeileliste.setKundenNrLokal(lKundennummer);
        objTeileliste.setPrivat(bPrivat != null && bPrivat != false);
        objTeileliste.setNewID(sID);
        objTeileliste.setBemerkung((String)transferableMap.getValue("teilelistebemerkung"));
        Calendar rightNow2 = Calendar.getInstance();
        datAenderung = rightNow2.getTime();
        objTeileliste.setDatAenderung(datAenderung);
        try {
            objTeileliste.setFiliale(sFiliale);
            objTeileliste.saveKopfdaten(bNeuanlage, sFirma);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Teileliste gespeichert: " + sID);
        transferableMap.setValue("teilelisteid", sID);
        transferableMap.setValue("teilelistenewid", null);
        transferableMap.setValue("teilelisteerstellt", datErstellung);
        transferableMap.setValue("teilelistegeaendert", datAenderung);
        transferableMap.setValue("teileliste", objTeileliste);
    }

    protected void deleteTeileliste(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("deleteTeileliste");
        String sID = (String)transferableMap.getValue("teilelisteid");
        Collection aTL = null;
        if (sID == null && (aTL = (Collection)transferableMap.getValue("teilelisten")) == null) {
            this.log.error("weder TEILELISTEID noch TEILELISTEN gesetzt");
            return;
        }
        String sAuftragsnummer = (String)transferableMap.getValue("auftragsnr");
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sNutzerId = null;
        String sFiliale = null;
        sNutzerId = transferableMap.getValue("eigentuemer") != null ? (String)transferableMap.getValue("eigentuemer") : this.sessionInfo.getUserInfo().getID();
        sFiliale = transferableMap.getValue("filialid") != null ? (String)transferableMap.getValue("filialid") : this.sessionInfo.getUserInfo().getFilialeID();
        Boolean oScore = (Boolean)transferableMap.getValue("score");
        boolean bScore = oScore != null && oScore != false;
        try {
            if (sID != null) {
                Teileliste.delete(sID, sNutzerId, sFirma, sFiliale, sAuftragsnummer, bScore);
            } else if (aTL != null) {
                Iterator iTL = aTL.iterator();
                while (iTL.hasNext()) {
                    Teileliste oTL = (Teileliste)iTL.next();
                    sID = oTL.getID();
                    sNutzerId = oTL.getNutzerID();
                    sFiliale = oTL.getFiliale();
                    sAuftragsnummer = oTL.getAuftragsNr();
                    if (!oTL.sperre(true, sNutzerId, sFirma)) continue;
                    Teileliste.delete(sID, sNutzerId, sFirma, sFiliale, sAuftragsnummer, bScore);
                    iTL.remove();
                }
                transferableMap.setValue("teilelisten", aTL);
            }
        }
        catch (Exception e) {
            Logger.getLogger(TrfTeilelisteCommand.class).error("Fehler beim L\u00f6schen der Teileliste: " + e.getMessage());
            transferableMap.setError(e);
        }
    }

    protected void aendereEigentuemer(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("aendereEigentuemer");
        Collection aTL = (Collection)transferableMap.getValue("teilelisten");
        String sNewEigentuemer = (String)transferableMap.getValue("eigentuemer");
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        Iterator iTL = aTL.iterator();
        while (iTL.hasNext()) {
            Teileliste oTL = (Teileliste)iTL.next();
            try {
                String sFiliale = oTL.getFiliale();
                oTL.aendereEigentuemer(sNewEigentuemer, sFirma, sFiliale);
                iTL.remove();
            }
            catch (DuplicateValueException ex) {
                transferableMap.setError(ex);
            }
            catch (Exception ex) {
                Logger.getLogger(TrfTeilelisteCommand.class).error("Fehler beim Aendern des Eigentuemers: " + ex.getMessage());
                transferableMap.setError(ex);
                return;
            }
            transferableMap.setValue("teilelisten", aTL);
        }
    }

    protected void loadTeilBasisdaten(TrfTeileliste transferableMap) {
        String sMarke = (String)transferableMap.getValue("marke");
        String sSachnummer = (String)transferableMap.getValue("sachnummer");
        String sSprache = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sSprache);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.LOAD_TEIL_BASISDATEN);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
            return;
        }
        int nPos = 0;
        String sMenge = "";
        String sBemerkung = "";
        Teil oTeil = null;
        try {
            oTeil = new Teil(sSachnummer, nPos, sMenge, sBemerkung, sSprache);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        if (sMarke != null && !oTeil.checkMarke(sMarke)) {
            transferableMap.setError(new NoDataFoundException());
            return;
        }
        transferableMap.setValue("teil", oTeil);
    }

    protected void loadTeilPreisdaten(TrfTeileliste transferableMap) {
        Teil oTeil = (Teil)transferableMap.getValue("teil");
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            oTeil.loadPreisInfo(sFirma);
        }
        catch (Exception e) {
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("teil", oTeil);
    }

    protected void insertTeile(TrfTeileliste transferableMap) {
        this.log.debug("Entering insertTeile");
        Boolean bFzgIdString = (Boolean)transferableMap.getValue("fzgidstring");
        Boolean bAddMenge = (Boolean)transferableMap.getValue("menge");
        boolean addMenge = false;
        if (bAddMenge != null) {
            addMenge = bAddMenge;
        }
        String sFzgIdString = null;
        if (bFzgIdString != null && bFzgIdString.booleanValue() && this.sessionInfo.getFzgIdInfo() != null) {
            boolean bDisplayDate;
            Boolean bDisplayDateAlways = this.sessionInfo.getUserInfo().getAlwaysDisplayProduktDate();
            boolean bHasRechtDisplayDate = this.sessionInfo.hasRechtAnzeigeProddatum();
            boolean bl = bDisplayDate = bHasRechtDisplayDate;
            if (bDisplayDate && (bDisplayDateAlways == null || !bDisplayDateAlways.booleanValue())) {
                bDisplayDate = false;
            }
            sFzgIdString = this.sessionInfo.getFzgIdInfo().toString(bDisplayDate, null, null);
        }
        String sSprache = this.sessionInfo.getAktuelleSprache();
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferableMap.setValue("sprache", sSprache);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.TEILELISTE_INSERT_TEILE);
            }
            catch (CommunicationException ex) {
                transferableMap.setError(ex);
                return;
            }
        }
        Collection<?> cTeileAusTrf = this.getTeile(transferableMap);
        Teileliste objTeileliste = (Teileliste)transferableMap.getValue("teileliste");
        String sJobId = (String)transferableMap.getValue("jobid");
        String sSrpId = (String)transferableMap.getValue("srpid");
        Boolean oScore = (Boolean)transferableMap.getValue("score");
        boolean bScore = oScore != null && oScore != false;
        try {
            boolean bLoadPubldaten;
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sEigentuemer = null;
            String sFiliale = null;
            sEigentuemer = transferableMap.getValue("eigentuemer") != null ? (String)transferableMap.getValue("eigentuemer") : sNutzerId;
            sFiliale = transferableMap.getValue("filialid") != null ? (String)transferableMap.getValue("filialid") : this.sessionInfo.getUserInfo().getFilialeID();
            Boolean loadAnzNotizen = (Boolean)transferableMap.getValue("notiz");
            boolean bLoadAnzNotizen = loadAnzNotizen != null && loadAnzNotizen != false;
            boolean bIstBestellliste = false;
            Bestellliste objBestellliste = null;
            Scoreliste objScoreliste = null;
            if (objTeileliste == null) {
                Calendar rightNow;
                String sListenID = (String)transferableMap.getValue("teilelisteid");
                String sIstBestellliste = (String)transferableMap.getValue("istbestellliste");
                if (sIstBestellliste != null && sIstBestellliste.equals("J")) {
                    bIstBestellliste = true;
                }
                if (bIstBestellliste) {
                    objBestellliste = new Bestellliste(sListenID, sSprache, sFirma, sFiliale);
                    if (objBestellliste.getGesperrt()) {
                        transferableMap.setError(new ListLockedException());
                        return;
                    }
                } else if (bScore) {
                    objScoreliste = new Scoreliste(sListenID, sSprache, sEigentuemer, sFiliale);
                    if (!objScoreliste.sperre(true, sNutzerId, sFirma)) {
                        if (objScoreliste.getGesperrtVon() != null) {
                            String sName = Nutzer.loadNutzerName(sFirma, objScoreliste.getGesperrtVon());
                            transferableMap.setValue("username", sName);
                        }
                        transferableMap.setValue("scoreliste", objScoreliste);
                        transferableMap.setError(new ListLockedException());
                        return;
                    }
                    objScoreliste.reload(sFirma, sFiliale);
                    rightNow = Calendar.getInstance();
                    objScoreliste.setDatAenderung(rightNow.getTime());
                } else {
                    objTeileliste = new Teileliste(sListenID, sEigentuemer, sSprache);
                    objTeileliste.setFiliale(sFiliale);
                    if (!objTeileliste.sperre(true, sNutzerId, sFirma)) {
                        if (objTeileliste.getGesperrtVon() != null) {
                            String sName = Nutzer.loadNutzerName(sFirma, objTeileliste.getGesperrtVon());
                            transferableMap.setValue("username", sName);
                        }
                        transferableMap.setValue("teileliste", objTeileliste);
                        transferableMap.setError(new ListLockedException());
                        return;
                    }
                    objTeileliste.reload(sFirma, sFiliale);
                    rightNow = Calendar.getInstance();
                    objTeileliste.setDatAenderung(rightNow.getTime());
                }
            } else if (objTeileliste instanceof Bestellliste) {
                objBestellliste = (Bestellliste)objTeileliste;
            } else if (objTeileliste instanceof Scoreliste) {
                objScoreliste = (Scoreliste)objTeileliste;
            }
            Vector<Teil> cTeile = new Vector<Teil>();
            Iterator<?> iter = cTeileAusTrf.iterator();
            while (iter.hasNext()) {
                Auftrag oAuftrag;
                String sBemerkung;
                Teil oTeil = null;
                Object obj = iter.next();
                if (obj instanceof Teil) {
                    oTeil = (Teil)obj;
                } else if (obj instanceof String) {
                    String sSachnummer = (String)obj;
                    int nPos = 0;
                    String sMenge = "";
                    sBemerkung = "";
                    oTeil = new Teil(sSachnummer, nPos, sMenge, sBemerkung, sSprache);
                } else if (obj instanceof webetk.app.aspg.Teil) {
                    webetk.app.aspg.Teil aspgTeil = (webetk.app.aspg.Teil)obj;
                    int nPos = 0;
                    String sMenge = "";
                    if (addMenge) {
                        sMenge = aspgTeil.getMenge();
                    }
                    sBemerkung = "";
                    oTeil = new Teil(aspgTeil.getSachnummer(), nPos, sMenge, sBemerkung, sSprache);
                    oTeil.setAspgTyp(aspgTeil.getAspgTyp());
                    oTeil.setAspgRef(aspgTeil.getAspgRef());
                    oTeil.setAspgMenge(aspgTeil.getAspgMenge());
                    oTeil.setRuecksendepflicht(aspgTeil.getRuecksendepflicht());
                } else if (obj instanceof GenericTeil) {
                    GenericTeil t = (GenericTeil)obj;
                    String sSachnummer = t.getSachnummer();
                    int nPos = 0;
                    String sMenge = "";
                    String sBemerkung2 = "";
                    oTeil = new Teil(sSachnummer, nPos, sMenge, sBemerkung2, sSprache);
                    oTeil.setRuecksendepflicht(t.getRuecksendepflicht());
                } else {
                    throw new ClassCastException("Teil or String excepted!");
                }
                if (bIstBestellliste && (oAuftrag = (Auftrag)transferableMap.getValue("auftrag")) != null) {
                    String sKundenname = oAuftrag.getKundenname();
                    if (sKundenname != null && sKundenname.length() > 0) {
                        oTeil.setBemerkung(oAuftrag.getKundenname());
                    }
                    oTeil.setKundennummer(oAuftrag.getKundenNr());
                    oTeil.setAuftragsnummer(oAuftrag.getAuftragsNr());
                }
                oTeil.setFIString(sFzgIdString);
                cTeile.add(oTeil);
            }
            boolean bl = bLoadPubldaten = !this.sessionInfo.doZentraleRecherche();
            if (bIstBestellliste && objBestellliste != null) {
                objBestellliste.addTeile(cTeile, sSprache, true, bLoadPubldaten);
                objBestellliste.setFiliale(sFiliale);
                objBestellliste.insertTeileInDB(sFirma);
                transferableMap.setValue("bestellliste", objBestellliste);
            } else if (bScore && objScoreliste != null) {
                objScoreliste.setFiliale(sFiliale);
                objScoreliste.addTeile(cTeile, sSprache, false, bLoadPubldaten, sNutzerId, sFirma, sJobId, sSrpId);
                objScoreliste.saveKopfdaten(false, sFirma);
                objScoreliste.insertTeileInDB(sFirma, sJobId, sSrpId);
                objScoreliste.sperre(false, sNutzerId, sFirma);
                transferableMap.setValue("scoreliste", objScoreliste);
            } else if (objTeileliste != null) {
                String sRrSapStatus;
                objTeileliste.setFiliale(sFiliale);
                objTeileliste.addTeile(cTeile, sSprache, false, addMenge, bLoadPubldaten, bLoadAnzNotizen, sNutzerId, sFirma);
                objTeileliste.saveKopfdaten(false, sFirma);
                objTeileliste.insertTeileInDB(sFirma);
                objTeileliste.sperre(false, sNutzerId, sFirma);
                transferableMap.setValue("teileliste", objTeileliste);
                if (objTeileliste.isRrSapListe() && objTeileliste.getSapStatus() != null && ((sRrSapStatus = objTeileliste.getSapStatus()).equals("A") || sRrSapStatus.equals("E"))) {
                    this.stornoSap(transferableMap);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(TrfTeilelisteCommand.class).debug("Die Teile konnten nicht \u00fcbernommen werden" + e.getMessage());
            transferableMap.setError(e);
        }
    }

    private Collection<?> getTeile(TrfTeileliste transferableMap) {
        if (transferableMap.getValue("teile") != null) {
            return (Collection)transferableMap.getValue("teile");
        }
        if (transferableMap.getValue("teileaspg") != null) {
            return (Collection)transferableMap.getValue("teileaspg");
        }
        if (transferableMap.getValue("teile_ersetzung") != null) {
            return (Collection)transferableMap.getValue("teile_ersetzung");
        }
        if (transferableMap.getValue("teile_norm") != null) {
            return (Collection)transferableMap.getValue("teile_norm");
        }
        if (transferableMap.getValue("teilenotiz") != null) {
            return (Collection)transferableMap.getValue("teilenotiz");
        }
        if (transferableMap.getValue("teile_verwendung") != null) {
            return (Collection)transferableMap.getValue("teile_verwendung");
        }
        return (Collection)transferableMap.getValue("genericteile");
    }

    protected void saveTeile(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering saveTeil");
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sNutzerId = null;
        String sFiliale = null;
        sNutzerId = transferableMap.getValue("eigentuemer") != null ? (String)transferableMap.getValue("eigentuemer") : this.sessionInfo.getUserInfo().getID();
        sFiliale = transferableMap.getValue("filialid") != null ? (String)transferableMap.getValue("filialid") : this.sessionInfo.getUserInfo().getFilialeID();
        String sID = (String)transferableMap.getValue("teilelisteid");
        boolean bIstBestellliste = false;
        String sIstBestellliste = (String)transferableMap.getValue("istbestellliste");
        if (sIstBestellliste != null && sIstBestellliste.equals("J")) {
            bIstBestellliste = true;
        }
        String sJobId = (String)transferableMap.getValue("jobid");
        String sSrpId = (String)transferableMap.getValue("srpid");
        Vector cTeile = (Vector)transferableMap.getValue("teile");
        try {
            if (!bIstBestellliste) {
                Iterator iTeile = cTeile.iterator();
                Teil oTeil = null;
                String sJobIdNeu = null;
                String sSrpIdNeu = null;
                if (iTeile.hasNext()) {
                    oTeil = (Teil)iTeile.next();
                    sJobIdNeu = oTeil.getJobId();
                    sSrpIdNeu = oTeil.getSrpId();
                }
                Teileliste objTeileliste = null;
                if (sJobId != null) {
                    String sSprache = this.sessionInfo.getAktuelleSprache();
                    objTeileliste = new Scoreliste(sID, sSprache, sNutzerId, sFiliale);
                    Scoreliste objScoreliste = (Scoreliste)objTeileliste;
                    objScoreliste.reload(sFirma, sFiliale);
                    String sJobIdAlt = sJobId;
                    String sSrpIdAlt = sSrpId;
                    if (!sJobIdAlt.equals(sJobIdNeu) || !sSrpIdAlt.equals(sSrpIdNeu)) {
                        objScoreliste.updateJobSrp(cTeile, sFirma, sJobIdAlt, sSrpIdAlt);
                    }
                } else {
                    objTeileliste = new Teileliste("", sNutzerId, sID, "");
                }
                if (cTeile.size() == 1) {
                    if (oTeil != null) {
                        oTeil.saveInListe(sID, bIstBestellliste, sNutzerId, sFirma, sFiliale, sJobIdNeu, sSrpIdNeu);
                    }
                } else {
                    objTeileliste.setTeile(cTeile);
                    objTeileliste.setFiliale(sFiliale);
                    if (objTeileliste instanceof Scoreliste) {
                        Scoreliste objScoreliste = (Scoreliste)objTeileliste;
                        objScoreliste.insertTeileInDB(sFirma, sJobIdNeu, sSrpIdNeu);
                    } else {
                        objTeileliste.insertTeileInDB(sFirma);
                    }
                }
                Calendar rightNow = Calendar.getInstance();
                Date datAenderung = rightNow.getTime();
                objTeileliste.setDatAenderung(datAenderung);
                objTeileliste.setFiliale(sFiliale);
                objTeileliste.saveAenderungsdatum(sFirma);
            } else {
                Bestellliste objBestellliste = new Bestellliste(sID);
                if (cTeile.size() == 1) {
                    Iterator iTeile = cTeile.iterator();
                    Teil oTeil = (Teil)iTeile.next();
                    oTeil.saveInListe(sID, bIstBestellliste, sNutzerId, sFirma, sFiliale, null, null);
                } else {
                    objBestellliste.setTeile(cTeile);
                    objBestellliste.setFiliale(sFiliale);
                    objBestellliste.insertTeileInDB(sFirma);
                }
                objBestellliste.setTeile(cTeile);
                objBestellliste.setFiliale(sFiliale);
                objBestellliste.insertTeileInDB(sFirma);
            }
        }
        catch (Exception e) {
            Logger.getLogger(TrfTeilelisteCommand.class).debug("Teile konnten nicht gespeichert werden" + e.getMessage());
            transferableMap.setError(e);
        }
    }

    protected void deleteTeil(TrfTeileliste transferableMap) {
        Boolean oScore;
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering deleteTeil");
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sNutzerId = null;
        String sFiliale = null;
        sNutzerId = transferableMap.getValue("eigentuemer") != null ? (String)transferableMap.getValue("eigentuemer") : this.sessionInfo.getUserInfo().getID();
        sFiliale = transferableMap.getValue("filialid") != null ? (String)transferableMap.getValue("filialid") : this.sessionInfo.getUserInfo().getFilialeID();
        String sID = (String)transferableMap.getValue("teilelisteid");
        boolean bIstBestellliste = false;
        String sIstBestellliste = (String)transferableMap.getValue("istbestellliste");
        if (sIstBestellliste != null && sIstBestellliste.equals("J")) {
            bIstBestellliste = true;
        }
        boolean bScore = (oScore = (Boolean)transferableMap.getValue("score")) != null && oScore != false;
        Collection cTeile = (Collection)transferableMap.getValue("teile");
        try {
            if (bIstBestellliste) {
                Bestellliste oBl = new Bestellliste(sID);
                oBl.setFiliale(sFiliale);
                oBl.deleteParts(cTeile, sFirma);
            } else if (bScore) {
                Scoreliste oSl = new Scoreliste();
                oSl.setID(sID);
                oSl.setNutzerID(sNutzerId);
                oSl.setFiliale(sFiliale);
                oSl.deleteParts(cTeile, sFirma);
            } else {
                Teileliste oTl = new Teileliste();
                oTl.setID(sID);
                oTl.setNutzerID(sNutzerId);
                oTl.setFiliale(sFiliale);
                oTl.deleteParts(cTeile, sFirma);
            }
        }
        catch (Exception e) {
            Logger.getLogger(TrfTeilelisteCommand.class).debug("Die Teile konnten nicht gel\u00f6scht werden." + e.getMessage());
            transferableMap.setError(e);
        }
    }

    protected void loadTeilelistenUebersicht(TrfTeileliste transferableMap) {
        String sUSDirect;
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        String sSprache = this.sessionInfo.getAktuelleSprache();
        boolean bMitBestelllisten = this.sessionInfo.getDMSVerwenden();
        Boolean bOhneBestelllisten = (Boolean)transferableMap.getValue("ohnebestelllisten");
        if (bOhneBestelllisten != null && bOhneBestelllisten.booleanValue()) {
            bMitBestelllisten = false;
        }
        boolean bUSDirect = (sUSDirect = (String)transferableMap.getValue("us_filename")) != null && sUSDirect.trim().length() > 0;
        String sFilter = (String)transferableMap.getValue("filter");
        try {
            boolean bPrivat = this.sessionInfo.getUserInfo().hasRecht("R_WEBETK_FREMDE_PRIVATE_TL");
            Vector<Teileliste> aTeilelisten = Teileliste.loadTeilelistenUebersicht(sNutzerId, sFirma, sFiliale, sSprache, bMitBestelllisten, bUSDirect, sFilter, bPrivat);
            if (aTeilelisten != null && !this.sessionInfo.getUserInfo().hasRecht("R_WEBETK_RR_ORDER_LIST")) {
                for (int ii = aTeilelisten.size() - 1; ii >= 0; --ii) {
                    Teileliste oTeileliste = aTeilelisten.elementAt(ii);
                    if (!oTeileliste.isRrSapListe()) continue;
                    aTeilelisten.remove(ii);
                }
            }
            ArrayList<Teileliste> teilelistes = new ArrayList<Teileliste>();
            teilelistes.addAll(aTeilelisten);
            transferableMap.setValue("teilelisten", teilelistes);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    protected void doDatenAbgleich(TrfTeileliste transferableMap) {
        this.log.debug("Entering doDatenAbgleich");
        Boolean bParamFull = (Boolean)transferableMap.getValue("datenabgleich_full");
        boolean bFull = false;
        if (bParamFull != null) {
            bFull = bParamFull;
        }
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = null;
        sFiliale = transferableMap.getValue("filialid") != null ? (String)transferableMap.getValue("filialid") : this.sessionInfo.getUserInfo().getFilialeID();
        Konfiguration oKonfiguration = null;
        oKonfiguration = new Konfiguration(sFirma, sFiliale);
        try {
            oKonfiguration.loadKonfiguration();
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        String sDatenabgleich = oKonfiguration.getDatenabgleich();
        boolean bDatenabgleichImmer = sDatenabgleich != null && sDatenabgleich.equals("I");
        Teileliste oTL = (Teileliste)transferableMap.getValue("teileliste");
        Teil oSingleTeil = (Teil)transferableMap.getValue("teil");
        Vector<Teil> cTeile = (Vector<Teil>)transferableMap.getValue("teile");
        if (oTL != null) {
            cTeile = oTL.getTeile();
        } else if (oSingleTeil != null) {
            cTeile = new Vector();
            cTeile.add(oSingleTeil);
        }
        if (cTeile == null) {
            return;
        }
        if (bFull) {
            if (oTL == null || this.sessionInfo.doZentraleRecherche()) {
                this.doPubldatenAbgleich(cTeile);
            } else {
                try {
                    if (oTL instanceof Scoreliste) {
                        ((Scoreliste)oTL).doPubldatenAbgleich(sFirma, sFiliale);
                    } else {
                        oTL.doPubldatenAbgleich(sFirma, sFiliale);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (this.sessionInfo.getDMSVerwenden() && (bFull || bDatenabgleichImmer)) {
            String sMarke = null;
            sMarke = oTL != null ? oTL.getMarke() : (String)transferableMap.getValue("marke");
            String sAuftragsNr = (String)transferableMap.getValue("auftragsnr");
            String sKundenNr = (String)transferableMap.getValue("kundennr");
            int nKundenNr = -1;
            if (sKundenNr != null) {
                nKundenNr = Integer.parseInt(sKundenNr);
            }
            StringBuffer sAuftragsNrBuf = null;
            sAuftragsNrBuf = sAuftragsNr != null ? new StringBuffer(sAuftragsNr) : new StringBuffer("");
            IntWrapper kundenNr = new IntWrapper(nKundenNr);
            try {
                this.doDMSAbgleich(cTeile, sMarke, sAuftragsNrBuf, kundenNr, transferableMap);
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
            }
            if (oTL != null && oTL.getAuftrag() == null) {
                oTL.setAuftragsNrLokal(sAuftragsNrBuf.toString());
                oTL.setKundenNrLokal(new Long(kundenNr.getValue()));
            }
        } else if (bFull) {
            Iterator<Teil> iter = cTeile.iterator();
            Teil oTeil = null;
            while (iter.hasNext()) {
                oTeil = iter.next();
                if (oTeil.getLokalteil()) continue;
                if (!oTeil.isTeilVonScore()) {
                    oTeil.setPreis(0.0);
                }
                oTeil.setMwSt(null);
                oTeil.setAtSt(null);
            }
        }
        if (oTL == null) {
            this.doPreismodulAbgleich(cTeile);
        } else {
            try {
                oTL.doPreismodulAbgleich(sFirma, sFiliale);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            this.doKonfigurationAbgleich(oKonfiguration, cTeile);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        if (oTL != null) {
            try {
                oTL.setFiliale(sFiliale);
                oTL.saveTeile(cTeile, sFirma);
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
        }
        if (oTL != null) {
            transferableMap.setValue("teileliste", oTL);
        } else {
            transferableMap.setValue("teil", oSingleTeil);
        }
    }

    protected void doDMSAbgleich(Collection<Teil> cTeile, String sMarke, StringBuffer sAuftragsNrBuf, IntWrapper kundenNr, TrfTeileliste transferableMap) throws XmlParseException, XmlCommunicationException {
        Vector<String> aFehlerhafteTeilenummern = new Vector<String>();
        Vector<Integer> aFehlerhaftePos = new Vector<Integer>();
        Vector<Integer> aTeilRetCodes = new Vector<Integer>();
        if (cTeile == null) {
            return;
        }
        Iterator<Teil> iter = cTeile.iterator();
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        Vector<String> cTeileNr = new Vector<String>();
        for (Teil oTeil : cTeile) {
            cTeileNr.add(oTeil.getTeilenummer());
        }
        String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
        String sAuftragsNr = null;
        if (sAuftragsNrBuf != null && sAuftragsNrBuf.length() > 0) {
            sAuftragsNr = sAuftragsNrBuf.toString();
        }
        int nKundenNr = 0;
        if (kundenNr != null) {
            nKundenNr = kundenNr.getValue();
        }
        XmlDmsTeilelistenInfo xmlReq = new XmlDmsTeilelistenInfo();
        xmlReq.setInputParameters(sNutzerId, sFirma, sFiliale, sAuftragsNr, nKundenNr, sDMSMarke, cTeileNr);
        xmlReq.requestService();
        String sMsgText = xmlReq.getMeldungstext();
        transferableMap.setValue("msgtxt", sMsgText);
        int nStatus = xmlReq.getErgebnisCode();
        if (nStatus != 0) {
            transferableMap.setError(new DMSException(Integer.toString(nStatus)));
            return;
        }
        sAuftragsNr = xmlReq.getAuftragsnummer();
        if (sAuftragsNrBuf != null && sAuftragsNr != null && sAuftragsNr.length() > 0) {
            sAuftragsNrBuf.delete(0, sAuftragsNrBuf.length());
            sAuftragsNrBuf.append(sAuftragsNr);
        }
        nKundenNr = xmlReq.getKundennummer();
        if (kundenNr != null && nKundenNr > 0) {
            kundenNr.setValue(nKundenNr);
        }
        iter = cTeile.iterator();
        for (int i = 0; i < xmlReq.getTeileCount() && iter.hasNext(); ++i) {
            Teil oTeil = iter.next();
            nStatus = xmlReq.getErgebnisCode(i);
            if (nStatus != 0) {
                aFehlerhaftePos.add(new Integer(i + 1));
                aFehlerhafteTeilenummern.add(oTeil.getTeilenummerGespreizt());
                aTeilRetCodes.add(new Integer(nStatus));
                continue;
            }
            Teil oTeilOld = new Teil(oTeil);
            if (!oTeil.isTeilVonScore()) {
                oTeil.setBenennung(xmlReq.getTeilebezeichnung(i));
                double dPreis = xmlReq.getHaendlerpreis(i);
                oTeil.setHaendlerpreis(dPreis);
                oTeil.setPreis(dPreis);
            }
            oTeil.setLagerbestand(xmlReq.getLagerbestand(i));
            oTeil.setMinimalbestand(xmlReq.getMindestbestand(i));
            if (xmlReq.getBedarfshinweis(i) >= 0) {
                oTeil.setBedarfshinweis(new Integer(xmlReq.getBedarfshinweis(i)));
            } else {
                oTeil.setBedarfshinweis(null);
            }
            oTeil.setAuMe(xmlReq.getAUME(i));
            oTeil.setLagerort(xmlReq.getLagerort(i));
            oTeil.setRabatt(xmlReq.getRabatt(i));
            oTeil.setDispo(Integer.toString(xmlReq.getDispoCode(i)));
            oTeil.setSuffix(Integer.toString(xmlReq.getSuffix(i)));
            Double dMwst = xmlReq.getMwst(i);
            oTeil.setMwSt(dMwst);
            oTeil.setAtSt(xmlReq.getSondersteuer(i));
            if (oTeil.equals(oTeilOld)) continue;
            oTeil.setMustSave(true);
        }
        if (!aFehlerhafteTeilenummern.isEmpty()) {
            transferableMap.setError(new DMSException(aFehlerhaftePos, aFehlerhafteTeilenummern, aTeilRetCodes));
        }
    }

    protected void doPreismodulAbgleich(Collection<Teil> cTeile) {
        if (cTeile == null) {
            return;
        }
        for (Teil oTeil : cTeile) {
            if (oTeil.getLokalteil()) continue;
            try {
                Teil oTeilOld = new Teil(oTeil);
                String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
                oTeil.loadPreisInfo(sFirma);
                if (oTeil.equals(oTeilOld)) continue;
                oTeil.setMustSave(true);
            }
            catch (Exception e) {}
        }
    }

    protected void doPubldatenAbgleich(Vector<Teil> cTeile) {
        if (cTeile == null) {
            return;
        }
        try {
            String sSprache = this.sessionInfo.getAktuelleSprache();
            if (this.sessionInfo.doZentraleRecherche()) {
                TrfTeileliste trf = new TrfTeileliste(null);
                Teileliste objTeileliste = new Teileliste();
                objTeileliste.setTeile(cTeile);
                trf.setValue("teileliste", objTeileliste);
                trf.setValue("sprache", sSprache);
                trf.setValue("replace_all", new Boolean(true));
                GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.DO_DATENABGLEICH);
                objTeileliste = (Teileliste)trf.getValue("teileliste");
                cTeile.clear();
                cTeile.addAll(objTeileliste.getTeile());
            } else {
                for (Teil oTeil : cTeile) {
                    if (oTeil.getLokalteil()) continue;
                    Teil oTeilOld = new Teil(oTeil);
                    Teil oTeilPublDaten = null;
                    oTeilPublDaten = new Teil(oTeil.getSachnummer(), oTeil.getPosInt(), oTeil.getMenge(), oTeil.getBemerkung(), sSprache);
                    oTeil.setMarken(oTeilPublDaten.getMarken());
                    oTeil.setTeileart(oTeilPublDaten.getTeileart());
                    oTeil.setProduktklasse(oTeilPublDaten.getProduktklasse());
                    oTeil.setMAM(oTeilPublDaten.getMAM());
                    oTeil.setVVM(oTeilPublDaten.getVVM());
                    oTeil.setLVM(oTeilPublDaten.getLVM());
                    oTeil.setBVM(oTeilPublDaten.getBVM());
                    oTeil.setHG(oTeilPublDaten.getHG());
                    oTeil.setUG(oTeilPublDaten.getUG());
                    if (!oTeil.isTeilVonScore()) {
                        oTeil.setBenennung(oTeilPublDaten.getBenennung());
                    }
                    oTeil.setZusatz(oTeilPublDaten.getZusatz());
                    if (oTeil.equals(oTeilOld)) continue;
                    oTeil.setMustSave(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doKonfigurationAbgleich(Konfiguration oKonfiguration, Collection<Teil> cTeile) throws SQLException, DatabaseBusyException {
        if (cTeile == null) {
            return;
        }
        String sAtSt = oKonfiguration.getMWStSatzAltteile();
        double dAtSt = 0.0;
        if (sAtSt != null) {
            try {
                dAtSt = Double.parseDouble(sAtSt);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Iterator<Teil> iter = cTeile.iterator();
        Teil oTeil = null;
        while (iter.hasNext()) {
            oTeil = iter.next();
            Teil oTeilOld = new Teil(oTeil);
            if (oTeil.getMwStDouble() == null || oTeil.getMwStDouble() == 0.0) {
                String sMwStCode = oTeil.getMwstCode();
                String sMwSt = null;
                sMwSt = sMwStCode != null ? (sMwStCode.equals("2") ? oKonfiguration.getMWStSatzHoch() : (sMwStCode.equals("3") ? oKonfiguration.getMWStSatzAltteile() : (sMwStCode.equals("4") ? oKonfiguration.getMWStSatz3() : (sMwStCode.equals("5") ? oKonfiguration.getMWStSatz4() : oKonfiguration.getMWStSatzNiedrig())))) : oKonfiguration.getMWStSatzHoch();
                double dMwSt = 0.0;
                if (sMwSt != null) {
                    try {
                        dMwSt = Double.parseDouble(sMwSt);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                oTeil.setMwSt(new Double(dMwSt));
            }
            if (oTeil.getAtSt() == 0.0) {
                oTeil.setAtSt(new Double(dAtSt));
            }
            if (oTeil.equals(oTeilOld)) continue;
            oTeil.setMustSave(true);
        }
    }

    protected void doDMSStammsatz(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering doDMSStammsatz");
        String sMarke = (String)transferableMap.getValue("marke");
        Collection cTeile = null;
        Teil oTeil2 = (Teil)transferableMap.getValue("teil");
        if (oTeil2 != null) {
            try {
                StringBuffer sbDmsMsgText = new StringBuffer();
                int nStatus = this.doDMSStammsatz(oTeil2, sMarke, sbDmsMsgText);
                String sDmsMsgText = sbDmsMsgText.toString();
                if (sDmsMsgText.equals("null")) {
                    sDmsMsgText = null;
                }
                transferableMap.setValue("msgtxt", sDmsMsgText);
                if (nStatus != 0) {
                    transferableMap.setValue("returncode", new Integer(nStatus));
                    throw new DMSException(Integer.toString(nStatus));
                }
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
            }
        } else {
            cTeile = (Collection)transferableMap.getValue("teile");
            if (cTeile == null || cTeile.size() < 1) {
                return;
            }
            Vector<String> aDmsMsgTexts = new Vector<String>();
            Vector<Integer> aDmsReturnCodes = new Vector<Integer>();
            for (Teil oTeil2 : cTeile) {
                try {
                    StringBuffer sbDmsMsgText = new StringBuffer();
                    int nStatus = this.doDMSStammsatz(oTeil2, sMarke, sbDmsMsgText);
                    aDmsReturnCodes.add(new Integer(nStatus));
                    String sDmsMsgText = sbDmsMsgText.toString();
                    if (sDmsMsgText.equals("null")) {
                        sDmsMsgText = null;
                    }
                    aDmsMsgTexts.add(sDmsMsgText);
                }
                catch (NoDataFoundException ex) {
                    aDmsMsgTexts.add(ex.getMessage());
                    aDmsReturnCodes.add(new Integer(-1));
                }
                catch (Exception ex) {
                    aDmsMsgTexts.add(ex.getMessage());
                    aDmsReturnCodes.add(new Integer(-1));
                    break;
                }
            }
            transferableMap.setValue("returncodesliste", aDmsReturnCodes);
            transferableMap.setValue("msgtxtlist", aDmsMsgTexts);
        }
    }

    private int doDMSStammsatz(Teil oTeil, String sMarke, StringBuffer sDmsMsgText) throws NoDataFoundException, SQLException, DatabaseBusyException, XmlParseException, XmlCommunicationException {
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        String sProduktklasse = oTeil.getProduktklasse();
        String sTeileart = oTeil.getTeileart();
        if (sProduktklasse == null) {
            throw new NoDataFoundException("Produktklasse");
        }
        if (sTeileart == null) {
            throw new NoDataFoundException("Teileart");
        }
        double dPreis = oTeil.getPreis();
        oTeil.loadPreisInfo(sFirma);
        oTeil.setPreis(dPreis);
        String sBenennung = oTeil.getBenennung();
        String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
        XmlDmsStammsatzanlage xmlReq = new XmlDmsStammsatzanlage();
        xmlReq.setInputParameters(sNutzerId, sFirma, sFiliale, oTeil.getTeilenummer(), sDMSMarke, sBenennung, oTeil.getPreis(), oTeil.getSonderpreis(), oTeil.getRabattSchluessel(), sProduktklasse, sTeileart, oTeil.getVVM(), oTeil.getLVM(), oTeil.getBVM(), oTeil.getHoheMwst());
        xmlReq.requestService();
        sDmsMsgText.append(xmlReq.getMeldungstext());
        int nStatus = xmlReq.getErgebnisCode();
        return nStatus;
    }

    protected void doDMSSendList(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering doDMSSendList");
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        Teileliste oTL = null;
        Vector<Teil> cTeile = null;
        String sArt = (String)transferableMap.getValue("art");
        String sListenID = (String)transferableMap.getValue("teilelisteid");
        boolean bErneutSenden = sArt.equals("resend");
        if (bErneutSenden) {
            try {
                String sSprache = this.sessionInfo.getAktuelleSprache();
                oTL = new Teileliste(sListenID, sNutzerId, sSprache, sFirma, sFiliale);
                this.ladeSendeinfo(oTL, sFirma, sFiliale, transferableMap);
                sArt = (String)transferableMap.getValue("art");
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
                return;
            }
        } else {
            oTL = (Teileliste)transferableMap.getValue("teileliste");
            if (oTL == null) {
                oTL = (Bestellliste)transferableMap.getValue("bestellliste");
            }
            if (oTL == null) {
                TrfTeileliste trfladeBestellliste = new TrfTeileliste(null);
                trfladeBestellliste.setValue("teilelisteid", sListenID);
                trfladeBestellliste.setValue("lock", Boolean.FALSE);
                trfladeBestellliste.setValue("forcelock", Boolean.FALSE);
                this.ladeBestellliste(trfladeBestellliste);
                oTL = (Teileliste)trfladeBestellliste.getValue("teileliste");
            }
            if ((cTeile = oTL.getTeile()).isEmpty()) {
                transferableMap.setError(new EmptyListException());
                return;
            }
        }
        String sAuftragsnummer = (String)transferableMap.getValue("auftragsnr");
        String sKundenNr = (String)transferableMap.getValue("kundennr");
        int nKundennummer = -1;
        if (sKundenNr != null && sKundenNr.length() > 0) {
            nKundennummer = Integer.parseInt(sKundenNr);
        }
        boolean bGreiferschein = false;
        String sGreiferschein = (String)transferableMap.getValue("greiferschein");
        if (sGreiferschein != null && sGreiferschein.equals("J")) {
            bGreiferschein = true;
        }
        String sFreitext = (String)transferableMap.getValue("freitext");
        String sPasswort = (String)transferableMap.getValue("pwd");
        boolean bRechnung = false;
        String sRechnung = (String)transferableMap.getValue("rechnung");
        if (sRechnung != null && sRechnung.equals("J")) {
            bRechnung = true;
        }
        boolean bLieferschein = false;
        String sLieferschein = (String)transferableMap.getValue("lieferschein");
        if (sLieferschein != null && sLieferschein.equals("J")) {
            bLieferschein = true;
        }
        String sSondersteuerung = (String)transferableMap.getValue("sondersteuerung");
        int nSondersteuerung = 0;
        if (sSondersteuerung != null && sSondersteuerung.length() > 0) {
            nSondersteuerung = Integer.parseInt(sSondersteuerung);
        }
        String sBar = (String)transferableMap.getValue("bar");
        double dBar = 0.0;
        if (sBar != null && sBar.length() > 0) {
            dBar = Double.parseDouble(sBar);
        }
        String sUnbar = (String)transferableMap.getValue("unbar");
        double dUnbar = 0.0;
        if (sUnbar != null && sUnbar.length() > 0) {
            dUnbar = Double.parseDouble(sUnbar);
        }
        int nMitarbeiternummer = -1;
        String sMitarbeiternummer = (String)transferableMap.getValue("bearbeiter");
        if (sMitarbeiternummer != null && sMitarbeiternummer.length() > 0) {
            nMitarbeiternummer = Integer.parseInt(sMitarbeiternummer);
        }
        oTL.setFiliale(sFiliale);
        try {
            int[] aRetCodes;
            boolean bSatzweise = this.ermittleSatzweiseAusKonfiguration();
            StringBuffer sDmsMstTxt = new StringBuffer();
            if (sArt.equals("Werkstattauftrag")) {
                aRetCodes = this.doDMSWerkstattauftrag(oTL, sNutzerId, sFirma, nMitarbeiternummer, sFreitext, sAuftragsnummer, bGreiferschein, bSatzweise, sDmsMstTxt);
            } else if (sArt.equals("Kostenvoranschlag")) {
                aRetCodes = this.doDMSKostenvoranschlag(oTL, sNutzerId, sFirma, nMitarbeiternummer, sFreitext, sAuftragsnummer, nKundennummer, bSatzweise, sDmsMstTxt);
            } else if (sArt.equals("Barverkauf")) {
                aRetCodes = this.doDMSBarverkauf(oTL, sNutzerId, sFirma, nMitarbeiternummer, sFreitext, sAuftragsnummer, nKundennummer, bGreiferschein, bRechnung, bLieferschein, sPasswort, nSondersteuerung, dBar, dUnbar, bSatzweise, sDmsMstTxt);
            } else if (sArt.equals("Eilauftrag")) {
                aRetCodes = this.doDMSEilauftrag(oTL, sNutzerId, sFirma, bSatzweise, sDmsMstTxt);
            } else if (sArt.equals("Normalauftrag")) {
                aRetCodes = this.doDMSNormalauftrag(oTL, sNutzerId, sFirma, bSatzweise, sDmsMstTxt);
            } else {
                this.log.error("Keine g\u00fcltige Listenart: " + sArt);
                throw new InvalidDataException("Keine g\u00fcltige Listenart: " + sArt);
            }
            if (!sDmsMstTxt.toString().equals("null")) {
                transferableMap.setValue("msgtxt", sDmsMstTxt.toString());
            }
            transferableMap.setValue("teileliste", oTL);
            transferableMap.setValue("bestellliste", oTL);
            transferableMap.setValue("returncodes", aRetCodes);
            for (int ii = 0; ii < aRetCodes.length; ++ii) {
                if (aRetCodes[ii] == 0) continue;
                throw new DMSException();
            }
        }
        catch (Exception ex) {
            boolean bBestellliste = oTL instanceof Bestellliste;
            if (!bBestellliste && !bErneutSenden && ex instanceof DMSException) {
                try {
                    String sArtDB = null;
                    if (sArt.equals("Barverkauf")) {
                        sArtDB = "B";
                    } else if (sArt.equals("Kostenvoranschlag")) {
                        sArtDB = "K";
                    } else if (sArt.equals("Werkstattauftrag")) {
                        sArtDB = "W";
                    }
                    oTL.sperre(sFirma, sArtDB, sAuftragsnummer, nKundennummer, nMitarbeiternummer, bGreiferschein, bRechnung, bLieferschein, sFreitext, sPasswort, nSondersteuerung, dBar, dUnbar);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            if (!(ex instanceof DMSException)) {
                transferableMap.setError(ex);
            }
            return;
        }
        if (bErneutSenden) {
            try {
                oTL.sperre(false, sFirma);
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
            }
        }
    }

    protected boolean ermittleSatzweiseAusKonfiguration() throws SQLException, DatabaseBusyException {
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        Konfiguration oKonfiguration = null;
        oKonfiguration = new Konfiguration(sFirma, sFiliale);
        oKonfiguration.loadKonfiguration();
        return oKonfiguration.getAbwicklung().equals("S");
    }

    protected void doLadeSendeinfo(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering doLadeSendeinfo");
        String sNutzerId = (String)transferableMap.getValue("eigentuemer");
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = (String)transferableMap.getValue("filialid");
        String sListenID = (String)transferableMap.getValue("teilelisteid");
        try {
            String sSprache = this.sessionInfo.getAktuelleSprache();
            Teileliste oTL = new Teileliste(sListenID, sNutzerId, sSprache, sFirma, sFiliale);
            this.ladeSendeinfo(oTL, sFirma, sFiliale, transferableMap);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    protected void ladeSendeinfo(Teileliste oTL, String sFirma, String sFiliale, TrfTeileliste transferableMap) throws SQLException, DatabaseBusyException {
        oTL.setFiliale(sFiliale);
        Hashtable<String, String> oHashTable = oTL.loadSendeinfo(sFirma);
        if (oHashTable != null) {
            String sArtDB = oHashTable.get("Satzart");
            String sArt = null;
            if (sArtDB.equals("B")) {
                sArt = "Barverkauf";
            } else if (sArtDB.equals("K")) {
                sArt = "Kostenvoranschlag";
            } else if (sArtDB.equals("W")) {
                sArt = "Werkstattauftrag";
            }
            transferableMap.setValue("art", sArt);
            transferableMap.setValue("auftragsnr", oHashTable.get("AuftragsNr"));
            transferableMap.setValue("kundennr", oHashTable.get("KundenNr"));
            transferableMap.setValue("bearbeiter", oHashTable.get("MitarbeiterNr"));
            transferableMap.setValue("greiferschein", oHashTable.get("Greiferschein"));
            transferableMap.setValue("rechnung", oHashTable.get("Rechnung"));
            transferableMap.setValue("lieferschein", oHashTable.get("Lieferschein"));
            transferableMap.setValue("freitext", oHashTable.get("Freitext"));
            transferableMap.setValue("pwd", oHashTable.get("Passwort"));
            transferableMap.setValue("sondersteuerung", oHashTable.get("Sondersteuerung"));
            transferableMap.setValue("bar", oHashTable.get("Bar"));
            transferableMap.setValue("unbar", oHashTable.get("Unbar"));
        }
    }

    protected int[] doDMSWerkstattauftrag(Teileliste oTL, String sNutzerId, String sFirma, int nMitarbeiternummer, String sFreitext, String sAuftragsnummer, boolean bGreiferschein, boolean bSatzweise, StringBuffer sDmsMstTxt) throws XmlCommunicationException, XmlParseException, SQLException, DatabaseBusyException, NoDataFoundException {
        Vector<Teil> cTeile = oTL.getTeile();
        XmlDmsWerkstattAuftrag xmlReq = new XmlDmsWerkstattAuftrag();
        xmlReq.setInputParameters(sNutzerId, sFirma, oTL.getFiliale(), nMitarbeiternummer, sFreitext, sAuftragsnummer, bGreiferschein);
        for (Teil oTeil : cTeile) {
            XmlDmsBestellPositionKomplett pos = this.erzeugeDMSListenPos(oTeil, oTL.getMarke());
            xmlReq.addPosition(pos);
        }
        xmlReq.requestService();
        return this.checkResultDMSSendList(xmlReq, oTL, sFirma, bSatzweise, sDmsMstTxt);
    }

    protected int[] checkResultDMSSendList(XmlDmsCommand xmlReq, Teileliste oTL, String sFirma, boolean bSatzweise, StringBuffer sDmsMsgTxt) throws XmlCommunicationException, XmlParseException, SQLException, DatabaseBusyException {
        int nStatus;
        Vector<Teil> cTeile = oTL.getTeile();
        int[] aRet = null;
        boolean bBestellliste = oTL instanceof Bestellliste;
        sDmsMsgTxt.append(xmlReq.getMeldungstext());
        boolean bFehler = false;
        Vector<Teil> cTeileToRemove = new Vector<Teil>();
        if (!bSatzweise) {
            nStatus = xmlReq.getErgebnisCode();
            aRet = new int[]{nStatus};
            if (nStatus != 0) {
                bFehler = true;
                if (!bBestellliste) {
                    oTL.sperre(true, sFirma);
                }
                return aRet;
            }
            for (Teil oTeil : cTeile) {
                cTeileToRemove.add(oTeil);
            }
        } else {
            aRet = new int[cTeile.size()];
            nStatus = 0;
            Iterator iter = cTeile.iterator();
            int nCount = 0;
            if (xmlReq instanceof XmlDmsWerkstattAuftrag) {
                nCount = ((XmlDmsWerkstattAuftrag)xmlReq).getErgebnisCount();
            } else if (xmlReq instanceof XmlDmsKostenvoranschlag) {
                nCount = ((XmlDmsKostenvoranschlag)xmlReq).getErgebnisCount();
            } else if (xmlReq instanceof XmlDmsBarverkauf) {
                nCount = ((XmlDmsBarverkauf)xmlReq).getErgebnisCount();
            } else if (xmlReq instanceof XmlDmsEilauftrag) {
                nCount = ((XmlDmsEilauftrag)xmlReq).getErgebnisCount();
            } else if (xmlReq instanceof XmlDmsNeuteileAuftrag) {
                nCount = ((XmlDmsNeuteileAuftrag)xmlReq).getErgebnisCount();
            }
            for (int ii = 0; ii < nCount; ++ii) {
                Teil oTeil = (Teil)iter.next();
                if (xmlReq instanceof XmlDmsWerkstattAuftrag) {
                    nStatus = ((XmlDmsWerkstattAuftrag)xmlReq).getErgebnisCode(ii);
                } else if (xmlReq instanceof XmlDmsKostenvoranschlag) {
                    nStatus = ((XmlDmsKostenvoranschlag)xmlReq).getErgebnisCode(ii);
                } else if (xmlReq instanceof XmlDmsBarverkauf) {
                    nStatus = ((XmlDmsBarverkauf)xmlReq).getErgebnisCode(ii);
                } else if (xmlReq instanceof XmlDmsEilauftrag) {
                    nStatus = ((XmlDmsEilauftrag)xmlReq).getErgebnisCode(ii);
                } else if (xmlReq instanceof XmlDmsNeuteileAuftrag) {
                    nStatus = ((XmlDmsNeuteileAuftrag)xmlReq).getErgebnisCode(ii);
                }
                aRet[ii] = nStatus;
                if (nStatus != 0) {
                    bFehler = true;
                    if (!GlobalObjects.getInstance().getCodeFuehrtZumAbbruch(nStatus)) continue;
                    if (bBestellliste) break;
                    oTL.sperre(true, sFirma);
                    break;
                }
                cTeileToRemove.add(oTeil);
            }
        }
        if (!bFehler) {
            cTeile.clear();
            if (bBestellliste) {
                Bestellliste oBL = (Bestellliste)oTL;
                oBL.deleteAllParts(sFirma);
            }
        } else {
            cTeile.removeAll(cTeileToRemove);
            oTL.deleteParts(cTeileToRemove, sFirma);
            if (!bBestellliste) {
                oTL.sperre(true, sFirma);
            }
        }
        return aRet;
    }

    protected int[] doDMSKostenvoranschlag(Teileliste oTL, String sNutzerId, String sFirma, int nMitarbeiternummer, String sFreitext, String sAuftragsnummer, int nKundennummer, boolean bSatzweise, StringBuffer sDmsMsgTxt) throws XmlCommunicationException, XmlParseException, SQLException, DatabaseBusyException, NoDataFoundException {
        Vector<Teil> cTeile = oTL.getTeile();
        XmlDmsKostenvoranschlag xmlReq = new XmlDmsKostenvoranschlag();
        xmlReq.setInputParameters(sNutzerId, sFirma, oTL.getFiliale(), nMitarbeiternummer, sFreitext, sAuftragsnummer, nKundennummer);
        for (Teil oTeil : cTeile) {
            XmlDmsBestellPositionKomplett pos = this.erzeugeDMSListenPos(oTeil, oTL.getMarke());
            xmlReq.addPosition(pos);
        }
        xmlReq.requestService();
        return this.checkResultDMSSendList(xmlReq, oTL, sFirma, bSatzweise, sDmsMsgTxt);
    }

    protected int[] doDMSBarverkauf(Teileliste oTL, String sNutzerId, String sFirma, int nMitarbeiternummer, String sFreitext, String sAuftragsnummer, int nKundennummer, boolean bGreiferschein, boolean bRechnung, boolean bLieferschein, String sPasswort, int nSondersteuerung, double dBar, double dUnbar, boolean bSatzweise, StringBuffer sDmsMsgTxt) throws XmlCommunicationException, XmlParseException, SQLException, DatabaseBusyException, NoDataFoundException {
        Vector<Teil> cTeile = oTL.getTeile();
        XmlDmsBarverkauf xmlReq = new XmlDmsBarverkauf();
        xmlReq.setInputParameters(sNutzerId, sFirma, oTL.getFiliale(), nMitarbeiternummer, sFreitext, sAuftragsnummer, nKundennummer, sPasswort, bRechnung, bGreiferschein, bLieferschein, nSondersteuerung, dBar, dUnbar);
        for (Teil oTeil : cTeile) {
            XmlDmsBestellPositionKomplett pos = this.erzeugeDMSListenPos(oTeil, oTL.getMarke());
            xmlReq.addPosition(pos);
        }
        xmlReq.requestService();
        return this.checkResultDMSSendList(xmlReq, oTL, sFirma, bSatzweise, sDmsMsgTxt);
    }

    protected int[] doDMSEilauftrag(Teileliste oTL, String sNutzerId, String sFirma, boolean bSatzweise, StringBuffer sDmsMsgTxt) throws XmlCommunicationException, XmlParseException, SQLException, DatabaseBusyException {
        Vector<Teil> cTeile = oTL.getTeile();
        XmlDmsEilauftrag xmlReq = new XmlDmsEilauftrag();
        xmlReq.setInputParameters(sNutzerId, sFirma, oTL.getFiliale());
        String sMarkeUser = this.sessionInfo.getUserInfo().getMarke();
        String sMarkeFirst = null;
        for (Teil oTeil : cTeile) {
            String sBenennung = oTeil.getBenennung();
            Vector<String> aMarkenTeil = oTeil.getMarken();
            String sMarke = null;
            if (aMarkenTeil != null && aMarkenTeil.size() == 1) {
                sMarke = (String)aMarkenTeil.toArray()[0];
            }
            if (sMarke == null || sMarke.trim().equals("")) {
                sMarke = sMarkeFirst != null ? sMarkeFirst : sMarkeUser;
            }
            if (sMarkeFirst == null) {
                sMarkeFirst = sMarke;
            }
            String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
            int nKundennummer = 0;
            if (oTeil.getKundennummer() != null) {
                nKundennummer = oTeil.getKundennummer().intValue();
            }
            XmlDmsBestellPositionErweitert pos = new XmlDmsBestellPositionErweitert(oTeil.getTeilenummer(), sDMSMarke, sBenennung, oTeil.getMengeDouble(), oTeil.getAuftragsnummer(), nKundennummer, oTeil.getBemerkung());
            xmlReq.addPosition(pos);
        }
        xmlReq.requestService();
        return this.checkResultDMSSendList(xmlReq, oTL, sFirma, bSatzweise, sDmsMsgTxt);
    }

    protected int[] doDMSNormalauftrag(Teileliste oTL, String sNutzerId, String sFirma, boolean bSatzweise, StringBuffer sDmsMsgTxt) throws XmlCommunicationException, XmlParseException, SQLException, DatabaseBusyException {
        Vector<Teil> cTeile = oTL.getTeile();
        XmlDmsNeuteileAuftrag xmlReq = new XmlDmsNeuteileAuftrag();
        xmlReq.setInputParameters(sNutzerId, sFirma, oTL.getFiliale());
        String sMarkeUser = this.sessionInfo.getUserInfo().getMarke();
        String sMarkeFirst = null;
        for (Teil oTeil : cTeile) {
            String sBenennung = oTeil.getBenennung();
            Vector<String> aMarkenTeil = oTeil.getMarken();
            String sMarke = null;
            if (aMarkenTeil != null && aMarkenTeil.size() == 1) {
                sMarke = (String)aMarkenTeil.toArray()[0];
            }
            if (sMarke == null || sMarke.trim().equals("")) {
                sMarke = sMarkeFirst != null ? sMarkeFirst : sMarkeUser;
            }
            if (sMarkeFirst == null) {
                sMarkeFirst = sMarke;
            }
            String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
            XmlDmsBestellPosition pos = new XmlDmsBestellPosition(oTeil.getTeilenummer(), sDMSMarke, sBenennung, oTeil.getMengeDouble());
            xmlReq.addPosition(pos);
        }
        xmlReq.requestService();
        return this.checkResultDMSSendList(xmlReq, oTL, sFirma, bSatzweise, sDmsMsgTxt);
    }

    protected XmlDmsBestellPositionKomplett erzeugeDMSListenPos(Teil oTeil, String sMarkeTL) throws NoDataFoundException, SQLException, DatabaseBusyException {
        String sTeileart;
        String sProduktklasse = oTeil.getProduktklasse();
        if (sProduktklasse != null && sProduktklasse.length() < 1) {
            sProduktklasse = null;
        }
        if ((sTeileart = oTeil.getTeileart()) != null && sTeileart.length() < 1) {
            sTeileart = null;
        }
        int nSuffix = 0;
        if (oTeil.getSuffix() != null && !oTeil.getSuffix().trim().equals("")) {
            nSuffix = Integer.parseInt(oTeil.getSuffix());
        }
        int nSplitt = -1;
        if (oTeil.getSplitt() != null && !oTeil.getSplitt().equals("")) {
            nSplitt = Integer.parseInt(oTeil.getSplitt());
        }
        String sBenennung = oTeil.getBenennung();
        double dPreis = oTeil.getPreis();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        oTeil.loadPreisInfo(sFirma);
        double dDateipreis = oTeil.getPreis();
        oTeil.setPreis(dPreis);
        String sRabatt = oTeil.getRabattString();
        if (sRabatt != null && sRabatt.length() > 0 && !sRabatt.startsWith("+")) {
            sRabatt = "-" + sRabatt;
        }
        Vector<String> aMarkenTeil = oTeil.getMarken();
        String sMarke = null;
        if (aMarkenTeil != null && aMarkenTeil.size() == 1) {
            sMarke = (String)aMarkenTeil.toArray()[0];
        }
        if (sMarke == null || sMarke.trim().equals("")) {
            sMarke = sMarkeTL;
        }
        String sDMSMarke = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", sMarke, "marke.DMSSchnittstelle", null);
        XmlDmsBestellPositionKomplett pos = new XmlDmsBestellPositionKomplett(oTeil.getTeilenummer(), sDMSMarke, sBenennung, oTeil.getMengeDouble(), oTeil.getPreis(), dDateipreis, sRabatt, oTeil.getRabattSchluessel(), nSuffix, nSplitt, sProduktklasse, sTeileart, oTeil.getSonderpreis(), oTeil.getTransparenz(), oTeil.getBemerkung());
        return pos;
    }

    protected void incrementRechungsnummer(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering incrementRechungsnummer");
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        try {
            long lRechungsnummer = Konfiguration.incrementRechungsnummer(sFirma, sFiliale);
            String sRechungsnummer = Long.toString(lRechungsnummer);
            transferableMap.setValue("rechnungsnummer", sRechungsnummer);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    protected void doSendMailOperation(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering doSendMailOperation");
        String sAnEMail = (String)transferableMap.getValue("anemail");
        String sVonName = (String)transferableMap.getValue("vonname");
        String sVonEMail = (String)transferableMap.getValue("vonemail");
        String sBetreff = (String)transferableMap.getValue("betreff");
        String sFreitext = (String)transferableMap.getValue("freitext");
        Teileliste objTeileliste = (Teileliste)transferableMap.getValue("teileliste");
        boolean bMitPreis = false;
        String sMitPreis = (String)transferableMap.getValue("mit_preisen");
        if (sMitPreis != null && sMitPreis.equals("J")) {
            bMitPreis = true;
        }
        try {
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            Konfiguration oKonfiguration = new Konfiguration(sFirma, sFiliale);
            oKonfiguration.loadKonfiguration();
            String sMailHost = oKonfiguration.getMailserver();
            String sAttachementDaten = null;
            String sAttachementName = null;
            byte[] outBytes = null;
            String sImgName = "";
            ServerGlobalObjects objGlobal = ServerGlobalObjects.getInstance();
            if (objTeileliste != null) {
                sAttachementDaten = objTeileliste.formatiereDaten(bMitPreis);
                sAttachementName = objGlobal.getMailAttachmentNamePartslist();
            } else {
                Vector<String> cZeilenId = new Vector<String>();
                SucheInfo oSucheInfo = this.sessionInfo.getSucheInfo();
                CurrentBTE currentBte = this.sessionInfo.getBTEManager().getCurrentBTE();
                DruckansichtObject oDA = (DruckansichtObject)currentBte.makeSnapshot("Druck", cZeilenId, oSucheInfo);
                oDA.setFzgSucheInfo(this.sessionInfo.getFzgSucheInfo());
                oDA.setCurrentBTE(currentBte);
                HashMap mapBen = (HashMap)transferableMap.getValue("benennung");
                sAttachementName = currentBte.getBTENr() + ".html";
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    String sFormat = ImageCache.requestImageAsByteArray(baos, currentBte.getBildIdAsString(), "T");
                    outBytes = baos.toByteArray();
                    sImgName = currentBte.getBTENr() + "." + sFormat;
                }
                catch (Exception ex) {
                    this.log.error("Error: ", ex);
                }
                sAttachementDaten = oDA.getHTML(mapBen, sImgName);
            }
            this.sendeMail(sMailHost, sAttachementDaten, sAttachementName, outBytes, sImgName, sAnEMail, sVonName, sVonEMail, sBetreff, sFreitext);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            ex.printStackTrace(System.out);
        }
    }

    protected void sendeMail(String sMailHost, String sAttachmentdaten, String sAttachmentName, byte[] imgDaten, String sImgName, String sAnEMail, String sVonName, String sVonEMail, String sBetreff, String sFreitext) throws MessagingException {
        Logger.getLogger(Teileliste.class).debug("Sending mail");
        Properties props = System.getProperties();
        props.put("mail.smtp.host", sMailHost);
        Logger.getLogger(Teileliste.class).debug("MailHost: " + sMailHost);
        Session objSession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(objSession);
        Logger.getLogger(Teileliste.class).debug("created MimeMessage");
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)sAnEMail));
        if (sVonEMail.length() > 0) {
            msg.setFrom((Address)new InternetAddress(sVonEMail));
        }
        msg.setSubject(sBetreff);
        msg.setSentDate(new Date());
        MimeBodyPart mbp1 = new MimeBodyPart();
        String sMailText = sVonName + "\r\n";
        sMailText = sMailText + sFreitext;
        mbp1.setText(sMailText);
        MimeBodyPart mbp2 = null;
        MimeBodyPart mbp3 = null;
        if (imgDaten == null) {
            mbp2 = new MimeBodyPart();
            mbp2.setDisposition("attachment");
            mbp2.setFileName(sAttachmentName);
            mbp2.setText(sAttachmentdaten);
        } else {
            mbp2 = new MimeBodyPart();
            mbp2.setDisposition("attachment");
            mbp2.setFileName(sImgName);
            ByteArrayDataSource ds = new ByteArrayDataSource(imgDaten);
            mbp2.setDataHandler(new DataHandler((DataSource)ds));
            mbp3 = new MimeBodyPart();
            mbp3.setDisposition("attachment");
            mbp3.setFileName(sAttachmentName);
            mbp3.setText(sAttachmentdaten);
        }
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        mp.addBodyPart((BodyPart)mbp2);
        if (mbp3 != null) {
            mp.addBodyPart((BodyPart)mbp3);
        }
        msg.setContent((Multipart)mp);
        Logger.getLogger(Teileliste.class).debug("sending mail");
        Transport.send((Message)msg);
    }

    protected void saveAuftrag(TrfTeileliste transferableMap) {
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Entering saveAuftrag");
        String sFirmaId = this.sessionInfo.getUserInfo().getFirmaID();
        String sFilialeId = this.sessionInfo.getUserInfo().getFilialeID();
        String sAuftragsnummer = (String)transferableMap.getValue("auftragsnr");
        String sKundennummer = (String)transferableMap.getValue("kundennr");
        Long lKundennummer = null;
        if (sKundennummer != null && sKundennummer.length() > 0) {
            lKundennummer = Long.valueOf(sKundennummer);
        }
        String sKundenname = (String)transferableMap.getValue("kundenname");
        String sFahrgestellnummer = (String)transferableMap.getValue("fgstnr");
        String sModus = (String)transferableMap.getValue("modus");
        boolean bInsert = sModus == null || !sModus.equals("update");
        Auftrag oAuftrag = null;
        try {
            oAuftrag = new Auftrag(sFirmaId, sFilialeId, sAuftragsnummer, lKundennummer, sKundenname, sFahrgestellnummer);
            oAuftrag.save(bInsert);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
        transferableMap.setValue("auftrag", oAuftrag);
    }

    protected void checkKannTeileUebernehmen(TrfTeileliste transferableMap) {
        String sNutzerId = this.sessionInfo.getUserInfo().getID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        Teileliste objTeileliste = (Teileliste)transferableMap.getValue("teileliste");
        boolean bErgebnis = false;
        try {
            bErgebnis = objTeileliste.checkKannTeileUebernehmen(sFirma, sFiliale, sNutzerId);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
        transferableMap.setValue("teileliste", objTeileliste);
        transferableMap.setValue("boolean", bErgebnis);
    }

    protected void getNextTeilelistenId(TrfTeileliste transferableMap) {
        try {
            long lId = Teileliste.getNextTeilelistenId();
            transferableMap.setValue("teilelisteid", Long.toString(lId));
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    protected void copyTeileliste(TrfTeileliste transferableMap) {
        String sNewNutzerID = this.sessionInfo.getUserInfo().getID();
        String sNewFiliale = this.sessionInfo.getUserInfo().getFilialeID();
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sOldID = (String)transferableMap.getValue("teilelisteid");
        String sNewID = (String)transferableMap.getValue("teilelistenewid");
        String sOldNutzerID = (String)transferableMap.getValue("eigentuemer");
        String sOldFiliale = (String)transferableMap.getValue("filialid_alt");
        try {
            Teileliste.copyTeilelisteInDb(sNewID, sOldID, sNewNutzerID, sOldNutzerID, sFirma, sNewFiliale, sOldFiliale);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        Logger.getLogger(TrfTeilelisteCommand.class).debug("Teileliste von " + sOldID + " nach " + sNewID + " kopiert");
    }

    protected void loadBearbeiterNr(TrfTeileliste transferableMap) {
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        String sID = this.sessionInfo.getUserInfo().getID();
        try {
            Integer nBearbeiterNr = Nutzer.loadBearbeiterNr(sFirma, sID);
            transferableMap.setValue("bearbeiter_nummer", nBearbeiterNr);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    protected void insertScoreListe(TrfTeileliste transferableMap) {
        String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
        Scoreliste oSl = (Scoreliste)transferableMap.getValue("scoreliste");
        try {
            Calendar rightNow = Calendar.getInstance();
            Date datToday = rightNow.getTime();
            oSl.setDatErstellung(datToday);
            oSl.setDatAenderung(datToday);
            oSl.save(true, sFirma);
        }
        catch (Exception e) {
            this.log.debug("ScoreListe konnte nicht gespeichert werden" + e.getMessage());
            transferableMap.setError(e);
            return;
        }
        transferableMap.setValue("id", oSl.getID());
    }

    protected void sendeSap(TrfTeileliste transferableMap) {
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.SAP_SENDE);
        }
        catch (CommunicationException ex) {
            this.log.error("Communication to WebETK: " + ex.getMessage());
            transferableMap.setError(ex);
            return;
        }
        Teileliste oTL = (Teileliste)transferableMap.getValue("teileliste");
        try {
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            oTL.saveSapAbfrage(sFirma);
        }
        catch (Exception ex) {
            this.log.error("SAP Abfragedaten konnten nicht gespeichert werden: " + ex.getMessage());
            transferableMap.setError(ex);
            return;
        }
        transferableMap.setValue("teileliste", oTL);
    }

    private void saveKopfdatenRr(TrfTeileliste transferableMap) {
        Teileliste oTL = (Teileliste)transferableMap.getValue("teileliste");
        try {
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            oTL.saveKopfdatenRr(sFirma);
        }
        catch (Exception ex) {
            this.log.error("Kopfdaten konnten nicht gespeichert werden: " + ex.getMessage());
            transferableMap.setError(ex);
        }
    }

    protected void holeAntwortSap(TrfTeileliste transferableMap) {
        try {
            BmwNetz oBmwNetz = GlobalObjects.getInstance().getCentralServerSettings();
            String sCentralServerUrl = oBmwNetz.getCentralServerUrl();
            if (sCentralServerUrl == null || sCentralServerUrl.length() < 1) {
                return;
            }
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
            return;
        }
        Teileliste oTL = (Teileliste)transferableMap.getValue("teileliste");
        String alterStatus = oTL.getSapStatus();
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.SAP_HOLE_ANTWORT);
        }
        catch (CommunicationException ex) {
            transferableMap.setError(ex);
            return;
        }
        oTL = (Teileliste)transferableMap.getValue("teileliste");
        if (oTL.getSapStatus().equals("N") && !alterStatus.equals("E")) {
            try {
                String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
                boolean bNeuanlage = false;
                if (oTL.getSapArt().equals("A")) {
                    oTL.setSapStatus("N");
                } else {
                    oTL.setSapStatus("E");
                }
                oTL.saveKopfdaten(bNeuanlage, sFirma);
                String sFunktion = null;
                sFunktion = oTL.getSapArt().equals("A") ? "ANFRAGE_BEANTWORTET" : "BESTELLUNG_BESTAETIGT";
                oTL.writeHistorie(sFunktion, sFirma);
                transferableMap.setValue("teileliste", oTL);
            }
            catch (Exception ex) {
                this.log.error("Datenbankfehler: " + ex.getMessage());
                transferableMap.setError(ex);
            }
        }
    }

    protected void stornoSap(TrfTeileliste transferableMap) {
        Teileliste oTL = (Teileliste)transferableMap.getValue("teileliste");
        try {
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            oTL.setSapStatus("N");
            boolean bNeuanlage = false;
            oTL.saveKopfdaten(bNeuanlage, sFirma);
            String sFunktion = "ANFRAGE_STORNIERT";
            oTL.writeHistorie(sFunktion, sFirma);
        }
        catch (Exception ex) {
            this.log.error("Datenbankfehler: " + ex.getMessage());
            transferableMap.setError(ex);
            return;
        }
        transferableMap.setValue("teileliste", oTL);
    }

    protected void insertRrSapListe(TrfTeileliste transferableMap) {
        String sName = (String)transferableMap.getValue("teilelisteid");
        try {
            Teileliste oTL = TrfTeilelisteCommand.createRrSapListe(this.sessionInfo, sName);
            transferableMap.setValue("teileliste", oTL);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    public static Teileliste createRrSapListe(SessionInfo sessionInfo, String sHaendlerNr) throws DatabaseBusyException, SQLException {
        String sNutzerId = sessionInfo.getUserInfo().getID();
        String sFirma = sessionInfo.getUserInfo().getFirmaID();
        String sFiliale = sessionInfo.getUserInfo().getFilialeID();
        String sSprache = sessionInfo.getAktuelleSprache();
        return Teileliste.insertRrListe(sNutzerId, sFirma, sFiliale, sHaendlerNr, sSprache);
    }

    protected void renameDefaultRrSapListe(TrfTeileliste transferableMap) {
        try {
            String sNutzerId = this.sessionInfo.getUserInfo().getID();
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            String sName = (String)transferableMap.getValue("teilelisteid");
            String newID = Teileliste.renameDefaultRrSapListe(sNutzerId, sFirma, sFiliale, sName);
            transferableMap.setValue("teilelistenewid", newID);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    private static class IntWrapper {
        private int mnValue;

        public IntWrapper(int nValue) {
            this.mnValue = nValue;
        }

        public int getValue() {
            return this.mnValue;
        }

        public void setValue(int nValue) {
            this.mnValue = nValue;
        }
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private byte[] b;

        public ByteArrayDataSource(byte[] b) {
            this.b = b;
        }

        public InputStream getInputStream() {
            ByteArrayInputStream b1 = new ByteArrayInputStream(this.b);
            return b1;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public String getName() {
            return "";
        }
    }
}

