/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.NoDataFoundException;
import webetk.app.SearchBTETeile;
import webetk.app.SessionInfoDez;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.asssuche.BenennungSuche;
import webetk.app.asssuche.HGFGSuche;
import webetk.app.basesuche.BaseHgFgSuche;
import webetk.app.basesuche.FremdeTNrSuche;
import webetk.app.basesuche.SachnummernSuche;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgsuche.BegriffSuche;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.fzgsuche.TeileSuche;
import webetk.app.fzgsuchespezifischvalueline.ValuelineSuche;
import webetk.app.teilevwdgben.BTESuche;
import webetk.app.teilevwdgben.TVBenennungSuche;
import webetk.communication.CommunicationException;
import webetk.communication.JavaAssSucheInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfTeilesuche;
import webetk.javaserver.app.GlobalObjects;

public class TrfTeilesucheCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfTeilesucheCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfTeilesuche)) {
            this.log.error("Given transferable must be TrfTeilesuche, but it isn't!");
            throw new ClassCastException("TrfTeilesuche excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfTeilesuche transferableMap = (TrfTeilesuche)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.NO_OPERATION.equals(command)) {
            return;
        }
        if (Command.PERFORM_TEILESUCHE.equals(command)) {
            this.performSearch(transferableMap);
            return;
        }
        if (Command.SEARCH_HG_AT_INDEX.equals(command)) {
            this.performHGSearchAtIndex(transferableMap);
            return;
        }
        if (Command.LOAD_TEILEVERWENDUNGBEN.equals(command)) {
            this.performTVBenSearch(transferableMap);
            return;
        }
        if (Command.LOAD_ERWEITERTE_VALUE_LINE_BTES.equals(command)) {
            this.ladeErweiterteValueLineBtes(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void ladeErweiterteValueLineBtes(TrfTeilesuche transferable) {
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIstFzg = (String)transferable.getValue("isfzg");
        boolean bIstFzg = sIstFzg != null && !sIstFzg.equals("false");
        FzgSucheInfo oSucheInfo = new FzgSucheInfo();
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        String sFahrgestellnummer = null;
        String sRegion = null;
        long lModellspalte = 0L;
        if (bIstFzg && this.sessionInfo.getFzgIdInfo() != null) {
            FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
            sMarke = oFzgIdInfo.getMarke();
            sProduktart = oFzgIdInfo.getProduktart();
            sKatalogumfang = oFzgIdInfo.getKatalogumfang();
            sFahrgestellnummer = oFzgIdInfo.getFahrgestellNr();
            sRegion = oFzgIdInfo.getRegion();
            lModellspalte = oFzgIdInfo.getModellspalte();
        }
        oSucheInfo.setMarke(sMarke);
        oSucheInfo.setProduktart(sProduktart);
        sKatalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        oSucheInfo.setKatalogumfang(sKatalogumfang);
        oSucheInfo.setFahrgestellnummer(sFahrgestellnummer);
        oSucheInfo.setRegion(sRegion);
        oSucheInfo.setModellspalte(lModellspalte);
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("sprache", sLang);
                transferable.setValue("sucheinfo", oSucheInfo);
                SessionInfoDez oSessionInfoDez = new SessionInfoDez();
                oSessionInfoDez.setMbAusweisungenElementeAktiv(this.sessionInfo.isAusweisungenElementeAktiv());
                oSessionInfoDez.setMbNachruestungenRelevant(this.sessionInfo.getUserInfo().getNachruestungenRelevant());
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    oSessionInfoDez.setMoBedingungswerte_BTE(this.sessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE());
                } else {
                    oSessionInfoDez.setMoBedingungswerte_BTE(null);
                }
                transferable.setValue("sesseionInfoDez", oSessionInfoDez);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.LOAD_ERWEITERTE_VALUE_LINE_BTES);
                transferable.setValue("bildtafeln", transferable.getValue("bildtafeln"));
                transferable.setValue("ergebnis", transferable.getValue("ergebnis"));
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
            }
        } else {
            try {
                ValuelineSuche oSuche = new ValuelineSuche();
                int nErgebnis = ((SearchBTETeile)oSuche).performSearch(oSucheInfo, sLang, this.sessionInfo);
                if (nErgebnis == 1) {
                    transferable.setValue("bildtafeln", oSuche.getBTEs());
                } else {
                    transferable.setValue("bildtafeln", null);
                }
                transferable.setValue("ergebnis", Integer.toString(nErgebnis));
            }
            catch (Exception e) {
                transferable.setError(e);
            }
        }
    }

    protected void performSearch(TrfTeilesuche transferable) {
        this.log.info("EtkJavaServer: performSearch()");
        this.sessionInfo.setSachnummerSuch(null);
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIsFzg = (String)transferable.getValue("isfzg");
        boolean bIsFzg = sIsFzg != null && sIsFzg.equals("true");
        String sModus = (String)transferable.getValue("modus");
        String sDirekt = (String)transferable.getValue("direkt");
        boolean bDirekt = sDirekt != null && sDirekt.equals("true");
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        SucheInfo oSucheInfo = null;
        if (bIsFzg) {
            if (this.sessionInfo.getFzgIdInfo() != null) {
                FzgIdInfo oFzgIdInfo = this.sessionInfo.getFzgIdInfo();
                oSucheInfo = this.sessionInfo.getFzgSucheInfo();
                sMarke = oFzgIdInfo.getMarke();
                sProduktart = oFzgIdInfo.getProduktart();
                sKatalogumfang = oFzgIdInfo.getKatalogumfang();
            }
        } else {
            sMarke = (String)transferable.getValue("marke");
            sProduktart = (String)transferable.getValue("produktart");
            sKatalogumfang = (String)transferable.getValue("katalogumfang");
            oSucheInfo = this.sessionInfo.newAssSucheInfo();
            oSucheInfo.setMarke(sMarke);
            oSucheInfo.setProduktart(sProduktart);
            oSucheInfo.setKatalogumfang(sKatalogumfang);
        }
        this.log.info("oSucheInfo.getSuchHG(): " + oSucheInfo.getSuchHG());
        String sHgUg = null;
        String sSachnummer = null;
        String btNummer = (String)transferable.getValue("btnummer");
        String sBenennung = null;
        String sSuchbegriff = null;
        String sFremdeTeilenummer = null;
        Collection cSachnummern = null;
        Collection cHgFg = null;
        String sHgSel = null;
        if (sModus.equals("sucheteilenummer")) {
            this.log.info("Search Type: SUCHE_TEILENUMMER");
            sHgUg = (String)transferable.getValue("hgug");
            sHgUg = sHgUg == null || sHgUg.equals("") ? null : sHgUg;
            sSachnummer = (String)transferable.getValue("sachnummer");
        }
        if (sModus.equals("suchesachnummer") && (cSachnummern = (Collection)transferable.getValue("sachnummern")).size() == 1) {
            sSachnummer = (String)((ArrayList)cSachnummern).get(0);
        }
        if (sModus.equals("suchebenennung")) {
            sBenennung = (String)transferable.getValue("benennung");
        }
        if (sModus.equals("suchesuchbegriff")) {
            sSuchbegriff = (String)transferable.getValue("suchbegriff");
        }
        if (sModus.equals("suchefremdeteilenummer")) {
            sFremdeTeilenummer = (String)transferable.getValue("fremdeteilenummer");
        }
        if (sModus.equals("suchehgfg")) {
            cHgFg = (Collection)transferable.getValue("hgfg");
            sHgSel = (String)transferable.getValue("hg");
            this.log.info("sHgSel: " + sHgSel);
        }
        SearchBTETeile oSuche = null;
        try {
            if (bIsFzg) {
                if (sModus.equals("sucheteilenummer")) {
                    if (btNummer != null && !btNummer.isEmpty()) {
                        this.log.info("Suche mit BTNUmmer: " + btNummer);
                        oSuche = new SachnummernSuche();
                    } else {
                        oSuche = sHgUg != null ? new SachnummernSuche(sHgUg, sSachnummer) : new SachnummernSuche(sSachnummer);
                    }
                    this.sessionInfo.setSachnummerSuch(sSachnummer);
                }
                if (sModus.equals("suchesachnummer")) {
                    oSuche = new TeileSuche(cSachnummern);
                    this.sessionInfo.setSachnummerSuch(sSachnummer);
                }
                if (sModus.equals("suchebenennung")) {
                    oSuche = new webetk.app.fzgsuche.BenennungSuche(sBenennung);
                }
                if (sModus.equals("suchesuchbegriff")) {
                    oSuche = new BegriffSuche(sSuchbegriff);
                }
                if (sModus.equals("suchefremdeteilenummer")) {
                    oSuche = new FremdeTNrSuche(sFremdeTeilenummer);
                }
                if (sModus.equals("suchehgfg")) {
                    this.log.info("Suche nach HgFg");
                    oSuche = new webetk.app.fzgsuche.HGFGSuche(cHgFg, sHgSel, false, false, false, bDirekt, false);
                }
            } else {
                if (sModus.equals("sucheteilenummer")) {
                    if (btNummer != null && !btNummer.isEmpty()) {
                        this.log.info("Suche mit BTNUmmer: " + btNummer);
                        oSuche = new SachnummernSuche();
                    } else {
                        oSuche = sHgUg != null ? new SachnummernSuche(sHgUg, sSachnummer) : new SachnummernSuche(sSachnummer);
                    }
                    this.sessionInfo.setSachnummerSuch(sSachnummer);
                }
                if (sModus.equals("suchesachnummer")) {
                    oSuche = new webetk.app.asssuche.TeileSuche(cSachnummern);
                    this.sessionInfo.setSachnummerSuch(sSachnummer);
                }
                if (sModus.equals("suchebenennung")) {
                    oSuche = new BenennungSuche(sBenennung);
                }
                if (sModus.equals("suchesuchbegriff")) {
                    oSuche = new webetk.app.asssuche.BegriffSuche(sSuchbegriff);
                }
                if (sModus.equals("suchefremdeteilenummer")) {
                    oSuche = new FremdeTNrSuche(sFremdeTeilenummer);
                }
                if (sModus.equals("suchehgfg")) {
                    this.log.info("Suche nach HgFg / Sonstige Produkte");
                    oSuche = new HGFGSuche(cHgFg, sHgSel, new ArrayList<String>(), false, false, false, bDirekt, false);
                }
            }
        }
        catch (Exception e) {
            transferable.setError(e);
            return;
        }
        int nErgebnis = -1;
        if (bIsFzg) {
            oSuche.includeAccessoiresBildtafeln(true);
        }
        oSucheInfo.setBtNummer(btNummer);
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("searchbteteile", oSuche);
                transferable.setValue("sucheinfo", oSucheInfo);
                transferable.setValue("sprache", sLang);
                SessionInfoDez oSessionInfoDez = new SessionInfoDez();
                oSessionInfoDez.setMbAusweisungenElementeAktiv(this.sessionInfo.isAusweisungenElementeAktiv());
                oSessionInfoDez.setMbNachruestungenRelevant(this.sessionInfo.getUserInfo().getNachruestungenRelevant());
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    oSessionInfoDez.setMoBedingungswerte_BTE(this.sessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE());
                } else {
                    oSessionInfoDez.setMoBedingungswerte_BTE(null);
                }
                transferable.setValue("sesseionInfoDez", oSessionInfoDez);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.PERFORM_TEILESUCHE);
                if (sModus.equals("sucheteilenummer")) {
                    sSachnummer = (String)transferable.getValue("sachnummer");
                    this.sessionInfo.setSachnummerSuch(sSachnummer);
                }
                if (sModus.equals("suchefremdeteilenummer")) {
                    this.sessionInfo.setSachnummerSuch(oSucheInfo.getSuchSachnummer());
                }
                oSucheInfo = (SucheInfo)transferable.getValue("sucheinfo");
                oSuche = (SearchBTETeile)transferable.getValue("searchbteteile");
                transferable.setValue("searchbteteile", null);
                String sErgebnis = (String)transferable.getValue("ergebnis");
                nErgebnis = sErgebnis == null ? -1 : Integer.parseInt(sErgebnis);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
        }
        try {
            nErgebnis = oSuche.performSearch(oSucheInfo, sLang, this.sessionInfo);
        }
        catch (Exception e) {
            transferable.setError(e);
            return;
        }
        if (sModus.equals("suchefremdeteilenummer")) {
            this.sessionInfo.setSachnummerSuch(oSucheInfo.getSuchSachnummer());
        }
        transferable.setValue("bildtafeln", null);
        transferable.setValue("teilenummern", null);
        if (nErgebnis == 4) {
            BaseHgFgSuche oSucheHelp;
            int nAnzHGs;
            boolean bShowNoDataFoundMeldung = true;
            if (oSuche instanceof HGFGSuche && (nAnzHGs = ((HGFGSuche)(oSucheHelp = (HGFGSuche)oSuche)).getAnzHGs()) > 1) {
                bShowNoDataFoundMeldung = false;
            }
            if (oSuche instanceof webetk.app.fzgsuche.HGFGSuche && (nAnzHGs = ((webetk.app.fzgsuche.HGFGSuche)(oSucheHelp = (webetk.app.fzgsuche.HGFGSuche)oSuche)).getAnzHGs()) > 1) {
                bShowNoDataFoundMeldung = false;
            }
            if (bShowNoDataFoundMeldung) {
                transferable.setError(new NoDataFoundException("keine Daten gefunden"));
                return;
            }
        }
        transferable.setValue("bildtafeln", null);
        if (nErgebnis == 3 || nErgebnis == 1) {
            transferable.setValue("bildtafeln", oSuche.getBTEs());
        }
        if (nErgebnis == 3 || nErgebnis == 2) {
            transferable.setValue("teilenummern", oSuche.getTeile());
        }
        if (!bIsFzg) {
            AssSucheInfo oAssSucheInfoSrc = (AssSucheInfo)oSucheInfo;
            this.log.info("ServerSeitig: oAssSucheInfoSrc.getSuchHG" + oAssSucheInfoSrc.getSuchHG());
            JavaAssSucheInfo oAssSucheInfo = new JavaAssSucheInfo(oAssSucheInfoSrc);
            this.log.info("ServerSeitig: oAssSucheInfoSrc.getSuchHG" + oAssSucheInfoSrc.getSuchHG());
            transferable.setValue("asssucheinfo_java", oAssSucheInfo);
        } else {
            FzgSucheInfo oFzgSucheInfoSrc = (FzgSucheInfo)oSucheInfo;
            this.log.info("ServerSeitig: oFzgSucheInfoSrc.getSuchHG" + oFzgSucheInfoSrc.getSuchHG());
            JavaFzgSucheInfo oFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfoSrc);
            this.log.info("ServerSeitig: oFzgSucheInfoSrc.getSuchHG" + oFzgSucheInfoSrc.getSuchHG());
            transferable.setValue("fzgsucheinfo_java", oFzgSucheInfo);
        }
        this.sessionInfo.setSearchBTETeile(oSuche);
        int nIndexHGPrev = -1;
        int nIndexHGNext = -1;
        if (oSuche instanceof HGFGSuche) {
            nIndexHGPrev = ((HGFGSuche)oSuche).getIndexPrevHG();
            nIndexHGNext = ((HGFGSuche)oSuche).getIndexNextHG();
        }
        if (oSuche instanceof webetk.app.fzgsuche.HGFGSuche) {
            nIndexHGPrev = ((webetk.app.fzgsuche.HGFGSuche)oSuche).getIndexPrevHG();
            nIndexHGNext = ((webetk.app.fzgsuche.HGFGSuche)oSuche).getIndexNextHG();
        }
        transferable.setValue("index_prev_hg", Integer.toString(nIndexHGPrev));
        transferable.setValue("index_next_hg", Integer.toString(nIndexHGNext));
    }

    protected void performTVBenSearch(TrfTeilesuche transferable) {
        this.sessionInfo.setSachnummerSuch(null);
        Vector<String> cRegionen = this.sessionInfo.getUserInfo().getRegionen();
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIsFzg = (String)transferable.getValue("isfzg");
        boolean bIsFzg = sIsFzg != null && sIsFzg.equals("true");
        String sModus = (String)transferable.getValue("modus");
        String sMarke = null;
        String sProduktart = null;
        String sKatalogumfang = null;
        SucheInfo oSucheInfo = null;
        sMarke = (String)transferable.getValue("marke");
        sProduktart = (String)transferable.getValue("produktart");
        sKatalogumfang = (String)transferable.getValue("katalogumfang");
        oSucheInfo = new AssSucheInfo();
        oSucheInfo.setMarke(sMarke);
        oSucheInfo.setProduktart(sProduktart);
        oSucheInfo.setKatalogumfang(sKatalogumfang);
        String sBenennung = null;
        Collection cSachnummern = null;
        String sSachnummer = null;
        if (sModus.equals("suchebenennung")) {
            sBenennung = (String)transferable.getValue("benennung");
        }
        if (sModus.equals("suchesachnummer") && (cSachnummern = (Collection)transferable.getValue("sachnummern")).size() == 1) {
            sSachnummer = (String)((ArrayList)cSachnummern).get(0);
        }
        SearchBTETeile oSuche = null;
        try {
            if (sModus.equals("suchebenennung")) {
                oSuche = new TVBenennungSuche(sBenennung);
            }
            if (sModus.equals("suchesachnummer")) {
                oSuche = new BTESuche(cSachnummern, cRegionen);
                this.sessionInfo.setSachnummerSuch(sSachnummer);
            }
        }
        catch (Exception e) {
            transferable.setError(e);
            return;
        }
        int nErgebnis = -1;
        if (bIsFzg) {
            oSuche.includeAccessoiresBildtafeln(true);
        }
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("searchbteteile", oSuche);
                transferable.setValue("sucheinfo", oSucheInfo);
                transferable.setValue("sprache", sLang);
                SessionInfoDez oSessionInfoDez = new SessionInfoDez();
                oSessionInfoDez.setMbAusweisungenElementeAktiv(this.sessionInfo.isAusweisungenElementeAktiv());
                oSessionInfoDez.setMbNachruestungenRelevant(this.sessionInfo.getUserInfo().getNachruestungenRelevant());
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    oSessionInfoDez.setMoBedingungswerte_BTE(this.sessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE());
                } else {
                    oSessionInfoDez.setMoBedingungswerte_BTE(null);
                }
                transferable.setValue("sesseionInfoDez", oSessionInfoDez);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.LOAD_TEILEVERWENDUNGBEN);
                oSucheInfo = (SucheInfo)transferable.getValue("sucheinfo");
                oSuche = (SearchBTETeile)transferable.getValue("searchbteteile");
                transferable.setValue("searchbteteile", null);
                String sErgebnis = (String)transferable.getValue("ergebnis");
                nErgebnis = sErgebnis == null ? -1 : Integer.parseInt(sErgebnis);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
        }
        try {
            nErgebnis = oSuche.performSearch(oSucheInfo, sLang, this.sessionInfo);
        }
        catch (Exception e) {
            transferable.setError(e);
            return;
        }
        transferable.setValue("bildtafeln", null);
        transferable.setValue("teilenummern", null);
        if (nErgebnis == 4) {
            BaseHgFgSuche oSucheHelp;
            int nAnzHGs;
            boolean bShowNoDataFoundMeldung = true;
            if (oSuche instanceof HGFGSuche && (nAnzHGs = ((HGFGSuche)(oSucheHelp = (HGFGSuche)oSuche)).getAnzHGs()) > 1) {
                bShowNoDataFoundMeldung = false;
            }
            if (oSuche instanceof webetk.app.fzgsuche.HGFGSuche && (nAnzHGs = ((webetk.app.fzgsuche.HGFGSuche)(oSucheHelp = (webetk.app.fzgsuche.HGFGSuche)oSuche)).getAnzHGs()) > 1) {
                bShowNoDataFoundMeldung = false;
            }
            if (bShowNoDataFoundMeldung) {
                transferable.setError(new NoDataFoundException("keine Daten gefunden"));
                return;
            }
        }
        transferable.setValue("bildtafeln", null);
        if (nErgebnis == 3 || nErgebnis == 1) {
            transferable.setValue("bildtafeln", oSuche.getBTEs());
        }
        if (nErgebnis == 3 || nErgebnis == 2) {
            transferable.setValue("teilenummern", oSuche.getTeile());
        }
        if (!bIsFzg) {
            AssSucheInfo oAssSucheInfoSrc = oSucheInfo;
            JavaAssSucheInfo oAssSucheInfo = new JavaAssSucheInfo(oAssSucheInfoSrc);
            transferable.setValue("asssucheinfo_java", oAssSucheInfo);
        } else {
            FzgSucheInfo oFzgSucheInfoSrc = (FzgSucheInfo)oSucheInfo;
            JavaFzgSucheInfo oFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfoSrc);
            this.log.info("ServerSeitig: oFzgSucheInfoSrc.getSuchHG" + oFzgSucheInfoSrc.getSuchHG());
            transferable.setValue("fzgsucheinfo_java", oFzgSucheInfo);
        }
        this.sessionInfo.setSearchBTETeile(oSuche);
        int nIndexHGPrev = -1;
        int nIndexHGNext = -1;
        if (oSuche instanceof HGFGSuche) {
            nIndexHGPrev = ((HGFGSuche)oSuche).getIndexPrevHG();
            nIndexHGNext = ((HGFGSuche)oSuche).getIndexNextHG();
        }
        if (oSuche instanceof webetk.app.fzgsuche.HGFGSuche) {
            nIndexHGPrev = ((webetk.app.fzgsuche.HGFGSuche)oSuche).getIndexPrevHG();
            nIndexHGNext = ((webetk.app.fzgsuche.HGFGSuche)oSuche).getIndexNextHG();
        }
        transferable.setValue("index_prev_hg", Integer.toString(nIndexHGPrev));
        transferable.setValue("index_next_hg", Integer.toString(nIndexHGNext));
    }

    protected void performHGSearchAtIndex(TrfTeilesuche transferable) {
        BaseHgFgSuche oHGFGSuche;
        BaseHgFgSuche oHGFGSuche2;
        this.log.info("ServerSeitig: performHGSearchAtIndex");
        this.sessionInfo.setSachnummerSuch(null);
        String sLang = this.sessionInfo.getAktuelleSprache();
        String sIndexHG = (String)transferable.getValue("index");
        if (sIndexHG == null) {
            this.log.error("performHGSearchAtIndex(): kein Index angegeben");
            transferable.setError(new Exception("kein Index angegeben"));
            return;
        }
        int nIndexHG = Integer.parseInt(sIndexHG);
        if (nIndexHG == -1) {
            this.log.error("performHGSearchAtIndex(): Index -1 angegeben");
            transferable.setError(new Exception("Index -1 angegeben"));
            return;
        }
        SearchBTETeile oSearchBTETeile = this.sessionInfo.getSearchBTETeile();
        if (oSearchBTETeile == null) {
            this.log.error("performHGSearchAtIndex(): keine SearchBTETeile-Object vorhanden");
            transferable.setError(new Exception("keine SearchBTETeile-Object vorhanden"));
            return;
        }
        if (!(oSearchBTETeile instanceof HGFGSuche) && !(oSearchBTETeile instanceof webetk.app.fzgsuche.HGFGSuche)) {
            this.log.error("performHGSearchAtIndex(): Suchobject keine HGFGSuche");
            transferable.setError(new Exception("Suchobject keine HGFGSuche"));
            return;
        }
        if (oSearchBTETeile instanceof HGFGSuche) {
            oHGFGSuche2 = (HGFGSuche)oSearchBTETeile;
            ((HGFGSuche)oHGFGSuche2).setAktIndexHG(nIndexHG);
        } else {
            oHGFGSuche2 = (webetk.app.fzgsuche.HGFGSuche)oSearchBTETeile;
            ((webetk.app.fzgsuche.HGFGSuche)oHGFGSuche2).setAktIndexHG(nIndexHG);
        }
        int nErgebnis = -1;
        SucheInfo oSucheInfo = this.sessionInfo.getSucheInfo();
        Collection<SearchBTETeile.PartOrBTE> cBTEs = null;
        int nIndexHGPrev = -1;
        int nIndexHGNext = -1;
        if (this.sessionInfo.doZentraleRecherche()) {
            try {
                transferable.setValue("searchbteteile", oSearchBTETeile);
                transferable.setValue("sucheinfo", oSucheInfo);
                transferable.setValue("sprache", sLang);
                SessionInfoDez oSessionInfoDez = new SessionInfoDez();
                oSessionInfoDez.setMbAusweisungenElementeAktiv(this.sessionInfo.isAusweisungenElementeAktiv());
                oSessionInfoDez.setMbNachruestungenRelevant(this.sessionInfo.getUserInfo().getNachruestungenRelevant());
                if (this.sessionInfo.getFzgSucheInfo() != null) {
                    oSessionInfoDez.setMoBedingungswerte_BTE(this.sessionInfo.getFzgSucheInfo().getBedingungsMenge_BTE());
                } else {
                    oSessionInfoDez.setMoBedingungswerte_BTE(null);
                }
                transferable.setValue("sesseionInfoDez", oSessionInfoDez);
                GlobalObjects.getInstance().getServiceExecutor().executeService(transferable, Command.SEARCH_HG_AT_INDEX);
                oSucheInfo = (SucheInfo)transferable.getValue("sucheinfo");
                oSearchBTETeile = (SearchBTETeile)transferable.getValue("searchbteteile");
                this.sessionInfo.setSearchBTETeile(oSearchBTETeile);
                transferable.setValue("searchbteteile", null);
                String sErgebnis = (String)transferable.getValue("ergebnis");
                nErgebnis = sErgebnis == null ? -1 : Integer.parseInt(sErgebnis);
            }
            catch (CommunicationException ex) {
                transferable.setError(ex);
                return;
            }
        }
        this.log.info("Suche lokal durchf\u00fchren");
        try {
            if (oSearchBTETeile instanceof HGFGSuche) {
                oHGFGSuche = (HGFGSuche)oSearchBTETeile;
                nErgebnis = ((HGFGSuche)oHGFGSuche).performSearch(this.sessionInfo.getAssSucheInfo(), sLang, this.sessionInfo);
                cBTEs = oHGFGSuche.getBTEs();
                nIndexHGPrev = ((HGFGSuche)oHGFGSuche).getIndexPrevHG();
                nIndexHGNext = ((HGFGSuche)oHGFGSuche).getIndexNextHG();
            } else {
                oHGFGSuche = (webetk.app.fzgsuche.HGFGSuche)oSearchBTETeile;
                nErgebnis = ((webetk.app.fzgsuche.HGFGSuche)oHGFGSuche).performSearch(this.sessionInfo.getFzgSucheInfo(), sLang, this.sessionInfo);
                cBTEs = oHGFGSuche.getBTEs();
                nIndexHGPrev = ((webetk.app.fzgsuche.HGFGSuche)oHGFGSuche).getIndexPrevHG();
                nIndexHGNext = ((webetk.app.fzgsuche.HGFGSuche)oHGFGSuche).getIndexNextHG();
            }
        }
        catch (Exception e) {
            transferable.setError(e);
        }
        if (oSearchBTETeile instanceof HGFGSuche) {
            oHGFGSuche = (HGFGSuche)oSearchBTETeile;
            cBTEs = oHGFGSuche.getBTEs();
            nIndexHGPrev = ((HGFGSuche)oHGFGSuche).getIndexPrevHG();
            nIndexHGNext = ((HGFGSuche)oHGFGSuche).getIndexNextHG();
        } else {
            oHGFGSuche = (webetk.app.fzgsuche.HGFGSuche)oSearchBTETeile;
            cBTEs = oHGFGSuche.getBTEs();
            nIndexHGPrev = ((webetk.app.fzgsuche.HGFGSuche)oHGFGSuche).getIndexPrevHG();
            nIndexHGNext = ((webetk.app.fzgsuche.HGFGSuche)oHGFGSuche).getIndexNextHG();
        }
        transferable.setValue("bildtafeln", null);
        if (nErgebnis == 3 || nErgebnis == 1) {
            transferable.setValue("bildtafeln", cBTEs);
        }
        transferable.setValue("index_prev_hg", Integer.toString(nIndexHGPrev));
        transferable.setValue("index_next_hg", Integer.toString(nIndexHGNext));
        if (oSearchBTETeile instanceof HGFGSuche) {
            AssSucheInfo oAssSucheInfoSrc = (AssSucheInfo)oSucheInfo;
            JavaAssSucheInfo oAssSucheInfo = new JavaAssSucheInfo(oAssSucheInfoSrc);
            transferable.setValue("asssucheinfo_java", oAssSucheInfo);
            this.log.info("oAssSucheInfoSrc.getSuchHG(): " + oAssSucheInfoSrc.getSuchHG());
        } else {
            FzgSucheInfo oFzgSucheInfoSrc = (FzgSucheInfo)oSucheInfo;
            JavaFzgSucheInfo oFzgSucheInfo = new JavaFzgSucheInfo(oFzgSucheInfoSrc);
            transferable.setValue("fzgsucheinfo_java", oFzgSucheInfo);
            this.log.info("oFzgSucheInfo.getSuchHG(): " + oFzgSucheInfo.getSuchHG());
        }
    }
}

