/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.DatabaseBusyException;
import webetk.IntegerWrapper;
import webetk.InvalidDataException;
import webetk.NoDataFoundException;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.zub.common.Preise;
import webetk.app.zub.suche.Bauart;
import webetk.app.zub.suche.Baureihe;
import webetk.app.zub.suche.BaureiheMotorrad;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.KarosserieForm;
import webetk.app.zub.suche.Modell;
import webetk.app.zub.suche.ProduktId;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.command.TrfZubMiscCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfZubSuche;
import webetk.db.zub.dbaccess.SucheDbAccess;
import webetk.utils.StringUtils;

public class TrfZubSucheCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfZubSucheCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfZubSuche)) {
            this.log.error("Given transferable must be TrfZubSuche, but it isn't!");
            throw new ClassCastException("TrfZubSuche excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfZubSuche transferableMap = (TrfZubSuche)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.LADE_KATEGORIEN.equals(command)) {
            this.ladeKategorien(transferableMap);
            return;
        }
        if (Command.SUCHE_PRODUKTE_UK.equals(command)) {
            this.sucheProdukteUk(transferableMap);
            return;
        }
        if (Command.ERMITTLE_ANZAHL_SUCHERGEBNISSE.equals(command)) {
            this.anzahlMarketingProdukteUk(transferableMap);
            return;
        }
        if (Command.LADE_UNTERKATEGORIEN_ZU_HAUPTKATEGORIE.equals(command)) {
            this.ladeUnterkategorien(transferableMap);
            return;
        }
        if (Command.REFRESH_BTE_LISTE_ZU_UK.equals(command)) {
            this.refreshBteListe(transferableMap);
            return;
        }
        if (Command.LOAD_BAUARTEN_MOTORAD.equals(command)) {
            this.ladeBauartMotorrad(transferableMap);
            return;
        }
        if (Command.LOAD_BAUREIHEN_MOTORAD.equals(command)) {
            this.ladeBaureihenMotorrad(transferableMap);
            return;
        }
        if (Command.LOAD_MODELLE_MOTORAD.equals(command)) {
            this.ladeModelleMotorrad(transferableMap);
            return;
        }
        if (Command.LOAD_BAUARTEN.equals(command)) {
            this.ladeBauarten(transferableMap);
            return;
        }
        if (Command.LADE_BAUREIHEN.equals(command)) {
            this.ladeBaureihen(transferableMap);
            return;
        }
        if (Command.LADE_KAROSSERIEFORMEN.equals(command)) {
            this.ladeKaroserieFormen(transferableMap);
            return;
        }
        if (Command.LADE_MODELLE.equals(command)) {
            this.ladeModelle(transferableMap);
            return;
        }
        if (Command.LADE_KATALOGAUSFUEHRUNGEN.equals(command)) {
            this.ladeKatalogausf\u00fchrungen(transferableMap);
            return;
        }
        if (Command.LOAD_BAUARTENBAUM.equals(command)) {
            this.ladeBauartenBaum(transferableMap);
            return;
        }
        if (Command.LOAD_BAUREIHENBAUM_WITH_BAUART.equals(command)) {
            this.ladeBaureihenBaumWithBauart(transferableMap);
            return;
        }
        if (Command.LADE_BAUREIHENBAUM.equals(command)) {
            this.ladeBaureihenBaum(transferableMap);
            return;
        }
        if (Command.ERMITTLE_KUNDE_AUS_NUMMER.equals(command)) {
            this.ermittleKundeAusNummer(transferableMap);
            return;
        }
        if (Command.ERMITTLE_KUNDE_AUS_NAME.equals(command)) {
            this.ermittleKundeAusName(transferableMap);
            return;
        }
        if (Command.ERMITTLE_FAHRZEUGDATEN.equals(command)) {
            this.ermittleFahrzeugdaten(transferableMap);
            return;
        }
        if (Command.ERMITTLE_HITLISTE_KEYWORDSUCHE.equals(command)) {
            this.ermittleHitListeAusKeywordSuche(transferableMap);
            return;
        }
        if (Command.LADE_PRODUKTE_ZU_BTELISTE.equals(command)) {
            this.ermittleProduktElementeAusBTE(transferableMap);
            return;
        }
        if (Command.LADE_MOSPIDS.equals(command)) {
            this.ladeMospIds(transferableMap);
            return;
        }
        if (Command.PERFORM_TEILESUCHE.equals(command)) {
            this.ermittleTeileAusBenennung(transferableMap);
            return;
        }
        if (Command.LOAD_HK_UK_ZU_PRODUKT.equals(command)) {
            this.loadHkUkZuProdukt(transferableMap);
            return;
        }
        if (Command.ERMITTLE_BTE_BEDINGUNG.equals(command)) {
            this.ermittleBteBedingung(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void ermittleTeileAusBenennung(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        Fahrzeug fahrzeug = null;
        String suchbegriff = (String)transferableMap.getValue("suchbegriff");
        try {
            fahrzeug = (Fahrzeug)transferableMap.getValue("fahrzeug");
            if (fahrzeug != null && fahrzeug.getModellspalte() == 0L) {
                FzgIdInfo info = new FzgIdInfo();
                if (fahrzeug.getFahrgestellnummer() != null) {
                    String sLang = this.sessionInfo.getAktuelleSprache();
                    Collection<String> aUserMarken = this.sessionInfo.getUserMarken();
                    Collection<String> aUserProdukte = this.sessionInfo.getUserProdukte();
                    String katalogUmfang = this.sessionInfo.getUserKatUmfang();
                    try {
                        info.identifyByFgstnr(fahrzeug.getFahrgestellnummer(), aUserMarken, aUserProdukte, katalogUmfang, sLang);
                        fahrzeug.setModellspalte(info.getModellspalte());
                    }
                    catch (NoDataFoundException e) {
                        fahrzeug = null;
                    }
                } else if (fahrzeug.getBaureihe() == null || fahrzeug.getModell() == null || fahrzeug.getKarosserie() == null || fahrzeug.getRegion() == null) {
                    fahrzeug = null;
                } else {
                    info.setBaureihe(fahrzeug.getBaureihe());
                    info.setModell(fahrzeug.getModell());
                    info.setKarosserie(fahrzeug.getKarosserie());
                    info.setRegion(fahrzeug.getRegion());
                    long modellSpalte = info.ermittleModellspalte();
                    if (modellSpalte != -1L) {
                        fahrzeug.setModellspalte(modellSpalte);
                    } else {
                        fahrzeug = null;
                    }
                }
            }
            List suchErgebnisse = SucheDbAccess.sucheProdukteEtk(suchbegriff, fahrzeug, marke, produktArt, sprache, region);
            transferableMap.setValue("ergebnisList", suchErgebnisse);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleHitListeAusKeywordSuche(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        try {
            String keyword = (String)transferableMap.getValue("keywordSucheString");
            Integer hkId = (Integer)transferableMap.getValue("hauptKategorie");
            Integer ukId = (Integer)transferableMap.getValue("unterkategorie");
            Baureihe baureihe = (Baureihe)transferableMap.getValue("BAUREIHE_ZUB");
            Fahrzeug fahrzeug = (Fahrzeug)transferableMap.getValue("fahrzeug");
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(sprache, region);
            }
            String marktBen = SucheDbAccess.ermittleMarktZuId(marktId, sprache, region);
            List hitListe = SucheDbAccess.ermittleHitListeAusString(keyword, marktId, marktBen, baureihe, fahrzeug, hkId, ukId, marke, produktArt, sprache, region);
            transferableMap.setValue("ergebnisHitliste", hitListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void refreshBteListe(TrfZubSuche transferableMap) {
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String iso = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String katalogUmfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        try {
            long hauptkatId = (Long)transferableMap.getValue("hauptKategorie");
            long unterkatId = (Long)transferableMap.getValue("unterkategorie");
            Baureihe baureihe = (Baureihe)transferableMap.getValue("BAUREIHE_ZUB");
            FzgSucheInfo sucheInfo = (FzgSucheInfo)transferableMap.getValue("fzgidinfo_app");
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(iso, regIso);
            }
            List<Object> bteListe = new ArrayList();
            bteListe = sucheInfo != null ? SucheDbAccess.ermittleBtesZuUnterkategorie(hauptkatId, unterkatId, marktId, marke, produktArt, sucheInfo, sRegionenAufbereitet, katalogUmfang, iso, regIso) : (baureihe != null ? SucheDbAccess.ermittleBtesZuUnterkategorie(hauptkatId, unterkatId, marktId, marke, produktArt, baureihe, sRegionenAufbereitet, katalogUmfang, iso, regIso) : SucheDbAccess.ermittleBtesZuUnterkategorie(hauptkatId, unterkatId, marktId, marke, produktArt, iso, regIso));
            this.sessionInfo.getUserInfo().setBteResults(bteListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeUnterkategorien(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        try {
            int hauptKategorieId = (Integer)transferableMap.getValue("hauptKategorie");
            int markt = this.sessionInfo.getUserInfo().getMarktId();
            if (markt < 0) {
                markt = SucheDbAccess.ermittleDefaultMarktId(sprache, regIso);
            }
            List<HitListenUnterkategorie> unterkategorien = SucheDbAccess.ladeUnterkategorien(hauptKategorieId, produktArt, marke, markt, sprache, regIso);
            transferableMap.setValue("unterkategorieListe", unterkategorien);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeKategorien(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        try {
            int markt = this.sessionInfo.getUserInfo().getMarktId();
            if (markt < 0) {
                markt = SucheDbAccess.ermittleDefaultMarktId(sprache, regIso);
            }
            boolean ladeOhneUk = true;
            if (transferableMap.getHashMap() != null && transferableMap.getHashMap().containsKey("ermittleHkOhneUK")) {
                ladeOhneUk = (Boolean)transferableMap.getValue("ermittleHkOhneUK");
            }
            List<HauptKategorie> hauptKategorien = SucheDbAccess.ladeHauptKategorien(produktArt, marke, markt, sprache, regIso, ladeOhneUk);
            transferableMap.setValue("kategorienListe", hauptKategorien);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void anzahlMarketingProdukteUk(TrfZubSuche transferableMap) {
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String iso = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            long hauptkatId = (Long)transferableMap.getValue("hauptKategorie");
            long unterkatId = (Long)transferableMap.getValue("unterkategorie");
            Boolean refreshBte = (Boolean)transferableMap.getValue("refreshBTEListe");
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(iso, regIso);
            }
            if (refreshBte != null && refreshBte.booleanValue() || this.sessionInfo.getUserInfo().getBteResults() == null || this.sessionInfo.getUserInfo().getBteResults().size() == 0) {
                this.sessionInfo.getUserInfo().setBteResults(SucheDbAccess.ermittleBtesZuUnterkategorie(hauptkatId, unterkatId, marktId, marke, produktArt, iso, regIso));
            }
            transferableMap.setValue("anzahlSuchergebnisse", new Integer(this.sessionInfo.getUserInfo().getBteResults().size()));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void sucheProdukteUk(TrfZubSuche transferableMap) {
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        String katalogUmfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(sprache, regIso);
            }
            String marktBen = SucheDbAccess.ermittleMarktZuId(marktId, sprache, regIso);
            Integer hauptkatId = (Integer)transferableMap.getValue("hauptKategorie");
            Integer unterkatId = (Integer)transferableMap.getValue("unterkategorie");
            String isLifestyle = transferableMap.getValue("isLifestyle").toString();
            int fetchSize = (Integer)transferableMap.getValue("marketingFetchSize");
            int pageNr = (Integer)transferableMap.getValue("marketingPageNr");
            Boolean refresh = (Boolean)transferableMap.getValue("refreshBTEListe");
            String kundenNr = (String)transferableMap.getValue("kundennr");
            FzgSucheInfo fahrzeug = (FzgSucheInfo)transferableMap.getValue("fzgsucheinfo_app");
            if (this.sessionInfo.getUserInfo().getBteResults() == null || this.sessionInfo.getUserInfo().getBteResults().size() == 0 || refresh != null && refresh.booleanValue()) {
                this.sessionInfo.getUserInfo().setBteResults(SucheDbAccess.ermittleBtesZuUnterkategorie(hauptkatId.longValue(), unterkatId.longValue(), marktId, marke, produktArt, fahrzeug, sRegionenAufbereitet, katalogUmfang, sprache, regIso));
            }
            List<ProduktId> bteNrn = this.sessionInfo.getUserInfo().getBteResults();
            transferableMap.setValue("bteListe", bteNrn);
            if (bteNrn.size() == 0) {
                transferableMap.setValue("marketingListe", new ArrayList());
                return;
            }
            List<ProduktListenElement> prodListe = SucheDbAccess.ermittleProduktListeZuBtNrn(bteNrn, firmaId, marktId, marktBen, marke, produktArt, sRegionenAufbereitet, katalogUmfang, sprache, regIso, fetchSize, pageNr, isLifestyle.equals("J"));
            try {
                this.ermittlePreise(bteNrn, prodListe, kundenNr, fahrzeug, transferableMap);
            }
            catch (Exception e) {
                transferableMap.setError(e);
            }
            transferableMap.setValue("marketingListe", prodListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleBteBedingung(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            String btenr = (String)transferableMap.getValue("btnummer");
            String prodListe = SucheDbAccess.ermittleBTEBedingung(btenr, sprache, regIso);
            transferableMap.setValue("bteBedingungString", prodListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittlePreise(List<ProduktId> bteNrn, List<ProduktListenElement> prodListe, String kundenNr, FzgSucheInfo fahrzeug, TrfZubSuche trf) throws DatabaseBusyException, SQLException {
        int position = 1;
        for (ProduktId id : bteNrn) {
            Preise preise = TrfZubMiscCommand.ladePreiseAusPriceFile(id.getBteNr(), id.getBteArt(), kundenNr, fahrzeug, null, this.sessionInfo);
            try {
                String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
                if (!Teileinfo.checkPreiseGeladen(firmaId)) {
                    preise = TrfZubMiscCommand.ladePreiseVonDMS(preise, kundenNr, this.sessionInfo);
                }
            }
            catch (Exception ex) {
                if (ex instanceof DMSException) {
                    DMSException exDms = (DMSException)ex;
                    if (trf.getError() != null) {
                        if (((DMSException)trf.getError()).getTeilenummern() != null && exDms.getTeilenummern() != null && !((DMSException)trf.getError()).getTeilenummern().contains(exDms.getTeilenummern().toArray()[0])) {
                            ((DMSException)trf.getError()).getTeilenummern().add(exDms.getTeilenummern().toArray()[0]);
                            ((DMSException)trf.getError()).getPositionen().add(new Integer(++position));
                            ((DMSException)trf.getError()).getRetCodes().add(exDms.getRetCodes().toArray()[0]);
                        }
                    } else {
                        trf.setError(ex);
                    }
                }
                trf.setError(ex);
            }
            for (ProduktListenElement elem : prodListe) {
                boolean equalBildPos;
                boolean bl = equalBildPos = elem.getBildPosNr() == null && id.getBildPosNr() == null || elem.getBildPosNr() != null && id.getBildPosNr() != null && elem.getBildPosNr().equals(id.getBildPosNr());
                if (!elem.getBteNr().equals(id.getBteNr()) || !equalBildPos) continue;
                elem.setPreise(preise);
                elem.setPrice(preise.getAbPreis(id.getBildPosNr(), null));
            }
        }
    }

    private void ermittleProduktElementeAusBTE(TrfZubSuche transferableMap) {
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        String katalogUmfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(sprache, regIso);
            }
            String marktBen = SucheDbAccess.ermittleMarktZuId(marktId, sprache, regIso);
            List bteListe = (List)transferableMap.getValue("bteListe");
            int fetchSize = (Integer)transferableMap.getValue("marketingFetchSize");
            int pageNr = (Integer)transferableMap.getValue("marketingPageNr");
            String kundenNr = (String)transferableMap.getValue("kundennr");
            FzgSucheInfo fahrzeug = (FzgSucheInfo)transferableMap.getValue("fzgsucheinfo_app");
            String isLifestyle = transferableMap.getValue("isLifestyle").toString();
            List<ProduktListenElement> prodListe = SucheDbAccess.ermittleProduktListeZuBtNrn(bteListe, firmaId, marktId, marktBen, marke, produktArt, sRegionenAufbereitet, katalogUmfang, sprache, regIso, fetchSize, pageNr, isLifestyle.equals("J"));
            try {
                this.ermittlePreise(bteListe, prodListe, kundenNr, fahrzeug, transferableMap);
            }
            catch (Exception e) {
                transferableMap.setError(e);
            }
            transferableMap.setValue("marketingListe", prodListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeBauartMotorrad(TrfZubSuche transferableMap) {
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktart = this.sessionInfo.getUserInfo().getProduktart();
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            List bauartenListe = SucheDbAccess.holeBauartAuswahlMotorrad(marke, produktart, katalogumfang, sRegionenAufbereitet, sprache, regIso);
            transferableMap.setValue("bauartenmotorradliste", bauartenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeBaureihenMotorrad(TrfZubSuche transferableMap) {
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktart = this.sessionInfo.getUserInfo().getProduktart();
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            Bauart bauartMotorrad = (Bauart)transferableMap.getValue("bauart");
            bauartMotorrad = SucheDbAccess.holeBaureihenMotorradAuswahl(bauartMotorrad, marke, produktart, katalogumfang, sRegionenAufbereitet, sprache, regIso);
            transferableMap.setValue("bauart", bauartMotorrad);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeModelleMotorrad(TrfZubSuche transferableMap) {
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        try {
            BaureiheMotorrad baureihe = (BaureiheMotorrad)transferableMap.getValue("baureiheMotorrad");
            baureihe = SucheDbAccess.holeModellAuswahlMotorrad(baureihe, katalogumfang, sRegionenAufbereitet);
            transferableMap.setValue("baureiheMotorrad", baureihe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeBauarten(TrfZubSuche transferableMap) {
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktart = this.sessionInfo.getUserInfo().getProduktart();
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            List bauartenListe = SucheDbAccess.holeBauartenAuswahl(marke, produktart, katalogumfang, sRegionenAufbereitet, sprache, regIso);
            transferableMap.setValue("bauartenliste", bauartenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeBaureihen(TrfZubSuche transferableMap) {
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktart = this.sessionInfo.getUserInfo().getProduktart();
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            String bauartMotorrad = transferableMap.getValue("bauart").toString();
            List baureihenListe = SucheDbAccess.holeBaureihenAuswahl(marke, produktart, bauartMotorrad, katalogumfang, sRegionenAufbereitet, sprache, regIso);
            transferableMap.setValue("baureihenListeZUB", baureihenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeKaroserieFormen(TrfZubSuche transferableMap) {
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            Baureihe baureihe = (Baureihe)transferableMap.getValue("BAUREIHE_ZUB");
            if (baureihe.getKarosserieForm() == null || baureihe.getKarosserieForm().isEmpty()) {
                baureihe = SucheDbAccess.holeKarosserieformenAuswahl(baureihe, katalogumfang, sRegionenAufbereitet, sprache, regIso);
                transferableMap.setValue("BAUREIHE_ZUB", baureihe);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeModelle(TrfZubSuche transferableMap) {
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        try {
            KarosserieForm karosserieForm = (KarosserieForm)transferableMap.getValue("karosserie");
            if (karosserieForm.getModelle() == null || karosserieForm.getModelle().isEmpty()) {
                String baureihe = ((Baureihe)transferableMap.getValue("BAUREIHE_ZUB")).getBaureihe();
                karosserieForm = SucheDbAccess.holeModellAuswahlPkw(karosserieForm, baureihe, katalogumfang, sRegionenAufbereitet);
                transferableMap.setValue("karosserie", karosserieForm);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeKatalogausf\u00fchrungen(TrfZubSuche transferableMap) {
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String katalogumfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String produktart = this.sessionInfo.getUserInfo().getProduktart();
        try {
            Modell modell = (Modell)transferableMap.getValue("modell");
            String baureihe = transferableMap.getValue("baureihe").toString();
            String karosserieForm = transferableMap.getValue("karosserie").toString();
            modell = SucheDbAccess.holeKatalogAuswahl(produktart, modell, baureihe, karosserieForm, katalogumfang, sRegionenAufbereitet);
            transferableMap.setValue("modell", modell);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeBauartenBaum(TrfZubSuche transferableMap) {
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String katalogUmfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        try {
            String bteNr = (String)transferableMap.getValue("btnummer");
            String bildPosNr = (String)transferableMap.getValue("bildPosNr");
            List bauartenListe = null;
            bauartenListe = bildPosNr != null && bildPosNr.length() > 0 ? SucheDbAccess.ermittleBnbBauartenBaum(bteNr, bildPosNr, marke, produktArt, katalogUmfang, sRegionenAufbereitet, sprache, region) : SucheDbAccess.ermittleBauartenBaum(bteNr, marke, produktArt, katalogUmfang, sRegionenAufbereitet, sprache, region);
            transferableMap.setValue("bauartenliste", bauartenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeBaureihenBaum(TrfZubSuche transferableMap) {
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String katalogUmfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        try {
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(sprache, region);
            }
            String bteNr = (String)transferableMap.getValue("btnummer");
            String bildPosNr = (String)transferableMap.getValue("bildPosNr");
            List baureihenListe = null;
            baureihenListe = bildPosNr != null && bildPosNr.length() > 0 ? SucheDbAccess.ermittleBnbBaureihenBaum(bteNr, marktId, bildPosNr, marke, produktArt, katalogUmfang, sRegionenAufbereitet, sprache, region) : SucheDbAccess.ermittleBaureihenBaum(bteNr, marktId, marke, produktArt, katalogUmfang, sRegionenAufbereitet, sprache, region);
            transferableMap.setValue("baureihenListeZUB", baureihenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeBaureihenBaumWithBauart(TrfZubSuche transferableMap) {
        String sRegionenAufbereitet = StringUtils.maskiereHochkommaKomma(this.sessionInfo.getUserInfo().getRegionen());
        String katalogUmfang = this.sessionInfo.getUserInfo().getKatalogumfang();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        try {
            String bteNr = (String)transferableMap.getValue("btnummer");
            String bildPosNr = (String)transferableMap.getValue("bildPosNr");
            String bauart = (String)transferableMap.getValue("bauart");
            List baureihenListe = null;
            baureihenListe = bildPosNr != null && bildPosNr.length() > 0 ? SucheDbAccess.ermittleBnbBaureihenBaumWithBauart(bteNr, bildPosNr, marke, produktArt, katalogUmfang, sRegionenAufbereitet, sprache, region, bauart) : SucheDbAccess.ermittleBaureihenBaumWithBauart(bteNr, marke, produktArt, katalogUmfang, sRegionenAufbereitet, sprache, region, bauart);
            transferableMap.setValue("baureihenListeZUB", baureihenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleKundeAusNummer(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String produktart = this.sessionInfo.getUserInfo().getProduktart();
        try {
            String kundennummer = transferableMap.getValue("kundennr").toString();
            List kundenListe = SucheDbAccess.holeKundenZuNummer(kundennummer, sprache, region, produktart);
            transferableMap.setValue("kundenListe", kundenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleKundeAusName(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String produktart = this.sessionInfo.getUserInfo().getProduktart();
        try {
            String kundenname = (String)transferableMap.getValue("kundenname");
            List kundenListe = SucheDbAccess.holeKundenZuName(kundenname, sprache, region, produktart);
            transferableMap.setValue("kundenListe", kundenListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleFahrzeugdaten(TrfZubSuche transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String region = this.sessionInfo.getUserInfo().getSpracheRegion();
        String vin = (String)transferableMap.getValue("vin");
        Long mospid = (Long)transferableMap.getValue("modellspaltenid");
        try {
            Fahrzeug fahrzeug = null;
            if (vin != null && !"".equals(vin)) {
                fahrzeug = SucheDbAccess.holeFahrzeugDetailsAusVin(vin, sprache, region);
            } else if (mospid != null) {
                fahrzeug = SucheDbAccess.holeFahrzeugDetailsAusMospid(mospid, sprache, region);
            } else {
                this.log.error("Weder VIN noch MOSPID zum Laden der Fahrzeugdaten angegeben.");
            }
            transferableMap.setValue("fahrzeug", fahrzeug);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeMospIds(TrfZubSuche transferableMap) {
        String baureihe = (String)transferableMap.getValue("baureihe");
        String karosserie = (String)transferableMap.getValue("karosserie");
        String erwvbez = (String)transferableMap.getValue("ErwVerkaufsBez");
        String katalog = (String)transferableMap.getValue("KatalogAusfuehrung");
        try {
            Collection<Long> mospids = SucheDbAccess.ladeMospIdsZuAuswahl(baureihe, karosserie, erwvbez, katalog);
            transferableMap.setValue("modellspaltenidsInt", mospids);
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    private void loadHkUkZuProdukt(TrfZubSuche transferableMap) {
        String btenr = (String)transferableMap.getValue("btnummer");
        try {
            IntegerWrapper hkId = new IntegerWrapper(null);
            IntegerWrapper ukId = new IntegerWrapper(null);
            SucheDbAccess.ermittleHkUkAusProdukt(btenr, hkId, ukId);
            transferableMap.setValue("hauptKategorie", hkId.getValue());
            transferableMap.setValue("unterkategorie", ukId.getValue());
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }
}

