/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.DMSException;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.app.BTEBedingungsmenge;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.teileinfo.Teileinfo;
import webetk.app.zub.common.Preise;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.technisch.TechnikInfo;
import webetk.app.zub.technisch.TechnischesProdukt;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.command.TrfZubMiscCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfZubTechnisch;
import webetk.db.zub.dbaccess.SucheDbAccess;
import webetk.db.zub.dbaccess.TechnischDbAccess;

public class TrfZubTechnischCommand
extends AbstractTransferableCommand {
    protected Logger log = Logger.getLogger(TrfZubTechnischCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfZubTechnisch)) {
            this.log.error("Given transferable must be TrfZubTechnisch, but it isn't!");
            throw new ClassCastException("TrfZubTechnisch excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfZubTechnisch transferableMap = (TrfZubTechnisch)this.transferable;
        Command command = transferableMap.getCommand();
        this.log.debug("Executing command: " + command);
        if (Command.ERMITTLE_TECHNISCHES_PRODUKT.equals(command)) {
            this.ermittleTechnischesProdukt(transferableMap);
            return;
        }
        if (Command.ERMITTLE_BEDINGUNGEN_TECHNISCHES_PRODUKT.equals(command)) {
            this.ermittleBedingungenTechnischesProduktFzg(transferableMap);
            return;
        }
        this.log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void ermittleTechnischesProdukt(TrfZubTechnisch transferableMap) {
        String sBteArt = (String)transferableMap.getValue("art");
        if (sBteArt.equals("FZG")) {
            this.ermittleTechnischesProduktFzg(transferableMap);
        } else {
            this.ermittleTechnischesProduktUgb(transferableMap);
        }
    }

    private void ermittleTechnischesProduktFzg(TrfZubTechnisch transferableMap) {
        String iso = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        try {
            MarketingProdukt mprodukt = (MarketingProdukt)transferableMap.getValue("marketingProdukt");
            Fahrzeug fahrzeug = (Fahrzeug)transferableMap.getValue("fzgsucheinfo_app");
            if (fahrzeug == null) {
                transferableMap.setError(new InvalidInitializationException("kein Fahrzeug-Objekt \u00fcbergeben"));
                return;
            }
            long lMospId = fahrzeug.getModellspalte();
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(iso, regIso);
            }
            TechnischesProdukt oTechnischesProdukt = TechnischDbAccess.getTechnischesProduktFzg(mprodukt, lMospId, iso, regIso, fahrzeug, marktId, this.sessionInfo.getIGDOMVerwenden());
            oTechnischesProdukt.setBteKommentar(new TechnikInfo(mprodukt.getBteNr(), mprodukt.getBildPosNr(), produktArt, iso));
            Preise preise = this.ermittlePreise(transferableMap, "FZG", fahrzeug);
            if (preise != null) {
                oTechnischesProdukt.setPreise(preise);
            }
            transferableMap.setValue("technischesProdukt", oTechnischesProdukt);
            oTechnischesProdukt.setVerbaubareAlternativen(TechnischDbAccess.ermittleVerbauteAlternativen(mprodukt, fahrzeug));
            oTechnischesProdukt.setVerbaubareVarianten(TechnischDbAccess.ermittleVerbauteVarianten(mprodukt, fahrzeug));
            oTechnischesProdukt.setVerbaubareZubehoerProdukte(TechnischDbAccess.ermittleVerbauteZubehoerProdukte(mprodukt, fahrzeug));
            oTechnischesProdukt.checkTechnischesProdukt();
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleTechnischesProduktUgb(TrfZubTechnisch transferableMap) {
        String iso = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            Preise preise;
            MarketingProdukt mprodukt = (MarketingProdukt)transferableMap.getValue("marketingProdukt");
            String sMarke = this.sessionInfo.getUserInfo().getMarke();
            String sProduktart = this.sessionInfo.getUserInfo().getProduktart();
            int marktId = this.sessionInfo.getUserInfo().getMarktId();
            if (marktId < 0) {
                marktId = SucheDbAccess.ermittleDefaultMarktId(iso, regIso);
            }
            TechnischesProdukt oTechnischesProdukt = TechnischDbAccess.getTechnischesProduktUgb(mprodukt, sMarke, sProduktart, "", iso, regIso, marktId, this.sessionInfo.getIGDOMVerwenden());
            oTechnischesProdukt.setBteKommentar(new TechnikInfo(mprodukt.getBteNr(), mprodukt.getBildPosNr(), sProduktart, iso));
            String kundennr = (String)transferableMap.getValue("kundennr");
            if (kundennr == null) {
                kundennr = "0";
            }
            if ((preise = this.ermittlePreise(transferableMap, "ASS", null)) != null) {
                oTechnischesProdukt.setPreise(preise);
            }
            transferableMap.setValue("technischesProdukt", oTechnischesProdukt);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private Preise ermittlePreise(TrfZubTechnisch transferableMap, String sBteArt, FzgSucheInfo oFzgSucheInfo) {
        Preise preise;
        block9: {
            preise = null;
            String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
            try {
                boolean bPreiseDms;
                String preiseLaden = (String)transferableMap.getValue("mit_preisen");
                boolean bPreiseAlle = preiseLaden != null && preiseLaden.equals("ALLES");
                boolean bl = bPreiseDms = preiseLaden != null && preiseLaden.equals("NUR_DMS");
                if (!bPreiseAlle && (!bPreiseDms || !Teileinfo.checkPreiseGeladen(firmaId))) break block9;
                try {
                    MarketingProdukt mprodukt = (MarketingProdukt)transferableMap.getValue("marketingProdukt");
                    String kundennr = (String)transferableMap.getValue("kundennr");
                    if (kundennr == null) {
                        kundennr = "0";
                    }
                    ArrayList hinzugefuegteTeile = (ArrayList)transferableMap.getValue("preiszeilen");
                    preise = TrfZubMiscCommand.ladePreiseAusPriceFile(mprodukt.getBteNr(), sBteArt, kundennr, oFzgSucheInfo, hinzugefuegteTeile, this.sessionInfo);
                    preise = TrfZubMiscCommand.ladePreiseVonDMS(preise, kundennr, this.sessionInfo);
                }
                catch (Exception ex) {
                    if (ex instanceof DMSException) {
                        DMSException exDms = (DMSException)ex;
                        if (transferableMap.getError() != null) {
                            if (!((DMSException)transferableMap.getError()).getTeilenummern().contains(exDms.getTeilenummern().toArray()[0])) {
                                int position = 1;
                                ((DMSException)transferableMap.getError()).getTeilenummern().add(exDms.getTeilenummern().toArray()[0]);
                                ((DMSException)transferableMap.getError()).getPositionen().add(new Integer(position));
                                ((DMSException)transferableMap.getError()).getRetCodes().add(exDms.getRetCodes().toArray()[0]);
                            }
                        } else {
                            transferableMap.setError(ex);
                        }
                        break block9;
                    }
                    transferableMap.setError(ex);
                }
            }
            catch (Exception ex) {
                transferableMap.setError(ex);
            }
        }
        return preise;
    }

    private void ermittleBedingungenTechnischesProduktFzg(TrfZubTechnisch transferableMap) {
        String iso = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            MarketingProdukt mprodukt = (MarketingProdukt)transferableMap.getValue("marketingProdukt");
            FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)transferableMap.getValue("fzgsucheinfo_app");
            if (oFzgSucheInfo == null) {
                transferableMap.setError(new InvalidInitializationException("kein FzgSucheInfo-Objekt \u00fcbergeben"));
                return;
            }
            long lMospId = oFzgSucheInfo.getModellspalte();
            BTEBedingungsmenge oBteBedmenge = TechnischDbAccess.evalBedingungenTechnischesProdukt(mprodukt, lMospId, iso, regIso, oFzgSucheInfo, this.sessionInfo.getIGDOMVerwenden());
            transferableMap.setValue("fzgsucheinfo_app", oFzgSucheInfo);
            transferableMap.setValue("bteBedingung", oBteBedmenge);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }
}

