/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.command;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.ObjectLockedException;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.konfiguration.Konfiguration;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.AnfrageSuche;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.app.zub.verwaltung.Kunde;
import webetk.app.zub.verwaltung.NutzerZub;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.command.AbstractTransferableCommand;
import webetk.communication.command.TrfFahrzeugIdCommand;
import webetk.communication.command.TrfZubSucheCommand;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.db.zub.dbaccess.VerwaltungDbAccess;

public class TrfZubVerwaltungCommand
extends AbstractTransferableCommand {
    private static Logger log = Logger.getLogger(TrfZubSucheCommand.class);

    @Override
    public void setTransferable(Transferable trf) {
        if (!(trf instanceof TrfZubVerwaltung)) {
            log.error("Given transferable must be TrfZubVerwaltung, but it isn't!");
            throw new ClassCastException("TrfZubVerwaltung excepted!");
        }
        super.setTransferable(trf);
    }

    @Override
    public void execute() throws InvalidDataException, DatabaseBusyException, SQLException {
        TrfZubVerwaltung transferableMap = (TrfZubVerwaltung)this.transferable;
        Command command = transferableMap.getCommand();
        log.debug("Executing command: " + command);
        if (Command.LADE_ANFRAGE.equals(command)) {
            this.ladeAnfrage(transferableMap);
            return;
        }
        if (Command.LADE_VORGANG.equals(command)) {
            this.ladeVorgang(transferableMap);
            return;
        }
        if (Command.LADE_KONFIGURATION.equals(command)) {
            this.ladeKonfiguration(transferableMap);
            return;
        }
        if (Command.LADE_ANGEBOT.equals(command)) {
            this.ladeAngebot(transferableMap);
            return;
        }
        if (Command.SPEICHERE_KONFIGURATION.equals(command)) {
            this.speichereKonfiguration(transferableMap);
            return;
        }
        if (Command.SPEICHERE_ANGEBOT.equals(command)) {
            this.speichereAngebot(transferableMap);
            return;
        }
        if (Command.SPEICHERE_KUNDE.equals(command)) {
            this.speichereKunde(transferableMap);
            return;
        }
        if (Command.SPEICHERE_KUNDENFAHRZEUG.equals(command)) {
            this.speichereKundenfahrzeug(transferableMap);
            return;
        }
        if (Command.LOESCHE_ANFRAGE.equals(command)) {
            this.loescheAnfrage(transferableMap);
            return;
        }
        if (Command.LOESCHE_VORGANG.equals(command)) {
            this.loescheVorgang(transferableMap);
            return;
        }
        if (Command.LOESCHE_KONFIGURATION.equals(command)) {
            this.loescheKonfiguration(transferableMap);
            return;
        }
        if (Command.LADE_VORGANG_BEDINGUNGEN.equals(command)) {
            this.ladeVorgangBedingungen(transferableMap);
            return;
        }
        if (Command.LOESCHE_KUNDE.equals(command)) {
            this.loescheKunde(transferableMap);
            return;
        }
        if (Command.LOESCHE_KUNDENFAHRZEUG.equals(command)) {
            this.loescheKundenfahrzeug(transferableMap);
            return;
        }
        if (Command.DRUCKE_BERICHT_EMAIL.equals(command)) {
            this.druckeBerichtEmail(transferableMap);
            return;
        }
        if (Command.ERMITTLE_ARBEIT_KONFIG.equals(command)) {
            this.ermittleArbeitKonfig(transferableMap);
            return;
        }
        if (Command.ERMITTLE_USER_INFO.equals(command)) {
            this.ermittleUserInfo(transferableMap);
            return;
        }
        if (Command.LISTE_FILIALEN.equals(command)) {
            this.listeFilialen(transferableMap);
            return;
        }
        if (Command.UPDATE_ZUB_USER.equals(command)) {
            this.speichereUserDaten(transferableMap);
            return;
        }
        if (Command.SPEICHERE_ARBEIT_KONFIG.equals(command)) {
            this.speichereArbeitKonfig(transferableMap);
            return;
        }
        if (Command.SPEICHERE_FILIALDATEN.equals(command)) {
            this.speichereFilialDaten(transferableMap);
            return;
        }
        if (Command.LISTE_MAERKTE.equals(command)) {
            this.listeMaerkte(transferableMap);
            return;
        }
        if (Command.SUCHE_ANFRAGEN.equals(command)) {
            this.sucheAnfragen(transferableMap);
            return;
        }
        if (Command.SUCHE_ANGEBOTE.equals(command)) {
            this.sucheAngebote(transferableMap);
            return;
        }
        if (Command.LOESCHE_ANGEBOT.equals(command)) {
            this.loescheAngebot(transferableMap);
            return;
        }
        if (Command.STORNIERE_ANGEBOT.equals(command)) {
            this.storniereAngebot(transferableMap);
            return;
        }
        if (Command.ENTSPERRE_ANFRAGE.equals(command)) {
            this.entsperreAnfrage(transferableMap);
            return;
        }
        if (Command.UEBERARBEITE_ANGEBOT.equals(command)) {
            this.ueberarbeiteAngebot(transferableMap);
            return;
        }
        if (Command.SPEICHERE_ANFRAGE.equals(command)) {
            this.speichereAnfrage(transferableMap);
            return;
        }
        if (Command.ERMITTLE_BINDEFRIST.equals(command)) {
            this.ermittleBindeFrist(transferableMap);
            return;
        }
        if (Command.RESET_AW_KONFIG_MARKT.equals(command)) {
            this.resetAwKonfigMarkt(transferableMap);
            return;
        }
        if (Command.HAT_USER_AGB_BESTAETIGT.equals(command)) {
            this.hatUserAgbBestaetigt(transferableMap);
            return;
        }
        if (Command.SET_USER_AGB_BESTAETIGT.equals(command)) {
            this.setUserAgbBestaetigt(transferableMap);
            return;
        }
        if (Command.ANZEIGE_MWST.equals(command)) {
            this.getAnzeigeMwSt(transferableMap);
            return;
        }
        if (Command.KUNDEN_SPEICHERN.equals(command)) {
            this.getKundenSpeichern(transferableMap);
            return;
        }
        if (Command.CHECK_MAILSERVER_ACTIVE.equals(command)) {
            this.isMailServerActive(transferableMap);
            return;
        }
        if (Command.ERMITTLE_NEUE_ANGEBOTSNUMMER.equals(command)) {
            this.setNeueAngebotsNummer(transferableMap);
            return;
        }
        if (Command.SPEICHERE_KUNDENZUORDNUNG.equals(command)) {
            this.speichereKundenZuordnung(transferableMap);
            return;
        }
        if (Command.ERMITTLE_ANZAHL_KONFIG_VON_VORGANG.equals(command)) {
            this.ermittleAnzahlKonfigVonVorgang(transferableMap);
            return;
        }
        if (Command.SET_AN_ISPA.equals(command)) {
            this.setzeFlagAnIspa(transferableMap);
            return;
        }
        log.error("No valid command: " + command);
        throw new InvalidDataException("No valid command: " + command);
    }

    private void setNeueAngebotsNummer(TrfZubVerwaltung transferableMap) {
        try {
            int angebotsNummer = VerwaltungDbAccess.ermittleNeueAngebotsNummer();
            transferableMap.setValue("AngebotsNr", new Integer(angebotsNummer));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void isMailServerActive(TrfZubVerwaltung transferableMap) {
        try {
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            Konfiguration oKonfiguration = new Konfiguration(sFirma, sFiliale);
            oKonfiguration.loadKonfiguration();
            String sMailHost = oKonfiguration.getMailserver();
            if (sMailHost != null && sMailHost.length() > 0) {
                transferableMap.setValue("mailServerAktiv", new Boolean(true));
            } else {
                transferableMap.setValue("mailServerAktiv", new Boolean(false));
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void getKundenSpeichern(TrfZubVerwaltung transferableMap) {
        int marktId = this.sessionInfo.getUserInfo().getMarktId();
        Object oMarktId = transferableMap.getValue("markt");
        if (oMarktId != null) {
            marktId = (Integer)oMarktId;
        }
        try {
            boolean kundenDatenSpeichern = VerwaltungDbAccess.isKundenDatenSpeichern(marktId);
            transferableMap.setValue("kundenDatenSpeichern", new Boolean(kundenDatenSpeichern));
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    private void getAnzeigeMwSt(TrfZubVerwaltung transferableMap) {
        int marktId = this.sessionInfo.getUserInfo().getMarktId();
        Object oMarktId = transferableMap.getValue("markt");
        if (oMarktId != null) {
            marktId = (Integer)oMarktId;
        }
        try {
            boolean anzeigeMwst = VerwaltungDbAccess.isAnzeigeInklMwSt(marktId);
            transferableMap.setValue("anzeigeMwSt", new Boolean(anzeigeMwst));
        }
        catch (Exception ex) {
            transferableMap.setError(ex);
        }
    }

    private void resetAwKonfigMarkt(TrfZubVerwaltung transferableMap) {
        Object oMarktId = transferableMap.getValue("markt");
        String marke = (String)transferableMap.getValue("marke");
        String produktart = (String)transferableMap.getValue("produktart");
        if (marke == null) {
            marke = this.sessionInfo.getUserInfo().getMarke();
        }
        if (produktart == null) {
            produktart = this.sessionInfo.getUserInfo().getProduktart();
        }
        int marktId = 0;
        marktId = oMarktId == null ? this.sessionInfo.getUserInfo().getMarktId() : ((Integer)oMarktId).intValue();
        AufwandsKonfiguration konfig = new AufwandsKonfiguration();
        try {
            VerwaltungDbAccess.ermittleAWFallback(konfig, marktId, marke, produktart);
            transferableMap.setValue("arbeitKonfig", konfig);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleBindeFrist(TrfZubVerwaltung transferableMap) {
        Object oMarktId = transferableMap.getValue("markt");
        int marktId = 0;
        marktId = oMarktId == null ? this.sessionInfo.getUserInfo().getMarktId() : ((Integer)oMarktId).intValue();
        try {
            int bindeFrist = VerwaltungDbAccess.ermittleBindeFristTage(marktId);
            transferableMap.setValue("bindeFrist", new Integer(bindeFrist));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void speichereAnfrage(TrfZubVerwaltung transferableMap) {
        try {
            Anfrage anfrage = (Anfrage)transferableMap.getValue("anfrage");
            anfrage = VerwaltungDbAccess.speichereAnfrage(anfrage);
            transferableMap.setValue("anfrage", anfrage);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ueberarbeiteAngebot(TrfZubVerwaltung transferableMap) {
        try {
            String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
            String aktuellerNutzer = this.sessionInfo.getUserInfo().getID();
            String sprache = this.sessionInfo.getUserInfo().getSprache();
            String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
            String konfigName = (String)transferableMap.getValue("konfigurationTEXT");
            boolean forceCopyKonfig = false;
            webetk.app.zub.verwaltung.Konfiguration konfig = (webetk.app.zub.verwaltung.Konfiguration)transferableMap.getValue("konfiguration");
            if (transferableMap.getValue("ForceCopyKonfig") != null) {
                forceCopyKonfig = (Boolean)transferableMap.getValue("ForceCopyKonfig");
            }
            if (konfig == null) {
                konfig = VerwaltungDbAccess.ermittleKonfigurationAusAngebot((Angebot)transferableMap.getValue("angebot"), firmaId, aktuellerNutzer, sprache, regIso);
            }
            Anfrage anfrage = VerwaltungDbAccess.ladeAnfrage(aktuellerNutzer, firmaId, konfig.getAnfrageId(), sprache, regIso, true);
            int newIndex = 1;
            if (anfrage.getVorgang().getKonfigurationsId() != null) {
                newIndex = anfrage.getVorgang().getKonfigurationsId().size();
            }
            String lastKonfigName = "";
            lastKonfigName = anfrage.getVorgang().getKonfigurationsNamen() == null ? (anfrage.getVorgang().getKonfiguration() == null ? konfig.getKonfigurationsName() : anfrage.getVorgang().getKonfiguration().getKonfigurationsName()) : anfrage.getVorgang().getKonfigurationsNamen().get(newIndex - 1);
            int pos = lastKonfigName.lastIndexOf(" ");
            int posIndex = Integer.parseInt(lastKonfigName.substring(pos + 1, lastKonfigName.length()));
            konfigName = konfigName + " " + (posIndex + 1);
            konfig = VerwaltungDbAccess.ueberArbeiteAngebot(konfig, aktuellerNutzer, firmaId, forceCopyKonfig, konfigName);
            anfrage = VerwaltungDbAccess.ladeAnfrage(aktuellerNutzer, firmaId, konfig.getAnfrageId(), sprache, regIso, false);
            anfrage.getVorgang().setKonfiguration(konfig);
            transferableMap.setValue("konfiguration", konfig);
            transferableMap.setValue("anfrage", anfrage);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void entsperreAnfrage(TrfZubVerwaltung transferableMap) {
        try {
            String userId = this.sessionInfo.getUserInfo().getID();
            Integer anfrageId = null;
            anfrageId = (Integer)transferableMap.getValue("anfrageId");
            VerwaltungDbAccess.entsperreAnfrage(anfrageId, userId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void sucheAngebote(TrfZubVerwaltung transferableMap) {
        try {
            String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
            String filialId = this.sessionInfo.getUserInfo().getFilialeID();
            String aktuellerNutzer = this.sessionInfo.getUserInfo().getID();
            String kundenNameSuche = (String)transferableMap.getValue("kundenname");
            String kundenNrSuche = (String)transferableMap.getValue("kundenId");
            String produktBenennungSuche = (String)transferableMap.getValue("Produktbenennung");
            String erstellungsDatumVon = (String)transferableMap.getValue("Erstellungsdatum_von");
            String erstellungsDatumBis = (String)transferableMap.getValue("Erstellungsdatum_bis");
            String angebotsNr = (String)transferableMap.getValue("AngebotsNr");
            String ersteller = (String)transferableMap.getValue("Ersteller");
            Boolean alleFilialenSuche = (Boolean)transferableMap.getValue("AlleFilialen");
            Boolean eigenerNutzerSuche = (Boolean)transferableMap.getValue("NurEigeneAnfragen");
            String vin = (String)transferableMap.getValue("vin");
            Integer bindefrist = (Integer)transferableMap.getValue("bindeFrist");
            Boolean ispaSuche = (Boolean)transferableMap.getValue("ispasuche");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KUNDENNAME", kundenNameSuche);
            map.put("KUNDENNUMMER", kundenNrSuche);
            map.put("PRODUKTBENENNUNG", produktBenennungSuche);
            map.put("ERSTELLUNGSDATUM_VON", erstellungsDatumVon);
            map.put("ERSTELLUNGSDATUM_BIS", erstellungsDatumBis);
            map.put("ANGEBOTSNUMMER", angebotsNr);
            map.put("ERSTELLER", ersteller);
            map.put("ALLE_FILIALEN_SUCHEN", alleFilialenSuche);
            map.put("NUR_EIGENE_ANFRAGEN", eigenerNutzerSuche);
            map.put("VIN", vin);
            map.put("BINDEFRIST", bindefrist);
            map.put("ISPA_SUCHE", ispaSuche);
            List liste = VerwaltungDbAccess.sucheAngebote(map, filialId, aktuellerNutzer, firmaId, this.sessionInfo.getUserMarken(), this.sessionInfo.getUserProdukte());
            transferableMap.setValue("AngebotsErgebnisse", liste);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void sucheAnfragen(TrfZubVerwaltung transferableMap) {
        try {
            String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
            String filialId = this.sessionInfo.getUserInfo().getFilialeID();
            Collection<String> userMarken = this.sessionInfo.getUserMarken();
            Collection<String> userProdukte = this.sessionInfo.getUserProdukte();
            String aktuellerNutzer = this.sessionInfo.getUserInfo().getID();
            String kundenNameSuche = (String)transferableMap.getValue("kundenname");
            String kundenNrSuche = (String)transferableMap.getValue("kundenId");
            String produktBenennungSuche = (String)transferableMap.getValue("Produktbenennung");
            String erstellungsDatumVon = (String)transferableMap.getValue("Erstellungsdatum_von");
            String erstellungsDatumBis = (String)transferableMap.getValue("Erstellungsdatum_bis");
            String vinSuche = (String)transferableMap.getValue("vin");
            String ersteller = (String)transferableMap.getValue("Ersteller");
            Boolean alleFilialenSuche = (Boolean)transferableMap.getValue("AlleFilialen");
            Boolean eigenerNutzerSuche = (Boolean)transferableMap.getValue("NurEigeneAnfragen");
            Boolean ispaSuche = (Boolean)transferableMap.getValue("ispasuche");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("KUNDENNAME", kundenNameSuche);
            map.put("KUNDENNUMMER", kundenNrSuche);
            map.put("PRODUKTBENENNUNG", produktBenennungSuche);
            map.put("ERSTELLUNGSDATUM_VON", erstellungsDatumVon);
            map.put("ERSTELLUNGSDATUM_BIS", erstellungsDatumBis);
            map.put("VIN", vinSuche);
            map.put("ERSTELLER", ersteller);
            map.put("ALLE_FILIALEN_SUCHEN", alleFilialenSuche);
            map.put("NUR_EIGENE_ANFRAGEN", eigenerNutzerSuche);
            map.put("ISPA_SUCHE", ispaSuche);
            List<AnfrageSuche> liste = VerwaltungDbAccess.sucheAnfragen(map, filialId, aktuellerNutzer, firmaId, userMarken, userProdukte);
            transferableMap.setValue("AnfrageErgebnisse", liste);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void speichereFilialDaten(TrfZubVerwaltung transferableMap) {
        try {
            FilialeZub filiale = (FilialeZub)transferableMap.getValue("filialeZUB");
            VerwaltungDbAccess.speichereFilialDaten(filiale);
            this.sessionInfo.getUserInfo().setMarktId(filiale.getMarktId());
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void listeMaerkte(TrfZubVerwaltung transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            transferableMap.setValue("marktListeIpac", VerwaltungDbAccess.ladeMarktListe(sprache, regIso));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void speichereArbeitKonfig(TrfZubVerwaltung transferableMap) {
        String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
        Collection<String> filialIds = new ArrayList<String>();
        try {
            String filialId = (String)transferableMap.getValue("filialid");
            if (filialId == null) {
                filialIds = VerwaltungDbAccess.getAlleFilialen(firmaId);
            } else {
                filialIds.add(filialId);
            }
            AufwandsKonfiguration konfig = (AufwandsKonfiguration)transferableMap.getValue("arbeitKonfig");
            String produktArt = (String)transferableMap.getValue("produktart");
            String marke = (String)transferableMap.getValue("marke");
            List markeProdArt = VerwaltungDbAccess.getMarkenProduktArtenList(marke, produktArt);
            VerwaltungDbAccess.speichereArbeitenKonfig(firmaId, filialIds, konfig, markeProdArt);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void speichereUserDaten(TrfZubVerwaltung transferableMap) {
        try {
            NutzerZub user = (NutzerZub)transferableMap.getValue("user");
            VerwaltungDbAccess.speichereUserDaten(user);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void listeFilialen(TrfZubVerwaltung transferableMap) {
        String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            if (transferableMap.getValue("firmaid") != null) {
                firmaId = (String)transferableMap.getValue("firmaid");
            }
            List filialListe = VerwaltungDbAccess.ladeFilialDaten(firmaId);
            transferableMap.setValue("filialenZUB", filialListe);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleUserInfo(TrfZubVerwaltung transferableMap) {
        String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            String userId = (String)transferableMap.getValue("user_id");
            if (userId == null) {
                throw new InvalidDataException("No Parameter: Constants.HttpRequestParameter.USERID found");
            }
            NutzerZub user = VerwaltungDbAccess.ladeUserDaten(userId, firmaId);
            transferableMap.setValue("user", user);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ermittleArbeitKonfig(TrfZubVerwaltung transferableMap) {
        String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
        String filialId = this.sessionInfo.getUserInfo().getFilialeID();
        String marke = this.sessionInfo.getUserInfo().getMarke();
        String produktArt = this.sessionInfo.getUserInfo().getProduktart();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        int marktId = this.sessionInfo.getUserInfo().getMarktId();
        try {
            if (transferableMap.getValue("filialid") != null) {
                filialId = (String)transferableMap.getValue("filialid");
            }
            if (transferableMap.getValue("marke") != null) {
                marke = (String)transferableMap.getValue("marke");
            }
            if (transferableMap.getValue("produktart") != null) {
                produktArt = (String)transferableMap.getValue("produktart");
            }
            transferableMap.setValue("arbeitKonfig", VerwaltungDbAccess.ladeAWKonfiguration(firmaId, filialId, marke, produktArt, marktId, sprache, regIso));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void druckeBerichtEmail(TrfZubVerwaltung transferableMap) {
        try {
            byte[] pdfContent = (byte[])transferableMap.getValue("berichtsInhalt");
            String empfaengerName = (String)transferableMap.getValue("empfaenger");
            String empfaengerEmail = (String)transferableMap.getValue("empfaengerMail");
            String senderMail = (String)transferableMap.getValue("sender");
            String betreff = (String)transferableMap.getValue("betreff");
            String freiText = (String)transferableMap.getValue("freiTextEmail");
            String attachmentName = (String)transferableMap.getValue("attachmentName");
            String sFirma = this.sessionInfo.getUserInfo().getFirmaID();
            String sFiliale = this.sessionInfo.getUserInfo().getFilialeID();
            Konfiguration oKonfiguration = new Konfiguration(sFirma, sFiliale);
            oKonfiguration.loadKonfiguration();
            String sMailHost = oKonfiguration.getMailserver();
            this.sendeBerichtsMail(sMailHost, pdfContent, attachmentName, empfaengerName, empfaengerEmail, senderMail, betreff, freiText);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    protected void sendeBerichtsMail(String sMailHost, byte[] berichtsDaten, String sBerichtsName, String anName, String sAnEMail, String sVonEMail, String sBetreff, String sFreitext) throws Exception {
        Logger.getLogger(this.getClass()).debug("Sending mail");
        Properties props = System.getProperties();
        props.put("mail.smtp.host", sMailHost);
        Logger.getLogger(this.getClass()).debug("MailHost: " + sMailHost);
        Session objSession = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(objSession);
        Logger.getLogger(this.getClass()).debug("created MimeMessage");
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)sAnEMail));
        if (sVonEMail.length() > 0) {
            msg.setFrom((Address)new InternetAddress(sVonEMail));
        }
        msg.setSubject(sBetreff);
        msg.setSentDate(new Date());
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setText(sFreitext);
        MimeBodyPart mbp2 = null;
        if (berichtsDaten != null) {
            mbp2 = new MimeBodyPart();
            mbp2.setDisposition("attachment");
            mbp2.setFileName(sBerichtsName);
            ByteArrayDataSource ds = new ByteArrayDataSource(berichtsDaten);
            mbp2.setDataHandler(new DataHandler((DataSource)ds));
        }
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        if (mbp2 != null) {
            mp.addBodyPart((BodyPart)mbp2);
        }
        msg.setContent((Multipart)mp);
        Logger.getLogger(this.getClass()).debug("sending mail");
        Transport.send((Message)msg);
    }

    private void ladeVorgangBedingungen(TrfZubVerwaltung transferableMap) {
        try {
            Anfrage anfrage = (Anfrage)transferableMap.getValue("anfrage");
            VerwaltungDbAccess.ermittleBedingungsListe(anfrage.getVorgang().getFahrzeug(), anfrage.getVorgang().getVorgangsId());
            transferableMap.setValue("anfrage", anfrage);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeAnfrage(TrfZubVerwaltung transferableMap) {
        String userId = this.sessionInfo.getUserInfo().getID();
        String firma = this.sessionInfo.getUserInfo().getFirmaID();
        String iso = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            int anfrageId = (Integer)transferableMap.getValue("anfrageId");
            Anfrage anfrage = VerwaltungDbAccess.ladeAnfrage(userId, firma, anfrageId, iso, regIso, false);
            this.sessionInfo.getUserInfo().setMarke(anfrage.getMarke());
            this.sessionInfo.getUserInfo().setProduktart(String.valueOf(anfrage.getProduktArt()));
            String sVINSpecKontaktieren = (String)transferableMap.getValue("vinspec_schnittstelle_kontaktieren");
            String sIGDOMKontaktieren = (String)transferableMap.getValue("igdom_schnittstelle_kontaktieren");
            this.komplettiereFahrzeugZuVorgang(anfrage.getVorgang(), sVINSpecKontaktieren, sIGDOMKontaktieren);
            transferableMap.setValue("anfrage", anfrage);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeVorgang(TrfZubVerwaltung transferableMap) {
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            int vorgangsId = (Integer)transferableMap.getValue("vorgangsId");
            Vorgang vorgang = VerwaltungDbAccess.ladeVorgang(this.sessionInfo.getUserInfo().getID(), this.sessionInfo.getUserInfo().getFirmaID(), vorgangsId, sprache, regIso);
            String sVINSpecKontaktieren = (String)transferableMap.getValue("vinspec_schnittstelle_kontaktieren");
            String sIGDOMKontaktieren = (String)transferableMap.getValue("igdom_schnittstelle_kontaktieren");
            this.komplettiereFahrzeugZuVorgang(vorgang, sVINSpecKontaktieren, sIGDOMKontaktieren);
            transferableMap.setValue("vorgang", vorgang);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void komplettiereFahrzeugZuVorgang(Vorgang vorgang, String sVINSpecKontaktieren, String sIGDOMKontaktieren) throws Exception {
        Fahrzeug fahrzeug = vorgang.getFahrzeug();
        if (fahrzeug == null) {
            return;
        }
        TrfFahrzeugId trfFI = new TrfFahrzeugId(null);
        String sVollstaendigeFI = "true";
        trfFI.setValue("isvollstaendigefi", sVollstaendigeFI);
        trfFI.setValue("marke", vorgang.getFahrzeug().getMarke());
        trfFI.setValue("produktart", this.sessionInfo.getUserInfo().getProduktart());
        trfFI.setValue("katalogumfang", this.sessionInfo.getUserInfo().getKatalogumfang());
        trfFI.setValue("bauart", vorgang.getFahrzeug().getBauart());
        trfFI.setValue("baureihe", fahrzeug.getBaureihe());
        trfFI.setValue("karosserie", fahrzeug.getKarosserie());
        trfFI.setValue("modell", fahrzeug.getModell());
        trfFI.setValue("region", fahrzeug.getKatalogausf());
        trfFI.setValue("lenkung", fahrzeug.getLenkung());
        trfFI.setValue("getriebe", fahrzeug.getGetriebe());
        trfFI.setValue("baujahr", fahrzeug.getBaujahr());
        trfFI.setValue("zulmonat", fahrzeug.getZulassungsmonat());
        TrfFahrzeugIdCommand cmd = new TrfFahrzeugIdCommand();
        cmd.setEnvironment(this.sessionInfo);
        trfFI.setCommand(Command.RESET_FAHRZEUGIDENTIFIKATION);
        cmd.setTransferable(trfFI);
        cmd.execute();
        if (trfFI.getError() != null) {
            throw trfFI.getError();
        }
        trfFI.setCommand(Command.CHANGE_FAHRZEUGIDENTIFIKATION);
        cmd.setTransferable(trfFI);
        cmd.execute();
        if (trfFI.getError() != null) {
            throw trfFI.getError();
        }
        if (fahrzeug.getFahrgestellnummer() == null || fahrzeug.getFahrgestellnummer().length() == 0) {
            trfFI.setCommand(Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_ATTR);
        } else if (fahrzeug.getFahrgestellnummer() != null || fahrzeug.getFahrgestellnummer().length() == 7) {
            trfFI.setValue("fgstnr", fahrzeug.getFahrgestellnummer());
            trfFI.setCommand(Command.GET_VIN_RESOLVER_VIN17);
        } else {
            trfFI = new TrfFahrzeugId(null);
            trfFI.setValue("isvollstaendigefi", "false");
            trfFI.setValue("fgstnr", fahrzeug.getFahrgestellnummer());
            trfFI.setValue("vinspec_schnittstelle_kontaktieren", sVINSpecKontaktieren);
            trfFI.setValue("igdom_schnittstelle_kontaktieren", sIGDOMKontaktieren);
            trfFI.setCommand(Command.FINALIZE_FAHRZEUGIDENTIFIKATION_WITH_FGSTNR);
        }
        cmd.setTransferable(trfFI);
        cmd.execute();
        if (trfFI.getError() != null) {
            throw trfFI.getError();
        }
        JavaFzgIdInfo oFzgIdInfo = (JavaFzgIdInfo)trfFI.getValue("fzgidinfo_java");
        FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)trfFI.getValue("fzgsucheinfo_app");
        fahrzeug.setModellspalte(oFzgIdInfo.getModellspalte());
        if (oFzgIdInfo.getBaureiheBezeichnung() != null && oFzgIdInfo.getBaureiheBezeichnung().length() > 0) {
            fahrzeug.setBauartBezeichnung(oFzgIdInfo.getBauartBezeichnung());
        }
        if (oFzgIdInfo.getBaureiheBezeichnung() != null && oFzgIdInfo.getBaureiheBezeichnung().length() > 0) {
            fahrzeug.setBaureiheBezeichnung(oFzgIdInfo.getBaureiheBezeichnung());
        }
        if (oFzgIdInfo.getKarosserieBezeichnung() != null && oFzgIdInfo.getKarosserieBezeichnung().length() > 0) {
            fahrzeug.setKarosserieBezeichnung(oFzgIdInfo.getKarosserieBezeichnung());
        }
        if (oFzgIdInfo.getTypmenge() != null) {
            fahrzeug.setTypmenge(oFzgIdInfo.getTypmenge());
        }
        fahrzeug.setFzgIdString(oFzgSucheInfo.getFzgIdString());
        if (oFzgSucheInfo.getAusstattung() != null) {
            fahrzeug.setAusstattung(oFzgSucheInfo.getAusstattung());
        }
        vorgang.setFahrzeug(fahrzeug);
    }

    private void ladeKonfiguration(TrfZubVerwaltung transferableMap) {
        String userId = this.sessionInfo.getUserInfo().getID();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            int konfigurationsId = (Integer)transferableMap.getValue("konfigurationsId");
            webetk.app.zub.verwaltung.Konfiguration konfiguration = VerwaltungDbAccess.ladeKonfiguration(userId, this.sessionInfo.getUserInfo().getFirmaID(), konfigurationsId, sprache, regIso);
            transferableMap.setValue("konfiguration", konfiguration);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void ladeAngebot(TrfZubVerwaltung transferableMap) {
        String userId = this.sessionInfo.getUserInfo().getID();
        String sprache = this.sessionInfo.getUserInfo().getSprache();
        String regIso = this.sessionInfo.getUserInfo().getSpracheRegion();
        try {
            int konfigurationsId = (Integer)transferableMap.getValue("konfigurationsId");
            Anfrage anfrage = VerwaltungDbAccess.ladeAngebot(this.sessionInfo.getUserInfo().getID(), this.sessionInfo.getUserInfo().getFirmaID(), konfigurationsId, userId, sprache, regIso);
            transferableMap.setValue("anfrage", anfrage);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void speichereKonfiguration(TrfZubVerwaltung transferableMap) {
        try {
            Anfrage anfrage = (Anfrage)transferableMap.getValue("anfrage");
            List addPositions = (List)transferableMap.getValue("addPos");
            List updatePositions = (List)transferableMap.getValue("updatePos");
            List deletePositions = (List)transferableMap.getValue("deletePos");
            anfrage = VerwaltungDbAccess.speichereKonfiguration(anfrage, addPositions, updatePositions, deletePositions);
            transferableMap.setValue("anfrage", anfrage);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void speichereAngebot(TrfZubVerwaltung transferableMap) {
        String userId = this.sessionInfo.getUserInfo().getID();
        String firmaId = this.sessionInfo.getUserInfo().getFirmaID();
        try {
            int konfigurationsId = (Integer)transferableMap.getValue("konfigurationsId");
            Angebot angebot = (Angebot)transferableMap.getValue("angebot");
            webetk.app.zub.verwaltung.Konfiguration konfig = (webetk.app.zub.verwaltung.Konfiguration)transferableMap.getValue("konfiguration");
            VerwaltungDbAccess.speichereAngebot(konfigurationsId, angebot, userId, firmaId);
            VerwaltungDbAccess.setzeMwSteuerAngebot(konfig);
            try {
                VerwaltungDbAccess.entsperreAnfrage(new Integer(konfig.getAnfrageId()), userId);
            }
            catch (ObjectLockedException e) {
                log.warn("Kein Entsperren der dem Angebot zugrundeliegenden Anfrage m\u00f6glich!!");
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void speichereKunde(TrfZubVerwaltung transferableMap) {
        try {
            Kunde kunde = (Kunde)transferableMap.getValue("kunde");
            if (kunde != null) {
                if ((kunde = VerwaltungDbAccess.speichereKunde(kunde)).getFahrzeuge() != null) {
                    for (Fahrzeug fahrzeug : kunde.getFahrzeuge()) {
                        VerwaltungDbAccess.speichereKundenfahrzeug(kunde.getKundenId(), fahrzeug);
                    }
                }
                transferableMap.setValue("kunde", kunde);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
            e.printStackTrace();
        }
    }

    private void speichereKundenfahrzeug(TrfZubVerwaltung transferableMap) {
        try {
            int kundenId = (Integer)transferableMap.getValue("kundenId");
            Fahrzeug fahrzeug = (Fahrzeug)transferableMap.getValue("fahrzeug");
            VerwaltungDbAccess.speichereKundenfahrzeug(kundenId, fahrzeug);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void loescheAnfrage(TrfZubVerwaltung transferableMap) {
        try {
            int anfrageId = (Integer)transferableMap.getValue("anfrageId");
            VerwaltungDbAccess.loescheAnfrage(anfrageId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void loescheAngebot(TrfZubVerwaltung transferableMap) {
        try {
            int angebotsId = (Integer)transferableMap.getValue("AngebotsNr");
            VerwaltungDbAccess.storniereAngebot(angebotsId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void storniereAngebot(TrfZubVerwaltung transferableMap) {
        try {
            Integer angebotsNr = (Integer)transferableMap.getValue("AngebotsNr");
            if (angebotsNr != null) {
                int angebotsId = angebotsNr;
                VerwaltungDbAccess.storniereAngebot(angebotsId);
                return;
            }
            Integer konfigurationsNr = (Integer)transferableMap.getValue("konfigurationsId");
            if (konfigurationsNr != null) {
                int konfigurationsId = konfigurationsNr;
                VerwaltungDbAccess.storniereAngebotKonfig(konfigurationsId);
            }
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void loescheVorgang(TrfZubVerwaltung transferableMap) {
        try {
            int vorgangsId = (Integer)transferableMap.getValue("vorgangsId");
            VerwaltungDbAccess.loescheVorgang(vorgangsId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void loescheKonfiguration(TrfZubVerwaltung transferableMap) {
        try {
            int konfigurationsId = (Integer)transferableMap.getValue("konfigurationsId");
            VerwaltungDbAccess.loescheKonfiguration(konfigurationsId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void loescheKunde(TrfZubVerwaltung transferableMap) {
        try {
            int kundenId = (Integer)transferableMap.getValue("kundenId");
            VerwaltungDbAccess.loescheKunde(kundenId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void loescheKundenfahrzeug(TrfZubVerwaltung transferableMap) {
        try {
            int kundenId = (Integer)transferableMap.getValue("kundenId");
            String vin = (String)transferableMap.getValue("kundenId");
            VerwaltungDbAccess.loescheKundenfahrzeug(kundenId, vin);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void hatUserAgbBestaetigt(TrfZubVerwaltung transferableMap) {
        String firma = this.sessionInfo.getUserInfo().getFirmaID();
        String user = this.sessionInfo.getUserInfo().getID();
        boolean bAgbBestaetigt = false;
        try {
            bAgbBestaetigt = VerwaltungDbAccess.hatUserAgbBestaetigt(firma, user);
        }
        catch (SQLException e) {
            transferableMap.setError(e);
        }
        catch (DatabaseBusyException e) {
            transferableMap.setError(e);
        }
        transferableMap.setValue("agbBestaetigt", new Boolean(bAgbBestaetigt));
    }

    private void setUserAgbBestaetigt(TrfZubVerwaltung transferableMap) {
        String firma = this.sessionInfo.getUserInfo().getFirmaID();
        String user = this.sessionInfo.getUserInfo().getID();
        Boolean oBestaetigt = (Boolean)transferableMap.getValue("agbBestaetigt");
        boolean bestaetigt = oBestaetigt == null ? true : oBestaetigt;
        try {
            VerwaltungDbAccess.setUserAgbBestaetigt(firma, user, bestaetigt);
        }
        catch (SQLException e) {
            transferableMap.setError(e);
        }
        catch (DatabaseBusyException e) {
            transferableMap.setError(e);
        }
    }

    private void speichereKundenZuordnung(TrfZubVerwaltung map) {
        Anfrage anfrage = (Anfrage)map.getValue("anfrage");
        try {
            VerwaltungDbAccess.speichereKundenZuordnung(anfrage);
        }
        catch (Exception e) {
            map.setError(e);
        }
    }

    private void ermittleAnzahlKonfigVonVorgang(TrfZubVerwaltung transferableMap) {
        int vorgangsId = (Integer)transferableMap.getValue("vorgangsId");
        try {
            int countKonfig = VerwaltungDbAccess.ermittleAnzahlKonfigVonVorgang(vorgangsId);
            transferableMap.setValue("anzahlSuchergebnisse", new Integer(countKonfig));
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private void setzeFlagAnIspa(TrfZubVerwaltung transferableMap) {
        int konfigId = (Integer)transferableMap.getValue("konfigurationsId");
        try {
            VerwaltungDbAccess.setzeFlagAnIspa(konfigId);
        }
        catch (Exception e) {
            transferableMap.setError(e);
        }
    }

    private static class ByteArrayDataSource
    implements DataSource {
        private byte[] b;

        public ByteArrayDataSource(byte[] b) {
            this.b = b;
        }

        public InputStream getInputStream() {
            ByteArrayInputStream b1 = new ByteArrayInputStream(this.b);
            return b1;
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public String getName() {
            return "";
        }
    }
}

