/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class UrlEncodedQueryString {
    private static final String PARSE_PARAMETER_SEPARATORS = String.valueOf((Object)Separator.AMPERSAND) + (Object)((Object)Separator.SEMICOLON);
    private final Map<String, List<String>> queryMap = new LinkedHashMap<String, List<String>>();

    public static UrlEncodedQueryString create() {
        return new UrlEncodedQueryString();
    }

    public static UrlEncodedQueryString create(Map<String, List<String>> parameterMap) {
        UrlEncodedQueryString queryString = new UrlEncodedQueryString();
        for (Map.Entry<String, List<String>> entry : parameterMap.entrySet()) {
            queryString.queryMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return queryString;
    }

    public static UrlEncodedQueryString parse(CharSequence query) {
        UrlEncodedQueryString queryString = new UrlEncodedQueryString();
        queryString.appendOrSet(query, true);
        return queryString;
    }

    public static UrlEncodedQueryString parse(URI uri) {
        return UrlEncodedQueryString.parse(uri.getRawQuery());
    }

    public String get(String name) {
        List<String> parameters = this.getValues(name);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return parameters.get(0);
    }

    public boolean contains(String name) {
        return this.queryMap.containsKey(name);
    }

    public Iterator<String> getNames() {
        return this.queryMap.keySet().iterator();
    }

    public List<String> getValues(String name) {
        return this.queryMap.get(name);
    }

    public Map<String, List<String>> getMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.queryMap.entrySet()) {
            List<String> listValues = entry.getValue();
            map.put(entry.getKey(), new ArrayList<String>(listValues));
        }
        return map;
    }

    public UrlEncodedQueryString set(String name, String value) {
        this.appendOrSet(name, value, false);
        return this;
    }

    public UrlEncodedQueryString set(String name, Number value) {
        if (value == null) {
            this.remove(name);
            return this;
        }
        this.appendOrSet(name, value.toString(), false);
        return this;
    }

    public UrlEncodedQueryString set(String query) {
        this.appendOrSet(query, false);
        return this;
    }

    public UrlEncodedQueryString append(String name, String value) {
        this.appendOrSet(name, value, true);
        return this;
    }

    public UrlEncodedQueryString append(String name, Number value) {
        this.appendOrSet(name, value.toString(), true);
        return this;
    }

    public UrlEncodedQueryString append(String query) {
        this.appendOrSet(query, true);
        return this;
    }

    public boolean isEmpty() {
        return this.queryMap.isEmpty();
    }

    public UrlEncodedQueryString remove(String name) {
        this.appendOrSet(name, null, false);
        return this;
    }

    public URI apply(URI uri) {
        return this.apply(uri, Separator.AMPERSAND);
    }

    public URI apply(URI uri, Separator separator) {
        String query;
        StringBuilder builder = new StringBuilder();
        if (uri.getScheme() != null) {
            builder.append(uri.getScheme());
            builder.append(':');
        }
        if (uri.getHost() != null) {
            builder.append("//");
            if (uri.getUserInfo() != null) {
                builder.append(uri.getUserInfo());
                builder.append('@');
            }
            builder.append(uri.getHost());
            if (uri.getPort() != -1) {
                builder.append(':');
                builder.append(uri.getPort());
            }
        } else if (uri.getAuthority() != null) {
            builder.append("//");
            builder.append(uri.getAuthority());
        }
        if (uri.getPath() != null) {
            builder.append(uri.getPath());
        }
        if ((query = this.toString(separator)).length() != 0) {
            builder.append('?');
            builder.append(query);
        }
        if (uri.getFragment() != null) {
            builder.append('#');
            builder.append(uri.getFragment());
        }
        try {
            return new URI(builder.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UrlEncodedQueryString)) {
            return false;
        }
        String query = this.toString();
        String thatQuery = ((UrlEncodedQueryString)obj).toString();
        return query.equals(thatQuery);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.toString(Separator.AMPERSAND);
    }

    public String toString(Separator separator) {
        StringBuilder builder = new StringBuilder();
        for (String name : this.queryMap.keySet()) {
            for (String value : this.queryMap.get(name)) {
                if (builder.length() != 0) {
                    builder.append((Object)separator);
                }
                try {
                    builder.append(URLEncoder.encode(name, "UTF-8"));
                    if (value == null) continue;
                    builder.append('=');
                    builder.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return builder.toString();
    }

    private UrlEncodedQueryString() {
    }

    private void appendOrSet(String name, String value, boolean append) {
        List<String> listValues;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (append) {
            listValues = this.queryMap.get(name);
            if (listValues != null) {
                listValues.add(value);
                return;
            }
        } else if (value == null) {
            this.queryMap.remove(name);
            return;
        }
        listValues = new ArrayList<String>();
        listValues.add(value);
        this.queryMap.put(name, listValues);
    }

    private void appendOrSet(CharSequence parameters, boolean append) {
        if (parameters == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(parameters.toString(), PARSE_PARAMETER_SEPARATORS);
        HashSet<String> setAlreadyParsed = null;
        while (tokenizer.hasMoreTokens()) {
            String parameter = tokenizer.nextToken();
            int indexOf = parameter.indexOf(61);
            try {
                String value;
                String name;
                if (indexOf == -1) {
                    name = parameter;
                    value = null;
                } else {
                    name = parameter.substring(0, indexOf);
                    value = parameter.substring(indexOf + 1);
                }
                name = URLDecoder.decode(name, "UTF-8");
                if (!append) {
                    if (setAlreadyParsed == null) {
                        setAlreadyParsed = new HashSet<String>();
                    }
                    if (!setAlreadyParsed.contains(name)) {
                        this.remove(name);
                    }
                    setAlreadyParsed.add(name);
                }
                if (value != null) {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                this.appendOrSet(name, value, true);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Separator {
        AMPERSAND{

            public String toString() {
                return "&";
            }
        }
        ,
        SEMICOLON{

            public String toString() {
                return ";";
            }
        };

    }
}

