/*
 * Decompiled with CFR 0.152.
 */
package webetk.db;

import org.apache.log4j.Logger;
import webetk.db.ClassLoaderUtil;
import webetk.db.SQLStatements;
import webetk.db.zub.SQLStatements;

public class DbQueryConfigurator {
    private static final Logger log = Logger.getLogger(DbQueryConfigurator.class);

    public void configure() {
        this.configureQueryClasses();
        this.configureZubQueryClasses();
    }

    private void configureQueryClasses() {
        String dbEnv = "".equals(SQLStatements.getDbEnv()) ? "Transbase" : SQLStatements.getDbEnv();
        log.info("configuring DB queries for DB evnironment " + dbEnv);
        String packageAndCLassPrefix = SQLStatements.getPackageAndClassPrefix();
        ClassLoaderUtil classLoaderUtil = new ClassLoaderUtil(dbEnv, packageAndCLassPrefix);
        SQLStatements.Allgemein.instance = classLoaderUtil.createInstance(SQLStatements.Allgemein.class);
        SQLStatements.Wertebereiche.instance = classLoaderUtil.createInstance(SQLStatements.Wertebereiche.class);
        SQLStatements.Einstellungen.instance = classLoaderUtil.createInstance(SQLStatements.Einstellungen.class);
        SQLStatements.FzgIdentifikation.instance = classLoaderUtil.createInstance(SQLStatements.FzgIdentifikation.class);
        SQLStatements.FzgUmfang.instance = classLoaderUtil.createInstance(SQLStatements.FzgUmfang.class);
        SQLStatements.TeilesucheSpezifischValueLineFzg.instance = classLoaderUtil.createInstance(SQLStatements.TeilesucheSpezifischValueLineFzg.class);
        SQLStatements.TeilesucheFzg.instance = classLoaderUtil.createInstance(SQLStatements.TeilesucheFzg.class);
        SQLStatements.TeilesucheAllgemein.instance = classLoaderUtil.createInstance(SQLStatements.TeilesucheAllgemein.class);
        SQLStatements.TeilesucheAss.instance = classLoaderUtil.createInstance(SQLStatements.TeilesucheAss.class);
        SQLStatements.Teileinfo.instance = classLoaderUtil.createInstance(SQLStatements.Teileinfo.class);
        SQLStatements.TeileinfoHTML.instance = classLoaderUtil.createInstance(SQLStatements.TeileinfoHTML.class);
        SQLStatements.TeileinfoJAVA.instance = classLoaderUtil.createInstance(SQLStatements.TeileinfoJAVA.class);
        SQLStatements.BedAuswertung.instance = classLoaderUtil.createInstance(SQLStatements.BedAuswertung.class);
        SQLStatements.BteAnzeige.instance = classLoaderUtil.createInstance(SQLStatements.BteAnzeige.class);
        SQLStatements.Teileliste.instance = classLoaderUtil.createInstance(SQLStatements.Teileliste.class);
        SQLStatements.TeilelisteHTML.instance = classLoaderUtil.createInstance(SQLStatements.TeilelisteHTML.class);
        SQLStatements.TeilelisteJAVA.instance = classLoaderUtil.createInstance(SQLStatements.TeilelisteJAVA.class);
        SQLStatements.TeilelisteHTML_SAP.instance = classLoaderUtil.createInstance(SQLStatements.TeilelisteHTML_SAP.class);
        SQLStatements.TeilelisteJAVA_SAP.instance = classLoaderUtil.createInstance(SQLStatements.TeilelisteJAVA_SAP.class);
        SQLStatements.BTEInfo.instance = classLoaderUtil.createInstance(SQLStatements.BTEInfo.class);
        SQLStatements.Polstercode.instance = classLoaderUtil.createInstance(SQLStatements.Polstercode.class);
        SQLStatements.Interpretation.instance = classLoaderUtil.createInstance(SQLStatements.Interpretation.class);
        SQLStatements.SatzEinzelteile.instance = classLoaderUtil.createInstance(SQLStatements.SatzEinzelteile.class);
        SQLStatements.Aspg.instance = classLoaderUtil.createInstance(SQLStatements.Aspg.class);
        SQLStatements.ValueLine.instance = classLoaderUtil.createInstance(SQLStatements.ValueLine.class);
        SQLStatements.Teileersetzung.instance = classLoaderUtil.createInstance(SQLStatements.Teileersetzung.class);
        SQLStatements.VisualisierungTeil.instance = classLoaderUtil.createInstance(SQLStatements.VisualisierungTeil.class);
        SQLStatements.TeileverwendungReduziert.instance = classLoaderUtil.createInstance(SQLStatements.TeileverwendungReduziert.class);
        SQLStatements.TeilevwdgFzg.instance = classLoaderUtil.createInstance(SQLStatements.TeilevwdgFzg.class);
        SQLStatements.TechnischeLiteratur.instance = classLoaderUtil.createInstance(SQLStatements.TechnischeLiteratur.class);
        SQLStatements.Erstbevorratung.instance = classLoaderUtil.createInstance(SQLStatements.Erstbevorratung.class);
        SQLStatements.Lagerzeit.instance = classLoaderUtil.createInstance(SQLStatements.Lagerzeit.class);
        SQLStatements.Notizuebersicht.instance = classLoaderUtil.createInstance(SQLStatements.Notizuebersicht.class);
        SQLStatements.NotizuebersichtHTML.instance = classLoaderUtil.createInstance(SQLStatements.NotizuebersichtHTML.class);
        SQLStatements.NotizuebersichtJAVA.instance = classLoaderUtil.createInstance(SQLStatements.NotizuebersichtJAVA.class);
        SQLStatements.Normteile.instance = classLoaderUtil.createInstance(SQLStatements.Normteile.class);
        SQLStatements.Fuellmengen.instance = classLoaderUtil.createInstance(SQLStatements.Fuellmengen.class);
        SQLStatements.Federtabelle.instance = classLoaderUtil.createInstance(SQLStatements.Federtabelle.class);
        SQLStatements.TeilevwdgTeil.instance = classLoaderUtil.createInstance(SQLStatements.TeilevwdgTeil.class);
        SQLStatements.TeilevwdgBen.instance = classLoaderUtil.createInstance(SQLStatements.TeilevwdgBen.class);
        SQLStatements.Hilfe.instance = classLoaderUtil.createInstance(SQLStatements.Hilfe.class);
        SQLStatements.Firmenkonfiguration.instance = classLoaderUtil.createInstance(SQLStatements.Firmenkonfiguration.class);
        SQLStatements.News.instance = classLoaderUtil.createInstance(SQLStatements.News.class);
        SQLStatements.Infotool.instance = classLoaderUtil.createInstance(SQLStatements.Infotool.class);
        SQLStatements.Admintool.instance = classLoaderUtil.createInstance(SQLStatements.Admintool.class);
        SQLStatements.LoginInfo.instance = classLoaderUtil.createInstance(SQLStatements.LoginInfo.class);
        SQLStatements.TabellenKonfiguration.instance = classLoaderUtil.createInstance(SQLStatements.TabellenKonfiguration.class);
        SQLStatements.MailOptions.instance = classLoaderUtil.createInstance(SQLStatements.MailOptions.class);
        SQLStatements.PerformanceLog.instance = classLoaderUtil.createInstance(SQLStatements.PerformanceLog.class);
        SQLStatements.ETKTexte.instance = classLoaderUtil.createInstance(SQLStatements.ETKTexte.class);
    }

    private void configureZubQueryClasses() {
        String dbEnvOrig = webetk.db.zub.SQLStatements.getDbEnv();
        String dbEnv = "".equals(dbEnvOrig) ? "Transbase" : dbEnvOrig;
        log.info("configuring IPAC DB queries for DB evnironment " + dbEnv);
        String packageAndCLassPrefix = webetk.db.zub.SQLStatements.getPackageAndClassPrefix();
        ClassLoaderUtil classLoaderUtil = new ClassLoaderUtil(dbEnv, packageAndCLassPrefix);
        SQLStatements.Listenfueller.instance = classLoaderUtil.createInstance(SQLStatements.Listenfueller.class);
        SQLStatements.FahrzeugIdentifikation.instance = classLoaderUtil.createInstance(SQLStatements.FahrzeugIdentifikation.class);
        SQLStatements.KundenIdentifikation.instance = classLoaderUtil.createInstance(SQLStatements.KundenIdentifikation.class);
        SQLStatements.ProduktSuche.instance = classLoaderUtil.createInstance(SQLStatements.ProduktSuche.class);
        SQLStatements.MarketingSicht.instance = classLoaderUtil.createInstance(SQLStatements.MarketingSicht.class);
        SQLStatements.TechnischeSicht.instance = classLoaderUtil.createInstance(SQLStatements.TechnischeSicht.class);
        SQLStatements.AnfrageVorgangsHelper.instance = classLoaderUtil.createInstance(SQLStatements.AnfrageVorgangsHelper.class);
        SQLStatements.AngebotsHelper.instance = classLoaderUtil.createInstance(SQLStatements.AngebotsHelper.class);
        SQLStatements.KonfigurationsHelper.instance = classLoaderUtil.createInstance(SQLStatements.KonfigurationsHelper.class);
        SQLStatements.Preise.instance = classLoaderUtil.createInstance(SQLStatements.Preise.class);
        SQLStatements.Verwaltung.instance = classLoaderUtil.createInstance(SQLStatements.Verwaltung.class);
        SQLStatements.Admin.instance = classLoaderUtil.createInstance(SQLStatements.Admin.class);
        SQLStatements.BestehendeAnfrage.instance = classLoaderUtil.createInstance(SQLStatements.BestehendeAnfrage.class);
        SQLStatements.BestehendeAngebote.instance = classLoaderUtil.createInstance(SQLStatements.BestehendeAngebote.class);
        SQLStatements.Texte.instance = classLoaderUtil.createInstance(SQLStatements.Texte.class);
        SQLStatements.Nutzer.instance = classLoaderUtil.createInstance(SQLStatements.Nutzer.class);
    }
}

