/*
 * Decompiled with CFR 0.152.
 */
package webetk.db;

import org.apache.log4j.Logger;
import webetk.InvalidDatabaseEnvironmentException;

public abstract class SQLStatements {
    private static final Logger log = Logger.getLogger(SQLStatements.class);
    public static final String TRANSBASE_DB = "Transbase";
    public static final String ORACLE_DB = "Oracle";
    public static final String DEFAULT_DB_ENV = "Transbase";
    private static String msDbEnv = "";
    private static String msPackageAndClassPrefix = "webetk.db.SQLStatements";

    public static void setDbEnvironment(String pDbEnv) throws InvalidDatabaseEnvironmentException {
        if (pDbEnv.equalsIgnoreCase("Transbase") || pDbEnv.equalsIgnoreCase(ORACLE_DB)) {
            if (log.isInfoEnabled()) {
                log.info("database environment for : " + pDbEnv + " is set.");
            }
        } else {
            log.error(" no valid database environment : " + pDbEnv + " are set!");
            throw new InvalidDatabaseEnvironmentException(" no valid database environment : " + pDbEnv + " are set!");
        }
        msDbEnv = pDbEnv;
    }

    public static String getPackageAndClassPrefix() {
        return msPackageAndClassPrefix;
    }

    public static String getDbEnv() {
        return msDbEnv;
    }

    public static abstract class ETKTexte {
        public static ETKTexte instance;

        public abstract String RETRIEVE_ETKTEXTE();

        public abstract String RETRIEVE_ETKTEXTE_KOMMENTARE();
    }

    public static abstract class PerformanceLog {
        public static PerformanceLog instance;

        public abstract String GET_NEXT_REQUESTID_SEQ_VAL();

        public abstract String LOAD_LOG_PERFORMANCE_FLAG();

        public abstract String WRITE_PERFORMANCE_LOG();
    }

    public static abstract class MailOptions {
        public static MailOptions instance;

        public abstract String LOAD_ABSENDER_UND_EMPFAENGER();

        public abstract String INSERT_ABSENDER();

        public abstract String DELETE_ABSENDER();

        public abstract String INSERT_EMPFAENGER();

        public abstract String DELETE_EMPAENGER();
    }

    public static abstract class TabellenKonfiguration {
        public static TabellenKonfiguration instance;

        public abstract String LOAD_KONFIG();

        public abstract String INSERT_SPALTE();

        public abstract String DELETE_KONFIG();
    }

    public static abstract class LoginInfo {
        public static LoginInfo instance;

        public abstract String LOAD_SINGLE_USER_LOGIN_INFO();

        public abstract String INSERT_NEW_LOGIN_INFO();

        public abstract String UPDATE_LOGIN_INFO();

        public abstract String UPDATE_LOGIN_INFO_LOGOUT();

        public abstract String GET_LOGGEDIN_USERS();

        public abstract String GET_INACTIVE_USERS();
    }

    public static abstract class Admintool {
        public static Admintool instance;

        public abstract String LOAD_FIRMEN();

        public abstract String DELETE_PRICES();

        public abstract String DELETE_PRICES_BY_FIRMA();

        public abstract String ERMITTLE_NUTZERTABELLEN();

        public abstract String ERMITTLE_NUTZERSEQUENZEN();

        public abstract String DROP_SEQUENCE();

        public abstract String DROP_TABLE();

        public abstract String GET_COUNT_FIRMA_PREISE();

        public abstract String GET_DISTINCT_FIRMA_PREISE();

        public abstract String LOCK_TABLE();

        public abstract String UNLOCK_TABLE();

        public abstract String INSERT_PRICES();

        public abstract String UPDATE_PRICES();

        public abstract String LOAD_SPRACHEN();

        public abstract String LOAD_DBVERSIONSINFO();

        public abstract String PRICE_FIELD_getName(int var1);

        public abstract boolean PRICE_FIELD_getIsQuoted(int var1);
    }

    public static abstract class Infotool {
        public static Infotool instance;

        public abstract String INSERT_USER_TIPP();

        public abstract String DELETE_USER_TIPP();

        public abstract String LOAD_TIPPS_TRICKS();

        public abstract String COUNT_TIPPS_TRICKS();

        public abstract String COUNT_TICKER();
    }

    public static abstract class News {
        public static News instance;

        public abstract String INSERT_NEWSTEXT();

        public abstract String UPDATE_NEWSTEXT();

        public abstract String LOAD_NEWSTEXTE();

        public abstract String LOAD_NEWSTEXTE_MARKEN();

        public abstract String DELETE_NEWSTEXT();

        public abstract String UPDATE_NEWSTEXT_AKTIVIERUNG();

        public abstract String DELETE_IMAGE();

        public abstract String INSERT_IMAGE();

        public abstract String LOAD_IMAGE();

        public abstract String LOAD_IMAGE_MARKEN();

        public abstract String UPDATE_IMAGE();
    }

    public static abstract class Firmenkonfiguration {
        public static Firmenkonfiguration instance;

        public abstract String RETRIEVE_FIRMEN();

        public abstract String RETRIEVE_FILIALEN();

        public abstract String RETRIEVE_COUNT_FILIALEN_IN_FIRMA();

        public abstract String RETRIEVE_INFO_FILIALE();

        public abstract String RETRIEVE_EXIST_USER();

        public abstract String RETRIEVE_DMS_VERWENDEN();

        public abstract String LOAD_KONFIGURATION();

        public abstract String DELETE_KONFIGURATION();

        public abstract String DELETE_ZUB_KONFIGURATION();

        public abstract String INSERT_KONFIGURATION();

        public abstract String UPDATE_KONFIGURATION();

        public abstract String SELECT_RECHNUNGSNUMMER_FOR_UPDATE();

        public abstract String UPDATE_RECHNUNGSNUMMER();

        public abstract String UPDATE_FIRMENBEZEICHNUNG();

        public abstract String INSERT_FILIALE();

        public abstract String DELETE_FILIALE();

        public abstract String UPDATE_FILIALE();

        public abstract String RETRIEVE_FILIALEN_SPRACHEN();

        public abstract String RETRIEVE_ANZAHL_NUTZER();

        public abstract String RETRIEVE_MATCHING_NUTZER();

        public abstract String RETRIEVE_NUTZER();

        public abstract String RETRIEVE_SINGLE_NUTZER();

        public abstract String RETRIEVE_BERECHTIGUNEN();

        public abstract String RETRIEVE_SPRACHEN();

        public abstract String RETRIEVE_FUNKTIONSRECHTE();

        public abstract String RETRIEVE_NUTZER_FUNKTIONSRECHTE();

        public abstract String RETRIEVE_NUTZER_BERECHTIGUNGEN();

        public abstract String DELETE_NUTZER_BERECHTIGUNGEN();

        public abstract String DELETE_NUTZER_FUNKTIONSRECHTE();

        public abstract String DELETE_NUTZER_EINSTELLUNGEN();

        public abstract String DELETE_ZUB_NUTZER();

        public abstract String DELETE_NUTZER_EINSTELLUNGEN_REGION();

        public abstract String DELETE_NUTZER();

        public abstract String DELETE_NUTZER_TEILELISTEPOS();

        public abstract String DELETE_NUTZER_TEILELISTE();

        public abstract String DELETE_NUTZER_TEILELISTE_SENDEINFO();

        public abstract String DELETE_NUTZER_TEILEINFO();

        public abstract String RETRIEVE_EXIST_USER_ID();

        public abstract String STORE_NUTZER();

        public abstract String STORE_NUTZER_BERECHTIGUNGEN();

        public abstract String STORE_NUTZER_FUNKTIONSRECHTE();

        public abstract String UPDATE_NUTZER();

        public abstract String MOVE_TEILELISTEN();

        public abstract String MOVE_TEILELISTENPOS();

        public abstract String MOVE_TEILELISTENSI();

        public abstract String RETRIEVE_USERINFO();

        public abstract String UPDATE_DEFAULT_FILIALE();

        public abstract String RETRIEVE_EINEFIRMAFILIALENUTZER();

        public abstract String RETRIEVE_USER_BY_DEFAULT_FILIALE();

        public abstract String RETRIEVE_BESTELLLISTE_POSITIONEN();

        public abstract String RETRIEVE_TEILELISTE_POSITIONEN();

        public abstract String DELETE_ALL_AUFTRAEGE();

        public abstract String DELETE_ALL_TEILELISTEN();

        public abstract String DELETE_ALL_TEILELISTEN_POSITIONEN();

        public abstract String DELETE_ALL_TEILELISTEN_SI();

        public abstract String DELETE_ALL_BESTELLLISTEN();

        public abstract String DELETE_ALL_BESTELLLISTEN_POSITIONEN();

        public abstract String EXISTIERT_FILIAL_ZUB();

        public abstract String UPDATE_MARKTID_NUTZER_VON_FILIALE();
    }

    public static abstract class Hilfe {
        public static Hilfe instance;

        public abstract String RETRIEVE_ABKUERZUNGEN();

        public abstract String RETRIEVE_VERSIONSINFO();

        public abstract String RETRIEVE_BEDEUTUNGEN();

        public abstract String RETRIEVE_SALAPAS();
    }

    public static abstract class TeilevwdgBen {
        public static TeilevwdgBen instance;

        public abstract String RETRIEVE_BAUREIHEN();

        public abstract String RETRIEVE_BAUREIHEN_SONDERLOCKE();

        public abstract String RETRIEVE_BAUREIHEN_TR();

        public abstract String RETRIEVE_MODELLSPALTEN();

        public abstract String RETRIEVE_MODELLSPALTEN_SONDERLOCKE();

        public abstract String MODELLSPALTEN_STMT();

        public abstract String RETRIEVE_BAUREIHEN_TNR();

        public abstract String RETRIEVE_MODELLSPALTEN_TNR();

        public abstract String SEARCH_SNR_TVBENENNUNG();

        public abstract String SEARCH_SNR_TVBENENNUNG_SONDERLOCKE();

        public abstract String SEARCH_BT_SACHNUMMERN_TVBEN();
    }

    public static abstract class TeilevwdgTeil {
        public static TeilevwdgTeil instance;

        public abstract String RETRIEVE_TEIL_ZU_MARKE_PROD();

        public abstract String RETRIEVE_TEIL();

        public abstract String RETRIEVE_BAUREIHEN();

        public abstract String RETRIEVE_MODELLSPALTEN();

        public abstract String MODELLSPALTEN_STMT();
    }

    public static abstract class Federtabelle {
        public static Federtabelle instance;

        public abstract String LOAD_SALAS();

        public abstract String LOAD_PUNKTE_TYP();

        public abstract String LOAD_PUNKTE_SALA();

        public abstract String SFT_PRODDATUM_YYYYMM();

        public abstract String SFT_PRODDATUM_YYYYMMDD();

        public abstract String LOAD_FEDERN_LINKS();

        public abstract String LOAD_FEDERN_RECHTS();

        public abstract String LOAD_ASPG_KIT();
    }

    public static abstract class Fuellmengen {
        public static Fuellmengen instance;

        public abstract String RETRIEVE_FUELLMENGEN();
    }

    public static abstract class Normteile {
        public static Normteile instance;

        public abstract String RETRIEVE_BENENNUNGEN();

        public abstract String RETRIEVE_TEILE_ZU_BENENNUNG();

        public abstract String TEXTCODE_GLEICH_STMT();

        public abstract String TEXTCODE_IN_STMT();

        public abstract String RETRIEVE_TEILE_ZU_NORMNUMMER();

        public abstract String RETRIEVE_NORMNUMMERN_GRUPPEN();

        public abstract String RETRIEVE_NORMNUMMERN();
    }

    public static abstract class NotizuebersichtJAVA {
        public static NotizuebersichtJAVA instance;

        public abstract String RETRIEVE_ANZ_NOTIZEN();

        public abstract String RETRIEVE_ANZ_NOTIZEN_ZU_SACHNUMMER();

        public abstract String RETRIEVE_MIN_HG();

        public abstract String RETRIEVE_NOTIZEN();
    }

    public static abstract class NotizuebersichtHTML {
        public static NotizuebersichtHTML instance;

        public abstract String RETRIEVE_ANZ_NOTIZEN();

        public abstract String RETRIEVE_MIN_HG();

        public abstract String RETRIEVE_NOTIZEN();

        public abstract String HG_STMT();
    }

    public static abstract class Notizuebersicht {
        public static Notizuebersicht instance;

        public abstract String HG_STMT();
    }

    public static abstract class Lagerzeit {
        public static Lagerzeit instance;

        public abstract String RETRIEVE_HGS();

        public abstract String RETRIEVE_TEILE();

        public abstract String HG_BIS_STMT();

        public abstract String TC_CHECK_LANDKUERZEL();
    }

    public static abstract class Erstbevorratung {
        public static Erstbevorratung instance;

        public abstract String RETRIEVE_HGS();

        public abstract String HG_BIS_STMT();

        public abstract String HG_LENKUNG_STMT();

        public abstract String RETRIEVE_TEILE();

        public abstract String TEIL_LENKUNG_STMT();

        public abstract String TC_CHECK_LANDKUERZEL();
    }

    public static abstract class TechnischeLiteratur {
        public static TechnischeLiteratur instance;

        public abstract String RETRIEVE_FGS();

        public abstract String RETRIEVE_SPRACHEN();

        public abstract String LOAD_TECHNISCHE_LITERATUR();

        public abstract String TL_SPRACHE_STMT_GEB();

        public abstract String TL_SPRACHE_STMT_UGB();
    }

    public static abstract class TeilevwdgFzg {
        public static TeilevwdgFzg instance;

        public abstract String RETRIEVE_HGS();

        public abstract String HG_BIS_STMT();

        public abstract String HG_DAT_SERIE_STMT();

        public abstract String HG_LENKUNG_STMT();

        public abstract String RETRIEVE_TEILE_OHNE_LENKUNG();

        public abstract String RETRIEVE_TEILE_MIT_LENKUNG();

        public abstract String TEIL_DAT_SERIE_STMT();

        public abstract String RETRIEVE_TEIL_ONLY_IN_OHNE_LENKUNG();

        public abstract String RETRIEVE_TEIL_ONLY_IN_MIT_LENKUNG();

        public abstract String TC_CHECK_LANDKUERZEL();
    }

    public static abstract class TeileverwendungReduziert {
        public static TeileverwendungReduziert instance;

        public abstract String RETRIEVE_TEIL();

        public abstract String RETRIEVE_VERWENDUNG();
    }

    public static abstract class VisualisierungTeil {
        public static VisualisierungTeil instance;

        public abstract String RETRIEVE_VISUALISIERUNGSINFO_GEB();

        public abstract String RETRIEVE_VISUALISIERUNGSINFO_UGB();
    }

    public static abstract class Teileersetzung {
        public static Teileersetzung instance;

        public abstract String RETRIEVE_HGS();

        public abstract String HG_BIS_STMT();

        public abstract String HG_LENKUNG_STMT();

        public abstract String HG_DAT_SERIE_STMT();

        public abstract String FIND_HG();

        public abstract String RETRIEVE_TEILE();

        public abstract String TEIL_DAT_SERIE_STMT();

        public abstract String TEIL_LENKUNG_STMT();

        public abstract String TC_CHECK_LANDKUERZEL();
    }

    public static abstract class ValueLine {
        public static ValueLine instance;

        public abstract String LOAD_HGS();

        public abstract String LOAD_SAETZE();

        public abstract String TC_CHECK_LANDKUERZEL();

        public abstract String LOAD_BTE_BAUREIHEN();

        public abstract String LOAD_BILDTAFELN();

        public abstract String LOAD_TEILENUMMERN();
    }

    public static abstract class Aspg {
        public static Aspg instance;

        public abstract String LOAD_ASPG_TEILE();

        public abstract String LOAD_STECKER();
    }

    public static abstract class SatzEinzelteile {
        public static SatzEinzelteile instance;

        public abstract String LOAD_HG();

        public abstract String LOAD_SATZ();

        public abstract String COUNT_EINZELTEILE();

        public abstract String LOAD_EINZELTEIL();

        public abstract String TC_CHECK_LANDKUERZEL();
    }

    public static abstract class Interpretation {
        public static Interpretation instance;

        public abstract String EXIST_SACHNUMMER_MARKE();

        public abstract String LOAD_INTERPRETATION_EINSTIEG();

        public abstract String LOAD_INTERPRETATION();
    }

    public static abstract class Polstercode {
        public static Polstercode instance;

        public abstract String LOAD_POLSTERCODE();
    }

    public static abstract class TeilelisteJAVA_SAP {
        public static TeilelisteJAVA_SAP instance;

        public abstract String LOAD_TEILELISTE_HIST();

        public abstract String DELETE_TEILELISTE_HIST();

        public abstract String INSERT_TEILELISTE_HIST();

        public abstract String LOAD_NUTZERDATEN();

        public abstract String INSERT_NUTZERDATEN();

        public abstract String UPDATE_NUTZERDATEN();

        public abstract String UPDATE_ID_IN_LISTEPOS();

        public abstract String UPDATE_ID_IN_LISTEHIST();

        public abstract String UPDATE_ID_IN_LISTE();
    }

    public static abstract class BTEInfo {
        public static BTEInfo instance;

        public abstract String RETRIEVE_BTEINFO();

        public abstract String RETRIEVE_BTEKOMMENTAR();
    }

    public static abstract class TeilelisteHTML_SAP {
        public static TeilelisteHTML_SAP instance;

        public abstract String LOAD_TEILELISTE_RR();

        public abstract String LOAD_TEILELISTE_POS_RR();

        public abstract String DELETE_TEILELISTE_RR();

        public abstract String DELETE_TEILELISTEPOS_RR();

        public abstract String INSERT_TEILELISTE_RR();

        public abstract String LOAD_TEILELISTE_HIST();

        public abstract String DELETE_TEILELISTE_HIST();

        public abstract String INSERT_TEILELISTE_HIST();

        public abstract String GET_NEXT_ABFRAGE_SEQ_VAL();
    }

    public static abstract class TeilelisteJAVA {
        public static TeilelisteJAVA instance;

        public abstract String RETRIEVE_LISTEN_IDS();

        public abstract String RETRIEVE_BESTELLLISTEN_IDS();

        public abstract String RETRIEVE_UEBERSICHT();

        public abstract String FILTER_NUTZER();

        public abstract String FILTER_FILIALE();

        public abstract String FILTER_FIRMA();

        public abstract String FILTER_FIRMA_MIT_PRIVAT();

        public abstract String RETRIEVE_UEBERSICHT_BESTELLLISTEN();

        public abstract String RETRIEVE_LISTE_ALLG();

        public abstract String RETRIEVE_BESTELLLISTE_ALLG();

        public abstract String RETRIEVE_LISTE_POS();

        public abstract String RETRIEVE_MAX_POS();

        public abstract String RETRIEVE_BESTELLLISTE_POS();

        public abstract String RETRIEVE_TEIL_PREISE();

        public abstract String RETRIEVE_TEILELISTE_PREISE();

        public abstract String RETRIEVE_TEILELISTE_PUBLDATEN();

        public abstract String DELETE();

        public abstract String DELETE_POS();

        public abstract String INSERT_BESTELLLISTE();

        public abstract String DELETE_JOBS();

        public abstract String DELETE_SRPS();

        public abstract String UPDATE_POS();

        public abstract String UPDATE_BESTELL_POS();

        public abstract String DELETE_BESTELLLISTE_POS();

        public abstract String DELETE_SINGLE_POS();

        public abstract String DELETE_BESTELLLISTE_SINGLE_POS();

        public abstract String INSERT_LISTE_ALLG();

        public abstract String COPY_LISTE_ALLG();

        public abstract String UPDATE_LISTE_ALLG();

        public abstract String UPDATE_LISTE_AENDER_DAT();

        public abstract String UPDATE_LISTE_SPERRE();

        public abstract String RETRIEVE_LISTE_SPERRE();

        public abstract String RETRIEVE_LISTE_SPERRE_FOR_UPDATE();

        public abstract String UPDATE_LISTE_SPERRE_NUTZER();

        public abstract String INSERT_SENDE_INFO();

        public abstract String DELETE_SENDE_INFO();

        public abstract String RETRIEVE_SENDE_INFO();

        public abstract String RETRIEVE_BESTELLLISTE_SPERRE_FOR_UPDATE();

        public abstract String UPDATE_BESTELLLISTE_SPERRE();

        public abstract String INSERT_LISTE_POS();

        public abstract String COPY_LISTE_POSITIONEN();

        public abstract String INSERT_BESTELLLISTE_POS();

        public abstract String RETRIEVE_COUNT_BESTELLLISTEPOS();

        public abstract String UPDATE_LISTE_POS();

        public abstract String UPDATE_SCORELISTE_POS_STATUS();

        public abstract String UPDATE_BESTELLLISTE_POS();

        public abstract String GET_TEILELISTE_ZU_AUFTRAG();

        public abstract String INSERT_AUFTRAG();

        public abstract String UPDATE_AUFTRAG();

        public abstract String DELETE_AUFTRAG();

        public abstract String UPDATE_EIGENTUEMER();

        public abstract String UPDATE_EIGENTUEMER_POS();

        public abstract String INSERT_JOB();

        public abstract String INSERT_SRP();

        public abstract String RETRIEVE_JOBS();

        public abstract String RETRIEVE_SRPS();

        public abstract String GET_NEXT_ID_SEQ_VAL();

        public abstract String GET_NEXT_SCOREID_SEQ_VAL();

        public abstract String GET_NEXT_RRSAPID_SEQ_VAL();

        public abstract String GET_RELEASED_SCORE_LISTS();

        public abstract String LOAD_TC_INFO();

        public abstract String TC_CHECK_LANDKUERZEL();
    }

    public static abstract class TeilelisteHTML {
        public static TeilelisteHTML instance;

        public abstract String RETRIEVE_LISTEN_IDS();

        public abstract String RETRIEVE_LISTE_ALLG();

        public abstract String RETRIEVE_LISTE_POS();

        public abstract String DELETE();

        public abstract String DELETE_POS();

        public abstract String CHECK_TEILELISTE();

        public abstract String INSERT_BESTELLLISTE();

        public abstract String INSERT_LISTE_ALLG();

        public abstract String UPDATE_LISTE_ALLG();

        public abstract String INSERT_LISTE_POS();

        public abstract String RETRIEVE_MAILADRESSEN();

        public abstract String GET_NEXT_SAMMELID_SEQ_VAL();
    }

    public static abstract class Teileliste {
        public static Teileliste instance;

        public abstract String RETRIEVE_TEIL();
    }

    public static abstract class BteAnzeige {
        public static BteAnzeige instance;

        public abstract String LOAD_HOTSPOTS();

        public abstract String LOAD_BTZEILEN_FZG();

        public abstract String TC_CHECK_LANDKUERZEL();

        public abstract String LOAD_BTZEILEN_CP_FZG();

        public abstract String CP_FZG_TYP_WERK();

        public abstract String LOAD_BTZEILEN_UGB();

        public abstract String LOAD_KOMMENTARE_FZG();

        public abstract String LOAD_KOMMENTARE_UGB();

        public abstract String LOAD_BEDINGUNGEN_FZG();

        public abstract String LOAD_BTE_BEDINGUNGEN_FZG();

        public abstract String LOAD_UEBERBEDINGUNGEN_FZG();

        public abstract String LOAD_BTVERWEISE_FZG();

        public abstract String LOAD_BTVERWEISE_UGB();

        public abstract String LOAD_JA_NEIN_TEXT();

        public abstract String LOAD_AZEICHEN();

        public abstract String LOAD_ANZAHL_REL_KAMPAGNEN();

        public abstract String TC_CHECK_LANDKUERZEL_KAMPAGNE();
    }

    public static abstract class BedAuswertung {
        public static BedAuswertung instance;

        public abstract String LOAD_BT_STAMM();

        public abstract String LOAD_BT_STAMM_CP();

        public abstract String LOAD_BT_BEDINGUNGEN_SALA();

        public abstract String LOAD_BT_BEDINGUNGEN_AFL();

        public abstract String LOAD_BT_BEDINGUNGEN_TEXT();
    }

    public static abstract class TeileinfoJAVA {
        public static TeileinfoJAVA instance;

        public abstract String RETRIEVE_TEILEINFO_NOTIZ();

        public abstract String DELETE_TEILEINFO_NOTIZ();

        public abstract String INSERT_TEILEINFO_NOTIZ();

        public abstract String RETRIEVE_TEILEINFO_NOTIZEN_OTHERS();

        public abstract String RETRIEVE_COUNT_PREISE();
    }

    public static abstract class TeileinfoHTML {
        public static TeileinfoHTML instance;

        public abstract String RETRIEVE_TEILEINFO_NOTIZ();

        public abstract String DELETE_TEILEINFO_NOTIZ();

        public abstract String INSERT_TEILEINFO_NOTIZ();
    }

    public static abstract class Teileinfo {
        public static Teileinfo instance;

        public abstract String RETRIEVE_TEILEINFO();

        public abstract String RETRIEVE_TEILEINFO_HGUG();

        public abstract String RETRIEVE_TEILEINFO_SERVICEINFO();

        public abstract String RETRIEVE_TEILEINFO_PRODUKTINFO();

        public abstract String RETRIEVE_TEILEINFO_REACHINFO();

        public abstract String RETRIEVE_BEN_ZU_KUERZEL();

        public abstract String RETRIEVE_TEILEINFO_TEILECLEARING();

        public abstract String TC_CHECK_LANDKUERZEL();

        public abstract String RETRIEVE_HGUG();

        public abstract String SEARCH_SNR_FREMDNR();
    }

    public static abstract class TeilesucheAss {
        public static TeilesucheAss instance;

        public abstract String RETRIEVE_HGS();

        public abstract String RETRIEVE_HGS_GRAF();

        public abstract String RETRIEVE_HGFGS();

        public abstract String RETRIEVE_ALL_HGFGS();

        public abstract String SEARCH_BT_BENENNUNG();

        public abstract String SEARCH_BT_BENENNUNG_SONDERLOCKE();

        public abstract String SEARCH_BT_BENENNUNG_TR();

        public abstract String SEARCH_BT_BEGRIFF();

        public abstract String SEARCH_SNR_BENENNUNG();

        public abstract String SEARCH_SNR_BENENNUNG_SONDERLOCKE();

        public abstract String SEARCH_SNR_BENENNUNG_TR();

        public abstract String SEARCH_SNR_BEGRIFF();

        public abstract String SEARCH_BT_SACHNUMMER_COMPL();

        public abstract String SEARCH_SNR_SACHNUMMER_INCOMPL();

        public abstract String SEARCH_SNR_FREMDNR();

        public abstract String SEARCH_BT_SACHNUMMERN();

        public abstract String SEARCH_BT_HGFG();

        public abstract String SEARCH_BT_HG_GRAFISCH();

        public abstract String SEARCH_BT_HG_FG_GRAFISCH();

        public abstract String SEARCH_BT_HG_GRAFISCH_MIT_GRAFIKEN();

        public abstract String SEARCH_BT_HG_FG_GRAFISCH_MIT_GRAFIKEN();

        public abstract String CHECK_BT_HG_GRAFISCH();

        public abstract String SEARCH_BILDTAF_HGFG();

        public abstract String SEARCH_BILDTAF_HG();

        public abstract String ORDER_BY_POS();

        public abstract String ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER();

        public abstract String SEARCH_BT_NUMMER_COMPL();
    }

    public static abstract class TeilesucheAllgemein {
        public static TeilesucheAllgemein instance;

        public abstract String LOAD_MARKT_BENENNUNG();
    }

    public static abstract class TeilesucheFzg {
        public static TeilesucheFzg instance;

        public abstract String RETRIEVE_HGS();

        public abstract String RETRIEVE_HGS_GRAF();

        public abstract String RETRIEVE_FGS_GRAF();

        public abstract String RETRIEVE_FGS_GRAF_MOSP();

        public abstract String RETRIEVE_FGS_GRAF_MIT_GRAFIKEN();

        public abstract String RETRIEVE_FGS_GRAF_MOSP_MIT_GRAFIKEN();

        public abstract String RETRIEVE_HGFGS();

        public abstract String RETRIEVE_ALL_HGFGS();

        public abstract String SEARCH_BT_BENENNUNG();

        public abstract String SEARCH_BT_BENENNUNG_SONDERLOCKE();

        public abstract String SEARCH_BT_BENENNUNG_TR();

        public abstract String SEARCH_BT_BEGRIFF();

        public abstract String SEARCH_BT_BEGRIFF_NEU();

        public abstract String SEARCH_BILDTAFS_LENKUNG();

        public abstract String SEARCH_BILDTAFS_GETRIEBE();

        public abstract String SEARCH_BILDTAFS_EINSATZ();

        public abstract String SEARCH_BILDTAFS_AUSLAUF();

        public abstract String SEARCH_SNR_BENENNUNG();

        public abstract String SEARCH_SNR_BENENNUNG_SONDERLOCKE();

        public abstract String SEARCH_SNR_BENENNUNG_TR();

        public abstract String SEARCH_SNR_BEGRIFF();

        public abstract String SEARCH_BT_SACHNUMMER_COMPL();

        public abstract String SEARCH_SNR_SACHNUMMER_INCOMPL();

        public abstract String SEARCH_SNR_FREMDNR();

        public abstract String SEARCH_BT_SACHNUMMERN();

        public abstract String SEARCH_BTZEILEN_LENKUNG();

        public abstract String SEARCH_BTZEILEN_GETRIEBE();

        public abstract String SEARCH_BTZEILEN_EINSATZ();

        public abstract String SEARCH_BTZEILEN_AUSLAUF();

        public abstract String SEARCH_BT_HGFG();

        public abstract String SEARCH_ALL_BT_NUMBERS();

        public abstract String SEARCH_BT_HG_GRAFISCH();

        public abstract String SEARCH_BT_HG_FG_GRAFISCH();

        public abstract String SEARCH_BT_HG_FG_GRAFISCH_CENTRAL();

        public abstract String SEARCH_BT_HG_GRAFISCH_MIT_GRAFIKEN();

        public abstract String SEARCH_BT_HG_FG_GRAFISCH_MIT_GRAFIKEN();

        public abstract String CHECK_BT_HG_GRAFISCH();

        public abstract String SEARCH_BILDTAF_HGFG();

        public abstract String SEARCH_NUR_NICHT_SICHERHEITSRELEVANTE_BILDTAFELN();

        public abstract String SEARCH_KABELBAUM_CHANGEPOINTS();

        public abstract String SEARCH_BT_NUMMER_COMPL();
    }

    public static abstract class TeilesucheSpezifischValueLineFzg {
        public static TeilesucheSpezifischValueLineFzg instance;

        public abstract String RETRIEVE_BTES_VALUE_LINE();
    }

    public static abstract class FzgUmfang {
        public static FzgUmfang instance;

        public abstract String RETRIEVE_REGIONEN();

        public abstract String RETRIEVE_LENKUNGEN();

        public abstract String RETRIEVE_BAUARTEN();

        public abstract String RETRIEVE_BAUREIHEN();

        public abstract String RETRIEVE_KAROSSERIEN();

        public abstract String RETRIEVE_MODELLE();

        public abstract String RETRIEVE_MODELLSPALTEN();

        public abstract String MODELL_STMT();

        public abstract String RETRIEVE_BAUART();

        public abstract String RETRIEVE_KAROSSERIE();

        public abstract String RETRIEVE_LENKUNG();
    }

    public static abstract class FzgIdentifikation {
        public static FzgIdentifikation instance;

        public abstract String RETRIEVE_BAUARTEN();

        public abstract String RETRIEVE_BAUREIHEN();

        public abstract String GET_GRAFIKID_FOR_BAUREIHE();

        public abstract String GET_GRAFIKID_FOR_BAUREIHE_KAROSSERIE();

        public abstract String GET_GRAFIKID_FOR_FIBILD();

        public abstract String RETRIEVE_KAROSSERIEN();

        public abstract String RETRIEVE_MODELLE();

        public abstract String RETRIEVE_REGIONEN();

        public abstract String RETRIEVE_LENKUNGEN();

        public abstract String RETRIEVE_GETRIEBEARTEN();

        public abstract String RETRIEVE_BAUJAHRE();

        public abstract String RETRIEVE_ZULASSMONATE();

        public abstract String RETRIEVE_ZULASSMONATE2();

        public abstract String RETRIEVE_BAUART();

        public abstract String RETRIEVE_KAROSSERIE();

        public abstract String RETRIEVE_LENKUNG();

        public abstract String RETRIEVE_GETRIEBE();

        public abstract String RETRIEVE_MOSP_BY_ATTRIBUTE_PKW();

        public abstract String RETRIEVE_MOSP_BY_ATTRIBUTE_KRAD();

        public abstract String RETRIEVE_MOSP_BY_FGSTNR();

        public abstract String RETRIEVE_MOSP_BY_TYP();

        public abstract String RETRIEVE_TYPMENGE_BY_ATTRIBUTE_PKW();

        public abstract String RETRIEVE_TYPMENGE_BY_ATTRIBUTE_KRAD();

        public abstract String RETRIEVE_LENKUNG_BEN();

        public abstract String LOAD_SALAS_ZU_FGSTNR();

        public abstract String LOAD_SS_BEDINGUNGEN_AF();

        public abstract String LOAD_SS_BEDINGUNGEN_AF_BY_AFCODE();

        public abstract String LOAD_SS_BEDINGUNGEN_AF_BY_POLSTERCODE();

        public abstract String LOAD_SS_BEDINGUNGEN_LACK();

        public abstract String LOAD_SS_BEDINGUNGEN_LACK_EXACT();

        public abstract String LOAD_SS_BEDINGUNGEN_LACK_LIKE();

        public abstract String LOAD_SS_BEDINGUNGEN_SALAPA();

        public abstract String LOAD_SS_BEDINGUNGEN_SALAPA_BY_ART();

        public abstract String LOAD_SS_BEDINGUNGEN_SALAPA_BY_HZEAHLER();

        public abstract String RETRIEVE_BED_ZUSATZINFO();

        public abstract String RETRIEVE_ZUSATZINFO_MARKE();

        public abstract String RETRIEVE_VIN17_DATEN_BY_TYP();

        public abstract String GET_DATA_WITH_FGSTNR_TYP();
    }

    public static abstract class Einstellungen {
        public static Einstellungen instance;

        public abstract String RETRIEVE_EINSTELLUNGEN();

        public abstract String RETRIEVE_EINSTELLUNGEN_JAVA();

        public abstract String RETRIEVE_EINSTELLUNGEN_MARKTID_JAVA();

        public abstract String RETRIEVE_IPAC_MARKT();

        public abstract String UPDATE_MARKTID();

        public abstract String RETRIEVE_EINSTELLUNGEN_REGIONEN();

        public abstract String RETRIEVE_EINSTELLUNGEN_REGIONEN_JAVA();

        public abstract String DELETE_EINSTELLUNGEN();

        public abstract String DELETE_EINSTELLUNGEN_JAVA();

        public abstract String INSERT_EINSTELLUNGEN();

        public abstract String INSERT_EINSTELLUNGEN_JAVA();

        public abstract String DELETE_EINSTELLUNGEN_REGIONEN();

        public abstract String DELETE_EINSTELLUNGEN_REGIONEN_JAVA();

        public abstract String INSERT_EINSTELLUNGEN_REGIONEN();

        public abstract String INSERT_EINSTELLUNGEN_REGIONEN_JAVA();

        public abstract String RETRIEVE_SPRACHEN();

        public abstract String RETRIEVE_REGIONEN();

        public abstract String RETRIEVE_COUNT_MODSPALTEN();

        public abstract String RETRIEVE_COUNT_MODSPALTEN_LENKUNG();

        public abstract String RETRIEVE_RECHTE();

        public abstract String RETRIEVE_RECHTE_JAVA();

        public abstract String RETRIEVE_BERECHTIGUNGEN();

        public abstract String DELETE_TEILENOTIZEN_ABGELAUFEN();

        public abstract String RETRIEVE_MAERKTE_ETK_LOKALE_PRODUKTE();

        public abstract String RETRIEVE_ETK_MARKT();

        public abstract String RETRIEVE_WEITERE_MAERKTE();

        public abstract String DELETE_WEITERE_MAERKTE();

        public abstract String INSERT_WEITERE_MAERKTE();

        public abstract String RETRIEVE_SAMMEL_RESTR();
    }

    public static abstract class Wertebereiche {
        public static Wertebereiche instance;

        public abstract String RETRIEVE_WERTEBEREICH();
    }

    public static abstract class Allgemein {
        public static Allgemein instance;

        public abstract String getLikeInsensitive(String var1, String var2, boolean var3);

        public abstract String getNotLikeInsensitive(String var1, String var2, boolean var3);

        public abstract String getLikeTr(String var1, String var2, boolean var3);

        public abstract String getNotLikeTr(String var1, String var2, boolean var3);

        public abstract String LOAD_GRAFIK();

        public abstract String INSERT_GRAFIK_STATISTIK();

        public abstract String RETRIEVE_BMWSACHNUMMER_FOR_FREMDESACHNUMMER();

        public abstract String RETRIEVE_URLS();

        public abstract String RETRIEVE_BMW_NETZ();

        public abstract String RETRIEVE_BMW_NETZURL();

        public abstract String RETRIEVE_ALL_BMW_NETZURL();

        public abstract String RETRIEVE_BMW_PROXY();

        public abstract String RETRIEVE_SOWU_ANTWORT();

        public abstract String DELETE_SOWU_ANTWORT();
    }
}

