/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;

public class AdminToolDbAccess {
    private static Logger log = Logger.getLogger(AdminToolDbAccess.class);

    public static boolean isFirmaIdTheOnlyOneInPreise(Connection con, String sFirmaId) throws SQLException, ClassNotFoundException {
        String sSQLStatement = SQLStatements.Admintool.instance.GET_DISTINCT_FIRMA_PREISE();
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        int nCount = 0;
        boolean bResult = false;
        if (res != null) {
            while (res.next()) {
                if (++nCount > 1) {
                    return false;
                }
                String sFirmaIdRS = res.getString("FirmaId");
                if (!sFirmaId.equals(sFirmaIdRS)) continue;
                bResult = true;
            }
        }
        AdminToolDbAccess.closeQuery(res);
        return bResult;
    }

    public static void closeQuery(ResultSet rset) {
        if (rset == null) {
            return;
        }
        try {
            Statement stmt = rset.getStatement();
            if (rset != null) {
                rset.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            log.warn("Unable to close statement and/or resultset!", e);
        }
    }

    public static boolean lockTable(Connection con, String sTable, String sMode) {
        try {
            String sSQLStatement = SQLStatements.Admintool.instance.LOCK_TABLE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TABLE", sTable);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MODE", sMode);
            log.debug("Executing: " + sSQLStatement);
            Statement stmt = con.createStatement();
            stmt.execute(sSQLStatement);
            stmt.close();
            return true;
        }
        catch (Exception e) {
            log.error("Locken der Tabelle " + sTable + " im Modus " + sMode + " ist gescheitert mit " + e.getMessage());
            return false;
        }
    }

    public static int loeschePreise(Connection con, String sFirma, boolean bFirmaIsTheOnlyOne) throws SQLException, ClassNotFoundException {
        String sSQLStatement = null;
        if (bFirmaIsTheOnlyOne) {
            sSQLStatement = SQLStatements.Admintool.instance.DELETE_PRICES();
        } else {
            sSQLStatement = SQLStatements.Admintool.instance.DELETE_PRICES_BY_FIRMA();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        int result = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        return result;
    }

    public static void unlockTable(Connection con, String sTable) {
        try {
            String sSQLStatement = SQLStatements.Admintool.instance.UNLOCK_TABLE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TABLE", sTable);
            log.debug("Executing: " + sSQLStatement);
            Statement stmt = con.createStatement();
            stmt.execute(sSQLStatement);
            stmt.close();
        }
        catch (Exception e) {
            log.error("Das Unlocken der Tabelle " + sTable + " ist gescheitert mit " + e.getMessage());
        }
    }

    public static int erzeugePreis(Connection connection, String[] recordData, boolean bUpdate, String sFirma) throws SQLException {
        int retVal = 0;
        String sqlStatement = bUpdate ? SQLStatements.Admintool.instance.UPDATE_PRICES() : SQLStatements.Admintool.instance.INSERT_PRICES();
        sqlStatement = StringUtils.substituteStringQuoted(sqlStatement, "&preise_firma&", sFirma, true);
        for (int i = 0; i < recordData.length; ++i) {
            sqlStatement = StringUtils.substituteStringQuoted(sqlStatement, SQLStatements.Admintool.instance.PRICE_FIELD_getName(i), recordData[i], SQLStatements.Admintool.instance.PRICE_FIELD_getIsQuoted(i));
        }
        Statement stmt = connection.createStatement();
        try {
            retVal = stmt.executeUpdate(sqlStatement);
            if (retVal == 0 && bUpdate) {
                retVal = AdminToolDbAccess.erzeugePreis(connection, recordData, false, sFirma);
            }
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 9151) {
                log.error("error <9151>: probably duplicate of keys " + recordData[0]);
            }
            throw e;
        }
        stmt.close();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loescheNutzertabellen(Connection con) throws SQLException {
        String sSQLStatement = SQLStatements.Admintool.instance.ERMITTLE_NUTZERTABELLEN();
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = con.createStatement();
            rset = stmt.executeQuery(sSQLStatement);
            while (rset.next()) {
                AdminToolDbAccess.loescheTabelle(con, rset.getString("tabelle"));
            }
            stmt.close();
        }
        catch (SQLException e) {
            log.error(e);
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception e) {
                log.error(e);
            }
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private static int loescheTabelle(Connection con, String sTablename) throws SQLException {
        String sSQLStatement = SQLStatements.Admintool.instance.DROP_TABLE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TABLE", sTablename);
        log.debug("Executing: " + sSQLStatement);
        int result = 0;
        try {
            Statement stmt = con.createStatement();
            result = stmt.executeUpdate(sSQLStatement);
            stmt.close();
        }
        catch (SQLException e) {
            log.error("Unable to delete table " + sTablename, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loescheNutzersequenzen(Connection con) throws SQLException {
        String sSQLStatement = SQLStatements.Admintool.instance.ERMITTLE_NUTZERSEQUENZEN();
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = null;
        ResultSet rset = null;
        try {
            stmt = con.createStatement();
            rset = stmt.executeQuery(sSQLStatement);
            while (rset.next()) {
                AdminToolDbAccess.loescheSequence(con, rset.getString("sequenz"));
            }
            stmt.close();
        }
        catch (SQLException e) {
            log.error(e);
        }
        finally {
            try {
                rset.close();
            }
            catch (Exception e) {
                log.error(e);
            }
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    private static int loescheSequence(Connection con, String sSequencename) throws SQLException {
        String sSQLStatement = SQLStatements.Admintool.instance.DROP_SEQUENCE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SEQUENCE", sSequencename);
        log.debug("Executing: " + sSQLStatement);
        int result = 0;
        try {
            Statement stmt = con.createStatement();
            result = stmt.executeUpdate(sSQLStatement);
            stmt.close();
        }
        catch (SQLException e) {
            log.error("Unable to delete Sequence " + sSequencename, e);
        }
        return result;
    }
}

