/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class EtkTextDbAccess {
    private static Logger log = Logger.getLogger(EtkTextDbAccess.class);

    public static ResultSet loadETKTexte(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.ETKTexte.instance.RETRIEVE_ETKTEXTE();
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadETKTexteZuKommentaren(Connection con, String sISO, String sRegISO) throws SQLException {
        ResultSet res = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.ETKTexte.instance.RETRIEVE_ETKTEXTE_KOMMENTARE();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.ETKTexte.instance.RETRIEVE_ETKTEXTE_KOMMENTARE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

