/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class FedertabelleDbAccess {
    private static Logger log = Logger.getLogger(FedertabelleDbAccess.class);

    public static ResultSet loadSalas(Connection con, String sLang, Collection cTypen, String sProduktionsdatum, boolean bIsTagesgenau) throws SQLException, DatabaseBusyException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_SALAS();
            int index = 0;
            String sTypen = FedertabelleDbAccess.concatCollection(cTypen, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPEN", sTypen);
            if (bIsTagesgenau) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMMDD());
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMM());
                sProduktionsdatum = sProduktionsdatum.substring(0, 6);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            }
            String sISO = LanguageUtils.toLanguage(sLang);
            String sRegISO = LanguageUtils.toRegion(sLang, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_SALAS();
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sTypen = FedertabelleDbAccess.concatCollection(cTypen, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPEN", sTypen);
        if (bIsTagesgenau) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMMDD());
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMM());
            sProduktionsdatum = sProduktionsdatum.substring(0, 6);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTIONSDATUM", sProduktionsdatum);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSalaPunkte(Connection con, Collection cTypen, String sProduktionsdatum, boolean bIsTagesgenau, Collection cSalaIds) throws SQLException, DatabaseBusyException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_PUNKTE_SALA();
            int index = 0;
            String sTypen = FedertabelleDbAccess.concatCollection(cTypen, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPEN", sTypen);
            if (bIsTagesgenau) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMMDD());
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMM());
                sProduktionsdatum = sProduktionsdatum.substring(0, 6);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            }
            String sSalaIds = FedertabelleDbAccess.concatCollection(cSalaIds, false);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SALAIDS", sSalaIds);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_PUNKTE_SALA();
        String sTypen = FedertabelleDbAccess.concatCollection(cTypen, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPEN", sTypen);
        if (bIsTagesgenau) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMMDD());
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMM());
            sProduktionsdatum = sProduktionsdatum.substring(0, 6);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTIONSDATUM", sProduktionsdatum);
        String sSalaIds = FedertabelleDbAccess.concatCollection(cSalaIds, false);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SALAIDS", sSalaIds);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTypPunkte(Connection con, Collection cTypen, String sProduktionsdatum, boolean bIsTagesgenau) throws SQLException, DatabaseBusyException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_PUNKTE_TYP();
            int index = 0;
            String sTypen = FedertabelleDbAccess.concatCollection(cTypen, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPEN", sTypen);
            if (bIsTagesgenau) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMMDD());
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMM());
                sProduktionsdatum = sProduktionsdatum.substring(0, 6);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
                StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_PUNKTE_TYP();
        String sTypen = FedertabelleDbAccess.concatCollection(cTypen, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPEN", sTypen);
        if (bIsTagesgenau) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMMDD());
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODDATUM_STMT", SQLStatements.Federtabelle.instance.SFT_PRODDATUM_YYYYMM());
            sProduktionsdatum = sProduktionsdatum.substring(0, 6);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTIONSDATUM", sProduktionsdatum);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadFeder(Connection con, String sArt, String sLinksRechts, long lFTId, int nPunkte) throws SQLException, DatabaseBusyException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            sSQLStatement = sLinksRechts.equals("L") ? SQLStatements.Federtabelle.instance.LOAD_FEDERN_LINKS() : SQLStatements.Federtabelle.instance.LOAD_FEDERN_RECHTS();
            int index = 0;
            String sFTId = Long.toString(lFTId);
            StringUtils.setPreparedStatementParams(++index, sFTId);
            StringUtils.setPreparedStatementParams(++index, sArt);
            String sPunkte = Integer.toString(nPunkte);
            StringUtils.setPreparedStatementParams(++index, sPunkte);
            StringUtils.setPreparedStatementParams(++index, sPunkte);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = sLinksRechts.equals("L") ? SQLStatements.Federtabelle.instance.LOAD_FEDERN_LINKS() : SQLStatements.Federtabelle.instance.LOAD_FEDERN_RECHTS();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sArt);
        String sFTId = Long.toString(lFTId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FTID", sFTId);
        String sPunkte = Integer.toString(nPunkte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PUNKTE", sPunkte);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    private static String concatCollection(Collection cCollection, boolean bHochkomma) {
        String sString = "";
        if (cCollection == null) {
            return sString;
        }
        Iterator iterator = cCollection.iterator();
        while (iterator.hasNext()) {
            if (sString.length() > 0) {
                sString = sString + ", ";
            }
            Object oObject = iterator.next();
            String sValue = "";
            if (oObject instanceof String) {
                sValue = (String)oObject;
            }
            if (oObject instanceof Long) {
                sValue = oObject.toString();
            }
            if (oObject instanceof Integer) {
                sValue = oObject.toString();
            }
            if (bHochkomma) {
                sString = sString + "'" + sValue + "'";
                continue;
            }
            sString = sString + sValue;
        }
        return sString;
    }

    public static ResultSet loadAspgKit(Connection con, long lFTId) throws SQLException, DatabaseBusyException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_ASPG_KIT();
            PreparedStatement stat = con.prepareStatement(sSQLStatement);
            String sFTId = Long.toString(lFTId);
            stat.setString(1, sFTId);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = stat.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Federtabelle.instance.LOAD_ASPG_KIT();
        String sFTId = Long.toString(lFTId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FTID", sFTId);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

