/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class LagerzeitDbAccess {
    private static Logger log = Logger.getLogger(LagerzeitDbAccess.class);

    public static ResultSet selectHGs(Connection con, String sHGVon, String sHGBis, String sMarke, String sProduktart) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Lagerzeit.instance.RETRIEVE_HGS();
            int index = 0;
            if (sHGVon == null || sHGVon.length() == 0) {
                sHGVon = "11";
            }
            StringUtils.setPreparedStatementParams(++index, sHGVon);
            if (sHGBis == null || sHGBis.length() == 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", SQLStatements.Lagerzeit.instance.HG_BIS_STMT());
                StringUtils.setPreparedStatementParams(++index, sHGBis);
            }
            StringUtils.setPreparedStatementParams(++index, "J");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "B");
            StringUtils.setPreparedStatementParams(++index, sMarke);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Lagerzeit.instance.RETRIEVE_HGS();
        if (sHGVon == null || sHGVon.length() == 0) {
            sHGVon = "11";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGAB", sHGVon);
        if (sHGBis == null || sHGBis.length() == 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", SQLStatements.Lagerzeit.instance.HG_BIS_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS", sHGBis);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet findHG(Connection con, String sHG) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Teileersetzung.instance.FIND_HG();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sHG);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Teileersetzung.instance.FIND_HG();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectTeile(Connection con, String sSprache, String sHG, String sMarke, String sProduktart, String sUserKatalogumfang, String sLandkuerzel) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Lagerzeit.instance.RETRIEVE_TEILE();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            String sKatalogumfaenge = sUserKatalogumfang;
            if (sUserKatalogumfang.equals("ALLE")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(2));
                StringUtils.setPreparedStatementParams(++index, "VT");
                StringUtils.setPreparedStatementParams(++index, "ST");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(1));
                StringUtils.setPreparedStatementParams(++index, sKatalogumfaenge);
            }
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Lagerzeit.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, "J");
            StringUtils.setPreparedStatementParams(++index, sHG);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "B");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Lagerzeit.instance.RETRIEVE_TEILE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sKatalogumfaenge = "'" + sUserKatalogumfang + "'";
        if (sUserKatalogumfang.equals("ALLE")) {
            sKatalogumfaenge = "'VT', 'ST'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFAENGE", sKatalogumfaenge);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Lagerzeit.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

