/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class MiscDbAccess {
    private static Logger log = Logger.getLogger(MiscDbAccess.class);

    public static ResultSet loadSOWUAntwort(Connection con, String sFahrgestellnummer) throws SQLException {
        ResultSet res = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_SOWU_ANTWORT();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sFahrgestellnummer);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_SOWU_ANTWORT();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "VIN", sFahrgestellnummer);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void deleteSOWUAntwort(Connection con, String sFahrgestellnummer, String sId) throws SQLException {
        String sSQLStatement = SQLStatements.Allgemein.instance.DELETE_SOWU_ANTWORT();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "VIN", sFahrgestellnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sId);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }
}

