/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class NormteileDbAccess {
    private static Logger log = Logger.getLogger(NormteileDbAccess.class);

    public static ResultSet loadNormteileBenennungen(Connection con, String sMarke, String sProduktart, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_BENENNUNGEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sMarke);
            ps.setString(2, sProduktart);
            ps.setString(3, "B");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(4, sISO);
            ps.setString(5, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadGrafikInfos(Connection con, String sMarke, String sProduktart, String sNormnummernGruppe) throws SQLException {
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            if (sNormnummernGruppe == null) {
                sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_NORMNUMMERN_GRUPPEN();
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "B");
                StringUtils.setPreparedStatementParams(++index, "T");
            } else {
                sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_NORMNUMMERN();
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "B");
                StringUtils.setPreparedStatementParams(++index, sNormnummernGruppe);
                StringUtils.setPreparedStatementParams(++index, "T");
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (sNormnummernGruppe == null) {
            sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_NORMNUMMERN_GRUPPEN();
        } else {
            sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_NORMNUMMERN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NORMNUMMERNGRUPPE", sNormnummernGruppe);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadNormteile(Connection con, String sMarke, String sProduktart, String sSprache, String sNormnummer, Vector<String> aBenIDs) throws SQLException {
        Calendar oCalendar = Calendar.getInstance();
        oCalendar.add(1, -2);
        long lCompareDate = oCalendar.get(1) * 10000 + (oCalendar.get(2) + 1) * 100 + oCalendar.get(5);
        String sCompareDate = Long.toString(lCompareDate);
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sRegISO;
            String sISO;
            int index = 0;
            if (sNormnummer != null) {
                sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_TEILE_ZU_NORMNUMMER();
                sISO = LanguageUtils.toLanguage(sSprache);
                sRegISO = LanguageUtils.toRegion(sSprache, true);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "B");
                StringUtils.setPreparedStatementParams(++index, sNormnummer);
                StringUtils.setPreparedStatementParams(++index, "07");
                StringUtils.setPreparedStatementParams(++index, "88");
                StringUtils.setPreparedStatementParams(++index, "10");
                StringUtils.setPreparedStatementParams(++index, "6");
                StringUtils.setPreparedStatementParams(++index, sCompareDate);
            } else {
                sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_TEILE_ZU_BENENNUNG();
                sISO = LanguageUtils.toLanguage(sSprache);
                sRegISO = LanguageUtils.toRegion(sSprache, true);
                StringUtils.setPreparedStatementParams(++index, sISO);
                StringUtils.setPreparedStatementParams(++index, sRegISO);
                StringUtils.setPreparedStatementParams(++index, sMarke);
                StringUtils.setPreparedStatementParams(++index, sProduktart);
                StringUtils.setPreparedStatementParams(++index, "B");
                StringUtils.setPreparedStatementParams(++index, "07");
                StringUtils.setPreparedStatementParams(++index, "88");
                StringUtils.setPreparedStatementParams(++index, "10");
                StringUtils.setPreparedStatementParams(++index, sCompareDate);
                if (aBenIDs.size() == 1) {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXTCODE_STMT", SQLStatements.Normteile.instance.TEXTCODE_GLEICH_STMT());
                    StringUtils.setPreparedStatementParams(++index, aBenIDs.get(0));
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXTCODE_STMT", SQLStatements.Normteile.instance.TEXTCODE_IN_STMT());
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aBenIDs.size()));
                    for (String sBenIDs : aBenIDs) {
                        StringUtils.setPreparedStatementParams(++index, sBenIDs);
                    }
                }
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (sNormnummer != null) {
            sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_TEILE_ZU_NORMNUMMER();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "NORMNUMMER", sNormnummer);
        } else {
            sSQLStatement = SQLStatements.Normteile.instance.RETRIEVE_TEILE_ZU_BENENNUNG();
            if (aBenIDs.size() == 1) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXTCODE_STMT", SQLStatements.Normteile.instance.TEXTCODE_GLEICH_STMT());
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXTCODE", aBenIDs.get(0));
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXTCODE_STMT", SQLStatements.Normteile.instance.TEXTCODE_IN_STMT());
                String sBenIDs = "";
                Iterator<String> iter = aBenIDs.iterator();
                while (iter.hasNext()) {
                    if (sBenIDs.length() > 0) {
                        sBenIDs = sBenIDs + ", ";
                    }
                    sBenIDs = sBenIDs + iter.next();
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TEXTCODE", sBenIDs);
            }
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "COMPARE_DATE", sCompareDate);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

