/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class SatzEinzelteileDbAccess {
    private static Logger log = Logger.getLogger(SatzEinzelteileDbAccess.class);

    public static ResultSet loadHGs(Connection con, String sSprache, String sMarke, String sProduktart) throws SQLException {
        String sSQLStatement = SQLStatements.SatzEinzelteile.instance.LOAD_HG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sMarke);
            ps.setString(2, "B");
            ps.setString(3, sProduktart);
            ps.setString(4, sProduktart);
            ps.setString(5, "00");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSaetze(Connection con, String sSprache, String sMarke, String sProduktart, String sUserKatalogumfang, String sHG, String sLandkuerzel) throws SQLException {
        String sSQLStatement = SQLStatements.SatzEinzelteile.instance.LOAD_SATZ();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            String sKatalogumfaenge = sUserKatalogumfang;
            if (sUserKatalogumfang.equals("ALLE")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(2));
                StringUtils.setPreparedStatementParams(++index, "VT");
                StringUtils.setPreparedStatementParams(++index, "ST");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(1));
                StringUtils.setPreparedStatementParams(++index, sKatalogumfaenge);
            }
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.SatzEinzelteile.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, "B");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sHG);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sKatalogumfaenge = "'" + sUserKatalogumfang + "'";
        if (sUserKatalogumfang.equals("ALLE")) {
            sKatalogumfaenge = "'VT', 'ST'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFAENGE", sKatalogumfaenge);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.SatzEinzelteile.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hatEinzelteile(Connection con, String sSachnummerSatz) throws SQLException {
        ResultSet res;
        block3: {
            boolean bl;
            String sSQLStatement = SQLStatements.SatzEinzelteile.instance.COUNT_EINZELTEILE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummerSatz);
            log.debug("Executing: " + sSQLStatement);
            Statement stmt = null;
            res = null;
            try {
                stmt = con.createStatement();
                res = stmt.executeQuery(sSQLStatement);
                if (!res.next()) break block3;
                int nCount = res.getInt("Anzahl");
                bl = nCount == 0;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            return bl;
        }
        boolean bl = false;
        WebetkUtils.closeQuery(res);
        return bl;
    }

    public static ResultSet loadEinzelteile(Connection con, String sSprache, String sSachnummerSatz, String sMarke, String sProduktart, String sUserKatalogumfang, String sLandkuerzel) throws SQLException {
        String sSQLStatement = SQLStatements.SatzEinzelteile.instance.LOAD_EINZELTEIL();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            String sKatalogumfaenge = sUserKatalogumfang;
            if (sUserKatalogumfang.equals("ALLE")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(2));
                StringUtils.setPreparedStatementParams(++index, "VT");
                StringUtils.setPreparedStatementParams(++index, "ST");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(1));
                StringUtils.setPreparedStatementParams(++index, sKatalogumfaenge);
            }
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Lagerzeit.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sSachnummerSatz);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummerSatz);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sKatalogumfaenge = "'" + sUserKatalogumfang + "'";
        if (sUserKatalogumfang.equals("ALLE")) {
            sKatalogumfaenge = "'VT', 'ST'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFAENGE", sKatalogumfaenge);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Lagerzeit.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

