/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileInfoDbAccess {
    private static Logger log = Logger.getLogger(TeileInfoDbAccess.class);

    public static ResultSet loadTeileinfo(Connection con, String sHgUg, String sSachnummer, String sSprache, Collection<String> aMarken) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Teileinfo.instance.RETRIEVE_TEILEINFO();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            StringUtils.setPreparedStatementParams(++index, sISO);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "A");
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "MENGE");
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            if (sSachnummer == null || sSachnummer.length() != 7) {
                log.warn("Keine Sachnummer \u00fcbergeben!");
                return null;
            }
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMarken.size()));
            for (String sMarken : aMarken) {
                StringUtils.setPreparedStatementParams(++index, sMarken);
            }
            if (sSachnummer != null && sSachnummer.length() == 7) {
                if (sHgUg != null && sHgUg.length() == 4) {
                    log.debug(" und HgUg ");
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGUG_STMT", SQLStatements.Teileinfo.instance.RETRIEVE_TEILEINFO_HGUG());
                    String sHg = sHgUg.substring(0, 2);
                    StringUtils.setPreparedStatementParams(++index, sHg);
                    String sUg = sHgUg.substring(2, 4);
                    StringUtils.setPreparedStatementParams(++index, sUg);
                } else {
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGUG_STMT", "");
                }
            } else {
                log.warn("Keine Sachnummer \u00fcbergeben!");
                return null;
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        if (sSachnummer != null && sSachnummer.length() == 7) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
            if (sHgUg != null && sHgUg.length() == 4) {
                log.debug(" und HgUg ");
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGUG_STMT", SQLStatements.Teileinfo.instance.RETRIEVE_TEILEINFO_HGUG());
                String sHg = sHgUg.substring(0, 2);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHg);
                String sUg = sHgUg.substring(2, 4);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "UG", sUg);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGUG_STMT", "");
            }
        } else {
            log.warn("Keine Sachnummer \u00fcbergeben!");
            return null;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", aMarken);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadNotiz(Connection con, String sNutzerID, String sFirma, String sSprache, String sSachnummer) throws SQLException {
        ResultSet res = null;
        if (sSachnummer == null || sSachnummer.length() != 7) {
            log.warn("Keine Sachnummer \u00fcbergeben!");
            return null;
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sSQLStatement = null;
            if (sFirma == null) {
                sSQLStatement = SQLStatements.TeileinfoHTML.instance.RETRIEVE_TEILEINFO_NOTIZ();
                StringUtils.setPreparedStatementParams(++index, sSachnummer);
                sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
                StringUtils.setPreparedStatementParams(++index, sNutzerID);
            } else {
                sSQLStatement = SQLStatements.TeileinfoJAVA.instance.RETRIEVE_TEILEINFO_NOTIZ();
                StringUtils.setPreparedStatementParams(++index, sSachnummer);
                StringUtils.setPreparedStatementParams(++index, sNutzerID);
                if (sFirma != null) {
                    sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
                    StringUtils.setPreparedStatementParams(++index, sFirma);
                }
                StringUtils.setPreparedStatementParams(++index, "M");
                StringUtils.setPreparedStatementParams(++index, "00");
                if (sSprache != null) {
                    String sISO = LanguageUtils.toLanguage(sSprache);
                    String sRegISO = LanguageUtils.toRegion(sSprache, true);
                    StringUtils.setPreparedStatementParams(++index, sISO);
                    StringUtils.setPreparedStatementParams(++index, sRegISO);
                }
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = sFirma == null ? SQLStatements.TeileinfoHTML.instance.RETRIEVE_TEILEINFO_NOTIZ() : SQLStatements.TeileinfoJAVA.instance.RETRIEVE_TEILEINFO_NOTIZ();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        sNutzerID = StringUtils.maskiereHochkommaFuerDb(sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        if (sFirma != null) {
            sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        }
        if (sSprache != null) {
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadNotizenOthers(Connection con, String sNutzerID, String sFirma, String sSachnummer, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = null;
        sSQLStatement = SQLStatements.TeileinfoJAVA.instance.RETRIEVE_TEILEINFO_NOTIZEN_OTHERS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sSachnummer);
            ps.setString(2, sNutzerID);
            ps.setString(3, sFirma);
            ps.setString(4, "J");
            ps.setString(5, "M");
            ps.setString(6, "00");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(7, sISO);
            ps.setString(8, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadServiceinfo(Connection con, String sSachnummer) throws SQLException {
        ResultSet res = null;
        if (sSachnummer == null || sSachnummer.length() != 7) {
            log.warn("Keine Sachnummer \u00fcbergeben!");
            return null;
        }
        String sSQLStatement = SQLStatements.Teileinfo.instance.RETRIEVE_TEILEINFO_SERVICEINFO();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1007);
            ps.setString(1, sSachnummer);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement(1004, 1007);
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBenZuKuerzel(Connection con, String sArt, String sKuerzel, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Teileinfo.instance.RETRIEVE_BEN_ZU_KUERZEL();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1007);
            ps.setString(1, sArt);
            ps.setString(2, sKuerzel);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sArt);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KUERZEL", sKuerzel);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement(1004, 1007);
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadProduktinfo(Connection con, long lKomId, String sSprache) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Teileinfo.instance.RETRIEVE_TEILEINFO_PRODUKTINFO();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1007);
            String sISO = LanguageUtils.toLanguage(sSprache);
            ps.setString(1, sISO);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sRegISO);
            String sKomId = Long.toString(lKomId);
            ps.setString(3, sKomId);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        String sKomId = Long.toString(lKomId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KOMID", sKomId);
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement(1004, 1007);
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadReachinfo(Connection con, String sachNr) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Teileinfo.instance.RETRIEVE_TEILEINFO_REACHINFO();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1007);
            ps.setString(1, sachNr);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sachNr);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement(1004, 1007);
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeileclearing(Connection con, String sSachnummer, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, String sLandkuerzel) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Teileinfo.instance.RETRIEVE_TEILEINFO_TEILECLEARING();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN1", StringUtils.preparePlaceHolders(aUserMarken.size()));
            for (String sUserMarken : aUserMarken) {
                StringUtils.setPreparedStatementParams(++index, sUserMarken);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN2", StringUtils.preparePlaceHolders(aUserProdukte.size()));
            for (String sUserProdukte : aUserProdukte) {
                StringUtils.setPreparedStatementParams(++index, sUserProdukte);
            }
            String sKatalogumfaenge = sUserKatalogumfang;
            if (sUserKatalogumfang.equals("ALLE")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(2));
                StringUtils.setPreparedStatementParams(++index, "VT");
                StringUtils.setPreparedStatementParams(++index, "ST");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(1));
                StringUtils.setPreparedStatementParams(++index, sKatalogumfaenge);
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Teileinfo.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            StringUtils.setPreparedStatementParams(++index, sToday);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "MARKEN", aUserMarken);
        sSQLStatement = StringUtils.substituteListOfStrings(sSQLStatement, "PRODUKTARTEN", aUserProdukte);
        String sKatalogumfaenge = "'" + sUserKatalogumfang + "'";
        if (sUserKatalogumfang.equals("ALLE")) {
            sKatalogumfaenge = "'VT', 'ST'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFAENGE", sKatalogumfaenge);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Teileinfo.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void saveNotiz(Connection con, String sNutzerId, String sFirma, String sSachnummer, String sNotiztext, boolean bAllgemein, int nBisJahr, int nBisMonat) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = sFirma == null ? SQLStatements.TeileinfoHTML.instance.DELETE_TEILEINFO_NOTIZ() : SQLStatements.TeileinfoJAVA.instance.DELETE_TEILEINFO_NOTIZ();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
        if (sFirma != null) {
            sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
        sSQLStatement = null;
        sSQLStatement = sFirma == null ? SQLStatements.TeileinfoHTML.instance.INSERT_TEILEINFO_NOTIZ() : SQLStatements.TeileinfoJAVA.instance.INSERT_TEILEINFO_NOTIZ();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
        if (sFirma != null) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        String sValue = StringUtils.substituteStringStraight(sNotiztext, "'", "''");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NOTIZTEXT", sValue);
        String sBisMonat = new Integer(nBisMonat).toString();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BISMONAT", sBisMonat);
        String sBisJahr = new Integer(nBisJahr).toString();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BISJAHR", sBisJahr);
        String sAllgemein = "N";
        if (bAllgemein) {
            sAllgemein = "J";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ALLGEMEIN", sAllgemein);
        log.debug("Executing: " + sSQLStatement);
        stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    public static void deleteNotiz(Connection con, String sNutzerId, String sFirma, String sSachnummer) throws SQLException {
        String sSQLStatement = null;
        sSQLStatement = sFirma == null ? SQLStatements.TeileinfoHTML.instance.DELETE_TEILEINFO_NOTIZ() : SQLStatements.TeileinfoJAVA.instance.DELETE_TEILEINFO_NOTIZ();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNR", sSachnummer);
        sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sNutzerId);
        if (sFirma != null) {
            sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        stmt.executeUpdate(sSQLStatement);
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPreiseGeladen(Connection con, String sFirma) throws SQLException {
        String sWert;
        ResultSet res;
        block3: {
            boolean bl;
            String sSQLStatement = SQLStatements.TeileinfoJAVA.instance.RETRIEVE_COUNT_PREISE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirma));
            log.debug("Executing: " + sSQLStatement);
            Statement stmt = null;
            res = null;
            sWert = "0";
            try {
                stmt = con.createStatement();
                res = stmt.executeQuery(sSQLStatement);
                if (res != null && res.next()) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            return bl;
        }
        sWert = res.getString(1);
        WebetkUtils.closeQuery(res);
        return !sWert.equals("0");
    }

    public static ResultSet loadTeilenummernErgebnisliste(Connection con, Collection<String> aSachnummern, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.Teileinfo.instance.SEARCH_SNR_FREMDNR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            Iterator<String> iter = aSachnummern.iterator();
            StringBuffer sbSachnuummern = new StringBuffer("(");
            while (iter.hasNext()) {
                String sFremdNr = iter.next();
                sFremdNr = StringUtils.maskiereHochkommaFuerDb(sFremdNr);
                if (sbSachnuummern.length() > 1) {
                    sbSachnuummern.append(", ");
                }
                sbSachnuummern.append("'");
                sbSachnuummern.append(sFremdNr);
                sbSachnuummern.append("'");
            }
            sbSachnuummern.append(")");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMERN", sbSachnuummern.toString());
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        Iterator<String> iter = aSachnummern.iterator();
        StringBuffer sbSachnuummern = new StringBuffer("(");
        while (iter.hasNext()) {
            String sFremdNr = iter.next();
            sFremdNr = StringUtils.maskiereHochkommaFuerDb(sFremdNr);
            if (sbSachnuummern.length() > 1) {
                sbSachnuummern.append(", ");
            }
            sbSachnuummern.append("'");
            sbSachnuummern.append(sFremdNr);
            sbSachnuummern.append("'");
        }
        sbSachnuummern.append(")");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMERN", sbSachnuummern.toString());
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

