/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.NoDataFoundException;
import webetk.app.asssuche.AssSucheInfo;
import webetk.db.SQLStatements;
import webetk.db.dbaccess.AllgemeinDbAccess;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileSucheAssDbAccess {
    private static Logger log = Logger.getLogger(TeileSucheAssDbAccess.class);

    public static ResultSet selectHGFGs(Connection con, String sMarke, String sProduktart, String sKatalogUmfang, String sSprache) throws SQLException, NoDataFoundException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.RETRIEVE_ALL_HGFGS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1008);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            ps.setString(12, sISO);
            ps.setString(13, sRegISO);
            ps.setString(1, sMarke);
            ps.setString(2, sProduktart);
            ps.setString(3, "BE");
            ps.setString(4, sKatalogUmfang);
            ps.setString(5, "00");
            ps.setString(8, sMarke);
            ps.setString(9, sProduktart);
            ps.setString(10, "BE");
            ps.setString(11, sKatalogUmfang);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            if (res == null || !res.isBeforeFirst()) {
                throw new NoDataFoundException("No HgFs found");
            }
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement(1004, 1008);
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.isBeforeFirst()) {
            throw new NoDataFoundException("No HgFs found");
        }
        return res;
    }

    public static ResultSet selectHGs(Connection con, boolean bGrafischeSuche, String sMarke, String sProduktart, String sKatalogUmfang, String sSprache) throws SQLException {
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            sSQLStatement = bGrafischeSuche ? SQLStatements.TeilesucheAss.instance.RETRIEVE_HGS_GRAF() : SQLStatements.TeilesucheAss.instance.RETRIEVE_HGS();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            ps.setString(9, "T");
            ps.setString(1, sMarke);
            ps.setString(8, sMarke);
            ps.setString(2, sProduktart);
            ps.setString(3, "BE");
            ps.setString(4, sKatalogUmfang);
            ps.setString(5, "00");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = bGrafischeSuche ? SQLStatements.TeilesucheAss.instance.RETRIEVE_HGS_GRAF() : SQLStatements.TeilesucheAss.instance.RETRIEVE_HGS();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectFGs(Connection con, String sMarke, String sProduktart, String sKatalogUmfang, String sHG, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.RETRIEVE_HGFGS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sMarke);
            ps.setString(2, sProduktart);
            ps.setString(3, "BE");
            ps.setString(4, sKatalogUmfang);
            ps.setString(5, sHG);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_Benennung(Connection con, String sSuchstring, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        sSuchstring = StringUtils.substituteStringStraight(sSuchstring, "*", "%");
        sSuchstring = StringUtils.maskiereHochkommaFuerDb(sSuchstring);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        boolean bSonderlocke = false;
        boolean bSonderlocke_tr = false;
        String sSuchstring1 = null;
        String sSuchstring2 = null;
        if (sISO.equals("de")) {
            bSonderlocke = StringUtils.enthaeltUmlautAndViceVersa(sSuchstring);
            if (bSonderlocke) {
                sSuchstring1 = sSuchstring;
                sSuchstring2 = StringUtils.replaceFirstUmlautAndViceVersa(sSuchstring);
            }
        } else if (sISO.equals("tr")) {
            boolean bl = bSonderlocke_tr = sSuchstring.indexOf("\u0131") > -1 || sSuchstring.indexOf("\u0130") > -1 || sSuchstring.indexOf("i") > -1 || sSuchstring.indexOf("I") > -1;
            if (bSonderlocke_tr) {
                sSuchstring = sSuchstring.toUpperCase(new Locale("tr", "TR"));
            }
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = null;
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            if (bSonderlocke) {
                sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_SONDERLOCKE();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
            } else if (bSonderlocke_tr) {
                sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_TR();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            } else {
                sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", SQLStatements.TeilesucheAss.instance.ORDER_BY_POS());
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = bSonderlocke ? SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_SONDERLOCKE() : (bSonderlocke_tr ? SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG_TR() : SQLStatements.TeilesucheAss.instance.SEARCH_BT_BENENNUNG());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", SQLStatements.TeilesucheAss.instance.ORDER_BY_POS());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        if (bSonderlocke) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_Begriff(Connection con, Collection cBegriffePlus, Collection cBegriffeMinus, Collection cBegriffeOder, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_BEGRIFF();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", SQLStatements.TeilesucheAss.instance.ORDER_BY_POS());
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSuchbegriffBen = AllgemeinDbAccess.erzeugeSuchbegriffBen(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
            sSQLStatement = sSuchbegriffBen == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", sSuchbegriffBen);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sSuchbegriffBen = AllgemeinDbAccess.erzeugeSuchbegriffBen(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
        sSQLStatement = sSuchbegriffBen == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_STMT", sSuchbegriffBen);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummern_Benennung(Connection con, String sSuchstring, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        sSuchstring = StringUtils.substituteStringStraight(sSuchstring, "*", "%");
        sSuchstring = StringUtils.maskiereHochkommaFuerDb(sSuchstring);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        boolean bSonderlocke = false;
        boolean bSonderlockeTr = false;
        String sSuchstring1 = null;
        String sSuchstring2 = null;
        if (sISO.equals("de")) {
            bSonderlocke = StringUtils.enthaeltUmlautAndViceVersa(sSuchstring);
            if (bSonderlocke) {
                sSuchstring1 = sSuchstring;
                sSuchstring2 = StringUtils.replaceFirstUmlautAndViceVersa(sSuchstring);
            }
        } else if (sISO.equals("tr") && (sSuchstring.indexOf("i") > -1 || sSuchstring.indexOf("I") > -1 || sSuchstring.indexOf(304) > -1 || sSuchstring.indexOf(305) > -1)) {
            bSonderlockeTr = true;
            sSuchstring = sSuchstring.toUpperCase(new Locale("tr", "TR"));
        }
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSQLStatement = null;
            if (bSonderlocke) {
                sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_SONDERLOCKE();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
            } else if (bSonderlockeTr) {
                sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_TR();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            } else {
                sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
            }
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", SQLStatements.TeilesucheAss.instance.ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER());
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = null;
        sSQLStatement = bSonderlocke ? SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_SONDERLOCKE() : (bSonderlockeTr ? SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG_TR() : SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BENENNUNG());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", SQLStatements.TeilesucheAss.instance.ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER());
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        if (bSonderlocke) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING1", sSuchstring1);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING2", sSuchstring2);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SUCHSTRING", sSuchstring);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummern_Begriff(Connection con, Collection cBegriffePlus, Collection cBegriffeMinus, Collection cBegriffeOder, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_SNR_BEGRIFF();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER", SQLStatements.TeilesucheAss.instance.ORDER_BY_BENENNUNG_HG_UG_SACHNUMMER());
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSuchbegriffTeil = AllgemeinDbAccess.erzeugeSuchbegriffBenTeil(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
            sSQLStatement = sSuchbegriffTeil == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", sSuchbegriffTeil);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String sSuchbegriffTeilKomm = AllgemeinDbAccess.erzeugeSuchbegriffBenTeilKomm(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
            sSQLStatement = sSuchbegriffTeilKomm == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", sSuchbegriffTeilKomm);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sSuchbegriffTeil = AllgemeinDbAccess.erzeugeSuchbegriffBenTeil(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
        sSQLStatement = sSuchbegriffTeil == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_STMT", sSuchbegriffTeil);
        String sSuchbegriffTeilKomm = AllgemeinDbAccess.erzeugeSuchbegriffBenTeilKomm(cBegriffePlus, cBegriffeMinus, cBegriffeOder, sISO);
        sSQLStatement = sSuchbegriffTeilKomm == null ? StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", "") : StringUtils.substituteString(sSQLStatement, "BEGRIFFE_BEN_TEIL_KOMM_STMT", sSuchbegriffTeilKomm);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_SNrCompl(Connection con, AssSucheInfo oAssSucheInfo, String sSachnummer, String sSprache, String btNummer) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_SACHNUMMER_COMPL();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", SQLStatements.TeilesucheAss.instance.ORDER_BY_POS());
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sMarke = oAssSucheInfo.getMarke();
            StringUtils.setPreparedStatementParams(++index, sMarke);
            sSachnummer = StringUtils.maskiereHochkommaFuerDb(sSachnummer);
            StringUtils.setPreparedStatementParams(++index, sSachnummer);
            String sProduktart = oAssSucheInfo.getProduktart();
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sMarke = oAssSucheInfo.getMarke();
        String sProduktart = oAssSucheInfo.getProduktart();
        String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSachnummer = StringUtils.maskiereHochkommaFuerDb(sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummer);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNUMMER", btNummer);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_BTNummer(Connection con, AssSucheInfo oAssSucheInfo, String sSachnummer, String sSprache, String btNummer) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_NUMMER_COMPL();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", SQLStatements.TeilesucheAss.instance.ORDER_BY_POS());
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
            ps.setString(1, sMarke);
            ps.setString(3, sProduktart);
            ps.setString(4, "BE");
            ps.setString(5, sKatalogUmfang);
            ps.setString(2, btNummer);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sMarke = oAssSucheInfo.getMarke();
        String sProduktart = oAssSucheInfo.getProduktart();
        String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNUMMER", btNummer);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummer_SNrIncompl(Connection con, AssSucheInfo oAssSucheInfo, String sSachnummerIncompl, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_SNR_SACHNUMMER_INCOMPL();
        sSachnummerIncompl = StringUtils.substituteStringStraight(sSachnummerIncompl, "*", "%");
        sSachnummerIncompl = StringUtils.substituteStringStraight(sSachnummerIncompl, "?", "_");
        sSachnummerIncompl = StringUtils.maskiereHochkommaFuerDb(sSachnummerIncompl);
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            ps.setString(8, sISO);
            ps.setString(9, sRegISO);
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
            ps.setString(1, sMarke);
            ps.setString(3, sProduktart);
            ps.setString(4, "BE");
            ps.setString(5, sKatalogUmfang);
            ps.setString(2, sSachnummerIncompl);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sMarke = oAssSucheInfo.getMarke();
        String sProduktart = oAssSucheInfo.getProduktart();
        String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER", sSachnummerIncompl);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchSachnummer_Sachnummern(Connection con, AssSucheInfo oAssSucheInfo, Collection<String> aSachnummern, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_SNR_FREMDNR();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
            StringUtils.setPreparedStatementParams(++index, sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aSachnummern.size()));
            for (String sFremdNr : aSachnummern) {
                StringUtils.setPreparedStatementParams(++index, sFremdNr);
            }
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sMarke = oAssSucheInfo.getMarke();
        String sProduktart = oAssSucheInfo.getProduktart();
        String sKatalogUmfang = oAssSucheInfo.getKatalogumfang();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        Iterator<String> iter = aSachnummern.iterator();
        StringBuffer sbFremd = new StringBuffer("(");
        while (iter.hasNext()) {
            String sFremdNr = iter.next();
            sFremdNr = StringUtils.maskiereHochkommaFuerDb(sFremdNr);
            if (sbFremd.length() > 1) {
                sbFremd.append(", ");
            }
            sbFremd.append("'");
            sbFremd.append(sFremdNr);
            sbFremd.append("'");
        }
        sbFremd.append(")");
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FREMDNUMMERN", sbFremd.toString());
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_SNrs(Connection con, Collection<String> cTeile, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_SACHNUMMERN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORDER_BY_POS", SQLStatements.TeilesucheAss.instance.ORDER_BY_POS());
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN3", StringUtils.preparePlaceHolders(cTeile.size()));
            for (String sSachnummern : cTeile) {
                StringUtils.setPreparedStatementParams(++index, sSachnummern);
            }
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sSachnummern = null;
        Iterator<String> iterator = cTeile.iterator();
        while (iterator.hasNext()) {
            String sSachnummer = iterator.next().toString();
            if (sSachnummern == null) {
                sSachnummern = "'" + sSachnummer + "'";
                continue;
            }
            sSachnummern = sSachnummern + ", '" + sSachnummer + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMERN", sSachnummern);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_HGFG(Connection con, String[] asHGFG, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        boolean bNurHg;
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_HGFG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            boolean bNurHg2;
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "BE");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            boolean bl = bNurHg2 = asHGFG.length == 1 && asHGFG[0].length() == 2;
            if (bNurHg2) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", SQLStatements.TeilesucheAss.instance.SEARCH_BILDTAF_HG());
                String sHG = asHGFG[0];
                StringUtils.setPreparedStatementParams(++index, sHG);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", SQLStatements.TeilesucheAss.instance.SEARCH_BILDTAF_HGFG());
                String sHgFgs = AllgemeinDbAccess.concatStrings(asHGFG, true);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGFGS", sHgFgs);
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        boolean bl = bNurHg = asHGFG.length == 1 && asHGFG[0].length() == 2;
        if (bNurHg) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", SQLStatements.TeilesucheAss.instance.SEARCH_BILDTAF_HG());
            String sHG = asHGFG[0];
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG/HGFG_STMT", SQLStatements.TeilesucheAss.instance.SEARCH_BILDTAF_HGFG());
            String sHgFgs = AllgemeinDbAccess.concatStrings(asHGFG, true);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGFGS", sHgFgs);
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet checkBildtafel_HG_Grafisch(Connection con, String sHG, String sMarke, String sProduktart, String sKatalogUmfang) throws SQLException {
        String sSQLStatement = SQLStatements.TeilesucheAss.instance.CHECK_BT_HG_GRAFISCH();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sMarke);
            ps.setString(2, sProduktart);
            ps.setString(3, "BE");
            ps.setString(4, sKatalogUmfang);
            ps.setString(5, sHG);
            ps.setString(6, "T");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_HG_Grafisch(Connection con, String sHG, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, boolean bMitGrafiken) throws SQLException {
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con) && !bMitGrafiken) {
            sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_HG_GRAFISCH();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            ps.setString(3, "T");
            ps.setString(4, sMarke);
            ps.setString(5, sProduktart);
            ps.setString(6, "BE");
            ps.setString(7, sKatalogUmfang);
            ps.setString(8, sHG);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_HG_GRAFISCH_MIT_GRAFIKEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet searchBildtafel_HG_FG_Grafisch(Connection con, String sHG, String sFG, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, boolean bMitGrafiken) throws SQLException {
        String sSQLStatement = null;
        if (HtmlUtils.isConnectionSourceOracle(con) && !bMitGrafiken) {
            sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_HG_FG_GRAFISCH();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, "T");
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            ps.setString(4, sMarke);
            ps.setString(5, sProduktart);
            ps.setString(6, "BE");
            ps.setString(7, sKatalogUmfang);
            ps.setString(8, sHG);
            ps.setString(9, sFG);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = SQLStatements.TeilesucheAss.instance.SEARCH_BT_HG_FG_GRAFISCH_MIT_GRAFIKEN();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FG", sFG);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void main(String[] args) {
    }
}

