/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class ValueLineDbAccess {
    private static Logger log = Logger.getLogger(ValueLineDbAccess.class);

    public static ResultSet loadHGs(Connection con, String sSprache, String sMarke, String sProduktart) throws SQLException {
        String sSQLStatement = SQLStatements.ValueLine.instance.LOAD_HGS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(7, sISO);
            ps.setString(8, sRegISO);
            ps.setString(1, sMarke);
            ps.setString(4, sProduktart);
            ps.setString(5, sProduktart);
            ps.setString(2, "J");
            ps.setString(3, "B");
            ps.setString(6, "00");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSaetze(Connection con, String sSprache, String sMarke, String sProduktart, String sKatalogumfang, String sHG, String sLandkuerzel) throws SQLException {
        String sSQLStatement = SQLStatements.ValueLine.instance.LOAD_SAETZE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            String sKatalogumfaenge = sKatalogumfang;
            if (sKatalogumfang.equals("ALLE")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(2));
                StringUtils.setPreparedStatementParams(++index, "VT");
                StringUtils.setPreparedStatementParams(++index, "ST");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(1));
                StringUtils.setPreparedStatementParams(++index, sKatalogumfaenge);
            }
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.SatzEinzelteile.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, "B");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sHG);
            StringUtils.setPreparedStatementParams(++index, "J");
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sKatalogumfaenge = "'" + sKatalogumfang + "'";
        if (sKatalogumfang.equals("ALLE")) {
            sKatalogumfaenge = "'VT', 'ST'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFAENGE", sKatalogumfaenge);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.SatzEinzelteile.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBteBaureihen(Connection con, String sSprache, String sMarke, String sProduktart, String sKatalogUmfang, Collection<String> cRegionen) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        String sSQLStatement = SQLStatements.ValueLine.instance.LOAD_BTE_BAUREIHEN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, "KONZERN");
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, "J");
            if (sKatalogUmfang == null || sKatalogUmfang.equals("ALLE")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG_STMT", "");
            }
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        if (sKatalogUmfang == null || sKatalogUmfang.equals("ALLE")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG_STMT", "");
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = "";
        Iterator<String> iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBildtafeln(Connection con, String sSprache, String sBaureihe, String sMarke, String sProduktart, String sKatalogUmfang, Collection<String> cRegionen) throws SQLException {
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        String sSQLStatement = SQLStatements.ValueLine.instance.LOAD_BILDTAFELN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, "J");
            StringUtils.setPreparedStatementParams(++index, sKatalogUmfang);
            StringUtils.setPreparedStatementParams(++index, "N");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cRegionen.size()));
            for (String sRegionen : cRegionen) {
                StringUtils.setPreparedStatementParams(++index, sRegionen);
            }
            StringUtils.setPreparedStatementParams(++index, sBaureihe);
            StringUtils.setPreparedStatementParams(++index, sMarke);
            StringUtils.setPreparedStatementParams(++index, sProduktart);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            StringUtils.setPreparedStatementParams(++index, "K");
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BAUREIHE", sBaureihe);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KATALOGUMFANG", sKatalogUmfang);
        String sRegionen = "";
        Iterator<String> iterator = cRegionen.iterator();
        while (iterator.hasNext()) {
            if (sRegionen.length() > 0) {
                sRegionen = sRegionen + ", ";
            }
            sRegionen = sRegionen + "'" + iterator.next() + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGIONEN", sRegionen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadTeilenummern(Connection con, String sSprache, String sMarke, String sProduktart) throws SQLException {
        String sSQLStatement = SQLStatements.ValueLine.instance.LOAD_TEILENUMMERN();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(1, sISO);
            ps.setString(1, sRegISO);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            ps.setString(5, "J");
            ps.setString(7, "J");
            ps.setString(1, sRegISO);
            ps.setString(6, sMarke);
            ps.setString(8, sProduktart);
            ps.setString(7, "B");
            log.debug("Executing: " + sSQLStatement);
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        log.debug("Executing: " + sSQLStatement);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

