/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.zub;

import webetk.db.zub.SQLStatements;

public final class SQLStatementsOracle
extends SQLStatements {

    public static final class Nutzer
    extends SQLStatements.Nutzer {
        @Override
        public final String INSERT_EMPTY_ZUB_USER() {
            return "INSERT INTO w_zub_user ( userz_firma_id, userz_id ) VALUES ( ?, ? ) ";
        }

        @Override
        public final String HAT_NUTZER_AGB_BESTAETIGT() {
            return "SELECT userz_agb_bestaetigt Bestaetigt FROM w_zub_user WHERE userz_firma_id = ? AND userz_id = ? ";
        }

        @Override
        public final String SET_USER_AGB_BESTAETIGT() {
            return "UPDATE w_zub_user SET userz_agb_bestaetigt = ? WHERE userz_firma_id = ? AND userz_id = ? ";
        }
    }

    public static final class Texte
    extends SQLStatements.Texte {
        @Override
        public final String ERMITTLE_TEXT_NACH_ID() {
            return "SELECT ben_text FROM w_ben_gk WHERE ben_textcode=? AND ben_iso=? AND ben_regiso=?";
        }
    }

    public static final class BestehendeAngebote
    extends SQLStatements.BestehendeAngebote {
        @Override
        public final String SUCHE_ANGEBOT() {
            return "SELECT vorganga_angebotsnummer angebotsNr,\n  vorganga_angebotsname angebotsName,\n  vorganga_datum_anlage anlageDatum,\n  vorganga_bindefrist bindeFrist,\n  coalesce(kunde_name, vorganga_kunde_name) kundeName,\n  coalesce(kunde_vorname, vorganga_kunde_vorname) kundeVorname,\n  user_id erstellerId,\n  userz_real_name ersteller,\n  vorganga_kunde_id kundeId,\n  vorgang_id vorgangId,\n  vorgangk_konfig_id konfigId,\n\t anfrage_id anfrageId,\n  vorgang_produkt_name produktName,\n  vorgang_produkt_btnr btnr,\n  vorgang_bildposnr bildPos,\n  vorganga_status status,\n  vorganga_an_ispa an_ispa,\n  vorganga_bemerkung bemerkung \n FROM (w_zub_konfig_angebot INNER JOIN w_zub_vorgang_konfiguration on vorganga_konfig_id = vorgangk_konfig_id \n  INNER JOIN w_zub_vorgang on vorgangk_vorgang_id = vorgang_id\n  INNER JOIN w_zub_anfrage on vorgang_anfrage_id = anfrage_id )\n\t LEFT OUTER JOIN w_zub_kunde on vorganga_kunde_id = kunde_id\n  LEFT OUTER JOIN w_zub_kunde_fahrzeug on kundefzg_id = kunde_id\n\t LEFT OUTER JOIN w_user on vorganga_user_id = user_id and anfrage_firma_id = user_firma_id\n\t LEFT OUTER JOIN w_zub_user on user_id = userz_id and user_firma_id = userz_firma_id\nWHERE vorganga_status in ('AKTUELL', 'STORNIERT')\n AND anfrage_marke_tps in (&MARKEN&) &ADD& ORDER BY vorganga_angebotsnummer";
        }
    }

    public static final class BestehendeAnfrage
    extends SQLStatements.BestehendeAnfrage {
        @Override
        public final String SUCHE_ANFRAGE() {
            return "select distinct anfrage_id anfrageId,\nanfrage_name anfrageName,\nanfragei_bemerkung bemerkung,\nanfrage_datum_anlage erstellungsdatum,\ncoalesce(kunde_name, anfragei_kunde_name) kundenName,\ncoalesce(kunde_vorname, anfragei_kunde_vorname) kundenVorname, \n anfragei_kunde_id kundenId,\nkunde_kundennummer kundenNummer,\nuser_id erstellerId,\nuserz_real_name ersteller,\nvorgang_id vorgangId,\nvorgang_produkt_name produktName,\nvorgang_produkt_btnr btnr,\nvorgang_bildposnr bildPos,\n(select count(*) from w_zub_konfig_angebot, w_zub_vorgang_konfiguration, w_zub_vorgang where vorgang_id = vorgang.vorgang_id and vorgangk_vorgang_id=vorgang_id and vorganga_konfig_id=vorgangk_konfig_id and vorganga_status in ('AKTUELL','ERSETZT')  AND vorganga_bindefrist >= ((to_char(YY of currentdate) || to_char(MO of currentdate) || to_char(DD of currentdate)) cast integer) ) offeneAngebote  \n from w_zub_anfrage \n   left outer join w_zub_anfrage_infos on anfrage_id = anfragei_anfrage_id \n  left outer join w_zub_kunde on anfragei_kunde_id = kunde_id\n  left outer join w_zub_kunde_fahrzeug on kundefzg_id = kunde_id\n  left outer join w_zub_vorgang vorgang on vorgang_anfrage_id = anfrage_id\n  left outer join w_user on anfrage_user_id_anlage = user_id and anfrage_firma_id = user_firma_id\n  left outer join w_zub_user on user_id = userz_id and user_firma_id = userz_firma_id \nwhere vorgang_id in (  select vorgangk_vorgang_id from (  select vorgangk_vorgang_id, vorgangk_konfig_id   from w_zub_vorgang_konfiguration  diff  select vorgangk_vorgang_id, vorgangk_konfig_id from w_zub_vorgang_konfiguration,     w_zub_konfig_angebot where vorganga_konfig_id = vorgangk_konfig_id ) )  AND anfrage_marke_tps in (&MARKEN&) &ADD&";
        }
    }

    public static final class Admin
    extends SQLStatements.Admin {
        @Override
        public final String ERMITTLE_NUTZER_LISTE() {
            return "SELECT user_name name,        user_id userId,\t\t\t\tuser_firma_id firma from w_user  where user_id <> 'score'  and user_firma_id = ? order by user_id";
        }

        @Override
        public final String ERMITTLE_NUTZER_INFO() {
            return "SELECT w_user.user_id userId,\n\t\t\t\tw_user.user_name userName,\n\t\t\t\tw_zub_user.userz_real_name realName,\n\t\t\t\tw_zub_user.userz_telefon telefon,\n\t\t\t\tw_zub_user.userz_email email,\n\t\t\t\tw_user.user_marktid marktId,\n\t\t\t\tw_user.user_bearbeiternummer bearbeiterNr,\n \t\t\t\tw_user.user_default_filiale_id filialId,\n\t\t\t\tw_filiale.filiale_bezeichnung filialName,\n\t\t\t\tcoalesce(w_user_einstellungen.user_iso,w_filiale.filiale_iso) iso,\n\t\t\t\tcoalesce(w_user_einstellungen.user_regiso, w_filiale.filiale_regiso) regIso\nFROM (w_user LEFT OUTER JOIN w_zub_user ON w_user.user_id = w_zub_user.userz_id AND w_user.user_firma_id = w_zub_user.userz_firma_id) LEFT OUTER JOIN \n\t\t\tw_user_einstellungen ON w_user.user_id = w_user_einstellungen.user_id and w_user.user_firma_id = w_user_einstellungen.user_firma_id\n LEFT OUTER JOIN     w_filiale ON w_user.user_default_filiale_id = w_filiale.filiale_id\nWHERE w_user.user_id = ? \nAND w_user.user_firma_id = ? ";
        }

        @Override
        public final String ERMITTLE_FILIAL_LISTE() {
            return "SELECT filiale_id filialId, \t\t\t\tfiliale_bezeichnung bez,\t\t\t\tfiliale_iso iso,\t\t\t\tfiliale_regiso regIso,\t\t\t\tkonfig_hd_strasse strasse,\t\t\t\tkonfig_hd_plz plz,\t\t\t\tkonfig_hd_ort ort,\t\t\t\tkonfig_hd_telefon telefon,\t\t\t\tkonfigz_fax fax,\t\t\t\tkonfigz_email email,\t\t\t\tkonfigz_default_markt_id markt,\t\t\t\tkonfigz_speicher_kunden speicherKz,\t\t\t\tkonfigz_verfuegbarkeit_pruefen verfuegbarKz FROM w_filiale LEFT OUTER JOIN ( w_konfig LEFT OUTER JOIN w_zub_konfig on (konfig_firma_id = konfigz_firma_id and konfig_filiale_id = konfigz_filiale_id)) ON filiale_id = konfig_filiale_id and filiale_firma_id = konfig_firma_id WHERE filiale_firma_id = ? \nORDER BY filiale_bezeichnung";
        }

        @Override
        public final String ERMITTLE_FIRMA_BEZ() {
            return "SELECT firma_bezeichnung bez FROM w_firma WHERE firma_id = ?";
        }

        @Override
        public final String ERMITTLE_FILIALE_ARBEITEN() {
            return "SELECT arbeit_geltungsbereich_art gbArt,\t\t\t\tarbeit_geltungsbereich_id gbId,\t\t\t\tarbeit_marke_tps marke,\t\t\t\tarbeit_produktart produktArt,\t\t\t\tarbeit_aufwand_id aufwandId,\t\t\t\tdecode(arbeit_geltungsbereich_art,'F','0',decode(arbeit_geltungsbereich_id,'0','2','1')) prio, \t\t\t\tarbeit_kritart kritArt,\t\t\t\tarbeit_art art,\t\t\t\tarbeit_kritwert kritWert\nFROM w_zub_arbeit\nWHERE arbeit_marke_tps = ? AND arbeit_produktart = ? AND arbeit_firma_id = ? AND arbeit_geltungsbereich_art = 'F' \nAND arbeit_geltungsbereich_id = ? ORDER BY arbeit_aufwand_id, arbeit_kritart, prio";
        }

        @Override
        public final String ERMITTLE_MARKT_IPAC_WERTE() {
            return "SELECT marktipacw_id marktId,\t\t\t\tmarktipacw_art art,\t\t\t\tmarktipacw_wert wert FROM w_markt_ipac_werte WHERE marktipacw_id in (0, ?) AND marktipacw_art like ''||?||'' AND marktipacw_produktart = ? ORDER BY marktipacw_id desc, marktipacw_art";
        }

        @Override
        public final String ERMITTLE_MARKT_SPEZIFIKA() {
            return "SELECT marktipac_bindefrist bindefrist, marktipac_kundendaten kundendaten, marktipac_anz_inkl_mwst mwst FROM w_markt_ipac WHERE marktipac_id in (0, ?)";
        }

        @Override
        public final String COUNT_ZUB_USERDATEN() {
            return "SELECT count(userz_id) cnt from w_zub_user WHERE userz_id = ? AND userz_firma_id = ?";
        }

        @Override
        public final String UPDATE_ZUB_USERDATEN() {
            return "UPDATE w_zub_user set userz_real_name=?, userz_telefon = ?, userz_email = ? WHERE userz_id = ? AND userz_firma_id = ?";
        }

        @Override
        public final String UPDATE_BEARBEITERNUMMER() {
            return "UPDATE w_user set user_bearbeiternummer=?WHERE user_id = ? AND user_firma_id = ?";
        }

        @Override
        public final String UPDATE_USER_EINSTELLUNGEN() {
            return "UPDATE w_user_einstellungen SET user_iso = ?,  user_regiso = ? WHERE user_firma_id = ? AND user_id = ? ";
        }

        @Override
        public final String UPDATE_FILIALDATEN() {
            return "UPDATE w_konfig set konfig_hd_strasse = ?,  konfig_hd_ort = ?,  konfig_hd_plz = ?,  konfig_hd_telefon = ? WHERE konfig_firma_id = ? AND konfig_filiale_id = ?";
        }

        @Override
        public final String COUNT_ZUB_FILIALDATEN() {
            return "SELECT COUNT(konfigz_filiale_id) cnt FROM w_zub_konfig WHERE konfigz_firma_id = ? AND konfigz_filiale_id = ?";
        }

        @Override
        public final String COUNT_FILIALE_KONFIG() {
            return "SELECT COUNT(konfig_filiale_id) cnt FROM w_konfig WHERE konfig_firma_id = ? AND konfig_filiale_id = ?";
        }

        @Override
        public final String UPDATE_ZUB_FILIALDATEN() {
            return "UPDATE w_zub_konfig set konfigz_fax = ?,  konfigz_email = ?,  konfigz_default_markt_id=?,  konfigz_speicher_kunden = ?,  konfigz_verfuegbarkeit_pruefen = ? WHERE konfigz_firma_id = ? AND konfigz_filiale_id = ?";
        }

        @Override
        public final String INSERT_ZUB_USERDATEN() {
            return "INSERT INTO w_zub_user(userz_firma_id,userz_id,userz_real_name,userz_telefon,userz_email) values (?, ?, ?, ?, ?)";
        }

        @Override
        public final String INSERT_KONFIG_FILIALE() {
            return "INSERT INTO w_konfig(konfig_firma_id, konfig_filiale_id, konfig_hs_verwenden, konfig_hd_strasse, konfig_hd_plz, konfig_hd_ort, konfig_hd_telefon) VALUES (?, ?, ?, ?, ?, ?, ?)";
        }

        @Override
        public final String INSERT_ZUB_FILIALDATEN() {
            return "INSERT INTO w_zub_konfig(konfigz_firma_id,konfigz_filiale_id,konfigz_fax,konfigz_email,konfigz_default_markt_id,konfigz_speicher_kunden,konfigz_verfuegbarkeit_pruefen) values (?,?,?,?,?,?,?)";
        }

        @Override
        public final String UPDATE_ARBEITEN() {
            return "UPDATE w_zub_arbeit set arbeit_kritwert = ? WHERE arbeit_firma_id = ?  AND arbeit_geltungsbereich_art = ? AND arbeit_geltungsbereich_id = ?  AND arbeit_marke_tps = ?  AND arbeit_produktart = ?  AND arbeit_aufwand_id = ?  AND arbeit_kritart = ? ";
        }

        @Override
        public final String DELETE_ARBEITEN() {
            return "DELETE FROM w_zub_arbeit WHERE arbeit_firma_id = ? AND arbeit_geltungsbereich_art = ? AND arbeit_geltungsbereich_id = ? AND arbeit_marke_tps = ? AND arbeit_produktart = ?";
        }

        @Override
        public final String DELETE_ARBEITEN_VOLLST() {
            return "DELETE FROM w_zub_arbeit WHERE arbeit_firma_id = ? AND arbeit_geltungsbereich_art = 'F' AND arbeit_geltungsbereich_id = ?";
        }

        @Override
        public final String ERMITTLE_ALLE_FILIALEN() {
            return "SELECT filiale_id filialId FROM w_filiale WHERE filiale_firma_id = ?";
        }

        @Override
        public final String INSERT_ARBEITEN() {
            return "INSERT INTO w_zub_arbeit(arbeit_firma_id,  arbeit_geltungsbereich_art,  arbeit_geltungsbereich_id,  arbeit_marke_tps,  arbeit_produktart,  arbeit_aufwand_id, arbeit_art,  arbeit_kritart,  arbeit_kritwert) TABLE (&TABELLE&)";
        }

        @Override
        public final String ERMITTLE_ANZAHL_USER() {
            return "SELECT COUNT(user_id) cnt FROM w_user where user_firma_id = ?&ADD&";
        }

        @Override
        public final String SUCHE_USER() {
            return "SELECT user_name name,        user_id userId,\t\t\t\tuser_firma_id firma from w_user  where user_id <> 'score'  and user_firma_id = ?  and ( user_id like '%'||?||'%'  or upper(user_name) like '%'||?||'%') order by user_id";
        }

        @Override
        public final String UPDATE_FILIALNAME() {
            return "update w_filiale set filiale_bezeichnung = ? where filiale_id = ? and filiale_firma_id = ?";
        }

        @Override
        public final String UPDATE_USER_MARKTID() {
            return "update w_user set user_marktid = ? where user_firma_id = ? and user_default_filiale_id = ?";
        }
    }

    public static final class Verwaltung
    extends SQLStatements.Verwaltung {
        @Override
        public final String GET_NEW_KUNDE_ID() {
            return "SELECT zub_kunde_id_seq.NEXTVAL id FROM zub_kunde_id_seq";
        }

        @Override
        public final String INSERT_KUNDE() {
            return "INSERT INTO w_zub_kunde ( kunde_anrede, kunde_name, kunde_vorname, kunde_kundennummer, kunde_strasse, kunde_hausnummer, kunde_land, kunde_plz, kunde_stadt, kunde_postfachnummer, kunde_telefon, kunde_mobiltelefon, kunde_faxnummer, kunde_email, kunde_bemerkung, kunde_geburtsdatum, kunde_id ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
        }

        @Override
        public final String UPDATE_KUNDE() {
            return "UPDATE w_zub_kunde SET kunde_anrede = ?, kunde_name = ?, kunde_vorname = ?, kunde_kundennummer = ?, kunde_strasse = ?, kunde_hausnummer = ?, kunde_land = ?, kunde_plz = ?, kunde_stadt = ?, kunde_postfachnummer = ?, kunde_telefon = ?, kunde_mobiltelefon = ?, kunde_faxnummer = ?, kunde_email = ?, kunde_bemerkung = ?, kunde_geburtsdatum = ? WHERE kunde_id  = ?";
        }

        @Override
        public final String INSERT_FAHRZEUG() {
            return "INSERT INTO w_zub_kunde_fahrzeug ( kundefzg_id, kundefzg_vin, kundefzg_kennzeichen ) VALUES ( ?, ?, ? )";
        }

        @Override
        public final String DELETE_FAHRZEUG() {
            return "DELETE FROM w_zub_kunde_fahrzeug WHERE kundefzg_id = ? AND   kundefzg_vin = ?";
        }

        @Override
        public final String DELETE_KUNDE_FAHRZEUGE() {
            return "DELETE FROM w_zub_kunde_fahrzeug WHERE kundefzg_id = ?";
        }

        @Override
        public final String DELETE_KUNDE() {
            return "DELETE FROM w_zub_kunde WHERE kunde_id = ?";
        }

        @Override
        public final String ERMITTLE_BNBS_ZU_KONFIGURATION() {
            return "SELECT DISTINCT btzeilenz_btnr bte,btzeilenz_bildposnr bnb , btzeilenz_elementart elementart FROM w_btzeilenzub  where btzeilenz_btnr = ?  AND coalesce(?,btzeilenz_bildposnr) = btzeilenz_bildposnr  AND btzeilenz_sachnr in (&TEILELISTE&) ";
        }

        @Override
        public final String INSERT_VORGANG_BEDINGUNGEN() {
            return "INSERT INTO w_zub_vorgang_bedingung TABLE ( &TABELLE& )";
        }

        @Override
        public final String ERMITTLE_VORGANG_BEDINGUNGEN() {
            return "SELECT vorgangbed_kez kez, \t\t\t\tvorgangbed_text text,\t\t\t\tvorgangbed_wert wert FROM w_zub_vorgang_bedingung WHERE vorgangbed_vorgang_id = ?";
        }

        @Override
        public final String PRUEFE_KUNDENNUMMER() {
            return "SELECT COUNT(*) from w_zub_kunde where kunde_kundennummer = ? and kunde_id <> ?";
        }
    }

    public static final class Preise
    extends SQLStatements.Preise {
        @Override
        public final String LOAD_TEILE_UND_PREISE_ZU_FZG_BTE() {
            return "select teil_hauptgr Hg, teil_untergrup Ug, teil_art Teileart, btzeilenz_pos Pos, btzeilenz_gehzupos Gehzupos, btzeilenz_bildposnr Bildpos, btzeilenz_art Art, btzeilenz_verw Verweis, btzeilenz_sachnr Sachnr, btzeilenz_elementart Elemart, btzeilenz_buendelung Buendel, btzeilenz_menge_min Mengemin, NVL(btzeilenzva_varianteid, 0) Variante from w_teil, w_btzeilenzub left outer join w_btzeilenzub_variante on (btzeilenz_btnr = btzeilenzva_btnr and btzeilenz_pos = btzeilenzva_pos) where btzeilenz_btnr = ? and teil_sachnr = btzeilenz_sachnr order by btzeilenz_pos";
        }

        @Override
        public final String LOAD_TEILE_UND_PREISE_ZU_UGB_BTE() {
            return "select teil_hauptgr Hg, teil_untergrup Ug, teil_art Teileart, btzeilenuz_pos Pos, btzeilenuz_gehzupos Gehzupos, btzeilenuz_bildposnr Bildpos, btzeilenuz_art Art, btzeilenuz_verw Verweis, btzeilenuz_sachnr Sachnr, btzeilenuz_elementart Elemart, btzeilenuz_buendelung Buendel, btzeilenuz_menge_min Mengemin, NVL(btzeilenzuva_varianteid, 0) Variante from w_teil, w_btzeilenzubugb left outer join w_btzeilenzubugb_variante on (btzeilenuz_btnr = btzeilenzuva_btnr and btzeilenuz_pos = btzeilenzuva_pos) where btzeilenuz_btnr = ? and teil_sachnr = btzeilenuz_sachnr order by btzeilenuz_pos";
        }

        @Override
        public final String LOAD_TEILE_UND_PREISE_ZU_MOSPIDS_FZG_BTE() {
            return "select distinct (btzeilenz_pos) Pos, teil_hauptgr Hg, teil_untergrup Ug, teil_art Teileart, btzeilenz_gehzupos Gehzupos, btzeilenz_bildposnr Bildpos, btzeilenz_art Art, btzeilenz_verw Verweis, btzeilenz_sachnr Sachnr, btzeilenz_elementart Elemart, btzeilenz_buendelung Buendel, btzeilenz_menge_min Mengemin, NVL(btzeilenzva_varianteid, 0) Variante from w_teil, w_btzeilenzub_verbauung, w_btzeilenzub left outer join w_btzeilenzub_variante on (btzeilenz_btnr = btzeilenzva_btnr and btzeilenz_pos = btzeilenzva_pos) where btzeilenz_btnr = ? and teil_sachnr = btzeilenz_sachnr and teil_sachnr = btzeilenz_sachnr and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_pos = btzeilenzv_pos and btzeilenzv_mospid IN (&MOSPIDS&) order by Pos";
        }

        @Override
        public final String LOAD_PREIS_ZU_TEIL() {
            return "select NVL(preise_evpreis, 0) EVP, NVL(preise_preis_kz, ' ') PreisKz, NVL(preise_mwst, 0) MwSt, NVL(preise_mwst_code, ' ') MwStCode from w_preise@etk_preise where preise_firma = ? and preise_sachnr = ?";
        }

        @Override
        public final String ERMITTLE_ALLE_EINBAUINFOS_ZU_BTENR() {
            return "select bildtafze_id ElemId, bildtafze_art Art, bildtafze_baureihe Br, einbauinfo_id InfoId, einbauinfo_komplexitaet Kompl, einbauinfo_lesart Lesart, einbauinfo_mechanisch Mech, einbauinfo_elektrisch Elek, einbauinfo_programm Prog, einbauinfo_lack Lack, einbauinfo_gesamt Ges from w_einbauinfo, w_bildtafzub_einbauinfo_markt where bildtafze_systemid = 1 and bildtafze_marktid = ? and bildtafze_btnr = ? and bildtafze_einbauinfoid = einbauinfo_id ";
        }
    }

    public static final class KonfigurationsHelper
    extends SQLStatements.KonfigurationsHelper {
        @Override
        public final String GET_NEW_KONFIGURATION_ID() {
            return "SELECT zub_konfiguration_id_seq.NEXTVAL id FROM zub_konfiguration_id_seq";
        }

        @Override
        public final String INSERT_KONFIGURATION() {
            return "INSERT INTO w_zub_vorgang_konfiguration (vorgangk_vorgang_id, vorgangk_konfig_id, vorgangk_aufabschlag, vorgangk_konfig_name, vorgangk_konfig_id_vorlage ) VALUES ( ?, ?, ?, ?, ?)";
        }

        @Override
        public final String INSERT_KONFIGURATION_BNB() {
            return "INSERT INTO w_zub_vorgang_konfiguration_bnb (vorgangkbnb_konfig_id,vorgangkbnb_bildposnr, vorgangkbnb_elementart ) TABLE ( &TABELLE& )";
        }

        @Override
        public final String INSERT_KONFIGURATION_VARIANTEN() {
            return "INSERT INTO w_zub_vorgang_konfig_bnb_var ( vorgangkbvar_konfig_id, vorgangkbvar_bildposnr, vorgangkbvar_variante_id )TABLE ( &TABELLE& )";
        }

        @Override
        public final String INSERT_KONFIGURATION_POSITIONEN() {
            return "INSERT INTO w_zub_vorgang_konfig_position (vorgangkp_konfig_id, vorgangkp_pos, vorgangkp_gruppe, vorgangkp_elementart, vorgangkp_status, vorgangkp_artikel_art, vorgangkp_artikel_nummer, vorgangkp_artikel_ben, vorgangkp_menge, vorgangkp_preis_netto, vorgangkp_rabatt, vorgangkp_mwst_satz, vorgangkp_mwst_betrag, vorgangkp_comment ) TABLE ( &TABELLE& )";
        }

        @Override
        public final String INSERT_KONFIGURATION_LASTSEEN() {
            return "INSERT INTO w_zub_user_konfig_lastseen(userkls_konfig_id, userkls_user_id, userkls_user_firma_id, userkls_view_id_last, userkls_datum) values (?, ?, ?, ?, ?)";
        }

        @Override
        public final String UPDATE_KONFIGURATION() {
            return "UPDATE w_zub_vorgang_konfiguration SET vorgangk_konfig_name = ?,vorgangk_aufabschlag = ? WHERE vorgangk_konfig_id = ?";
        }

        @Override
        public final String UPDATE_KONFIGURATION_LASTSEEN() {
            return "UPDATE w_zub_user_konfig_lastseen set userkls_view_id_last  = ?, userkls_datum = ? WHERE userkls_konfig_id = ? and userkls_user_id = ? AND userkls_user_firma_id=?";
        }

        @Override
        public final String DELETE_KONFIGURATION() {
            return "DELETE FROM w_zub_vorgang_konfiguration WHERE vorgangk_konfig_id = ?";
        }

        @Override
        public final String DELETE_KONFIGURATION_ANGEBOT() {
            return "DELETE FROM w_zub_konfig_angebot WHERE vorganga_konfig_id = ?";
        }

        @Override
        public final String DELETE_KONFIGURATION_POSITIONEN() {
            return "DELETE FROM w_zub_vorgang_konfig_position WHERE vorgangkp_konfig_id = ?";
        }

        @Override
        public final String DELETE_KONFIGURATION_BNB_VARIANTEN() {
            return "DELETE FROM w_zub_vorgang_konfig_bnb_var WHERE vorgangkbvar_konfig_id = ?";
        }

        @Override
        public final String DELETE_KONFIGURATION_BNB() {
            return "DELETE FROM w_zub_vorgang_konfiguration_bnb WHERE vorgangkbnb_konfig_id = ?";
        }

        @Override
        public final String DELETE_KONFIGURATION_LASTSEEN() {
            return "DELETE FROM w_zub_user_konfig_lastseen WHERE userkls_konfig_id = ?";
        }

        @Override
        public final String LOAD_KONFIGURATION() {
            return "SELECT vorgangk_vorgang_id id, vorgangk_konfig_name name, vorgangk_aufabschlag aufabschlag, vorgangk_konfig_id_vorlage vorlage FROM   w_zub_vorgang_konfiguration WHERE  vorgangk_konfig_id = ?";
        }

        @Override
        public final String LOAD_KONFIGURATION_VARIANTEN() {
            return "SELECT vorgangkbnb_bildposnr AS bildposnr,\t\tvorgangkbnb_elementart AS alementart, \t\tvorgangkbvar_variante_id AS varianteid FROM w_zub_vorgang_konfiguration_bnb LEFT OUTER JOIN w_zub_vorgang_konfig_bnb_var ON  vorgangkbnb_konfig_id=vorgangkbvar_konfig_id AND     vorgangkbnb_bildposnr=vorgangkbvar_bildposnr WHERE vorgangkbnb_konfig_id=?";
        }

        @Override
        public final String LOAD_KONFIGURATION_POSITIONEN() {
            return "SELECT vorgangkp_gruppe gruppe, vorgangkp_elementart elementArt, vorgangkp_status status, vorgangkp_artikel_art artikelArt, vorgangkp_artikel_nummer artikelNr, vorgangkp_artikel_ben artikelBenennung, vorgangkp_menge menge, vorgangkp_preis_netto preis, vorgangkp_rabatt rabatt, vorgangkp_pos pos,vorgangkp_mwst_satz mwStSatz,vorgangkp_mwst_betrag mwStBetrag, vorgangkp_comment comment FROM w_zub_vorgang_konfig_position WHERE vorgangkp_konfig_id = ? ORDER BY vorgangkp_pos";
        }

        @Override
        public final String LOAD_KONFIGURATION_LETZTE_SICHT() {
            return "SELECT userkls_view_id_last sicht FROM w_zub_user_konfig_lastseen WHERE userkls_user_id = ? AND userkls_user_firma_id = ? AND userkls_konfig_id = ? ";
        }

        @Override
        public final String LOAD_KONFIGURATION_ANGEBOT() {
            return "SELECT vorganga_angebotsnummer nummer, vorganga_gesamt2_netto netto, vorganga_gesamt2_brutto brutto, vorganga_status status, vorganga_status_datum statusDatum, vorganga_datum_anlage anlageDatum, vorganga_bindefrist bindefrist, vorganga_user_id userID, vorganga_kunde_id k_id,kunde_kundennummer k_nummer, coalesce(kunde_anrede, vorganga_kunde_anrede) k_anrede,\ncoalesce(kunde_name, vorganga_kunde_name) k_name,\ncoalesce(kunde_vorname, vorganga_kunde_vorname) k_vorname,\ncoalesce(kunde_strasse, vorganga_kunde_strasse) k_strasse,\ncoalesce(kunde_hausnummer, vorganga_kunde_hausnummer) k_hausnummer,\ncoalesce(kunde_land, vorganga_kunde_land) k_land,\ncoalesce(kunde_plz, vorganga_kunde_plz) k_plz,\ncoalesce(kunde_stadt, vorganga_kunde_stadt) k_stadt,\ncoalesce(kunde_postfachnummer, vorganga_kunde_postfachnummer) k_postfach,\ncoalesce(kunde_telefon, vorganga_kunde_telefon) k_telefon,\ncoalesce(kunde_mobiltelefon, vorganga_kunde_mobiltelefon) k_mobil,\ncoalesce(kunde_faxnummer, vorganga_kunde_faxnummer) k_fax,\ncoalesce(kunde_email, vorganga_kunde_email) k_email,\nkunde_bemerkung k_bemerkung,\nkunde_geburtsdatum k_geburtsdaum,\nvorganga_angebotsname angebotsName,\n vorganga_an_ispa an_ispa,\n vorganga_bemerkung bemerkung \n FROM w_zub_konfig_angebot LEFT OUTER JOIN w_zub_kunde on vorganga_kunde_id = kunde_id\n WHERE vorganga_konfig_id = ? ";
        }

        @Override
        public final String UPDATE_KONFIGURATION_POSITION() {
            return "update w_zub_vorgang_konfig_position  set vorgangkp_gruppe = ?, \t\t\tvorgangkp_elementart=?, \t\t\tvorgangkp_status=?, \t\t\tvorgangkp_artikel_ben\t=?, \t\t\tvorgangkp_menge=?, \t\t\tvorgangkp_preis_netto=?, \t\t\tvorgangkp_rabatt=?, \t\t\tvorgangkp_comment=? \n where vorgangkp_konfig_id=?  and vorgangkp_pos = ? ";
        }

        @Override
        public final String DELETE_KONFIGURATION_POSITION() {
            return "delete from w_zub_vorgang_konfig_position where vorgangkp_konfig_id = ? and vorgangkp_pos = ?";
        }

        @Override
        public final String UPDATE_KONFIG_VORLAGE() {
            return "update w_zub_vorgang_konfiguration set vorgangk_konfig_id_vorlage = null where vorgangk_konfig_id_vorlage = ?";
        }

        @Override
        public final String GET_LAST_KONFIG_POSID() {
            return "select nvl(max(vorgangkp_pos),0) from w_zub_vorgang_konfig_position where vorgangkp_konfig_id=?";
        }

        @Override
        public final String DELETE_VORGANG_LASTSEEN() {
            return "DELETE FROM w_zub_user_vorgang_lastseen WHERE uservls_konfig_id_last = ?";
        }

        @Override
        public final String KOPIERE_KONFIGURATION() {
            return "INSERT INTO w_zub_vorgang_konfiguration(vorgangk_vorgang_id, vorgangk_konfig_id, vorgangk_konfig_name, vorgangk_aufabschlag, vorgangk_konfig_id_vorlage) SELECT vorgangk_vorgang_id, (''||?||'' ) cast integer, vorgangk_konfig_name, vorgangk_aufabschlag, vorgangk_konfig_id FROM w_zub_vorgang_konfiguration WHERE vorgangk_konfig_id=?";
        }

        @Override
        public final String KOPIERE_KONFIGURATION_BNB_VAR() {
            return "INSERT INTO w_zub_vorgang_konfig_bnb_var(vorgangkbvar_konfig_id, vorgangkbvar_bildposnr, vorgangkbvar_variante_id)SELECT (''||?||'' ) cast integer, \t\tvorgangkbvar_bildposnr, \t\tvorgangkbvar_variante_id FROM w_zub_vorgang_konfig_bnb_var WHERE vorgangkbvar_konfig_id=?";
        }

        @Override
        public final String KOPIERE_KONFIGURATION_BNB() {
            return "INSERT INTO w_zub_vorgang_konfiguration_bnb(vorgangkbnb_konfig_id,vorgangkbnb_bildposnr, vorgangkbnb_elementart )SELECT (''||?||'' ) cast integer,  \t\tvorgangkbnb_bildposnr, \t\tvorgangkbnb_elementart FROM w_zub_vorgang_konfiguration_bnb WHERE vorgangkbnb_konfig_id=?";
        }

        @Override
        public final String KOPIERE_KONFIGURATION_POSITIONEN() {
            return "INSERT INTO w_zub_vorgang_konfig_position(vorgangkp_konfig_id, vorgangkp_pos, vorgangkp_gruppe, vorgangkp_elementart, vorgangkp_status, vorgangkp_artikel_art, vorgangkp_artikel_nummer, vorgangkp_artikel_ben, vorgangkp_menge, vorgangkp_preis_netto, vorgangkp_rabatt, vorgangkp_comment ) SELECT (''||?||'' ) cast integer, vorgangkp_pos, vorgangkp_gruppe, vorgangkp_elementart, vorgangkp_status, vorgangkp_artikel_art, vorgangkp_artikel_nummer, vorgangkp_artikel_ben, vorgangkp_menge, vorgangkp_preis_netto, vorgangkp_rabatt, vorgangkp_comment FROM w_zub_vorgang_konfig_position WHERE vorgangkp_konfig_id = ?";
        }

        @Override
        public final String KOPIERE_KONFIGURATION_LASTSEEN() {
            return "INSERT INTO w_zub_user_konfig_lastseen(userkls_user_id,userkls_user_firma_id, userkls_konfig_id, userkls_view_id_last,userkls_datum)SELECT userkls_user_id, userkls_user_firma_id, (''||?||'') cast integer, userkls_view_id_last, currentdate FROM w_zub_user_konfig_lastseen WHERE userkls_konfig_id = ? AND userkls_user_id = ? AND userkls_user_firma_id = ?";
        }

        @Override
        public final String KOPIERE_VORGANG_LASTSEEN() {
            return "INSERT INTO w_zub_user_vorgang_lastseen(uservls_user_id, uservls_user_firma_id, uservls_vorgang_id, uservls_konfig_id_last, uservls_datum) VALUES ( ? , ?, ?, ?, currentdate)";
        }

        @Override
        public final String KOPIERE_ANFRAGE_LASTSEEN() {
            return "INSERT INTO w_zub_user_anfrage_lastseen(userals_user_id, userals_user_firma_id, userals_anfrage_id, userals_vorgang_id_last, userals_datum) VALUES ( ? , ?, ?, ?, currentdate)";
        }

        @Override
        public final String SETZE_MWST() {
            return "UPDATE w_zub_vorgang_konfig_position set vorgangkp_mwst_satz = ?, vorgangkp_mwst_betrag = ? where vorgangkp_konfig_id = ? and vorgangkp_pos = ?";
        }

        @Override
        public final String SETZE_KONFIGNAME() {
            return "UPDATE w_zub_vorgang_konfiguration set vorgangk_konfig_name = ? where vorgangk_konfig_id = ? ";
        }
    }

    public static final class AngebotsHelper
    extends SQLStatements.AngebotsHelper {
        @Override
        public final String GET_NEW_ANGEBOTSNUMMER() {
            return "SELECT zub_angebotsnr_id_seq.NEXTVAL a_nr FROM zub_angebotsnr_id_seq";
        }

        @Override
        public final String INSERT_ANGEBOT() {
            return "INSERT INTO w_zub_konfig_angebot (vorganga_konfig_id, vorganga_angebotsnummer, vorganga_gesamt2_netto, vorganga_gesamt2_brutto, vorganga_status, vorganga_status_datum, vorganga_datum_anlage, vorganga_bindefrist, vorganga_user_id, vorganga_user_firma_id, vorganga_kunde_id, vorganga_kunde_anrede, vorganga_kunde_name, vorganga_kunde_vorname, vorganga_kunde_kundennummer, vorganga_kunde_strasse, vorganga_kunde_hausnummer, vorganga_kunde_land, vorganga_kunde_plz, vorganga_kunde_stadt, vorganga_kunde_postfachnummer, vorganga_kunde_telefon, vorganga_kunde_mobiltelefon, vorganga_kunde_faxnummer, vorganga_kunde_email,vorganga_angebotsname, vorganga_bemerkung ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
        }

        @Override
        public final String UPDATE_ANGEBOT() {
            return "UPDATE w_zub_konfig_angebot SET vorganga_gesamt2_netto = ?, vorganga_gesamt2_brutto = ?, vorganga_status = ?, vorganga_status_datum = ?, vorganga_datum_anlage = ?, vorganga_bindefrist = ?, vorganga_user_id = ?, vorganga_user_firma_id = ?, vorganga_kunde_id = ?, vorganga_kunde_anrede = ?, vorganga_kunde_name = ?, vorganga_kunde_vorname = ?, vorganga_kunde_kundennummer = ?, vorganga_kunde_strasse = ?, vorganga_kunde_hausnummer = ?, vorganga_kunde_land = ?, vorganga_kunde_plz = ?, vorganga_kunde_stadt = ?, vorganga_kunde_postfachnummer = ?, vorganga_kunde_telefon = ?, vorganga_kunde_mobiltelefon = ?, vorganga_kunde_faxnummer = ?, vorganga_kunde_email = ?, vorganga_angebotsname = ?, vorganga_bemerkung = ? WHERE vorganga_angebotsnummer = ?";
        }

        @Override
        public final String DELETE_ANGEBOT() {
            return "DELETE from w_zub_konfig_angebot where vorganga_angebotsnummer = ?";
        }

        @Override
        public final String STORNIERE_ANGEBOT() {
            return "UPDATE w_zub_konfig_angebot set vorganga_status = ?,\tvorganga_status_datum = ? WHERE vorganga_angebotsnummer = ?";
        }

        @Override
        public final String STORNIERE_ANGEBOT_KONFIG() {
            return "UPDATE w_zub_konfig_angebot set vorganga_status = ?,\tvorganga_status_datum = ? WHERE vorganga_konfig_id = ?";
        }

        @Override
        public final String ERMITTLE_KONFIG() {
            return "SELECT vorganga_konfig_id konfig_id from w_zub_konfig_angebot WHERE vorganga_angebotsnummer = ?";
        }

        @Override
        public final String SETZE_AN_ISPA() {
            return "UPDATE w_zub_konfig_angebot SET vorganga_an_ispa = 'J' where vorganga_konfig_id = ?";
        }
    }

    public static final class AnfrageVorgangsHelper
    extends SQLStatements.AnfrageVorgangsHelper {
        @Override
        public final String LOAD_ANFRAGE() {
            return "SELECT anfrage_id id, anfrage_name name, anfrage_marke_tps marke, anfrage_produktart produktart, anfrage_datum_anlage anlageDatum, anfrage_user_id_anlage anlageUser, anfrage_firma_id firma, anfrage_filiale_id filiale, anfrage_datum_aender aenderungsDatum, anfrage_user_id_aender aenderungsUser, anfrage_gesperrt_von gesperrtVon, anfragei_kunde_id k_id, coalesce(kunde_anrede, anfragei_kunde_anrede) k_anrede, coalesce(kunde_name, anfragei_kunde_name) k_name, coalesce(kunde_vorname, anfragei_kunde_vorname) k_vorname, coalesce(kunde_kundennummer, cast (anfragei_kunde_kundennummer as char(7)) ) k_nummer, coalesce(kunde_strasse, anfragei_kunde_strasse) k_strasse, coalesce(kunde_hausnummer, anfragei_kunde_hausnummer) k_hausnummer, coalesce(kunde_land, anfragei_kunde_land) k_land, coalesce(kunde_plz, anfragei_kunde_plz)\tk_plz, coalesce(kunde_stadt, anfragei_kunde_stadt)\tk_stadt, coalesce(kunde_postfachnummer, anfragei_kunde_postfachnummer) k_postfach, coalesce(kunde_telefon, anfragei_kunde_telefon)\tk_telefon, coalesce(kunde_mobiltelefon, anfragei_kunde_mobiltelefon) k_mobil, coalesce(kunde_faxnummer, anfragei_kunde_faxnummer)\tk_fax, coalesce(kunde_email, anfragei_kunde_email) k_email, anfragei_bemerkung bemerkung, anfragei_stichworte stichworte, anfragei_anfrage_id infoId FROM  w_zub_anfrage LEFT OUTER JOIN w_zub_anfrage_infos ON anfrage_id = anfragei_anfrage_id \tLEFT OUTER JOIN w_zub_kunde on anfragei_kunde_id = kunde_id WHERE anfrage_id = ?";
        }

        @Override
        public final String LOAD_ANFRAGEN_VORGAENGE() {
            return "SELECT distinct vorgang_id id, vorgang_produkt_name name, valid valid FROM  w_zub_vorgang LEFT OUTER JOIN w_zub_vorgang_konfiguration ON vorgang_id = vorgangk_vorgang_id LEFT OUTER JOIN w_zub_konfig_angebot ON vorgangk_konfig_id = vorganga_konfig_id WHERE vorgang_anfrage_id = ? AND vorganga_konfig_id is null ORDER BY id";
        }

        @Override
        public final String LOAD_ANFRAGEN_ALLE_VORGAENGE() {
            return "SELECT distinct vorgang_id id, vorgang_produkt_name name, valid valid FROM  w_zub_vorgang LEFT OUTER JOIN w_zub_vorgang_konfiguration ON vorgang_id = vorgangk_vorgang_id LEFT OUTER JOIN w_zub_konfig_angebot ON vorgangk_konfig_id = vorganga_konfig_id WHERE vorgang_anfrage_id = ? ORDER BY id";
        }

        @Override
        public final String LOAD_ANFRAGE_VORGANG_DEFAULT_ID() {
            return "SELECT userals_vorgang_id_last vorgang FROM w_zub_user_anfrage_lastseen WHERE userals_anfrage_id = ? AND userals_user_id = ? AND userals_user_firma_id = ?";
        }

        @Override
        public final String LOAD_VORGANG() {
            return "SELECT vorgang_id id, vorgang_produkt_btnr btnr, vorgang_bildposnr bildpos, vorgang_produkt_name name, vorgang_datum_anlage anlageDatum, vorgang_datum_aender aenderungsDatum, vorgang_anfrage_id anfrageId FROM  w_zub_vorgang WHERE vorgang_id = ?";
        }

        @Override
        public final String LOAD_VORGANG_FAHRZEUGINFO() {
            return "SELECT vorgangfzg_kritart art, vorgangfzg_kritwert wert FROM   w_zub_vorgang_fahrzeug WHERE  vorgangfzg_vorgang_id = ?";
        }

        @Override
        public final String LOAD_EXISTING_VORGANG_KATEGORIE() {
            return "NUR TRANSBASE";
        }

        @Override
        public final String LOAD_VORGANG_KATEGORIE() {
            return "SELECT benhk.ben_text hk, benuk.ben_text uk FROM w_bildtafzub, w_hk_uk_sa, w_hauptkategorie, w_unterkategorie, w_ben_gk benhk, w_ben_gk benuk, w_bildtaf , w_bildtaf_marke WHERE ((bildtafz_salaid = hkuksa_salaid) AND (hkuksa_hkid = hauptkat_id) AND (hkuksa_ukid = unterkat_id) AND (hauptkat_textcode = benhk.ben_textcode) AND (unterkat_textcode = benuk.ben_textcode) AND (bildtafz_btnr = ?) AND (bildtafz_btnr = bildtaf_btnr ) AND (bildtafm_btnr = bildtaf_btnr ) AND (bildtafm_marke_tps = hkuksa_marke_tps )AND (bildtaf_produktart = hkuksa_produktart )AND (benuk.ben_iso = ?) AND (benhk.ben_iso = ?) AND (benuk.ben_regiso = ?) AND (benhk.ben_regiso = ?) )";
        }

        @Override
        public final String LOAD_VORGANGS_KONFIGURATIONEN() {
            return "SELECT vorgangk_konfig_id id, vorgangk_konfig_name name,vorganga_angebotsnummer angebotsnummer, vorganga_status status FROM  w_zub_vorgang_konfiguration LEFT OUTER JOIN w_zub_konfig_angebot ON \t\tvorgangk_konfig_id = vorganga_konfig_id WHERE vorgangk_vorgang_id = ? AND vorganga_konfig_id is null";
        }

        @Override
        public final String ERMITTLE_ANZAHL_KONFIG_ANGEBOTE_ZU_VORGANG() {
            return "SELECT count(*) anzahl from  w_zub_vorgang_konfiguration , w_zub_konfig_angebot WHERE vorgangk_konfig_id = vorganga_konfig_id  AND vorgangk_vorgang_id = ?";
        }

        @Override
        public final String ERMITTLE_ANZAHL_KONFIG_VON_VORGANG() {
            return "SELECT count(*) anzahl FROM  w_zub_vorgang_konfiguration LEFT OUTER JOIN w_zub_konfig_angebot ON \t\tvorgangk_konfig_id = vorganga_konfig_id WHERE vorgangk_vorgang_id = ? AND vorganga_konfig_id is null";
        }

        @Override
        public final String LOAD_VORGANGS_KONFIGURATIONEN_ANGEBOT() {
            return "SELECT vorgangk_konfig_id id, vorgangk_konfig_name name,vorganga_angebotsnummer angebotsnummer, vorganga_status status FROM  w_zub_vorgang_konfiguration LEFT OUTER JOIN w_zub_konfig_angebot ON vorgangk_konfig_id = vorganga_konfig_id WHERE vorgangk_vorgang_id = ? AND vorganga_konfig_id is not null";
        }

        @Override
        public final String LOAD_VORGANG_KONFIGURATION_DEFAULT_ID() {
            return "SELECT uservls_konfig_id_last konfiguration,\t\t\t\tvorgangk_konfig_name konfigname FROM w_zub_user_vorgang_lastseen,\t\t\tw_zub_vorgang_konfiguration WHERE uservls_vorgang_id = ? AND uservls_user_id = ? AND uservls_user_firma_id = ? AND uservls_vorgang_id = vorgangk_vorgang_id AND uservls_konfig_id_last = vorgangk_konfig_id";
        }

        @Override
        public final String LOAD_VORGANG_KONFIGURATION_DEFAULT_ID_FIRST_VIEW() {
            return "SELECT uservls_konfig_id_last konfiguration,\t\t\t\tvorgangk_konfig_name konfigname FROM w_zub_user_vorgang_lastseen,\t\t\tw_zub_vorgang_konfiguration WHERE uservls_vorgang_id = ? AND uservls_user_firma_id = ? AND uservls_vorgang_id = vorgangk_vorgang_id AND uservls_konfig_id_last = vorgangk_konfig_id";
        }

        @Override
        public final String UPDATE_ANFRAGE() {
            return "UPDATE w_zub_anfrage SET anfrage_name = ?, anfrage_datum_aender = ?, anfrage_user_id_aender = ? WHERE anfrage_id = ?";
        }

        @Override
        public final String UPDATE_ANFRAGE_LAST_VORGANG() {
            return "UPDATE w_zub_user_anfrage_lastseen SET userals_vorgang_id_last = ?, \tuserals_datum = ? WHERE userals_anfrage_id = ? AND userals_user_id = ? AND userals_user_firma_id = ?";
        }

        @Override
        public final String ERMITTLE_ANZAHL_ANFRAGE_INFOS() {
            return "SELECT count(*) cnt from w_zub_anfrage_infos where anfragei_anfrage_id = ?";
        }

        @Override
        public final String UPDATE_ANFRAGE_INFOS() {
            return "UPDATE w_zub_anfrage_infos SET anfragei_kunde_id = ?, anfragei_kunde_anrede = ?, anfragei_kunde_name = ?, anfragei_kunde_vorname = ?, anfragei_kunde_kundennummer = ?, anfragei_kunde_strasse = ?, anfragei_kunde_hausnummer = ?, anfragei_kunde_land = ?, anfragei_kunde_plz = ?, anfragei_kunde_stadt = ?, anfragei_kunde_postfachnummer = ?, anfragei_kunde_telefon = ?, anfragei_kunde_mobiltelefon = ?, anfragei_kunde_faxnummer = ?, anfragei_kunde_email = ?, anfragei_bemerkung = ?, anfragei_stichworte = ? WHERE anfragei_anfrage_id = ?";
        }

        @Override
        public final String GET_NEW_ANFRAGE_ID() {
            return "SELECT zub_anfrage_id_seq.NEXTVAL id FROM zub_anfrage_id_seq";
        }

        @Override
        public final String INSERT_ANFRAGE() {
            return "INSERT INTO w_zub_anfrage (anfrage_id, anfrage_marke_tps, anfrage_produktart, anfrage_name, anfrage_datum_anlage, anfrage_user_id_anlage, anfrage_datum_aender, anfrage_user_id_aender, anfrage_firma_id, anfrage_filiale_id, anfrage_gesperrt_von) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
        }

        @Override
        public final String INSERT_ANFRAGE_INFOS() {
            return "INSERT INTO w_zub_anfrage_infos (anfragei_anfrage_id, anfragei_kunde_id, anfragei_kunde_anrede, anfragei_kunde_name, anfragei_kunde_vorname, anfragei_kunde_kundennummer, anfragei_kunde_strasse, anfragei_kunde_hausnummer, anfragei_kunde_land, anfragei_kunde_plz, anfragei_kunde_stadt, anfragei_kunde_postfachnummer, anfragei_kunde_telefon, anfragei_kunde_mobiltelefon, anfragei_kunde_faxnummer, anfragei_kunde_email, anfragei_bemerkung, anfragei_stichworte) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
        }

        @Override
        public final String INSERT_ANFRAGE_LAST_VORGANG() {
            return "INSERT INTO w_zub_user_anfrage_lastseen (userals_anfrage_id, userals_user_id, userals_user_firma_id, userals_vorgang_id_last, userals_datum) values (?, ?, ?, ?, ?)";
        }

        @Override
        public final String UPDATE_VORGANG() {
            return "UPDATE w_zub_vorgang SET  vorgang_produkt_btnr = ?, vorgang_bildposnr = ?, vorgang_produkt_name = ?, vorgang_datum_anlage = ?, vorgang_datum_aender = ? WHERE vorgang_id = ?";
        }

        @Override
        public final String UPDATE_VORGANG_LAST_KONFIG() {
            return "UPDATE w_zub_user_vorgang_lastseen SET uservls_konfig_id_last = ?, \tuservls_datum = ? WHERE uservls_vorgang_id = ? AND uservls_user_id = ? AND uservls_user_firma_id = ?";
        }

        @Override
        public final String GET_NEW_VORGANG_ID() {
            return "SELECT zub_vorgang_id_seq.NEXTVAL id FROM zub_vorgang_id_seq";
        }

        @Override
        public final String INSERT_VORGANG() {
            return "INSERT INTO w_zub_vorgang (vorgang_anfrage_id, vorgang_id, vorgang_produkt_btnr, vorgang_bildposnr, vorgang_produkt_name, vorgang_datum_anlage, vorgang_datum_aender) VALUES ( ?, ?, ?, ?, ?, ?, ? )";
        }

        @Override
        public final String INSERT_VORGANG_FAHRZEUG() {
            return "INSERT INTO w_zub_vorgang_fahrzeug (vorgangfzg_vorgang_id, vorgangfzg_kritart, vorgangfzg_kritwert) TABLE ( &TABELLE& )";
        }

        @Override
        public final String INSERT_VORGANG_LAST_KONFIG() {
            return "INSERT INTO w_zub_user_vorgang_lastseen (uservls_vorgang_id, uservls_user_id, uservls_user_firma_id, uservls_konfig_id_last, uservls_datum) values (?, ?, ?, ?, ?)";
        }

        @Override
        public final String DELETE_ANFRAGE() {
            return "DELETE FROM w_zub_anfrage WHERE anfrage_id = ?";
        }

        @Override
        public final String DELETE_ANFRAGE_INFOS() {
            return "DELETE FROM w_zub_anfrage_infos WHERE anfragei_anfrage_id = ?";
        }

        @Override
        public final String DELETE_ANFRAGE_VORGANG_LASTSEEN() {
            return "DELETE FROM w_zub_user_anfrage_lastseen WHERE userals_anfrage_id = ?";
        }

        @Override
        public final String DELETE_VORGANG() {
            return "DELETE FROM w_zub_vorgang WHERE vorgang_id = ?";
        }

        @Override
        public final String DELETE_VORGANG_FAHRZEUG() {
            return "DELETE FROM w_zub_vorgang_fahrzeug WHERE vorgangfzg_vorgang_id = ?";
        }

        @Override
        public final String DELETE_VORGANG_KONFIG_LASTSEEN() {
            return "DELETE FROM w_zub_user_vorgang_lastseen WHERE uservls_vorgang_id = ?";
        }

        @Override
        public final String DELETE_VORGANG_BEDINGUNGEN() {
            return "DELETE FROM w_zub_vorgang_bedingung WHERE vorgangbed_vorgang_id = ?";
        }

        @Override
        public final String DELETE_VORGANG_LASTSEEN() {
            return "DELETE FROM w_zub_user_anfrage_lastseen WHERE userals_vorgang_id_last = ?";
        }

        @Override
        public final String HAT_OFFENE_ANGEBOTE() {
            return "SELECT count(*) anzahl from w_zub_konfig_angebot, w_zub_vorgang_konfiguration, w_zub_vorgang WHERE vorgang_anfrage_id = ? AND vorgangk_vorgang_id = vorgang_id AND vorgangk_konfig_id = vorganga_konfig_id AND vorganga_status in ('AKTUELL', 'ERSETZT')AND vorganga_bindefrist >= ((to_char(YY of currentdate) || to_char(MO of currentdate) || to_char(DD of currentdate)) cast integer)";
        }

        @Override
        public final String ENTSPERRE_ANFRAGE() {
            return "UPDATE w_zub_anfrage set anfrage_gesperrt_von = NULL WHERE ( anfrage_gesperrt_von = ? or anfrage_gesperrt_von IS NULL ) AND anfrage_id = ?";
        }

        @Override
        public final String ENTSPERRE_ALLE_ANFRAGEN() {
            return "UPDATE w_zub_anfrage set anfrage_gesperrt_von = NULL WHERE anfrage_gesperrt_von = ? ";
        }

        @Override
        public final String SPERRE_ANFRAGE() {
            return "UPDATE w_zub_anfrage set anfrage_gesperrt_von = ? WHERE anfrage_id = ? and ( anfrage_gesperrt_von is null or anfrage_gesperrt_von = ? )";
        }
    }

    public static final class TechnischeSicht
    extends SQLStatements.TechnischeSicht {
        @Override
        public final String RETRIEVE_BTEKOMMENTAR() {
            return "select distinct komm_id KommId, ben_text Text, komm_code Code, komm_vz VZ,  komm_darstellung Darstellung, komm_tiefe Tiefe,  komm_pos Pos from w_bildtafzub_komm, w_ben_gk, w_komm where bildtafzk_btnr = ? and bildtafzk_kommid = komm_id and komm_textcode = ben_textcode and bildtafzk_art = ? and bildtafzk_bildposnr = '00'  and bildtafzk_zeilenpos = -1 and ben_iso = ? and ben_regiso = ? order by KommId, Pos";
        }

        @Override
        public final String LOAD_EXPLOSIONSGRAFIKEN() {
            return "select bildtaf_btnr bte,\n\t\t\t\tgrafik_blob bild,\n\t\t\t\tgrafik_format format,\n\t\t\t\tgrafik_laenge laenge,\n\t\t\t\tgrafik_art art \nfrom w_bildtaf,\n\t\t\tw_grafik\nwhere bildtaf_btnr = ?\nand bildtaf_grafikid = grafik_grafikid\nand grafik_art = ?";
        }

        @Override
        public final String LOAD_ZUBBT_STAMM() {
            return "select distinct bildtafz_btnr BildtafelNr, bildtaf_bteart BildtafelArt, ben_text Benennung, bildtafz_bedkez BedKuerzel, bildtaf_grafikid GrafikId, grafik_moddate ModStamp from w_bildtaf inner join w_bildtafzub on (bildtaf_btnr = bildtafz_btnr)  right join w_grafik on (bildtaf_grafikid = grafik_grafikid)  inner join w_ben_gk on (bildtaf_textc = ben_textcode and ben_iso = ? and  ben_regiso = ?)  where bildtafz_btnr = ?";
        }

        @Override
        public final String LOAD_ZUBBT_BEDELEM_SALA() {
            return "select distinct bildtafzbe_elemid ElementId, bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, bedsala_saz SAZ, eg_pos EGruppenPosition, bedsala_pnr PrimaNr from w_btzeilenzub_verbauung, w_btzeilenzub, w_ben_gk, w_bed_sala, w_bed, w_eg, w_bildtafzub_bedelem where btzeilenzv_btnr = ? and btzeilenzv_mospid = ? and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_pos = btzeilenzv_pos and btzeilenz_bedkez is not null and btzeilenz_bildposnr in (&BILDPOSNR&) and bildtafzbe_btnr = btzeilenz_btnr and bildtafzbe_kez = btzeilenz_bedkez and bed_elemid = bildtafzbe_elemid  and bed_elemid = bedsala_id and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? union select distinct bildtafzbe_elemid ElementId, bedsala_art || bedsala_pnr || bedsala_hz Code, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, bedsala_saz SAZ, eg_pos EGruppenPosition, bedsala_pnr PrimaNr from w_bildtafzub, w_ben_gk, w_bed_sala, w_bed, w_eg, w_bildtafzub_bedelem where bildtafz_btnr = ? and bildtafz_bedkez is not null and bildtafz_btnr = bildtafzbe_btnr and bildtafz_bedkez = bildtafzbe_kez and bildtafzbe_elemid = bed_elemid and bed_elemid = bedsala_id and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? order by EGruppenPosition, PrimaNr";
        }

        @Override
        public final String LOAD_ZUBBT_BEDELEM_TEXT() {
            return "select distinct bildtafzbe_elemid ElementId, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, eg_pos EGruppenPosition from w_btzeilenzub_verbauung, w_btzeilenzub, w_ben_gk, w_bed_sala, w_bed, w_eg, w_bildtafzub_bedelem where btzeilenzv_btnr = ? and btzeilenzv_mospid = ? and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_pos = btzeilenzv_pos and btzeilenz_bedkez is not null and btzeilenz_bildposnr in (&BILDPOSNR&) and bildtafzbe_btnr = btzeilenz_btnr and bildtafzbe_kez = btzeilenz_bedkez and bed_elemid = bildtafzbe_elemid  and bed_ogid = 'TEXT' and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? union select distinct bildtafzbe_elemid ElementId, ben_text Benennung, bed_egid EGruppenId, eg_exklusiv Exklusiv, eg_pos EGruppenPosition from w_bildtafzub, w_ben_gk, w_bed_sala, w_bed, w_eg, w_bildtafzub_bedelem where bildtafz_btnr = ? and bildtafz_bedkez is not null and bildtafz_btnr = bildtafzbe_btnr and bildtafz_bedkez = bildtafzbe_kez and bildtafzbe_elemid = bed_elemid and bed_ogid = 'TEXT' and bed_egid = eg_id and bed_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? order by EGruppenPosition, Benennung";
        }

        @Override
        public final String LOAD_ZUBBT_BEDINGUNGEN_FZG() {
            return "select distinct bildtafzbg_kez Kuerzel, bildtafzbg_vz  GesamttermVZ, bildtafzbg_gesamtterm Gesamtterm, bildtafzbo_ogid OG, bildtafzbo_vart VArt, bildtafzbo_fzeile FZeile, bildtafzbe_vz ElementVZ, bildtafzbe_elemid ElementId, bildtafzbe_pos Pos from w_btzeilenzub_verbauung, w_btzeilenzub, w_bildtafzub_bedelem, w_bildtafzub_bedog, w_bildtafzub_bedgesamt where btzeilenzv_btnr = ? and btzeilenzv_mospid = ? and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_pos = btzeilenzv_pos and btzeilenz_bedkez is not null and btzeilenz_bildposnr in (&BILDPOSNR&) and btzeilenz_btnr = bildtafzbg_btnr and btzeilenz_bedkez = bildtafzbg_kez  and bildtafzbg_btnr = bildtafzbo_btnr and bildtafzbg_kez = bildtafzbo_kez and bildtafzbo_btnr = bildtafzbe_btnr and bildtafzbo_kez = bildtafzbe_kez and bildtafzbo_ogid = bildtafzbe_ogid union select distinct bildtafzbg_kez Kuerzel, bildtafzbg_vz  GesamttermVZ, bildtafzbg_gesamtterm Gesamtterm, bildtafzbo_ogid OG, bildtafzbo_vart VArt, bildtafzbo_fzeile FZeile, bildtafzbe_vz ElementVZ, bildtafzbe_elemid ElementId, bildtafzbe_pos Pos from w_bildtafzub, w_bildtafzub_bedelem, w_bildtafzub_bedog, w_bildtafzub_bedgesamt where bildtafz_btnr = ? and bildtafz_bedkez is not null and bildtafz_btnr = bildtafzbg_btnr  and bildtafz_bedkez = bildtafzbg_kez and bildtafzbg_btnr = bildtafzbo_btnr and bildtafzbg_kez = bildtafzbo_kez and bildtafzbo_btnr = bildtafzbe_btnr and bildtafzbo_kez = bildtafzbe_kez and bildtafzbo_ogid = bildtafzbe_ogid order by Kuerzel, OG, Pos";
        }

        @Override
        public final String LOAD_ZUBBT_UEBERBEDINGUNGEN_FZG() {
            return "select distinct bildtafzbu_kez Kuerzel, bildtafzbu_kezueber KuerzelUeber from w_bildtafzub_bedueber where bildtafzbu_btnr = ? order by Kuerzel, KuerzelUeber";
        }

        @Override
        public final String LOAD_BTZEILEN_FZG() {
            return "select distinct btzeilenz_bildposnr Bildnummer, teil_hauptgr Teil_HG, teil_untergrup Teil_UG, teil_sachnr Teil_Sachnummer, ben_text Teil_Benennung, teil_benennzus Teil_Zusatz, teil_entfall_kez Teil_Entfall, teil_textcode_kom Teil_Kommentar_Id, teil_kom_pi Teil_Komm_PI, teil_vorhanden_si Teil_SI, teil_ist_reach Teil_Reach,  teil_ist_aspg Teil_Aspg,  teil_ist_stecker Teil_Stecker,  null Teil_TC, btzeilenzv_vmenge Menge, btzeilenz_kat Kat_KZ, btzeilenz_automatik Getriebe_KZ, btzeilenz_lenkg Lenkung_KZ, btzeilenz_eins Einsatz, btzeilenz_auslf Auslauf, btzeilenz_bedkez || nvl(to_char(btzeilenz_regelnr), '') Bedingung_KZ, 0 KommBT, 0 KommVor, 0 KommNach, teil_rueck_pfl Ruecksendepflicht, null Satz_Sachnummer,  btzeilenz_pos ZubPos, btzeilenz_gehzupos ZubGehoertZuPos, btzeilenz_elementart ZubElementart, btzeilenz_buendelung ZubBuendelung, btzeilenz_art ZubArt, btzeilenz_verw ZubVerweis, btzeilenz_gruppeid GruppeId from w_btzeilenzub_verbauung inner join w_btzeilenzub on (btzeilenzv_btnr = btzeilenz_btnr and btzeilenzv_pos = btzeilenz_pos and btzeilenz_bildposnr in (&BILDPOSNR&)) inner join w_teil on (btzeilenz_sachnr = teil_sachnr) inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) where btzeilenzv_mospid = ? and btzeilenzv_btnr = ? order by ZubPos";
        }

        @Override
        public final String LOAD_BTZEILEN_CP_FZG() {
            return "select distinct btzeilenzc_pos Pos, btzeilenzc_typ Typ, btzeilenzc_werk Werk, btzeilenzc_art Art, btzeilenzc_datum Datum, btzeilenzc_vin Vin, btzeilenzc_vin_proddatum VinProddatum, btzeilenzc_vin_min VinMin, btzeilenzc_vin_max VinMax, btzeilenzc_nart NummerArt, btzeilenzc_nummer Nummer from w_btzeilenzub_cp where btzeilenzc_mospid = &MOSP& and btzeilenzc_btnr = '&BTNR&' &CP_FZG_TYP_WERK& order by Pos";
        }

        @Override
        public final String CP_FZG_TYP_WERK() {
            return "   and btzeilenzc_typ = '&TYP&' and btzeilenzc_werk = '&WERK&'";
        }

        @Override
        public final String LOAD_BTZEILEN_FZG_RELEVANT_BZGL_VARIANTE() {
            return "(select distinct btzeilenz_pos ZubPos  from w_btzeilenzub  where btzeilenz_btnr = ?    and btzeilenz_bildposnr in (&BILDPOSNR&) diff select distinct btzeilenz_pos ZubPos  from w_btzeilenzub, w_btzeilenzub_variante  where btzeilenz_btnr = ?    and btzeilenzva_btnr = btzeilenz_btnr    and btzeilenzva_pos = btzeilenz_pos)  &LOAD_BTZEILEN_FZG_RELEVANT_BZGL_VARIANTE_PRO_BNB&  order by ZubPos";
        }

        @Override
        public final String LOAD_BTZEILEN_FZG_RELEVANT_BZGL_VARIANTE_PRO_BNB() {
            return "select distinct btzeilenz_pos ZubPos  from w_btzeilenzub, w_btzeilenzub_variante  where btzeilenz_btnr = '&BTENR&'    and btzeilenzva_btnr = btzeilenz_btnr    and btzeilenzva_pos = btzeilenz_pos    and btzeilenz_bildposnr = '&BILDPOSNR&'    and btzeilenzva_varianteid = &VARIANTENID& ";
        }

        @Override
        public final String LOAD_BTZEILEN_UGB_BZGL_VARIANTE() {
            return "(select distinct btzeilenuz_pos ZubPos  from w_btzeilenzubugb  where btzeilenuz_btnr = ?    and btzeilenuz_bildposnr in (&BILDPOSNR&) diff select distinct btzeilenuz_pos ZubPos  from w_btzeilenzubugb, w_btzeilenzubugb_variante  where btzeilenuz_btnr = ?    and btzeilenzuva_btnr = btzeilenuz_btnr    and btzeilenzuva_pos = btzeilenuz_pos)  &LOAD_BTZEILEN_FZGUGB_RELEVANT_BZGL_VARIANTE_PRO_BNB&  order by ZubPos";
        }

        @Override
        public final String LOAD_BTZEILEN_FZGUGB_RELEVANT_BZGL_VARIANTE_PRO_BNB() {
            return " select distinct btzeilenuz_pos ZubPos  from w_btzeilenzubugb, w_btzeilenzubugb_variante  where btzeilenuz_btnr = '&BTENR&'    and btzeilenzuva_btnr = btzeilenuz_btnr    and btzeilenzu_bildposnr = '&BILDPOSNR&'    and btzeilenzuva_pos = btzeilenuz_pos    and btzeilenzuva_varianteid = &VARIANTENID& ";
        }

        @Override
        public final String PRUEFE_VARIANTENAUSWAHL_FUER_FAHRZEUG() {
            return "select distinct btzeilenzva_varianteid  from w_btzeilenzub, w_btzeilenzub_verbauung, w_btzeilenzub_variante  where btzeilenzv_mospid = ? and btzeilenzv_btnr = btzeilenz_btnr  and btzeilenzv_pos = btzeilenz_pos  and btzeilenzva_btnr = btzeilenz_btnr  and btzeilenzva_pos = btzeilenz_pos  and btzeilenz_btnr = ?  and coalesce(?,btzeilenz_bildposnr)=btzeilenz_bildposnr ";
        }

        @Override
        public final String PRUEFE_ALTERNATIVENAUSWAHL_FUER_FAHRZEUG() {
            return "select distinct btzeilenz_btnr btnr,\t\t\t\t\t\t\t\t btzeilenz_bildposnr bildpos,\t\t\t\t\t\t\t\t btzeilenz_auslf auslauf  from w_btzeilenzub, w_btzeilenzub_verbauung  where btzeilenzv_mospid = ? and btzeilenzv_btnr = btzeilenz_btnr  and btzeilenzv_pos = btzeilenz_pos  and btzeilenz_btnr = ?  and btzeilenz_elementart = ?  and coalesce(?,btzeilenz_bildposnr)=btzeilenz_bildposnr ";
        }

        @Override
        public final String PRUEFE_ZUBEHOERAUSWAHL_FUER_FAHRZEUG() {
            return "select distinct btzeilenz_btnr btnr,\t\t\t\t\t\t\t\t btzeilenz_bildposnr bildpos, \t\t\t\t\t\t\t\t btzeilenz_auslf auslauf,\t\t\t\t\t\t\t\t btzeilenz_lenkg lenkung,\t\t\t\t\t\t\t\t btzeilenz_eins einsatz,\t\t\t\t\t\t\t\t btzeilenz_automatik automatik from w_btzeilenzub, w_btzeilenzub_verbauung  where btzeilenzv_mospid = ? and btzeilenzv_btnr = btzeilenz_btnr  and btzeilenzv_pos = btzeilenz_pos  and btzeilenz_btnr = ?  and btzeilenz_elementart = ?  and coalesce(?,btzeilenz_bildposnr)=btzeilenz_bildposnr ";
        }

        @Override
        public final String ERMITTLE_EINBAUINFO_ZU_BTE() {
            return "select bildtafze_id,einbauinfo_id, coalesce(ben_text, einbauinfo_komplexitaet) einbauinfo_komplexitaet,einbauinfo_lesart,einbauinfo_mechanisch,einbauinfo_elektrisch,einbauinfo_programm,einbauinfo_lack,einbauinfo_gesamt from w_bildtafzub_einbauinfo_markt, w_einbauinfo LEFT OUTER JOIN (select ben_text, publben_bezeichnung from w_publben, w_ben_gk where ben_iso=? and ben_regiso=? and ben_textcode = publben_textcode and publben_art='EIK' ) ON einbauinfo_komplexitaet = publben_bezeichnung where bildtafze_systemid = 1 and bildtafze_marktid = ? and bildtafze_btnr = ? and bildtafze_id = ? and bildtafze_art = ? and bildtafze_baureihe in ('OHNE', ?) and bildtafze_einbauinfoid = einbauinfo_id ";
        }

        @Override
        public final String ERMITTLE_EINBAUINFO_ZU_BNB() {
            return "select bildtafze_id,einbauinfo_id, einbauinfo_komplexitaet,einbauinfo_lesart,einbauinfo_mechanisch,einbauinfo_elektrisch,einbauinfo_programm,einbauinfo_lack,einbauinfo_gesamt from w_einbauinfo, w_bildtafzub_einbauinfo_markt where bildtafze_systemid = 1 and bildtafze_marktid = ? and bildtafze_btnr = ? and bildtafze_art = ? and bildtafze_baureihe in ('OHNE', ?) and bildtafze_einbauinfoid = einbauinfo_id ";
        }

        @Override
        public final String ERMITTLE_REFA_ARBEIT_ZU_BTE() {
            return "select refa_id, refa_awnummer, refa_kommid, bildtafzr_aw   from w_bildtafzub_refa, w_refa  where bildtafzr_btnr = ?  and bildtafzr_mospid = ?  &TYP_FEST&  &TYP_BESTIMMEN&  and bildtafzr_refaid = refa_id ";
        }

        @Override
        public final String TYP_FEST() {
            return " and bildtafzr_typschl = ?";
        }

        @Override
        public final String TYP_BESTIMMEN() {
            return " and bildtafzr_typschl in (select fztyp_typschl from w_fztyp where fztyp_mospid = ?)  ";
        }

        @Override
        public final String ERMITTLE_REFA_ARBEIT_ZU_BNB() {
            return "select refa_id, refa_awnummer, refa_kommid, bildtafzbnbr_aw  from w_bildtafzub_bnb_refa, w_refa  where bildtafzbnbr_btnr = ?  and bildtafzbnbr_bildpos = ?  and bildtafzbnbr_mospid = ?  &TYP_FEST_BNB&  &TYP_BESTIMMEN_BNB&  and bildtafzbnbr_refaid = refa_id ";
        }

        @Override
        public final String TYP_FEST_BNB() {
            return " and bildtafzbnbr_typschl = ?";
        }

        @Override
        public final String TYP_BESTIMMEN_BNB() {
            return " and bildtafzbnbr_typschl in (select fztyp_typschl from w_fztyp where fztyp_mospid = ?)  ";
        }

        @Override
        public final String ERMITTLE_REFA_BENENNUNG() {
            return "select komm_pos POS, ben_text REFA_KOMM  FROM w_komm, w_ben_gk ben1 where komm_id = ? and ben1.ben_iso = ? and ben1.ben_regiso = ? and ben1.ben_textcode = komm_textcode order by komm_pos";
        }

        @Override
        public final String LOAD_BTZEILEN_UGB() {
            return "select distinct btzeilenuz_bildposnr Bildnummer, teil_hauptgr Teil_HG, teil_untergrup Teil_UG, teil_sachnr Teil_Sachnummer, ben_text Teil_Benennung, teil_benennzus Teil_Zusatz, teil_entfall_kez Teil_Entfall, teil_textcode_kom Teil_Kommentar_Id, teil_kom_pi Teil_Komm_PI, teil_vorhanden_si Teil_SI, teil_ist_reach Teil_Reach,  teil_ist_aspg Teil_Aspg,  teil_ist_stecker Teil_Stecker,  null Teil_TC, 1 Menge, btzeilenuz_eins Einsatz, btzeilenuz_auslf Auslauf, btzeilenuz_mmg MMG, btzeilenuz_emg EMG, btzeilenuz_eins Einsatz, btzeilenuz_auslf Auslauf, 0 KommVor, 0 KommNach, teil_rueck_pfl Ruecksendepflicht, ks_sachnr_satz Satz_Sachnummer,  btzeilenuz_pos ZubPos, btzeilenuz_gehzupos ZubGehoertZuPos, btzeilenuz_elementart ZubElementart, btzeilenuz_buendelung ZubBuendelung, btzeilenuz_art ZubArt, btzeilenuz_verw ZubVerweis, 0 GruppeId from w_btzeilenzubugb_verbauung inner join w_btzeilenzubugb on (btzeilenzuv_btnr = btzeilenuz_btnr and btzeilenzuv_pos = btzeilenuz_pos) inner join w_teil on (btzeilenuz_sachnr = teil_sachnr) inner join w_ben_gk on (teil_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?) left join w_kompl_satz on (btzeilenuz_sachnr = ks_sachnr_satz and ks_marke_tps = ?) where btzeilenzuv_marke_tps = ? and btzeilenzuv_btnr = ?  and btzeilenuz_bildposnr = NVL(?, btzeilenuz_bildposnr)  order by ZubPos";
        }
    }

    public static final class MarketingSicht
    extends SQLStatements.MarketingSicht {
        @Override
        public final String ERMITTLE_MARKETINGINFOS_ZU_BTE() {
            return "select bildtafzm_btnr,mprod_text, mprod_art, mprod_text_laenge text_laenge from w_marketingprodukt_text m, w_bildtafzub_marketing where bildtafzm_btnr = ? and bildtafzm_produktid = mprod_produktid and mprod_marktid = ? and mprod_spriso = ? and mprod_sprregiso = ? ";
        }

        @Override
        public final String ERMITTLE_SPEZIFISCHE_MARKETINGINFOS_ZU_BTE() {
            return this.ERMITTLE_MARKETINGINFOS_ZU_BTE() + " and mprod_art = ?";
        }

        @Override
        public final String ERMITTLE_BTEART() {
            return "select bildtaf_bteart from w_bildtaf where bildtaf_btnr=?";
        }

        @Override
        public final String ERMITTLE_FZABH_BESTANDTEILE_ZU_BTE() {
            return "select distinct btzeilenz_btnr, btzeilenz_bildposnr,btzeilenz_elementart,ben1.ben_text from w_btzeilenzub zeile\t\t\tLEFT OUTER JOIN w_bildtafzub_bnb ON btzeilenz_bildposnr = bildtafzb_bildposnr and btzeilenz_btnr = bildtafzb_btnr  \t\tLEFT OUTER JOIN (select * from w_ben_gk WHERE ben_iso = ? and ben_regiso = ? ) ben1 ON bildtafzb_textcode = ben1.ben_textcode where btzeilenz_btnr= ? and coalesce(?,btzeilenz_bildposnr)=btzeilenz_bildposnr order by btzeilenz_btnr, btzeilenz_bildposnr";
        }

        @Override
        public final String ERMITTLE_FZGABH_ALTERNATIVNAMEN_BNB() {
            return "select ben_text FROM w_btzeilenzub, \tw_teil, w_ben_gk WHERE ben_textcode = teil_textcode and teil_sachnr = btzeilenz_sachnr and btzeilenz_btnr = ? and btzeilenz_bildposnr = ? and ben_iso = ? and ben_regiso = ? and btzeilenz_art = 'NORMAL'";
        }

        @Override
        public final String ERMITTLE_FZUABH_BESTANDTEILE_ZU_BTE() {
            return "select distinct btzeilenuz_btnr, btzeilenuz_bildposnr,btzeilenuz_elementart,ben1.ben_text from w_btzeilenzubugb LEFT OUTER JOIN w_bildtafzub_bnb ON  btzeilenuz_bildposnr = bildtafzb_bildposnr and btzeilenuz_btnr = bildtafzb_btnr LEFT OUTER JOIN (select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben1 ON bildtafzb_textcode = ben1.ben_textcode where btzeilenuz_btnr = ? and coalesce(?,btzeilenuz_bildposnr)=btzeilenuz_bildposnr order by btzeilenuz_btnr, btzeilenuz_bildposnr";
        }

        @Override
        public final String ERMITTLE_FZGUABH_ALTERNATIVNAMEN_BNB() {
            return "select ben_text FROM w_btzeilenzubugb, \tw_teil, w_ben_gk WHERE ben_textcode = teil_textcode and teil_sachnr = btzeilenuz_sachnr and btzeilenuz_btnr = ? and btzeilenuz_bildposnr = ? and ben_iso = ? and ben_regiso = ?and btzeilenuz_art = 'NORMAL'";
        }

        @Override
        public final String ERMITTLE_OPTIONALE_PRODUKTE_FZABH_ZU_BTE() {
            return "select btzeilenz_btnr,\t\t\t\tbtzeilenz_bildposnr from w_btzeilenzub where btzeilenz_btnr = ? and coalesce(?, btzeilenz_bildposnr)=btzeilenz_bildposnr and btzeilenz_elementart = ?";
        }

        @Override
        public final String ERMITTLE_OPTIONALE_PRODUKTE_FZUABH_ZU_BTE() {
            return "select btzeilenuz_btnr,\t\t\t\tbtzeilenuz_bildposnr from w_btzeilenzubugb where btzeilenuz_btnr = ? and coalesce(?, btzeilenuz_bildposnr)=btzeilenuz_bildposnr and btzeilenuz_elementart = ?";
        }

        @Override
        public final String ERMITTLE_OPTIONALE_PRODUKTINFOS_FZABH_ZU_BTE() {
            return "select distinct mprod_text text,mprod_art art, mprod_text_laenge text_laenge from (w_btzeilenzub LEFT OUTER JOIN w_bildtafzub_bnb_marketing ON btzeilenz_btnr = to_char(bildtafzbnb_btnr) AND btzeilenz_bildposnr = bildtafzbnb_bildpos)\tLEFT OUTER JOIN (SELECT * FROM w_marketingprodukt_text where mprod_marktid = ? and mprod_spriso = ? and mprod_sprregiso = ? ) ON bildtafzbnb_produktid = mprod_produktid where btzeilenz_btnr = ? and btzeilenz_bildposnr = ?and btzeilenz_elementart = ? ";
        }

        @Override
        public final String ERMITTLE_OPTIONALE_PRODUKTINFOS_FZUABH_ZU_BTE() {
            return "select  distinct mprod_text,mprod_art, btzeilenuz_btnr, btzeilenuz_bildposnr, mprod_text_laenge text_laenge from (w_btzeilenzubugb LEFT OUTER JOIN w_bildtafzub_bnb_marketing ON btzeilenuz_btnr = to_char(bildtafzbnb_btnr) AND btzeilenuz_bildposnr = bildtafzbnb_bildpos)\tLEFT OUTER JOIN (SELECT * FROM w_marketingprodukt_text where mprod_marktid = ? and mprod_spriso = ? and mprod_sprregiso = ?) ON bildtafzbnb_produktid = mprod_produktid where btzeilenuz_btnr = ? and coalesce(?,btzeilenuz_bildposnr)=btzeilenuz_bildposnr and btzeilenuz_elementart = ? ";
        }

        @Override
        public final String ERMITTLE_OPTIONALE_PRODUKTBILDER_FZABH_ZU_BTE() {
            return "select  grafikipac_blob,btzeilenz_btnr, btzeilenz_bildposnr from w_btzeilenzub, w_bildtafzub_bnb_marketing,\tw_marketingprodukt_grafik, w_grafik_ipac where btzeilenz_btnr = to_char(bildtafzbnb_btnr) and btzeilenz_bildposnr = bildtafzbnb_bildpos and coalesce(?,btzeilenz_bildposnr)=btzeilenz_bildposnr and bildtafzbnb_produktid = mgraf_produktid and grafikipac_id = mgraf_grafikid and grafikipac_art = mgraf_art and btzeilenz_btnr = ?and btzeilenz_elementart = ? and mgraf_marktid = ?";
        }

        @Override
        public final String ERMITTLE_OPTIONALE_PRODUKTBILDER_FZUABH_ZU_BTE() {
            return "select  grafikipac_blob,btzeilenuz_btnr, btzeilenuz_bildposnr from w_btzeilenzubugb, w_bildtafzub_bnb_marketing,\tw_marketingprodukt_grafik, w_grafik_ipac where btzeilenuz_btnr = to_char(bildtafzbnb_btnr) and btzeilenuz_bildposnr = bildtafzbnb_bildpos and coalesce(?,btzeilenuz_bildposnr)=btzeilenuz_bildposnr and bildtafzbnb_produktid = mgraf_produktid and grafikipac_id = mgraf_grafikid and grafikipac_art = mgraf_art and btzeilenuz_btnr = ? and btzeilenuz_elementart = ? and mgraf_marktid = ?";
        }

        @Override
        public final String ERMITTLE_OPTIONALE_BAUREIHEN() {
            return "select distinct ben_text,  fztyp_baureihe,  btzeilenz_bildposnr from w_btzeilenzub, \tw_btzeilenzub_verbauung,  w_fztyp,  w_baureihe, w_ben_gk where btzeilenz_btnr = ? and btzeilenzv_btnr = btzeilenz_btnr and coalesce(?, btzeilenz_bildposnr) = btzeilenz_bildposnr and btzeilenz_pos = btzeilenzv_pos and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and fztyp_sichtschutz = 'N' and fztyp_ktlgausf in (&REGIONEN&) and btzeilenzv_mospid = fztyp_mospid and fztyp_baureihe = baureihe_baureihe and baureihe_textcode = ben_textcode and btzeilenz_elementart = ? and ben_iso = ? and ben_regiso = ? ";
        }

        @Override
        public final String ERMITTLE_VARIANTEN_ZU_BTE() {
            return "select  bildtafzv_btnr,variante_id,\t ben_text from w_ben_gk, w_markt_produkt_var, w_variante INNER JOIN w_bildtafzub_variante ON variante_id = bildtafzv_varianteid where bildtafzv_btnr = ? and ben_iso = ? and ben_regiso = ? and ben_textcode = variante_textcode and variante_id = marktprod_varianteid and marktprod_btnr = bildtafzv_btnr and marktprod_marktid =  ? and marktprod_systemid = 1 order by variante_id";
        }

        @Override
        public final String ERMITTLE_VARIANTE_BILDER() {
            return "select grafikipac_blob image,\t\t\t\tbildtafzvm_varianteid,\t\t\t\tbildtafzvm_btnr, \t\t\t\tmgraf_grafikid grafikid FROM w_bildtafzub_var_marketing INNER JOIN (SELECT * FROM w_marketingprodukt_grafik WHERE mgraf_marktid = ?) ON (bildtafzvm_produktid = mgraf_produktid AND bildtafzvm_marktid = mgraf_marktid)INNER JOIN w_grafik_ipac ON (mgraf_grafikid = grafikipac_id and mgraf_art = grafikipac_art ) where bildtafzvm_btnr = ? and bildtafzvm_varianteid = ? and bildtafzvm_marktid = ? and grafikipac_art = 'N' order by mgraf_pos";
        }

        @Override
        public final String ERMITTLE_VARIANTEN_ZU_BNB_GEBUNDEN() {
            return "select  distinct btzeilenz_btnr,variante_id,\t ben_text from w_ben_gk, w_markt_produkt_var, w_variante INNER JOIN w_btzeilenzub_variante ON variante_id = btzeilenzva_varianteid LEFT OUTER JOIN w_btzeilenzub ON btzeilenzva_btnr = btzeilenz_btnr AND btzeilenzva_pos = btzeilenz_pos where btzeilenz_btnr = ? and ben_iso = ? and ben_regiso = ? and btzeilenz_bildposnr = ? and ben_textcode = variante_textcode and variante_id = marktprod_varianteid and marktprod_btnr = btzeilenz_btnr and marktprod_marktid =  ? and marktprod_systemid = 1";
        }

        @Override
        public final String ERMITTLE_VARIANTEN_ZU_BNB_UNGEBUNDEN() {
            return "select  distinct btzeilenuz_btnr,variante_id,\t ben_text from w_ben_gk, w_markt_produkt_var, w_variante INNER JOIN w_btzeilenzubugb_variante ON variante_id = btzeilenzuva_varianteid LEFT OUTER JOIN w_btzeilenzubugb ON btzeilenzuva_btnr = btzeilenuz_btnr AND btzeilenzuva_pos = btzeilenuz_pos where btzeilenuz_btnr = ? and ben_iso = ? and ben_regiso = ? and btzeilenuz_bildposnr = ? and ben_textcode = variante_textcode and variante_id = marktprod_varianteid and marktprod_btnr = btzeilenuz_btnr and marktprod_marktid =  ? and marktprod_systemid = 1";
        }

        @Override
        public final String ERMITTLE_GRAFIKEN_ZU_BTE() {
            return "select bildtafzm_btnr, mgraf_art, grafikipac_blob from w_marketingprodukt_grafik, w_bildtafzub_marketing, w_grafik_ipac where grafikipac_id = mgraf_grafikid and grafikipac_art = mgraf_art and mgraf_produktid = bildtafzm_produktid and bildtafzm_btnr = ? and mgraf_marktid = ? order by mgraf_pos";
        }

        @Override
        public final String ERMITTLE_GRAFIKEN_ZU_BNB() {
            return "select bildtafzbnb_btnr, mgraf_art, grafikipac_blob from w_marketingprodukt_grafik, w_bildtafzub_bnb_marketing, w_grafik_ipac where grafikipac_id = mgraf_grafikid and grafikipac_art = mgraf_art and mgraf_produktid = bildtafzbnb_produktid and bildtafzbnb_btnr = ? and mgraf_marktid = ? and bildtafzbnb_bildpos = ? order by mgraf_pos";
        }

        @Override
        public final String ERMITTLE_MARKETINGINFOS_ZU_BNB() {
            return "select bildtafzbnb_btnr,mprod_text, mprod_art, mprod_text_laenge text_laenge from w_marketingprodukt_text m, w_bildtafzub_bnb_marketing where to_char(bildtafzbnb_btnr) = ? and bildtafzbnb_produktid = mprod_produktid and mprod_marktid = ? and mprod_spriso = ? and mprod_sprregiso = ? and bildtafzbnb_bildpos = ? ";
        }

        @Override
        public final String ERMITTLE_SPEZIFISCHE_MARKETINGINFOS_ZU_BNB() {
            return this.ERMITTLE_MARKETINGINFOS_ZU_BNB() + " and mprod_art=?";
        }

        @Override
        public final String RETRIEVE_BTEKOMMENTAR() {
            return "select distinct komm_id KommId, ben_text Text, komm_code Code, komm_vz VZ,  komm_darstellung Darstellung, komm_tiefe Tiefe,  komm_pos Pos from w_bildtafzub_komm, w_ben_gk, w_komm where bildtafzk_btnr = ? and bildtafzk_kommid = komm_id and komm_textcode = ben_textcode and bildtafzk_art = ? and bildtafzk_bildposnr = '00'  and bildtafzk_zeilenpos = -1 and ben_iso = ? and ben_regiso = ?union all select distinct komm_id KommId, ben_text Text, komm_code Code, komm_vz VZ,  komm_darstellung Darstellung, komm_tiefe Tiefe,  komm_pos Pos from w_bildtafzub_komm inner join w_btzeilenzub on bildtafzk_btnr = btzeilenz_btnr  AND bildtafzk_bildposnr = btzeilenz_bildposnr AND bildtafzk_zeilenpos = btzeilenz_pos , w_ben_gk, w_komm where bildtafzk_btnr = ? and bildtafzk_kommid = komm_id and komm_textcode = ben_textcode and btzeilenz_elementart in ('HP_PAKET', 'HP_OBLIGAT') and bildtafzk_art = ? and ben_iso = ? and ben_regiso = ?union all select distinct komm_id KommId, ben_text Text, komm_code Code, komm_vz VZ,  komm_darstellung Darstellung, komm_tiefe Tiefe,  komm_pos Pos from w_bildtafzub_komm left outer join w_btzeilenzubugb on bildtafzk_btnr = btzeilenuz_btnr  AND bildtafzk_bildposnr = btzeilenuz_bildposnr AND bildtafzk_zeilenpos = btzeilenuz_pos , w_ben_gk, w_komm where bildtafzk_btnr = ? and bildtafzk_kommid = komm_id and komm_textcode = ben_textcode and btzeilenuz_elementart in ('HP_PAKET', 'HP_OBLIGAT') and bildtafzk_art = ? and ben_iso = ? and ben_regiso = ? order by KommId, Pos";
        }

        @Override
        public final String RETRIEVE_BTEKOMMENTAR_BNB() {
            return "select distinct komm_id KommId, ben_text Text, komm_code Code, komm_vz VZ,  komm_darstellung Darstellung, komm_tiefe Tiefe,  komm_pos Pos from w_bildtafzub_komm, w_ben_gk, w_komm where bildtafzk_btnr = ? and bildtafzk_kommid = komm_id and komm_textcode = ben_textcode and bildtafzk_art = ? and bildtafzk_bildposnr = ?  and ben_iso = ? and ben_regiso = ?  and bildtafzk_zeilenpos = coalesce(?, bildtafzk_zeilenpos) order by KommId, Pos";
        }

        @Override
        public final String ERMITTLE_NOETIGE_FZ_ATTRIBUTE_FZGEB_BASE() {
            return "SELECT DISTINCT trim(btzeilenz_automatik) automatik,\ttrim(btzeilenz_lenkg) lenkung,\tbtzeilenz_eins datEins,\tbtzeilenz_auslf datAusl FROM w_btzeilenzub where btzeilenz_btnr = ? and btzeilenz_bildposnr = coalesce(?, btzeilenz_bildposnr)";
        }

        @Override
        public final String ERMITTLE_NOETIGE_FZ_ATTRIBUTE_FZUGB_BASE() {
            return "SELECT DISTINCT null automatik,\tnull lenkung,\tbtzeilenz_eins datEins,\tbtzeilenz_auslf datAusl FROM w_btzeilenzub where btzeilenz_btnr = ? and btzeilenz_bildposnr = coalesce(?, btzeilenz_bildposnr)";
        }

        @Override
        public final String ERMITTLE_SZCODE_ZU_BTE() {
            return "SELECT bedsala_art||bedsala_pnr||bedsala_hz szcode, bedsala_id salaid  FROM w_bildtafzub, w_bed_sala WHERE bildtafz_btnr= ? AND bildtafz_salaid= bedsala_id";
        }
    }

    public static final class ProduktSuche
    extends SQLStatements.ProduktSuche {
        @Override
        public final String LISTE_BTE_UNTERKATEGORIE() {
            return "SELECT distinct bildtaf_btnr,bildtaf_hg, bildtaf_fg, bildtaf_pos, bildtaf_bteart, coalesce(btzeilenz_bildposnr, btzeilenuz_bildposnr ),ben1.ben_text hkbez,ben2.ben_text ukbez, bildtaf_lkz FROM w_hk_uk_sa, w_unterkategorie uk, w_hauptkategorie hk, w_ben_gk ben1, w_ben_gk ben2, w_bildtafzub,  w_bildtaf_marke,  w_markt_produkt_br,  w_bildtaf LEFT OUTER JOIN w_btzeilenzub on (btzeilenz_btnr = bildtaf_btnr and btzeilenz_elementart = ?)  LEFT OUTER JOIN w_btzeilenzubugb on (btzeilenuz_btnr = bildtaf_btnr and btzeilenuz_elementart = ?) WHERE hkuksa_salaid = bildtafz_salaid and bildtafz_btnr = bildtaf_btnr and bildtafm_btnr = marktprod_btnr and marktprod_systemid = 1 and marktprod_marktid = ? and hkuksa_produktart = bildtaf_produktart and hkuksa_hkid = coalesce(?, hkuksa_hkid) and hkuksa_ukid = ? and bildtaf_btnr = bildtafm_btnr and hkuksa_marke_tps = bildtafm_marke_tps and hkuksa_marke_tps = ? and hkuksa_produktart = ? and uk.unterkat_id = hkuksa_ukid and hk.hauptkat_id = hkuksa_hkid and ben1.ben_textcode = hk.hauptkat_textcode and ben2.ben_textcode = uk.unterkat_textcode and ben1.ben_iso = ? and ben1.ben_regiso = ? and ben2.ben_iso = ? and ben2.ben_regiso = ? order by bildtaf_hg, bildtaf_fg, bildtaf_pos ";
        }

        @Override
        public final String LISTE_BTE_UNTERKATEGORIE_FAHRZEUG() {
            return "SELECT distinct bildtaf_btnr,  bildtaf_hg, bildtaf_fg,  bildtaf_pos, bildtaf_bteart, bildpos, ben1.ben_text, ben2.ben_text, bildtaf_lkz  FROM w_hk_uk_sa, w_unterkategorie uk, w_hauptkategorie hk, w_ben_gk ben1,  w_ben_gk ben2, w_bildtafzub, w_bildtaf, w_bildtaf_marke, w_markt_produkt_br,  (select distinct btzeilenz_btnr btnr, decode(btzeilenz_elementart, 'HP_OBLIGAT', null, btzeilenz_bildposnr) bildpos, btzeilenz_elementart elementart    from w_btzeilenzub, w_btzeilenzub_verbauung,  w_fztyp,  w_markt_produkt_br   where btzeilenz_elementart in ('HP_PAKET', 'HP_OBLIGAT')  and btzeilenz_btnr = btzeilenzv_btnr  and btzeilenz_btnr = marktprod_btnr  and marktprod_systemid = 1  and marktprod_marktid = ?  and marktprod_baureihe = ?  and btzeilenz_pos = btzeilenzv_pos  and btzeilenzv_mospid = fztyp_mospid  and fztyp_baureihe = coalesce(?, fztyp_baureihe)  and fztyp_karosserie = coalesce(?,fztyp_karosserie)  and fztyp_erwvbez = coalesce(?, fztyp_erwvbez)  and fztyp_ktlgausf = coalesce(?, fztyp_ktlgausf)  union all  select distinct btzeilenuz_btnr btnr,  decode(btzeilenuz_elementart, 'HP_OBLIGAT', null, btzeilenuz_bildposnr) bildpos,  btzeilenuz_elementart elementart  from w_btzeilenzubugb, w_markt_produkt_br  where btzeilenuz_elementart in ('HP_PAKET', 'HP_OBLIGAT')  and btzeilenuz_btnr = marktprod_btnr  and marktprod_marktid = ?  ) zeilen  where  hkuksa_salaid = bildtafz_salaid  and bildtafz_btnr = bildtaf_btnr  and zeilen.btnr = bildtaf_btnr  and hkuksa_produktart = bildtaf_produktart  and hkuksa_hkid = coalesce(?, hkuksa_hkid)  and hkuksa_ukid = ?  and bildtafm_btnr = bildtaf_btnr  and hkuksa_marke_tps = bildtafm_marke_tps  and hkuksa_marke_tps = ?  and hkuksa_produktart = ?  and hkuksa_ukid = uk.unterkat_id  and hkuksa_hkid = hk.hauptkat_id  and hk.hauptkat_textcode = ben1.ben_textcode  and uk.unterkat_textcode = ben2.ben_textcode  and ben1.ben_iso = ?  and ben1.ben_regiso = ?  and ben2.ben_iso = ?  and ben2.ben_regiso = ?  order by bildtaf_hg, bildtaf_fg, bildtaf_pos  ";
        }

        @Override
        public final String ERMITTLE_MARKETINGINFOS_ZU_PRODUKTLISTE() {
            return "select bildtafzm_btnr,m.mprod_text, m.mprod_art,1 prio, mprod_text_laenge text_laenge from w_marketingprodukt_text m, w_bildtafzub_marketing where bildtafzm_btnr in (&PRODUKTLISTE&) and bildtafzm_produktid = mprod_produktid and mprod_marktid = ? and mprod_spriso = ? and mprod_sprregiso = ? order by bildtafzm_btnr";
        }

        @Override
        public final String ERMITTLE_MARKETINGINFOS_ZU_PRODUKTLISTE_PET() {
            return "select  bildtafzbnb_btnr,bildtafzbnb_bildpos,m.mprod_text, m.mprod_art, 1 prio, mprod_text_laenge text_laenge from w_marketingprodukt_text m, w_bildtafzub_bnb_marketing where bildtafzbnb_produktid = mprod_produktid and mprod_marktid = ? and mprod_spriso = ? and mprod_sprregiso = ? and (&CONDITIONS&)order by bildtafzbnb_btnr, bildtafzbnb_bildpos";
        }

        @Override
        public final String ERMITTLE_GRAFIKEN_ZU_PRODUKTLISTE() {
            return "SELECT bildtafzm_btnr btenr, grafikipac_blob image FROM w_marketingprodukt_grafik, w_bildtafzub_marketing, w_grafik_ipac WHERE grafikipac_id = mgraf_grafikid AND grafikipac_art = mgraf_art AND mgraf_produktid = bildtafzm_produktid AND bildtafzm_btnr in (&PRODUKTLISTE&) AND mgraf_marktid = ? AND mgraf_art = ? ORDER BY mgraf_pos";
        }

        @Override
        public final String ERMITTLE_GRAFIKEN_ZU_PRODUKTLISTE_PET() {
            return "SELECT bildtafzbnb_btnr btenr, bildtafzbnb_bildpos pos, grafikipac_blob image FROM w_marketingprodukt_grafik, w_bildtafzub_bnb_marketing, w_grafik_ipac WHERE grafikipac_id = mgraf_grafikid AND grafikipac_art = mgraf_art AND mgraf_produktid = bildtafzbnb_produktid AND mgraf_marktid = ? AND mgraf_art = ? AND (&CONDITIONS&) ORDER BY mgraf_pos";
        }

        @Override
        public final String ERMITTLE_BAUARTEN_ZUR_PRODUKTLISTE() {
            return "select distinct bildtafzb_btnr, bauart_bauart, ben_text, bauart_position from w_bauart, w_baureihe, w_ben_gk, w_bildtafzub_baureihe, w_fztyp, w_markt_produkt_br  where baureihe_baureihe = bildtafzb_baureihe  and bauart_bauart = baureihe_bauart  and ben_textcode = bauart_textcode  and bildtafzb_btnr in (&PRODUKTLISTE&) and bildtafzb_btnr = marktprod_btnr and marktprod_marktid = ? and marktprod_systemid = 1 and fztyp_baureihe = marktprod_baureihe and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and baureihe_marke_tps = ? and baureihe_produktart = ? and fztyp_baureihe = baureihe_baureihe and fztyp_ktlgausf in (&REGIONEN&) and bildtafzb_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and bildtafzb_ktlgausf in (&REGIONEN&) and ben_iso = ? and ben_regiso = ? order by bauart_position";
        }

        @Override
        public final String ERMITTLE_BAUARTEN_ZUR_PRODUKTLISTE_PET() {
            return "select distinct btzeilenzv_btnr, btzeilenz_bildposnr,bauart_bauart,ben_text,bauart_position from w_bauart, w_baureihe,w_ben_gk,w_btzeilenzub,w_btzeilenzub_verbauung,w_fztyp, w_markt_produkt_br where btzeilenz_pos = btzeilenzv_pos and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_btnr = marktprod_btnr and marktprod_marktid = ? and marktprod_systemid = 1 and fztyp_baureihe = marktprod_baureihe and btzeilenzv_mospid = fztyp_mospid and ben_textcode = baureihe_textcode and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and baureihe_marke_tps = ? and baureihe_produktart = ? and fztyp_baureihe = baureihe_baureihe and bauart_bauart = baureihe_bauart  and fztyp_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and ben_iso = ? and ben_regiso = ? and (&CONDITIONS&) order by bauart_position";
        }

        @Override
        public final String ERMITTLE_BAUREIHEN_ZUR_PRODUKTLISTE() {
            return "select distinct bildtafzb_btnr, baureihe_baureihe,ben_text,baureihe_position from w_baureihe,w_ben_gk,w_bildtafzub_baureihe,w_fztyp, w_markt_produkt_br where baureihe_baureihe = bildtafzb_baureihe and ben_textcode = baureihe_textcode and bildtafzb_btnr in (&PRODUKTLISTE&) and bildtafzb_btnr = marktprod_btnr and marktprod_marktid = ? and marktprod_systemid = 1 and fztyp_baureihe = marktprod_baureihe and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and baureihe_marke_tps = ? and baureihe_produktart = ? and fztyp_baureihe = baureihe_baureihe and fztyp_ktlgausf in (&REGIONEN&) and bildtafzb_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and bildtafzb_ktlgausf in (&REGIONEN&) and ben_iso = ? and ben_regiso = ? order by baureihe_position";
        }

        @Override
        public final String ERMITTLE_BAUARTENBAUM_FUER_PRODUKT() {
            return "select distinct bauart_position, baureihe_bauart, ben3.ben_text, baureihe_position,baureihe_baureihe,ben1.ben_text,fztyp_karosserie,ben2.ben_text, fztyp_erwvbez,fztyp_ktlgausf from w_baureihe,w_bauart,w_ben_gk ben1,w_ben_gk ben2,w_ben_gk ben3,w_fztyp,w_publben,w_btzeilenzub_verbauung,w_btzeilenzub where btzeilenzv_mospid = fztyp_mospid and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_pos = btzeilenzv_pos and btzeilenzv_btnr = ? and fztyp_baureihe = baureihe_baureihe and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and fztyp_sichtschutz = 'N' and fztyp_ktlgausf in (&REGIONEN&) and bauart_bauart = baureihe_bauart and ben1.ben_textcode = baureihe_textcode and baureihe_marke_tps = ? and baureihe_produktart = ? and ben1.ben_iso = ? and ben1.ben_regiso = ? and ben2.ben_iso = ? and ben2.ben_regiso = ? and ben3.ben_textcode = bauart_textcode and ben3.ben_iso = ? and ben3.ben_regiso = ? and ben2.ben_textcode = publben_textcode and publben_bezeichnung = fztyp_karosserie and publben_art = 'K' and coalesce(?, btzeilenz_bildposnr) = btzeilenz_bildposnr order by baureihe_position, baureihe_baureihe, fztyp_karosserie, fztyp_erwvbez, fztyp_ktlgausf";
        }

        @Override
        public final String ERMITTLE_BAUREIHENBAUM_FUER_PRODUKT_WITH_BAUART() {
            return "select distinct baureihe_position,baureihe_baureihe,ben1.ben_text,fztyp_karosserie,ben2.ben_text, fztyp_erwvbez,fztyp_ktlgausf from w_baureihe,w_bauart,w_ben_gk ben1,w_ben_gk ben2,w_fztyp,w_publben,w_btzeilenzub_verbauung,w_btzeilenzub where btzeilenzv_mospid = fztyp_mospid and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_pos = btzeilenzv_pos and btzeilenzv_btnr = ? and fztyp_baureihe = baureihe_baureihe and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and fztyp_sichtschutz = 'N' and fztyp_ktlgausf in (&REGIONEN&) and ben1.ben_textcode = baureihe_textcode and baureihe_marke_tps = ? and baureihe_produktart = ? and ben1.ben_iso = ? and ben1.ben_regiso = ? and ben2.ben_iso = ? and ben2.ben_regiso = ? and ben2.ben_textcode = publben_textcode and publben_bezeichnung = fztyp_karosserie and publben_art = 'K' and coalesce(?, btzeilenz_bildposnr) = btzeilenz_bildposnr and bauart_bauart = baureihe_bauart and bauart_bauart = ? order by baureihe_position, baureihe_baureihe, fztyp_karosserie, fztyp_erwvbez, fztyp_ktlgausf";
        }

        @Override
        public final String ERMITTLE_BAUREIHEN_ZUR_PRODUKTLISTE_PET() {
            return "select distinct btzeilenzv_btnr, btzeilenz_bildposnr,baureihe_baureihe,ben_text,baureihe_position from w_baureihe,w_ben_gk,w_btzeilenzub,w_btzeilenzub_verbauung,w_fztyp, w_markt_produkt_br where btzeilenz_pos = btzeilenzv_pos and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_btnr = marktprod_btnr and marktprod_marktid = ? and marktprod_systemid = 1 and fztyp_baureihe = marktprod_baureihe and btzeilenzv_mospid = fztyp_mospid and ben_textcode = baureihe_textcode and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and baureihe_marke_tps = ? and baureihe_produktart = ? and fztyp_baureihe = baureihe_baureihe and fztyp_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and ben_iso = ? and ben_regiso = ? and (&CONDITIONS&) order by baureihe_position";
        }

        @Override
        public final String ERMITTLE_BAUREIHENBAUM_FUER_PRODUKT() {
            return "select distinct baureihe_position,baureihe_baureihe,ben1.ben_text,fztyp_karosserie,ben2.ben_text, fztyp_erwvbez,fztyp_ktlgausf from w_baureihe,w_ben_gk ben1,w_ben_gk ben2,w_fztyp,w_publben,w_btzeilenzub_verbauung,w_btzeilenzub, w_markt_produkt_br where btzeilenzv_mospid = fztyp_mospid and btzeilenz_btnr = btzeilenzv_btnr and btzeilenz_pos = btzeilenzv_pos and btzeilenzv_btnr = ? and btzeilenzv_btnr = marktprod_btnr and marktprod_marktid = ? and marktprod_systemid = 1 and fztyp_baureihe = marktprod_baureihe and fztyp_baureihe = baureihe_baureihe and baureihe_vbereich in ('BE', ?) and fztyp_vbereich = ? and fztyp_sichtschutz = 'N' and fztyp_ktlgausf in (&REGIONEN&) and ben1.ben_textcode = baureihe_textcode and baureihe_marke_tps = ? and baureihe_produktart = ? and ben1.ben_iso = ? and ben1.ben_regiso = ? and ben2.ben_iso = ? and ben2.ben_regiso = ? and ben2.ben_textcode = publben_textcode and publben_bezeichnung = fztyp_karosserie and publben_art = 'K' and coalesce(?, btzeilenz_bildposnr) = btzeilenz_bildposnr order by baureihe_position, baureihe_baureihe, fztyp_karosserie, fztyp_erwvbez, fztyp_ktlgausf";
        }

        @Override
        public final String ERMITTLE_BTE_BEDINGUNGEN() {
            return "select bildtafz_btnr, bildtafzbo_vart, bildtafzbe_vz, bedsala_art, bedsala_pnr, bedsala_hz, ben_text  from w_bildtafzub, w_bildtafzub_bedgesamt, w_bildtafzub_bedog, w_bildtafzub_bedelem, w_bed, w_ben_gk, w_bed_sala  where bildtafz_btnr in (&PRODUKTLISTE&) \tand bildtafz_bedkez IS NOT NULL \tand bildtafz_btnr =  bildtafzbg_btnr and bildtafz_bedkez = bildtafzbg_kez \tand bildtafz_btnr = bildtafzbo_btnr and bildtafz_bedkez = bildtafzbo_kez\tand bildtafz_btnr = bildtafzbe_btnr and bildtafz_bedkez = bildtafzbe_kez\tand bed_elemid = bildtafzbe_elemid\tand bedsala_id = bed_elemid\tand ben_textcode = bed_textcode\tand ben_iso = ?\tand ben_regiso =  ?";
        }

        @Override
        public final String ERMITTLE_BTE_BEDINGUNG() {
            return "select bildtafz_btnr, bildtafzbo_vart, bildtafzbe_vz, bedsala_art, bedsala_pnr, bedsala_hz, ben_text, bildtafzbg_gesamtterm ,  bildtafzbo_ogid  from w_bildtafzub, w_bildtafzub_bedgesamt, w_bildtafzub_bedog, w_bildtafzub_bedelem, w_bed, w_ben_gk, w_bed_sala  where bildtafz_btnr = ? \tand bildtafz_bedkez IS NOT NULL \tand bildtafz_btnr =  bildtafzbg_btnr and bildtafz_bedkez = bildtafzbg_kez \tand bildtafz_btnr = bildtafzbo_btnr and bildtafz_bedkez = bildtafzbo_kez\tand bildtafz_btnr = bildtafzbe_btnr and bildtafz_bedkez = bildtafzbe_kez\tand bed_elemid = bildtafzbe_elemid\tand bedsala_id = bed_elemid\tand ben_textcode = bed_textcode\tand ben_iso = ?\tand ben_regiso =  ?";
        }

        @Override
        public final String SUCHE_PRODUCT() {
            return "select distinct bildtaf_btnr,\n\t\t\t\tbildtaf_bteart,\n\t\t\t\tbtzeilenz_bildposnr,\n\t\t\t\thkuksa_hkid hauptkat_id,\n\t\t\t\tben2.ben_text hauptkategorie_text,\n\t\t\t\thauptkat_pos,\n\t\t\t\thkuksa_ukid unterkat_id,\n\t\t\t\tben3.ben_text unterkategorie_text,\n\t\t\t\tunterkat_pos, \n\t\t\t  bildtaf_lkz from (select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben1,\n\t \t  (select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben2,\n\t \t  (select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben3,\n  \t  w_hk_uk_sa hus,\n\t \t\tw_hauptkategorie hk,\n\t\t\tw_unterkategorie uk,\n\t \t\tw_bildtafzub btz,\n\t\t\tw_bildtaf_marke,\n\t\t\tw_markt_produkt_br, \t\t\tw_bildtaf bt\nLEFT OUTER JOIN (select btzeilenz_btnr, btzeilenz_pos, btzeilenz_bildposnr from w_btzeilenzub where btzeilenz_elementart = ? \tUNION select btzeilenuz_btnr btzeilenz_btnr, btzeilenuz_pos btzeilenz_pos, btzeilenuz_bildposnr btzeilenz_bildposnr from w_btzeilenzubugb where btzeilenuz_elementart = ? ) ON btzeilenz_btnr = bildtaf_btnr where (ben1.ben_textcode, bildtaf_btnr) in (select hauptkat_textcode textcode, \n\t\t\t\t\tbildtafz_btnr btnr\nfrom w_hauptkategorie\n\t inner join w_hk_uk_sa on hauptkat_id = hkuksa_hkid\n\t inner join w_bildtafzub on hkuksa_salaid = bildtafz_salaid\nunion all\nselect unterkat_textcode textcode, \n\t\t\t\tbildtafz_btnr btnr\nfrom w_unterkategorie\n\t inner join w_hk_uk_sa on unterkat_id = hkuksa_ukid\n\t inner join w_bildtafzub on hkuksa_salaid = bildtafz_salaid\nunion all\nselect bed_textcode textcode, \n\t\t\t\tbildtafz_btnr\nfrom w_bildtafzub,\n     w_bed\nwhere bed_elemid = bildtafz_salaid\nunion all\nselect bildtafzb_textcode textcode,\n\t\t\t bildtafzb_btnr btnr\nfrom w_bildtafzub_bnb\nunion all\nselect teil_textcode textcode, \n\t\t\t\tbtzeilenz_btnr btnr\nfrom w_btzeilenzub,\n\t\t w_teil\nwhere teil_sachnr = btzeilenz_sachnr)\n&SUCHSTRING&\nand hkuksa_marke_tps = ?\nand hkuksa_produktart = ?\nand btz.bildtafz_btnr = bt.bildtaf_btnr\nand bildtaf_produktart = hus.hkuksa_produktart\nand bildtaf_btnr = bildtafm_btnr and bildtafm_btnr = marktprod_btnr  and marktprod_marktid = ?  and marktprod_systemid = 1 and bildtafm_marke_tps = hus.hkuksa_marke_tps\nand hus.hkuksa_salaid = btz.bildtafz_salaid\nand hus.hkuksa_hkid = hk.hauptkat_id\nand hus.hkuksa_ukid = uk.unterkat_id\nand hk.hauptkat_textcode = ben2.ben_textcode\nand uk.unterkat_textcode = ben3.ben_textcode\norder by hauptkat_pos, unterkat_pos, bildtaf_btnr";
        }

        @Override
        public final String SUCHE_SZ_SAZ() {
            return "SELECT DISTINCT bildtaf_btnr, \t\t\tbildtaf_bteart,\n\t\t\tbtzeilenz_bildposnr,\n\t\t\thkuksa_hkid hauptkat_id, ben2.ben_text hauptkategorie_text, hauptkat_pos,\n\t\t\thkuksa_ukid unterkat_id, ben3.ben_text unterkategorie_text, unterkat_pos, \n\t\t\tbildtaf_lkz FROM (SELECT * FROM w_ben_gk WHERE ben_iso = ? AND ben_regiso = ?) ben2,\n\t\t\t(SELECT * FROM w_ben_gk WHERE ben_iso = ? AND ben_regiso = ?) ben3,\n\t\t\tw_bed_sala,\n\t\t\tw_hk_uk_sa hus,\n\t\t\tw_hauptkategorie hk,\n\t\t\tw_unterkategorie uk,\n\t\t\tw_bildtafzub btz,\n\t\t\tw_bildtaf_marke,\n\t\t\tw_markt_produkt_br, \t\t\tw_bildtaf bt\nLEFT OUTER JOIN (SELECT btzeilenz_btnr, btzeilenz_pos, btzeilenz_bildposnr FROM w_btzeilenzub WHERE btzeilenz_elementart = ? UNION SELECT btzeilenuz_btnr btzeilenz_btnr, btzeilenuz_pos btzeilenz_pos, btzeilenuz_bildposnr btzeilenz_bildposnr FROM w_btzeilenzubugb WHERE btzeilenuz_elementart = ? )ON btzeilenz_btnr = bildtaf_btnr\nWHERE (bildtaf_btnr) IN (select bildtafz_btnr btnr\nFROM w_hauptkategorie\nINNER JOIN w_hk_uk_sa on hauptkat_id = hkuksa_hkid\nINNER JOIN w_bildtafzub ON hkuksa_salaid = bildtafz_salaid \nUNION ALL\nSELECT bildtafz_btnr btnr\nFROM w_unterkategorie\nINNER JOIN w_hk_uk_sa on unterkat_id = hkuksa_ukid\nINNER JOIN w_bildtafzub ON hkuksa_salaid = bildtafz_salaid)\n&SUCHSTRING&\nAND hkuksa_marke_tps = ?\nAND hkuksa_produktart = ?\nAND bildtafz_btnr = bildtaf_btnr\nand bildtafz_btnr = marktprod_btnr and marktprod_marktid = ?  and marktprod_systemid = 1 AND hkuksa_salaid = bedsala_id\nAND bildtafz_salaid = hkuksa_salaid\nAND bildtafz_btnr = bt.bildtaf_btnr\nAND bildtafm_btnr = bt.bildtaf_btnr\nAND bildtaf_produktart = hus.hkuksa_produktart\nAND bildtafm_marke_tps = hus.hkuksa_marke_tps \nAND hus.hkuksa_hkid = hk.hauptkat_id\nAND hus.hkuksa_ukid = uk.unterkat_id\nAND hk.hauptkat_textcode = ben2.ben_textcode\nAND uk.unterkat_textcode = ben3.ben_textcode\nORDER BY hauptkat_pos, unterkat_pos, bildtaf_btnr";
        }

        @Override
        public final String SUCHE_KEYWORDS() {
            return "select distinct bildtaf_btnr, \n\t\t\t\tbildtaf_bteart,\n\t\t\t\tbtzeilenz_bildposnr,\n\t\t\t\thkuksa_hkid hauptkat_id,\n\t\t\t\tben2.ben_text hauptkategorie_text,\n\t\t\t\thauptkat_pos,\n\t\t\t\thkuksa_ukid unterkat_id,\n\t\t\t\tben3.ben_text unterkategorie_text,\n\t\t\t\tunterkat_pos, \n\t\t\t  bildtaf_lkz from (select * from w_marketingprodukt_keyword where mkeyw_spriso = ? and mkeyw_sprregiso = ?) w_marketingprodukt_keyword,\n\t    (select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben2,\n\t   \t(select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben3,\n\t \t\tw_hk_uk_sa hus,\n\t \t\tw_hauptkategorie hk,\n\t\t \tw_unterkategorie uk,\n\t \t\tw_bildtafzub btz,\n\t \t\tw_bildtaf_marke,\n\t\t\tw_markt_produkt_br, \t\t\tw_bildtaf bt\n\t\t\tleft outer join (select btzeilenz_btnr, btzeilenz_pos, btzeilenz_bildposnr from w_btzeilenzub where btzeilenz_elementart = ?                             UNION select btzeilenuz_btnr btzeilenz_btnr, btzeilenuz_pos btzeilenz_pos, btzeilenuz_bildposnr btzeilenz_bildposnr from w_btzeilenzubugb where btzeilenuz_elementart = ?)  ON btzeilenz_btnr = bildtaf_btnr where (bildtaf_btnr, mkeyw_produktid ) in (select bildtafzm_btnr btnr, \n\t\t\t\t\t\t\t bildtafzm_produktid produktid\n\t\t\t\tfrom w_bildtafzub_marketing\n\t\t\t\tunion all\n\t\t\t\tselect bildtafzbnb_btnr btnr, \n\t\t\t\t\t\t\t bildtafzbnb_produktid produktid\n\t\t\t\tfrom w_bildtafzub_bnb_marketing\n\t\t\t\tunion all\n\t\t\t\tselect bildtafzvm_btnr btnr, \n\t\t\t\t\t\t\t bildtafzvm_produktid produktid \n\t\t\t\tfrom w_bildtafzub_var_marketing\t\t\t\t)&SUCHSTRING&\nand hkuksa_marke_tps = ?\nand hkuksa_produktart = ?\nand hus.hkuksa_salaid = btz.bildtafz_salaid\nand hus.hkuksa_hkid = hk.hauptkat_id\nand hus.hkuksa_ukid = uk.unterkat_id\nand btz.bildtafz_btnr = bt.bildtaf_btnr\nand bt.bildtaf_btnr = bildtafm_btnr\n and bildtafm_btnr = marktprod_btnr  and marktprod_marktid = ?  and marktprod_systemid = 1 and bildtafm_marke_tps = hkuksa_marke_tps\nand bt.bildtaf_produktart = hkuksa_produktart\nand hk.hauptkat_textcode = ben2.ben_textcode\nand uk.unterkat_textcode = ben3.ben_textcode\norder by hauptkat_pos, unterkat_pos, bildtaf_btnr";
        }

        @Override
        public final String SUCHE_TEASERTEXT() {
            return "select distinct bildtaf_btnr, \n\t\t\t\tbildtaf_bteart,\n\t\t\t\tbtzeilenz_bildposnr,\n\t\t\t\thkuksa_hkid hauptkat_id,\n\t\t\t\tben2.ben_text hauptkategorie_text,\n\t\t\t\thauptkat_pos,\n\t\t\t\thkuksa_ukid unterkat_id,\n\t\t\t\tben3.ben_text unterkategorie_text,\n\t\t\t\tunterkat_pos, \n\t\t\t  bildtaf_lkz from (select * from w_marketingprodukt_text where mprod_spriso = ? and mprod_sprregiso = ?) w_marketingprodukt_text,\n\t\t \t(select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben2,\n\t \t\t(select * from w_ben_gk where ben_iso = ? and ben_regiso = ?) ben3,\n\t \t\tw_hk_uk_sa hus,\n \t\tw_hauptkategorie hk,\n\t \t\tw_unterkategorie uk,\n\t \t\tw_bildtafzub btz,\n\t \t\tw_bildtaf_marke,\n\t\t\tw_markt_produkt_br, \t\t\tw_bildtaf bt\n\t\t\tleft outer join (select btzeilenz_btnr, btzeilenz_pos, btzeilenz_bildposnr from w_btzeilenzub where btzeilenz_elementart = ?                             UNION select btzeilenuz_btnr btzeilenz_btnr, btzeilenuz_pos btzeilenz_pos, btzeilenuz_bildposnr btzeilenz_bildposnr from w_btzeilenzubugb where btzeilenuz_elementart = ?)  ON btzeilenz_btnr = bildtaf_btnr where (bildtaf_btnr, mprod_produktid) in (select bildtafzm_btnr btnr, \n\t\t\t\t\tbildtafzm_produktid produktid\n\t from w_bildtafzub_marketing\n\t union all\n\t select bildtafzbnb_btnr btnr, \n\t\t\t\tbildtafzbnb_produktid produktid\n  from w_bildtafzub_bnb_marketing\n  union all\n  select bildtafzvm_btnr btnr, \n\t\t\t\t\tbildtafzvm_produktid produktid\n  from w_bildtafzub_var_marketing)\n&SUCHSTRING&\nand hkuksa_marke_tps = ?\nand hkuksa_produktart = ?\nand hus.hkuksa_salaid = btz.bildtafz_salaid\nand hus.hkuksa_hkid = hk.hauptkat_id\nand hus.hkuksa_ukid = uk.unterkat_id\nand btz.bildtafz_btnr = bt.bildtaf_btnr\nand bildtafm_btnr = bt.bildtaf_btnr\n and bildtafm_btnr = marktprod_btnr  and marktprod_marktid = ?  and marktprod_systemid = 1 and bildtafm_marke_tps = hkuksa_marke_tps\nand bt.bildtaf_produktart = hkuksa_produktart\nand hk.hauptkat_textcode = ben2.ben_textcode\nand uk.unterkat_textcode = ben3.ben_textcode\nand mprod_art = ?\norder by hauptkat_pos, unterkat_pos, bildtaf_btnr";
        }

        @Override
        public final String LISTE_ALLE_KATALOGAUSF() {
            return "select distinct fztyp_ktlgausf from w_fztyp";
        }

        @Override
        public final String ERMITTLE_PRODUKTNAME() {
            return "SELECT distinct ben1.ben_text, 1 prio, bildtafz_zusatz_kommid \nFROM w_bed,\n\t w_ben_gk ben1,\n  w_bildtafzub,  w_bildtaf \nWHERE ben1.ben_iso = ?\nand ben1.ben_regiso = ?\nand ben1.ben_textcode = bed_textcode\nand bildtafz_btnr = ?\nand bildtafz_salaid = bed_elemid\nand bildtaf_btnr = bildtafz_btnr";
        }

        @Override
        public final String ERMITTLE_SZ_ZUSAETZE() {
            return "select komm_pos POS, ben_text SZ_KOMM  FROM w_komm, w_ben_gk ben1 where komm_id = ? and ben1.ben_iso = ? and ben1.ben_regiso = ? and ben1.ben_textcode = komm_textcode order by komm_pos";
        }

        @Override
        public final String ERMITTLE_PRODUKTNAME_BNB() {
            return "SELECT ben_text, 1 prio\nFROM w_ben_gk,   w_bildtafzub_bnb \nWHERE bildtafzb_btnr = ?\nAND bildtafzb_bildposnr = ?\nAND bildtafzb_textcode = ben_textcode \nAND ben_iso = ?\nAND ben_regiso = ?\n UNION ALL SELECT ben_text, 2 prio\nFROM w_ben_gk, \t\t\tw_btzeilenzub,\t\t\tw_teil WHERE btzeilenz_btnr = ?\nAND btzeilenz_bildposnr = ?\nAND btzeilenz_sachnr = teil_sachnr\nAND teil_textcode = ben_textcode \nAND ben_iso = ?\nAND ben_regiso = ?";
        }

        @Override
        public final String ERMITTLE_PRODUKTNAME_BNB_OPT() {
            return "SELECT DISTINCT ben_text, 3 prio\nFROM w_ben_gk,\n\t (w_btzeilenzub LEFT OUTER JOIN w_bildtafzub_bnb ON btzeilenz_btnr = bildtafzb_btnr AND btzeilenz_bildposnr = bildtafzb_bildposnr\n\t                LEFT OUTER JOIN w_teil ON btzeilenz_sachnr = teil_sachnr) zeilen\nWHERE btzeilenz_btnr = ?\nAND ben_iso = ?\nAND ben_regiso = ?\nAND btzeilenz_elementart IN ('OPTIONAL')\nAND btzeilenz_bildposnr= ?\nAND teil_sachnr in (select min(teil_sachnr)\n\t\t\t\t\t\t\t\t\t  from w_teil, w_ben_gk, w_btzeilenzub\n\t\t\t\t\t\t\t\t\t  where teil_textcode = ben_textcode\n\t\t\t\t\t\t\t\t\t  and btzeilenz_btnr = zeilen.btzeilenz_btnr\n\t\t\t\t\t\t\t\t\t  and btzeilenz_bildposnr = zeilen.btzeilenz_bildposnr\n\t\t\t\t\t  \t\t\t\tand btzeilenz_sachnr = teil_sachnr)\nand ben_textcode = coalesce(bildtafzb_textcode,teil_textcode)";
        }

        @Override
        public final String ERMITTLE_PRODUKTBILDER_GESAMT_FALLBACK() {
            return "select grafikipac_blob,\n\t      grafik_id,\n   \t\tprio \nfrom w_grafik_ipac,\n\t( select mgraf_grafikid grafik_id, \n          mgraf_art art, \n\t\t\t\t\t 1 prio\n   from w_marketingprodukt_grafik,\n\t\t  \t w_bildtafzub_marketing\n  \twhere bildtafzm_produktid = mgraf_produktid\n\t \tand bildtafzm_btnr = ?\n\t \tand mgraf_marktid = ?\n\t \tand mgraf_art = ?\n   and ? IN ('SHOWROOM','PIAS')\t) grafikids\nwhere grafikids.grafik_id = grafikipac_id\nand grafikids.art = grafikipac_art\norder by prio";
        }

        @Override
        public final String ERMITTLE_PRODUKTBILDER_PET_FALLBACK() {
            return "select grafikipac_blob,\n\t      grafik_id,\n   \t\tprio \nfrom w_grafik_ipac,\n\t( select mgraf_grafikid grafik_id, \n          mgraf_art art, \n\t\t\t\t\t 1 prio,\t\t\t\t\t mgraf_pos pos\n   from w_marketingprodukt_grafik,\n\t\t  \t w_bildtafzub_bnb_marketing\n  \twhere bildtafzbnb_produktid = mgraf_produktid\n\t \tand bildtafzbnb_btnr = ?\n\t\tand bildtafzbnb_bildpos = ?\t \tand mgraf_marktid = ?\n\t \tand mgraf_art = ?\n   and ? IN ('SHOWROOM','PIAS')\t) grafikids\nwhere grafikids.grafik_id = grafikipac_id\nand grafikids.art = grafikipac_art\norder by prio, pos";
        }

        @Override
        public final String HOLE_NO_IMAGE_ICON() {
            return "SELECT grafikipac_blob image FROM w_grafik_ipac WHERE grafikipac_id = -1 AND grafikipac_art = ? ";
        }

        @Override
        public final String ERMITTLE_HK_UK_ZU_PRODUKT() {
            return "nur Transbase";
        }

        @Override
        public final String SUCHE_PRODUKTNAME_ETK() {
            return "select distinct bildtaf_btnr btnr,\t\tbildtaf_hg hg,\t\tbildtaf_fg fg,\t\tben_text benennung,\t\tbildtaf_pos pos from w_bildtaf,  w_bildtaf_marke,  w_ben_gk where ben_textcode = bildtaf_textc and bildtaf_btnr = bildtafm_btnr and ben_iso = ? and ben_regiso = ? and bildtafm_marke_tps = ? and bildtaf_produktart = ? and upper(ben_text) like upper('&SUCHBEGRIFF&') &ADD&order by hg, fg, pos";
        }

        @Override
        public final String SUCHE_PRODUKTNAME_ETK_TR() {
            return "select distinct bildtaf_btnr btnr,\t\tbildtaf_hg hg,\t\tbildtaf_fg fg,\t\tben_text benennung,\t\tbildtaf_pos pos from w_bildtaf,  w_bildtaf_marke,  w_ben_gk where ben_textcode = bildtaf_textc and bildtaf_btnr = bildtafm_btnr and ben_iso = ? and ben_regiso = ? and bildtafm_marke_tps = ? and bildtaf_produktart = ? and upper(replace(ben_text,'i',chr(50352))) LIKE '&SUCHBEGRIFF&' &ADD&order by hg, fg, pos";
        }
    }

    public static final class KundenIdentifikation
    extends SQLStatements.KundenIdentifikation {
        @Override
        public final String ERMITTLE_KUNDE_UEBER_NUMMER() {
            return "SELECT kunde_id id, kunde_kundennummer nummer, kunde_anrede anrede, kunde_name name, kunde_vorname vorname, kunde_strasse strasse, kunde_hausnummer hausnummer, kunde_land land, kunde_plz plz, kunde_stadt stadt, kunde_postfachnummer postfach, kunde_telefon tel, kunde_mobiltelefon mobil, kunde_faxnummer fax, kunde_email email, kunde_bemerkung bemerkung, kunde_geburtsdatum gebdatum FROM w_zub_kunde WHERE TRIM(TO_CHAR(kunde_kundennummer)) LIKE ? ORDER BY kunde_kundennummer ";
        }

        @Override
        public final String ERMITTLE_KUNDEN_UEBER_NAME() {
            return "SELECT kunde_id id, kunde_kundennummer nummer , kunde_anrede anrede, kunde_name name, kunde_vorname vorname, kunde_strasse strasse, kunde_hausnummer hausnummer, kunde_land land, kunde_plz plz, kunde_stadt stadt, kunde_postfachnummer postfach, kunde_telefon tel, kunde_mobiltelefon mobil, kunde_faxnummer fax, kunde_email email, kunde_bemerkung bemerkung, kunde_geburtsdatum gebdatum FROM w_zub_kunde WHERE upper(trim(kunde_name ||','||nvl(kunde_vorname,''))) LIKE ? ORDER BY kunde_name, kunde_vorname";
        }

        @Override
        public final String ERMITTLE_KUNDENFAHRZEUGE() {
            return "SELECT kundefzg_vin vin, kundefzg_kennzeichen kennzeichen FROM w_zub_kunde_fahrzeug WHERE kundefzg_id = ?";
        }
    }

    public static final class FahrzeugIdentifikation
    extends SQLStatements.FahrzeugIdentifikation {
        @Override
        public final String ERMITTLE_FAHRZEUGDATEN_AUS_VIN() {
            return "SELECT DISTINCT baureihe_marke_tps marke, baureihe_produktart produktart, baureihe_bauart bauart, ben_bauart.ben_text bauartBez, fztyp_mospid mospid, fztyp_typschl typschl, fztyp_vbereich vbereich, fztyp_lenkung lenkung, fztyp_getriebe getriebe, fztyp_baureihe baureihe, ben_baureihe.ben_text baureiheBez, fztyp_ktlgausf katalogausf, fztyp_vbez vbezeichnung, fztyp_erwvbez vbezeichnungerw, fztyp_motor motor, fztyp_karosserie karosserie, ben_karosserie.ben_text karosserieBez, fztyp_katalysator katalysator, fztyp_sichtschutz sichtschutz, fgstnr_prod produktionsdatum FROM w_fztyp, w_bauart, w_fgstnr, w_baureihe, w_ben_gk ben_baureihe, w_ben_gk ben_bauart, w_ben_gk ben_karosserie, w_publben WHERE fztyp_mospid = fgstnr_mospid AND fztyp_baureihe = baureihe_baureihe AND baureihe_textcode = ben_baureihe.ben_textcode AND fztyp_karosserie = publben_bezeichnung AND publben_art = 'K' AND ben_karosserie.ben_textcode = publben_textcode AND ben_baureihe.ben_iso = ? AND ben_karosserie.ben_iso = ? AND ben_bauart.ben_iso = ? AND ben_baureihe.ben_regiso = ? AND ben_karosserie.ben_regiso = ? AND ben_bauart.ben_regiso = ? and bauart_bauart = baureihe_bauartand ben_bauart.ben_textcode = bauart_textcode AND fztyp_typschl = fgstnr_typschl AND UPPER ( ''||? ) BETWEEN UPPER( fgstnr_von ) AND UPPER( fgstnr_bis )AND UPPER (fgstnr_anf)  = UPEER(''||?) ";
        }

        @Override
        public final String ERMITTLE_FAHRZEUGDATEN_AUS_MOSPID() {
            return "SELECT DISTINCT baureihe_marke_tps marke, baureihe_produktart produktart, baureihe_bauart bauart, ben_bauart.ben_text bauartBez, fztyp_vbereich vbereich, fztyp_baureihe baureihe, ben_baureihe.ben_text baureiheBez, fztyp_ktlgausf katalogausf, fztyp_vbez vbezeichnung, fztyp_erwvbez vbezeichnungerw, fztyp_motor motor, fztyp_karosserie karosserie, ben_karosserie.ben_text karosserieBez, fztyp_katalysator katalysator, fztyp_sichtschutz sichtschutz FROM w_fztyp, w_bauart, w_baureihe, w_ben_gk ben_baureihe, w_ben_gk ben_bauart, w_ben_gk ben_karosserie, w_publben WHERE fztyp_baureihe = baureihe_baureihe AND baureihe_textcode = ben_baureihe.ben_textcode AND fztyp_karosserie = publben_bezeichnung AND publben_art = 'K' AND ben_karosserie.ben_textcode = publben_textcode AND ben_baureihe.ben_iso = ? AND ben_karosserie.ben_iso = ? AND ben_bauart.ben_iso = ? AND ben_baureihe.ben_regiso = ? AND ben_karosserie.ben_regiso = ? AND ben_bauart.ben_regiso = ?  and bauart_bauart = baureihe_bauart and ben_bauart.ben_textcode = bauart_textcode AND fztyp_mospid = ? ";
        }

        @Override
        public final String ERMITTLE_NOETIGE_FZ_ATTRIBUTE_MOSPID() {
            return "SELECT DISTINCT trim(btzeilenz_automatik) automatik,\ttrim(btzeilenz_lenkg) lenkung,\tbtzeilenz_eins datEins,\tbtzeilenz_auslf datAusl FROM w_btzeilenzub, w_btzeilenzub_verbauung where btzeilenz_btnr = ? and btzeilenz_bildposnr = coalesce(?, btzeilenz_bildposnr) and btzeilenz_btnr = btzeilenzv_btnr and btzeilenzv_pos = btzeilenz_pos and btzeilenzv_mospid = ? ";
        }
    }

    public static final class Listenfueller
    extends SQLStatements.Listenfueller {
        @Override
        public final String LOAD_HAUPTKATEGORIE() {
            return "SELECT hauptkat_id, hauptkat_marke_tps,hauptkat_produktart,w_ben_gk.ben_text,w_grafik_ipac.grafikipac_blob,hauptkat_pos FROM w_ben_gk, w_hauptkategorie LEFT OUTER JOIN w_grafik_ipac ON (w_hauptkategorie.hauptkat_grafikid = w_grafik_ipac.grafikipac_id AND w_grafik_ipac.grafikipac_art = 'K') WHERE hauptkat_produktart=? AND hauptkat_marke_tps=? AND w_ben_gk.ben_textcode = w_hauptkategorie.hauptkat_textcode AND w_ben_gk.ben_iso = ? AND w_ben_gk.ben_regiso = ? ORDER BY hauptkat_pos";
        }

        @Override
        public final String LOAD_UNTERKATEGORIE_ALLE() {
            return "SELECT unterkat_id ukId, w_ben_gk.ben_text benennung, unterkat_hkid hkId, w_grafik_ipac.grafikipac_blob image, unterkat_pos pos FROM w_ben_gk,  w_hauptkategorie, w_unterkategorie LEFT OUTER JOIN w_grafik_ipac ON (w_unterkategorie.unterkat_grafikid = w_grafik_ipac.grafikipac_id AND w_grafik_ipac.grafikipac_art = 'K') WHERE w_hauptkategorie.hauptkat_id = w_unterkategorie.unterkat_hkid AND w_hauptkategorie.hauptkat_produktart = ? AND w_hauptkategorie.hauptkat_marke_tps=? AND w_ben_gk.ben_textcode=w_unterkategorie.unterkat_textcode AND w_ben_gk.ben_iso=? AND w_ben_gk.ben_regiso = ?  ORDER BY hauptkat_pos, unterkat_pos";
        }

        @Override
        public final String ERMITTLE_GRAFIK_UNTERKATEGORIE_FB() {
            return "select grafikipac_blob\nfrom w_grafik_ipac,\n     w_marketingprodukt_grafik,\n     w_bildtafzub_marketing,\n  \t  w_bildtafzub,\n\t \t\tw_hk_uk_sa,\n\t\t\tw_bildtaf\n,\t\t\tw_bildtaf_marke\nwhere hkuksa_ukid = ?\nand hkuksa_salaid = bildtafz_salaid\nand bildtafz_btnr = bildtafzm_btnr\nand bildtaf_btnr = bildtafm_btnr\nand bildtafzm_produktid = mgraf_produktid\nand bildtaf_btnr = bildtafz_btnr\n and bildtafm_marke_tps = hkuksa_marke_tps and bildtaf_produktart = hkuksa_produktart and mgraf_marktid = ?\nand mgraf_grafikid = grafikipac_id\nand grafikipac_art = mgraf_art\nand mgraf_art = ?\norder by bildtaf_hg, bildtaf_fg, mgraf_pos";
        }

        @Override
        public final String ERMITTLE_GRAFIK_UNTERKATEGORIE_EINZELN() {
            return "select w_grafik_ipac.grafikipac_blob image\nfrom w_unterkategorie LEFT OUTER JOIN w_grafik_ipac ON (w_unterkategorie.unterkat_grafikid = w_grafik_ipac.grafikipac_id AND w_grafik_ipac.grafikipac_art = 'K') where unterkat_id = ?\n";
        }

        @Override
        public final String LOAD_UNTERKATEGORIE_MIT_HAUPTKATEGORIE() {
            return "SELECT unterkat_id,w_ben_gk.ben_text, unterkat_hkid, w_grafik_ipac.grafikipac_blob,unterkat_pos from w_ben_gk,  w_hauptkategorie, w_unterkategorie LEFT OUTER JOIN w_grafik_ipac ON (w_unterkategorie.unterkat_grafikid = w_grafik_ipac.grafikipac_id AND w_grafik_ipac.grafikipac_art = 'K') where w_hauptkategorie.hauptkat_id = w_unterkategorie.unterkat_hkid and w_hauptkategorie.hauptkat_produktart = ? and w_hauptkategorie.hauptkat_marke_tps=? and w_ben_gk.ben_textcode=w_unterkategorie.unterkat_textcode and w_ben_gk.ben_iso=? and w_ben_gk.ben_regiso = ?  and w_hauptkategorie.hauptkat_id = ? order by unterkat_pos, unterkat_hkid";
        }

        @Override
        public final String LOAD_BAUREIHENAUSWAHL() {
            return "select distinct baureihe_baureihe Baureihe, ben_text ExtBaureihe, baureihe_position Pos from w_baureihe, w_ben_gk, w_fztyp where baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in ('BE', ?) and baureihe_baureihe = fztyp_baureihe and fztyp_vbereich = ? and fztyp_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and baureihe_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? order by Pos ";
        }

        @Override
        public final String LOAD_BAUARTMOTORRAD_AUSWAHL() {
            return "select distinct baureihe_bauart Bauart, ben_text ExtBauart, bauart_position Pos from w_baureihe, w_bauart, w_ben_gk, w_fztyp where baureihe_marke_tps = ? and baureihe_produktart = ? and baureihe_vbereich in ('BE', ?) and fztyp_baureihe = baureihe_baureihe and fztyp_vbereich = ? and fztyp_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and bauart_bauart = baureihe_bauart and ben_textcode = bauart_textcode and ben_iso = ? and ben_regiso = ? order by Pos";
        }

        @Override
        public final String LOAD_KAROSSERIEFORMENAUSWAHL() {
            return "select distinct fztyp_karosserie Karosserie, ben_text ExtKarosserie from w_fztyp, w_ben_gk, w_publben where fztyp_baureihe = ? and fztyp_vbereich in ('BE', ?) and fztyp_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and publben_art = 'K' and fztyp_karosserie = publben_bezeichnung and publben_textcode = ben_textcode and ben_iso = ? and ben_regiso = ? order by ExtKarosserie ";
        }

        @Override
        public final String LOAD_MODELLAUSWAHL_PKW() {
            return "select distinct fztyp_erwvbez Modell, vbezp_pos Pos from w_vbez_pos, w_fztyp  where fztyp_baureihe = ? and fztyp_vbereich in ('BE', ?) &KAROSSERIE_STMT& and fztyp_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and vbezp_baureihe = fztyp_baureihe and vbezp_vbez = fztyp_vbez order by Pos, Modell";
        }

        @Override
        public final String LOAD_MODELLAUSWAHL_MOTORRAD() {
            return "select distinct fztyp_erwvbez Modell, vbezp_pos Pos from w_vbez_pos, w_fztyp  where fztyp_baureihe = ? and fztyp_vbereich in ('BE', ?) and fztyp_ktlgausf in (&REGIONEN&) and fztyp_sichtschutz = 'N' and vbezp_baureihe = fztyp_baureihe and vbezp_vbez = fztyp_vbez order by Pos, Modell";
        }

        @Override
        public final String LOAD_KATALOGAUSFUEHRUNGEN() {
            return "SELECT DISTINCT fztyp_ktlgausf katAusf FROM w_fztyp WHERE fztyp_baureihe = ? AND fztyp_vbereich IN ('BE', ?) AND fztyp_karosserie = ? AND fztyp_erwvbez = ? AND fztyp_ktlgausf IN (&REGIONEN&) ORDER BY katAusf";
        }

        @Override
        public final String LOAD_LENKUNGEN() {
            return "SELECT DISTINCT fztyp_lenkung Lenkung FROM w_fztyp WHERE fztyp_baureihe = ? AND fztyp_vbereich IN ('BE', ?) AND fztyp_karosserie = ? AND fztyp_erwvbez = ? AND fztyp_ktlgausf = ? ORDER BY Lenkung";
        }

        @Override
        public final String LOAD_GETRIEBE() {
            return "SELECT DISTINCT fztyp_getriebe Getriebe FROM w_fztyp WHERE fztyp_baureihe = ? AND fztyp_vbereich IN ('BE', ?) AND fztyp_karosserie = ? AND fztyp_erwvbez = ? AND fztyp_ktlgausf = ? AND fztyp_lenkung = ? ORDER BY Getriebe ";
        }

        @Override
        public final String LOAD_PRODUKTIONSMONAT() {
            return "SELECT DISTINCT fgstnr_prod monat FROM w_fztyp, w_fgstnr WHERE fztyp_mospid = fgstnr_mospid AND fztyp_typschl = fgstnr_typschl AND fztyp_baureihe = ? AND fztyp_vbereich IN ('BE', ?) AND fztyp_karosserie = ? AND fztyp_erwvbez = ? AND fztyp_ktlgausf = ? AND fztyp_lenkung = ? AND fztyp_getriebe = ? ORDER BY monat";
        }

        @Override
        public final String LOAD_PRODUKTIONSMONAT_MOTORRAD() {
            return "SELECT DISTINCT fgstnr_prod monat FROM w_fztyp, w_fgstnr WHERE fztyp_mospid = fgstnr_mospid AND fztyp_typschl = fgstnr_typschl AND fztyp_baureihe = ? AND fztyp_vbereich IN ('BE', ?) AND fztyp_karosserie = ? AND fztyp_erwvbez = ? AND fztyp_ktlgausf = ? ORDER BY monat";
        }

        @Override
        public final String LOAD_MODELLSPALTEN() {
            return "SELECT DISTINCT fztyp_mospid Mospid FROM w_fztyp WHERE fztyp_baureihe = '&BAUREIHE&' &KAROSSERIE_STMT&&ERW_VBEZ_STMT&&KATALOG_STMT&";
        }

        @Override
        public final String LOAD_MODELLSPALTEN_KAROSSERIE() {
            return "and fztyp_karosserie = '&KAROSSERIE&' ";
        }

        @Override
        public final String LOAD_MODELLSPALTEN_ERW_VBEZ() {
            return "and fztyp_erwvbez = '&ERW_VBEZ&' ";
        }

        @Override
        public final String LOAD_MODELLSPALTEN_KATALOG() {
            return "and fztyp_ktlgausf = '&KATALOG&' ";
        }

        @Override
        public final String LOAD_MAERKTEAUSWAHL() {
            return "SELECT marktipac_id,  ben_text, \tmarktipac_kuerzel  marktipac_relevanz_pa,  marktipac_lkz \tFROM w_markt_ipac, w_ben_gk \tWHERE marktipac_textcode = ben_textcode AND ben_iso = ? AND ben_regiso = ? \tORDER BY marktipac_id";
        }

        @Override
        public final String ERMITTLE_DEFAULT_MARKT() {
            return "select marktipacs_id  from w_markt_ipac_sprache where marktipacs_spriso = ? and marktipacs_sprregiso = ? UNION ALL select marktipacs_id from w_markt_ipac_sprache where marktipacs_spriso= ? UNION ALL select marktipacs_id from w_markt_ipac_sprache where marktipacs_sprregiso= ?";
        }

        @Override
        public final String ERMITTLE_MARKT_ZU_ID() {
            return "select ben_text from w_markt_ipac, w_ben_gk where marktipac_id = ? and marktipac_textcode = ben_textcode and ben_iso = ? and ben_regiso = ?";
        }

        @Override
        public final String ERMITTLE_DEFAULT_SPRACHE_MARKT() {
            return "select marktipacs_spriso iso,  marktipacs_sprregiso regIso  from w_markt_ipac_sprache  where marktipacs_id = ?";
        }

        @Override
        public final String ERMITTLE_MARKE_PRODUKTARTEN() {
            return "select distinct bildtafm_marke_tps marke, bildtaf_produktart produktArt from w_bildtaf, w_bildtaf_marke where bildtafm_btnr = bildtaf_btnr";
        }
    }
}

