/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.zub.dbaccess;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.DuplicateValueException;
import webetk.InvalidInitializationException;
import webetk.ObjectLockedException;
import webetk.ThreadSafeSimpleDateFormat;
import webetk.WebetkUtils;
import webetk.app.Bedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.MarktIpac;
import webetk.app.ServerGlobalObjects;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.HauptKategorie;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.Variante;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.AnfrageSuche;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.AngebotsSuche;
import webetk.app.zub.verwaltung.AufwandsKonfigPosition;
import webetk.app.zub.verwaltung.AufwandsKonfiguration;
import webetk.app.zub.verwaltung.BaseVorgang;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.app.zub.verwaltung.FilialeZub;
import webetk.app.zub.verwaltung.IMarkeProduktArt;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.app.zub.verwaltung.KonfigurationsPosition;
import webetk.app.zub.verwaltung.Kunde;
import webetk.app.zub.verwaltung.NutzerZub;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.db.zub.SQLStatements;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;

public class VerwaltungDbAccess {
    private static Logger log = Logger.getLogger(VerwaltungDbAccess.class);
    private static ThreadSafeSimpleDateFormat sdf = new ThreadSafeSimpleDateFormat("yyyyMMdd");
    static final int MIN_SEARCH_SIZE = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Anfrage ladeAnfrage(String user, String firma, int anfrageId, String iso, String regIso, boolean alsVorlage) throws SQLException, DatabaseBusyException, ObjectLockedException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.ladeAnfrage");
            Anfrage anfrage = VerwaltungDbAccess.ladeAnfrageInternal(con, anfrageId, alsVorlage);
            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_ANFRAGE_VORGANG_DEFAULT_ID();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, anfrage.getAnfrageId());
            textPs.setString(2, user);
            textPs.setString(3, firma);
            result = textPs.executeQuery();
            if (result.next()) {
                int vorgangsId = result.getInt("vorgang");
                Vorgang defaultVorgang = null;
                if (anfrage.getVorgangsId().contains(new Integer(vorgangsId))) {
                    defaultVorgang = VerwaltungDbAccess.ladeVorgang(user, firma, result.getInt("vorgang"), iso, regIso);
                } else if (anfrage.getVorgangsId().size() > 0) {
                    defaultVorgang = VerwaltungDbAccess.ladeVorgang(user, firma, anfrage.getVorgangsId(anfrage.getVorgangsId().size() - 1), iso, regIso);
                }
                anfrage.setVorgang(defaultVorgang);
            } else if (anfrage.getVorgangsId() != null && anfrage.getVorgangsId().size() > 0) {
                Vorgang defaultVorgang = null;
                defaultVorgang = VerwaltungDbAccess.ladeVorgang(user, firma, anfrage.getVorgangsId(anfrage.getVorgangsId().size() - 1), iso, regIso);
                anfrage.setVorgang(defaultVorgang);
            }
            anfrage.setOffeneAngebote(VerwaltungDbAccess.hasOffeneAngebote(con, anfrageId));
            VerwaltungDbAccess.sperreAnfrage(new Integer(anfrage.getAnfrageId()), user);
            Anfrage anfrage2 = anfrage;
            return anfrage2;
        }
        finally {
            if (textPs != null) {
                textPs.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "ladeAnfrage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOffeneAngebote(Connection con, int anfrageId) throws SQLException {
        ResultSet rs = null;
        try (PreparedStatement textPs = null;){
            textPs = con.prepareStatement(SQLStatements.AnfrageVorgangsHelper.instance.HAT_OFFENE_ANGEBOTE());
            textPs.setInt(1, anfrageId);
            rs = textPs.executeQuery();
            if (rs.next()) {
                int anzahl = rs.getInt("anzahl");
                boolean bl = anzahl > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Anfrage ladeAnfrageInternal(Connection con, int anfrageId, boolean alsVorlage) throws SQLException {
        PreparedStatement textPs = null;
        ResultSet result = null;
        String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_ANFRAGE();
        try {
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, anfrageId);
            result = textPs.executeQuery();
            if (result.next()) {
                String sAnlageDatum = result.getString("anlageDatum");
                java.util.Date anlageDatum = null;
                try {
                    anlageDatum = sdf.parse(sAnlageDatum.substring(0, 8));
                }
                catch (Exception e) {
                    log.error("Unable to parse anlageDatum: " + sAnlageDatum, e);
                }
                Anfrage anfrage = new Anfrage(result.getString("name"), result.getString("marke"), result.getString("produktart").charAt(0), anlageDatum, result.getString("anlageUser"), result.getString("firma"), result.getString("filiale"));
                anfrage.setAnfrageId(result.getInt("id"));
                String aenderDat = result.getString("aenderungsDatum");
                if (aenderDat != null) {
                    try {
                        java.util.Date aenderungsDatum = sdf.parse(aenderDat.substring(0, 8));
                        anfrage.setAenderungsDatum(aenderungsDatum);
                        anfrage.setAenderungsNutzerId(result.getString("aenderungsUser"));
                    }
                    catch (Exception e) {
                        log.debug("aenderungsDatum ist kein Datum", e);
                    }
                }
                anfrage.setGesperrtVonId(result.getString("gesperrtVon"));
                anfrage.setBemerkung(result.getString("bemerkung"));
                anfrage.setStichworte(result.getString("stichworte"));
                anfrage.setKunde(new Kunde(result.getString("k_nummer"), result.getString("k_anrede"), result.getString("k_name"), result.getString("k_vorname"), result.getString("k_strasse"), result.getString("k_hausnummer"), result.getString("k_land"), result.getString("k_plz"), result.getString("k_stadt"), result.getString("k_postfach"), result.getString("k_telefon"), result.getString("k_mobil"), result.getString("k_fax"), result.getString("k_email"), null));
                anfrage.getKunde().setKundenId(result.getInt("k_id"));
                result.getInt("infoId");
                anfrage.setExplizitGespeichert(!result.wasNull());
                Anfrage anfrage2 = anfrage = VerwaltungDbAccess.ermittleVorgaenge(con, anfrage, alsVorlage);
                return anfrage2;
            }
            Anfrage anfrage = null;
            return anfrage;
        }
        finally {
            if (textPs != null) {
                textPs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Anfrage ermittleVorgaenge(Connection con, Anfrage anfrage, boolean alsVorlage) throws SQLException {
        ResultSet result = null;
        try (Statement textPs = null;){
            String statement = null;
            statement = alsVorlage ? SQLStatements.AnfrageVorgangsHelper.instance.LOAD_ANFRAGEN_ALLE_VORGAENGE() : SQLStatements.AnfrageVorgangsHelper.instance.LOAD_ANFRAGEN_VORGAENGE();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, anfrage.getAnfrageId());
            result = textPs.executeQuery();
            while (result.next()) {
                anfrage.addVorgangsId(result.getInt("id"));
                anfrage.addVorgangsName(result.getString("name"));
                String valid = result.getString("valid");
                if (valid != null && valid.equals("J")) {
                    anfrage.setValid(true);
                    continue;
                }
                anfrage.setValid(false);
            }
        }
        return anfrage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vorgang ladeVorgang(String user, String firma, int vorgangsId, String iso, String regIso) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globals = ServerGlobalObjects.getInstance();
        try {
            con = globals.getDBConnectionNutzer("ladeVorgang");
            Vorgang vorgang = VerwaltungDbAccess.ladeVorgangInternal(con, user, firma, vorgangsId, iso, regIso);
            vorgang.setKonfiguration(VerwaltungDbAccess.ermittleVorgangDefaultKonfiguration(con, user, firma, vorgang, iso, regIso));
            Vorgang vorgang2 = vorgang;
            return vorgang2;
        }
        finally {
            if (con != null) {
                globals.freeDBConnectionNutzer(con, "ladeVorgang");
            }
        }
    }

    private static Vorgang ladeVorgangInternal(Connection con, String user, String firma, int vorgangsId, String iso, String regIso) throws SQLException, DatabaseBusyException {
        return VerwaltungDbAccess.ladeVorgangInternal(con, user, firma, vorgangsId, iso, regIso, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vorgang ladeVorgangInternal(Connection con, String user, String firma, int vorgangsId, String iso, String regIso, boolean angebotsModus) throws SQLException, DatabaseBusyException {
        log.debug("Now Accessing Database");
        ResultSet result = null;
        try (Statement textPs = null;){
            String aenderDat;
            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANG();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgangsId);
            result = textPs.executeQuery();
            if (!result.next()) {
                Vorgang vorgang = null;
                return vorgang;
            }
            int anfrageId = result.getInt("anfrageId");
            java.util.Date anlageDatum = null;
            try {
                anlageDatum = sdf.parse(result.getString("anlageDatum").substring(0, 8));
            }
            catch (ParseException e) {
                log.error("Unable to parse anlageDatum: " + result.getString("anlageDatum"), e);
            }
            Vorgang vorgang = new Vorgang(result.getString("btnr"), result.getString("bildpos"), result.getString("name"), anlageDatum);
            vorgang.setAnfrageId(anfrageId);
            vorgang.setVorgangsId(result.getInt("id"));
            int hkId = result.getInt("hkId");
            if (!result.wasNull()) {
                vorgang.setHkId(hkId);
            }
            int ukId = result.getInt("ukId");
            if (!result.wasNull()) {
                vorgang.setUkId(ukId);
            }
            if ((aenderDat = result.getString("aenderungsDatum")) != null) {
                try {
                    java.util.Date aenderungsDatum = sdf.parse(aenderDat.substring(0, 8));
                    vorgang.setAenderungDatum(aenderungsDatum);
                }
                catch (Exception e) {
                    log.error("Unable to parse aenderungsDatum: " + aenderDat, e);
                }
            }
            result.close();
            vorgang.setFahrzeug(VerwaltungDbAccess.ermittleVorgangFahrzeug(con, vorgangsId));
            vorgang = VerwaltungDbAccess.ermittleKonfigurationen(con, vorgang, angebotsModus);
            Vorgang vorgang2 = vorgang = VerwaltungDbAccess.setzeKategorien(vorgang, iso, regIso);
            return vorgang2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ladeVorgangAnfrageId(Connection con, String user, String firma, int vorgangsId, String iso, String regIso) throws SQLException, DatabaseBusyException {
        log.debug("Now Accessing Database");
        ResultSet result = null;
        try (Statement textPs = null;){
            int anfrageId;
            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANG();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgangsId);
            result = textPs.executeQuery();
            result.next();
            int n = anfrageId = result.getInt("anfrageId");
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Konfiguration ermittleVorgangDefaultKonfiguration(Connection con, String user, String firma, Vorgang vorgang, String iso, String regIso) throws SQLException, DatabaseBusyException {
        Konfiguration konfiguration;
        block17: {
            PreparedStatement textPs;
            block14: {
                ResultSet result;
                block12: {
                    Konfiguration konfiguration2;
                    block16: {
                        block13: {
                            block10: {
                                Konfiguration konfiguration3;
                                block15: {
                                    block11: {
                                        log.debug("Now Accessing Database");
                                        textPs = null;
                                        result = null;
                                        try {
                                            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANG_KONFIGURATION_DEFAULT_ID();
                                            textPs = con.prepareStatement(statement);
                                            textPs.setInt(1, vorgang.getVorgangsId());
                                            textPs.setString(2, user);
                                            textPs.setString(3, firma);
                                            result = textPs.executeQuery();
                                            if (!result.next()) break block10;
                                            int konfigurationsId = result.getInt("konfiguration");
                                            String konfigurationsName = result.getString("konfigname");
                                            Konfiguration konfig = new Konfiguration();
                                            konfig.setKonfigurationsId(konfigurationsId);
                                            konfig.setKonfigurationsName(konfigurationsName);
                                            konfiguration3 = konfig;
                                            if (result == null) break block11;
                                        }
                                        catch (Throwable throwable) {
                                            if (result != null) {
                                                WebetkUtils.closeQuery(result);
                                            } else if (textPs != null) {
                                                textPs.close();
                                            }
                                            throw throwable;
                                        }
                                        WebetkUtils.closeQuery(result);
                                        break block15;
                                    }
                                    if (textPs != null) {
                                        textPs.close();
                                    }
                                }
                                return konfiguration3;
                            }
                            if (vorgang.getKonfigurationsId() == null || vorgang.getKonfigurationsId().size() <= 0) break block12;
                            Konfiguration konfig = new Konfiguration();
                            konfig.setKonfigurationsId(vorgang.getKonfigurationsId(vorgang.getKonfigurationsId().size() - 1));
                            konfig.setKonfigurationsName(vorgang.getKonfigurationsName(vorgang.getKonfigurationsNamen().size() - 1));
                            konfiguration2 = konfig;
                            if (result == null) break block13;
                            WebetkUtils.closeQuery(result);
                            break block16;
                        }
                        if (textPs != null) {
                            textPs.close();
                        }
                    }
                    return konfiguration2;
                }
                konfiguration = VerwaltungDbAccess.ermittleVorgangDefaultKonfigurationBeimErstenOeffnen(con, firma, vorgang, iso, regIso);
                if (result == null) break block14;
                WebetkUtils.closeQuery(result);
                break block17;
            }
            if (textPs != null) {
                textPs.close();
            }
        }
        return konfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Konfiguration ermittleVorgangDefaultKonfigurationBeimErstenOeffnen(Connection con, String firma, Vorgang vorgang, String iso, String regIso) throws SQLException, DatabaseBusyException {
        Konfiguration konfiguration;
        block17: {
            PreparedStatement textPs;
            block14: {
                ResultSet result;
                block12: {
                    Konfiguration konfiguration2;
                    block16: {
                        block13: {
                            block10: {
                                Konfiguration konfiguration3;
                                block15: {
                                    block11: {
                                        log.debug("Now Accessing Database");
                                        textPs = null;
                                        result = null;
                                        try {
                                            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANG_KONFIGURATION_DEFAULT_ID_FIRST_VIEW();
                                            textPs = con.prepareStatement(statement);
                                            textPs.setInt(1, vorgang.getVorgangsId());
                                            textPs.setString(2, firma);
                                            result = textPs.executeQuery();
                                            if (!result.next()) break block10;
                                            int konfigurationsId = result.getInt("konfiguration");
                                            String konfigurationsName = result.getString("konfigname");
                                            Konfiguration konfig = new Konfiguration();
                                            konfig.setKonfigurationsId(konfigurationsId);
                                            konfig.setKonfigurationsName(konfigurationsName);
                                            konfiguration3 = konfig;
                                            if (result == null) break block11;
                                        }
                                        catch (Throwable throwable) {
                                            if (result != null) {
                                                WebetkUtils.closeQuery(result);
                                            } else if (textPs != null) {
                                                textPs.close();
                                            }
                                            throw throwable;
                                        }
                                        WebetkUtils.closeQuery(result);
                                        break block15;
                                    }
                                    if (textPs != null) {
                                        textPs.close();
                                    }
                                }
                                return konfiguration3;
                            }
                            if (vorgang.getKonfigurationsId() == null || vorgang.getKonfigurationsId().size() <= 0) break block12;
                            Konfiguration konfig = new Konfiguration();
                            konfig.setKonfigurationsId(vorgang.getKonfigurationsId(vorgang.getKonfigurationsId().size() - 1));
                            konfig.setKonfigurationsName(vorgang.getKonfigurationsName(vorgang.getKonfigurationsNamen().size() - 1));
                            konfiguration2 = konfig;
                            if (result == null) break block13;
                            WebetkUtils.closeQuery(result);
                            break block16;
                        }
                        if (textPs != null) {
                            textPs.close();
                        }
                    }
                    return konfiguration2;
                }
                konfiguration = null;
                if (result == null) break block14;
                WebetkUtils.closeQuery(result);
                break block17;
            }
            if (textPs != null) {
                textPs.close();
            }
        }
        return konfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Konfiguration ladeKonfiguration(String user, String firma, int konfigurationsId, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globals = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            Konfiguration konfig;
            con = globals.getDBConnectionNutzer("ladeKonfiguration");
            Konfiguration konfiguration = konfig = VerwaltungDbAccess.ladeKonfigurationInternal(con, user, firma, konfigurationsId, iso, regIso);
            return konfiguration;
        }
        finally {
            if (con != null) {
                globals.freeDBConnectionNutzer(con, "ladeKonfiguration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ermittleBedingungsListe(Fahrzeug fahrzeug, int vorgangsId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globals = ServerGlobalObjects.getInstance();
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            Long id;
            con = globals.getDBConnectionNutzer("ermittleBedingungsListe");
            String statement = SQLStatements.Verwaltung.instance.ERMITTLE_VORGANG_BEDINGUNGEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgangsId);
            result = textPs.executeQuery();
            Bedingungsmenge menge = fahrzeug.getBedingungsMenge();
            ArrayList<String> werteListe = new ArrayList<String>();
            while (result.next()) {
                String krit = result.getString("kez");
                String wert = result.getString("wert");
                if (!wert.equalsIgnoreCase("1")) continue;
                werteListe.add(krit);
            }
            result.close();
            try {
                Enumeration<Long> beds = menge.getBedingungen();
                while (beds.hasMoreElements()) {
                    id = beds.nextElement();
                    for (String krit : werteListe) {
                        if (id != Long.parseLong(krit)) continue;
                        menge.setBedWert(id, new Bedingungswert("1"));
                    }
                }
            }
            catch (InvalidInitializationException e) {
                log.warn("InitializationException during get of active Bedingungen", e);
            }
            Enumeration<Long> keys = fahrzeug.getBedingungsMenge().getBedingungen();
            while (keys.hasMoreElements()) {
                id = keys.nextElement();
                if (!menge.getBedWert(id).equals("0")) continue;
                try {
                    menge.setBedWert(id, new Bedingungswert("2"));
                }
                catch (InvalidInitializationException e) {
                    log.warn("InvalidInitializationException ", e);
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (con != null) {
                globals.freeDBConnectionNutzer(con, "ermittleBedingungsListe");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Fahrzeug ermittleVorgangFahrzeug(Connection con, int vorgangsId) throws SQLException {
        Statement textPs = null;
        ResultSet result = null;
        boolean hasFahrzeug = false;
        Fahrzeug fahrzeug = new Fahrzeug();
        try {
            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANG_FAHRZEUGINFO();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgangsId);
            result = textPs.executeQuery();
            String baujahr = null;
            String baumonat = null;
            while (result.next()) {
                hasFahrzeug = true;
                String krit = result.getString("art");
                String wert = result.getString("wert");
                if (krit.equalsIgnoreCase("MARKE_TPS")) {
                    fahrzeug.setMarke(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("PRODUKTART")) {
                    fahrzeug.setProduktArt(wert.charAt(0));
                    continue;
                }
                if (krit.equalsIgnoreCase("VBEREICH")) {
                    fahrzeug.setVbereich(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("BAUART")) {
                    fahrzeug.setBauArt(wert.charAt(0));
                    continue;
                }
                if (krit.equalsIgnoreCase("BAUREIHE")) {
                    fahrzeug.setBaureihe(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("KAROSSERIE")) {
                    fahrzeug.setKarosserie(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("VBEZ")) {
                    fahrzeug.setModell(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("VBEZERW")) {
                    fahrzeug.setModellBezeichnung(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("MOTOR")) {
                    fahrzeug.setMotor(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("KTLGAUSF")) {
                    fahrzeug.setKatalogausf(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("LENKUNG")) {
                    fahrzeug.setLenkung(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("GETRIEBE")) {
                    fahrzeug.setGetriebe(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("BAUJAHR")) {
                    fahrzeug.setBaujahr(wert);
                    baujahr = wert;
                    continue;
                }
                if (krit.equalsIgnoreCase("BAUMONAT")) {
                    fahrzeug.setZulassungsmonat(wert);
                    baumonat = wert;
                    continue;
                }
                if (krit.equalsIgnoreCase("FGSTNR")) {
                    fahrzeug.setFahrgestellnummer(wert);
                    continue;
                }
                if (krit.equalsIgnoreCase("BEDINGUNG")) continue;
                log.error("Invalid value \"" + krit + "\" in w_zub_vorgang_fahrzeug.vorgangfzg_kritart");
            }
            if (baujahr != null && baumonat != null && !baujahr.equals("kA") && !baumonat.equals("kA")) {
                fahrzeug.setProduktionsdatum(baujahr + baumonat);
            }
            if (fahrzeug.getProduktArt() == ' ') {
                fahrzeug.setProduktArt(Produkte.getInstance().getProdukt("AUTO").getBerechtigung().charAt(0));
            }
        }
        finally {
            textPs.close();
        }
        if (hasFahrzeug) {
            return fahrzeug;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vorgang ermittleKonfigurationen(Connection con, Vorgang vorgang, boolean angebotsModus) throws SQLException {
        ResultSet result = null;
        try (Statement textPs = null;){
            String statement = null;
            statement = !angebotsModus ? SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANGS_KONFIGURATIONEN() : SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANGS_KONFIGURATIONEN_ANGEBOT();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgang.getVorgangsId());
            result = textPs.executeQuery();
            while (result.next()) {
                vorgang.addKonfigurationsId(result.getInt("id"));
                vorgang.addKonfigurationsName(result.getString("name"));
                if (result.getInt("angebotsnummer") == 0) {
                    vorgang.addKonfigurationsArt("Konfiguration");
                    continue;
                }
                vorgang.addKonfigurationsArt("Angebot " + result.getString("status"));
            }
        }
        return vorgang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ermittleAnzahlKonfigVonVorgang(int vorgangsId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Statement textPs = null;
        ResultSet result = null;
        int numberOfKonfig = 0;
        Connection con = null;
        try {
            con = globs.getDBConnectionNutzer("ermittleAnzahlKonfigVonVorgang");
            String statement = null;
            statement = SQLStatements.AnfrageVorgangsHelper.instance.ERMITTLE_ANZAHL_KONFIG_VON_VORGANG();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgangsId);
            result = textPs.executeQuery();
            if (result.next()) {
                numberOfKonfig = result.getInt("anzahl");
            }
        }
        finally {
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "ermittleAnzahlKonfigVonVorgang");
            }
        }
        return numberOfKonfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vorgang setzeKategorien(Vorgang vorgang, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement textPs = null;
        ResultSet result = null;
        try {
            String statement;
            con = globs.getDBConnection("setzeKategorien");
            if (vorgang.getHkId() > Integer.MIN_VALUE && vorgang.getUkId() > Integer.MIN_VALUE) {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_EXISTING_VORGANG_KATEGORIE();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, vorgang.getHkId());
                textPs.setInt(2, vorgang.getUkId());
                textPs.setString(3, iso);
                textPs.setString(4, regIso == null ? "  " : regIso);
                textPs.setString(5, iso);
                textPs.setString(6, regIso == null ? "  " : regIso);
                result = textPs.executeQuery();
                if (result.next()) {
                    vorgang.setHauptKategorie(new HauptKategorie(vorgang.getHkId(), result.getString("marke"), result.getString("produktart"), result.getString("hkBen"), result.getInt("hkPos"), new ArrayList<HitListenUnterkategorie>()));
                    boolean isLifestyle = result.getString("istLifestyle").equals("J");
                    vorgang.setUnterKategorie(new HitListenUnterkategorie(vorgang.getHkId(), result.getString("ukBen"), result.getInt("ukPos"), isLifestyle));
                    result.close();
                    Vorgang vorgang2 = vorgang;
                    return vorgang2;
                }
            }
            statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANG_KATEGORIE();
            textPs = con.prepareStatement(statement);
            textPs.setString(1, vorgang.getBtNummer());
            textPs.setString(2, iso);
            textPs.setString(3, iso);
            textPs.setString(4, regIso == null ? "  " : regIso);
            textPs.setString(5, regIso == null ? "  " : regIso);
            result = textPs.executeQuery();
            if (result.next()) {
                vorgang.setHauptKategorie(new HauptKategorie(vorgang.getHkId(), result.getString("marke"), result.getString("produktart"), result.getString("hkBen"), result.getInt("hkPos"), new ArrayList<HitListenUnterkategorie>()));
                boolean isLifestyle = result.getString("istLifestyle").equals("J");
                vorgang.setUnterKategorie(new HitListenUnterkategorie(vorgang.getHkId(), result.getString("ukBen"), result.getInt("ukPos"), isLifestyle));
                result.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "setzeKategorien");
            }
            if (textPs != null) {
                textPs.close();
            }
        }
        return vorgang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Konfiguration ladeKonfigurationInternal(Connection con, String user, String firma, int konfigurationsId, String iso, String regIso) throws SQLException, DatabaseBusyException {
        log.debug("Now Accessing Database");
        ResultSet result = null;
        try (Statement textPs = null;){
            String statement = SQLStatements.KonfigurationsHelper.instance.LOAD_KONFIGURATION();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            result = textPs.executeQuery();
            if (result.next()) {
                int vorgangsId = result.getInt("id");
                String name = result.getString("name");
                double aufabschlag = result.getDouble("aufabschlag");
                int vorlage = result.getInt("vorlage");
                result.close();
                int anfrageId = VerwaltungDbAccess.ladeVorgangAnfrageId(con, user, firma, vorgangsId, iso, regIso);
                Konfiguration konfiguration = new Konfiguration(anfrageId, vorgangsId);
                konfiguration.setKonfigurationsId(konfigurationsId);
                konfiguration.setKonfigurationsName(name);
                konfiguration.setAufabschlag(aufabschlag);
                konfiguration.setKonfigurationsIdVorlage(vorlage);
                Angebot angebot = VerwaltungDbAccess.ermittleAngebot(con, konfigurationsId);
                VerwaltungDbAccess.fuelleBnbAndVariants(con, konfiguration);
                VerwaltungDbAccess.fuellePositionen(con, konfiguration, angebot != null);
                konfiguration.setLetzteSicht(VerwaltungDbAccess.ladeLetzteSicht(con, user, firma, konfiguration.getKonfigurationsId()));
                if (angebot != null) {
                    angebot.setGeladen(true);
                }
                konfiguration.setAngebot(angebot);
                Konfiguration konfiguration2 = konfiguration;
                return konfiguration2;
            }
            Konfiguration konfiguration = null;
            return konfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Konfiguration fuelleBnbAndVariants(Connection con, Konfiguration konfiguration) throws SQLException {
        ResultSet result = null;
        try (Statement textPs = null;){
            String statement = SQLStatements.KonfigurationsHelper.instance.LOAD_KONFIGURATION_VARIANTEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfiguration.getKonfigurationsId());
            result = textPs.executeQuery();
            ArrayList<Bnb> selectedBnbs = new ArrayList<Bnb>();
            while (result.next()) {
                Bnb bnbSel = new Bnb();
                bnbSel.setBildPos(result.getString("bildposnr"));
                bnbSel.setElementArt(result.getString("alementart"));
                Variante var = new Variante();
                var.setVarianteId(result.getInt("varianteid"));
                bnbSel.setSelectedVariante(var);
                selectedBnbs.add(bnbSel);
            }
            konfiguration.setSelectedBnbsMitVarianten(selectedBnbs);
        }
        return konfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Konfiguration fuellePositionen(Connection con, Konfiguration konfiguration, boolean isAngebot) throws SQLException {
        ResultSet result = null;
        try (Statement textPs = null;){
            String statement = SQLStatements.KonfigurationsHelper.instance.LOAD_KONFIGURATION_POSITIONEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfiguration.getKonfigurationsId());
            result = textPs.executeQuery();
            while (result.next()) {
                String artikelNr = result.getString("artikelNr");
                if (artikelNr != null && artikelNr.equals("null")) {
                    artikelNr = null;
                }
                KonfigurationsPosition pos = new KonfigurationsPosition(result.getString("gruppe"), result.getString("elementArt"), result.getString("status"), result.getString("artikelArt").charAt(0), artikelNr, result.getString("artikelBenennung"), result.getInt("menge"), result.getDouble("preis"), result.getDouble("rabatt"), result.getString("comment"));
                pos.setPos(result.getInt("pos"));
                pos.setMwstSatz(result.getDouble("mwStSatz"));
                pos.setMwStBetrag(result.getDouble("mwStBetrag"));
                konfiguration.addPosition(pos);
            }
            if (konfiguration.getPositionen() == null) {
                konfiguration.setPositionen(new ArrayList());
            }
        }
        return konfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ladeLetzteSicht(Connection con, String userId, String firma, int konfigurationsId) throws SQLException {
        ResultSet result = null;
        try (Statement textPs = null;){
            String statement = SQLStatements.KonfigurationsHelper.instance.LOAD_KONFIGURATION_LETZTE_SICHT();
            textPs = con.prepareStatement(statement);
            textPs.setString(1, userId);
            textPs.setString(2, firma);
            textPs.setInt(3, konfigurationsId);
            result = textPs.executeQuery();
            if (result.next()) {
                String string = result.getString("sicht");
                return string;
            }
            String string = "TECHNIK";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Angebot ermittleAngebot(Connection con, int konfigurationsId) throws SQLException {
        ResultSet result = null;
        try (Statement textPs = null;){
            String statement = SQLStatements.KonfigurationsHelper.instance.LOAD_KONFIGURATION_ANGEBOT();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            result = textPs.executeQuery();
            if (result.next()) {
                java.util.Date statusDatum = null;
                java.util.Date anlageDatum = null;
                java.util.Date bindefristDatum = null;
                int bindefrist = 0;
                String sStatusDatum = result.getString("statusDatum");
                try {
                    statusDatum = sdf.parse(sStatusDatum);
                }
                catch (ParseException e) {
                    log.error("Unable to parse statusDatum: " + sStatusDatum, e);
                }
                String sAnlageDatum = result.getString("anlageDatum");
                try {
                    anlageDatum = sdf.parse(sAnlageDatum);
                }
                catch (ParseException e) {
                    log.error("Unable to parse anlageDatum: " + sAnlageDatum, e);
                }
                String sBindeFristDatum = result.getString("bindefrist");
                try {
                    bindefristDatum = sdf.parse(sBindeFristDatum);
                }
                catch (ParseException e) {
                    log.error("Unable to parse bindeFrist : " + sBindeFristDatum);
                }
                bindefrist = VerwaltungDbAccess.getDayDiff(anlageDatum, bindefristDatum);
                Angebot angebot = new Angebot(result.getDouble("brutto"), result.getDouble("netto"), result.getString("status"), statusDatum, anlageDatum, bindefrist, result.getString("userID"));
                angebot.setKunde(new Kunde(result.getString("k_nummer"), result.getString("k_anrede"), result.getString("k_name"), result.getString("k_vorname"), result.getString("k_strasse"), result.getString("k_hausnummer"), result.getString("k_land"), result.getString("k_plz"), result.getString("k_stadt"), result.getString("k_postfach"), result.getString("k_telefon"), result.getString("k_mobil"), result.getString("k_fax"), result.getString("k_email"), result.getString("k_bemerkung")));
                angebot.getKunde().setKundenId(result.getInt("k_id"));
                angebot.setAngebotsName(result.getString("angebotsName"));
                angebot.setAngebotsnummer(result.getInt("nummer"));
                String anIspa = result.getString("an_ispa");
                if (!result.wasNull()) {
                    angebot.setAnIspa(anIspa);
                }
                angebot.setBemerkung(result.getString("bemerkung"));
                Angebot angebot2 = angebot;
                return angebot2;
            }
            Angebot angebot = null;
            return angebot;
        }
    }

    private static int getDayDiff(java.util.Date anlageDatum, java.util.Date bindefristDatum) {
        Calendar calAnlage = Calendar.getInstance();
        calAnlage.setTime(anlageDatum);
        Calendar calBindefrist = Calendar.getInstance();
        calBindefrist.setTime(bindefristDatum);
        int anlageYear = calAnlage.get(1);
        int bindefristYear = calBindefrist.get(1);
        int anlageDay = calAnlage.get(6);
        int bindefristDay = calBindefrist.get(6);
        int tempStartDay = anlageDay;
        int totalDaysDiff = 0;
        for (int i = anlageYear; i <= bindefristYear; ++i) {
            GregorianCalendar yearsEnd = new GregorianCalendar(i, 11, 31);
            int nrOfDaysRemaining = yearsEnd.get(6) - tempStartDay;
            totalDaysDiff += nrOfDaysRemaining;
            tempStartDay = 0;
        }
        GregorianCalendar yearsEnd = new GregorianCalendar(bindefristYear, 11, 31);
        return totalDaysDiff -= yearsEnd.get(6) - bindefristDay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Anfrage ladeAngebot(String user, String firma, int konfigurationsId, String userId, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            Iterator<String> it;
            con = globs.getDBConnectionNutzer("ladeAngebot");
            Konfiguration konfig = VerwaltungDbAccess.ladeKonfigurationInternal(con, user, firma, konfigurationsId, iso, regIso);
            Vorgang vorgang = VerwaltungDbAccess.ladeVorgangInternal(con, user, firma, konfig.getVorgangsId(), iso, regIso, true);
            Anfrage anfrage = VerwaltungDbAccess.ladeAnfrageInternal(con, vorgang.getAnfrageId(), false);
            if (anfrage.getVorgangsId() != null) {
                anfrage.getVorgangsId().clear();
            }
            if (anfrage.getVorgangsNamen() != null) {
                anfrage.getVorgangsNamen().clear();
            }
            anfrage.addVorgangsId(vorgang.getVorgangsId());
            anfrage.addVorgangsName(vorgang.getProduktName());
            if (vorgang.getKonfigurationsId() != null) {
                vorgang.getKonfigurationsId().clear();
            }
            vorgang.addKonfigurationsId(konfig.getKonfigurationsId());
            int counter = 0;
            if (vorgang.getKonfigurationsArt() != null) {
                it = vorgang.getKonfigurationsArt().iterator();
                while (it.hasNext()) {
                    it.next();
                    if (counter > 0) {
                        it.remove();
                    }
                    ++counter;
                }
            }
            if (vorgang.getKonfigurationsNamen() != null) {
                counter = 0;
                it = vorgang.getKonfigurationsNamen().iterator();
                while (it.hasNext()) {
                    it.next();
                    if (counter > 0) {
                        it.remove();
                    }
                    ++counter;
                }
            }
            vorgang.setKonfiguration(konfig);
            anfrage.setVorgang(vorgang);
            Anfrage anfrage2 = anfrage;
            return anfrage2;
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "ladeAngebot");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setzeMwSteuerAngebot(Konfiguration konfig) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement stat = null;
        try {
            con = globs.getDBConnectionNutzer("setzeMwSteuerAngebot");
            for (KonfigurationsPosition pos : konfig.getPositionen()) {
                stat = con.prepareStatement(SQLStatements.KonfigurationsHelper.instance.SETZE_MWST());
                VerwaltungDbAccess.setzeMwStPos((PreparedStatement)stat, pos, konfig.getKonfigurationsId());
            }
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "setzeMwSteuerAngebot");
            }
        }
    }

    private static void setzeMwStPos(PreparedStatement textPs, KonfigurationsPosition pos, int konfigId) throws SQLException {
        textPs.setDouble(1, pos.getMwstSatz());
        textPs.setDouble(2, pos.getMwStBetrag());
        textPs.setInt(3, konfigId);
        textPs.setInt(4, pos.getPos());
        int rows = textPs.executeUpdate();
        if (rows <= 0) {
            log.warn("No rows updated for konfig: " + konfigId + " pos: " + pos.getPos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ermittleNeueAngebotsNummer() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        PreparedStatement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("ermittleNeueAngebotsNummer");
            String statement = SQLStatements.AngebotsHelper.instance.GET_NEW_ANGEBOTSNUMMER();
            textPs = con.prepareStatement(statement);
            result = textPs.executeQuery();
            int angebotsNummer = 0;
            if (result.next()) {
                angebotsNummer = result.getInt("a_nr");
            }
            result.close();
            textPs.close();
            int n = angebotsNummer;
            return n;
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "ermittleNeueAngebotsNummer");
            }
        }
    }

    public static Angebot speichereAngebot(int konfigurationsId, Angebot angebot, String userId, String firmaId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.speichereAngebot");
            String statement = null;
            if (angebot.isNeu()) {
                Kunde kunde;
                statement = SQLStatements.AngebotsHelper.instance.INSERT_ANGEBOT();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, konfigurationsId);
                textPs.setInt(2, angebot.getAngebotsnummer());
                textPs.setDouble(3, angebot.getGesamtPreisNetto());
                textPs.setDouble(4, angebot.getGesamtPreisBrutto());
                textPs.setString(5, angebot.getStatus());
                textPs.setString(6, sdf.format(angebot.getStatusDatum()));
                textPs.setString(7, sdf.format(angebot.getAnlageDatum()));
                textPs.setInt(8, new Integer(sdf.format(angebot.getBindeFristDatum())));
                textPs.setString(9, userId);
                textPs.setString(10, firmaId);
                if (angebot.getKunde() == null) {
                    angebot.setKunde(new Kunde());
                }
                if ((kunde = angebot.getKunde()).getKundenId() != 0) {
                    textPs.setInt(11, kunde.getKundenId());
                } else {
                    textPs.setNull(11, 5);
                }
                if (kunde.getAnrede() != null) {
                    textPs.setString(12, kunde.getAnrede());
                } else {
                    textPs.setNull(12, 12);
                }
                if (kunde.getName() != null) {
                    textPs.setString(13, kunde.getName());
                } else {
                    textPs.setNull(13, 12);
                }
                if (kunde.getVorname() != null) {
                    textPs.setString(14, kunde.getVorname());
                } else {
                    textPs.setNull(14, 12);
                }
                if (kunde.getKundennummer() != null) {
                    textPs.setString(15, kunde.getKundennummer());
                } else {
                    textPs.setNull(15, 12);
                }
                if (kunde.getStrasse() != null) {
                    textPs.setString(16, kunde.getStrasse());
                } else {
                    textPs.setNull(16, 12);
                }
                if (kunde.getHausnr() != null) {
                    textPs.setString(17, kunde.getHausnr());
                } else {
                    textPs.setNull(17, 12);
                }
                if (kunde.getLand() != null) {
                    textPs.setString(18, kunde.getLand());
                } else {
                    textPs.setNull(18, 12);
                }
                if (kunde.getPlz() != null) {
                    textPs.setString(19, kunde.getPlz());
                } else {
                    textPs.setNull(19, 12);
                }
                if (kunde.getStadt() != null) {
                    textPs.setString(20, kunde.getStadt());
                } else {
                    textPs.setNull(20, 12);
                }
                if (kunde.getPostfachnr() != null) {
                    textPs.setString(21, kunde.getPostfachnr());
                } else {
                    textPs.setNull(21, 12);
                }
                if (kunde.getTelefonnummer() != null) {
                    textPs.setString(22, kunde.getTelefonnummer());
                } else {
                    textPs.setNull(22, 12);
                }
                if (kunde.getMobilnummer() != null) {
                    textPs.setString(23, kunde.getMobilnummer());
                } else {
                    textPs.setNull(23, 12);
                }
                if (kunde.getFaxnummer() != null) {
                    textPs.setString(24, kunde.getFaxnummer());
                } else {
                    textPs.setNull(24, 12);
                }
                if (kunde.getEmail() != null) {
                    textPs.setString(25, kunde.getEmail());
                } else {
                    textPs.setNull(25, 12);
                }
                if (angebot.getAngebotsName() != null) {
                    textPs.setString(26, angebot.getAngebotsName());
                } else {
                    textPs.setNull(26, 12);
                }
                if (angebot.getBemerkung() != null) {
                    textPs.setString(27, angebot.getBemerkung());
                } else {
                    textPs.setNull(27, 12);
                }
                textPs.execute();
                angebot.setNeu(false);
            } else {
                Kunde kunde;
                statement = SQLStatements.AngebotsHelper.instance.UPDATE_ANGEBOT();
                textPs = con.prepareStatement(statement);
                textPs.setDouble(1, angebot.getGesamtPreisNetto());
                textPs.setDouble(2, angebot.getGesamtPreisBrutto());
                textPs.setString(3, angebot.getStatus());
                textPs.setInt(4, Integer.parseInt(sdf.format(angebot.getStatusDatum())));
                textPs.setInt(5, Integer.parseInt(sdf.format(angebot.getAnlageDatum())));
                textPs.setInt(6, Integer.parseInt(sdf.format(angebot.getBindeFristDatum())));
                textPs.setString(7, userId);
                textPs.setString(8, firmaId);
                if (angebot.getKunde() == null) {
                    angebot.setKunde(new Kunde(null));
                }
                if ((kunde = angebot.getKunde()).getKundenId() != 0) {
                    textPs.setInt(9, kunde.getKundenId());
                } else {
                    textPs.setNull(9, 5);
                }
                if (kunde.getAnrede() != null) {
                    textPs.setString(10, kunde.getAnrede());
                } else {
                    textPs.setNull(10, 12);
                }
                if (kunde.getName() != null) {
                    textPs.setString(11, kunde.getName());
                } else {
                    textPs.setNull(11, 12);
                }
                if (kunde.getVorname() != null) {
                    textPs.setString(12, kunde.getVorname());
                } else {
                    textPs.setNull(12, 12);
                }
                if (kunde.getKundennummer() != null) {
                    textPs.setString(13, kunde.getKundennummer());
                } else {
                    textPs.setNull(13, 12);
                }
                if (kunde.getStrasse() != null) {
                    textPs.setString(14, kunde.getStrasse());
                } else {
                    textPs.setNull(14, 12);
                }
                if (kunde.getHausnr() != null) {
                    textPs.setString(15, kunde.getHausnr());
                } else {
                    textPs.setNull(15, 12);
                }
                if (kunde.getLand() != null) {
                    textPs.setString(16, kunde.getLand());
                } else {
                    textPs.setNull(16, 12);
                }
                if (kunde.getPlz() != null) {
                    textPs.setString(17, kunde.getPlz());
                } else {
                    textPs.setNull(17, 12);
                }
                if (kunde.getStadt() != null) {
                    textPs.setString(18, kunde.getStadt());
                } else {
                    textPs.setNull(18, 12);
                }
                if (kunde.getPostfachnr() != null) {
                    textPs.setString(19, kunde.getPostfachnr());
                } else {
                    textPs.setNull(19, 12);
                }
                if (kunde.getTelefonnummer() != null) {
                    textPs.setString(20, kunde.getTelefonnummer());
                } else {
                    textPs.setNull(20, 12);
                }
                if (kunde.getMobilnummer() != null) {
                    textPs.setString(21, kunde.getMobilnummer());
                } else {
                    textPs.setNull(21, 12);
                }
                if (kunde.getFaxnummer() != null) {
                    textPs.setString(22, kunde.getFaxnummer());
                } else {
                    textPs.setNull(22, 12);
                }
                if (kunde.getEmail() != null) {
                    textPs.setString(23, kunde.getEmail());
                } else {
                    textPs.setNull(23, 12);
                }
                if (angebot.getAngebotsName() != null) {
                    textPs.setString(24, angebot.getAngebotsName());
                } else {
                    textPs.setNull(24, 12);
                }
                if (angebot.getBemerkung() != null) {
                    textPs.setString(25, angebot.getBemerkung());
                } else {
                    textPs.setNull(25, 12);
                }
                textPs.setInt(26, angebot.getAngebotsnummer());
                textPs.execute();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "speichereAngebot");
            }
        }
        return angebot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Anfrage speichereKonfiguration(Anfrage anfrage, List addPositions, List updatePositions, List deletePositions) throws SQLException, DatabaseBusyException, ObjectLockedException {
        boolean wasNew;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        ResultSet result = null;
        Konfiguration konfiguration = anfrage.getVorgang().getKonfiguration();
        boolean lastSeenUpdate = anfrage.getVorgang().getVorgangsId() != 0;
        boolean bl = wasNew = konfiguration.getKonfigurationsId() == 0;
        if (wasNew && anfrage.getVorgang().getVorgangsId() == 0) {
            anfrage = VerwaltungDbAccess.speichereVorgang(anfrage);
        }
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.speichereKonfiguration");
            con.setAutoCommit(false);
            String statement = null;
            if (wasNew) {
                statement = SQLStatements.KonfigurationsHelper.instance.GET_NEW_KONFIGURATION_ID();
                textPs = con.prepareStatement(statement);
                result = textPs.executeQuery();
                result.next();
                konfiguration.setKonfigurationsId(result.getInt("id"));
                result.close();
                textPs.close();
                int index = anfrage.getVorgang().getKonfigurationsId().indexOf(new Integer(0));
                anfrage.getVorgang().getKonfigurationsId().set(index, new Integer(konfiguration.getKonfigurationsId()));
                statement = SQLStatements.KonfigurationsHelper.instance.INSERT_KONFIGURATION();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, anfrage.getVorgang().getVorgangsId());
                textPs.setInt(2, konfiguration.getKonfigurationsId());
                textPs.setDouble(3, konfiguration.getAufabschlag());
                if (konfiguration.getKonfigurationsName() != null) {
                    textPs.setString(4, konfiguration.getKonfigurationsName());
                } else {
                    textPs.setNull(4, 12);
                }
                if (konfiguration.getKonfigurationsIdVorlage() != 0) {
                    textPs.setInt(5, konfiguration.getKonfigurationsIdVorlage());
                } else {
                    textPs.setNull(5, 5);
                }
                textPs.execute();
                textPs.close();
                if (!lastSeenUpdate) {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_VORGANG_LAST_KONFIG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, anfrage.getVorgang().getVorgangsId());
                    textPs.setString(2, anfrage.getAnlageNutzerId());
                    textPs.setString(3, anfrage.getFirmaId());
                    textPs.setInt(4, konfiguration.getKonfigurationsId());
                    textPs.setDate(5, new Date(System.currentTimeMillis()));
                    textPs.execute();
                    textPs.close();
                } else {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_VORGANG_LAST_KONFIG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, konfiguration.getKonfigurationsId());
                    textPs.setDate(2, new Date(anfrage.getAenderungsDatum().getTime()));
                    textPs.setInt(3, konfiguration.getVorgangsId());
                    textPs.setString(4, anfrage.getAenderungsNutzerId());
                    textPs.setString(5, anfrage.getFirmaId());
                    textPs.execute();
                    textPs.close();
                }
                statement = SQLStatements.KonfigurationsHelper.instance.INSERT_KONFIGURATION_LASTSEEN();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, konfiguration.getKonfigurationsId());
                textPs.setString(2, anfrage.getAnlageNutzerId());
                textPs.setString(3, anfrage.getFirmaId());
                textPs.setString(4, konfiguration.getLetzteSicht());
                textPs.setDate(5, new Date(System.currentTimeMillis()));
                textPs.execute();
                textPs.close();
            } else {
                statement = SQLStatements.KonfigurationsHelper.instance.UPDATE_KONFIGURATION();
                textPs = con.prepareStatement(statement);
                if (konfiguration.getKonfigurationsName() != null) {
                    textPs.setString(1, konfiguration.getKonfigurationsName());
                } else {
                    textPs.setNull(1, 12);
                }
                if (konfiguration.getAufabschlag() != 0.0) {
                    textPs.setDouble(2, konfiguration.getAufabschlag());
                } else {
                    textPs.setNull(2, 2);
                }
                textPs.setInt(3, konfiguration.getKonfigurationsId());
                textPs.execute();
                textPs.close();
                statement = SQLStatements.KonfigurationsHelper.instance.UPDATE_KONFIGURATION_LASTSEEN();
                textPs = con.prepareStatement(statement);
                textPs.setString(1, konfiguration.getLetzteSicht());
                textPs.setDate(2, new Date(System.currentTimeMillis()));
                textPs.setInt(3, konfiguration.getKonfigurationsId());
                textPs.setString(4, anfrage.getAenderungsNutzerId());
                textPs.setString(5, anfrage.getFirmaId());
                int rows = textPs.executeUpdate();
                textPs.close();
                if (rows == 0) {
                    statement = SQLStatements.KonfigurationsHelper.instance.INSERT_KONFIGURATION_LASTSEEN();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, konfiguration.getKonfigurationsId());
                    textPs.setString(2, anfrage.getAenderungsNutzerId());
                    textPs.setString(3, anfrage.getFirmaId());
                    textPs.setString(4, konfiguration.getLetzteSicht());
                    textPs.setDate(5, new Date(System.currentTimeMillis()));
                    textPs.execute();
                    textPs.close();
                }
                statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_VORGANG_LAST_KONFIG();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, konfiguration.getKonfigurationsId());
                textPs.setDate(2, new Date(anfrage.getAenderungsDatum().getTime()));
                textPs.setInt(3, konfiguration.getVorgangsId());
                textPs.setString(4, anfrage.getAenderungsNutzerId());
                textPs.setString(5, anfrage.getFirmaId());
                rows = textPs.executeUpdate();
                textPs.close();
                if (rows == 0) {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_VORGANG_LAST_KONFIG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, anfrage.getVorgang().getVorgangsId());
                    textPs.setString(2, anfrage.getAenderungsNutzerId());
                    textPs.setString(3, anfrage.getFirmaId());
                    textPs.setInt(4, konfiguration.getKonfigurationsId());
                    textPs.setDate(5, new Date(System.currentTimeMillis()));
                    textPs.execute();
                    textPs.close();
                }
                statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_ANFRAGE_LAST_VORGANG();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, anfrage.getVorgang().getVorgangsId());
                textPs.setDate(2, new Date(anfrage.getAenderungsDatum().getTime()));
                textPs.setInt(3, anfrage.getAnfrageId());
                textPs.setString(4, anfrage.getAenderungsNutzerId());
                textPs.setString(5, anfrage.getFirmaId());
                rows = textPs.executeUpdate();
                textPs.close();
                if (rows == 0) {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_ANFRAGE_LAST_VORGANG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, anfrage.getAnfrageId());
                    if (anfrage.getAnlageNutzerId() != null) {
                        textPs.setString(2, anfrage.getAenderungsNutzerId());
                    } else {
                        textPs.setNull(2, 12);
                    }
                    if (anfrage.getFirmaId() != null) {
                        textPs.setString(3, anfrage.getFirmaId());
                    } else {
                        textPs.setNull(3, 12);
                    }
                    textPs.setInt(4, anfrage.getVorgang().getVorgangsId());
                    textPs.setDate(5, new Date(System.currentTimeMillis()));
                    textPs.execute();
                    textPs.close();
                }
            }
            VerwaltungDbAccess.insertBnbAndVariants(con, konfiguration);
            VerwaltungDbAccess.deletePositions(con, konfiguration, deletePositions);
            VerwaltungDbAccess.insertPositions(con, konfiguration, addPositions, wasNew);
            VerwaltungDbAccess.updatePositions(con, konfiguration, updatePositions, deletePositions);
            con.commit();
            anfrage.getVorgang().setKonfiguration(konfiguration);
        }
        catch (RuntimeException e) {
            log.error("Fehler: ", e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("Fehler: ", e);
            e.printStackTrace();
        }
        finally {
            if (textPs != null) {
                textPs.close();
            }
            if (con != null) {
                con.setAutoCommit(true);
                globs.freeDBConnectionNutzer(con, "speichereKonfiguration");
            }
        }
        return anfrage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertBnbAndVariants(Connection con, Konfiguration konfiguration) throws SQLException {
        String statementKonfBnb = SQLStatements.KonfigurationsHelper.instance.INSERT_KONFIGURATION_BNB();
        String statementKonfVar = SQLStatements.KonfigurationsHelper.instance.INSERT_KONFIGURATION_VARIANTEN();
        int konfigID = konfiguration.getKonfigurationsId();
        StringBuffer sbufBnb = new StringBuffer();
        StringBuffer sbufVar = new StringBuffer();
        ArrayList bnbVarianten = konfiguration.getSelectedBnbsMitVarianten();
        Bnb bnb = null;
        for (int i = 0; i < bnbVarianten.size(); ++i) {
            bnb = (Bnb)bnbVarianten.get(i);
            sbufBnb.append("(");
            sbufBnb.append(konfigID);
            sbufBnb.append(",'");
            sbufBnb.append(StringUtils.maskiereHochkommaFuerDb(bnb.getBildPos()));
            sbufBnb.append("',");
            if (bnb.getElementArt() != null) {
                sbufBnb.append("'");
                sbufBnb.append(StringUtils.maskiereHochkommaFuerDb(bnb.getElementArt()));
                sbufBnb.append("'");
            } else {
                sbufBnb.append("''");
            }
            if (bnb.getSelectedVariante() != null) {
                sbufVar.append("(");
                sbufVar.append(konfigID);
                sbufVar.append(",'");
                sbufVar.append(StringUtils.maskiereHochkommaFuerDb(bnb.getBildPos()));
                sbufVar.append("',");
                sbufVar.append(bnb.getSelectedVariante().getVarianteId());
                sbufVar.append("),");
            }
            sbufBnb.append("),");
        }
        if (sbufBnb != null && sbufBnb.length() > 0) {
            sbufBnb.setCharAt(sbufBnb.lastIndexOf(","), ' ');
            statementKonfBnb = StringUtils.substituteString(statementKonfBnb, "TABELLE", sbufBnb.toString());
            try (PreparedStatement textPs = con.prepareStatement(statementKonfBnb);){
                textPs = con.prepareStatement(statementKonfBnb);
                textPs.execute();
            }
        }
        if (sbufVar != null && sbufVar.length() > 0) {
            sbufVar.setCharAt(sbufVar.lastIndexOf(","), ' ');
            statementKonfVar = StringUtils.substituteString(statementKonfVar, "TABELLE", sbufVar.toString());
            try (PreparedStatement textPs = con.prepareStatement(statementKonfVar);){
                textPs = con.prepareStatement(statementKonfVar);
                textPs.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePositions(Connection con, Konfiguration konfiguration, List deletePositions) throws SQLException {
        String statement = SQLStatements.KonfigurationsHelper.instance.DELETE_KONFIGURATION_POSITION();
        try (PreparedStatement textPs = con.prepareStatement(statement);){
            for (KonfigurationsPosition pos : deletePositions) {
                textPs.setInt(1, konfiguration.getKonfigurationsId());
                textPs.setInt(2, pos.getPos());
                textPs.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePositions(Connection con, Konfiguration konfiguration, List updatePositions, List deletePositions) throws SQLException {
        String statement = SQLStatements.KonfigurationsHelper.instance.UPDATE_KONFIGURATION_POSITION();
        try (PreparedStatement textPs = con.prepareStatement(statement);){
            for (KonfigurationsPosition pos : updatePositions) {
                if (deletePositions.contains(pos)) continue;
                textPs.setString(1, pos.getGruppe());
                if (pos.getElementArt() != null) {
                    textPs.setString(2, pos.getElementArt());
                } else {
                    textPs.setNull(2, 12);
                }
                textPs.setString(3, pos.getStatus());
                textPs.setString(4, pos.getArtikelBenennung());
                textPs.setInt(5, pos.getMenge());
                textPs.setDouble(6, pos.getPreis());
                textPs.setDouble(7, pos.getRabatt());
                if (pos.getBemerkung() != null && !pos.getBemerkung().equals("")) {
                    textPs.setString(8, pos.getBemerkung());
                } else {
                    textPs.setNull(8, 12);
                }
                textPs.setInt(9, konfiguration.getKonfigurationsId());
                textPs.setInt(10, pos.getPos());
                textPs.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertPositions(Connection con, Konfiguration konfiguration, List addPositions, boolean wasNew) throws SQLException {
        String statement = SQLStatements.KonfigurationsHelper.instance.INSERT_KONFIGURATION_POSITIONEN();
        StringBuffer sbuf = new StringBuffer();
        ArrayList positionen = wasNew ? new ArrayList(konfiguration.getPositionen()) : new ArrayList(addPositions);
        KonfigurationsPosition position = null;
        int konfigID = konfiguration.getKonfigurationsId();
        for (int aktPos = 1; aktPos <= positionen.size(); ++aktPos) {
            position = (KonfigurationsPosition)positionen.get(aktPos - 1);
            sbuf.append("(");
            sbuf.append(konfigID);
            sbuf.append(",");
            sbuf.append(position.getPos());
            sbuf.append(",'");
            sbuf.append(StringUtils.maskiereHochkommaFuerDb(position.getGruppe()));
            sbuf.append("',");
            if (position.getElementArt() != null) {
                sbuf.append("'");
                sbuf.append(StringUtils.maskiereHochkommaFuerDb(position.getElementArt()));
                sbuf.append("'");
            } else {
                sbuf.append("NULL");
            }
            sbuf.append(",'");
            sbuf.append(StringUtils.maskiereHochkommaFuerDb(position.getStatus()));
            sbuf.append("','");
            sbuf.append(position.getArt());
            sbuf.append("','");
            sbuf.append(StringUtils.maskiereHochkommaFuerDb(position.getArtikelNummer()));
            sbuf.append("','");
            sbuf.append(StringUtils.maskiereHochkommaFuerDb(position.getArtikelBenennung()));
            sbuf.append("',");
            sbuf.append(position.getMenge());
            sbuf.append(",");
            sbuf.append(position.getPreis());
            sbuf.append(",");
            if (position.getRabatt() != 0.0) {
                sbuf.append(position.getRabatt());
            } else {
                sbuf.append("NULL");
            }
            sbuf.append(",");
            sbuf.append(position.getMwstSatz());
            sbuf.append(",");
            sbuf.append(position.getMwStBetrag());
            sbuf.append(",");
            if (position.getBemerkung() != null) {
                sbuf.append("'");
                sbuf.append(position.getBemerkung());
                sbuf.append("'");
            } else {
                sbuf.append("NULL");
            }
            sbuf.append("),");
        }
        if (sbuf != null && sbuf.length() > 0) {
            sbuf.setCharAt(sbuf.lastIndexOf(","), ' ');
            statement = StringUtils.substituteString(statement, "TABELLE", sbuf.toString());
            try (PreparedStatement textPs = con.prepareStatement(statement);){
                textPs = con.prepareStatement(statement);
                textPs.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Anfrage speichereVorgang(Anfrage anfrage) throws SQLException, DatabaseBusyException, ObjectLockedException {
        boolean updateLastSeen;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        ResultSet result = null;
        Vorgang vorgang = anfrage.getVorgang();
        boolean bl = updateLastSeen = anfrage.getAnfrageId() != 0;
        if (vorgang.getVorgangsId() == 0 && anfrage.getAnfrageId() == 0) {
            anfrage = VerwaltungDbAccess.speichereAnfrage(anfrage);
        }
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.speichereVorgang");
            String statement = null;
            if (vorgang.getVorgangsId() == 0) {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.GET_NEW_VORGANG_ID();
                textPs = con.prepareStatement(statement);
                result = textPs.executeQuery();
                result.next();
                vorgang.setVorgangsId(result.getInt("id"));
                result.close();
                textPs.close();
                int index = anfrage.getVorgangsId().indexOf(new Integer(0));
                anfrage.getVorgangsId().set(index, new Integer(vorgang.getVorgangsId()));
                statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_VORGANG();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, anfrage.getAnfrageId());
                textPs.setInt(2, vorgang.getVorgangsId());
                textPs.setString(3, vorgang.getBtNummer());
                if (vorgang.getBildPos() != null) {
                    textPs.setString(4, vorgang.getBildPos());
                } else {
                    textPs.setNull(4, 1);
                }
                textPs.setString(5, vorgang.getProduktName());
                textPs.setInt(6, Integer.parseInt(sdf.format(vorgang.getAnlageDatum())));
                if (vorgang.getAenderungDatum() != null) {
                    textPs.setInt(7, Integer.parseInt(sdf.format(vorgang.getAenderungDatum())));
                } else {
                    textPs.setNull(7, 5);
                }
                if (vorgang.getHkId() > Integer.MIN_VALUE) {
                    textPs.setInt(8, vorgang.getHkId());
                } else {
                    textPs.setNull(8, 4);
                }
                if (vorgang.getUkId() > Integer.MIN_VALUE) {
                    textPs.setInt(9, vorgang.getUkId());
                } else {
                    textPs.setNull(9, 4);
                }
                textPs.execute();
                textPs.close();
                if (!updateLastSeen) {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_ANFRAGE_LAST_VORGANG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, anfrage.getAnfrageId());
                    if (anfrage.getAnlageNutzerId() != null) {
                        textPs.setString(2, anfrage.getAnlageNutzerId());
                    } else {
                        textPs.setNull(2, 12);
                    }
                    if (anfrage.getFirmaId() != null) {
                        textPs.setString(3, anfrage.getFirmaId());
                    } else {
                        textPs.setNull(3, 12);
                    }
                    textPs.setInt(4, vorgang.getVorgangsId());
                    textPs.setDate(5, new Date(System.currentTimeMillis()));
                    textPs.execute();
                    textPs.close();
                } else {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_ANFRAGE_LAST_VORGANG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, vorgang.getVorgangsId());
                    textPs.setDate(2, new Date(anfrage.getAenderungsDatum().getTime()));
                    textPs.setInt(3, anfrage.getAnfrageId());
                    if (anfrage.getAenderungsNutzerId() != null) {
                        textPs.setString(4, anfrage.getAenderungsNutzerId());
                    } else {
                        textPs.setNull(4, 12);
                    }
                    if (anfrage.getFirmaId() != null) {
                        textPs.setString(5, anfrage.getFirmaId());
                    } else {
                        textPs.setNull(5, 12);
                    }
                    int rows = textPs.executeUpdate();
                    textPs.close();
                    if (rows == 0) {
                        statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_ANFRAGE_LAST_VORGANG();
                        textPs = con.prepareStatement(statement);
                        textPs.setInt(1, anfrage.getAnfrageId());
                        if (anfrage.getAnlageNutzerId() != null) {
                            textPs.setString(2, anfrage.getAnlageNutzerId());
                        } else {
                            textPs.setNull(2, 12);
                        }
                        if (anfrage.getFirmaId() != null) {
                            textPs.setString(3, anfrage.getFirmaId());
                        } else {
                            textPs.setNull(3, 12);
                        }
                        textPs.setInt(4, vorgang.getVorgangsId());
                        textPs.setDate(5, new Date(System.currentTimeMillis()));
                        textPs.execute();
                        textPs.close();
                    }
                }
            } else {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_VORGANG();
                textPs = con.prepareStatement(statement);
                textPs.setString(1, vorgang.getBtNummer());
                if (vorgang.getBildPos() != null) {
                    textPs.setString(2, vorgang.getBildPos());
                } else {
                    textPs.setNull(2, 1);
                }
                textPs.setString(3, vorgang.getProduktName());
                textPs.setString(4, sdf.format(vorgang.getAnlageDatum()));
                if (vorgang.getAenderungDatum() != null) {
                    textPs.setString(5, sdf.format(vorgang.getAenderungDatum()));
                } else {
                    textPs.setNull(5, 12);
                }
                if (vorgang.getHkId() > Integer.MIN_VALUE) {
                    textPs.setInt(6, vorgang.getHkId());
                } else {
                    textPs.setNull(6, 4);
                }
                if (vorgang.getUkId() > Integer.MIN_VALUE) {
                    textPs.setInt(7, vorgang.getUkId());
                } else {
                    textPs.setNull(7, 4);
                }
                textPs.setInt(8, vorgang.getVorgangsId());
                textPs.execute();
                textPs.close();
                if (vorgang.getFahrzeug() != null) {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_VORGANG_FAHRZEUG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, vorgang.getVorgangsId());
                    textPs.execute();
                    textPs.close();
                }
            }
            Fahrzeug fahrzeug = vorgang.getFahrzeug();
            if (fahrzeug != null) {
                statement = SQLStatements.Verwaltung.instance.INSERT_VORGANG_BEDINGUNGEN();
                StringBuffer buf = new StringBuffer();
                Bedingungsmenge menge = fahrzeug.getBedingungsMenge();
                Enumeration<Long> beds = menge.getBedingungen();
                while (beds.hasMoreElements()) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    Long id = beds.nextElement();
                    String bedWert = menge.getBedWert(id);
                    String bedName = menge.getBedNamen(id);
                    buf.append("(");
                    buf.append(vorgang.getVorgangsId()).append(",");
                    buf.append("'").append(id).append("',");
                    buf.append("'").append(StringUtils.maskiereHochkommaFuerDb(bedName)).append("',");
                    buf.append("'").append(StringUtils.maskiereHochkommaFuerDb(bedWert)).append("')");
                }
                if (buf.length() > 0) {
                    statement = StringUtils.substituteString(statement, "TABELLE", buf.toString());
                    textPs = con.prepareStatement(statement);
                    textPs.execute();
                }
                statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_VORGANG_FAHRZEUG();
                StringBuffer sbuf = new StringBuffer();
                int vorgangsID = vorgang.getVorgangsId();
                if (fahrzeug.getMarke() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'MARKE_TPS','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getMarke()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getProduktArt() != ' ' && fahrzeug.getProduktArt() != '\u0000') {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'PRODUKTART','");
                    sbuf.append(fahrzeug.getProduktArt());
                    sbuf.append("'),");
                }
                if (fahrzeug.getVbereich() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'VBEREICH','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getVbereich()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getBauArt() != ' ' && fahrzeug.getBauArt() != '\u0000') {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'BAUART','");
                    sbuf.append(fahrzeug.getBauArt());
                    sbuf.append("'),");
                }
                if (fahrzeug.getBaureihe() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'BAUREIHE','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getBaureihe()));
                    sbuf.append("'),");
                } else {
                    log.error("NO BAUREIHE SET FOR vorgang:" + vorgang.getVorgangsId() + ". This will result in an error during load");
                }
                if (fahrzeug.getKarosserie() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'KAROSSERIE','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getKarosserie()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getModell() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'VBEZ','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getModell()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getModellBezeichnung() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'VBEZERW','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getModellBezeichnung()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getMotor() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'MOTOR','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getMotor()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getKatalogausf() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'KTLGAUSF','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getKatalogausf()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getLenkung() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'LENKUNG','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getLenkung()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getGetriebe() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'GETRIEBE','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getGetriebe()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getFahrgestellnummer() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'FGSTNR','");
                    sbuf.append(StringUtils.maskiereHochkommaFuerDb(fahrzeug.getFahrgestellnummer()));
                    sbuf.append("'),");
                }
                if (fahrzeug.getBaujahr() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'BAUJAHR','");
                    sbuf.append(fahrzeug.getBaujahr());
                    sbuf.append("'),");
                }
                if (fahrzeug.getZulassungsmonat() != null) {
                    sbuf.append("(");
                    sbuf.append(vorgangsID);
                    sbuf.append(",'BAUMONAT','");
                    sbuf.append(fahrzeug.getZulassungsmonat());
                    sbuf.append("'),");
                }
                sbuf.setCharAt(sbuf.lastIndexOf(","), ' ');
                statement = StringUtils.substituteString(statement, "TABELLE", sbuf.toString());
                textPs = con.prepareStatement(statement);
                textPs.execute();
            }
            anfrage.setVorgang(vorgang);
        }
        finally {
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "speichereVorgang");
            }
        }
        return anfrage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Anfrage speichereAnfrage(Anfrage anfrage) throws SQLException, DatabaseBusyException, ObjectLockedException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.speichereAnfrage");
            String statement = null;
            if (anfrage.getAnfrageId() == 0) {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.GET_NEW_ANFRAGE_ID();
                textPs = con.prepareStatement(statement);
                result = textPs.executeQuery();
                result.next();
                anfrage.setAnfrageId(result.getInt("id"));
                result.close();
                statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_ANFRAGE();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, anfrage.getAnfrageId());
                textPs.setString(2, anfrage.getMarke());
                textPs.setString(3, Character.toString(anfrage.getProduktArt()));
                textPs.setString(4, anfrage.getAnfrageName());
                textPs.setInt(5, Integer.parseInt(sdf.format(anfrage.getAnlageDatum())));
                if (anfrage.getAnlageNutzerId() != null) {
                    textPs.setString(6, anfrage.getAnlageNutzerId());
                } else {
                    textPs.setNull(6, 12);
                }
                if (anfrage.getAenderungsDatum() != null) {
                    textPs.setInt(7, Integer.parseInt(sdf.format(anfrage.getAenderungsDatum())));
                } else {
                    textPs.setNull(7, 4);
                }
                if (anfrage.getAnlageNutzerId() != null) {
                    textPs.setString(8, anfrage.getAnlageNutzerId());
                } else {
                    textPs.setNull(8, 12);
                }
                textPs.setString(9, anfrage.getFirmaId());
                textPs.setString(10, anfrage.getFilialId());
                if (anfrage.getGesperrtVonId() != null) {
                    textPs.setString(11, anfrage.getGesperrtVonId());
                } else {
                    textPs.setNull(11, 12);
                }
                textPs.execute();
                textPs.close();
                if (anfrage.isExplizitGespeichert()) {
                    VerwaltungDbAccess.insertAnfrageInfos(con, anfrage);
                }
            } else {
                VerwaltungDbAccess.sperreAnfrage(new Integer(anfrage.getAnfrageId()), anfrage.getAnlageNutzerId());
                statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_ANFRAGE();
                textPs = con.prepareStatement(statement);
                textPs.setString(1, anfrage.getAnfrageName());
                textPs.setInt(2, Integer.parseInt(sdf.format(anfrage.getAenderungsDatum())));
                textPs.setString(3, anfrage.getAenderungsNutzerId());
                textPs.setInt(4, anfrage.getAnfrageId());
                textPs.execute();
                textPs.close();
                if (anfrage.isExplizitGespeichert()) {
                    VerwaltungDbAccess.updateAnfrageInfos(con, anfrage);
                }
                VerwaltungDbAccess.updateAnfrageInfos(con, anfrage);
                if (anfrage.getVorgang() != null && anfrage.getVorgang().getVorgangsId() != 0) {
                    statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_ANFRAGE_LAST_VORGANG();
                    textPs = con.prepareStatement(statement);
                    textPs.setInt(1, anfrage.getVorgang().getVorgangsId());
                    textPs.setDate(2, new Date(System.currentTimeMillis()));
                    textPs.setInt(3, anfrage.getAnfrageId());
                    textPs.setString(4, anfrage.getAenderungsNutzerId());
                    textPs.setString(5, anfrage.getFirmaId());
                    int rows = textPs.executeUpdate();
                    if (rows == 0) {
                        statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_ANFRAGE_LAST_VORGANG();
                        textPs = con.prepareStatement(statement);
                        textPs.setInt(1, anfrage.getAnfrageId());
                        if (anfrage.getAnlageNutzerId() != null) {
                            textPs.setString(2, anfrage.getAnlageNutzerId());
                        } else {
                            textPs.setNull(2, 12);
                        }
                        if (anfrage.getFirmaId() != null) {
                            textPs.setString(3, anfrage.getFirmaId());
                        } else {
                            textPs.setNull(3, 12);
                        }
                        textPs.setInt(4, anfrage.getVorgang().getVorgangsId());
                        textPs.setDate(5, new Date(System.currentTimeMillis()));
                        textPs.execute();
                        textPs.close();
                    }
                }
            }
            Anfrage anfrage2 = anfrage;
            return anfrage2;
        }
        finally {
            if (textPs != null) {
                textPs.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "speichereAnfrage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAnfrageInfos(Connection con, Anfrage anfrage) throws SQLException {
        String statement = null;
        try (Statement textPs = null;){
            statement = SQLStatements.AnfrageVorgangsHelper.instance.ERMITTLE_ANZAHL_ANFRAGE_INFOS();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, anfrage.getAnfrageId());
            ResultSet rset = textPs.executeQuery();
            int anzahl = 0;
            if (rset.next()) {
                anzahl = rset.getInt("cnt");
            }
            if (anzahl == 0) {
                VerwaltungDbAccess.insertAnfrageInfos(con, anfrage);
                return;
            }
        }
        try {
            statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_ANFRAGE_INFOS();
            textPs = con.prepareStatement(statement);
            if (anfrage.getKunde() == null) {
                anfrage.setKunde(new Kunde(null));
                log.error("no object of type Kunde found.");
            }
            if (anfrage.getKunde().getKundenId() != 0) {
                textPs.setInt(1, anfrage.getKunde().getKundenId());
            } else {
                textPs.setNull(1, 4);
            }
            if (anfrage.getKunde().getAnrede() != null) {
                textPs.setString(2, anfrage.getKunde().getAnrede());
            } else {
                textPs.setNull(2, 12);
            }
            if (anfrage.getKunde().getName() != null) {
                textPs.setString(3, anfrage.getKunde().getName());
            } else {
                textPs.setNull(3, 12);
            }
            if (anfrage.getKunde().getVorname() != null) {
                textPs.setString(4, anfrage.getKunde().getVorname());
            } else {
                textPs.setNull(4, 12);
            }
            if (anfrage.getKunde().getKundennummer() != null) {
                textPs.setString(5, anfrage.getKunde().getKundennummer());
            } else {
                textPs.setNull(5, 12);
            }
            if (anfrage.getKunde().getStrasse() != null) {
                textPs.setString(6, anfrage.getKunde().getStrasse());
            } else {
                textPs.setNull(6, 12);
            }
            if (anfrage.getKunde().getHausnr() != null) {
                textPs.setString(7, anfrage.getKunde().getHausnr());
            } else {
                textPs.setNull(7, 12);
            }
            if (anfrage.getKunde().getLand() != null) {
                textPs.setString(8, anfrage.getKunde().getLand());
            } else {
                textPs.setNull(8, 12);
            }
            if (anfrage.getKunde().getPlz() != null) {
                textPs.setString(9, anfrage.getKunde().getPlz());
            } else {
                textPs.setNull(9, 12);
            }
            if (anfrage.getKunde().getStadt() != null) {
                textPs.setString(10, anfrage.getKunde().getStadt());
            } else {
                textPs.setNull(10, 12);
            }
            if (anfrage.getKunde().getPostfachnr() != null) {
                textPs.setString(11, anfrage.getKunde().getPostfachnr());
            } else {
                textPs.setNull(11, 12);
            }
            if (anfrage.getKunde().getTelefonnummer() != null) {
                textPs.setString(12, anfrage.getKunde().getTelefonnummer());
            } else {
                textPs.setNull(12, 12);
            }
            if (anfrage.getKunde().getMobilnummer() != null) {
                textPs.setString(13, anfrage.getKunde().getMobilnummer());
            } else {
                textPs.setNull(13, 12);
            }
            if (anfrage.getKunde().getFaxnummer() != null) {
                textPs.setString(14, anfrage.getKunde().getFaxnummer());
            } else {
                textPs.setNull(14, 12);
            }
            if (anfrage.getKunde().getEmail() != null) {
                textPs.setString(15, anfrage.getKunde().getEmail());
            } else {
                textPs.setNull(15, 12);
            }
            if (anfrage.getBemerkung() != null) {
                textPs.setString(16, anfrage.getBemerkung());
            } else {
                textPs.setNull(16, 12);
            }
            if (anfrage.getStichworte() != null) {
                textPs.setString(17, anfrage.getStichworte());
            } else {
                textPs.setNull(17, 12);
            }
            textPs.setInt(18, anfrage.getAnfrageId());
            textPs.execute();
        }
        finally {
            if (textPs != null) {
                textPs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertAnfrageInfos(Connection con, Anfrage anfrage) throws SQLException {
        String statement = null;
        try (Statement textPs = null;){
            statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_ANFRAGE_INFOS();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, anfrage.getAnfrageId());
            if (anfrage.getKunde() == null) {
                anfrage.setKunde(new Kunde());
                log.error("no object of type Kunde found.");
            }
            if (anfrage.getKunde().getKundenId() != 0) {
                textPs.setInt(2, anfrage.getKunde().getKundenId());
            } else {
                textPs.setNull(2, 4);
            }
            if (anfrage.getKunde().getAnrede() != null) {
                textPs.setString(3, anfrage.getKunde().getAnrede());
            } else {
                textPs.setNull(3, 12);
            }
            if (anfrage.getKunde().getName() != null) {
                textPs.setString(4, anfrage.getKunde().getName());
            } else {
                textPs.setNull(4, 12);
            }
            if (anfrage.getKunde().getVorname() != null) {
                textPs.setString(5, anfrage.getKunde().getVorname());
            } else {
                textPs.setNull(5, 12);
            }
            if (anfrage.getKunde().getKundennummer() != null) {
                textPs.setString(6, anfrage.getKunde().getKundennummer());
            } else {
                textPs.setNull(6, 12);
            }
            if (anfrage.getKunde().getStrasse() != null) {
                textPs.setString(7, anfrage.getKunde().getStrasse());
            } else {
                textPs.setNull(7, 12);
            }
            if (anfrage.getKunde().getHausnr() != null) {
                textPs.setString(8, anfrage.getKunde().getHausnr());
            } else {
                textPs.setNull(8, 12);
            }
            if (anfrage.getKunde().getLand() != null) {
                textPs.setString(9, anfrage.getKunde().getLand());
            } else {
                textPs.setNull(9, 12);
            }
            if (anfrage.getKunde().getPlz() != null) {
                textPs.setString(10, anfrage.getKunde().getPlz());
            } else {
                textPs.setNull(10, 12);
            }
            if (anfrage.getKunde().getStadt() != null) {
                textPs.setString(11, anfrage.getKunde().getStadt());
            } else {
                textPs.setNull(11, 12);
            }
            if (anfrage.getKunde().getPostfachnr() != null) {
                textPs.setString(12, anfrage.getKunde().getPostfachnr());
            } else {
                textPs.setNull(12, 12);
            }
            if (anfrage.getKunde().getTelefonnummer() != null) {
                textPs.setString(13, anfrage.getKunde().getTelefonnummer());
            } else {
                textPs.setNull(13, 12);
            }
            if (anfrage.getKunde().getMobilnummer() != null) {
                textPs.setString(14, anfrage.getKunde().getMobilnummer());
            } else {
                textPs.setNull(14, 12);
            }
            if (anfrage.getKunde().getFaxnummer() != null) {
                textPs.setString(15, anfrage.getKunde().getFaxnummer());
            } else {
                textPs.setNull(15, 12);
            }
            if (anfrage.getKunde().getEmail() != null) {
                textPs.setString(16, anfrage.getKunde().getEmail());
            } else {
                textPs.setNull(16, 12);
            }
            if (anfrage.getBemerkung() != null) {
                textPs.setString(17, anfrage.getBemerkung());
            } else {
                textPs.setNull(17, 12);
            }
            if (anfrage.getStichworte() != null) {
                textPs.setString(18, anfrage.getStichworte());
            } else {
                textPs.setNull(18, 12);
            }
            textPs.execute();
            textPs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kunde speichereKunde(Kunde kunde) throws SQLException, DatabaseBusyException, DuplicateValueException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.speichereKunde");
            String statement = null;
            if (kunde.getKundenId() == 0) {
                statement = SQLStatements.Verwaltung.instance.GET_NEW_KUNDE_ID();
                textPs = con.prepareStatement(statement);
                result = textPs.executeQuery();
                result.next();
                kunde.setKundenId(result.getInt("id"));
                result.close();
                statement = SQLStatements.Verwaltung.instance.INSERT_KUNDE();
            } else {
                statement = SQLStatements.Verwaltung.instance.UPDATE_KUNDE();
            }
            if (kunde.getKundennummer() != null && kunde.getKundennummer().length() > 0) {
                String sql = SQLStatements.Verwaltung.instance.PRUEFE_KUNDENNUMMER();
                textPs = con.prepareStatement(sql);
                textPs.setString(1, kunde.getKundennummer());
                textPs.setInt(2, kunde.getKundenId());
                result = textPs.executeQuery();
                result.next();
                if (result.getInt(1) > 0) {
                    throw new DuplicateValueException("Die Kundennummer ist bereits vergeben!");
                }
            }
            textPs = con.prepareStatement(statement);
            textPs.setInt(17, kunde.getKundenId());
            textPs.setString(2, kunde.getName());
            if (kunde.getAnrede() != null) {
                textPs.setString(1, kunde.getAnrede());
            } else {
                textPs.setNull(1, 12);
            }
            if (kunde.getVorname() != null) {
                textPs.setString(3, kunde.getVorname());
            } else {
                textPs.setNull(3, 12);
            }
            if (kunde.getKundennummer() != null) {
                textPs.setString(4, kunde.getKundennummer());
            } else {
                textPs.setNull(4, 12);
            }
            if (kunde.getStrasse() != null) {
                textPs.setString(5, kunde.getStrasse());
            } else {
                textPs.setNull(5, 12);
            }
            if (kunde.getHausnr() != null) {
                textPs.setString(6, kunde.getHausnr());
            } else {
                textPs.setNull(6, 12);
            }
            if (kunde.getLand() != null) {
                textPs.setString(7, kunde.getLand());
            } else {
                textPs.setNull(7, 12);
            }
            if (kunde.getPlz() != null) {
                textPs.setString(8, kunde.getPlz());
            } else {
                textPs.setNull(8, 12);
            }
            if (kunde.getStadt() != null) {
                textPs.setString(9, kunde.getStadt());
            } else {
                textPs.setNull(9, 12);
            }
            if (kunde.getPostfachnr() != null) {
                textPs.setString(10, kunde.getPostfachnr());
            } else {
                textPs.setNull(10, 12);
            }
            if (kunde.getTelefonnummer() != null) {
                textPs.setString(11, kunde.getTelefonnummer());
            } else {
                textPs.setNull(11, 12);
            }
            if (kunde.getMobilnummer() != null) {
                textPs.setString(12, kunde.getMobilnummer());
            } else {
                textPs.setNull(12, 12);
            }
            if (kunde.getFaxnummer() != null) {
                textPs.setString(13, kunde.getFaxnummer());
            } else {
                textPs.setNull(13, 12);
            }
            if (kunde.getEmail() != null) {
                textPs.setString(14, kunde.getEmail());
            } else {
                textPs.setNull(14, 12);
            }
            if (kunde.getBemerkung() != null) {
                textPs.setString(15, kunde.getBemerkung());
            } else {
                textPs.setNull(15, 12);
            }
            if (kunde.getGeburtsDatum() != null) {
                textPs.setInt(16, Integer.parseInt(sdf.format(kunde.getGeburtsDatum())));
            } else {
                textPs.setNull(16, 5);
            }
            textPs.execute();
        }
        finally {
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "speichereKunde");
            }
        }
        return kunde;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void speichereKundenfahrzeug(int kundenId, Fahrzeug fahrzeug) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        if (fahrzeug == null) {
            log.error("No Fahrzeug to add");
            return;
        }
        if (fahrzeug.getFahrgestellnummer() == null) {
            log.error("The Fahrzeug to be added does not have a VIN");
            return;
        }
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.speichereKundenfahrzeug");
            String statement = SQLStatements.Verwaltung.instance.INSERT_FAHRZEUG();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, kundenId);
            textPs.setString(2, fahrzeug.getFahrgestellnummer());
            if (fahrzeug.getKennzeichen() != null) {
                textPs.setString(3, fahrzeug.getKennzeichen());
            } else {
                textPs.setNull(3, 12);
            }
            textPs.execute();
        }
        finally {
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "speichereKundenfahrzeug");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loescheAnfrage(int anfrageId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.loescheAnfrage");
            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_ANFRAGEN_VORGAENGE();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, anfrageId);
            ArrayList<Integer> vorgaenge = new ArrayList<Integer>();
            ResultSet rs = textPs.executeQuery();
            while (rs.next()) {
                vorgaenge.add(new Integer(rs.getInt("id")));
            }
            rs.close();
            textPs.close();
            boolean loeschbar = true;
            Iterator it = vorgaenge.iterator();
            while (it.hasNext()) {
                int vorgang = (Integer)it.next();
                loeschbar = loeschbar && VerwaltungDbAccess.loescheVorgang(vorgang);
            }
            if (loeschbar) {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_ANFRAGE_VORGANG_LASTSEEN();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, anfrageId);
                textPs.execute();
                textPs.close();
                statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_ANFRAGE_INFOS();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, anfrageId);
                textPs.execute();
                textPs.close();
                statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_ANFRAGE();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, anfrageId);
                textPs.execute();
                textPs.close();
            }
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
            }
            if (textPs != null) {
                textPs.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loescheAnfrage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loescheVorgang(int vorgangsId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.loescheVorgang");
            con.setAutoCommit(false);
            String statement = SQLStatements.AnfrageVorgangsHelper.instance.LOAD_VORGANGS_KONFIGURATIONEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgangsId);
            ArrayList<Integer> konfigurationen = new ArrayList<Integer>();
            ResultSet rs = textPs.executeQuery();
            while (rs.next()) {
                konfigurationen.add(new Integer(rs.getInt("id")));
            }
            rs.close();
            textPs.close();
            boolean loeschbar = true;
            Iterator it = konfigurationen.iterator();
            while (it.hasNext()) {
                int konfiguration = (Integer)it.next();
                VerwaltungDbAccess.loescheKonfiguration(konfiguration);
            }
            statement = SQLStatements.AnfrageVorgangsHelper.instance.ERMITTLE_ANZAHL_KONFIG_ANGEBOTE_ZU_VORGANG();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, vorgangsId);
            rs = textPs.executeQuery();
            int numberOfAngebote = 0;
            if (rs.next()) {
                numberOfAngebote = rs.getInt("anzahl");
            }
            if (numberOfAngebote > 0) {
                loeschbar = false;
            }
            if (loeschbar) {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_VORGANG_LASTSEEN();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, vorgangsId);
                textPs.execute();
                textPs.close();
                statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_VORGANG_FAHRZEUG();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, vorgangsId);
                textPs.execute();
                textPs.close();
                statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_VORGANG_BEDINGUNGEN();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, vorgangsId);
                textPs.execute();
                textPs.close();
                statement = SQLStatements.AnfrageVorgangsHelper.instance.DELETE_VORGANG();
                textPs = con.prepareStatement(statement);
                textPs.setInt(1, vorgangsId);
                textPs.execute();
                textPs.close();
            }
            con.commit();
            boolean bl = loeschbar;
            return bl;
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
            }
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loescheVorgang");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loescheKonfiguration(int konfigurationsId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.loescheKonfiguration");
            con.setAutoCommit(false);
            String statement = SQLStatements.KonfigurationsHelper.instance.DELETE_KONFIGURATION_ANGEBOT();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.KonfigurationsHelper.instance.DELETE_KONFIGURATION_BNB_VARIANTEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.KonfigurationsHelper.instance.DELETE_KONFIGURATION_BNB();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.KonfigurationsHelper.instance.DELETE_KONFIGURATION_POSITIONEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.KonfigurationsHelper.instance.DELETE_KONFIGURATION_LASTSEEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.KonfigurationsHelper.instance.UPDATE_KONFIG_VORLAGE();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.KonfigurationsHelper.instance.DELETE_VORGANG_LASTSEEN();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.KonfigurationsHelper.instance.DELETE_KONFIGURATION();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigurationsId);
            textPs.execute();
            textPs.close();
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
            }
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loescheKonfiguration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loescheKunde(int kundenId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.loescheKunde");
            con.setAutoCommit(false);
            String statement = SQLStatements.Verwaltung.instance.DELETE_KUNDE_FAHRZEUGE();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, kundenId);
            textPs.execute();
            textPs.close();
            statement = SQLStatements.Verwaltung.instance.DELETE_KUNDE();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, kundenId);
            textPs.execute();
            textPs.close();
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
            }
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loescheKunde");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loescheKundenfahrzeug(int kundenId, String vin) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement textPs = null;
        try {
            con = globs.getDBConnectionNutzer("zub.verwaltung.AdminToolDbAccess.loescheKundenfahrzeug");
            String statement = SQLStatements.Verwaltung.instance.DELETE_FAHRZEUG();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, kundenId);
            textPs.setString(2, vin);
            textPs.execute();
        }
        finally {
            textPs.close();
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loescheKundenfahrzeug");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MarktIpac> ladeMarktListe(String iso, String regIso) throws SQLException, DatabaseBusyException {
        ArrayList<MarktIpac> arrayList;
        Connection con;
        ServerGlobalObjects globs;
        block10: {
            Statement textPs;
            block9: {
                globs = ServerGlobalObjects.getInstance();
                log.debug("Now Accessing Database");
                con = null;
                textPs = null;
                ResultSet result = null;
                PreparedStatement ps = null;
                ArrayList<MarktIpac> marktListe = new ArrayList<MarktIpac>();
                try {
                    con = globs.getDBConnection("ladeMarktListe");
                    ps = con.prepareStatement(SQLStatements.Listenfueller.instance.LOAD_MAERKTEAUSWAHL());
                    ps.setString(1, iso == null ? " " : iso);
                    ps.setString(2, regIso == null ? " " : regIso);
                    result = ps.executeQuery();
                    while (result.next()) {
                        int marktId = result.getInt(1);
                        String name = result.getString(2);
                        String kuerzel = result.getString(3);
                        String produktart = result.getString(4);
                        String lkz = result.getString(5);
                        String ISOkz = result.getString(6);
                        MarktIpac markt = new MarktIpac(marktId, name, kuerzel);
                        Collection<String> produkte = Produkte.mapProdukt(produktart);
                        markt.setProdukte(produkte);
                        markt.setLkz(lkz);
                        markt.setmISOkz(ISOkz);
                        marktListe.add(markt);
                    }
                    arrayList = marktListe;
                    if (result == null) break block9;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        WebetkUtils.closeQuery(result);
                    } else if (textPs != null) {
                        textPs.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "ladeMarktListe");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(result);
                break block10;
            }
            if (textPs != null) {
                textPs.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "ladeMarktListe");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NutzerZub ladeUserDaten(String userId, String firmaId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("ladeUserDaten");
            ps = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_NUTZER_INFO());
            ps.setString(1, userId);
            ps.setString(2, firmaId);
            result = ps.executeQuery();
            if (result.next()) {
                String userName = result.getString("userName");
                String realName = result.getString("realName");
                String telefon = result.getString("telefon");
                String email = result.getString("email");
                String filialId = result.getString("filialId");
                String filialName = result.getString("filialName");
                Integer markt = null;
                int marktId = result.getInt("marktId");
                if (!result.wasNull()) {
                    markt = new Integer(marktId);
                }
                Integer bearbeiter = null;
                int bearbeiterNr = result.getInt("bearbeiterNr");
                if (!result.wasNull()) {
                    bearbeiter = new Integer(bearbeiterNr);
                }
                String isoCode = result.getString("iso");
                String regIso = result.getString("regIso");
                NutzerZub user = new NutzerZub(firmaId, userId, userName, filialId, bearbeiter == null ? null : String.valueOf(bearbeiter));
                user.setEmail(email);
                user.setMarktId(markt);
                user.setRealName(realName);
                user.setTelefon(telefon);
                user.setIso(isoCode);
                user.setRegIso(regIso);
                user.setDefaultFilialeBezeichnung(filialName);
                NutzerZub nutzerZub = user;
                return nutzerZub;
            }
            NutzerZub nutzerZub = null;
            return nutzerZub;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "ladeUserDaten");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ladeFilialDaten(String firmaId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        String firmaBez = null;
        try {
            con = globs.getDBConnectionNutzer("ermittleFilialInfo");
            ps = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_FIRMA_BEZ());
            ps.setString(1, firmaId);
            result = ps.executeQuery();
            while (result.next()) {
                firmaBez = result.getString("bez");
            }
            ArrayList<FilialeZub> filialListe = new ArrayList<FilialeZub>();
            ps = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_FILIAL_LISTE());
            ps.setString(1, firmaId);
            result = ps.executeQuery();
            while (result.next()) {
                String filialId = result.getString("filialId");
                String bezeichnung = result.getString("bez");
                String iso = result.getString("iso");
                String regIso = result.getString("regIso");
                String strasse = result.getString("strasse");
                String plz = result.getString("plz");
                String ort = result.getString("ort");
                String telefon = result.getString("telefon");
                String fax = result.getString("fax");
                String email = result.getString("email");
                Integer markt = null;
                int marktId = result.getInt("markt");
                if (!result.wasNull()) {
                    markt = new Integer(marktId);
                }
                boolean speichern = false;
                String speicherKz = result.getString("speicherKz");
                speichern = speicherKz != null ? speicherKz.equalsIgnoreCase("J") : VerwaltungDbAccess.ermittleDefaultSpeicherKz(marktId);
                boolean verfuegbar = false;
                String verfuegbarKz = result.getString("verfuegbarKz");
                if (verfuegbarKz != null) {
                    verfuegbar = verfuegbarKz.equalsIgnoreCase("J");
                }
                FilialeZub filiale = new FilialeZub(filialId, bezeichnung, firmaId, iso, regIso);
                filiale.setBezeichnungFirma(firmaBez);
                filiale.setEmail(email);
                filiale.setFax(fax);
                filiale.setMarktId(markt);
                filiale.setOrt(ort);
                filiale.setPlz(plz);
                filiale.setPruefVerfuegbarkeit(verfuegbar);
                filiale.setSpeicherKunde(speichern);
                filiale.setStrasse(strasse);
                filiale.setTelefon(telefon);
                filialListe.add(filiale);
            }
            ArrayList<FilialeZub> arrayList = filialListe;
            return arrayList;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "ermittleFilialInfo");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ermittleDefaultSpeicherKz(int marktId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnection("ermittleDefaultSpeicherKz");
            stat = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_MARKT_SPEZIFIKA());
            stat.setInt(1, marktId);
            rs = stat.executeQuery();
            boolean speichern = false;
            String sVerfuegbar = null;
            if (rs.next()) {
                sVerfuegbar = rs.getString("kundendaten");
            }
            if (sVerfuegbar != null && sVerfuegbar.trim().length() > 0) {
                speichern = sVerfuegbar.equalsIgnoreCase("J");
            }
            boolean bl = speichern;
            return bl;
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "ermittleDefaultSpeicherKz");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AufwandsKonfiguration ladeAWKonfiguration(String firmaId, String filialId, String marke, String produktArt, int marktId, String iso, String regIso) throws SQLException, DatabaseBusyException {
        AufwandsKonfiguration konfig = new AufwandsKonfiguration();
        konfig.setMarke(marke);
        konfig.setProdukt(produktArt);
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("ladeAWKonfiguration");
            ps = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_FILIALE_ARBEITEN());
            ps.setString(1, marke);
            ps.setString(2, produktArt);
            ps.setString(3, firmaId);
            ps.setString(4, filialId);
            result = ps.executeQuery();
            while (result.next()) {
                String aufwandId = result.getString("aufwandId");
                String art = result.getString("art");
                String wert = result.getString("kritWert");
                String kritArt = result.getString("kritArt");
                AufwandsKonfigPosition konfigPos = (AufwandsKonfigPosition)konfig.getAufwaende().get(art);
                if (konfigPos == null) {
                    konfigPos = new AufwandsKonfigPosition();
                    konfigPos.setId(aufwandId);
                }
                if (kritArt.equals("BEZEICHNUNG_CUST") && konfigPos.getBezeichnung() == null) {
                    konfigPos.setBezeichnung(wert);
                } else if (kritArt.equals("AUFWAND_MIN") && konfigPos.getAwMin() == null && wert != null) {
                    konfigPos.setAwMin(new Double(wert));
                } else if (kritArt.equals("PREIS_AW") && konfigPos.getPreis() == null && wert != null) {
                    konfigPos.setPreis(new Double(wert));
                } else {
                    log.error("invalid kritArt:" + kritArt);
                }
                konfig.getAufwaende().put(art, konfigPos);
            }
            VerwaltungDbAccess.ermittleAWFallback(konfig, marktId, marke, produktArt);
            AufwandsKonfiguration aufwandsKonfiguration = konfig;
            return aufwandsKonfiguration;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "getUserList");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ermittleAWFallback(AufwandsKonfiguration konfig, int marktId, String marke, String produktart) throws SQLException, DatabaseBusyException {
        Statement stat = null;
        ResultSet rs = null;
        Connection con = null;
        HashMap<String, AufwandsKonfigPosition> map = new HashMap<String, AufwandsKonfigPosition>();
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        HashMap<String, String> artMapping = new HashMap<String, String>();
        artMapping.put("AW_ELEKTRISCH_DAUER", "ELEKTRISCH");
        artMapping.put("AW_ELEKTRISCH_PREIS", "ELEKTRISCH");
        artMapping.put("AW_MECHANISCH_DAUER", "MECHANISCH");
        artMapping.put("AW_MECHANISCH_PREIS", "MECHANISCH");
        artMapping.put("AW_LACKIEREN_DAUER", "LACKIEREN");
        artMapping.put("AW_LACKIEREN_PREIS", "LACKIEREN");
        artMapping.put("AW_PROGRAMMIERUNG_DAUER", "PROGRAMMIER");
        artMapping.put("AW_PROGRAMMIERUNG_PREIS", "PROGRAMMIER");
        artMapping.put("AW_SONSTIGE_ARBEIT_DAUER", "SONSTIGE");
        artMapping.put("AW_SONSTIGE_ARBEIT_PREIS", "SONSTIGE");
        artMapping.put("AW_ALLE_ARBEIT_DAUER", "ARBEITSAUFWAND");
        artMapping.put("AW_ALLE_ARBEIT_PREIS", "ARBEITSAUFWAND");
        map.put("AW_ELEKTRISCH_DAUER", konfig.getElektrischeArbeit());
        map.put("AW_ELEKTRISCH_PREIS", konfig.getElektrischeArbeit());
        map.put("AW_MECHANISCH_DAUER", konfig.getMechanischeArbeit());
        map.put("AW_MECHANISCH_PREIS", konfig.getMechanischeArbeit());
        map.put("AW_LACKIEREN_DAUER", konfig.getLackierArbeit());
        map.put("AW_LACKIEREN_PREIS", konfig.getLackierArbeit());
        map.put("AW_PROGRAMMIERUNG_DAUER", konfig.getProgrammierArbeit());
        map.put("AW_PROGRAMMIERUNG_PREIS", konfig.getProgrammierArbeit());
        map.put("AW_SONSTIGE_ARBEIT_DAUER", konfig.getSonstigeArbeit());
        map.put("AW_SONSTIGE_ARBEIT_PREIS", konfig.getSonstigeArbeit());
        map.put("AW_ALLE_ARBEIT_DAUER", konfig.getArbeitAufwand());
        map.put("AW_ALLE_ARBEIT_PREIS", konfig.getArbeitAufwand());
        try {
            con = globs.getDBConnection("ermittleAWFallback");
            stat = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_MARKT_IPAC_WERTE());
            stat.setInt(1, marktId);
            stat.setString(2, "AW%");
            stat.setString(3, produktart);
            rs = stat.executeQuery();
            while (rs.next()) {
                String art = rs.getString("art");
                String wert = rs.getString("wert");
                String id = null;
                if (art.equals("AW_ELEKTRISCH_DAUER") || art.equals("AW_ELEKTRISCH_PREIS")) {
                    id = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", marke, "marke.arbeitsnummern.elektrisch", "");
                } else if (art.equals("AW_MECHANISCH_DAUER") || art.equals("AW_MECHANISCH_PREIS")) {
                    id = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", marke, "marke.arbeitsnummern.mechanisch", "");
                } else if (art.equals("AW_LACKIEREN_DAUER") || art.equals("AW_LACKIEREN_PREIS")) {
                    id = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", marke, "marke.arbeitsnummern.lack", "");
                } else if (art.equals("AW_PROGRAMMIERUNG_DAUER") || art.equals("AW_PROGRAMMIERUNG_PREIS")) {
                    id = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", marke, "marke.arbeitsnummern.programm", "");
                } else if (art.equals("AW_SONSTIGE_ARBEIT_DAUER") || art.equals("AW_SONSTIGE_ARBEIT_PREIS")) {
                    id = Marken.getInstance().getMarkeEigenschaft("marke.berechtigung", marke, "marke.arbeitsnummern.sonstige", "");
                } else if (art.equals("AW_ALLE_ARBEIT_DAUER") || art.equals("AW_ALLE_ARBEIT_PREIS")) {
                    id = "";
                }
                AufwandsKonfigPosition pos = (AufwandsKonfigPosition)map.get(art);
                if (pos == null && !konfig.getAufwaende().containsKey(artMapping.get(art))) {
                    pos = new AufwandsKonfigPosition();
                    konfig.getAufwaende().put(artMapping.get(art), pos);
                    pos.setId(id);
                    map.put(art, pos);
                } else if (konfig.getAufwaende().containsKey(artMapping.get(art))) {
                    pos = (AufwandsKonfigPosition)konfig.getAufwaende().get(artMapping.get(art));
                    pos.setId(id);
                    map.put(art, pos);
                }
                if (art.indexOf("PREIS") > -1) {
                    VerwaltungDbAccess.setzePreis(pos, wert);
                    continue;
                }
                if (art.indexOf("DAUER") <= -1) continue;
                VerwaltungDbAccess.setzeDauer(pos, wert);
            }
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "ermittleAWFallback");
            }
        }
    }

    private static void setzeDauer(AufwandsKonfigPosition pos, String wert) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(Locale.GERMANY);
        if (pos.getAwMin() == null && wert != null && wert.trim().length() > 0) {
            try {
                Number value = format.parse(wert);
                pos.setAwMin(new Double(value.doubleValue()));
            }
            catch (ParseException e) {
                log.error("Unable to parse awMin for Arbeit: " + pos.getBezeichnung() + ". Value is:" + wert);
            }
        }
    }

    private static void setzePreis(AufwandsKonfigPosition pos, String wert) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(Locale.GERMANY);
        if (pos.getPreis() == null && wert != null && wert.trim().length() > 0) {
            try {
                Number value = format.parse(wert);
                pos.setPreis(new Double(value.doubleValue()));
            }
            catch (ParseException e) {
                log.error("Unable to parse preis for Arbeit: " + pos.getBezeichnung() + ". Value is:" + wert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ermittleBindeFristTage(int marktId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnection("ermittleBindeFristTage");
            stat = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_MARKT_SPEZIFIKA());
            stat.setInt(1, marktId);
            rs = stat.executeQuery();
            int bindeFrist = 0;
            String sBindeFrist = null;
            if (rs.next()) {
                sBindeFrist = rs.getString("bindefrist");
            }
            if (sBindeFrist != null && sBindeFrist.trim().length() > 0) {
                bindeFrist = new Integer(sBindeFrist);
            }
            int n = bindeFrist;
            return n;
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "ermittleBindeFristTage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void speichereUserDaten(NutzerZub user) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            int count;
            con = globs.getDBConnectionNutzer("updateUserDaten");
            boolean insert = false;
            ps = con.prepareStatement(SQLStatements.Admin.instance.COUNT_ZUB_USERDATEN());
            ps.setString(1, user.getUserId());
            ps.setString(2, user.getFirmaId());
            result = ps.executeQuery();
            if (result.next() && (count = result.getInt("cnt")) == 0) {
                insert = true;
            }
            result.close();
            if (insert) {
                VerwaltungDbAccess.insertZubUser(con, user);
            } else {
                VerwaltungDbAccess.updateZubUser(con, user);
            }
            VerwaltungDbAccess.updateUser(con, user);
            VerwaltungDbAccess.updateUserEinstellungen(con, user);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "updateUserDaten");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUserEinstellungen(Connection con, NutzerZub user) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_USER_EINSTELLUNGEN());
            if (user.getIso() != null) {
                stat.setString(1, user.getIso());
            } else {
                stat.setNull(1, 12);
            }
            if (user.getRegIso() != null) {
                stat.setString(2, user.getRegIso());
            } else {
                stat.setNull(2, 12);
            }
            stat.setString(3, user.getFirmaId());
            stat.setString(4, user.getUserId());
            int rows = stat.executeUpdate();
            log.debug("Update of Einstellungen : " + rows + " row(s) updated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUser(Connection con, NutzerZub user) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_BEARBEITERNUMMER());
            if (user.getBearbeiterNummer() != null && user.getBearbeiterNummer().length() > 0) {
                stat.setInt(1, new Integer(user.getBearbeiterNummer()));
            } else {
                stat.setNull(1, 4);
            }
            stat.setString(2, user.getUserId());
            stat.setString(3, user.getFirmaId());
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No rows updated during update of BearbeiterNr - Maybe an error!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateZubUser(Connection con, NutzerZub user) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_ZUB_USERDATEN());
            if (user.getRealName() != null) {
                stat.setString(1, user.getRealName());
            } else {
                stat.setNull(1, 12);
            }
            if (user.getTelefon() != null) {
                stat.setString(2, user.getTelefon());
            } else {
                stat.setNull(2, 12);
            }
            if (user.getEmail() != null) {
                stat.setString(3, user.getEmail());
            } else {
                stat.setNull(3, 12);
            }
            stat.setString(4, user.getUserId());
            stat.setString(5, user.getFirmaId());
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No rows updated during update of user- Maybe an error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertZubUser(Connection con, NutzerZub user) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.INSERT_ZUB_USERDATEN());
            stat.setString(1, user.getFirmaId());
            stat.setString(2, user.getUserId());
            if (user.getRealName() != null) {
                stat.setString(3, user.getRealName());
            } else {
                stat.setNull(3, 12);
            }
            if (user.getTelefon() != null) {
                stat.setString(4, user.getTelefon());
            } else {
                stat.setNull(4, 12);
            }
            if (user.getEmail() != null) {
                stat.setString(5, user.getEmail());
            } else {
                stat.setNull(5, 12);
            }
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No Rows inserted during insert of zub_user - Possible Problem");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void speichereFilialDaten(FilialeZub filiale) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            int rows;
            int rows2;
            con = globs.getDBConnectionNutzer("updateFilialDaten");
            ps = con.prepareStatement(SQLStatements.Admin.instance.COUNT_ZUB_FILIALDATEN());
            ps.setString(1, filiale.getIdFirma());
            ps.setString(2, filiale.getId());
            result = ps.executeQuery();
            boolean insertZub = false;
            if (result.next() && (rows2 = result.getInt("cnt")) <= 0) {
                insertZub = true;
            }
            result.close();
            ps = con.prepareStatement(SQLStatements.Admin.instance.COUNT_FILIALE_KONFIG());
            ps.setString(1, filiale.getIdFirma());
            ps.setString(2, filiale.getId());
            result = ps.executeQuery();
            boolean insertKonfig = false;
            if (result.next() && (rows = result.getInt("cnt")) <= 0) {
                insertKonfig = true;
            }
            result.close();
            if (insertKonfig) {
                VerwaltungDbAccess.insertFilialeKonfig(con, filiale);
            } else {
                VerwaltungDbAccess.updateKonfig(con, filiale);
            }
            if (insertZub) {
                VerwaltungDbAccess.insertFilialeZub(con, filiale);
            } else {
                VerwaltungDbAccess.updateFilialeZub(con, filiale);
            }
            VerwaltungDbAccess.updateFilialName(con, filiale);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "updateFilialDaten");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFilialName(Connection con, FilialeZub filiale) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_FILIALNAME());
            if (filiale.getBezeichnung() == null) {
                return;
            }
            stat.setString(1, filiale.getBezeichnung());
            stat.setString(2, filiale.getId());
            stat.setString(3, filiale.getIdFirma());
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No rows updated in w_filiale - Possible Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFilialeZub(Connection con, FilialeZub filiale) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_ZUB_FILIALDATEN());
            if (filiale.getFax() != null) {
                stat.setString(1, filiale.getFax());
            } else {
                stat.setNull(1, 12);
            }
            if (filiale.getEmail() != null) {
                stat.setString(2, filiale.getEmail());
            } else {
                stat.setNull(2, 12);
            }
            if (filiale.getMarktId() != null) {
                stat.setInt(3, filiale.getMarktId());
            } else {
                stat.setNull(3, 4);
            }
            stat.setString(4, filiale.isSpeicherKunde() ? "J" : "N");
            stat.setString(5, filiale.isPruefVerfuegbarkeit() ? "J" : "N");
            stat.setString(6, filiale.getIdFirma());
            stat.setString(7, filiale.getId());
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No rows updated in w_zub_konfig - Possible Error");
            }
            if (filiale.getMarktId() != null) {
                stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_USER_MARKTID());
                stat.setInt(1, filiale.getMarktId());
                stat.setString(2, filiale.getIdFirma());
                stat.setString(3, filiale.getId());
                stat.executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateKonfig(Connection con, FilialeZub filiale) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_FILIALDATEN());
            if (filiale.getStrasse() != null) {
                stat.setString(1, filiale.getStrasse());
            } else {
                stat.setNull(1, 12);
            }
            if (filiale.getOrt() != null) {
                stat.setString(2, filiale.getOrt());
            } else {
                stat.setNull(2, 12);
            }
            if (filiale.getPlz() != null) {
                stat.setString(3, filiale.getPlz());
            } else {
                stat.setNull(3, 12);
            }
            if (filiale.getTelefon() != null) {
                stat.setString(4, filiale.getTelefon());
            } else {
                stat.setNull(4, 12);
            }
            stat.setString(5, filiale.getIdFirma());
            stat.setString(6, filiale.getId());
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No rows updated in w_konfig - Possible error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertFilialeKonfig(Connection con, FilialeZub filiale) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.INSERT_KONFIG_FILIALE());
            stat.setString(1, filiale.getIdFirma());
            stat.setString(2, filiale.getId());
            stat.setString(3, "N");
            if (filiale.getStrasse() != null) {
                stat.setString(4, filiale.getStrasse());
            } else {
                stat.setNull(4, 12);
            }
            if (filiale.getPlz() != null) {
                stat.setString(5, filiale.getPlz());
            } else {
                stat.setNull(5, 12);
            }
            if (filiale.getOrt() != null) {
                stat.setString(6, filiale.getOrt());
            } else {
                stat.setNull(6, 12);
            }
            if (filiale.getTelefon() != null) {
                stat.setString(7, filiale.getTelefon());
            } else {
                stat.setNull(7, 12);
            }
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No rows inserted during insert of w_konfig - Possible Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertFilialeZub(Connection con, FilialeZub filiale) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Admin.instance.INSERT_ZUB_FILIALDATEN());
            stat.setString(1, filiale.getIdFirma());
            stat.setString(2, filiale.getId());
            if (filiale.getFax() != null) {
                stat.setString(3, filiale.getFax());
            } else {
                stat.setNull(3, 12);
            }
            if (filiale.getEmail() != null) {
                stat.setString(4, filiale.getEmail());
            } else {
                stat.setNull(4, 12);
            }
            if (filiale.getMarktId() != null) {
                stat.setInt(5, filiale.getMarktId());
            } else {
                stat.setNull(5, 4);
            }
            stat.setString(6, filiale.isSpeicherKunde() ? "J" : "N");
            stat.setString(7, filiale.isPruefVerfuegbarkeit() ? "J" : "N");
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("No Rows inserted during insert of zub_filiale - Possible Problem");
            }
            if (filiale.getMarktId() != null) {
                stat = con.prepareStatement(SQLStatements.Admin.instance.UPDATE_USER_MARKTID());
                stat.setInt(1, filiale.getMarktId());
                stat.setString(2, filiale.getIdFirma());
                stat.setString(3, filiale.getId());
                stat.executeUpdate();
            }
        }
    }

    public static void speichereArbeitenKonfig(String firmaId, Collection filialIds, AufwandsKonfiguration konfig, List markenProduktArten) throws SQLException, DatabaseBusyException {
        for (String filialId : filialIds) {
            for (MarkeProdukt obj : markenProduktArten) {
                String marke = obj.getMarke();
                String produktArt = obj.getProdukt();
                VerwaltungDbAccess.speichereArbeitenKonfig(firmaId, filialId, konfig, marke, produktArt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void speichereArbeitenKonfig(String firmaId, String filialId, AufwandsKonfiguration konfig, String marke, String produktArt) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        try {
            con = globs.getDBConnectionNutzer("speichereArbeiten");
            ps = con.prepareStatement(SQLStatements.Admin.instance.DELETE_ARBEITEN());
            ps.setString(1, firmaId);
            ps.setString(2, "F");
            ps.setString(3, filialId);
            ps.setString(4, marke);
            ps.setString(5, produktArt);
            ps.executeUpdate();
            StringBuffer sbuf = new StringBuffer();
            String insertStatement = SQLStatements.Admin.instance.INSERT_ARBEITEN();
            for (String key : konfig.getAufwaende().keySet()) {
                AufwandsKonfigPosition pos = (AufwandsKonfigPosition)konfig.getAufwaende().get(key);
                VerwaltungDbAccess.appendLine(sbuf, firmaId, filialId, marke, produktArt, pos.getId(), key, "BEZEICHNUNG_CUST", pos.getBezeichnung());
                VerwaltungDbAccess.appendLine(sbuf, firmaId, filialId, marke, produktArt, pos.getId(), key, "AUFWAND_MIN", pos.getAwMin());
                VerwaltungDbAccess.appendLine(sbuf, firmaId, filialId, marke, produktArt, pos.getId(), key, "PREIS_AW", pos.getPreis());
            }
            if (sbuf != null && sbuf.length() > 0) {
                sbuf.setCharAt(sbuf.lastIndexOf(","), ' ');
                insertStatement = StringUtils.substituteString(insertStatement, "TABELLE", sbuf.toString());
                ps = con.prepareStatement(insertStatement);
                ps.execute();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "speichereArbeiten");
            }
        }
    }

    private static void appendLine(StringBuffer buf, String firmaId, String filialId, String marke, String produktArt, String awId, String arbeitsArt, String kriterium, Object kriteriumWert) {
        if (kriteriumWert != null) {
            buf.append("('");
            buf.append(firmaId).append("',");
            buf.append("'F',");
            buf.append("'").append(filialId).append("',");
            buf.append("'").append(marke).append("',");
            buf.append("'").append(produktArt).append("',");
            buf.append("'").append(awId).append("',");
            buf.append("'").append(arbeitsArt).append("',");
            buf.append("'").append(kriterium).append("',");
            buf.append("'").append(String.valueOf(kriteriumWert)).append("'),");
        }
    }

    public static Collection ermittleAlleProduktArten(String firmaId) {
        ArrayList<String> col = new ArrayList<String>();
        col.add("P");
        col.add("M");
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getAlleFilialen(String firmaId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("speichereArbeiten");
            ps = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_ALLE_FILIALEN());
            ArrayList<String> filialen = new ArrayList<String>();
            ps.setString(1, firmaId);
            result = ps.executeQuery();
            while (result.next()) {
                filialen.add(result.getString("filialId"));
            }
            ArrayList<String> arrayList = filialen;
            return arrayList;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "getAlleFilialen");
            }
        }
    }

    public static List getMarkenProduktArtenList(String marke, String produktArt) throws SQLException, DatabaseBusyException {
        final ArrayList markeProduktArten = new ArrayList();
        IMarkeProduktArt verarbeiter = new IMarkeProduktArt(){

            @Override
            public void verarbeiteWerte(String marke, String produktArt) {
                MarkeProdukt markeProdArt = new MarkeProdukt(marke, produktArt, null, null);
                if (!markeProduktArten.contains(markeProdArt)) {
                    markeProduktArten.add(markeProdArt);
                }
            }
        };
        VerwaltungDbAccess.queryMarkenProduktArten(marke, produktArt, verarbeiter);
        return markeProduktArten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryMarkenProduktArten(String marke, String produktArt, IMarkeProduktArt verarbeiter) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnection("getMarkenProduktArten");
            ps = con.createStatement();
            result = ps.executeQuery(SQLStatements.Listenfueller.instance.ERMITTLE_MARKE_PRODUKTARTEN());
            while (result.next()) {
                String markeRs = result.getString("marke");
                String produktArtRs = result.getString("produktArt");
                if (marke != null && !markeRs.equals(marke) || produktArt != null && !produktArtRs.equals(produktArt)) continue;
                verarbeiter.verarbeiteWerte(markeRs, produktArtRs);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(result);
            if (con != null) {
                globs.freeDBConnection(con, "getMarkenProduktArten");
            }
            throw throwable;
        }
        WebetkUtils.closeQuery(result);
        if (con != null) {
            globs.freeDBConnection(con, "getMarkenProduktArten");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer ermittleAnzahlUser(String firmaId, String searchString) throws SQLException, DatabaseBusyException {
        String add = "";
        if (searchString != null) {
            String realSearchString = searchString.replace('*', '%').replace('?', '_');
            add = " AND ( user_id like '%" + realSearchString + "%' OR user_name like '%" + searchString + "%')";
        }
        String statement = StringUtils.substituteString(SQLStatements.Admin.instance.ERMITTLE_ANZAHL_USER(), "ADD", add);
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        int count = 0;
        try {
            con = globs.getDBConnection("ermittleAnzahlUser");
            ps = con.prepareStatement(statement);
            ps.setString(1, firmaId);
            result = ps.executeQuery();
            if (result.next()) {
                count = result.getInt("cnt");
            }
            if (!result.wasNull()) {
                Integer n = new Integer(count);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "ermittleAnzahlUser");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AnfrageSuche> sucheAnfragen(Map suchKriterien, String filialId, String aktUserId, String firmaId, Collection<String> userMarken, Collection<String> userProdukte) throws SQLException, DatabaseBusyException, ParseException {
        ArrayList<AnfrageSuche> arrayList;
        String statement = SQLStatements.BestehendeAnfrage.instance.SUCHE_ANFRAGE();
        statement = StringUtils.substituteListOfStrings(statement, "MARKEN", userMarken);
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        StringBuffer buffer = VerwaltungDbAccess.getBaseSearchStringBuilder(suchKriterien, "anfragei", "anfrage", "anfrage_name", aktUserId, filialId);
        String ersteller = (String)suchKriterien.get("ERSTELLER");
        Boolean nurEigeneAnfragen = (Boolean)suchKriterien.get("NUR_EIGENE_ANFRAGEN");
        if (nurEigeneAnfragen != null && nurEigeneAnfragen.booleanValue()) {
            ersteller = aktUserId;
        }
        if (ersteller != null && ersteller.length() >= 3) {
            String erstellerSuchString = VerwaltungDbAccess.getSearchString(ersteller);
            buffer.append(" AND ( anfrage_user_id_anlage like '%").append(StringUtils.maskiereHochkommaFuerDb(erstellerSuchString)).append("%'");
            buffer.append(" OR anfrage_user_id_aender like '%").append(StringUtils.maskiereHochkommaFuerDb(erstellerSuchString)).append("%'");
            buffer.append(" OR upper(userz_real_name) like '%").append(StringUtils.maskiereHochkommaFuerDb(erstellerSuchString.toUpperCase())).append("%'");
            buffer.append(" OR upper(user_name) like '%").append(StringUtils.maskiereHochkommaFuerDb(erstellerSuchString.toUpperCase())).append("%' )");
        }
        if (userProdukte != null && userProdukte.size() == 1) {
            buffer.append(" AND anfrage_produktart = '").append(StringUtils.maskiereHochkommaFuerDb(userProdukte.iterator().next())).append("'");
        }
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("sucheAnfragen");
            String sqlStatement = StringUtils.substituteStringStraight(statement, "&ADD&", buffer.toString());
            log.info("Executing SQL-Command:\n" + sqlStatement);
            ps = con.createStatement();
            result = ps.executeQuery(sqlStatement);
            ArrayList<AnfrageSuche> anfragen = new ArrayList<AnfrageSuche>();
            while (result.next()) {
                int anfrageId = result.getInt("anfrageId");
                String bemerkung = result.getString("bemerkung");
                String anfrageName = result.getString("anfrageName");
                String erstellungsDatum = result.getString("erstellungsdatum");
                String kundeNachname = result.getString("kundenName");
                String kundeVorname = result.getString("kundenVorname");
                String kundenNummer = result.getString("kundenNummer");
                Integer kundeId = null;
                int kundenId = result.getInt("kundenId");
                if (!result.wasNull()) {
                    kundeId = new Integer(kundenId);
                }
                String erstellerId = result.getString("erstellerId");
                String erstellerName = result.getString("ersteller");
                Integer vId = null;
                int vorgangId = result.getInt("vorgangId");
                if (!result.wasNull()) {
                    vId = new Integer(vorgangId);
                }
                String produktName = result.getString("produktName");
                String btnr = result.getString("btnr");
                String bildPos = result.getString("bildPos");
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                java.util.Date erstellungsDate = null;
                try {
                    if (erstellungsDatum != null) {
                        erstellungsDate = format.parse(erstellungsDatum);
                    }
                }
                catch (ParseException e) {
                    log.error("Error while parsing date - possible wrong format");
                }
                int anzahlAngebote = result.getInt("offeneAngebote");
                AnfrageSuche anfrage = new AnfrageSuche();
                anfrage.setAnfrageId(anfrageId);
                if (!anfragen.contains(anfrage)) {
                    anfrage.setAnfrageName(anfrageName);
                    anfrage.setBemerkung(bemerkung);
                    anfrage.setAnlageDatum(erstellungsDate);
                    anfrage.setFilialId(filialId);
                    anfrage.setFirmaId(firmaId);
                    Kunde kunde = new Kunde();
                    if (kundeId != null) {
                        kunde.setKundenId(kundeId);
                    }
                    if (kundeNachname != null) {
                        kunde.setName(kundeNachname);
                    }
                    if (kundeVorname != null) {
                        kunde.setVorname(kundeVorname);
                    }
                    if (kundenNummer != null) {
                        kunde.setKundennummer(kundenNummer);
                    }
                    anfrage.setKunde(kunde);
                    anfrage.setAnlageNutzerId(erstellerId);
                    anfrage.setErstellerName(erstellerName);
                    anfrage.setVorgaenge(new ArrayList<BaseVorgang>());
                    anfrage.setOffeneAngebote(anzahlAngebote > 0);
                    anfragen.add(anfrage);
                }
                AnfrageSuche anfrageNeu = (AnfrageSuche)anfragen.get(anfragen.indexOf(anfrage));
                if (vId == null) continue;
                BaseVorgang vorgang = new BaseVorgang();
                vorgang.setVorgangsId(vId);
                if (anfrageNeu.getVorgaenge().contains(vorgang)) continue;
                vorgang.setAnlageDatum(erstellungsDate);
                vorgang.setAnfrageId(anfrageId);
                vorgang.setProduktName(produktName);
                vorgang.setBtNummer(btnr);
                vorgang.setBildPos(bildPos);
                anfrageNeu.addVorgang(vorgang);
            }
            arrayList = anfragen;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(result);
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "sucheAnfragen");
            }
            throw throwable;
        }
        WebetkUtils.closeQuery(result);
        if (con != null) {
            globs.freeDBConnectionNutzer(con, "sucheAnfragen");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List sucheAngebote(Map suchKriterien, String filialId, String aktUserId, String firmaId, Collection<String> userMarken, Collection<String> userProdukte) throws DatabaseBusyException, SQLException, ParseException {
        ArrayList<AngebotsSuche> arrayList;
        String statement = SQLStatements.BestehendeAngebote.instance.SUCHE_ANGEBOT();
        StringBuffer buffer = VerwaltungDbAccess.getBaseSearchStringBuilder(suchKriterien, "vorganga", "vorganga", "vorganga_angebotsname", aktUserId, filialId);
        statement = StringUtils.substituteListOfStrings(statement, "MARKEN", userMarken);
        Integer bindeFristSuche = (Integer)suchKriterien.get("BINDEFRIST");
        SimpleDateFormat zielDateFormat = new SimpleDateFormat("yyyyMMdd");
        if (bindeFristSuche != null) {
            Calendar cal = Calendar.getInstance();
            String heute = zielDateFormat.format(cal.getTime());
            cal.add(5, bindeFristSuche);
            String bindeFristBis = zielDateFormat.format(cal.getTime());
            buffer.append(" AND vorganga_bindefrist between ").append(heute).append(" AND ").append(bindeFristBis);
        }
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        String angebotsNummer = (String)suchKriterien.get("ANGEBOTSNUMMER");
        if (angebotsNummer != null) {
            buffer.append(" AND to_char(vorganga_angebotsnummer) like '%").append(angebotsNummer).append("%'");
        }
        String ersteller = (String)suchKriterien.get("ERSTELLER");
        Boolean nurEigeneAnfragen = (Boolean)suchKriterien.get("NUR_EIGENE_ANFRAGEN");
        if (nurEigeneAnfragen != null && nurEigeneAnfragen.booleanValue()) {
            ersteller = aktUserId;
        }
        if (ersteller != null && ersteller.length() >= 3) {
            String erstellerSuchString = VerwaltungDbAccess.getSearchString(ersteller);
            buffer.append(" AND ( vorganga_user_id like '%").append(erstellerSuchString).append("%'");
            buffer.append(" OR upper(userz_real_name) like '%").append(erstellerSuchString.toUpperCase()).append("%'");
            buffer.append(" OR upper(user_name) like '%").append(erstellerSuchString.toUpperCase()).append("%' )");
        }
        if (userProdukte != null && userProdukte.size() == 1) {
            buffer.append(" AND anfrage_produktart = '").append(StringUtils.maskiereHochkommaFuerDb(userProdukte.iterator().next())).append("'");
        }
        log.debug("Now Accessing Database");
        Connection con = null;
        Statement ps = null;
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("sucheAngebote");
            String sqlStatement = StringUtils.substituteStringStraight(statement, "&ADD&", buffer.toString());
            ArrayList<AngebotsSuche> angebote = new ArrayList<AngebotsSuche>();
            log.info("Executing SQL-Command:\n" + sqlStatement);
            ps = con.createStatement();
            result = ps.executeQuery(sqlStatement);
            while (result.next()) {
                int angebotsNr = result.getInt("angebotsNr");
                String angebotsName = result.getString("angebotsName");
                String erstellungsDatum = result.getString("anlageDatum");
                String bindeFrist = result.getString("bindeFrist");
                String kundeNachname = result.getString("kundeName");
                String kundeVorname = result.getString("kundeVorname");
                Integer kundeId = null;
                int kundenId = result.getInt("kundeId");
                if (!result.wasNull()) {
                    kundeId = new Integer(kundenId);
                }
                String anIspa = result.getString("an_ispa");
                String bemerkung = result.getString("bemerkung");
                String erstellerId = result.getString("erstellerId");
                String erstellerName = result.getString("ersteller");
                Integer vId = null;
                int vorgangId = result.getInt("vorgangId");
                if (!result.wasNull()) {
                    vId = new Integer(vorgangId);
                }
                String produktName = result.getString("produktName");
                String btnr = result.getString("btnr");
                String bildPos = result.getString("bildPos");
                String status = result.getString("status");
                int konfigId = result.getInt("konfigId");
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                java.util.Date erstellungsDate = null;
                try {
                    if (erstellungsDatum != null) {
                        erstellungsDate = format.parse(erstellungsDatum);
                    }
                }
                catch (ParseException e) {
                    log.error("Error while parsing date : " + erstellungsDatum + " - possible wrong format");
                }
                java.util.Date bindeFristDatum = null;
                try {
                    if (bindeFrist != null) {
                        bindeFristDatum = format.parse(bindeFrist);
                    }
                }
                catch (ParseException e) {
                    log.error("Error while parsing date : " + bindeFrist + " - possible wrong format");
                }
                AngebotsSuche angebot = new AngebotsSuche();
                angebot.setAngebotsNummer(angebotsNr);
                angebot.setKonfigId(konfigId);
                angebot.setStorniert(status.equals("STORNIERT"));
                if (!angebote.contains(angebot)) {
                    angebot.setAngebotsName(angebotsName);
                    angebot.setErstellungsDatum(erstellungsDate);
                    angebot.setFilialId(filialId);
                    angebot.setFirmaId(firmaId);
                    Kunde kunde = new Kunde();
                    if (kundeId != null) {
                        kunde.setKundenId(kundeId);
                    }
                    if (kundeNachname != null) {
                        kunde.setName(kundeNachname);
                    }
                    if (kundeVorname != null) {
                        kunde.setVorname(kundeVorname);
                    }
                    angebot.setKunde(kunde);
                    angebot.setErstellerId(erstellerId);
                    angebot.setErstellerName(erstellerName);
                    angebot.setBindeFrist(bindeFristDatum);
                    angebot.setStatus(status);
                    if (anIspa != null && !anIspa.equals("")) {
                        angebot.setAnIspa(anIspa);
                    }
                    angebot.setBemerkung(bemerkung);
                    angebote.add(angebot);
                }
                AngebotsSuche angebotNeu = (AngebotsSuche)angebote.get(angebote.indexOf(angebot));
                if (vId == null) continue;
                BaseVorgang vorgang = new BaseVorgang();
                vorgang.setVorgangsId(vId);
                vorgang.setAnlageDatum(erstellungsDate);
                vorgang.setAnfrageId(angebotsNr);
                vorgang.setProduktName(produktName);
                vorgang.setBtNummer(btnr);
                vorgang.setBildPos(bildPos);
                angebotNeu.setVorgang(vorgang);
            }
            arrayList = angebote;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(result);
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "sucheAngebote");
            }
            throw throwable;
        }
        WebetkUtils.closeQuery(result);
        if (con != null) {
            globs.freeDBConnectionNutzer(con, "sucheAngebote");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storniereAngebot(int angebotsNummer) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = globs.getDBConnectionNutzer("storniereAngebot");
            VerwaltungDbAccess.setzeAngebotsStatus(con, angebotsNummer, "STORNIERT");
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "storniereAngebot");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storniereAngebotKonfig(int konfigId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = globs.getDBConnectionNutzer("storniereAngebot");
            VerwaltungDbAccess.setzeAngebotsStatusKonfig(con, konfigId, "STORNIERT");
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "storniereAngebot");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setzeAngebotsStatus(Connection con, int angebotsNummer, String status) throws SQLException {
        try (Statement stat = null;){
            String statement = SQLStatements.AngebotsHelper.instance.STORNIERE_ANGEBOT();
            stat = con.prepareStatement(statement);
            stat.setString(1, status);
            stat.setInt(2, Integer.parseInt(sdf.format(new java.util.Date())));
            stat.setInt(3, angebotsNummer);
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("Zero rows updated - maybe an error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setzeAngebotsStatusKonfig(Connection con, int konfigId, String status) throws SQLException {
        try (Statement stat = null;){
            String statement = SQLStatements.AngebotsHelper.instance.STORNIERE_ANGEBOT_KONFIG();
            stat = con.prepareStatement(statement);
            stat.setString(1, status);
            stat.setInt(2, Integer.parseInt(sdf.format(new java.util.Date())));
            stat.setInt(3, konfigId);
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("Zero rows updated - maybe an error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loescheAngebot(int angebotsNummer) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        try {
            con = globs.getDBConnectionNutzer("loescheAngebot");
            String statement = SQLStatements.AngebotsHelper.instance.DELETE_ANGEBOT();
            stat = con.prepareStatement(statement);
            stat.setInt(1, angebotsNummer);
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("Zero rows deleted - maybe an error");
            }
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loescheAngebot");
            }
        }
    }

    private static StringBuffer getBaseSearchStringBuilder(Map suchKriterien, String prefix, String prefix2, String objektSpalte, String userId, String filialId) throws ParseException {
        String von;
        String kundeSuchString;
        StringBuffer buffer = new StringBuffer();
        String kundenName = (String)suchKriterien.get("KUNDENNAME");
        String kundenNummer = (String)suchKriterien.get("KUNDENNUMMER");
        String produktBenennung = (String)suchKriterien.get("PRODUKTBENENNUNG");
        String erstellungsDatumVon = (String)suchKriterien.get("ERSTELLUNGSDATUM_VON");
        String erstellungsDatumBis = (String)suchKriterien.get("ERSTELLUNGSDATUM_BIS");
        Boolean alleFilialen = (Boolean)suchKriterien.get("ALLE_FILIALEN_SUCHEN");
        String vin = (String)suchKriterien.get("VIN");
        Boolean ispaSuche = (Boolean)suchKriterien.get("ISPA_SUCHE");
        SimpleDateFormat quellDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        SimpleDateFormat zielDateFormat = new SimpleDateFormat("yyyyMMdd");
        if (kundenName != null && kundenName.length() >= 3) {
            kundeSuchString = VerwaltungDbAccess.getSearchString(kundenName).toUpperCase();
            buffer.append(" AND (upper(kunde_name)||', '||upper(kunde_vorname) like '%").append(kundeSuchString).append("%'");
            buffer.append(" OR (upper(" + prefix + "_kunde_name)||', '||upper(" + prefix + "_kunde_vorname) like '%").append(kundeSuchString).append("%' ) )");
        }
        if (kundenNummer != null && kundenNummer.length() > 0) {
            kundeSuchString = VerwaltungDbAccess.getSearchString(kundenNummer);
            buffer.append(" AND to_char(kunde_kundennummer) like '").append(kundeSuchString).append("%'");
        }
        if (produktBenennung != null && produktBenennung.length() >= 3) {
            String produktSuchString = VerwaltungDbAccess.getSearchString(produktBenennung).toUpperCase();
            buffer.append(" AND ( upper(vorgang_produkt_name) like '%").append(produktSuchString).append("%'");
            buffer.append(" OR upper(" + objektSpalte + ") like '%").append(produktSuchString).append("%' )");
        }
        if (vin != null && vin.length() >= 3) {
            String vinSuchString = VerwaltungDbAccess.getSearchString(vin);
            buffer.append(" AND vorgang_id in (select vorgangfzg_vorgang_id from w_zub_vorgang_fahrzeug where vorgangfzg_kritart  = 'FGSTNR' and vorgangfzg_kritwert like '%").append(vinSuchString).append("%' )");
            if (ispaSuche.booleanValue()) {
                buffer.append(" AND anfrage_id not in (select anfrage_id from w_zub_anfrage left outer join w_zub_vorgang vorgang on vorgang_anfrage_id = anfrage_id where vorgang_id not in (select vorgangfzg_vorgang_id from w_zub_vorgang_fahrzeug where vorgangfzg_kritart  = 'FGSTNR' and vorgangfzg_kritwert like '%").append(vinSuchString).append("%' ))");
            }
        }
        if (erstellungsDatumVon != null && erstellungsDatumBis != null) {
            von = zielDateFormat.format(quellDateFormat.parse(erstellungsDatumVon));
            String bis = zielDateFormat.format(quellDateFormat.parse(erstellungsDatumBis));
            buffer.append(" AND " + prefix2 + "_datum_anlage between ").append(von).append(" AND ").append(bis);
        } else if (erstellungsDatumVon != null && erstellungsDatumBis == null) {
            von = zielDateFormat.format(quellDateFormat.parse(erstellungsDatumVon));
            buffer.append(" AND " + prefix2 + "_datum_anlage >= ").append(von);
        } else if (erstellungsDatumVon == null && erstellungsDatumBis != null) {
            String bis = zielDateFormat.format(quellDateFormat.parse(erstellungsDatumBis));
            buffer.append(" AND " + prefix2 + "_datum_anlage <= ").append(bis);
        }
        if (alleFilialen == null || !alleFilialen.booleanValue()) {
            buffer.append(" AND anfrage_filiale_id = '").append(filialId).append("'");
        }
        return buffer;
    }

    private static String getSearchString(String origString) {
        return VerwaltungDbAccess.getSearchString(origString, false);
    }

    private static String getSearchString(String origString, boolean replaceBlankWithWildcard) {
        String newString = origString.replace('*', '%').replace('?', '_').replaceAll("'", "''");
        if (replaceBlankWithWildcard) {
            newString = newString.replace(' ', '%');
        }
        return newString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entsperreAnfrage(Integer anfrageId, String userId) throws SQLException, DatabaseBusyException, ObjectLockedException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        try {
            int rows;
            con = globs.getDBConnectionNutzer("entsperreAnfrage");
            con.setAutoCommit(false);
            String statement = null;
            statement = anfrageId != null ? SQLStatements.AnfrageVorgangsHelper.instance.ENTSPERRE_ANFRAGE() : SQLStatements.AnfrageVorgangsHelper.instance.ENTSPERRE_ALLE_ANFRAGEN();
            stat = con.prepareStatement(statement);
            stat.setString(1, userId);
            if (anfrageId != null) {
                stat.setInt(2, anfrageId);
            }
            if ((rows = stat.executeUpdate()) <= 0 && anfrageId != null) {
                con.rollback();
                throw new ObjectLockedException("Die Anfrage wurde bereits durch einen anderen Benutzer gesperrt");
            }
            con.commit();
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                con.rollback();
                con.setAutoCommit(true);
                globs.freeDBConnectionNutzer(con, "entsperreAnfrage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sperreAnfrage(Integer anfrageId, String userId) throws SQLException, DatabaseBusyException, ObjectLockedException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        try {
            con = globs.getDBConnectionNutzer("sperreAnfrage");
            con.setAutoCommit(false);
            String statement = SQLStatements.AnfrageVorgangsHelper.instance.SPERRE_ANFRAGE();
            stat = con.prepareStatement(statement);
            stat.setString(1, userId);
            stat.setInt(2, anfrageId);
            stat.setString(3, userId);
            int rows = stat.executeUpdate();
            if (rows <= 0) {
                con.rollback();
                throw new ObjectLockedException("Die Anfrage wurde bereits durch einen anderen Benutzer gesperrt");
            }
            con.commit();
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                con.rollback();
                con.setAutoCommit(true);
                globs.freeDBConnectionNutzer(con, "entsperreAnfrage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Konfiguration ueberArbeiteAngebot(Konfiguration konfig, String userId, String firmaId, boolean forceCopy, String konfigName) throws SQLException, DatabaseBusyException {
        Angebot angebot = konfig.getAngebot();
        if (angebot == null && !forceCopy) {
            log.info("Konfiguration contains no Angebot, so nothing to do");
            return konfig;
        }
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        int konfigId = konfig.getKonfigurationsId();
        ResultSet result = null;
        try {
            con = globs.getDBConnectionNutzer("kopiereKonfiguration");
            con.setAutoCommit(false);
            String statement = null;
            int newKonfigId = 0;
            statement = SQLStatements.KonfigurationsHelper.instance.GET_NEW_KONFIGURATION_ID();
            stat = con.prepareStatement(statement);
            result = stat.executeQuery();
            if (result.next()) {
                newKonfigId = result.getInt("id");
            }
            result.close();
            stat.close();
            statement = SQLStatements.KonfigurationsHelper.instance.KOPIERE_KONFIGURATION();
            stat = con.prepareStatement(statement);
            stat.setString(1, String.valueOf(newKonfigId));
            stat.setInt(2, konfigId);
            int rows = stat.executeUpdate();
            stat.close();
            if (rows <= 0) {
                log.warn("Zero rows inserted to konfig - possible error");
            }
            statement = SQLStatements.KonfigurationsHelper.instance.SETZE_KONFIGNAME();
            stat = con.prepareStatement(statement);
            stat.setString(1, konfigName);
            stat.setString(2, String.valueOf(newKonfigId));
            rows = stat.executeUpdate();
            stat.close();
            statement = SQLStatements.KonfigurationsHelper.instance.KOPIERE_KONFIGURATION_BNB();
            stat = con.prepareStatement(statement);
            stat.setString(1, String.valueOf(newKonfigId));
            stat.setInt(2, konfigId);
            rows = stat.executeUpdate();
            stat.close();
            if (rows <= 0) {
                log.warn("Zero rows inserted to konfig - possible error");
            }
            statement = SQLStatements.KonfigurationsHelper.instance.KOPIERE_KONFIGURATION_BNB_VAR();
            stat = con.prepareStatement(statement);
            stat.setString(1, String.valueOf(newKonfigId));
            stat.setInt(2, konfigId);
            rows = stat.executeUpdate();
            stat.close();
            if (rows <= 0) {
                log.warn("Zero rows inserted to konfig - possible error");
            }
            statement = SQLStatements.KonfigurationsHelper.instance.KOPIERE_KONFIGURATION_POSITIONEN();
            stat = con.prepareStatement(statement);
            stat.setInt(1, newKonfigId);
            stat.setInt(2, konfigId);
            rows = stat.executeUpdate();
            if (rows <= 0) {
                log.warn("Zero rows inserted to konfig_positions  - possible error");
            }
            statement = SQLStatements.KonfigurationsHelper.instance.KOPIERE_KONFIGURATION_LASTSEEN();
            stat = con.prepareStatement(statement);
            stat.setInt(1, newKonfigId);
            stat.setInt(2, konfigId);
            stat.setString(3, userId);
            stat.setString(4, firmaId);
            rows = stat.executeUpdate();
            if (rows <= 0) {
                statement = SQLStatements.KonfigurationsHelper.instance.INSERT_KONFIGURATION_LASTSEEN();
                stat = con.prepareStatement(statement);
                stat.setInt(1, newKonfigId);
                stat.setString(2, userId);
                stat.setString(3, firmaId);
                stat.setString(4, "KALKULATION");
                stat.setDate(5, new Date(System.currentTimeMillis()));
                stat.execute();
            }
            statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_VORGANG_LAST_KONFIG();
            stat = con.prepareStatement(statement);
            stat.setInt(1, newKonfigId);
            stat.setDate(2, new Date(System.currentTimeMillis()));
            stat.setInt(3, konfig.getVorgangsId());
            stat.setString(4, userId);
            stat.setString(5, firmaId);
            rows = stat.executeUpdate();
            if (rows <= 0) {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_VORGANG_LAST_KONFIG();
                stat = con.prepareStatement(statement);
                stat.setInt(1, konfig.getVorgangsId());
                stat.setString(2, userId);
                stat.setString(3, firmaId);
                stat.setInt(4, newKonfigId);
                stat.setDate(5, new Date(System.currentTimeMillis()));
                stat.execute();
                stat.close();
            }
            statement = SQLStatements.AnfrageVorgangsHelper.instance.UPDATE_ANFRAGE_LAST_VORGANG();
            stat = con.prepareStatement(statement);
            stat.setInt(1, konfig.getVorgangsId());
            stat.setDate(2, new Date(System.currentTimeMillis()));
            stat.setInt(3, konfig.getAnfrageId());
            stat.setString(4, userId);
            stat.setString(5, firmaId);
            rows = stat.executeUpdate();
            if (rows <= 0) {
                statement = SQLStatements.AnfrageVorgangsHelper.instance.INSERT_ANFRAGE_LAST_VORGANG();
                stat = con.prepareStatement(statement);
                stat.setInt(1, konfig.getAnfrageId());
                if (userId != null) {
                    stat.setString(2, userId);
                } else {
                    stat.setNull(2, 12);
                }
                if (firmaId != null) {
                    stat.setString(3, firmaId);
                } else {
                    stat.setNull(3, 12);
                }
                stat.setInt(4, konfig.getVorgangsId());
                stat.setDate(5, new Date(System.currentTimeMillis()));
                stat.execute();
            }
            konfig.setKonfigurationsId(newKonfigId);
            konfig.setKonfigurationsName(konfigName);
            con.commit();
            Konfiguration konfiguration = konfig;
            return konfiguration;
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                con.rollback();
                con.setAutoCommit(true);
                globs.freeDBConnectionNutzer(con, "kopiereKonfiguration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Konfiguration ermittleKonfigurationAusAngebot(Angebot angebot, String firma, String user, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnectionNutzer("ermittleKonfigurationAusAngebot");
            stat = con.prepareStatement(SQLStatements.AngebotsHelper.instance.ERMITTLE_KONFIG());
            stat.setInt(1, angebot.getAngebotsnummer());
            rs = stat.executeQuery();
            int konfigId = 0;
            if (rs.next()) {
                konfigId = rs.getInt("konfig_id");
            }
            Konfiguration konfiguration = VerwaltungDbAccess.ladeKonfigurationInternal(con, user, firma, konfigId, iso, regIso);
            return konfiguration;
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "ermittleKonfigurationAusAngebot");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hatUserAgbBestaetigt(String firma, String user) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            String sBestaetigt;
            con = globs.getDBConnectionNutzer("hatUserAgbBestaetigt");
            stat = con.prepareStatement(SQLStatements.Nutzer.instance.HAT_NUTZER_AGB_BESTAETIGT());
            stat.setString(1, firma);
            stat.setString(2, user);
            rs = stat.executeQuery();
            if (rs.next() && "J".equals(sBestaetigt = rs.getString("Bestaetigt"))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "hatUserAgbBestaetigt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserAgbBestaetigt(String firma, String user, boolean bestaetigt) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnectionNutzer("setUserAgbBestaetigt");
            stat = con.prepareStatement(SQLStatements.Nutzer.instance.HAT_NUTZER_AGB_BESTAETIGT());
            stat.setString(1, firma);
            stat.setString(2, user);
            rs = stat.executeQuery();
            if (!rs.next()) {
                VerwaltungDbAccess.insertEmptyZubUser(con, firma, user);
            }
            stat.close();
            stat = con.prepareStatement(SQLStatements.Nutzer.instance.SET_USER_AGB_BESTAETIGT());
            stat.setString(1, bestaetigt ? "J" : "N");
            stat.setString(2, firma);
            stat.setString(3, user);
            int updatedRows = stat.executeUpdate();
            if (updatedRows != 1) {
                log.warn("Updated " + updatedRows + " Rows, where 1 should have.");
            }
        }
        finally {
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "setUserAgbBestaetigt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertEmptyZubUser(Connection con, String firma, String user) throws SQLException {
        try (PreparedStatement stat = null;){
            stat = con.prepareStatement(SQLStatements.Nutzer.instance.INSERT_EMPTY_ZUB_USER());
            stat.setString(1, firma);
            stat.setString(2, user);
            stat.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAnzeigeInklMwSt(int marktId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnection("isAnzeigeInklMwSt");
            stat = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_MARKT_SPEZIFIKA());
            stat.setInt(1, marktId);
            rs = stat.executeQuery();
            String anzeige = "";
            if (rs.next()) {
                anzeige = rs.getString("mwst");
            }
            boolean bl = anzeige.equalsIgnoreCase("J");
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "isAnzeigeInklMwSt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKundenDatenSpeichern(int marktId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = globs.getDBConnection("isKundenDatenSpeichern");
            stat = con.prepareStatement(SQLStatements.Admin.instance.ERMITTLE_MARKT_SPEZIFIKA());
            stat.setInt(1, marktId);
            rs = stat.executeQuery();
            String anzeige = "";
            if (rs.next()) {
                anzeige = rs.getString("kundendaten");
            }
            boolean bl = anzeige.equalsIgnoreCase("J");
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stat != null) {
                stat.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "isKundenDatenSpeichern");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void speichereKundenZuordnung(Anfrage anfrage) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = globs.getDBConnectionNutzer("speichereKundenZuordnung");
            VerwaltungDbAccess.updateAnfrageInfos(con, anfrage);
        }
        finally {
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "speichereKundenZuordnung");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setzeFlagAnIspa(int konfigId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement textPs = null;
        String statement = null;
        try {
            con = globs.getDBConnectionNutzer("setzeFlagAnIspa");
            statement = SQLStatements.AngebotsHelper.instance.SETZE_AN_ISPA();
            textPs = con.prepareStatement(statement);
            textPs.setInt(1, konfigId);
            textPs.execute();
        }
        finally {
            if (textPs != null) {
                textPs.close();
            }
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "setzeFlagAnIspa");
            }
        }
    }
}

