/*
 * Decompiled with CFR 0.152.
 */
package webetk.framework;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungsmenge;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.bteanzeige.Hotspot;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.BteAnzeigeDbAccess;

public abstract class ServerBTEManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ServerBTEManager.class);
    protected int mnCurrentBTEIndex = -1;
    protected String msBteMengeID;
    protected Vector<String> mcBtNummern = null;
    protected Vector<String> mcBtTypen = null;
    protected Stack<BtVerweis> mstBteVerweise = new Stack();
    protected CurrentBTE mCurrentBTE;

    protected abstract CurrentBTE createCurrentBTEInstanz(String var1, String var2, String var3, String var4, long var5, String var7, boolean var8, boolean var9, Boolean var10, Boolean var11, Bedingungsmenge var12, boolean var13, boolean var14) throws InvalidInitializationException, SQLException, DatabaseBusyException;

    protected abstract CurrentBTE createCurrentBTEInstanz(String var1, String var2, String var3, String var4, String var5, boolean var6, boolean var7, Boolean var8, Boolean var9, boolean var10, boolean var11) throws SQLException, DatabaseBusyException, InvalidInitializationException;

    public void setBTEMenge(Collection<String> cBtNummern, Collection<String> cBtArten) {
        this.mcBtNummern = new Vector<String>(cBtNummern);
        this.mcBtTypen = new Vector<String>(cBtArten);
        this.msBteMengeID = Long.toString(System.currentTimeMillis());
        this.mnCurrentBTEIndex = -1;
        this.mCurrentBTE = null;
        this.mstBteVerweise.clear();
        log.info("Reinitialising BTE set. New ID is: " + this.msBteMengeID);
    }

    public void clearBTEMenge() {
        this.mcBtNummern = null;
        this.mcBtTypen = null;
        this.mCurrentBTE = null;
        this.mnCurrentBTEIndex = -1;
        this.msBteMengeID = null;
        log.debug("BTE set has been cleared.");
    }

    public String thisBTE(String sLanguage, long lModellspalte, boolean bExpandBNB, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif, SucheInfo oSucheInfo, boolean bLoad, boolean bIGDOM) throws IndexOutOfBoundsException, SQLException, DatabaseBusyException, InvalidInitializationException {
        log.info("Retrieving next BTE for language <" + sLanguage + "> and Modellspalte <" + lModellspalte + ">.");
        try {
            String sBtNummer = this.mcBtNummern.get(this.mnCurrentBTEIndex);
            String sBtType = this.mcBtTypen.get(this.mnCurrentBTEIndex);
            String sMarke = oSucheInfo.getMarke();
            String sProduktart = oSucheInfo.getProduktart();
            String sKatalogumfang = oSucheInfo.getKatalogumfang();
            if (sBtType.equals("FZG")) {
                if (!(oSucheInfo instanceof FzgSucheInfo)) {
                    log.error("No FzgSucheInfo-Objekt found!");
                    throw new InvalidInitializationException("No FzgSucheInfo-Objekt found!");
                }
                FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
                this.mCurrentBTE = this.createCurrentBTEInstanz(sBtNummer, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLanguage, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, oFzgSucheInfo.getBedingungsMenge(), bLoad, bIGDOM);
            } else {
                this.mCurrentBTE = this.createCurrentBTEInstanz(sBtNummer, sMarke, sProduktart, sKatalogumfang, sLanguage, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, bLoad, bIGDOM);
            }
            log.info("The new current BTE is: " + sBtNummer);
            return sBtNummer;
        }
        catch (ClassCastException e) {
            log.error("FATAL ERROR: Invalid BTE number found in BTE set vector! Aborting.", e);
            throw new InvalidInitializationException(e.getMessage());
        }
    }

    public String nextBTE(String sLanguage, long lModellspalte, boolean bExpandBNB, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif, SucheInfo oSucheInfo, boolean bLoad, boolean bIGDOM) throws IndexOutOfBoundsException, SQLException, DatabaseBusyException, InvalidInitializationException {
        log.info("Retrieving next BTE for language <" + sLanguage + "> and Modellspalte <" + lModellspalte + ">.");
        int nMaxIndex = this.mcBtNummern.size() - 1;
        if (this.mnCurrentBTEIndex > nMaxIndex || ++this.mnCurrentBTEIndex > nMaxIndex) {
            log.debug("Last BTE reached. No further BTE available.");
            return null;
        }
        if (this.mnCurrentBTEIndex < 0) {
            log.error("Invalid index on BTE vector: " + Integer.toString(this.mnCurrentBTEIndex));
            throw new IndexOutOfBoundsException("BTE Index is invalid");
        }
        try {
            String sBtNummer = this.mcBtNummern.get(this.mnCurrentBTEIndex);
            String sBtType = this.mcBtTypen.get(this.mnCurrentBTEIndex);
            String sMarke = oSucheInfo.getMarke();
            String sProduktart = oSucheInfo.getProduktart();
            String sKatalogumfang = oSucheInfo.getKatalogumfang();
            if (sBtType.equals("FZG")) {
                if (!(oSucheInfo instanceof FzgSucheInfo)) {
                    log.error("No FzgSucheInfo-Objekt found!");
                    throw new InvalidInitializationException("No FzgSucheInfo-Objekt found!");
                }
                FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
                this.mCurrentBTE = this.createCurrentBTEInstanz(sBtNummer, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLanguage, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, oFzgSucheInfo.getBedingungsMenge(), bLoad, bIGDOM);
            } else {
                this.mCurrentBTE = this.createCurrentBTEInstanz(sBtNummer, sMarke, sProduktart, sKatalogumfang, sLanguage, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, bLoad, bIGDOM);
            }
            log.info("The new current BTE is: " + sBtNummer);
            return sBtNummer;
        }
        catch (ClassCastException e) {
            log.error("FATAL ERROR: Invalid BTE number found in BTE set vector! Aborting.", e);
            throw new InvalidInitializationException(e.getMessage());
        }
    }

    public String previousBTE(String sLanguage, long lModellspalte, boolean bExpandBNB, boolean bNachruestRelvant, Boolean bUSATyp, Boolean bVinIdentif, SucheInfo oSucheInfo, boolean bLoad, boolean bIGDOM) throws IndexOutOfBoundsException, SQLException, DatabaseBusyException, InvalidInitializationException {
        log.info("Retrieving previous BTE for language <" + sLanguage + "> and Modellspalte <" + lModellspalte + ">.");
        if (this.mnCurrentBTEIndex < 0 || --this.mnCurrentBTEIndex < 0) {
            log.debug("First BTE reached. No further BTE available.");
            return null;
        }
        if (this.mnCurrentBTEIndex >= this.mcBtNummern.size()) {
            log.error("Invalid index on BTE vector: " + Integer.toString(this.mnCurrentBTEIndex));
            throw new IndexOutOfBoundsException("BTE Index is invalid");
        }
        try {
            String sBtNummer = this.mcBtNummern.get(this.mnCurrentBTEIndex);
            String sBtType = this.mcBtTypen.get(this.mnCurrentBTEIndex);
            String sMarke = oSucheInfo.getMarke();
            String sProduktart = oSucheInfo.getProduktart();
            String sKatalogumfang = oSucheInfo.getKatalogumfang();
            if (sBtType.equals("FZG")) {
                if (!(oSucheInfo instanceof FzgSucheInfo)) {
                    log.error("No FzgSucheInfo-Objekt found!");
                    throw new InvalidInitializationException("No FzgSucheInfo-Objekt found!");
                }
                FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
                this.mCurrentBTE = this.createCurrentBTEInstanz(sBtNummer, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLanguage, bExpandBNB, bNachruestRelvant, bUSATyp, bVinIdentif, oFzgSucheInfo.getBedingungsMenge(), bLoad, bIGDOM);
            } else {
                this.mCurrentBTE = this.createCurrentBTEInstanz(sBtNummer, sMarke, sProduktart, sKatalogumfang, sLanguage, bExpandBNB, bNachruestRelvant, bUSATyp, bVinIdentif, bLoad, bIGDOM);
            }
            log.info("The new current BTE is: " + sBtNummer);
            return sBtNummer;
        }
        catch (ClassCastException e) {
            log.error("Invalid BTE number found in BTE set vector! Aborting.", e);
            throw new InvalidInitializationException(e.getMessage());
        }
    }

    public boolean hasNextBTE() {
        return this.mnCurrentBTEIndex < this.mcBtNummern.size() - 1;
    }

    public boolean hasPreviousBTE() {
        return this.mnCurrentBTEIndex > 0;
    }

    public boolean setCurrentBTE(String sBTE, String sLang, long lModellspalte, boolean bExpandBNB, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif, SucheInfo oSucheInfo, boolean bLoad, boolean bIGDOM) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        int nFoundIndex = -1;
        for (int nIndex = 0; nFoundIndex < 0 && nIndex < this.mcBtNummern.size(); ++nIndex) {
            String sBtNummer = this.mcBtNummern.get(nIndex);
            if (!sBTE.equals(sBtNummer)) continue;
            nFoundIndex = nIndex;
        }
        String sBtType = this.mcBtTypen.get(nFoundIndex);
        if (nFoundIndex < 0) {
            log.error("The requested BTE is not in the BTE-Set: " + sBTE);
            return false;
        }
        String sMarke = oSucheInfo.getMarke();
        String sProduktart = oSucheInfo.getProduktart();
        String sKatalogumfang = oSucheInfo.getKatalogumfang();
        if (sBtType.equals("FZG")) {
            if (!(oSucheInfo instanceof FzgSucheInfo)) {
                log.error("No FzgSucheInfo-Objekt found!");
                throw new InvalidInitializationException("No FzgSucheInfo-Objekt found!");
            }
            FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
            this.mCurrentBTE = this.createCurrentBTEInstanz(sBTE, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLang, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, oFzgSucheInfo.getBedingungsMenge(), bLoad, bIGDOM);
        } else {
            this.mCurrentBTE = this.createCurrentBTEInstanz(sBTE, sMarke, sProduktart, sKatalogumfang, sLang, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, bLoad, bIGDOM);
        }
        this.mnCurrentBTEIndex = nFoundIndex;
        log.info("Current BTE has been set to (" + sBTE + ") on index: " + Integer.toString(this.mnCurrentBTEIndex));
        return true;
    }

    public boolean setCurrentBTE(CurrentBTE oCurrentBTE) {
        this.mCurrentBTE = oCurrentBTE;
        return true;
    }

    public String getCurrentBTENr() {
        if (this.mCurrentBTE == null) {
            return null;
        }
        return this.mCurrentBTE.getBTENr();
    }

    public boolean aktualisierenBTEZeilen(SucheInfo oSucheInfo, Collection<String> cVisibleSachnummern, String sLandkuerzel) throws SQLException, DatabaseBusyException, IllegalArgumentException, InvalidDataException {
        if (this.mCurrentBTE == null) {
            return false;
        }
        if (oSucheInfo == null) {
            log.error("Invalid SucheInfo-Object! SucheInfo is null!");
            throw new IllegalArgumentException("No valid SucheInfo object given. It's null!");
        }
        this.mCurrentBTE.aktualisierenZeilen(oSucheInfo, cVisibleSachnummern, sLandkuerzel, true);
        this.mCurrentBTE.checkForSatzteile();
        this.mCurrentBTE.checkForSteckerteil();
        return true;
    }

    public Vector<AbstractZeile> getBTEZeilen() {
        if (this.mCurrentBTE == null) {
            return null;
        }
        return this.mCurrentBTE.getZeilen();
    }

    public BTEBedingungsmenge getBedingungsmenge() {
        if (this.mCurrentBTE == null) {
            return null;
        }
        return this.mCurrentBTE.getBedingungen();
    }

    public boolean validiere(String sID) {
        return sID.equals(this.toString());
    }

    public String toString() {
        return this.msBteMengeID;
    }

    public CurrentBTE getCurrentBTE() {
        return this.mCurrentBTE;
    }

    public Collection<Hotspot> getCurrentHotspots() throws SQLException, DatabaseBusyException, InvalidDataException {
        if (this.mCurrentBTE == null) {
            log.error("Can't load hotspots, because we have no current BTE!");
            throw new InvalidDataException("Can't load hotspots, because we have no current BTE!");
        }
        Collection<Hotspot> cHotspots = this.mCurrentBTE.getHotspots();
        if (cHotspots == null) {
            this.mCurrentBTE.loadHotspots();
            cHotspots = this.mCurrentBTE.getHotspots();
        }
        return cHotspots;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<Hotspot> loadHotspotsForBildId(long lBildId, String sFormfaktor) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Loading hotspots for  (" + lBildId + " / " + sFormfaktor + ") ...");
        ArrayList<Hotspot> cHotspots = new ArrayList<Hotspot>();
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("BTEManager.loadHotspotsForBildId");
            res = BteAnzeigeDbAccess.loadHotspots(con, lBildId, sFormfaktor);
            while (res.next()) {
                int nTLX = res.getInt("TopLeft_x");
                int nTLY = res.getInt("TopLeft_y");
                int nBRX = res.getInt("BottomRight_x");
                int nBRY = res.getInt("BottomRight_y");
                String sPnr = res.getString("Bildnummer");
                Hotspot oHotspot = new Hotspot(nTLX, nTLY, nBRX, nBRY, sPnr);
                cHotspots.add(oHotspot);
            }
        }
        catch (SQLException e) {
            try {
                log.error("Database error during loading of hotspots:" + e.getMessage(), e);
                throw e;
                catch (DatabaseBusyException e2) {
                    log.error("Database error during loading of hotspots:" + e2.getMessage(), e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "CurrentBTE.loadHotspots");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "CurrentBTE.loadHotspots");
        log.debug("Hotspots have been loaded for: (" + lBildId + " / " + sFormfaktor + ").");
        return cHotspots;
    }

    public CurrentBTE addVerweisBte(String sSourceBTE, String sDestBTE, String sLang, long lMosp, boolean bExpandBnb, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif, SucheInfo oSucheInfo, boolean bLoad, boolean bIGDOM) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        BtVerweis oNewVerweis = new BtVerweis(sSourceBTE, sDestBTE);
        oNewVerweis.setMbDestWasMember(this.mcBtNummern.contains(sDestBTE));
        if (!oNewVerweis.getMbDestWasMember()) {
            this.mcBtNummern.add(sDestBTE);
            if (lMosp == -1L) {
                this.mcBtTypen.add("ASS");
            } else {
                this.mcBtTypen.add("FZG");
            }
        }
        this.mstBteVerweise.push(oNewVerweis);
        this.setCurrentBTE(sDestBTE, sLang, lMosp, bExpandBnb, bNachruestRelevant, bUSATyp, bVinIdentif, oSucheInfo, bLoad, bIGDOM);
        return this.getCurrentBTE();
    }

    public CurrentBTE removeVerweisBte(String sLang, long lMosp, boolean bExpandBnb, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif, SucheInfo oSucheInfo, boolean bLoad, boolean bIGDOM) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        if (this.mstBteVerweise.empty()) {
            return this.getCurrentBTE();
        }
        BtVerweis oNewVerweis = this.mstBteVerweise.pop();
        if (!oNewVerweis.getMbDestWasMember()) {
            int nIndex = -1;
            String sDestBte = oNewVerweis.getMsDestBte();
            for (nIndex = 0; nIndex < this.mcBtNummern.size() && !sDestBte.equals(this.mcBtNummern.get(nIndex)); ++nIndex) {
            }
            if (nIndex >= 0) {
                this.mcBtNummern.remove(nIndex);
                this.mcBtTypen.remove(nIndex);
            } else {
                log.warn("Destination BTE <" + sDestBte + "> was not found in BTE set! Proceeding anyway.");
            }
        }
        this.setCurrentBTE(oNewVerweis.getMsSourceBte(), sLang, lMosp, bExpandBnb, bNachruestRelevant, bUSATyp, bVinIdentif, oSucheInfo, bLoad, bIGDOM);
        return this.getCurrentBTE();
    }

    public String getBTEType() {
        if (this.mCurrentBTE == null) {
            if (this.mcBtTypen != null && this.mcBtTypen.size() > 0) {
                return this.mcBtTypen.get(0);
            }
            return null;
        }
        return this.mCurrentBTE.getBTEType();
    }

    public boolean haveBteVerweise() {
        return !this.mstBteVerweise.empty();
    }

    protected static class BtVerweis {
        protected String msSourceBte;
        protected String msDestBte;
        protected boolean mbDestWasMember = false;

        public BtVerweis(String sSourceBTE, String sDestBTE) {
            this.msSourceBte = sSourceBTE;
            this.msDestBte = sDestBTE;
        }

        public String getMsSourceBte() {
            return this.msSourceBte;
        }

        public String getMsDestBte() {
            return this.msDestBte;
        }

        public boolean getMbDestWasMember() {
            return this.mbDestWasMember;
        }

        public void setMbDestWasMember(boolean aMbDestWasMember) {
            this.mbDestWasMember = aMbDestWasMember;
        }
    }
}

