/*
 * Decompiled with CFR 0.152.
 */
package webetk.framework;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.LanguageUtils;
import webetk.app.BTEBedingungsmenge;
import webetk.app.SearchBTETeile;
import webetk.app.SessionInfoDez;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.fzgid.FzgIdControlInfo;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.framework.ServerBTEManager;
import webetk.framework.ServerUserInfo;
import webetk.mrkprd.Marken;

public abstract class ServerSessionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(ServerSessionInfo.class);
    protected transient ResourceBundle bundle;
    private Object mTempValue;
    private String msBaseURL;
    protected ServerUserInfo mUserInfo;
    protected FzgIdInfo mFzgIdInfo;
    protected SucheInfo mSucheInfo;
    protected SearchBTETeile mSearchBTETeile;
    protected ServerBTEManager mBTEManager;
    protected Collection<String> maUserMarken = new Vector<String>();
    protected ArrayList<String> maMoeglProdukteZuUserMarken = new ArrayList();
    protected Collection<String> maUserProdukte = new Vector<String>();
    protected String msUserKatumfang = null;
    protected boolean mbHasRechtAnzeigeProddatum = false;
    protected FzgIdControlInfo mFzgIdControlInfo = null;
    protected boolean mbEinstellungenDisharmonie = false;
    private SessionInfoDez moSessionInfoDez = null;
    private Object mNewsObject;
    private boolean mbAusweisungenElementeAktiv = false;
    private boolean mbFiltern = true;

    protected abstract ServerBTEManager createBTEManagerInstanz();

    protected abstract ServerUserInfo createUserInfoInstanz();

    protected abstract FzgIdInfo createFzgIdInfoInstanz() throws InvalidInitializationException;

    public ServerSessionInfo() {
        log.debug("Initializing");
        this.mBTEManager = this.createBTEManagerInstanz();
        this.mUserInfo = this.createUserInfoInstanz();
        this.mFzgIdInfo = null;
        this.mSucheInfo = null;
        this.mTempValue = null;
        this.mSearchBTETeile = null;
    }

    public ServerUserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public void setUserInfo(ServerUserInfo oServerUserInfo) {
        this.mUserInfo = oServerUserInfo;
    }

    public Collection<String> getUserMarken() {
        return this.maUserMarken;
    }

    public void setUserMarken(Collection<String> userMarken) {
        this.maUserMarken = userMarken;
    }

    public ArrayList<String> getMoeglProdukteZuUserMarken() {
        return this.maMoeglProdukteZuUserMarken;
    }

    public Collection<String> getUserProdukte() {
        return this.maUserProdukte;
    }

    public void setUserProdukte(Collection<String> userProdukte) {
        this.maUserProdukte = userProdukte;
    }

    public String getUserKatUmfang() {
        if (this.maUserMarken != null) {
            for (String sMarke : this.maUserMarken) {
                if (sMarke == null || !sMarke.equals(Marken.getInstance().getMarke("BMW").getBerechtigung())) continue;
                return this.msUserKatumfang;
            }
        }
        return "VT";
    }

    public void setUserKatalogUmfang(String userKatumfang) {
        this.msUserKatumfang = userKatumfang;
    }

    public boolean hasRechtAnzeigeProddatum() {
        return this.mbHasRechtAnzeigeProddatum;
    }

    public FzgIdInfo newFzgIdInfo() {
        log.debug("Creating new object of class FzgIdInfo!");
        this.mFzgIdInfo = null;
        ServerUserInfo userInfo = this.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        try {
            this.mFzgIdInfo = this.createFzgIdInfoInstanz();
        }
        catch (InvalidInitializationException e) {
            log.error("Could not create a new object of class FzgIdInfo!", e);
            return null;
        }
        return this.mFzgIdInfo;
    }

    public FzgSucheInfo newFzgSucheInfo() {
        log.debug("Creating new object of class FzgSucheInfo!");
        this.mSucheInfo = null;
        this.mSucheInfo = new FzgSucheInfo();
        return (FzgSucheInfo)this.mSucheInfo;
    }

    public void setSucheInfo(SucheInfo oSucheInfo) {
        this.mSucheInfo = oSucheInfo;
    }

    public AssSucheInfo newAssSucheInfo() {
        log.debug("Creating new object of class AssSucheInfo!");
        this.mSucheInfo = null;
        this.mSucheInfo = new AssSucheInfo();
        return (AssSucheInfo)this.mSucheInfo;
    }

    public FzgIdInfo getFzgIdInfo() {
        return this.mFzgIdInfo;
    }

    public FzgSucheInfo getFzgSucheInfo() {
        if (this.mSucheInfo instanceof FzgSucheInfo) {
            return (FzgSucheInfo)this.mSucheInfo;
        }
        return null;
    }

    public AssSucheInfo getAssSucheInfo() {
        if (this.mSucheInfo instanceof AssSucheInfo) {
            return (AssSucheInfo)this.mSucheInfo;
        }
        return null;
    }

    public SucheInfo getSucheInfo() {
        return this.mSucheInfo;
    }

    public void setBaseURL(String sBaseURL) {
        this.msBaseURL = sBaseURL;
    }

    public String getBaseURL() {
        return this.msBaseURL;
    }

    public void setBTEMenge(Collection<String> cBtNummern, Collection<String> cBtTypen) throws IllegalArgumentException {
        this.mBTEManager.setBTEMenge(cBtNummern, cBtTypen);
    }

    public String thisBTE(boolean bLoad) throws IndexOutOfBoundsException, SQLException, DatabaseBusyException, InvalidInitializationException {
        Boolean bUSATyp = null;
        if (this.mFzgIdInfo != null) {
            String sRegion = this.mFzgIdInfo.getRegion();
            bUSATyp = sRegion != null && sRegion.equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bVinIdentif = null;
        FzgSucheInfo oFzgSucheInfo = this.getFzgSucheInfo();
        if (oFzgSucheInfo != null) {
            String sFgstNummer = oFzgSucheInfo.getFahrgestellnummer();
            bVinIdentif = sFgstNummer != null ? Boolean.TRUE : Boolean.FALSE;
        }
        SucheInfo oSucheInfo = this.getSucheInfo();
        boolean bIGDOM = oSucheInfo.isIGDOM();
        long lModellspalte = this.getAktuelleModellspalte();
        ServerUserInfo oUserInfo = this.getUserInfo();
        boolean bExpandBNB = oUserInfo.getDarstellungBNB();
        boolean bNachruestRelevant = oUserInfo.getNachruestungenRelevant();
        String sCurBteNr = this.mBTEManager.thisBTE(this.getAktuelleSprache(), lModellspalte, bExpandBNB, bNachruestRelevant, bUSATyp, bVinIdentif, oSucheInfo, bLoad, bIGDOM);
        return sCurBteNr;
    }

    public String nextBTE(String sCurrentLang, boolean bLoad) throws IndexOutOfBoundsException, SQLException, DatabaseBusyException, InvalidInitializationException {
        Boolean bUSATyp = null;
        if (this.mFzgIdInfo != null) {
            bUSATyp = this.mFzgIdInfo.getRegion() != null && this.mFzgIdInfo.getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bVinIdentif = null;
        if (this.getFzgSucheInfo() != null) {
            bVinIdentif = this.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean bIGDOM = this.getSucheInfo().isIGDOM();
        String sCurBteNr = this.mBTEManager.nextBTE(sCurrentLang, this.getAktuelleModellspalte(), this.getUserInfo().getDarstellungBNB(), this.getUserInfo().getNachruestungenRelevant(), bUSATyp, bVinIdentif, this.getSucheInfo(), bLoad, bIGDOM);
        return sCurBteNr;
    }

    public String previousBTE(String sCurrentLang, boolean bLoad) throws IndexOutOfBoundsException, SQLException, DatabaseBusyException, InvalidInitializationException {
        Boolean bUSATyp = null;
        if (this.mFzgIdInfo != null) {
            bUSATyp = this.mFzgIdInfo.getRegion() != null && this.mFzgIdInfo.getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bVinIdentif = null;
        if (this.getFzgSucheInfo() != null) {
            bVinIdentif = this.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean bIGDOM = this.getSucheInfo().isIGDOM();
        String sCurBteNr = this.mBTEManager.previousBTE(sCurrentLang, this.getAktuelleModellspalte(), this.getUserInfo().getDarstellungBNB(), this.getUserInfo().getNachruestungenRelevant(), bUSATyp, bVinIdentif, this.getSucheInfo(), bLoad, bIGDOM);
        return sCurBteNr;
    }

    public String getAktuelleSprache() {
        return LanguageUtils.toCompoundLanguage(this.mUserInfo.getSprache(), this.mUserInfo.getSpracheRegion());
    }

    public ServerBTEManager getBTEManager() {
        return this.mBTEManager;
    }

    public String getBTEMengeID() {
        return this.mBTEManager.toString();
    }

    public BTEBedingungsmenge getBTEBedMenge() {
        return this.mBTEManager.getBedingungsmenge();
    }

    public void resetFzgId() {
        this.mFzgIdInfo = null;
        this.mSucheInfo = null;
    }

    public void setFzgIdInfo(FzgIdInfo oFzgIdInfo) {
        this.mFzgIdInfo = oFzgIdInfo;
    }

    public void resetFzgSuche() {
        this.mSucheInfo = null;
    }

    public void resetAssSuche() {
        this.mSucheInfo = null;
    }

    public void setSelectedBTE(String sBteNr, boolean bLoad) throws InvalidDataException, SQLException, DatabaseBusyException, InvalidInitializationException {
        Boolean bUSATyp = null;
        if (this.mFzgIdInfo != null) {
            bUSATyp = this.mFzgIdInfo.getRegion() != null && this.mFzgIdInfo.getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bVinIdentif = null;
        if (this.getFzgSucheInfo() != null) {
            bVinIdentif = this.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean bIGDOM = this.getSucheInfo().isIGDOM();
        this.mBTEManager.setCurrentBTE(sBteNr, this.getAktuelleSprache(), this.getAktuelleModellspalte(), this.getUserInfo().getDarstellungBNB(), this.getUserInfo().getNachruestungenRelevant(), bUSATyp, bVinIdentif, this.getSucheInfo(), bLoad, bIGDOM);
    }

    protected long getAktuelleModellspalte() {
        FzgSucheInfo fzgSuche = this.getFzgSucheInfo();
        if (fzgSuche == null) {
            return -1L;
        }
        return fzgSuche.getModellspalte();
    }

    public void reset() {
        this.mTempValue = null;
        this.resetFzgId();
        this.mBTEManager = this.createBTEManagerInstanz();
        log.info("Session Information has been resetted!");
    }

    public CurrentBTE addVerweisBte(String sSourceBTE, String sDestBTE, boolean bLoad) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        Boolean bUSATyp = null;
        if (this.mFzgIdInfo != null) {
            bUSATyp = this.mFzgIdInfo.getRegion() != null && this.mFzgIdInfo.getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bVinIdentif = null;
        if (this.getFzgSucheInfo() != null) {
            bVinIdentif = this.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean bIGDOM = this.getSucheInfo().isIGDOM();
        return this.mBTEManager.addVerweisBte(sSourceBTE, sDestBTE, this.getAktuelleSprache(), this.getAktuelleModellspalte(), this.getUserInfo().getDarstellungBNB(), this.getUserInfo().getNachruestungenRelevant(), bUSATyp, bVinIdentif, this.getSucheInfo(), bLoad, bIGDOM);
    }

    public CurrentBTE removeVerweisBte(boolean bLoad) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        Boolean bUSATyp = null;
        if (this.mFzgIdInfo != null) {
            bUSATyp = this.mFzgIdInfo.getRegion() != null && this.mFzgIdInfo.getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean bVinIdentif = null;
        if (this.getFzgSucheInfo() != null) {
            bVinIdentif = this.getFzgSucheInfo().getFahrgestellnummer() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean bIGDOM = this.getSucheInfo().isIGDOM();
        return this.mBTEManager.removeVerweisBte(this.getAktuelleSprache(), this.getAktuelleModellspalte(), this.getUserInfo().getDarstellungBNB(), this.getUserInfo().getNachruestungenRelevant(), bUSATyp, bVinIdentif, this.getSucheInfo(), bLoad, bIGDOM);
    }

    public abstract void retrieveUserRechte(ServerUserInfo var1) throws SQLException, DatabaseBusyException;

    public FzgIdControlInfo getFzgIdControlInfo() {
        if (this.mFzgIdControlInfo == null) {
            return null;
        }
        FzgIdInfo oFzgIdSess = this.getFzgIdInfo();
        FzgIdInfo oFzgIdRef = this.mFzgIdControlInfo.getFzgIdInfo();
        if (oFzgIdRef == null || oFzgIdSess == null) {
            this.mFzgIdControlInfo = null;
            return null;
        }
        if (oFzgIdRef.toString().equals(oFzgIdSess.toString())) {
            return this.mFzgIdControlInfo;
        }
        this.mFzgIdControlInfo = null;
        return null;
    }

    public void setFzgIdControlInfo(FzgIdControlInfo fzgIdControlInfo) {
        this.mFzgIdControlInfo = fzgIdControlInfo;
    }

    public boolean isEinstellungenDisharmonie() {
        return this.mbEinstellungenDisharmonie;
    }

    public void setEinstellungenDisharmonie(boolean b) {
        this.mbEinstellungenDisharmonie = b;
    }

    public boolean doZentraleRecherche() {
        if (this.mUserInfo == null) {
            return false;
        }
        if (this.mUserInfo.mSettings.getSuchraum() == null || this.mUserInfo.mSettings.getSuchraum().equals("")) {
            return false;
        }
        return this.mUserInfo.mSettings.getSuchraum().equals("Z");
    }

    public void setTempValue(Object oValue) {
        this.mTempValue = oValue;
    }

    public Object getTempValue() {
        return this.mTempValue;
    }

    public Object getNewsObject() {
        return this.mNewsObject;
    }

    public void setNewsObject(Object object) {
        this.mNewsObject = object;
    }

    public void setSearchBTETeile(SearchBTETeile oSearchBTETeile) {
        this.mSearchBTETeile = oSearchBTETeile;
    }

    public SearchBTETeile getSearchBTETeile() {
        return this.mSearchBTETeile;
    }

    public void setAusweisungenElementeAktiv(boolean mbAusweisungenElementeAktiv) {
        this.mbAusweisungenElementeAktiv = mbAusweisungenElementeAktiv;
    }

    public boolean isAusweisungenElementeAktiv() {
        return this.mbAusweisungenElementeAktiv;
    }

    public boolean isDoFiltern() {
        return this.mbFiltern;
    }

    public void setDoFiltern(boolean doFiltern) {
        this.mbFiltern = doFiltern;
    }

    public void setMoSessionInfoDez(SessionInfoDez moSessionInfoDez) {
        this.moSessionInfoDez = moSessionInfoDez;
    }

    public SessionInfoDez getMoSessionInfoDez() {
        return this.moSessionInfoDez;
    }

    public String getCrntBndlETKLng() {
        Locale oLocale = this.bundle.getLocale();
        if (oLocale.equals(Locale.US)) {
            return "enUS";
        }
        if (oLocale.equals(Locale.SIMPLIFIED_CHINESE)) {
            return "zh";
        }
        if (oLocale.equals(Locale.TRADITIONAL_CHINESE)) {
            return "zhTW";
        }
        return oLocale.getLanguage();
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }
}

