/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.domsowu;

import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.app.ServerGlobalObjects;

public class CallSOWUWebService {
    private static Logger log = Logger.getLogger(CallSOWUWebService.class);
    private static Logger logTime = Logger.getLogger("time");
    private static String SOWU_INT_URL = "http://cicsd.muc:6996";
    private static String SOWU_PROD_URL = "http://cicsp.muc:6997";
    private static String authStringSOWUEncINT = "cXFlc293MDpoYW5zOGFtcA==";
    private static String authStringSOWUEncPROD = "cXFlc293MTp0ZXJtaW5hMQ==";
    private static final String loggerQuery = "INSERT INTO W_ETK_TIME_LOG (REQUESTED_URL,REQUESTED_PARAMETER,REQUESTED_TIME,REQUESTED_VIN,TIME_DURATION) VALUES (?,?,?,?,?)";

    private void createSoapEnvelope(SOAPMessage soapMessage, String vin, String lang) throws SOAPException {
        SOAPPart soapPart = soapMessage.getSOAPPart();
        String myNamespace = "p1n";
        String myNamespaceURI = "http://www.bmw.com/P1NPY9";
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration(myNamespace, myNamespaceURI);
        String fgnr7 = "";
        String fgnr10 = "";
        if (vin.length() == 17) {
            fgnr7 = vin.substring(10, 17);
            fgnr10 = vin.substring(0, 10);
        } else {
            fgnr7 = vin;
        }
        SOAPBody soapBody = envelope.getBody();
        SOAPElement soapBodyMainElem = soapBody.addChildElement("getSowuTextRequest", myNamespace);
        SOAPElement soapBodyElem = soapBodyMainElem.addChildElement("fgnr7");
        soapBodyElem.addTextNode(fgnr7);
        SOAPElement soapBodyElem1 = soapBodyMainElem.addChildElement("language");
        soapBodyElem1.addTextNode(lang);
        SOAPElement soapBodyElem2 = soapBodyMainElem.addChildElement("fgnr10");
        soapBodyElem2.addTextNode(fgnr10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String callSoapWebService(String soapEndpointUrl, String vin, String language) {
        String soapResp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("mm:ss:SSS");
        long time = -System.currentTimeMillis();
        try {
            String soapAction = "http://www.bmw.com/P1NPY9/getSowuText";
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            SOAPMessage soapResponse = soapConnection.call(this.createSOAPRequest(soapEndpointUrl, soapAction, vin, language), (Object)soapEndpointUrl);
            log.info("Response SOAP Message:");
            ByteOutputStream out = new ByteOutputStream();
            soapResponse.writeTo((OutputStream)out);
            soapResp = out.toString();
            soapConnection.close();
        }
        catch (Exception e) {
            log.error("\nError occurred while sending SOAP Request to Server!\nMake sure you have the correct endpoint URL and SOAPAction!\n");
            e.printStackTrace();
        }
        finally {
            logTime.debug("********* Dauer (" + soapEndpointUrl + "?vin=" + vin + "&language=" + language + ") *********:" + sdf.format(time += System.currentTimeMillis()));
            String requestedParam = "?vin=" + vin + "&language=" + language;
            if (ServerGlobalObjects.getInstance().isTimerDBLogginRequired()) {
                this.insertWebETKTimeLogInfo(soapEndpointUrl, requestedParam, sdf.format(time), vin);
            }
        }
        return soapResp;
    }

    private SOAPMessage createSOAPRequest(String soapEndpointUrl, String soapAction, String vin, String lang) throws Exception {
        String authStringEncSOWU = null;
        if (soapEndpointUrl.contains(SOWU_INT_URL)) {
            authStringEncSOWU = authStringSOWUEncINT;
        } else if (soapEndpointUrl.contains(SOWU_PROD_URL)) {
            authStringEncSOWU = authStringSOWUEncPROD;
        }
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        MimeHeaders hd = soapMessage.getMimeHeaders();
        hd.addHeader("Authorization", "Basic " + authStringEncSOWU);
        hd.addHeader("SOAPAction", "http://www.bmw.com/P1NPY9/getSowuText");
        this.createSoapEnvelope(soapMessage, vin, lang);
        MimeHeaders headers = soapMessage.getMimeHeaders();
        headers.addHeader("SOAPAction", soapAction);
        soapMessage.saveChanges();
        return soapMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertWebETKTimeLogInfo(String URL2, String param, String time, String VIN) {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        Statement ps = null;
        try {
            con = gObj.getDBConnection("WebETKTimerlog.insert");
            ps = con.prepareStatement(loggerQuery);
            ps.setString(1, URL2);
            ps.setString(2, param);
            ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            ps.setString(4, VIN);
            ps.setString(5, time);
            ps.executeUpdate();
        }
        catch (SQLException | DatabaseBusyException e) {
            log.error("Error during logging data in W_ETK_TIME_LOG: " + e.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error("Error during closig PreparedStatement Object: " + e.getMessage());
                }
                if (con != null) {
                    try {
                        gObj.freeDBConnection(con, "WebETKTimerlog.insert");
                    }
                    catch (SQLException e) {
                        log.error("Error during closing connection to W_ETK_TIME_LOG: " + e.getMessage());
                    }
                }
            }
        }
    }
}

