/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.domsowu;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import webetk.communication.utils.UrlEncodedQueryString;
import webetk.interfaces.domsowu.Manager;

public class VINResolverManager
extends Manager {
    private static Logger logger = Logger.getLogger(VINResolverManager.class);

    public VINResolverManager(String psEnv) {
        super(psEnv);
    }

    protected String getVINResolverInformation(String sServerUrl) throws IOException {
        return this.getVIN17Information(sServerUrl);
    }

    public String retrieveInfo(String sVINResolverUrl, String sVin) {
        URI uri;
        try {
            uri = new URI(sVINResolverUrl);
        }
        catch (URISyntaxException ex) {
            logger.error("Invalid ServerURL for VINResolver server: " + sVINResolverUrl + " - " + ex.getMessage(), ex);
            return null;
        }
        UrlEncodedQueryString ueqs = UrlEncodedQueryString.parse(uri);
        ueqs.append("vin", sVin);
        uri = ueqs.apply(uri);
        logger.info("Accessing VINResolver using URL: " + uri.toString());
        try {
            return this.getVINResolverInformation(uri.toString());
        }
        catch (IOException ex) {
            logger.error("Communication to VINResolver server failed: " + ex.getMessage(), ex);
            return null;
        }
    }
}

