/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.domsowu;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import webetk.communication.utils.UrlEncodedQueryString;
import webetk.interfaces.dom.basic.VehicleBasic;
import webetk.interfaces.domsowu.Manager;

public class VehicleBasicManager
extends Manager {
    private static Logger logger = Logger.getLogger(VehicleBasicManager.class);

    public VehicleBasicManager(String psEnv) {
        super(psEnv);
    }

    protected VehicleBasic getDomVehicleInformation(String sServerUrl) throws JAXBException, IOException {
        return (VehicleBasic)this.getInformation(VehicleBasic.class, sServerUrl);
    }

    public VehicleBasic retrieveInfo(String sServerUrl, String sVin, String sAsapSessId) {
        URI uri;
        try {
            uri = new URI(sServerUrl);
        }
        catch (URISyntaxException ex) {
            logger.error("Invalid ServerURL for DOM server: " + sServerUrl + " - " + ex.getMessage(), ex);
            return null;
        }
        UrlEncodedQueryString ueqs = UrlEncodedQueryString.parse(uri);
        ueqs.append("vin", sVin);
        ueqs.append("version", "06.01");
        if (sAsapSessId != null) {
            ueqs.append("PSESSID", sAsapSessId);
        }
        uri = ueqs.apply(uri);
        logger.info("Accessing DOM Basics using URL: " + uri.toString());
        try {
            return this.getDomVehicleInformation(uri.toString());
        }
        catch (IOException ex) {
            logger.error("Communication to DOM server failed: " + ex.getMessage(), ex);
            return null;
        }
        catch (JAXBException ex) {
            logger.error("Invalid response from DOM server. Parsing failed: " + ex.getMessage(), ex);
            return null;
        }
    }
}

