/*
 * Decompiled with CFR 0.152.
 */
package webetk.interfaces.sowu;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import webetk.interfaces.sowu.SowuVO;

public class SowuSOAPVO {
    private static Logger log = Logger.getLogger(SowuVO.class);
    private Collection<String> textZeilen = null;
    private String messageCode = null;
    private String messageText = null;

    public SowuSOAPVO(String soapResp) {
        if (soapResp == null) {
            log.warn("Initialization with empty data! (data was null)!");
            return;
        }
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(soapResp)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.error("Exception occured while converting SOWU response to xml:::" + e.getMessage());
            e.printStackTrace();
        }
        NodeList respNode = doc.getElementsByTagName("response");
        if (respNode.getLength() > 0) {
            Element resp = (Element)respNode.item(0);
            String messageCode = resp.getElementsByTagName("messageCode").item(0).getTextContent();
            String message = resp.getElementsByTagName("message").item(0).getTextContent();
            if (messageCode.equals("0000") && message.trim().isEmpty()) {
                Boolean nrFlag = false;
                this.textZeilen = new Vector<String>();
                log.info("Individual Vehicle Data exists for VIN");
                NodeList tabTextNodeList = doc.getElementsByTagName("tabText");
                if (tabTextNodeList.getLength() > 0) {
                    for (int i = 0; i < tabTextNodeList.getLength(); ++i) {
                        Node node = tabTextNodeList.item(i);
                        if (node.getNodeType() != 1 || node == null) continue;
                        Element eElement = (Element)node;
                        String text = eElement.getElementsByTagName("text").item(0).getTextContent();
                        String nr = eElement.getElementsByTagName("nr").item(0).getTextContent();
                        nrFlag = nr.trim().isEmpty() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                        if (nrFlag.booleanValue() && this.textZeilen.size() > 0) {
                            this.textZeilen.add("");
                        }
                        this.textZeilen.add(text);
                    }
                    System.out.println("Text Message...." + this.textZeilen);
                }
            } else {
                log.info("No Individual Vehicle Data exists for VIN");
                this.messageCode = messageCode;
                this.messageText = message;
            }
        }
    }

    public Collection<String> getTextZeilen() {
        return this.textZeilen;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public String getMessageText() {
        return this.messageText;
    }
}

