/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaserver.app;

import com.bmw.etk.Proxy;
import ibaseDip.service.Dip;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.app.BmwNetz;
import webetk.app.ServerGlobalObjects;
import webetk.communication.transferables.ServiceExecutor;

public class GlobalObjects {
    protected Logger log = Logger.getLogger(GlobalObjects.class);
    private static GlobalObjects GlobalObjectsInstance = null;
    private static Boolean m_bSyncInit = new Boolean(false);
    private Properties properties;
    private ServletContext m_objContext;
    private boolean isIsis;
    private boolean igdomAccess = true;
    private Dip dipInstance = null;
    private String sPropFileRead = null;
    private final ServiceExecutor mServiceExecutor = new ServiceExecutor();

    private GlobalObjects(String sPropFile, ServletContext p_objContext) throws FileNotFoundException, IOException, InvalidInitializationException {
        String igdomAccessPropVal;
        this.m_objContext = p_objContext;
        this.loadProperties(sPropFile);
        this.isIsis = false;
        String isIsisPropVal = this.properties.getProperty("is.isis");
        if (isIsisPropVal != null) {
            if (isIsisPropVal.compareToIgnoreCase("true") == 0) {
                try {
                    String wsmCacheMax = this.properties.getProperty("wsm.cache.max");
                    this.log.debug("initialize dip-caching for [min]: " + wsmCacheMax);
                    this.dipInstance = Dip.getInstance(wsmCacheMax);
                    this.dipInstance.initAgent();
                }
                catch (Exception e) {
                    this.log.fatal("no wsm-access.", e);
                    throw new InvalidInitializationException(e.getMessage());
                }
                this.isIsis = true;
            }
        } else {
            System.out.println("Error: Property is.isis not found in property file " + sPropFile);
            System.out.println("Using properties as if 'is.isis=false'");
        }
        this.igdomAccess = this.isIsis ? (igdomAccessPropVal = this.properties.getProperty("igdom.access")) != null && igdomAccessPropVal.compareToIgnoreCase("true") == 0 : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalObjects getInstance(ServletContext servletContext) {
        Boolean bl = m_bSyncInit;
        synchronized (bl) {
            if (GlobalObjectsInstance == null) {
                String sJavaPropFile = "javaclient.properties";
                if (servletContext != null) {
                    sJavaPropFile = servletContext.getInitParameter("JavaClientPropertyFileName");
                    System.out.println("Java-Propertyfile is: " + sJavaPropFile);
                    if (sJavaPropFile == null) {
                        System.out.println("FATAL: The filename for the Java-property file for WebETK is missing!");
                        sJavaPropFile = "javaclient.properties";
                    }
                }
                try {
                    GlobalObjectsInstance = new GlobalObjects(sJavaPropFile, servletContext);
                }
                catch (Exception e) {
                    System.out.println("FATAL: Initialization of GlobalObjects failed! Reason: " + e.getMessage());
                    e.printStackTrace(System.out);
                    return null;
                }
                Logger.getLogger(GlobalObjects.class).info("Instance of GlobalObjects created.");
            }
        }
        return GlobalObjectsInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalObjects getInstance(String sJavaPropDatei) {
        Boolean bl = m_bSyncInit;
        synchronized (bl) {
            if (GlobalObjectsInstance == null) {
                if (sJavaPropDatei == null) {
                    sJavaPropDatei = "javaclient.properties";
                }
                System.out.println("Java-Propertyfile is: " + sJavaPropDatei);
                try {
                    GlobalObjectsInstance = new GlobalObjects(sJavaPropDatei, null);
                }
                catch (Exception e) {
                    System.out.println("FATAL: Initialization of GlobalObjects failed! Reason: " + e.getMessage());
                    e.printStackTrace(System.out);
                    return null;
                }
                Logger.getLogger(GlobalObjects.class).info("Instance of GlobalObjects created.");
            }
        }
        return GlobalObjectsInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalObjects getInstance() {
        Boolean bl = m_bSyncInit;
        synchronized (bl) {
            if (GlobalObjectsInstance == null) {
                String sJavaPropDatei = "javaclient.properties";
                System.out.println("Java Propertyfile is: " + sJavaPropDatei);
                try {
                    GlobalObjectsInstance = new GlobalObjects(sJavaPropDatei, null);
                }
                catch (Exception e) {
                    System.out.println("FATAL: Initialization of GlobalObjects failed! Reason: " + e.getMessage());
                    e.printStackTrace(System.out);
                    return null;
                }
                Logger.getLogger(GlobalObjects.class).info("Instance of GlobalObjects created.");
            }
        }
        return GlobalObjectsInstance;
    }

    protected long getSessionTimeoutInMillis() {
        return ServerGlobalObjects.getInstance().getSessionTimeout() * 1000;
    }

    private void loadProperties(String sPropFile) throws FileNotFoundException, IOException {
        String strPropFile = sPropFile;
        if (this.m_objContext != null) {
            strPropFile = this.m_objContext.getRealPath(strPropFile);
        }
        this.sPropFileRead = strPropFile;
        System.out.println("Real path of Propertyfile is: " + sPropFile);
        this.properties = new Properties();
        try (FileInputStream streamIn = null;){
            streamIn = new FileInputStream(strPropFile);
            this.properties.load(streamIn);
        }
    }

    public String getIsoCountryCodeIsis() {
        String isoCountryCodeIsis = null;
        isoCountryCodeIsis = this.isIsis ? this.dipInstance.getCountryCode() : this.properties.getProperty("test.isocountrycodeisis");
        return isoCountryCodeIsis;
    }

    public String getXmlDmsSchemaUrl() {
        return this.properties.getProperty("xmldms.schemaurl");
    }

    public String getXmlVinSpecSchemaUrl() {
        return this.properties.getProperty("xmlvin.schemaurl");
    }

    public String getDmsDsquitcodesFilename() {
        return this.properties.getProperty("dms.dsquitcodes.filename");
    }

    public BmwNetz getCentralServerSettings() throws SQLException, DatabaseBusyException {
        BmwNetz oBmwNetz = new BmwNetz();
        if (!this.isIsis) {
            this.log.debug("load setting from db since isIsis=" + this.isIsis);
            oBmwNetz.load();
        } else if (this.igdomAccess) {
            this.furnishBmwNetz(oBmwNetz);
        } else {
            this.log.debug("(getCentralServerSettings) igdom zugriff deaktiviert da igdomAccess=" + this.igdomAccess);
            oBmwNetz.setIGDOMBasicsServerUrl(null);
            oBmwNetz.setIGDOMOptionsServerUrl(null);
        }
        return oBmwNetz;
    }

    public BmwNetz getCIGDOMSettings() throws SQLException, DatabaseBusyException {
        BmwNetz oBmwNetz = new BmwNetz();
        if (this.igdomAccess) {
            if (!this.isIsis) {
                this.log.debug("hole urls aus db da igdomAccess=" + this.igdomAccess + " und isIsis=" + this.isIsis);
                oBmwNetz.load();
            } else {
                this.log.debug("hole urls vom ScoreBroker da igdomAccess=" + this.igdomAccess + " und isIsis=" + this.isIsis);
                this.furnishBmwNetz(oBmwNetz);
            }
        } else {
            this.log.debug("igdom zugriff deaktiviert da igdomAccess=" + this.igdomAccess);
            oBmwNetz.setIGDOMBasicsServerUrl(null);
            oBmwNetz.setIGDOMOptionsServerUrl(null);
        }
        return oBmwNetz;
    }

    private void furnishBmwNetz(BmwNetz oBmwNetz) {
        String domBasicExtension = this.properties.getProperty("dom.basic.extension");
        String domOptionsExtension = this.properties.getProperty("dom.options.extension");
        String zrExtension = this.properties.getProperty("zr.extension");
        String domBasicUrlString = this.dipInstance.retrieveSystemURL("domBasicUrl");
        this.log.info("domBasicUrl = ScoreBroker: " + domBasicUrlString + " + Property dom.basic.extension: " + domBasicExtension);
        this.log.info("domOptionsUrl = ScoreBroker: " + domBasicUrlString + " +  Property dom.options.extension: " + domOptionsExtension);
        String zrUrlString = this.dipInstance.retrieveSystemURL("zrUrl");
        this.log.info("zrUrl = ScoreBroker: " + zrUrlString + " +  Property zr.extension: " + zrExtension);
        oBmwNetz.setIGDOMBasicsServerUrl(domBasicUrlString + domBasicExtension);
        oBmwNetz.setIGDOMOptionsServerUrl(domBasicUrlString + domOptionsExtension);
        oBmwNetz.setCentralServerUrl(zrUrlString + zrExtension);
    }

    public void setIgdomAccess(boolean igdomAccessNew) {
        this.log.debug("set igdomAccess new: " + igdomAccessNew + " current: " + this.igdomAccess);
        if (igdomAccessNew != this.igdomAccess) {
            this.igdomAccess = igdomAccessNew;
            this.storeIgdomAccess();
        }
        this.igdomAccess = igdomAccessNew;
    }

    public boolean isIgdomAccess() {
        this.log.debug("return igdomAccess: " + this.igdomAccess);
        return this.igdomAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCodeFuehrtZumAbbruch(int nCode) {
        String sCode = String.valueOf(nCode);
        String sFileName = this.getDmsDsquitcodesFilename();
        if (sFileName != null) {
            BufferedReader reader = null;
            try {
                if (this.m_objContext != null) {
                    sFileName = this.m_objContext.getRealPath(sFileName);
                }
                reader = new BufferedReader(new FileReader(sFileName));
                String sLine = reader.readLine();
                while (sLine != null) {
                    if (sLine.indexOf(sCode) > -1) {
                        boolean bl = false;
                        return bl;
                    }
                    sLine = reader.readLine();
                }
            }
            catch (FileNotFoundException ex) {
                this.log.error("could not find file for errorcodes", ex);
            }
            catch (IOException ex) {
                this.log.error("could not read file for errorcodes", ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        this.log.error("could not close file for errorcodes", ex);
                    }
                }
            }
        }
        return true;
    }

    public String getRealPath(String sFileName) {
        if (this.m_objContext == null) {
            return sFileName;
        }
        return this.m_objContext.getRealPath(sFileName);
    }

    public boolean isIsis() {
        return this.isIsis;
    }

    public int getTimeoutSocket() {
        String sTimeout = this.properties.getProperty("timeout.socket", "600");
        if (sTimeout == null || sTimeout.length() < 1) {
            return 0;
        }
        return Integer.parseInt(sTimeout);
    }

    public String getTickerVerzeichnis() {
        return this.properties.getProperty("ticker.dir");
    }

    public int getTimeoutConnection() {
        String sTimeout = this.properties.getProperty("timeout.connection", "15");
        if (sTimeout == null || sTimeout.length() < 1) {
            return 0;
        }
        return Integer.parseInt(sTimeout);
    }

    public String getMarkeTeilRepraesentant(Collection aMarkenTeil, Collection aMarkenUser, String sMarkeEinstellungen) {
        if (aMarkenTeil.size() == 1) {
            return (String)aMarkenTeil.toArray()[0];
        }
        Vector<String> aMarkenSM = new Vector<String>();
        for (String sHelp1 : aMarkenTeil) {
            for (String sHelp2 : aMarkenUser) {
                if (!sHelp1.equalsIgnoreCase(sHelp2)) continue;
                aMarkenSM.add(sHelp1);
            }
        }
        if (aMarkenSM.size() == 1) {
            return (String)aMarkenSM.toArray()[0];
        }
        return sMarkeEinstellungen;
    }

    private void storeIgdomAccess() {
        this.log.debug("store properties to: " + this.sPropFileRead + " igdomAccess is now: " + this.igdomAccess);
        try {
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.sPropFileRead)));
            String szLine = in.readLine();
            while (szLine != null) {
                if ((szLine = szLine.trim()).startsWith("igdom.access")) {
                    szLine = "igdom.access = " + (this.isIgdomAccess() ? "true" : "false");
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.sPropFileRead)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public String getSowuConnection() {
        if (this.isIsis) {
            return "1";
        }
        String sRes = this.properties.getProperty("sowu.connection", "0");
        return sRes;
    }

    public String getXmlDmsServerUrl() {
        String xmlDmsServerUrl = this.isIsis ? this.dipInstance.getDmsServerUrl() : this.properties.getProperty("xmldms.serverurl");
        return xmlDmsServerUrl;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceExecutor getServiceExecutor() {
        String currentCentralServerUrl;
        BmwNetz bmwNetz;
        try {
            bmwNetz = this.getCentralServerSettings();
            currentCentralServerUrl = bmwNetz.getCentralServerUrl();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (DatabaseBusyException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ServiceExecutor serviceExecutor = this.mServiceExecutor;
        synchronized (serviceExecutor) {
            if (!(currentCentralServerUrl == null || this.mServiceExecutor.isInitialized() && this.mServiceExecutor.getServerUrl().equals(currentCentralServerUrl))) {
                this.log.info("connection Rest API Client to server: " + currentCentralServerUrl);
                Proxy proxySettings = new Proxy();
                proxySettings.setUseProxy(bmwNetz.getProxyName() != null && !bmwNetz.getProxyName().isEmpty());
                proxySettings.setProxyName(bmwNetz.getProxyName());
                proxySettings.setProxyPort(bmwNetz.getProxyPort());
                proxySettings.setUseAuthentication(bmwNetz.getProxyUserName() != null && !bmwNetz.getProxyUserName().isEmpty());
                proxySettings.setProxyUser(bmwNetz.getProxyUserName());
                proxySettings.setProxyPasswort(bmwNetz.getProxyPasswort());
                proxySettings.setUseNTLMAuthentication(bmwNetz.getProxyNtDomain() != null && !bmwNetz.getProxyNtDomain().isEmpty());
                proxySettings.setProxyNtDomain(bmwNetz.getProxyNtDomain());
                this.mServiceExecutor.init(currentCentralServerUrl, false, true, proxySettings);
            }
            return this.mServiceExecutor;
        }
    }
}

