/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaserver.framework;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgid.FzgIdInfo;
import webetk.db.dbaccess.AllgemeinDbAccess;
import webetk.db.dbaccess.SettingsDbAccess;
import webetk.framework.ServerBTEManager;
import webetk.framework.ServerSessionInfo;
import webetk.framework.ServerUserInfo;
import webetk.javaserver.app.GlobalObjects;
import webetk.javaserver.framework.UserInfo;
import webetk.javaserver.pl.BTEManager;
import webetk.mrkprd.Marken;
import webetk.mrkprd.MarkenProdukte;
import webetk.mrkprd.Produkte;

public class SessionInfo
extends ServerSessionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sessionId = null;
    private boolean mbDMSVerwenden = false;
    private boolean mbDMSAngeschlossen = false;
    private boolean mbVINSpecAngeschlossen = false;
    private boolean mbVINSpecVerwenden = false;
    private boolean mbIGDOMAngeschlossen = false;
    private boolean mbIGDOMVerwenden = false;
    private String msSachnummerSuch = null;
    private String asapUserId;
    private String asapSessionId;

    public SessionInfo(String sSessionId) {
        Logger.getLogger(SessionInfo.class).debug("Initializing");
        this.mbDMSVerwenden = false;
        this.mbVINSpecAngeschlossen = false;
        this.mbVINSpecVerwenden = false;
        this.mbIGDOMAngeschlossen = false;
        this.mbIGDOMVerwenden = false;
        this.mUserInfo = new UserInfo();
        this.sessionId = sSessionId;
        this.msSachnummerSuch = null;
    }

    public String getId() {
        return this.sessionId;
    }

    public boolean getDMSVerwenden() {
        return this.mbDMSVerwenden;
    }

    public void setDMSVerwenden(boolean bDMSVerwenden) {
        this.mbDMSVerwenden = bDMSVerwenden;
    }

    public boolean getDMSAngschlossen() {
        return this.mbDMSAngeschlossen;
    }

    public void setDMSAngeschlossen(boolean bDMSAngeschlossen) {
        this.mbDMSAngeschlossen = bDMSAngeschlossen;
    }

    public boolean getVINSpecAngschlossen() {
        return this.mbVINSpecAngeschlossen;
    }

    public void setVINSpecAngeschlossen(boolean bVINSpecAngeschlossen) {
        this.mbVINSpecAngeschlossen = bVINSpecAngeschlossen;
    }

    public boolean getVINSpecVerwenden() {
        return this.mbVINSpecVerwenden;
    }

    public void setVINSpecVerwenden(boolean bVINSpecVerwenden) {
        this.mbVINSpecVerwenden = bVINSpecVerwenden;
    }

    public boolean getIGDOMAngeschlossen() {
        return this.mbIGDOMAngeschlossen;
    }

    public void setIGDOMAngeschlossen(boolean bIGDOMAngeschlossen) {
        this.mbIGDOMAngeschlossen = bIGDOMAngeschlossen;
    }

    public boolean getIGDOMVerwenden() {
        return this.mbIGDOMVerwenden;
    }

    public void setIGDOMVerwenden(boolean bIGDOMVerwenden) {
        this.mbIGDOMVerwenden = bIGDOMVerwenden;
    }

    public UserInfo getPlUserInfo() {
        return (UserInfo)this.mUserInfo;
    }

    public void loadUser(String sFirmaId, String sFiliald, String sUsername) throws SQLException, DatabaseBusyException {
        this.mUserInfo = new UserInfo();
        if (!this.mUserInfo.initWithID(sFirmaId, sFiliald, sUsername)) {
            Logger.getLogger(SessionInfo.class).info("Could not find settings for user in database:" + sUsername);
        }
    }

    @Override
    protected ServerUserInfo createUserInfoInstanz() {
        return new UserInfo();
    }

    @Override
    protected ServerBTEManager createBTEManagerInstanz() {
        return new BTEManager();
    }

    @Override
    protected FzgIdInfo createFzgIdInfoInstanz() throws InvalidInitializationException {
        return new FzgIdInfo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveUserRechte(ServerUserInfo oUser) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        Vector<String> objRechte = new Vector<String>();
        try {
            con = gObj.getDBConnectionNutzer("SessionInfo.retrieveUserRechte");
            this.maUserMarken = new Vector();
            this.maUserProdukte = new Vector();
            this.msUserKatumfang = null;
            if (oUser != null) {
                Iterator iter;
                res = SettingsDbAccess.loadUserBerechtigungen(con, oUser.getFirmaID(), oUser.getID());
                while (res != null && res.next()) {
                    String sArt = res.getString("Art");
                    String sWert = res.getString("Wert");
                    if (sArt.equals("Marke")) {
                        if (Marken.getInstance().getEigenschaften("marke.berechtigung").contains(sWert)) {
                            this.maUserMarken.add(sWert);
                        } else {
                            throw new SQLException("keine g\u00fcltige Markenberechtigung " + sWert);
                        }
                    }
                    if (sArt.equals("Produktart")) {
                        if (Produkte.getInstance().getEigenschaften("produkt.berechtigung").contains(sWert)) {
                            this.maUserProdukte.add(sWert);
                        } else {
                            throw new SQLException("keine g\u00fcltige Produktberechtigung " + sWert);
                        }
                    }
                    if (sArt.equals("Katalogumfang")) {
                        String string = this.msUserKatumfang = this.msUserKatumfang != null && !this.msUserKatumfang.equals(sWert) ? "ALLE" : sWert;
                    }
                    if (!sArt.equalsIgnoreCase("ProdDatum")) continue;
                    this.mbHasRechtAnzeigeProddatum = sWert != null && sWert.equals("J");
                }
                this.maMoeglProdukteZuUserMarken = MarkenProdukte.ermittleMoeglicheProdukteZuUserMarken(this.maUserMarken);
                String sEinstellungenMarke = this.getUserInfo().getMarke();
                if (!this.maUserMarken.contains(sEinstellungenMarke) && (iter = this.maUserMarken.iterator()).hasNext()) {
                    String sUserMarke = (String)iter.next();
                    this.getUserInfo().setMarke(sUserMarke);
                }
                if (!this.maUserMarken.contains(Marken.getInstance().getMarke("BMW").getBerechtigung())) {
                    this.maUserProdukte.clear();
                    this.maUserProdukte.add(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
                    this.msUserKatumfang = "VT";
                }
                if (!this.maUserProdukte.isEmpty() && this.maUserProdukte.size() == 1) {
                    String sProdukt = (String)this.maUserProdukte.iterator().next();
                    if (!this.getUserInfo().getProduktart().equals(sProdukt)) {
                        this.getUserInfo().setProduktart(sProdukt);
                    }
                }
                if (!this.msUserKatumfang.equals("ALLE")) {
                    if (this.msUserKatumfang.equals("VT")) {
                        this.msUserKatumfang = "VT";
                    } else if (this.msUserKatumfang.equals("ST")) {
                        this.msUserKatumfang = "ST";
                    } else {
                        throw new SQLException("keine g\u00fcltige Katalogumfangberechtigung " + this.msUserKatumfang);
                    }
                    String sEinstellungenKatumfang = this.getUserInfo().getProduktart();
                    if (!sEinstellungenKatumfang.equals(this.msUserKatumfang)) {
                        this.getUserInfo().setKatalogumfang(this.msUserKatumfang);
                    }
                }
                res = SettingsDbAccess.loadUserRechte(con, oUser.getID(), oUser.getFirmaID());
                while (res != null && res.next()) {
                    String sRecht = res.getString("RechtId");
                    objRechte.add(sRecht);
                }
                if (objRechte.contains("R_WEBETK_ALLE")) {
                    objRechte = null;
                }
                oUser.setRechte(objRechte);
                WebetkUtils.closeQuery(res);
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "SessionInfo.retrieveUserRechte");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int[] loadMarktAndDealerType() {
        if (!GlobalObjects.getInstance().isIsis()) {
            ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
            Connection con = null;
            int[] data = null;
            Logger.getLogger(SessionInfo.class).info("loadMarktAndDealerType()");
            con = gObj.getDBConnectionNutzer("SessionInfo.loadMarktAndDealerType()");
            int[] nArray = data = AllgemeinDbAccess.loadMarktAndDealer(con);
            try {
                gObj.freeDBConnectionNutzer(con, "SessionInfo.loadMarktAndDealerType()");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return nArray;
            catch (DatabaseBusyException ex) {
                System.out.println("Error: " + ex);
                try {
                    gObj.freeDBConnectionNutzer(con, "SessionInfo.loadMarktAndDealerType()");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException ex2) {
                System.out.println("Error: " + ex2);
                {
                    catch (Throwable throwable) {
                        try {
                            gObj.freeDBConnectionNutzer(con, "SessionInfo.loadMarktAndDealerType()");
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    gObj.freeDBConnectionNutzer(con, "SessionInfo.loadMarktAndDealerType()");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTeilenotizen(ServerUserInfo oUser) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("SessionInfo.deleteTeilenotizen");
            SettingsDbAccess.deleteTeilenotizen(con, oUser.getFirmaID(), oUser.getID());
            WebetkUtils.closeQuery(res);
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "SessionInfo.retrieveUserRechte");
        }
    }

    public String getSachnummerSuch() {
        return this.msSachnummerSuch;
    }

    public void setSachnummerSuch(String sSachnummer) {
        this.msSachnummerSuch = sSachnummer;
    }

    public void setAsapUserId(String asapUserId) {
        this.asapUserId = asapUserId;
    }

    public String getAsapUserId() {
        return this.asapUserId;
    }

    public void setAsapSessionId(String asapSessionId) {
        this.asapSessionId = asapSessionId;
    }

    public String getAsapSessionId() {
        return this.asapSessionId;
    }
}

