/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaserver.servlet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import webetk.app.ServerGlobalObjects;
import webetk.javaserver.app.GlobalObjects;
import webetk.javaserver.framework.SessionInfo;

public class BaseServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(BaseServlet.class);
    protected ServerGlobalObjects m_objGlobal = null;
    protected GlobalObjects m_objJavaGlobal = null;

    protected SessionInfo getSessionInfo(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.info("No current session.");
            return null;
        }
        return (SessionInfo)session.getAttribute("sessInfo");
    }

    protected SessionInfo createNewSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String sSessionID = session.getId();
        log.debug("New Session ID created: " + sSessionID);
        SessionInfo sessInfo = new SessionInfo(sSessionID);
        session.setAttribute("sessInfo", (Object)sessInfo);
        log.info("Session has been successfully created: " + sSessionID);
        return sessInfo;
    }

    public void init() throws ServletException {
        String sLog4JProps = this.getServletContext().getRealPath(this.getServletContext().getInitParameter("Log4JConfigurationFile"));
        PropertyConfigurator.configure(sLog4JProps);
        log = Logger.getLogger(BaseServlet.class);
        log.error("starting ETK Server");
        log.debug("Log4J initialized.");
        log.debug("Creating server global objects...");
        this.m_objGlobal = ServerGlobalObjects.getInstance(this.getServletContext());
        if (this.m_objGlobal == null) {
            log.fatal("Could not create instance of ServerGlobalObjects!");
            throw new ServletException();
        }
        log.info("Server global objects created.");
        this.m_objJavaGlobal = GlobalObjects.getInstance(this.getServletContext());
        if (this.m_objJavaGlobal == null) {
            log.fatal("Could not create instance of GlobalObjects!");
            throw new ServletException();
        }
        log.debug("Servlet initialized.");
    }
}

