/*
 * Decompiled with CFR 0.152.
 */
package webetk.mrkprd;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import webetk.mrkprd.InvalidPropertieException;
import webetk.mrkprd.Marke;
import webetk.mrkprd.MarkenProperties;

public class Marken {
    private static Logger log = Logger.getLogger(Marken.class);
    private static Marken instance = null;
    private List<Marke> lMarken = new ArrayList<Marke>();

    private Marken() {
        this.load();
    }

    public static Marken getInstance() {
        if (instance == null) {
            instance = new Marken();
        }
        return instance;
    }

    private void load() {
        MarkenProperties mrkProps = new MarkenProperties();
        Properties props = mrkProps.getMarkenProperties();
        if (props.isEmpty()) {
            try {
                throw new InvalidPropertieException("### Keine Marken-Informationen/-Properties vorhanden! ###");
            }
            catch (InvalidPropertieException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                log.fatal(e.getMessage(), e);
                System.exit(-999);
            }
        }
        log.debug("### Marken Properties: " + props.toString());
        ArrayList<String> sMarken = new ArrayList<String>();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String sKey = (String)e.nextElement();
            String[] sKeyParts = sKey.split("\\.");
            if (sMarken.contains(sKeyParts[0])) continue;
            sMarken.add(sKeyParts[0]);
        }
        log.debug("### Marken Keys: " + sMarken.toString());
        for (String sMarke : sMarken) {
            Marke oMarke = new Marke(sMarke);
            Enumeration<Object> e2 = props.keys();
            while (e2.hasMoreElements()) {
                String sKey = (String)e2.nextElement();
                String[] sKeyParts = sKey.split("\\.");
                if (!sMarke.equals(sKeyParts[0])) continue;
                String sMarkenKey = sKey.replaceFirst(sKeyParts[0] + ".", "");
                String sMarkenValue = props.getProperty(sKey);
                oMarke.getProperties().setProperty(sMarkenKey, sMarkenValue);
            }
            this.lMarken.add(oMarke);
        }
        log.debug(this.toString());
    }

    public Marke getMarke(String sMarke) {
        Marke oMarkeGesucht = null;
        for (Marke oMarke : this.lMarken) {
            if (!sMarke.equals(oMarke.getMarke())) continue;
            oMarkeGesucht = oMarke;
        }
        return oMarkeGesucht;
    }

    public Marke getMarkeZurMarkeBerechtigung(String sMarkenBerechtigung) {
        Marke oMarkeGesucht = null;
        for (Marke oMarke : this.lMarken) {
            if (!sMarkenBerechtigung.equals(oMarke.getBerechtigung())) continue;
            oMarkeGesucht = oMarke;
        }
        return oMarkeGesucht;
    }

    public String getMarkeEigenschaft(String keySource, String valueSource, String keyTarget) {
        Marke oMarke;
        String sTest;
        String sValueTarget = null;
        Iterator<Marke> i$ = this.lMarken.iterator();
        while (i$.hasNext() && (sTest = (oMarke = i$.next()).getProperties().getProperty(keySource)) != null) {
            if (!sTest.equals(valueSource)) continue;
            sValueTarget = oMarke.getProperties().getProperty(keyTarget, null);
            break;
        }
        return sValueTarget;
    }

    public String getMarkeEigenschaft(String keySource, String valueSource, String keyTarget, String defaultValue) {
        String sValueTarget = this.getMarkeEigenschaft(keySource, valueSource, keyTarget);
        if (sValueTarget == null) {
            sValueTarget = defaultValue;
        }
        return sValueTarget;
    }

    public String getMarkeEigenschaft(String sMarke, String sKey) {
        return this.getMarke(sMarke) != null ? this.getMarke(sMarke).getProperties().getProperty(sKey, null) : null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("### Marken und Eigenschaften - Anfang ###");
        sb.append("\n");
        for (Marke oMarke : this.lMarken) {
            sb.append("### Marke: " + oMarke.getMarke());
            sb.append("\n");
            Enumeration<Object> e = oMarke.getProperties().keys();
            while (e.hasMoreElements()) {
                String sKey = (String)e.nextElement();
                sb.append("### - " + sKey + " = " + oMarke.getProperties().getProperty(sKey, ""));
                sb.append("\n");
            }
        }
        sb.append("### Marken und Eigenschaften - Ende ###");
        return sb.toString();
    }

    public ArrayList<String> getEigenschaften(String sKey) {
        ArrayList<String> sCol = new ArrayList<String>();
        for (Marke oMarke : this.lMarken) {
            String sValue = oMarke.getProperties().getProperty(sKey, null);
            if (sValue == null || sValue.length() <= 0) continue;
            sCol.add(sValue);
        }
        return !sCol.isEmpty() ? sCol : null;
    }
}

