/*
 * Decompiled with CFR 0.152.
 */
package webetk.mrkprd;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import webetk.mrkprd.InvalidPropertieException;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.MarkenProdukteListen;
import webetk.mrkprd.Produkte;

public class MarkenProdukte {
    private static Logger log = Logger.getLogger(MarkenProdukte.class);
    private static MarkenProdukte instance_etk = null;
    private static MarkenProdukte instance_ipac = null;
    private ArrayList<MarkeProdukt> lMarkenProdukte = new ArrayList();
    public static final int LISTE_ETK = 1;
    public static final int LISTE_IPAC = 2;

    private MarkenProdukte(int sListenArt) {
        this.load(sListenArt);
    }

    public static MarkenProdukte getInstance(int sListenArt) {
        switch (sListenArt) {
            case 1: {
                if (instance_etk == null) {
                    instance_etk = new MarkenProdukte(sListenArt);
                }
                return instance_etk;
            }
            case 2: {
                if (instance_ipac == null) {
                    instance_ipac = new MarkenProdukte(sListenArt);
                }
                return instance_ipac;
            }
        }
        return null;
    }

    private void load(int sListenArt) {
        switch (sListenArt) {
            case 1: {
                this.lMarkenProdukte = MarkenProdukteListen.getInstance().getMarkenProdukteListe();
                break;
            }
            case 2: {
                this.lMarkenProdukte = MarkenProdukteListen.getInstance().getIpacMarkenProdukteListe();
            }
        }
        if (this.lMarkenProdukte.isEmpty()) {
            try {
                throw new InvalidPropertieException("### Keine Marken-Produkte-Kombinationen vorhanden! (f\u00fcr Liste: " + sListenArt + ") ###");
            }
            catch (InvalidPropertieException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
                log.fatal(e.getMessage(), e);
                System.exit(-999);
            }
        }
        log.debug("### Marken-Produkte-Kombinationen (f\u00fcr Liste: " + sListenArt + "): ");
        log.debug(this.toString());
    }

    public MarkeProdukt getMarkeProdukt(String sMarke, String sProdukt) {
        MarkeProdukt oMarkeProduktGesucht = null;
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!sMarke.equals(oMarkeProdukt.getMarke()) || !sProdukt.equals(oMarkeProdukt.getProdukt())) continue;
            oMarkeProduktGesucht = oMarkeProdukt;
            break;
        }
        return oMarkeProduktGesucht;
    }

    public boolean isMarkeProdukt(String sMarke, String sProdukt) {
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!sMarke.equals(oMarkeProdukt.getMarke()) || !sProdukt.equals(oMarkeProdukt.getProdukt())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getMarken() {
        ArrayList<String> lMarken = new ArrayList<String>();
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (lMarken.contains(oMarkeProdukt.getMarke())) continue;
            lMarken.add(oMarkeProdukt.getMarke());
        }
        return lMarken;
    }

    public ArrayList<String> getMarken(boolean pbBMWGroup) {
        ArrayList<String> lMarken = new ArrayList<String>();
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if ((!pbBMWGroup || !oMarkeProdukt.isBMWGroup().booleanValue()) && (pbBMWGroup || oMarkeProdukt.isBMWGroup().booleanValue()) || lMarken.contains(oMarkeProdukt.getMarke())) continue;
            lMarken.add(oMarkeProdukt.getMarke());
        }
        return lMarken;
    }

    public ArrayList<String> getMarkenZumProdukt(String sProdukt) {
        ArrayList<String> lMarken = new ArrayList<String>();
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!oMarkeProdukt.getProdukt().equals(sProdukt) || lMarken.contains(oMarkeProdukt.getMarke())) continue;
            lMarken.add(oMarkeProdukt.getMarke());
        }
        return lMarken;
    }

    public boolean isMarke(String sMarke) {
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!sMarke.equals(oMarkeProdukt.getMarke())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getProdukte() {
        ArrayList<String> lProdukte = new ArrayList<String>();
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (lProdukte.contains(oMarkeProdukt.getProdukt())) continue;
            lProdukte.add(oMarkeProdukt.getProdukt());
        }
        return lProdukte;
    }

    public ArrayList<String> getProdukteZurMarke(String sMarke) {
        ArrayList<String> lProdukte = new ArrayList<String>();
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!oMarkeProdukt.getMarke().equals(sMarke) || lProdukte.contains(oMarkeProdukt.getProdukt())) continue;
            lProdukte.add(oMarkeProdukt.getProdukt());
        }
        return lProdukte;
    }

    public boolean isProdukt(String sProdukt) {
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!sProdukt.equals(oMarkeProdukt.getProdukt())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<MarkeProdukt> getMarkenProdukte() {
        return this.lMarkenProdukte;
    }

    public ArrayList<MarkeProdukt> getBerechtigteMarkenProdukte(Collection<String> plUserMarken, Collection<String> plUserProdukte, Collection<String> plMarktProdukte, Boolean pbIsUSmarkt) {
        ArrayList<MarkeProdukt> ldarfMarkenProdukte = new ArrayList<MarkeProdukt>();
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!plUserMarken.contains(oMarkeProdukt.getMarke()) || !plUserProdukte.contains(oMarkeProdukt.getProdukt()) || !plMarktProdukte.contains(oMarkeProdukt.getProdukt()) || pbIsUSmarkt != null && (pbIsUSmarkt == null || pbIsUSmarkt.booleanValue()) && (pbIsUSmarkt == null || !pbIsUSmarkt.booleanValue() || !oMarkeProdukt.getProdukt().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()))) continue;
            ldarfMarkenProdukte.add(oMarkeProdukt);
        }
        return ldarfMarkenProdukte;
    }

    public ArrayList<MarkeProdukt> getBerechtigteMarkenProdukte(Collection<String> plUserMarken, Collection<String> plUserProdukte, Boolean pbIsUSmarkt) {
        ArrayList<MarkeProdukt> ldarfMarkenProdukte = new ArrayList<MarkeProdukt>();
        for (MarkeProdukt oMarkeProdukt : this.lMarkenProdukte) {
            if (!plUserMarken.contains(oMarkeProdukt.getMarke()) || !plUserProdukte.contains(oMarkeProdukt.getProdukt()) || pbIsUSmarkt != null && (pbIsUSmarkt == null || pbIsUSmarkt.booleanValue()) && (pbIsUSmarkt == null || !pbIsUSmarkt.booleanValue() || !oMarkeProdukt.getProdukt().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung()))) continue;
            ldarfMarkenProdukte.add(oMarkeProdukt);
        }
        return ldarfMarkenProdukte;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("### Marken und Produkte - Anfang ###");
        sb.append("\n");
        for (MarkeProdukt oMrkPrd : this.lMarkenProdukte) {
            sb.append("### Marke: " + oMrkPrd.getMarke() + " Produkt: " + oMrkPrd.getProdukt());
            sb.append("\n");
        }
        sb.append("### Marken und Produkte - Ende ###");
        return sb.toString();
    }

    public static ArrayList<String> ermittleMoeglicheProdukteZuUserMarken(Collection<String> cMarken) {
        ArrayList<String> moeglProdukteZuMarken = new ArrayList<String>();
        for (String sMarke : cMarken) {
            ArrayList<String> moeglProdukteZurMarke = MarkenProdukte.getInstance(1).getProdukteZurMarke(sMarke);
            for (String sProdukt : moeglProdukteZurMarke) {
                if (moeglProdukteZuMarken.contains(sProdukt)) continue;
                moeglProdukteZuMarken.add(sProdukt);
            }
        }
        return moeglProdukteZuMarken;
    }
}

