/*
 * Decompiled with CFR 0.152.
 */
package webetk.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class CommonUtils {
    public static Logger log = Logger.getLogger(CommonUtils.class);
    private static final int BLOCKSIZE = 64000;

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = CommonUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                log.error("Couldn't delete " + dir.getName());
                return false;
            }
        }
        return dir.delete();
    }

    public static File getFileExistsAndCreateIfNot(String pFile) {
        File f = new File(pFile);
        if (f.exists()) {
            return f;
        }
        try {
            f.createNewFile();
            return f;
        }
        catch (IOException e) {
            log.error("Konnte " + pFile + " nicht anlegen");
            log.error(e);
            e.printStackTrace();
            return null;
        }
    }

    public static File getFileExists(String pFile) {
        File f = new File(pFile);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static void copyFile(String file, String newFile) throws FileNotFoundException, IOException {
        int nread;
        FileInputStream is = new FileInputStream(file);
        FileOutputStream os = new FileOutputStream(newFile);
        byte[] buffer = new byte[64000];
        while ((nread = ((InputStream)is).read(buffer, 0, buffer.length)) != -1) {
            ((OutputStream)os).write(buffer, 0, nread);
        }
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }
}

