/*
 * Decompiled with CFR 0.152.
 */
package webetk.utils;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StringUtils {
    public static final String PARAM_SUBST_SEP = "&";
    public static Map<Integer, String> prepareStatementParams = new HashMap<Integer, String>();
    public static Map<Integer, String> prepareStatementParams2 = new HashMap<Integer, String>();

    public static String substituteString(String sSource, String sParam, String sSubst) {
        String sSearchFor = new String(PARAM_SUBST_SEP + sParam + PARAM_SUBST_SEP);
        return StringUtils.substituteStringStraight(sSource, sSearchFor, sSubst);
    }

    public static String concatCollection(Collection<String> pStrings) {
        if (pStrings == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String string : pStrings) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append('\'').append(string).append('\'');
        }
        return sb.toString();
    }

    public static String substituteStringStraight(String sSource, String sParam, String sSubst) {
        if (sSource == null || sParam == null) {
            return sSource;
        }
        if (sSubst == null) {
            sSubst = new String("");
        }
        int nIndex = sSource.indexOf(sParam);
        while (nIndex != -1) {
            String sNewString;
            sSource = sNewString = sSource.substring(0, nIndex) + sSubst + sSource.substring(nIndex + sParam.length(), sSource.length());
            nIndex = sSource.indexOf(sParam, nIndex + sSubst.length());
        }
        return sSource;
    }

    public static String substituteListOfStrings(String sSource, String sParam, Collection<String> cSubst) {
        String sSearchFor = new String(PARAM_SUBST_SEP + sParam + PARAM_SUBST_SEP);
        return StringUtils.substituteListOfStringsStraight(sSource, sSearchFor, cSubst);
    }

    public static String substituteListOfStringsStraight(String sSource, String sParam, Collection<String> cSubst) {
        if (sSource == null || sParam == null) {
            return sSource;
        }
        if (cSubst == null) {
            cSubst = new Vector<String>();
            cSubst.add("");
        }
        String sSubst = "";
        for (String sStr : cSubst) {
            if (sSubst.length() > 1) {
                sSubst = sSubst + " , ";
            }
            sSubst = sSubst + "'" + sStr + "'";
        }
        int nIndex = sSource.indexOf(sParam);
        while (nIndex != -1) {
            String sNewString;
            sSource = sNewString = sSource.substring(0, nIndex) + sSubst + sSource.substring(nIndex + sParam.length(), sSource.length());
            nIndex = sSource.indexOf(sParam, nIndex + sSubst.length());
        }
        return sSource;
    }

    public static String substituteStringQuoted(String sSource, String sParam, String sSubst, boolean isQuoted) {
        String realSubst = sSubst == null ? "NULL" : (isQuoted ? "'" + sSubst + "'" : sSubst);
        return StringUtils.substituteStringStraight(sSource, sParam, realSubst);
    }

    public static String maskiereHochkommaFuerDb(String sSource) {
        return StringUtils.substituteStringStraight(sSource, "'", "''");
    }

    public static String convCharacters(String sDummy) {
        return sDummy == null || sDummy.trim().equals("") ? "null" : "'" + sDummy + "'";
    }

    public static String convNumeric(String sDummy) {
        return sDummy == null || sDummy.trim().equals("") ? "null" : sDummy;
    }

    public static String convMultilineToDB(String ReplaceString) {
        String sSep = PARAM_SUBST_SEP;
        if (ReplaceString == null) {
            return "NULL";
        }
        if ((ReplaceString = ReplaceString.trim()).length() == 0) {
            return "NULL";
        }
        ReplaceString = StringUtils.substituteStringStraight(ReplaceString, new String("\n"), new String(sSep + "\\n" + sSep));
        ReplaceString = StringUtils.substituteStringStraight(ReplaceString, new String("\r"), new String(sSep + "\\r" + sSep));
        ReplaceString = StringUtils.substituteStringStraight(ReplaceString, new String("'"), new String(sSep + "''" + sSep));
        return "'" + ReplaceString + "'";
    }

    public static Object[] convMultilineToArray(String sReplaceString) {
        Vector<String> vMsgZeilen = new Vector<String>();
        while (sReplaceString.length() > 0) {
            int nPosUmbruch = sReplaceString.indexOf("\\n");
            String sZeile = null;
            if (nPosUmbruch < 0) {
                sZeile = sReplaceString;
                sReplaceString = "";
            } else {
                sZeile = sReplaceString.substring(0, nPosUmbruch);
                sReplaceString = sReplaceString.substring(nPosUmbruch + 2, sReplaceString.length());
            }
            vMsgZeilen.add(sZeile);
        }
        return vMsgZeilen.toArray();
    }

    public static String convMultilineFromDBToRTF(String ReplaceString) {
        String sSep = PARAM_SUBST_SEP;
        ReplaceString = StringUtils.substituteStringStraight(ReplaceString, new String("\r"), "");
        ReplaceString = StringUtils.substituteStringStraight(ReplaceString, new String("\n"), "\\par ");
        ReplaceString = StringUtils.substituteStringStraight(ReplaceString, sSep + "\\r" + sSep, "");
        return StringUtils.substituteStringStraight(ReplaceString, sSep + "\\r" + sSep, "\\par ");
    }

    public static String convMultilineFromDB(String ReplaceString) {
        String sSep = PARAM_SUBST_SEP;
        ReplaceString = StringUtils.substituteStringStraight(ReplaceString, new String(sSep + "\\n" + sSep), new String("\n"));
        return StringUtils.substituteStringStraight(ReplaceString, new String(sSep + "\\r" + sSep), new String("\r"));
    }

    public static long convToLong(String sString) {
        long lEingabe = -1L;
        if (sString != null && sString.length() != 0 && !sString.equals("empty")) {
            if (sString.equals("empty")) {
                Logger.getLogger(StringUtils.class).debug("sString equals empty");
            }
            try {
                lEingabe = Long.parseLong(sString);
            }
            catch (NumberFormatException e) {
                Logger.getLogger(StringUtils.class).error("Could not convert Status<" + sString + "> to Number!", e);
            }
        }
        return lEingabe;
    }

    public static float convToFloat(String sString) {
        float lEingabe = -1.0f;
        if (sString != null && sString.length() != 0 && !sString.equals("empty")) {
            try {
                lEingabe = Float.parseFloat(sString);
            }
            catch (NumberFormatException e) {
                Logger.getLogger(StringUtils.class).error("Could not convert Status<" + sString + "> to Number!", e);
            }
        }
        return lEingabe;
    }

    public static String convString(String sValue) {
        String serg = sValue == null ? new String("") : new String(sValue);
        return serg;
    }

    public static int getCountDigit(String sString) {
        int nCountDigit = 0;
        for (int i = 0; i < sString.length(); ++i) {
            if (!Character.isDigit(sString.charAt(i)) && !Character.isLetter(sString.charAt(i))) continue;
            ++nCountDigit;
        }
        return nCountDigit;
    }

    public static boolean isNMToken(String sString) {
        for (int i = 0; i < sString.length(); ++i) {
            boolean bCharOK = false;
            char chChar = sString.charAt(i);
            bCharOK |= Character.isDigit(chChar);
            bCharOK |= Character.isLetter(chChar);
            if (bCharOK |= chChar == '.' || chChar == '-' || chChar == '_' || chChar == ':') continue;
            return false;
        }
        return true;
    }

    public static boolean enthaeltHochkomma(String sString) {
        for (int i = 0; i < sString.length(); ++i) {
            char chChar = sString.charAt(i);
            if (chChar != '\'') continue;
            return true;
        }
        return false;
    }

    public static boolean enthaeltUmlautAndViceVersa(String sString) {
        if ((sString = sString.toUpperCase()).indexOf("\u00c4") > -1) {
            return true;
        }
        if (sString.indexOf("\u00d6") > -1) {
            return true;
        }
        if (sString.indexOf("\u00dc") > -1) {
            return true;
        }
        if (sString.indexOf("AE") > -1) {
            return true;
        }
        if (sString.indexOf("OE") > -1) {
            return true;
        }
        return sString.indexOf("UE") > -1;
    }

    public static String replaceFirstUmlautAndViceVersa(String sString) {
        String sStringReplaced = null;
        String sSubstitute = null;
        String sHelp = sString.toUpperCase();
        int nCount = 0;
        int nPosition = 9999999;
        int nPositionHelp = sHelp.indexOf("\u00c4");
        if (nPositionHelp > -1) {
            nPosition = nPositionHelp;
            sSubstitute = "AE";
            nCount = 1;
        }
        if ((nPositionHelp = sHelp.indexOf("\u00d6")) > -1 && nPositionHelp < nPosition) {
            nPosition = nPositionHelp;
            sSubstitute = "OE";
            nCount = 1;
        }
        if ((nPositionHelp = sHelp.indexOf("\u00dc")) > -1 && nPositionHelp < nPosition) {
            nPosition = nPositionHelp;
            sSubstitute = "UE";
            nCount = 1;
        }
        if ((nPositionHelp = sHelp.indexOf("AE")) > -1) {
            nPosition = nPositionHelp;
            sSubstitute = "\u00c4";
            nCount = 2;
        }
        if ((nPositionHelp = sHelp.indexOf("OE")) > -1 && nPositionHelp < nPosition) {
            nPosition = nPositionHelp;
            sSubstitute = "\u00d6";
            nCount = 2;
        }
        if ((nPositionHelp = sHelp.indexOf("UE")) > -1 && nPositionHelp < nPosition) {
            nPosition = nPositionHelp;
            sSubstitute = "\u00dc";
            nCount = 2;
        }
        if (nPosition != 9999999) {
            sStringReplaced = sHelp.substring(0, nPosition) + sSubstitute + sHelp.substring(nPosition + nCount);
            return sStringReplaced;
        }
        return sString;
    }

    public static String getStringFromDate(Date dDate, String sLang, int nDateFormat) {
        Locale locale;
        if (sLang.equals("de")) {
            locale = new Locale("de", "DE");
        } else if (sLang.equals("en")) {
            locale = new Locale("en", "GB");
        } else if (sLang.equals("enUS")) {
            locale = new Locale("en", "US");
        } else if (sLang.equals("es")) {
            locale = new Locale("es", "ES");
        } else if (sLang.equals("fr")) {
            locale = new Locale("fr", "FR");
        } else if (sLang.equals("it")) {
            locale = new Locale("it", "IT");
        } else if (sLang.equals("ja")) {
            locale = new Locale("ja", "JP");
        } else if (sLang.equals("ko")) {
            locale = new Locale("ko", "KR");
        } else if (sLang.equals("nl")) {
            locale = new Locale("nl", "NL");
        } else if (sLang.equals("pt")) {
            locale = new Locale("pt", "PT");
        } else if (sLang.equals("ru")) {
            locale = new Locale("ru", "RU");
        } else if (sLang.equals("sv")) {
            locale = new Locale("sv", "SE");
        } else if (sLang.equals("th")) {
            locale = new Locale("th", "TH");
        } else if (sLang.equals("zh")) {
            locale = new Locale("zh", "CN");
        } else if (sLang.equals("zhTW")) {
            locale = new Locale("zh", "TW");
        } else {
            Logger.getLogger(StringUtils.class).error("Error: Unsupported Language " + sLang);
            locale = new Locale("en", "US");
        }
        DateFormat df = DateFormat.getDateInstance(nDateFormat, locale);
        return df.format(dDate);
    }

    public static Date getDateFromLong(long lDate) {
        GregorianCalendar objCalendar = new GregorianCalendar();
        int nYear = (int)(lDate / 10000L);
        int nMonth = (int)((lDate - (long)(nYear * 10000)) / 100L);
        int nDay = (int)(lDate - (long)(nYear * 10000) - (long)(nMonth * 100));
        objCalendar.set(nYear, --nMonth, nDay);
        return objCalendar.getTime();
    }

    public static boolean isEmpty(String sString, boolean bRemoveLeerzeichen) {
        if (sString == null) {
            return true;
        }
        if (bRemoveLeerzeichen) {
            sString = sString.trim();
        }
        return sString.equals("");
    }

    public static String addNullen(String sOldString, int nFeldlaenge) {
        int nStart;
        String sNewString = "";
        if (sOldString == null) {
            for (int ii = 0; ii < nFeldlaenge; ++ii) {
                sNewString = sNewString + "0";
            }
            return sNewString;
        }
        for (int ii = nStart = sOldString.length(); ii < nFeldlaenge; ++ii) {
            sNewString = sNewString + "0";
        }
        if ((sNewString = sNewString + sOldString).length() > nFeldlaenge) {
            sNewString = sNewString.substring(0, nFeldlaenge);
        }
        return sNewString;
    }

    public static String maskiereHochkommaKomma(Collection<String> aValues) {
        StringBuffer sbRegionen = new StringBuffer();
        for (String sValue : aValues) {
            if (sbRegionen.length() > 0) {
                sbRegionen.append(", ");
            }
            sbRegionen.append("'");
            sbRegionen.append(sValue);
            sbRegionen.append("'");
        }
        return sbRegionen.toString();
    }

    public static String nullsafe(String pValue) {
        return pValue == null ? "" : pValue;
    }

    public static void setPreparedStatementParams(int index, String value) {
        prepareStatementParams.put(index, value);
    }

    public static void setPreparedStatementParams2(int index, String value) {
        prepareStatementParams2.put(index, value);
    }

    public static Map<Integer, String> getPreparedStatementParams() {
        return prepareStatementParams;
    }

    public static Map<Integer, String> getPreparedStatementParams2() {
        return prepareStatementParams2;
    }

    public static PreparedStatement setParameters(PreparedStatement ps) {
        if (StringUtils.getPreparedStatementParams() != null & StringUtils.getPreparedStatementParams().size() > 0) {
            for (Map.Entry<Integer, String> pair : StringUtils.getPreparedStatementParams().entrySet()) {
                try {
                    ps.setString(pair.getKey(), pair.getValue());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            StringUtils.getPreparedStatementParams().clear();
        }
        return ps;
    }

    public static PreparedStatement setParameters2(PreparedStatement ps) {
        if (StringUtils.getPreparedStatementParams2() != null & StringUtils.getPreparedStatementParams2().size() > 0) {
            for (Map.Entry<Integer, String> pair : StringUtils.getPreparedStatementParams2().entrySet()) {
                try {
                    ps.setString(pair.getKey(), pair.getValue());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            StringUtils.getPreparedStatementParams().clear();
        }
        return ps;
    }

    public static String preparePlaceHolders(int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append('?');
            if (++i >= length) continue;
            builder.append(',');
        }
        return builder.toString();
    }
}

