/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import webetk.xmlapi.JAXBContextFactory;
import webetk.xmlapi.XmlCommunicationException;
import webetk.xmlapi.XmlParseException;

public abstract class XmlRpcCommand {
    private static Logger log = Logger.getLogger(XmlRpcCommand.class);
    private static final String ENCODING = "UTF-8";
    protected static String _serverUrlDms = "";
    protected static String _schemaUrlDms = "";
    protected static String _serverUrlVin = "";
    protected static String _schemaUrlVin = "";
    protected String username;
    protected String firma;
    protected String filiale;
    private HttpClient client = new HttpClient();
    protected int ergebnisCode;
    private JAXBContext jc;
    private Unmarshaller u;
    private Marshaller m;

    public String getFirma() {
        return this.firma;
    }

    public int getErgebnisCode() {
        return this.ergebnisCode;
    }

    public static void setServerUrlDms(String sServerUrlDms) {
        _serverUrlDms = sServerUrlDms;
    }

    public static void setSchemaUrlDms(String sSchemaUrlDms) {
        _schemaUrlDms = sSchemaUrlDms;
    }

    public static void setServerUrlVin(String sServerUrlVin) {
        _serverUrlVin = sServerUrlVin;
    }

    public static void setSchemaUrlVin(String sSchemaUrlVin) {
        _schemaUrlVin = sSchemaUrlVin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object sendCommand(Class targetXmlClass, Object xmlMessageRoot, String sServerUrl, String sSchemaUrl) throws IllegalStateException, XmlCommunicationException, XmlParseException {
        Object oXmlObject = null;
        log.debug("Sending XML request ...");
        if (sServerUrl == null || sServerUrl.length() == 0) {
            log.error("Not properly initialized! Server URL is missing.");
            throw new IllegalStateException("Not properly initialized! Server URL is missing.");
        }
        try {
            JAXBContextFactory factory = JAXBContextFactory.getInstance();
            this.jc = factory.getJaxBContext(targetXmlClass);
            this.u = this.jc.createUnmarshaller();
            this.m = this.jc.createMarshaller();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        PostMethod post = new PostMethod(sServerUrl);
        try {
            ByteArrayOutputStream bos;
            try {
                post.setRequestHeader("Content-type", "text/xml");
                bos = new ByteArrayOutputStream();
                log.debug("Marshalling ...");
                this.m.setProperty("jaxb.schemaLocation", (Object)"http://bmw.de/dms dms.xsd");
                this.m.setProperty("jaxb.formatted.output", (Object)true);
                this.m.marshal(xmlMessageRoot, (OutputStream)bos);
                bos.close();
                byte[] arr = bos.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(arr);
                post.setRequestBody((InputStream)bis);
                this.client.executeMethod((HttpMethod)post);
                bis.close();
            }
            catch (IOException ex) {
                log.error("ETK to DMS: IO Error during communication: " + ex.getMessage());
                throw new XmlCommunicationException("ETK to DMS: IO Communication error: " + ex.getMessage());
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            try {
                log.debug("Waiting for answer ...");
                bos = new ByteArrayOutputStream();
                InputStream is = post.getResponseBodyAsStream();
                byte[] buffer = new byte[256];
                int read = is.read(buffer);
                boolean bHtml = false;
                while (read > 0) {
                    String sBuffer = new String(buffer, ENCODING);
                    if (sBuffer != null) {
                        if (sBuffer.startsWith("<!DOCTYPE HTML")) {
                            bHtml = true;
                        }
                        if (bHtml) {
                            log.error(sBuffer);
                        } else {
                            log.info(sBuffer);
                        }
                    }
                    bos.write(buffer, 0, read);
                    read = is.read(buffer);
                }
                byte[] arr = bos.toByteArray();
                InputStreamReader answer = new InputStreamReader((InputStream)new ByteArrayInputStream(arr), ENCODING);
                oXmlObject = this.u.unmarshal((Reader)answer);
                log.debug("Result retrieved");
            }
            catch (IOException ex) {
                log.error("DMS to ETK: IO Error during communication: " + ex.getMessage());
                throw new XmlCommunicationException("DMS to ETK: IO Communication error: " + ex.getMessage());
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        finally {
            log.debug("Releasing HTTPClient connection");
            post.releaseConnection();
        }
        return oXmlObject;
    }

    public abstract void requestService() throws IllegalStateException, XmlCommunicationException, XmlParseException;

    protected abstract void constructXmlObjects() throws XmlParseException;

    protected void setInputParameters(String sUsername, String sFirma, String sFiliale) throws IllegalArgumentException, XmlParseException {
        this.username = sUsername;
        this.firma = sFirma;
        this.filiale = sFiliale;
        if (this.username == null || this.username.length() == 0) {
            Logger.getLogger(XmlRpcCommand.class).error("Username is not defined!");
            throw new IllegalArgumentException("Nutzername ist nicht definiert!");
        }
        if (this.firma == null || this.firma.length() == 0) {
            Logger.getLogger(XmlRpcCommand.class).error("Username is not defined!");
            throw new IllegalArgumentException("Nutzername ist nicht definiert!");
        }
        if (this.filiale == null || this.filiale.length() == 0) {
            Logger.getLogger(XmlRpcCommand.class).error("Username is not defined!");
            throw new IllegalArgumentException("Nutzername ist nicht definiert!");
        }
    }
}

