/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.KompletteBestelllistenPosition;
import webetk.interfaces.dms.TeilErgebnis;
import webetk.interfaces.dms.TypeBarverkaufRequest;
import webetk.interfaces.dms.TypeMarke;
import webetk.interfaces.dms.TypeVerkaufAuftragResponse;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPositionKomplett;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilErgebnis;

public class XmlDmsBarverkauf
extends XmlDmsCommand {
    private String auftragsnummer;
    private int mitarbeiternummer;
    private String kommentar;
    private int kundennummer;
    private String passwort;
    private boolean rechnungsIndikator;
    private boolean greiferscheinIndikator;
    private boolean lieferscheinIndikator;
    private int sonderSteuerung;
    private double bar;
    private double unbar;
    private ArrayList<XmlDmsTeilErgebnis> ergebnisse = new ArrayList();

    public DmsMessage getIt() {
        return this.XmlMessageRoot;
    }

    public String getAuftragsnummer() {
        return this.auftragsnummer;
    }

    public int getErgebnisCount() {
        return this.ergebnisse.size();
    }

    public String getTeilenummer(int index) {
        return this.ergebnisse.get(index).getTeilenummer();
    }

    public int getErgebnisCode(int index) {
        return this.ergebnisse.get(index).getErgebniscode();
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, int nMitarbeiternummer, String sKommentar, String sAuftragsnummer, int nKundennummer, String sPasswort, boolean bRechnung, boolean bGreiferschein, boolean bLieferschein, int nSondersteuerung, double dBar, double dUnbar) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.mitarbeiternummer = nMitarbeiternummer;
        this.kommentar = sKommentar;
        this.auftragsnummer = sAuftragsnummer;
        this.kundennummer = nKundennummer;
        this.passwort = sPasswort;
        this.rechnungsIndikator = bRechnung;
        this.greiferscheinIndikator = bGreiferschein;
        this.lieferscheinIndikator = bLieferschein;
        this.sonderSteuerung = nSondersteuerung;
        this.bar = dBar;
        this.unbar = dUnbar;
        Logger.getLogger(XmlDmsBarverkauf.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    public void addPosition(XmlDmsBestellPositionKomplett position) {
        TypeBarverkaufRequest inputPars = this.XmlMessageRoot.getDmsBarverkauf().getDmsRequest();
        KompletteBestelllistenPosition pos = new KompletteBestelllistenPosition();
        pos.setTeilenummer(position.getTeilenummer());
        pos.setMarke(TypeMarke.fromValue(position.getMarke()));
        pos.setBezeichnung(position.getBezeichnung());
        pos.setMenge(new BigDecimal(position.getMenge()).setScale(2, 4));
        pos.setNettopreis(new BigDecimal(position.getNettopreis()).setScale(2, 4));
        pos.setPreisPreisdatei(new BigDecimal(position.getPreisdateipreis()).setScale(2, 4));
        pos.setRabatt(position.getRabatt());
        pos.setKodierungsstufe(position.getKodierungsstufe());
        pos.setSuffix(new BigInteger(String.valueOf(position.getSuffix())));
        if (position.getSplitKennzeichen() != -1) {
            pos.setSplitKennzeichen(new BigInteger(String.valueOf(position.getSplitKennzeichen())));
        }
        pos.setProduktklasse(position.getProduktklasse());
        pos.setTeileart(position.getTeileart());
        pos.setSNP(new BigDecimal(position.getSNP()).setScale(2, 4));
        pos.setRT(position.getRT());
        pos.setKommentar(position.getKommentar());
        inputPars.getPosition().add(pos);
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        Logger.getLogger(XmlDmsBarverkauf.class).debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsBarverkauf() == null) {
            Logger.getLogger(XmlDmsBarverkauf.class).error("XML-Objekt is not a DmsBarverkauf Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsBarverkauf", "Response is not of type DmsBarverkauf!");
        }
        if (ergebnisObjekt.getDmsBarverkauf().getDmsResponse() == null) {
            Logger.getLogger(XmlDmsBarverkauf.class).error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsBarverkauf", "XML-Stream does not contain response objekt for DmsBarverkauf!");
        }
        TypeVerkaufAuftragResponse resp = ergebnisObjekt.getDmsBarverkauf().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        this.auftragsnummer = resp.getAuftragsnummer();
        for (TeilErgebnis te : resp.getTeilErgebnis()) {
            int nECode = -1;
            if (te.getErgebnisCode() != null) {
                nECode = te.getErgebnisCode().intValue();
            }
            XmlDmsTeilErgebnis ergebnis = new XmlDmsTeilErgebnis(te.getTeilenummer(), nECode);
            this.ergebnisse.add(ergebnis);
        }
        Logger.getLogger(XmlDmsBarverkauf.class).debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsBarverkauf.class).debug("Constructing XML-Objekt from input parameters for DmsBarverkauf Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsBarverkauf(new DmsMessage.DmsBarverkauf());
        root.getDmsBarverkauf().setDmsRequest(new TypeBarverkaufRequest());
        TypeBarverkaufRequest inputPars = root.getDmsBarverkauf().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.setMitarbeiterNr(new BigInteger(String.valueOf(this.mitarbeiternummer)));
        inputPars.setKommentar(this.kommentar);
        if (this.auftragsnummer != null) {
            inputPars.setAuftragsnummer(this.auftragsnummer);
        }
        inputPars.setKundennummer(new BigInteger(String.valueOf(this.kundennummer)));
        inputPars.setPasswort(this.passwort);
        inputPars.setRechnung(this.rechnungsIndikator);
        inputPars.setGreiferschein(this.greiferscheinIndikator);
        inputPars.setLieferschein(this.lieferscheinIndikator);
        inputPars.setKredit(new BigInteger(String.valueOf(this.sonderSteuerung)));
        inputPars.setBar(new BigDecimal(this.bar).setScale(2, 4));
        inputPars.setUnbar(new BigDecimal(this.unbar).setScale(2, 4));
        inputPars.getPosition().clear();
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsBarverkauf.class).debug("XML-Objekt constructed.");
    }
}

