/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.ErweiterteBestellistenPosition;
import webetk.interfaces.dms.TeilErgebnis;
import webetk.interfaces.dms.TypeEilauftragRequest;
import webetk.interfaces.dms.TypeEilauftragResponse;
import webetk.interfaces.dms.TypeMarke;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPositionErweitert;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilErgebnis;

public class XmlDmsEilauftrag
extends XmlDmsCommand {
    private ArrayList<XmlDmsTeilErgebnis> ergebnisse = new ArrayList();

    @Override
    public void setInputParameters(String sUsername, String sFirma, String sFiliale) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        Logger.getLogger(XmlDmsEilauftrag.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    public void addPosition(XmlDmsBestellPositionErweitert position) {
        TypeEilauftragRequest inputPars = this.XmlMessageRoot.getDmsEilauftrag().getDmsRequest();
        ErweiterteBestellistenPosition pos = new ErweiterteBestellistenPosition();
        pos.setTeilenummer(position.getTeilenummer());
        pos.setMarke(TypeMarke.fromValue(position.getMarke()));
        pos.setBezeichnung(position.getBezeichnung());
        pos.setMenge(new BigDecimal(position.getMenge()).setScale(2, 4));
        if (position.getAuftragsnummer() != null) {
            pos.setAuftragsnummer(position.getAuftragsnummer());
        }
        if (position.getKundennummer() != -1) {
            pos.setKundennummer(new BigInteger(String.valueOf(position.getKundennummer())));
        }
        pos.setKommentar(position.getKommentar());
        inputPars.getPosition().add(pos);
    }

    public void clearPositionen() {
        this.XmlMessageRoot.getDmsEilauftrag().getDmsRequest().getPosition().clear();
    }

    public int getErgebnisCount() {
        return this.ergebnisse.size();
    }

    public String getTeilenummer(int index) {
        return this.ergebnisse.get(index).getTeilenummer();
    }

    public int getErgebnisCode(int index) {
        return this.ergebnisse.get(index).getErgebniscode();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        Logger.getLogger(XmlDmsEilauftrag.class).debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsEilauftrag() == null) {
            Logger.getLogger(XmlDmsEilauftrag.class).error("XML-Objekt is not a DmsEilauftrag Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsEilauftrag", "Response is not of type DmsEilauftrag!");
        }
        if (ergebnisObjekt.getDmsEilauftrag().getDmsResponse() == null) {
            Logger.getLogger(XmlDmsEilauftrag.class).error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsEilauftrag", "XML-Stream does not contain response objekt for DmsEilauftrag!");
        }
        TypeEilauftragResponse resp = ergebnisObjekt.getDmsEilauftrag().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        for (TeilErgebnis te : resp.getTeilErgebnis()) {
            int nECode = -1;
            if (te.getErgebnisCode() != null) {
                nECode = te.getErgebnisCode().intValue();
            }
            XmlDmsTeilErgebnis ergebnis = new XmlDmsTeilErgebnis(te.getTeilenummer(), nECode);
            this.ergebnisse.add(ergebnis);
        }
        Logger.getLogger(XmlDmsEilauftrag.class).debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsEilauftrag.class).debug("Constructing XML-Objekt from input parameters for DmsEilauftrag Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsEilauftrag(new DmsMessage.DmsEilauftrag());
        root.getDmsEilauftrag().setDmsRequest(new TypeEilauftragRequest());
        TypeEilauftragRequest inputPars = root.getDmsEilauftrag().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.getPosition().clear();
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsEilauftrag.class).debug("XML-Objekt constructed.");
    }
}

