/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TypeKFZKennzeichenRequest;
import webetk.interfaces.dms.TypeKFZKennzeichenResponse;
import webetk.interfaces.dms.TypeMarke;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;

public class XmlDmsFzgIdKfzKennzeichen
extends XmlDmsCommand {
    private String auftragsnummer;
    private int kundennummer;
    private String kundenname;
    private String fahrgestellnummer;
    private String marke = "";
    private String kfzKennzeichen;
    private static Logger log = Logger.getLogger(XmlDmsFzgIdKfzKennzeichen.class);

    public String getAuftragsnummer() {
        return this.auftragsnummer;
    }

    public int getKundennummer() {
        return this.kundennummer;
    }

    public String getKundenname() {
        return this.kundenname;
    }

    public String getFahrgestellnummer() {
        return this.fahrgestellnummer;
    }

    public String getMarke() {
        return this.marke;
    }

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sKfzKennzeichen, String sMarke) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.kfzKennzeichen = sKfzKennzeichen;
        this.marke = sMarke;
        if (this.kfzKennzeichen == null || this.kfzKennzeichen.length() == 0) {
            Logger.getLogger(XmlDmsFzgIdKfzKennzeichen.class).error("Kennzeichen is not defined!");
            throw new IllegalArgumentException("Das KFZ Kennzeichen ist nicht definiert!");
        }
        Logger.getLogger(XmlDmsFzgIdKfzKennzeichen.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        log.debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsFzgIdKfzKennzeichen() == null) {
            log.error("XML-Objekt is not a DmsFzgIdKfzKennzeichen Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsFzgIdKfzKennzeichen", "Response is not of type DmsFzgIdKfzKennzeichen!");
        }
        if (ergebnisObjekt.getDmsFzgIdKfzKennzeichen().getDmsResponse() == null) {
            log.error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsFzgIdKfzKennzeichen", "XML-Stream does not contain response objekt for DmsFzgIdKfzKennzeichen!");
        }
        try {
            TypeKFZKennzeichenResponse resp = ergebnisObjekt.getDmsFzgIdKfzKennzeichen().getDmsResponse();
            this.ergebnisCode = resp.getErgebnisCode() != null ? resp.getErgebnisCode().intValue() : 0;
            this.meldungstext = resp.getMessageText();
            this.auftragsnummer = resp.getAuftragsnummer();
            this.kundennummer = resp.getKundennummer() != null ? resp.getKundennummer().intValue() : -1;
            this.kundenname = resp.getKundenname();
            this.fahrgestellnummer = resp.getFahrgestellnummer();
            if (resp.getMarke() != null) {
                this.marke = resp.getMarke().value();
            }
            log.debug("Information has been extracted.");
        }
        catch (Exception e) {
            log.error("Common DMS Error", e);
            throw new XmlParseException("DmsFzgIdKfzKennzeichen", "Common DMS Error");
        }
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        log.debug("Constructing XML-Objekt from input parameters for DmsFzgIdKfzKennzeichen Element ...");
        try {
            DmsMessage root = new DmsMessage();
            root.setDmsFzgIdKfzKennzeichen(new DmsMessage.DmsFzgIdKfzKennzeichen());
            TypeKFZKennzeichenRequest inputPars = new TypeKFZKennzeichenRequest();
            inputPars.setUsername(this.username);
            inputPars.setFirma(this.firma);
            inputPars.setFiliale(this.filiale);
            inputPars.setKfzKennzeichen(this.kfzKennzeichen);
            if (this.marke != null && !this.marke.equals("")) {
                inputPars.setMarke(TypeMarke.fromValue(this.marke));
            }
            root.getDmsFzgIdKfzKennzeichen().setDmsRequest(inputPars);
            this.XmlMessageRoot = root;
            log.debug("XML-Objekt constructed.");
        }
        catch (Exception e) {
            log.error("Fehler beim parsen der Message", e);
            throw new XmlParseException(this.getClass().getName(), "Fehler beim parsen der Message");
        }
    }
}

