/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.BestelllistenPosition;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TeilErgebnis;
import webetk.interfaces.dms.TypeMarke;
import webetk.interfaces.dms.TypeNeuteilauftragRequest;
import webetk.interfaces.dms.TypeNeuteilauftragResponse;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;
import webetk.xmlapi.dms.commands.typen.XmlDmsBestellPosition;
import webetk.xmlapi.dms.commands.typen.XmlDmsTeilErgebnis;

public class XmlDmsNeuteileAuftrag
extends XmlDmsCommand {
    private ArrayList<XmlDmsTeilErgebnis> ergebnisse = new ArrayList();

    @Override
    public void setInputParameters(String sUsername, String sFirma, String sFiliale) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        Logger.getLogger(XmlDmsNeuteileAuftrag.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    public void addPosition(XmlDmsBestellPosition position) {
        TypeNeuteilauftragRequest inputPars = this.XmlMessageRoot.getDmsNeuteileAuftrag().getDmsRequest();
        BestelllistenPosition pos = new BestelllistenPosition();
        pos.setTeilenummer(position.getTeilenummer());
        pos.setMarke(TypeMarke.fromValue(position.getMarke()));
        pos.setBezeichnung(position.getBezeichnung());
        pos.setMenge(new BigDecimal(position.getMenge()).setScale(2, 4));
        inputPars.getPosition().add(pos);
    }

    public void clearPositionen() {
        this.XmlMessageRoot.getDmsNeuteileAuftrag().getDmsRequest().getPosition().clear();
    }

    public int getErgebnisCount() {
        return this.ergebnisse.size();
    }

    public String getTeilenummer(int index) {
        return this.ergebnisse.get(index).getTeilenummer();
    }

    public int getErgebnisCode(int index) {
        return this.ergebnisse.get(index).getErgebniscode();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        Logger.getLogger(XmlDmsNeuteileAuftrag.class).debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsNeuteileAuftrag() == null) {
            Logger.getLogger(XmlDmsNeuteileAuftrag.class).error("XML-Objekt is not a DmsNeuteileAuftrag Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsNeuteileAuftrag", "Response is not of type DmsNeuteileAuftrag!");
        }
        if (ergebnisObjekt.getDmsNeuteileAuftrag().getDmsResponse() == null) {
            Logger.getLogger(XmlDmsNeuteileAuftrag.class).error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsNeuteileAuftrag", "XML-Stream does not contain response objekt for DmsNeuteileAuftrag!");
        }
        TypeNeuteilauftragResponse resp = ergebnisObjekt.getDmsNeuteileAuftrag().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        for (TeilErgebnis te : resp.getTeilErgebnis()) {
            int nECode = -1;
            if (te.getErgebnisCode() != null) {
                nECode = te.getErgebnisCode().intValue();
            }
            XmlDmsTeilErgebnis ergebnis = new XmlDmsTeilErgebnis(te.getTeilenummer(), nECode);
            this.ergebnisse.add(ergebnis);
        }
        Logger.getLogger(XmlDmsNeuteileAuftrag.class).debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsNeuteileAuftrag.class).debug("Constructing XML-Objekt from input parameters for DmsNeuteileAuftrag Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsNeuteileAuftrag(new DmsMessage.DmsNeuteileAuftrag());
        root.getDmsNeuteileAuftrag().setDmsRequest(new TypeNeuteilauftragRequest());
        TypeNeuteilauftragRequest inputPars = root.getDmsNeuteileAuftrag().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.getPosition().clear();
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsNeuteileAuftrag.class).debug("XML-Objekt constructed.");
    }
}

