/*
 * Decompiled with CFR 0.152.
 */
package webetk.xmlapi.dms.commands;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import webetk.interfaces.dms.DmsMessage;
import webetk.interfaces.dms.TypeMarke;
import webetk.interfaces.dms.TypeStammsatzanlageRequest;
import webetk.interfaces.dms.TypeStammsatzanlageResponse;
import webetk.xmlapi.XmlParseException;
import webetk.xmlapi.dms.XmlDmsCommand;

public class XmlDmsStammsatzanlage
extends XmlDmsCommand {
    private String teilenummer;
    private String marke;
    private String bezeichnung;
    private double UPE;
    private double SNP;
    private String kodierungsstufe;
    private String produktklasse;
    private String teileart;
    private int VVM;
    private int LVM;
    private int BVM;
    private boolean hoheMwst;

    public void setInputParameters(String sUsername, String sFirma, String sFiliale, String sTeilenummer, String sMarke, String sBezeichnung, double dUPE, double dSNP, String sKodierstufe, String sProduktklasse, String sTeileart, int nVVM, int nLVM, int nBVM, boolean bHoheMwst) throws IllegalArgumentException, XmlParseException {
        super.setInputParameters(sUsername, sFirma, sFiliale);
        this.teilenummer = sTeilenummer;
        this.marke = sMarke;
        this.bezeichnung = sBezeichnung;
        this.UPE = dUPE;
        this.SNP = dSNP;
        this.kodierungsstufe = sKodierstufe;
        this.produktklasse = sProduktklasse;
        this.teileart = sTeileart;
        this.VVM = nVVM;
        this.LVM = nLVM;
        this.BVM = nBVM;
        this.hoheMwst = bHoheMwst;
        if (this.teilenummer == null || this.teilenummer.length() < 1 || this.teilenummer.length() > 11) {
            Logger.getLogger(XmlDmsStammsatzanlage.class).error("Teilenummer is not defined!");
            throw new IllegalArgumentException("Teilenummer ist nicht definiert!");
        }
        if (this.marke == null || this.marke.length() == 0) {
            Logger.getLogger(XmlDmsStammsatzanlage.class).error("Marke is not defined!");
            throw new IllegalArgumentException("Marke ist nicht definiert!");
        }
        if (this.bezeichnung == null || this.bezeichnung.length() == 0) {
            Logger.getLogger(XmlDmsStammsatzanlage.class).error("Bezeichnung is not defined!");
            throw new IllegalArgumentException("Bezeichnung ist nicht definiert!");
        }
        if (this.produktklasse == null) {
            Logger.getLogger(XmlDmsStammsatzanlage.class).error("Produktklasse is not defined!");
            throw new IllegalArgumentException("Produktklasse ist nicht definiert!");
        }
        if (this.teileart == null) {
            Logger.getLogger(XmlDmsStammsatzanlage.class).error("Teileart is not defined!");
            throw new IllegalArgumentException("Teileart ist nicht definiert!");
        }
        Logger.getLogger(XmlDmsStammsatzanlage.class).debug("Input seems to be in order.");
        Logger.getLogger(XmlDmsStammsatzanlage.class).debug("Constructing XML-Objects ...");
        this.constructXmlObjects();
    }

    @Override
    protected void setResultObjekt(DmsMessage ergebnisObjekt) throws XmlParseException {
        Logger.getLogger(XmlDmsStammsatzanlage.class).debug("Extracting response from XML-Objekt ...");
        if (ergebnisObjekt.getDmsStammsatzanlage() == null) {
            Logger.getLogger(XmlDmsStammsatzanlage.class).error("XML-Objekt is not a DmsStammsatzanlage Element: " + ergebnisObjekt);
            throw new XmlParseException("XmlDmsStammsatzanlage", "Response is not of type DmsStammsatzanlage!");
        }
        if (ergebnisObjekt.getDmsStammsatzanlage().getDmsResponse() == null) {
            Logger.getLogger(XmlDmsStammsatzanlage.class).error("XML-Objekt is not a Response Element: " + ergebnisObjekt);
            throw new XmlParseException("DmsStammsatzanlage", "XML-Stream does not contain response objekt for DmsStammsatzanlage!");
        }
        TypeStammsatzanlageResponse resp = ergebnisObjekt.getDmsStammsatzanlage().getDmsResponse();
        this.ergebnisCode = resp.getErgebnisCode().intValue();
        this.meldungstext = resp.getMessageText();
        this.teilenummer = resp.getTeilenummer();
        Logger.getLogger(XmlDmsStammsatzanlage.class).debug("Information has been extracted.");
    }

    @Override
    protected void constructXmlObjects() throws XmlParseException {
        Logger.getLogger(XmlDmsStammsatzanlage.class).debug("Constructing XML-Objekt from input parameters for DmsStammsatzanlage Element ...");
        DmsMessage root = new DmsMessage();
        root.setDmsStammsatzanlage(new DmsMessage.DmsStammsatzanlage());
        root.getDmsStammsatzanlage().setDmsRequest(new TypeStammsatzanlageRequest());
        TypeStammsatzanlageRequest inputPars = root.getDmsStammsatzanlage().getDmsRequest();
        inputPars.setUsername(this.username);
        inputPars.setFirma(this.firma);
        inputPars.setFiliale(this.filiale);
        inputPars.setTeilenummer(this.teilenummer);
        inputPars.setMarke(TypeMarke.fromValue(this.marke));
        inputPars.setBezeichnung(this.bezeichnung);
        inputPars.setUPE(new BigDecimal(this.UPE).setScale(2, 4));
        inputPars.setSNP(new BigDecimal(this.SNP).setScale(2, 4));
        inputPars.setKodierungsstufe(this.kodierungsstufe);
        inputPars.setProduktklasse(this.produktklasse);
        inputPars.setTeileart(this.teileart);
        inputPars.setVVM(new BigInteger(String.valueOf(this.VVM)));
        inputPars.setLVM(new BigInteger(String.valueOf(this.LVM)));
        inputPars.setBVM(new BigInteger(String.valueOf(this.BVM)));
        inputPars.setHoherMWST(this.hoheMwst);
        this.XmlMessageRoot = root;
        Logger.getLogger(XmlDmsStammsatzanlage.class).debug("XML-Objekt constructed.");
    }
}

